' +------------------+---------------------------------+
' | NAME OF PROGRAM  | Blob Screen Saver               |
' | PROGRAMMED BY    | Jos Pedro Dias (zepedro@ip.pt) |
' | DATE OF CREATION | 1998/09/02                      |
' +------------------+---------------------------------+
' |                 PROGRAM DESCRIPTION                |
' +----------------------------------------------------+
' |   Blob Screen  Saver  generates  an image  made by |
' | some circles, which interact with each other.      |
' |   The reason of this name  for the program is that |
' | there's a commonly used form in 3d programs called |
' | exactly blob.  Blobs  are  made of  tridimentional |
' | spheres which  interact with each other  and which |
' | are great  to modelate  organic forms,  because of |
' | the smoothness of the forms it generates.          |
' |   The program  generates  a palette  based on  one |
' | color chosen  almost randomly  (almost  because it |
' | can't be dark), defines  randomly the position and |
' | radius of 10 circles  (this number can by changed: |
' | just  change  the   value  of  the  NumberOfBlobs% |
' | variable,  but remember: the speed  decreases when |
' | this number increases...)  and finally  calculates |
' | the influence  of every circle in  all pixels (the |
' | closest to  the center are  brighter;  when in the |
' | presence of  more than one  circle in  that pixel, |
' | both will  influence the pixel).  After the screen |
' | is drawn,  the  program changes  the  palette  (in |
' | pieces) until Escape is pressed.                   |
' |   I hope the understanding  of this program not to |
' | be hard, since it is well structured and the names |
' | of the  variables  are  self-explaining.  Besides, |
' | every block  of code has  a small  text describing |
' | it.                                                |
' |   A note for those who don't know: RGB is a way of |
' | describing  a color  (defining the  value of the 3 |
' | colors:  Red,  Green and Blue,  from which  we can |
' | get any color.                                     |
' +----------------------------------------------------+



'Start
RANDOMIZE TIMER
SCREEN 13
CLS



'Number of circles and allocation of the arrays in memory

NumberOfBlobs% = 10
DIM BaseColor(1 TO 3)
DIM Blob%(1 TO NumberOfBlobs%, 1 TO 3)



'Choice of the base color (with its 3 RGB components),
'from which the palette is going to be generated. This
'choice obeys to a condition: the average of the 3
'components (RGB) must be bigger than 0.5. Why? To avoid
'the chosen color to be too dark.

DO
  FOR i% = 1 TO 3
    BaseColor(i%) = RND
  NEXT
LOOP WHILE (BaseColor(1) + BaseColor(2) + BaseColor(3)) / 3 < .5



'Generates the palette (from black to the base color)

FOR i% = 0 TO 255
  i2 = i% / 4
  PALETTE i%, 65536 * INT(i2 * BaseColor(1)) + 256 * INT(i2 * BaseColor(2)) + INT(i2 * BaseColor(3))
NEXT



'Creation of the circles (x coordenate, y coordenate and radius)

FOR i% = 1 TO NumberOfBlobs%
  Blob%(i%, 1) = RND * 320
  Blob%(i%, 2) = RND * 200
  Blob%(i%, 3) = RND * 40 + 40
NEXT



'Drawing the screen...

FOR y% = 0 TO 199
  k$ = INKEY$
  FOR x% = 0 TO 319
    blobcolor% = 0
    FOR i% = 1 TO NumberOfBlobs%
      temp = SQR((Blob%(i%, 1) - x%) ^ 2 + (Blob%(i%, 2) - y%) ^ 2)
      IF temp < Blob%(i%, 3) THEN
        blobcolor% = blobcolor% + INT(80 - (temp / Blob%(i%, 3) * 80))
      END IF
    NEXT
    IF blobcolor% > 255 THEN blobcolor% = 255
    IF blobcolor% > 0 THEN PSET (x%, y%), blobcolor%
  NEXT
  IF k$ = CHR$(27) THEN GOTO finish
NEXT



'Procedures to do after the screen creation

DO
  k$ = INKEY$



  'Change of the base color

  FOR i% = 1 TO 3
    BaseColor(i%) = RND * .5 + .5
  NEXT



  'Changes 1/16 of the palette

  i3% = 16 * INT(RND * 16)
  FOR i% = i3% TO i3% + 15
    i2 = i% / 4
    PALETTE i%, 65536 * INT(i2 * BaseColor(1)) + 256 * INT(i2 * BaseColor(2)) + INT(i2 * BaseColor(3))
  NEXT
 
LOOP WHILE k$ <> CHR$(27)



'Finish

finish:
SCREEN 0
WIDTH 80, 25
CLS
COLOR 9: PRINT "Blob Screen Saver"
COLOR 1: PRINT "1998/09/02"
PRINT
COLOR 14: PRINT "Programmed by Jos Pedro Dias"
COLOR 12: PRINT "Homepage: http://members.xoom.com/Lucretia"
COLOR 4: PRINT "E-Mail: zepedro@ip.pt"
COLOR 7
PRINT
END

