DECLARE SUB showchar (chr1%, chr2%, start%)
DECLARE SUB showfont (num%, start%)
DECLARE SUB intro ()
DECLARE SUB waitkey ()
DEFINT A-Z
REM $INCLUDE: 'svgabc.bi'

vmode = VIDEOMODEGET
IF WHICHVGA = 0 THEN STOP
dummy = RES640
DIM SHARED demofont(4) AS STRING * 4098

' ------------------------------------------
' load fonts
' ------------------------------------------

FOR i = 0 TO 4
  fina$ = "testfon" + CHR$(i + 48) + ".fon"
  OPEN fina$ FOR BINARY AS #1
  GET #1, , demofont(i)
  fontset demofont(i): fontgetinfo x, y
  IF x < 1 OR x > 8 THEN CLOSE 1: STOP
  IF y < 1 OR y > 16 THEN CLOSE 1: STOP
  CLOSE #1
NEXT i


DO
intro

fontsystem
fontgetinfo x, y
row = 2: column = 3
text$ = "SYSTEMFONT: " + STR$(x) + " *" + STR$(y) + " PIXEL"
drwstring 1, 250, 28, text$, column * 8, row * 16
waitkey

' ------------------------------------------------------------------
' display single width/single height (8*16) , 1 character per letter
' ------------------------------------------------------------------
'
'               -----------------------------
' TESTFON0      |   chr$(x)   |      /      |
'               |-------------+-------------|
'     /         |      /      |      /      |
'               -----------------------------

CALL showfont(0, 22)
row = 4: old = 0
fontset demofont(0)
text$ = "FONTNAME: BOLD2 - SINGLE WIDTH/SINGLE HEIGHT (8 * 16)"
FOR i = 1 TO LEN(text$)
  ch$ = MID$(text$, i, 1)
  drwstring 1, 250, 28, ch$, (column + i - 1) * 8, row * 16
  CALL showchar(old, ASC(ch$), 22)
  old = ASC(ch$)
  t! = TIMER: DO: LOOP WHILE TIMER < t! + .3
NEXT i
CALL showchar(old, -1, 22)
waitkey

' --------------------------------------------------------------------
' display double width/single height (16*16) , 2 characters per letter
' --------------------------------------------------------------------
'
'               -----------------------------
' TESTFON4      |   chr$(x)   | chr$(x+128) |
'               |-------------+-------------|
'     /         |      /      |      /      |
'               -----------------------------

CALL showfont(4, 22)
row = 5: old = 0
fontset demofont(4)
text$ = "DOUBLE WIDTH/SINGLE HEIGHT (16 * 16)": display$ = ""
FOR i = 1 TO LEN(text$)
  x = ASC(MID$(text$, i, 1))
  display$ = display$ + CHR$(x) + CHR$(x + 128)
NEXT i
FOR i = 1 TO LEN(display$)
  ch$ = MID$(display$, i, 1)
  drwstring 1, 250, 28, ch$, (column + i - 1) * 8, row * 16
  CALL showchar(old, ASC(ch$), 22)
  old = ASC(ch$)
  t! = TIMER: DO: LOOP WHILE TIMER < t! + .3
NEXT i
CALL showchar(old, -1, 22)
waitkey

' -------------------------------------------------------------------
' display single width/double height (8*32) , 2 characters per letter
' -------------------------------------------------------------------
'
'               -----------------------------
' TESTFON3      |   chr$(x)   |      /      |
'               |-------------+-------------|
' TESTFON3      | chr$(x+128) |      /      |
'               -----------------------------

CALL showfont(3, 22)
row = 6: old = 0
fontset demofont(3)
text$ = "SINGLE WIDTH/DOUBLE HEIGHT (8 * 32)": display$ = ""
FOR i = 1 TO LEN(text$)
  x = ASC(MID$(text$, i, 1))
  display$ = display$ + CHR$(x + 128)
NEXT i
FOR i = 1 TO LEN(text$)
  ch$ = MID$(text$, i, 1)
  drwstring 1, 250, 28, ch$, (column + i - 1) * 8, row * 16
  CALL showchar(old, ASC(ch$), 22)
  old = ASC(ch$)
  t! = TIMER: DO: LOOP WHILE TIMER < t! + .3
  ch$ = MID$(display$, i, 1)
  drwstring 1, 250, 28, ch$, (column + i - 1) * 8, (row + 1) * 16
  CALL showchar(old, ASC(ch$), 22)
  old = ASC(ch$)
  t! = TIMER: DO: LOOP WHILE TIMER < t! + .3
NEXT i
CALL showchar(old, -1, 22)
waitkey

' --------------------------------------------------------------------
' display double width/double height (16*32) , 4 characters per letter
' --------------------------------------------------------------------
'
'               -----------------------------
' TESTFON1      |   chr$(x)   | chr$(x+128) |
'               |-------------+-------------|
' TESTFON2      |   chr$(x)   | chr$(x+128) |
'               -----------------------------

CALL showfont(1, 16)
CALL showfont(2, 22)
row = 8: old = 0
text$ = "DOUBLE WIDTH/DOUBLE HEIGHT (16 * 32)": display$ = ""
FOR i = 1 TO LEN(text$)
  x = ASC(MID$(text$, i, 1))
  display$ = display$ + CHR$(x) + CHR$(x + 128)
NEXT i
FOR i = 1 TO LEN(display$)
  fontset demofont(1)
  ch$ = MID$(display$, i, 1)
  drwstring 1, 250, 28, ch$, (column + i - 1) * 8, row * 16
  CALL showchar(old, ASC(ch$), 16)
  t! = TIMER: DO: LOOP WHILE TIMER < t! + .3
  fontset demofont(2)
  drwstring 1, 250, 28, ch$, (column + i - 1) * 8, (row + 1) * 16
  CALL showchar(old, ASC(ch$), 22)
  old = ASC(ch$)
  t! = TIMER: DO: LOOP WHILE TIMER < t! + .3
NEXT i
CALL showchar(old, -1, 16)
CALL showchar(old, -1, 22)



fontsystem
drwstring 1, 250, 28, "QUIT PROGRAM ? (Y/N)", 55 * 8, 2 * 16
DO: quit$ = INKEY$: LOOP WHILE quit$ = ""
quit$ = UCASE$(quit$)

LOOP UNTIL quit$ = "Y"

VIDEOMODESET vmode
END

SUB intro
FILLSCREEN 28
FOR i = 16 TO 31
DRWBOX 1, i, 0 + i - 16, 0 + i - 16, 639 - i + 16, 479 - i + 16
NEXT
fontsystem
a$ = "Font-Generator Demo   (C) 1998 D.Caspary"
b$ = SPACE$(INT((76 - LEN(a$)) / 2))
drwstring 1, 28, 216, b$ + a$ + b$, 16, 448
DRWLINE 1, 25, 16, 444, 623, 444
DRWLINE 1, 30, 16, 445, 623, 445
END SUB

SUB showchar (chr1, chr2, start)

x = INT(chr1 / 64): y = chr1 MOD 64
drwstring 1, 250, 28, CHR$(chr1), (8 + y) * 8, (start + 1 + x) * 16

IF chr2 >= 0 THEN
  x = INT(chr2 / 64): y = chr2 MOD 64
  drwstring 1, 40, 28, CHR$(chr2), (8 + y) * 8, (start + 1 + x) * 16
END IF

END SUB

SUB showfont (num, start)
fontsystem
drwstring 1, 250, 28, "Name: TESTFON" + CHR$(num + 48), 8 * 8, start * 16
fontset demofont(num)
FOR i = 0 TO 255 STEP 64: FOR j = 0 TO 63
drwstring 1, 250, 28, CHR$(i + j), (8 + j) * 8, (start + 1 + i / 64) * 16
NEXT j, i
END SUB

SUB waitkey
t! = TIMER: x = 9
fontsystem
DO
drwstring 1, 250, 28, "press any key ... (" + CHR$(x + 48) + ")", 55 * 8, 2 * 16
IF TIMER >= t! + 1 THEN t! = TIMER: x = x - 1
LOOP WHILE INKEY$ = "" AND x > 0
drwstring 1, 250, 28, "                     ", 55 * 8, 2 * 16
END SUB

