'
'  This subroutine initializes COM port PORT (1, 2, 3, or 4) for
' communication at transmission rate BAUD (1200 or less), data bits DBITS
' (5 - 8), parity PAR$ = "E" (even), "O" (odd), or "N" (none), and stop
' bits SBITS (1 or 2).  All parameters but PAR$ are of INTEGER type.  (Do
' not use COMREAD$ or COMPRINT with a PORT parameter before using COMOPEN
' to initialize that port.)
'
'  These routines require the ASM code in QBUTIL.INC.
'
SUB COMOPEN(PORT AS INTEGER,BAUD AS INTEGER,DBITS AS INTEGER,PAR$,SBITS AS INTEGER)
DIM OS AS INTEGER,S AS STRING*1
'
'  Bios thinks port numbers are zero-based.  Make that conversion and
' constrain port number to valid values.
'
PT=PORT-1 : IF PT<0 THEN PT=0
IF PT>3 THEN PT=3
'
'  Define port in machine code routine.
'
DEF SEG=VARSEG(MCODE(1))
OS=VARPTR(MCODE(1))
POKE OS+10,PT : POKE OS+11,0
'
'  Stop bits are also zero-based at bios level.  Constrain to valid range
' and convert to string representing binary number.
'
SL=SBITS-1 : IF SL<0 THEN SL=0
IF SL>1 THEN SL=1
S=LTRIM$(RTRIM$(STR$(SL)))
'
'  Constrain baud rate to valid value.  (Default is 600 baud.)
'
BD=BAUD
IF BD<>110 AND BD<>150 AND BD<>300 AND BD<>1200 THEN BD=600
'
'  Convert initialization parameters to binary string.
'
INTSTR$=""
IF BD=150 THEN INTSTR$="001"
IF BD=300 THEN INTSTR$="010"
IF BD=600 THEN INTSTR$="011"
IF BD=1200 THEN INTSTR$="100"
P$=MID$(LTRIM$(RTRIM$(UCASE$(PAR$))),1,1)
IF P$="N" THEN INTSTR$=INTSTR$+"10"
IF P$="E" THEN INTSTR$=INTSTR$+"11"
IF P$="O" THEN INTSTR$=INTSTR$+"01"
INTSTR$=INTSTR$+S
IF DBITS<6 THEN INTSTR$=INTSTR$+"00"
IF DBITS=6 THEN INTSTR$=INTSTR$+"01"
IF DBITS=7 THEN INTSTR$=INTSTR$+"10"
IF DBITS>7 THEN INTSTR$=INTSTR$+"11"
'
'  Convert binary initialization string to decimal value.
'
INIT=0
FOR I=1 TO 8
INIT=INIT+2^(8-I)*VAL(MID$(INTSTR$,I,1))
NEXT I
'
'  Finish machine code set up and call it.
'
POKE OS+1,INIT : POKE OS+2,0 : POKE OS+16,&H14
CALL ABSOLUTE(OS)
DEF SEG
END SUB
'
'  This function returns directly the character STRING read from COM port
' PORT (1, 2, 3, or 4).  N is the number of characters in the string to
' input from the port and return to the calling routine and TERMCHR is the
' ascii code for a termination character.  This latter parameter is not
' used if N is positive.  If N is zero or negative, rather than input a
' specific number of N characters, COMREAD$ simply returns a string
' containing all characters input from the COM port up until a character
' with ascii code TERMCHR is input.  (TERMCHR is not included in the
' returned string.  All parameters are of INTEGER type.)
'
FUNCTION COMREAD$(PORT AS INTEGER,N AS INTEGER,TERMCHR AS INTEGER)
DIM OS AS INTEGER,AX AS INTEGER,BX AS INTEGER,CX AS INTEGER,DX AS INTEGER
'
'  Define port, bios function number, and interrupt in machine code
' routine.
'
PT=PORT-1 : IF PT<0 THEN PT=0
IF PT>3 THEN PT=3
DEF SEG=VARSEG(MCODE(1))
OS=VARPTR(MCODE(1))
POKE OS+10,PT : POKE OS+11,0 : POKE OS+16,&H14
POKE OS+2,2
'
'  Input data from COM port.
'
STRNG$=""
IF N>0 THEN
'
'  Number of characters to input is predefined.
'
FOR I=1 TO N
CALL ABSOLUTE(AX,BX,CX,DX,OS)
STRNG$=STRNG$+CHR$(AX AND &HFF)
NEXT I
ELSE
'
'  Number of characters to input is determined by input of TERMCHR.
'
C=-1
WHILE C<>TERMCHR
CALL ABSOLUTE(AX,BX,CX,DX,OS)
'
'  Character read is in subregister AL.
'
C=AX AND &HFF
IF C<>TERMCHR THEN STRNG$=STRNG$+CHR$(C)
WEND
END IF
DEF SEG
COMREAD$=STRNG$
END FUNCTION
'
'  This subroutine sends character STRING STRNG$ out COM port PORT (1, 2,
' 3, or 4--an INTEGER variable).  If STRNG$ is terminated with a ";",
' carriage return and line feed characters are not sent out the port after
' STRNG$; otherwise, they are.
'
SUB COMPRINT(PORT AS INTEGER,STRNG$)
DIM OS AS INTEGER
'
'  Define port, bios function number, and interrupt in machine code
' routine.
'
PT=PORT-1 : IF PT<0 THEN PT=0
IF PT>3 THEN PT=3
DEF SEG=VARSEG(MCODE(1))
OS=VARPTR(MCODE(1))
POKE OS+10,PT : POKE OS+11,0 : POKE OS+2,1 : POKE OS+16,&H14
'
'  Send character string out COM port one character at a time.  Process
' last character separately in case it is ";".
'
L=LEN(STRNG$)-1
IF L>0 THEN
FOR I=1 TO L
C=ASC(MID$(STRNG$,I,1))
POKE OS+1,C
CALL ABSOLUTE(OS)
NEXT I
END IF
RT=ASC(RIGHT$(STRNG$,1))
IF RT<>59 THEN
POKE OS+1,RT
CALL ABSOLUTE(OS)
POKE OS+1,13
CALL ABSOLUTE(OS)
POKE OS+1,10
CALL ABSOLUTE(OS)
END IF
DEF SEG
END SUB
