'
'  This subroutine inputs attribute ATTRIB and returns the red, green,
' and blue color values that are currently assigned to ATTRIB via the
' color palette.  At least, that's what it does for QB modes 11 and above
' since they support the 256K-color RGB palette.  The RGB data can be
' converted to the actual assigned color via
'
'  PALCOL = RED + 256& * GREEN + 65536& * BLUE.
'
'  For lesser screen modes, the palette color itself is returned via the
' RED parameter.  All parameters passed to/from the routine are of INTEGER
' type.
'
'  The subroutine uses various functions and subfunctions of interrupt 10,
' accessed via ASM code in QBUTIL.INC.
'
SUB PALREAD(ATTRIB AS INTEGER,RED AS INTEGER,GREEN AS INTEGER,BLUE AS INTEGER)
DIM CX AS INTEGER,DX AS INTEGER,OS AS INTEGER,BX AS INTEGER,AX AS INTEGER
DIM MODE AS INTEGER,CATTR AS INTEGER,PATTR AS INTEGER
DEF SEG=VARSEG(MCODE(1))
OS=VARPTR(MCODE(1))
'
'  First, get video mode.  (It determines how palette is interpreted.)
'
POKE OS+2,&HF : POKE OS+16,&H10
CALL ABSOLUTE(AX,BX,CX,DX,OS)
MODE=AX AND &HFF
'
'  If MODE > 13h, need to perform brute force experiment to find out many
' colors it has.
'
NCOL=16
IF MODE>&H10 AND MODE<=&H13 THEN NCOL=256
IF MODE>&H13 THEN
'
'  It's an SVGA mode.  Write pixel to (0,0) and character to bios row 0 /
' column 0, each of attribute 255.  Then read attribute.  If either
' attribute that's read is 255, it must be a 256-color mode.  Otherwise,
' assume it's a 16-color mode.  (The reason for using both a graphics
' pixel and a text character is because there's no expeditious way to
' to know whether it's a graphics or text mode.  Also, just use video
' page 0.)
'
'  Set position for text character ("A") and write it.
'
POKE OS+2,2 : POKE OS+5,0 : POKE OS+10,0 : POKE OS+11,0
CALL ABSOLUTE(OS)
POKE OS+1,65 : POKE OS+2,9 : POKE OS+4,255 : POKE OS+7,1
POKE OS+8,0
CALL ABSOLUTE(OS)
'
'  Read attribute of character just written.
'
POKE OS+2,8
CALL ABSOLUTE(AX,BX,CX,DX,OS)
CATTR=(AX AND &HFF00)/256
'
'  Do same thing for graphics pixel.  (It's slightly simpler because
' pixel-write function also defines plot position.)
'
POKE OS+1,&HFF : POKE OS+2,&HC : POKE OS+7,0
CALL ABSOLUTE(OS)
POKE OS+2,&HD
CALL ABSOLUTE(AX,BX,CX,DX,OS)
PATTR=AX AND &HFF
IF PATTR=255 OR CATTR=255 THEN NCOL=256
END IF
POKE OS+2,&H10
IF NCOL=16 THEN
'
'  16-COLOR (OR LESS) MODE
'
'  Just get color value.
'
POKE OS+4,ATTRIB : POKE OS+1,7
CALL ABSOLUTE(AX,BX,CX,DX,OS)
'
'  Palette color is in BH.  Return it as RED in parameter list.
'
RED=(BX AND &HFF00)/256
ELSE
'
'  256-COLOR MODE
'
'  Get RGB data.
'
POKE OS+1,&H15 : POKE OS+4,ATTRIB : POKE OS+5,0
CALL ABSOLUTE(AX,BX,CX,DX,OS)
'
'  Red is in DH, green is in CH, and blue is in CL.
'
RED=(DX AND &HFF00)/256
GREEN=(CX AND &HFF00)/256
BLUE=CX AND &HFF
END IF
DEF SEG
END SUB
