'
'  This function returns a string containing the text on the current
' screen line.  It requires the machine code in QBUTIL.INC.
'
FUNCTION READSCRN$
DIM OS AS INTEGER,AX AS INTEGER,BX AS INTEGER,DX AS INTEGER,MAXROW AS INTEGER
DIM MAXCOL AS INTEGER,CHRCT AS INTEGER,PAGE AS INTEGER,ROW AS INTEGER
DIM COL AS INTEGER,CX AS INTEGER
'
'  Get maximum number of lines.
'
DEF SEG=0
MAXROW=PEEK(&H484)
'
'  Get maximum number of columns and video page.
'
DEF SEG=VARSEG(MCODE(1))
OS=VARPTR(MCODE(1))
'
'  Set up machine code.
'
POKE OS+16,&H10 : POKE OS+2,&HF
CALL ABSOLUTE(AX,BX,CX,DX,OS)
PAGE=(BX AND &HFF00)/256
MAXCOL=(AX AND &HFF00)/256-1
'
'  Get row cursor is on.
'
POKE OS+2,3 : POKE OS+5,PAGE
CALL ABSOLUTE(AX,BX,CX,DX,OS)
ROW=(DX AND &HFF00)/256
'
'  Create string containing concatenation of all characters on that line
' up to (but not including) ascii 13 or 10.
'
POKE OS+11,ROW
STRNG$=""
FOR COL=0 TO MAXCOL
POKE OS+2,2 : POKE OS+10,COL
CALL ABSOLUTE(OS)
POKE OS+2,8
CALL ABSOLUTE(AX,BX,CX,DX,OS)
CHRCT=AX AND &HFF
IF CHRCT=13 OR CHRCT=10 THEN EXIT FOR
STRNG$=STRNG$+CHR$(CHRCT)
NEXT COL
'
'  Before returning STRNG$, position cursor at beginning of next line
' UP the screen.  If this would be off the screen, position it at the last
' line on the screen.
'
ROW=ROW-1 : IF ROW<0 THEN ROW=MAXROW
POKE OS+2,2 : POKE OS+10,0 : POKE OS+11,ROW
CALL ABSOLUTE(OS)
DEF SEG
'
'  Get rid of trailling spaces before returning STRNG$.
'
READSCRN$=RTRIM$(STRNG$)
END FUNCTION
