'***************************************************************************
' ASCIANSI.BAS = Umwandlung einer ASCII- in eine ANSI-Textdatei, V2.0
' ============
' Dieses Q(uick)Basic-Programm wandelt alle im Verzeichnis C:\TMP\ vorge-
' fundenen DOS-ASCII-Textdateien ins Windows-ANSI-Format um und hinterlegt
' die resultierenden ANSI-Dateien im Unterverzeichnis C:\TMP\ANSI\.
'
' Die umzuwandelnden ASCII-Dateien muessen die Dateierweiterung ".TXT"
' besitzen. Die ANSI-Ergebnisdateien erhalten dieselben Namen wie die
' jeweiligen ASCII-Dateien. Die ASCII-Dateien bleiben unveraendert.
'
' Die maximale Dateigroesse betraegt 2 GB !
'
' Die ASCII- und ANSI-Codes 0 bis 127 stellen dieselben Zeichen dar. Eine
' Konvertierung ist also nur fuer die Codes 128 bis 255 erforderlich. Das
' sind die Zeichencodes fuer die Umlaute, landesspezifischen Zeichen und
' "Kastensymbole". Diese Zeichen werden in der ASII-Datei gemaess der
' unten mit DATA angegebenen Umwandlungstabelle ersetzt. Alle Kastensymbole
' mit einer und zwei Linien werden durch "-" und "+" ersetzt.
'
' Als ANSI-Code wird der in ISO 8859-1 spezifizierte Zeichensatz "Latin 1 /
' Westlich" vorausgesetzt.
'
' Beim ASCII-Code wird die MS-DOS-Codeseite 437 ("Englisch") zugrundegelegt,
' die auf deutschsprachigen PCs mit MS-DOS bis 6.22 und Windows 3.1
' vorkonfiguriert ist.
'
' Windows ab der Version 95 verwendet stattdessen die etwas abweichende
' Codeseite 850 ("Mehrsprachig/Lateinisch") mit weniger Kastensymbolen und
' mehr landesspezifischen Zeichen. Trotzdem sollte das Programm mit fast
' allen deutschsprachigen ASCII-Texten funktionieren. Das Programm laesst
' sich leicht fuer die Codeseite 850 modifizieren: Es muss dazu lediglich
' die DATA-Tabelle leicht angepasst werden. Auch eine ANSI-ASCII-Wandlung
' laesst sich durch eine entsprechende Belegung der DATA-Tabelle
' bewerkstelligen.
'
' (c) Thomas Antoni, 28.1.2004 - 1.10.2008
'***************************************************************************
DECLARE SUB DIRlist ()           '.TXT-Textdateien im Verzeichnis
                                 '"c:\tmp\" suchen und deren Namen in
                                 '"c:\tmp\dirtxt.tmp" hinterlegen
DIM t AS STRING * 1             'Zwischenspeicher fuer genau ein Text-Byte
'
'---- Code-Umwandlungstabelle einlesen -------------------------------------
DIM tabelle(128) AS INTEGER
FOR i% = 0 TO 127               'ANSI Codes fuer die ASCII-Zeichen 128-255
  READ tabelle(i%)
NEXT
'

DO
'---- rot-weissen Bildschirm mit Titelzeile und Kurzanleitung anzeigen -----
COLOR 0, 7: CLS                 'Bildschirm weiss einfaerben
COLOR 15, 4                     'Titelzeile weiss auf rot
PRINT "          ASCIANSI V2.0 -  ASCII-ANSI-Konverter (c) Thomas Antoni  2009         ";
'
FOR zeile% = 2 TO 24            'rote Seitenbalken malen
  LOCATE zeile%, 1: PRINT " ";
  LOCATE zeile%, 80: PRINT " ";
NEXT zeile%
'
LOCATE 25, 1: PRINT SPC(79); " "; 'Fusszeile rot malen
'
COLOR 0, 7                        'Schwarz auf Weiss
'
LOCATE 4, 21: PRINT "           "
LOCATE 5, 21: PRINT "                  "
LOCATE 6, 21: PRINT "                          "
LOCATE 7, 21: PRINT "                   "
'
LOCATE 9, 4
PRINT " Dieses Programm konvertiert alle im Verzeichnis C:\TMP\ vorgefundenen"
LOCATE 10, 4
PRINT " DOS-ASCII-Textdateien *.TXT ins Windows-ANSI-Format und hinterlegt sie"
LOCATE 11, 4
PRINT " dort ins Unterverzeichnis ANSI\ ."
'
'
'~~~~~~~~~~~~ Alter Dateiauswahl-Dialog zur Auswahl EINER beliebigen ~~~~~~~
'~~~~~~~~~~~~ Textdatei (CHDIR funktioniert nicht unter Win NT/XP) ~~~~~~~~~
'INPUT " Gib das Laufwerk d.ASCII-Datei ein; Beispiel: C ......... "; lw$
'INPUT " Gib den Pfad der ASCII-Datei ein;   Beispiel: TEMP ...... "; Pfad$
'INPUT " Gib den Namen d. ASCII-Datei ein;   Beispiel: TEST.TXT .. "; datei$
'IF Pfad$ <> "" THEN Pfad$ = Pfad$ + "\" 'kein doppelter Backslash bei
                                         'fehlendem Pfad (Stammverzeichnis)
'PRINT
'PRINT " Soll die Datei ";
'COLOR 15, 9                             'weiss auf blau
'PRINT " "; lw$; ":\"; Pfad$; datei$; " ";
'COLOR 0, 15
'PRINT " nach ANSI konvertiert und ueberschrieben werden?"
'PRINT
'PRINT " ....OK mit beliebiger Taste  ....Abbruch mit Esc"
'taste$ = INPUT$(1)                 'Eine Taste von der Tastatur einlesen
'IF taste$ = CHR$(27) THEN END      'Programm beenden mit Esc-Taste
'PRINT
'SHELL lw$ + ":"                    'ins angegebene Laufwerk wechseln
'CHDIR "\" + Pfad$                  'ins angegebene Verzeichnis wechseln
'OPEN datei$ FOR BINARY AS #1       'ASCII-Quelldatei oeffnen
'
'OPEN "xxx.tmp" FOR BINARY AS #2    'Temporaere Datei
'~~~~~~~~~~~~~~~~~~ Ende alter Dateiauswahl-Dialog ~~~~~~~~~~~~~~~~~~~~~~~~
'
'
'---- Namen der Textdateien C:\TMP\*.TXT einlesen in C:\TMP\dirtxt.tmp ----
CALL DIRlist
'
'---- Namen der aktuellen ASCII-Text-Datei einlesen------------------------
AnzahlDateien% = 0
SHELL "MD c:\tmp\ANSI"    'Verzeichnis zum Hinterlegen der resultierenden
                          'ANSI-Dateien erstellen. diese Anweisung verursacht
                          'die DOS - Fehleranzeige "Erweiterter Fehler 183",
                          'wenn das Verzeichnis ANSI\ bereits vorhanden ist
COLOR , 4: LOCATE 12, 1: PRINT " "; 'roten Rand restaurieren
COLOR , 7: PRINT SPC(30);          'Fehlermeldung 183 in d.Anzeige loeschen
OPEN "c:\tmp\dirtxt.tmp" FOR INPUT AS #3
DO UNTIL EOF(3)                    'Schleife ueber alle Textdateien
  LINE INPUT #3, Datei$            'Textzeile mit Textdatei-Namen einlesen
  AnzahlDateien% = AnzahlDateien% + 1
  LOCATE 14, 5: PRINT "Bearbeitete Datei   : "
  LOCATE 14, 29: PRINT SPC(12); 'alte Dateinamensanzeige loeschen
  LOCATE 14, 29: PRINT Datei$
  LOCATE 16, 5: PRINT "Umgewandelte Zeichen: "

  LOCATE 16, 28: PRINT SPC(10); 'alte Zeichenzahl-Anzeige loeschen
'
'---- aktuelle ASCII-Textdatei und ANSI-Ergebnisdatei oeffnen --------------
  OPEN "C:\tmp\" + Datei$ FOR BINARY AS #1
  OPEN "C:\tmp\ANSI\" + Datei$ FOR BINARY AS #2
'
'---- Alle Textzeichen in ANSI-Code wandeln --------------------------------
  anz& = 0
  DO UNTIL LOC(1) = LOF(1)        'Schleife ueber alle Bytes der Quelldatei
    GET #1, , t                   'ein ASCII-Zeichen aus Quelldatei lesen
    c% = ASC(t)                   'ASCII-Code als Zahl
    IF c% > 127 THEN              'Codes ueber 127 muessen konvertiert werden
      t = CHR$(tabelle(c% - 128)) 'zugehoeriges ANSI-Zeichen ermitteln
    END IF
    PUT #2, , t                   'ANSI-Zeichen in Temp-Datei schreiben
    anz& = anz& + 1
    LOCATE 16, 28: PRINT anz&     'Anzahl der gewandelten Zeichen anzeigen
  LOOP
CLOSE #2
CLOSE #1
LOOP
CLOSE #3
KILL "c:\tmp\dirtxt.tmp"
BEEP
LOCATE 18, 5
PRINT "Fertig!"; AnzahlDateien%; "Datei(en) konvertiert und in ";
PRINT "C:\TMP\ANSI\ hinterlegt"
'
'---- Wiederholen/Beenden-Dialog -------------------------------------------
LOCATE 22, 5
COLOR 15, 1                                  'weiss auf blau
PRINT "      [beliebige Taste]...Beenden     [Eing]...Neue Konvertierung      "
DO: taste$ = INKEY$: LOOP UNTIL taste$ <> "" 'Warten auf belieb. Tastendruck
IF taste$ <> CHR$(13) THEN
  CLS
  END
END IF
LOOP
'
'---- Code-Umwandlungstabelle ASCII-ANSI (Codes 128 bis 255) ---------------
'An jedem der ASCII-Code-Plaetze 128...255 ist der dafuer
'einzusetzende ANSI-Code angegeben. Zeichen, fuer die es bei ANSI keine
'Entsprechung gibt, werden durch ein Leerzeichen ersetzt (CHR$(032)).
DATA                                         199, 252: 'ASCII-Codes 128-129
DATA 233, 226, 228, 224, 229, 231, 234, 235, 232, 239: 'ASCII-Codes 130-139
DATA 238, 236, 196, 197, 201, 230, 198, 244, 246, 249: 'ASCII-Codes 140-149
DATA 255, 249, 255, 214, 220, 162, 163, 165, 032, 131: 'ASCII-Codes 150-159
DATA 225, 237, 243, 250, 241, 209, 032, 032, 191, 043: 'ASCII-Codes 160-169
DATA 172, 189, 188, 161, 171, 187, 124, 124, 124, 124: 'ASCII-Codes 170-179
DATA 043, 043, 043, 043, 043, 043, 124, 043, 043, 043: 'ASCII-Codes 180-189
DATA 043, 043, 043, 043, 043, 043, 045, 043, 043, 043: 'ASCII-Codes 190-199
'
DATA 043, 043, 043, 043, 043, 045, 043, 043, 043, 043: 'ASCII-Codes 200-209
DATA 043, 043, 043, 043, 043, 043, 043, 043, 043, 124: 'ASCII-Codes 210-219
DATA 043, 124, 124, 043, 170, 223, 032, 182, 202, 243: 'ASCII-Codes 220-229
DATA 181, 134, 164, 056, 254, 240, 156, 248, 202, 110: 'ASCII-Codes 230-239
DATA 061, 177, 032, 032, 131, 131, 247, 126, 176, 183: 'ASCII-Codes 240-249
DATA 173, 086, 179, 178, 124, 255                    : 'ASCII-Codes 250-255


'
'
SUB DIRlist
'****************************************************************************
' DIRlist = Textdateien im Verzeichnis "c:\tmp\" suchen und deren Namen
' =======   in der Datei "c:\tmp\dirtxt.tmp" hinterlegen
'
' Diese Q(uick)Basic-Subroutine ermittelt die Namen aller im Verzeichnis
' "c:\tmp\" vorhandenen Textdateien, die die Dateierweiterung "TXT" besitzen.
' Alle ermittelten Dateinamen werden in der Datei "c:\tmp\dirtxt.tmp"
' hinterlegt - je Dateinamen eine Zeile.
'
' Hierzu erzeugt die Subroutine zunaechst ein Dateiverzeichnis mit Hilfe des
' DOS-Kommandos "DIR". Dann durchsucht sie dieses Dateiverzeichnis nach
' entsprechenden Dateinamen. Vor und hinter dem Dateinamen muss sich ein
' Leerzeichen oder ein Zeilenvorschub befinden.
'
' Die vom DIR-Kommando erzeugte Dateiliste sieht leider unter DOS und
' unter den verschiedenen Windows-Versionen jeweils vollkommen
' unterschiedlich aus. Die Subroutine DIRlist beherrscht bezueglich der
' Dateinamen sowohl die verschiedenen Windows-Formate als auch das
' QBasic/DOS-Format des DIR-Befehls. Bei der Windows-Variante steht ein
' Punkt vor der Dateierweiterung, bei der DOS-Variante ein Leerzeichen.
' Bei Dateinamen, die die 8+3 Laenge nicht ausnutzen, werden ausserdem
' beim DOS-Format vom DIR-Befehl entsprechende Blanks eingefuegt, die
' ausgeblendet werden muessen.
'
'    Beispiele: Windows-Variante |  DOS-Variante
'               -----------------+-----------------
'               abc.txt          |  abc      txt
'               abcdefgh.txt     |  abcdefgh txt
'               Barcelona.txt    |  BARCEL~1 TXT  <= Langer Dateiname!
'
' Wenn eine TXT-Datei einen langen Dateinamen hat, der nicht den 8+3-DOS-
' Konventionen entspricht, dann wird sie in der erzeugten Dateiliste
' dirtxt.tmp mit ihrem abgekuerzten 8+3-Namen angegeben.
' "Barcelona_Reise.txt" wird z.B. aufgelistet als "Barcel~1.txt".

' Das aufrufende Programm ist dafuer verantwortlich, die erzeugte
' Datei "c:\tmp\dirtxt.tmp", die die Dateiliste beinhaltet, nach der
' Auswertung wieder zu loeschen.
'
' (c)Thomas Antoni - www.qbasic.de - 25.1.2008 - 25.9.2009
'****************************************************************************
SHELL "dir c:\tmp > c:\tmp\dirlist.tmp" 'Dateiliste erzeugen und in die Datei
                                        '"c:\tmp\dirlist.tmp" umleiten
OPEN "c:\tmp\dirlist.tmp" FOR INPUT AS #1
OPEN "c:\tmp\dirtxt.tmp" FOR OUTPUT AS #2
DO UNTIL EOF(1)           'Schleife ueber alle Textzeilen
  LINE INPUT #1, t$       'Textzeile einlesen
  tlen% = LEN(t$)         'Laenge der Textzeile
  anfang% = 1             'Anfangsposition f.Suche vorbesetzen auf 1.Zeichen
  gefunden% = 1           'Vorbesetzung: "Textdatei in aktueller Zeile
                          'gefunden"
'
'********* Textzeile nach d.Suchstring ".txt" bzw. " txt" durchsuchen ********
  DOSvariante% = 1        'Vorbesetzung: Dateiname ist in der DOS-Varian-
                          'te mit Blank statt Punkt angegeben
  TXTpos% = INSTR(anfang%, LCASE$(t$), " txt")
                          'nach " txt" bzw. " TXT" (mit Blank) suchen
                          '(DOS-Variante)
  IF TXTpos% = 0 THEN
    TXTpos% = INSTR(anfang%, LCASE$(t$), ".txt")
                          'nach ".txt" bzw. ".TXT" suchen (Windows-Variante)
    IF TXTpos% = 0 THEN
      gefunden% = 0       'weder " txt" noch ".txt" gefunden ->
                          'keine Textdatei in aktueller Zeile
    ELSE
      DOSvariante% = 0    'Merker "Der Dateiname ist in d. Windows-Variante mit
                          'Punkt statt Blank angegeben"
    END IF
  END IF
  IF gefunden% = 1 THEN   'Gefundene TXT-Datei weiterbearbeiten
'
'***** Dateiname rechts m.Zeilenvorschub od. Leerzeich.korrekt abgeschlossen?
    IF (TXTpos% + 3 >= tlen%) OR (MID$(t$, TXTpos% + 4, 1) = " ") THEN
      TXTrechtsOK% = 1      'Dateiname rechts korrekt abgeschlossen
    ELSE
      TXTrechtsOK% = 0      'Dateiname rechts nicht korrekt abgeschlosen
    END IF
'
'****** Dateiname links m.Zeilenvorschub od. Leerzeich.korrekt abgeschlossen?
    FOR i% = TXTpos% - 1 TO TXTpos% - 8 STEP -1
                                            '8 Zeichen vor ".txt" durchsuchen
      IF i% = 1 THEN                        'Zeilenvorschub
        TXTlinksOK% = 1
        EXIT FOR
      ELSEIF MID$(t$, i% - 1, 1) = " " THEN 'Leerzeichen
        TXTlinksOK% = 1
        EXIT FOR
      ELSE                                  'nicht korrekt abgeschlossen
        TXTlinksOK% = 0
      END IF
    NEXT
'
'****** gefundenen Dateinamen extrahieren und anzeigen wenn korrektes Format
    IF TXTlinksOK% = 1 AND TXTrechtsOK% = 1 THEN
                                     'TXT-Datei gefunden u.korrektes Format?
      IF DOSvariante% = 0 THEN       'Windows-Variante
        DateiName$ = MID$(t$, i%, TXTpos% - i% + 4)

      ELSE          'DOS-Variante des Dateinamens mit festem 8+3-Format (mit
                    'Leerzeichen aufgefuellt und mit Leerzeichen statt Punkt)
        DateiName$ = MID$(t$, TXTpos% - 8, 12)
       '
       '----- alle Leerzeichen im 8+3-String loeschen
       t1$ = ""                        'Zwischenpuffer vorbesetzen
       FOR n% = 1 TO LEN(DateiName$)   'Schleife ueber alle Textzeichen
         zeichen$ = MID$(DateiName$, n%, 1)           'Zeichen isolieren
         IF zeichen$ <> " " THEN t1$ = t1$ + zeichen$ 'Leerzeich.ausblenden
       NEXT
       '
       '----- Punkt einfuegen
       DateiName$ = LEFT$(t1$, LEN(t1$) - 3) + ".TXT"
     END IF
     PRINT #2, DateiName$
  END IF
END IF
LOOP
'
CLOSE #1, #2
KILL "c:\tmp\dirlist.tmp"
END SUB

