'***************************************************************************
' CLOCKBIG.BAS = Digitaluhr mit riesengrossen Ziffern
' ============
' Dieses QBasic-Programm zeigt die Uhrzeit auf einer riesigen, Bild-
' schirm-fuellenden Digitalanzeige mit 10x14 Punkt-Matrix-Ziffern an.
'
' (c) Thomas Antoni, 21.2.2005  --  www.qbasic.de
'***************************************************************************
'
'************ Dot-Matrix-Codes in Feld Z$ einlesen *************************
DIM Z$(10, 13)                 'Feld fur die je 14 Anzeige-Zeilen der
                               'Ziffern 0...9 und des Doppelpunktes
FOR Ziffer% = 0 TO 10
  FOR Zeile% = 0 TO 13         'Fuer alle 13 Ziffern die 14...
     READ Z$(Ziffer%, Zeile%)  'Anzeigezeilen ins Feld einlesen
  NEXT
NEXT
'
'************ Rahmen und Bedienhinweise anzeigen ***************************
COLOR 1, 7                     'Blau auf Hellgrau
CLS
'****** roten Kasten malen
COLOR 4, 7                     'rote Schrift auf Hellgrau
LOCATE 1, 1: PRINT STRING$(80, CHR$(219));
FOR Zeile% = 2 TO 24
  LOCATE Zeile%, 1: PRINT CHR$(219);
  LOCATE Zeile%, 80: PRINT CHR$(219);
NEXT
LOCATE 25, 1: PRINT STRING$(80, CHR$(219));
'
'****** Bedienhinweise
COLOR 15, 4                     'weisse Schrift auf rot
LOCATE 1, 4
PRINT " ClockBig              (c) Thomas Antoni, 21.1.2005 - www.qbasic.de ";
LOCATE 25, 30
PRINT "Beenden mit Esc-Taste ";
'
'******************* Uhrzeit anzeigen *************************************
COLOR 1, 7                'blaue Schrift auf hellgrau
DO
T$ = TIME$                'Uhrzeit zwischenspeichern
IF T$ <> Talt$ THEN       'Hat sich die Uhrzeit geaendert?
Talt$ = T$
H1% = VAL(MID$(T$, 1, 1)) 'Stunden Zehnerstelle
H2% = VAL(MID$(T$, 2, 1)) 'Stunden Einerstelle
M1% = VAL(MID$(T$, 4, 1)) 'Minuten Zehnerstelle
M2% = VAL(MID$(T$, 5, 1)) 'Minuten Einerstelle
S1% = VAL(MID$(T$, 7, 1)) 'Sekunden Zehnerstelle
S2% = VAL(MID$(T$, 8, 1)) 'Sekunden Einerstelle
'
FOR Zeile% = 0 TO 13
  LOCATE 6 + Zeile%, 4
  PRINT SPACE$(74);                            'Zeile loeschen
  LOCATE , 4
  PRINT Z$(H1%, Zeile%); " "; Z$(H2%, Zeile%); 'Stunden anzeigen
  PRINT Z$(10, Zeile%);                        'Doppelpunkt anzeigen
  PRINT Z$(M1%, Zeile%); " "; Z$(M2%, Zeile%); 'Minuten anzeigen
  PRINT Z$(10, Zeile%);                        'Doppelpunkt anzeigen
  PRINT Z$(S1%, Zeile%); " "; Z$(S2%, Zeile%); 'Sekunden anzeigen
NEXT
'
'********************* Datum anzeigen **************************************
LOCATE 22, 32
PRINT "Datum: ";
PRINT MID$(DATE$, 4, 2); "."; MID$(DATE$, 1, 2); "."; MID$(DATE$, 7, 4)
END IF
'
'********************* Beenden-Dialog **************************************
Taste$ = INKEY$
LOOP UNTIL Taste$ = CHR$(27)   'Beenden bei Esc-Tasten
END
'
'*********** 10x15-Punktmatrix-Codes fuer Ziffern 0...9 und Doppelpunkt ****
'
DATA "    "
DATA "  "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "  "
DATA "    "
'
'
DATA "      "
DATA "     "
DATA "    "
DATA "    "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA ""
DATA ""
'
'
DATA "    "
DATA "  "
DATA "     "
DATA "     "
DATA "     "
DATA "       "
DATA "       "
DATA "       "
DATA "       "
DATA "       "
DATA "       "
DATA "      "
DATA ""
DATA ""
'
'
DATA ""
DATA " "
DATA "        "
DATA "        "
DATA "        "
DATA "       "
DATA "        "
DATA "       "
DATA "        "
DATA "        "
DATA "       "
DATA "      "
DATA "   "
DATA "     "
'
'
DATA "        "
DATA "       "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA ""
DATA ""
DATA "        "
DATA "        "
DATA "        "
DATA "        "
'
'
DATA ""
DATA ""
DATA "        "
DATA "        "
DATA "  "
DATA " "
DATA "        "
DATA "        "
DATA "        "
DATA "        "
DATA "      "
DATA "     "
DATA "  "
DATA "    "
'
'
DATA "     "
DATA "   "
DATA "      "
DATA "        "
DATA "        "
DATA "        "
DATA "  "
DATA " "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "    "
DATA "      "
'
'
DATA ""
DATA ""
DATA "        "
DATA "        "
DATA "        "
DATA "        "
DATA "        "
DATA "        "
DATA "        "
DATA "        "
DATA "        "
DATA "        "
DATA "        "
DATA "        "
'
'
DATA "      "
DATA "    "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "    "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "    "
DATA "      "
'
'
DATA "      "
DATA "    "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "  "
DATA "   "
DATA "        "
DATA "        "
DATA "       "
DATA "       "
DATA "     "
DATA "     "
'
'
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "      "
DATA "    "
DATA "    "
DATA "      "
DATA "    "
DATA "    "
DATA "      "


