'****************************************************************************
' COSINTABE.BAS - Berechnung einer Cosinus-Tabelle ber das Additionstheorem
' ===========================================================================
' Dieses QBasic-Programm berechnet eine Cosinus-Tabelle, ohne die - in QBasic
' verfgbare - Cos-Funktion selbst zu verwenden. Es werden iterative Algorith-
' men benutzt, die ausschlielich auf Quadrat- und Wurzelfunktionen basieren.
' Die Berechnung luft in 2 Teilen ab.
'
' In Teil 1 berechnet das Programm den minimalen Winkel, der dann als Schrit-
' weite fr Teil 2 dient. Dieser Winkel ergibt sich aus der fortwhrenden
' (iterativen) Halbierung des Winkels 60, dessen Cosinus bekannlich den Wert
' 0,5 hat. Die Cosinusfunktion eines halbierten Winkels ergibt sich ber eine
' Formel aus dem Cosinus des ganzen Winkels, die aus dem Additionstheorem
' ableitbar ist. Die Anzahl "nmax" der Halbierungsschritte wird vom Anwender
' eingegeben. Der Minimalwinkel "alphamin" betrgt also 60/2^nmax .
'
' In Teil 2 wird der Cosinus von allen Vielfachne des Minimalwinkels "aphamin"
' im Bereich 0 bis 90 berechnet. Hierbei kommt ebenfalls das Additionstheorem
' zur Anwendung.
'
'
'        (c) Marc Antoni, 28.06.02
'              Mailto:marc@antonis.de
'              http://www.antoni.purespace.de
'              Programm downloadvar unter
'                http://www.antoni.purespace.de/cosintab.zip
'
'***************************************************************************

COLOR 0, 7                             'Schwarze Schrift auf grauem Grund
WIDTH 80, 50                           'Bildschirmgre 80 Spalten, 50 Zeilen
DO
CLS

'------ Teil 1 - Ermittlung des Minimalwinkels und dessen cos ------------
PRINT " ------======== Anzeige einer Cosinus-Tabelle ========------"
PRINT " Der minimale Winkel (Schrittweite) betrgt 60/2^n"
INPUT " Gib die Winkelauflsung n ein"; nmax%
c# = .5

FOR n% = 1 TO nmax%                    'Schleife ber die Iterationsschritte
  c# = SQR((1 + c#) / 2)               'Berechnung des cos des halben Winkels
NEXT n%                                'ber die Quadratwurzel ("Square Root")

alphamin# = 60 / (2 ^ nmax%)
PRINT
PRINT " cos 0", "     = 1.0000000000000000"   'Anzeige von cos 0
PRINT " cos"; alphamin#; "", "     = "; c#    'Anzeige von cos (alphamin)

'----- Teil 2 - Ermittlung u. Anzeige der cos-Werte von Vielfachen -------
'-----          des Minimalwinkels alphamin im Bereich 0...90 -----------
d# = c#                                'Anfangswert fr die Iteration =
                                       'cos von alphamin
kmax% = 90 / alphamin#                 'Anzahl der Iterationsschritte =
                                       '90/Schrittweite

FOR k% = 2 TO kmax%                    'Schleife ber die Iterationsschritte
  d# = d# * c# - SQR((1 - d# ^ 2) * (1 - c# ^ 2))
  PRINT " cos"; k% * alphamin#; "";
  LOCATE , 20                           'Cursor auf Spalte 29
PRINT "= "; d#
NEXT k%

'------- Wiederholen/ Beenden-Dialog --------------------------------------
PRINT                                         'Leerzeile anzeigen
PRINT " Weiter mit beliebiger Taste, Abbruch mit Esc"
DO: taste$ = INKEY$: LOOP WHILE taste$ = ""   'Warten auf Tastenbettigung
LOOP WHILE taste$ <> CHR$(27)                 'Neue Eingabe, wenn kein Esc
END                                           'Beenden mit Esc-Taste

