'***************************************************************************
' COUNTMIN.BAS - Countdown-Timer mit Eingabe in Minuten
' ============
' Nachdem der Anwender die Countdownzeit in Minuten angegeben und den
' Countdown-Timer mit der Eingabetaste gestartet hat, wird diese
' Zeitspanne abgewartet und anschliessend ein Big-Ben-Gongschlag ueber den
' PC-Speaker ausgegeben. Ein Programmanbbruch ist jederzeit mit der
' Esc-Taste moeglich. Mit der F1-Taste kann man das Programm neustarten
' und eine neue Countdown-Zeit waehlen.
'
' Der Maximalwert der Countdown-Zeit betraegt 999 min. Das Ruecksetzen des
' System-TIMERs um Mitternacht wird nicht abgefangen. Daher kommt es zu
' einer Fehlfunktion, wenn sich der Countdown-Zeitraum ber Mitternacht
' erstreckt.
'
' Gib 4 min ein, um ein Ei weichzukochen und 5 min, um Deine Zaehne
' ausreichend lange zu putzen :-))
'
' (c) Thomas Antoni, 8.7.2005 - 27.1.2009, Timmendorfer-Strand
'***************************************************************************
'
'----- rote Bildschirmumrandung malen
DO
COLOR 4, 7                     'rote Schrift auf hellgrau
WIDTH 40, 25                   'halb breiter Bildschirm mit 40 Spalten
CLS
LOCATE 1, 1: PRINT STRING$(40, CHR$(219));
FOR Zeile% = 2 TO 24
  LOCATE Zeile%, 1: PRINT CHR$(219);
  LOCATE Zeile%, 40: PRINT CHR$(219);
NEXT
LOCATE 25, 1: PRINT STRING$(40, CHR$(219));
'
'----- Titelzeile im oberen Rand anzeigen
COLOR 15, 4                     'weisse Schrift auf rot
LOCATE 1, 3
PRINT "COUNTDOWN-TIMER    (c)T.Antoni, 2005";
'
'----- Countdown-Zeit erfragen und Bedienhinweise in Fusszeile anzeigen
COLOR 0, 7                     'schwarze Schrift auf hellgrau
LOCATE 16, 16, 0
PRINT TIME$                    'Akzuelle Uhrzeit anzeigen
LOCATE 4, 2
INPUT " Gib die Countdownzeit in min ein: ", t
PRINT
COLOR 15, 4                    'weisse Schrift auf rot
LOCATE 25, 5
PRINT "Neustart...[F1]   Beenden...[Esc]";
'
'----- Timer-Bearbeitung
startzeit = TIMER
rest = t * 60                 'Restzeit vorbesetzen
gepiepst = 0                  'Merker vorbesetzen: "noch nicht gepiepst"
taste$ = ""                   'Vorbesetzung "keine Taste betaetigt"
timeralt = TIMER              'Merker fuer Timer vorbesetzen
'
DO
IF TIMER <> timeralt THEN     'Anzeige u.Tasten nur bei Timer-Aenderung bearbeiten
  timeralt = TIMER
  rest = t * 60 - (TIMER - startzeit)      'noch verbleibende Restzeit in sec
  IF rest < 0 THEN rest = 0                'Rest auf positive Werte begrenzen
  IF rest = 0 AND gepiepst = 0 THEN        'Timer abgelaufen und noch nicht gepiepst
    PLAY "MFMLT160O1L2gdecP2fedc"          'Big-Ben-Gongschlag wenn Timer abgelaufen
    gepiepst = 1
  END IF
  '
  IF rest = 0 THEN
    COLOR 15, 4                            'Countdown-Ende -> weiss auf rot
  ELSE
    COLOR 15, 1                            'sonst weisse Schrift auf blau
  END IF
  '
  LOCATE 12, 15: PRINT SPACE$(10)
  LOCATE 14, 15: PRINT SPACE$(10)
  min = INT(rest / 60)
  LOCATE 13, 15
  PRINT USING " ### : "; min;
  sec$ = LTRIM$(STR$(rest MOD 60))         'sec ermitteln (als String)
  IF LEN(sec$) < 2 THEN sec$ = "0" + sec$  'bei 1-stelligen sec Null davor
  PRINT sec$; " "
  COLOR 0, 7
  LOCATE 16, 16, 0
  PRINT TIME$
'
'---- Tastenbearbeitung
  taste$ = INKEY$
  IF taste$ = CHR$(27) THEN END            'Abbruch mit Esc-Taste
END IF
LOOP UNTIL taste$ = CHR$(0) + CHR$(59)     'Bei F1-Taste Schleife verlassen
LOOP

