'*****************************************************************************
'
' DIRMAKNO.BAS - QBasic-Programm zum Erstellen von max 1000 Verzeichnissen
'                mit durchnummerierten Verzeichnisnamen
' =========================================================================
'
' Der vordere Namensbestandteil und die erste und letzte Nummer werden vom
' Anwender eingegeben. In den Verzeichnisnamen erscheint die Nummer
' jeweils dreistellig und mit fuehrenden Nullen.
'
' Beispiel:
' - vorderer Namensbestandteil: anna
' - erste Nummer :   9
' - letzte Nummer: 121
' ==> Es werden die leeren Verzeichnisse anna009 ... anna121 erstellt
'
' (c) Thomas Antoni, 24.4.03 - 7.2.04
'       thomas@antonis.de
'       www.qbasic.de - Hottest QBasic Stuff on Earth
'
'*****************************************************************************
'
COLOR 0, 15                            'schwarz auf weiss
CLS
'
'---- Anwenderdialog --------------------
PRINT
PRINT "     Erstellen von nummerierten Verzeichnissen namexxx ... nameyyy"
PRINT "     ============================================================="
PRINT
INPUT "Gib den vorderen Namensbestandteil ein (0...5 Zeichen): name = "; name$
INPUT "Gib die erste  Nummer ein                    (0...999):  xxx = "; a%
INPUT "Gib die letzte Nummer ein                    (0...999):  yyy = "; z%
PRINT
PRINT "Es werden die folgenden Verzeichnisse erstellt: ";
PRINT name$; RIGHT$(STR$(a% + 1000), 3); "..."; 'erste Nummer mit fuehr.Nullen
PRINT name$; RIGHT$(STR$(z% + 1000), 3)
PRINT
PRINT "...weiter mit beliebiger Taste... Abbruch mit Esc"
PRINT
t$ = INPUT$(1)                         'Eine Tastenbetaetigung einlesen
IF t$ = CHR$(27) THEN END              'Programm beenden mit Esc-Taste
'
'---- Verzeichnisse erstellen -------------
FOR i% = a% TO z%
  nummer$ = RIGHT$(STR$(i% + 1000), 3) 'Nummer in String wandeln
                                       'und fuehrende Nullen einfuegen
  SHELL "MD " + name$ + nummer$
  PRINT name$ + nummer$
  IF INKEY$ <> "" THEN PRINT "Abgebrochen": SLEEP: END 'Abbruch mit Esc
NEXT i%
'
'---- Schlussdialog ------------------------
PRINT
PRINT "FERTIG! ";
PRINT z% - a% + 1; " Verzeichnisse erstellt... weiter mit beliebiger Taste"
SLEEP
END

