'*****************************************************************************
'
' FILE-BIN.BAS - Testprogramm fr Bearbeitung binrer Dateien
' ==============================================================
'
' Dieses QBasic-Programm demonstriert den Umgang mit binren Dateien.
' Binrdateien gestatten einen unmittelbaren Zugriff auf alle in der Datei
' enthaltenen Bytes unter Angabe der Byte-Position. Eine Datei wird dabei als
' Folge einzelner Bytes angesehen, wobei jedes Byte gezielt manipuliert
' werden kann.
'
' Teil 1: In Teil 1 wird ein kurzer Text und eine Reihe von Zahlen in der
'         binren Datei xxxtmp.bin im Stammverzeichnis des Laufwerks C:\
'         abgelegt.
' Teil 2: In Teil 2 werden diese Informationen wieder aus der Datei
'         ausgelesen und zur Anzeige gebracht.
'
' Teil 3: Hier wird demonstriert, wie man eine Zahl an beliebiger Stelle
'         (hier Byte 33) in eine binre Datei eintragen kann. Als Datei
'         wird yyytmp.bin im Stammverzeichnis des Laufwerks C:\ angelegt.
' Teil 4: Hier wird diese Zahl wieder ausgelesen und angezeigt.
'
' Wenn Sie Lust haben, knnen Sie sich ja nach dem Programmablauf mal die
' Dateien xxxtmp.bin und yyytmp.bin mit einem Hex-Editor anschauen und dann
' von Hand lschen.
'
'   \         (c) Thomas Antoni, 31.7.99 - 3.11.02
'    \ /\           Mailto:thomas@antonis.de
'    ( )            http://www.antonis.de 
'  .( o ).
'              ----==== Hottest QBasic Stuff on Earth !!! ====----
'
'*****************************************************************************


'-------- Teil 1: Potenzen von 2 in Datei xxxtmp.bin hinterlegen ------------
DIM text AS STRING * 14      'String-Variable mit fester Lnge v.14 Zeich.
CLS
ON ERROR GOTO fehler         'Fehlerbarbeitung falls Datei nicht vorhanden
KILL "c:\xxxtmp.bin"         'Datei lschen

OPEN "c:\xxxtmp.bin" FOR BINARY AS #1
pot$ = "Potenzen von 2"      '14 Zeichen langer Text
PUT #1, , pot$               'Den Inhalt von pot$ in die Datei schreiben
                             '___Befehls-Syntax___:
                             'PUT <#Dateinr.>, [Position], <Variable>
                             'Position=Stellung des Schreib-/ Lesezeigers
                             '1.Byte hat die Position 1; wird d.Position
                             'weggelassen, so ist d.aktuelle Pos. wirksam

FOR i% = 1 TO 16
  p& = 2 ^ i%
  PUT #1, , p&               'Potenz von 2 als 4-Byte-Gre in die Datei
NEXT i%                      'schreiben


'--------- Teil 2: xxx.bin wieder auslesen und Inhalt anzeigen ------------
SEEK #1, 1                   'Schreib-/Lesezeiger aufs 1. Byte setzen
                             'Bei Wechsel zwischen PUT und GET ist kein
                             'Schliessen einer Binren Datei erforderlich!
GET #1, , text$              'Text aus der Daei mit GET auslesen.
                             '___Befehls-Syntax___:
                             'GET <#Dateinr.), [Position], <Variable>
                             'Textvariable mssen vorher ber DIM mit der
                             'richtigen Lnge spezifiziert werden.
PRINT text$
FOR i% = 1 TO 16             '16 Long-Integer-Zahlen aus der Datei lesen
  GET #1, , p&
  PRINT p&                   '... and anzeigen
NEXT i%
CLOSE #1
SLEEP
PRINT

'------ Teil 3: Hex-Zahl 4711h (=18193) in Datei yyy.bin hinterlegen --------
OPEN "c:\yyytmp.bin" FOR BINARY AS #3
z& = &H4711
SEEK #3, 33   'der naechste Dateizugriff soll an Byte-Position 33 erfolgen
              'Bei einer Binrdatei ist also ein direkter Zugriff
              'mitten in der Datei jederzeit moeglich !!!
PUT #3, , z&


'------ Teil 4: Zahl wieder auslesen diese sowie die Dateilnge anzeigen -----
GET #3, 33, y&
PRINT y&
PRINT "Die Datei c:\yyytmp.bin ist"; LOF(3); " Bytes lang"
CLOSE #3
SLEEP

END

fehler: RESUME NEXT   'Fehler ignorieren



