'*****************************************************************************
'
' FILE-TYP.BAS - Demo der Bearbeitung Direktzugriffs-Dateien mit TYPE-Puffer
' ==========================================================================
'
' Was ist eine Direktzugriffs-Datei?
' -----------------------------------
' Dieses QBasic-Programm demonstriert den Umgang mit Direktzugriffs-Dateien.
' Direktzugriffs-Dateien bestehen aus gleich langen Datenstzen. Das
' ermoeglicht einen direkten Zugriff auf einen beliebigen Datensatz
' innerhalb der Datei, ohne dass alle vorhergehenden Datensaetze erst
' gelesen werden muessen. Dies ist der Vorteil gegenber den Sequentiellen
' Dateien.
'
' Die bei Sequentiellen Dateien bliche Datensatz-Endekennung, die aus einem
' Zeilenvorschub ( <CR> >LF> )  besteht, entfllt bei Direktzugriffs-Dateien.
'
' Eine noch flexiblere, aber auch wesentlich komplexere Abart der
' Direktzugriffs-Datei arbeitet mit einem FIELD-Puffer statt eines
' TYPE-Puffers (siehe mein Programm File-Fld.BAS).
'
' Was tut dies Programm?
' -----------------------------------
' In dem Programmbeispiel werden zunaechst die Namen und das Alter von zwei
' Personen abgefragt und in das anwenderdefinierte Feld "namlist" einge-
' tragen.
'
' In Teil 3 wird anschlieend der Inhalt von "namlist" in die Datei
' "test.tmp" im Stammverzeichnis des Laufwerks C:\ geschrieben.
'
' In Teil 4 wird diese Datei wieder ausgelesen und der Inhalt angezeigt.
'
' Wenn Sie Lust haben, knnen Sie sich ja nach dem Programmablauf mal die
' Datei "c:\test.tmp" mit einem Hex-Editor anschauen und dann von Hand
' lschen.
'
'   \         (c) Thomas Antoni, 3.11.02 - 3.11.02
'    \ /\           Mailto:thomas@antonis.de
'    ( )            www.antonis.de --- www.qbasic.de
'  .( o ).
'              ----==== Hottest QBasic Stuff on Earth !!! ====----
'
'*****************************************************************************

'----- Teil 1: Anwenderdefiniertes Feld von Typ "listentyp" deklarieren ----
TYPE Listentyp               'Laenge 14 Bytes
  nam AS STRING * 12         'Strings mssen eine feste Lnge haben
  alter AS INTEGER
END TYPE

DIM namlist(1 TO 2) AS Listentyp  'Schreibpuffer fr alle 2 Datenstze
DIM Datensatz AS Listentyp        'Lesepuffer fr einen Datensatz

'---- Teil 2: Namen und Alter von 2 Personen erfragen u. in Liste ablegen ---
CLS
FOR i% = 1 TO 2
  PRINT "Eingabe des"; i%; ". Datensatzes"
  INPUT " Gib den Namen ein :"; namlist(i%).nam
  INPUT " Gib das Alter ein :"; namlist(i%).alter
  PRINT
NEXT i%

'------ Teil 3: Beide Datenstze in die Datei c:\test.tmp schreiben ---------
OPEN "c:\test.tmp" FOR RANDOM AS 1 LEN = 14
SEEK 1, 1                'Dateizeiger auf ersten Datensatz setzen
FOR i% = 1 TO 2
  PUT #1, , namlist(i%)  'Datensatz in Datei schreiben
                         '___Befehls-Syntax :___
                         'PUT #<Dateinr.>, <Datensatznr&>, <Feldname$>
                         '(<Nr% des Feldelements%>)
NEXT
CLOSE #1

'------ Teil 4: Datentze aus Datei auslesen und anzeigen -------------------
PRINT
OPEN "c:\test.tmp" FOR RANDOM AS 1 LEN = LEN(Datensatz)
FOR i% = 1 TO 2
  GET #1, i%, Datensatz  'Datensatz aus Datei lesen
                         '___Befehls-Syntax :___
                         'GET #<Dateinr.>, <Datensatznr&>, <Feldname$>
                         '(<Nr% des Feldelements%>)
  PRINT Datensatz.nam, Datensatz.alter
NEXT
CLOSE #1
SLEEP
END


