'****************************************************************************
' IndexGen.BAS = Indexgenerator fuer HTML-Dateien V2.0
' ==========================================================================
' Dieses Q(uick)Basic-Programm erzeugt eine Index-Datei INDEX.HTM, die
' alle im Vereichnis C:\TMP\HTML\ hinterlegten HTML-Dateien mit der
' Dateiendung ".HTM" oder ".HTML" als anklickbare Links auflistet. INDEX.HTM
' stellt also ein Inhaltsverzeichnis der HTML-Dateien zur Verfuegung, das
' ebenfalls im Verzeichnis C:\TMP\HTML\ hinterlegt wird.
'
' Beim Anklicken werden die in INDEX.HTM verlinkten HTML-Seiten jeweils
' in einem neuen Browser-Fenster bzw. -Tab geoeffnet.
'
' Zur Ermittlung der relevanten Dateien wird der DIR-Befehl von DOS
' verwendet. Fuer den Aufruf von DIR werden dem Anwender die 3 folgenden
' Varianten offeriert:
'   (1) Beliebiges Betriebssystem - Windows oder DOS
'       Lange Dateinamen werden auf 8+3 Zeichen verkuerzt so wird
'       etwa "Abschlussabend.htm" zu "ABSCHL~1.HTM".
'   (2) Windows 9x - Lange Dateinamen werden unterstuetzt
'   (3) Windows XP - Lange Dateinamen werden unterstuetzt
' Bei den Varianten 2 und 3 wird der DIR-Befehl nicht direkt aufgerufen,
' sondern an den jeweiligen Kommandointerpreter COMMAND.COM bzw. CMD.EXE
' uebergeben. Nur dann ist die Unterstuetzung langer Dateinamen
' gewaehrleistet.
'
' (c) Thomas Antoni, 28.9.2009 - 20.1.2010
'       thomas@antonis.de  --- www.qbasic.de  --- www.antonis.de
'
'***************************************************************************
'
'****************************************************************************
'           Startbildschirm anzeigen und Betriebssystem erfragen
'****************************************************************************
DO
COLOR 0, 7                        'schwarz auf weiss
CLS
LOCATE 2, 32: PRINT "HTML-Indexgenerator"
LOCATE 3, 32: PRINT "==================="
LOCATE 5, 14
PRINT "Fuer alle *.HTM-Dateien im Ordner c:\TMP\HTML\ wird ein"
LOCATE 6, 14
PRINT "Inhaltsverzeichnis erstellt und in INDEX.HTM hinterlegt."
LOCATE 8: PRINT STRING$(80, CHR$(196));  'Linie malen

LOCATE 12, 10: PRINT "Welches Betriebssystem ist vorhanden?";
LOCATE 14, 19: PRINT "(1) Beliebiges Betriebssystem - Windows oder DOS";
LOCATE 15, 23: PRINT "Lange Dateinamen werden auf 8+3 Zeichen verkuerzt";
LOCATE 16, 19: PRINT "(2) Windows 9x - lange Dateinamen werden unterstuetzt";
LOCATE 17, 19: PRINT "(3) Windows XP - lange Dateinamen werden unterstuetzt";
LOCATE 18, 19: PRINT "(4) Abbrechen";
LOCATE 24, 5
COLOR 15, 1                       'weiss auf blau
PRINT "              Waehle gewuenschte Funktion (1) bis (4)                  ";
COLOR 0, 7                        'schwarz auf weiss
'
DO
  taste$ = INPUT$(1)   'Warten bis 1 Taste von d.Tastatur eingelesen
  SELECT CASE taste$
    CASE "1"
      Befehl$ = "dir "
                       'Soll das Programm auch unter reinem DOS
                       'funktionieren, dann muss der reine DOS-Befehl
                       'DIR verwendet werden. Es werden nur die kurzen
                       '8+3-Dateinenamen untersttzt; lange Dateinamen
      EXIT DO
    CASE "2":
      Befehl$ = "command /c dir "
                       'Die Verwendung des Kommandointerpreters COMMAND.EXE
                       ' von Windows 9x stellt sicher, dass lange Dateinamen
                       'unterstuetzt werden. Das waere nicht der Fall, wenn
                       'man direkt den DIR-Befehl von QB aus per
                       'SHELL "DIR ..." aufrufen wuerde!
      EXIT DO
    CASE "3"
      Befehl$ = "cmd /c dir"
                       'Bei Windows XP muss man CMD.EXE statt COMMAND.COM
                       'verwenden. Der Kommandointerpreter hat hier einen
                       'anderen Namen.
      EXIT DO
    CASE "4", CHR$(27) 'Beenden mit "4" oder mit Esc
      END
  END SELECT
LOOP                   'Zurueck zum Tasten-Einlesen, wenn eine andere
                       'Taste als 1..4 und Esc betaetigt
'
LOCATE 24, 5
COLOR 0, 7             'schwarz auf weiss
PRINT SPACE$(73);      'Bedienhinweis wieder loeschen
'
LOCATE 22, 29          'Position fuer eventuelle Meldung HTML- "Datei nicht
                       'gefunden" des DIR-Befehls, die sich durch ON ERROR
                       'nicht vermeiden laesst
'
'**************************************************************************
' Namen aller .HTM-und .HTMLDateien in C:\TMP\HTML\   mit DIR-Befehl
' ermitteln und in die Datei           C:\TMP\HTML\~dir.txt eintragen
'***************************************************************************
Pfad$ = "C:\TMP\HTML"
Erweiterung$ = "HTM?" 'hierdurch werden .HTM und .HTML-Dateien erfasst
' Befehl$ = Befehl$ + " " + Pfad$ + "\*." + Erweiterung$ + " /b"
Befehl$ = Befehl$ + " " + Pfad$ + "\*." + Erweiterung$ + " /b"
' Die Option /b listet nur die Verzeichnisse und Dateinamen auf - ohne
' Zusammenfasung, Kopfinformation sowie ohne sonstigen ueberfluessigen
' "Ballast".
'
Befehl$ = Befehl$ + " > C:\TMP\HTML\~dir.txt"
'
SHELL Befehl$
'
'****************************************************************************
'          Index-Datei INDEX.HTM anlegen und HTML-Vorspann einfuegen
'****************************************************************************
'
OPEN "C:\tmp\HTML\INDEX.HTM" FOR OUTPUT AS #2   'Index-Datei anlegen
PRINT #2, "<!DOCTYPE HTML PUBLIC "; CHR$(34);
PRINT #2, "-//W3C//DTD HTML 4.01 Transitional//EN"; CHR$(34); ">"
                               'Dokumententyp und HTML-Sprachversion angeben
'
PRINT #2, "<html>"
PRINT #2, "<head>"
PRINT #2, "<title>Index - Inhalt</title>"
'
PRINT #2, "<meta http-equiv="; CHR$(34); "Content-Type"; CHR$(34);
PRINT #2, " content="; CHR$(34); "text/html; charset=iso-8859-1"; CHR$(34); ">"
                               'Text-Zeichensatz angeben
'
PRINT #2, "<!-- This File has been automatically created by INDEXGEN -->"
PRINT #2, "<!-- ~ INDEXGEN automatically generates an index of all   -->"
PRINT #2, "<!--            *.HTM files in the C:\TMP\HTML\ dirctory  -->"
PRINT #2, "<!-- ~ INDEXGEN has been written in QBasic by (c)Thomas Antoni, 2009 -->"
PRINT #2, "<!-- ~ INDEXGEN is freeware. Download on www.qbasic.de -->"
'
PRINT #2,
PRINT #2, "<!-- Hover-Effekte =========== -->"
PRINT #2, "<style type="; CHR$(34); "text/css"; CHR$(34); ">"
PRINT #2, "<!--"
PRINT #2, "A:hover {color:"; CHR$(34); "#ff0000"; CHR$(34); ";}"
PRINT #2, "//-->"
PRINT #2, "</style>"
PRINT #2, "<!-- Ende Hover-Effekte ====== -->"
PRINT #2,
'
PRINT #2, "</head>"
'
PRINT #2,
PRINT #2, "<body><center> <table width=90%><tr><td>";
PRINT #2, "<h2>Inhalt</h2>";
PRINT #2, "<pre>"
                 'Die Anzeige der Index-Datei erfolgt "preformatiert" (in
                 'nichtproportionaler Schriftart mit allen Leerzeichen und
                 'Zeilenvorschueben) sowie mit einem Rand von je 5% auf
                 'der linken und der rechten Bildschirmseite
PRINT #2, "<ul>"
'
'****************************************************************************
'   Ermittelte Dateinamen lesen und als HTML-Link in Indexdatei eintragen
'****************************************************************************
OPEN "C:\TMP\HTML\~dir.txt" FOR INPUT AS #1
FileNo% = 0
WHILE NOT EOF(1)                   'Schleife ueber alle Dateinamen
                                   '(je Dateinamen 1 Zeile)
  LINE INPUT #1, d$                'Dateinamen *.HTM einlesen
  PunktPos% = INSTR(d$, ".")
  Link$ = LEFT$(d$, PunktPos% - 1) '".HTM" bzw. ".HTML" ausblenden
'
  PRINT #2, "<li><a href="; CHR$(34); d$; CHR$(34);   'Dateinamen als Link
  PRINT #2, " target="; CHR$(34); "_blank"; CHR$(34); ">"; Link$; "</a>"
'
  FileNo% = FileNo% + 1
WEND
'
'****************************************************************************
'     Nachspann mit Datum, Uhrzeit und Copyright in HTML-Datei einfuegen
'****************************************************************************
PRINT #2, "</ul>"
'
d$ = DATE$  'System-Datum einlesen
Datum$ = MID$(d$, 4, 2) + "." + LEFT$(d$, 2) + "." + RIGHT$(d$, 4)
            'System-Datum mm-dd-jjjj ins deutsche Format dd.mm.jjjj umwandeln
'
PRINT #2, "</pre><hr><br><font size = 2>Automatically generated by INDEXGEN ";
PRINT #2, "(&copy;Thomas Antoni), "; Datum$; ",  "; TIME$; "</font><br><br>"
PRINT #2, "</td></tr></table></center></body></html>"
CLOSE #2
'
'****************************************************************************
'             Fertigmeldung und Wiederholen/Beenden-Dialog
'****************************************************************************
'
LOCATE 20, 14
PRINT "Fertig!  "; FileNo%; "Dateien in INDEX.HTM eingetragen"
CLOSE #1
KILL "C:\TMP\HTML\~dir.txt"
'
LOCATE 24, 5
COLOR 15, 1                                  'weiss auf blau
PRINT "      [beliebige Taste]...Beenden     [Eing]...Programm-Neustart       ";
DO: taste$ = INKEY$: LOOP UNTIL taste$ <> "" 'Warten auf belieb. Tastendruck
IF taste$ <> CHR$(13) THEN
  CLS
  END
END IF
LOOP                                         'zurueck z. Programmwiederholg.
END


