DECLARE SUB Orgel ()
DECLARE SUB Klavier1 ()
'****************************************************************************
'*
'* KLAVIER.BAS - QBASIC-Klavierprogramme
'* ========================================================================
'* Verschiedene Varianten, am PC Klavier zu spielen
'*
'* (c) Thomas Antoni, 09.03.99 - 30.08.99
'*       thomas.antoni@erlf.siemens.de
'*
'****************************************************************************

start:
COLOR 15, 0 'Wei auf Schwarz
CLS
PRINT
PRINT " Willkommen zum Klavierspielen am PC        (c)T.Antoni, 1999"
PRINT " ============================================================"
PRINT
PRINT "  (1)    Klavier 1  (mit PLAY-Befehlen)"
PRINT "  (2)    Orgel      (mit SOUND-Befehlen)"
PRINT "  (Esc)  ... beenden"
PRINT
PRINT " Whle gewnschtes Instrument (1) bis (2):"
LOCATE 9, 44, 1, 3, 5     'Blink-Cursor an Eingabeposition anzeigen

DO: taste$ = INKEY$: LOOP UNTIL taste$ <> ""
LOCATE , , 0             'Blink-Cursor wieder deaktivieren
SELECT CASE taste$
  CASE "1"
    CALL Klavier1
    GOTO start
  CASE "2"
    CALL Orgel
    GOTO start
  CASE CHR$(27)
    COLOR 15, 0
    CLS
    END
  CASE ELSE: GOTO start
END SELECT
END

SUB Klavier1

'******************************************************************************
' Klavier1 - QBasic-Subroutine  zum Klavierspielen am PC mit dem PLAY-Befehl
' ===========================================================================
' Tasten 1...9 erzeugen 1/8 lange Tne C, D, E, F, G, A,  sowie C, D, E in der
' nchsthheren Oktave mit Hilfe entsprechender Play-Befehle.
'
' Mit den "-" und "-" Taste lt sich die Oktave erhhen und erniedrigen.
'
' Die gespielten Noten werden in der QBasic-Notation in einem blauen Notenfens-
' ter angezeigt, das sich mit der Backspace-Taste wieder lschen lt. Bei
' einem Wechsel der aktuellen Oktave erfolgt ebenfalls ein Lschen des Noten-
' fensters.
' Somit lassen sich Lieder komponieren, deren Inhalte im Notenfenster doku-
' mentiert und dann leicht in andere QBasic-Programme einbindbar sind.
'
' Mit Esc erfolgt die Rckkehr zum Hauptmen
'
' Verwendete Befehle: INKEY$, PRINT, SELECT CASE, PLAY
'
' (c) Thomas Antoni, 9.3.99 - 29.08.99
'******************************************************************************

CLS
oktave% = 1
PRINT " Klavierspielen am PC, Version 1 (mit Play-Befehl)  (c) T.Antoni, 1999"
PRINT " ====================================================================="
PRINT
PRINT " Tastenbelegung: 0...9   = Klavierspielen"
PRINT " ---------------     +   = Oktave erhhen"
PRINT "                     -   = Oktave erniedrigen"
PRINT "                 Bkspace = Notenfenster lschen  ( <== Taste )"
PRINT "                 Esc     = beenden"
PRINT
PRINT " Oktave        :"; oktave%
PRINT " ---------------"
PRINT
PRINT " Notenfenster  : (QBasic-Notenbuchstaben; o2 = Noten in der hheren Oktave)"
PRINT " --------------------------------------------------------------------------"
COLOR 14, 1                     'alle folgenden Anzeigen Gelb auf Blau
GOSUB loesch 'Notenfeld blau einfrben
taste$ = ""
WHILE taste$ <> CHR$(27)
taste$ = INKEY$

SELECT CASE taste$

'--- 7 Grundtne  (Lnge = 1/8) --------------------------------
CASE "1": PLAY "o" + STR$(oktave%) + " L8 c": PRINT "c ";
CASE "2": PLAY "o" + STR$(oktave%) + " L8 d": PRINT "d ";
CASE "3": PLAY "o" + STR$(oktave%) + " L8 e": PRINT "e ";
CASE "4": PLAY "o" + STR$(oktave%) + " L8 f": PRINT "f ";
CASE "5": PLAY "o" + STR$(oktave%) + " L8 g": PRINT "g ";
CASE "6": PLAY "o" + STR$(oktave%) + " L8 a": PRINT "a ";
CASE "7": PLAY "o" + STR$(oktave%) + " L8 b": PRINT "b ";

'--- 3 Tne in der nchsten Oktave -----------------------------
CASE "8": PLAY "o" + STR$(oktave% + 1) + "L8 c": PRINT "o2c ";
CASE "9": PLAY "o" + STR$(oktave% + 1) + "L8 d": PRINT "o2d ";
CASE "0": PLAY "o" + STR$(oktave% + 1) + "L8 e": PRINT "o2e ";

'--- Oktav-Sprung: bei +|- Oktave erhhen|erniedrigen ----------
'--- und Notenfeld lschen
CASE "+"
  IF oktave% < 5 THEN
    oktave% = oktave% + 1
    LOCATE 10, 17
    PRINT oktave%
    GOSUB loesch
  END IF
CASE "-"
  IF oktave% > 0 THEN
    oktave% = oktave% - 1
    LOCATE 10, 17
    PRINT oktave%
    GOSUB loesch
  END IF

'--- bei Backspace Notenfeld lschen ----------
CASE CHR$(8): GOSUB loesch
END SELECT

WEND
GOTO endklavier1

'--- Lokale Subroutine zum Lschen u.Blaufrben des Notenfeldes -------------
loesch:
  LOCATE 15, 1
  FOR i% = 15 TO 24: LOCATE i%, 1: PRINT SPACE$(80); : NEXT i%
  LOCATE 25, 1
  PRINT SPACE$(80);
  LOCATE 15, 1
RETURN

endklavier1:

END SUB

SUB Orgel
'******************************************************************************
' Orgel - QBasic-Subroutine zum Orgelspielen am PC mit dem SOUND-Befehl
' ===========================================================================
' Tasten 1...9 erzeugen 1/8 lange Tne C, D, E, F, G, A,  sowie C, D, E in der
' nchsthheren Oktave mit Hilfe entsprechender Play-Befehle.
'
' Mit den "-" und "-" Taste lt sich die Oktave erhhen und erniedrigen. Die
' aktuelle Oktave wird auf dem Bildschirm angezeigt
'
' Die gespielten Noten werden mit ihrer Frequenz in Herz in einem blauen
' Frequenzfenster angezeigt, das sich mit der Backspace-Taste wieder lschen
' lt. Bei einem Wechsel der aktuellen Oktave erfolgt ebenfalls ein Lschen
' des Notenfensters, ebenso, wenn das Frequenzfenster voll ist.
' Somit lassen sich Sounds komponieren, deren Inhalte im Frequenzfenster doku-
' mentiert und dann leicht in andere QBasic-Programme einbindbar sind.
'
' Mit Esc erfolgt die Rckkehr zum Hauptmen
'
' Verwendete Befehle: INKEY$, PRINT, SELECT CASE, SOUND
'
' (c) Thomas Antoni, 29.08.99 - 30.08.99
'******************************************************************************

CLS


oktave% = 1                           'Vorbesetzung: erste Oktave

PRINT " Orgelspielen am PC  (mit Sound-Befehl)  (c) T.Antoni, 1999"
PRINT " ====================================================================="
PRINT
PRINT " Tastenbelegung : 0...9   = Orgelspielen"
PRINT " ----------------     +   = Oktave erhhen"
PRINT "                      -   = Oktave erniedrigen"
PRINT "                  Esc     = beenden"
PRINT "                  BkSpace = Frequenzanzeige lschen  ( <=== Taste)"
PRINT
PRINT " Oktave         :"; oktave%
PRINT " ----------------"
PRINT
PRINT " Frequenzanzeige:     (in [Herz] )"
PRINT " ----------------"

COLOR 14, 1                     'alle folgenden Anzeigen Gelb auf Blau
GOSUB ClearFrequenz
LOCATE 15, 1


'-- Tasten auswerten --------------------------------------------------------
DO
  DO: taste$ = INKEY$: LOOP UNTIL taste$ <> ""
                                      'Warteschleife bis Taste bettigt
  SELECT CASE taste$
    CASE "1": frequenz! = 65.5        'Note C = 2^n * 65.5 Hz
    CASE "2": frequenz! = 73.5        'Note D
    CASE "3": frequenz! = 82.5        'Note E
    CASE "4": frequenz! = 87.5        'Note F
    CASE "5": frequenz! = 98          'Note G
    CASE "6": frequenz! = 110         'Note A
    CASE "7": frequenz! = 123.5       'Note B
    CASE "8": frequenz! = 131         'Note C in der nchsten Oktave:Frequ.*2
    CASE "9": frequenz! = 147         'Note D in der nchsten Oktave
    CASE "0": frequenz! = 165         'Note E in der nchsten Oktave
    CASE "+"
      IF oktave% < 6 THEN
        oktave% = oktave% + 1         'Oktave erhhen
        LOCATE 10, 18: PRINT oktave%  'Oktave anzeigen
        GOSUB ClearFrequenz
      END IF
    CASE "-":
      IF oktave% > 0 THEN
        oktave% = oktave% - 1         'Oktave erniedrigen
        LOCATE 10, 18: PRINT oktave%  'Oktave anzeigen
        GOSUB ClearFrequenz
      END IF
    CASE CHR$(8): GOSUB ClearFrequenz
  END SELECT

'--- Ton erzeugen (Lnge 4*55 ms = 0.22s) -----------------------------------
  IF (taste$ >= "0") AND (taste$ <= "9") THEN
    f! = frequenz! * 2 ^ oktave%      'effektive Frequenz
    SOUND f!, 4
    PRINT f!;
    IF CSRLIN = 24 AND POS(0) > 65 THEN GOSUB ClearFrequenz
                                    'Frequenzfenster lschen, wenn voll
  END IF

LOOP UNTIL taste$ = CHR$(27)
GOTO endorgel

'--- Lokale Subroutine zum Lschen u.Blaufrben des Frequenzfeldes -------------
ClearFrequenz:
  LOCATE 15, 1
  FOR i% = 15 TO 24: LOCATE i%, 1: PRINT SPACE$(80); : NEXT i%
  LOCATE 25, 1
  PRINT SPACE$(80);
  LOCATE 15, 1
RETURN


endorgel:

END SUB

