DECLARE FUNCTION Datum$ ()
DECLARE SUB RandomNo (randomfield%())
'****************************************************************************
' LOTTO.BAS = QBasic-Programm zur Erzeugung von Lotto-Zahlen ohne Doubletten
' ==========================================================================
'
' (c) Thomas Antoni, 13.10.99
'        thomas.antoni@erlf.siemens.de
'****************************************************************************

anfang:
DO
  COLOR 0, 7
  CLS
  COLOR 15, 4                         'Kopfzeile wei auf rot
  PRINT "         LottoFix   V1.0       (c) Thomas Antoni, 1999                          ";
  LOCATE , 70
  PRINT Datum$
  COLOR 0, 7
  PRINT
  PRINT "               Willkommen zum LottoFix Lottozahlen-Generator"
  PRINT "               "
  PRINT
  PRINT "    Sollen 6 oder 7 Lottozahlen aus 49 erzeugt werden? Whle 6 oder 7 ";
  LOCATE , , 1, 3, 5     'Blink-Cursor an Eingabeposition anzeigen
  DO: taste$ = INKEY$: LOOP WHILE taste$ = ""
  SELECT CASE taste$
    CASE "6": anz% = 6
    CASE "7": anz% = 7
    CASE CHR$(27): END
    CASE ELSE: GOTO anfang
  END SELECT
  LOCATE 13, 6, 0, 0          'Blink-Cursor wieder rcksetzen
  PRINT "        Die"; anz%; "Lottozahlen lauten:"
  COLOR 14, 1
  LOCATE 16, 15
  DIM randomfield%(1 TO 49)         'Feld fr 49 Zufallszahlen
  CALL RandomNo(randomfield%())     'Feld fllen ohne Doubletten
  FOR n% = 1 TO anz%: PRINT USING " #####  "; randomfield%(n%); : NEXT n%
  COLOR 15, 4                       'in Farbe wei auf rot Esc-Hinweis ausgeb.
  LOCATE 25, 1
  PRINT "          Wiederholen....[beliebige Taste]     Beenden....[Esc]                 ";

'----------------------- animierten Drehbalken in Fuzeile anzeigen ----------
  COLOR 15, 4                                 'wei auf rot
  DO
    Starttime! = TIMER
    DO: LOOP UNTIL TIMER > Starttime! + .15     '150 ms Wartezeit
    LOCATE 25, 72
    PRINT TIME$;                   'Uhrzeit anzeigen
    LOCATE , 2                     'Drehbalken als Ttigkeitsanzeige
    k% = k% + 1
    IF k% > 4 THEN k% = 1
    SELECT CASE k%
      CASE 1: PRINT "";           ' ";" ==> Cursor bleibt in aktueller Zeile
      CASE 2: PRINT "\";
      CASE 3: PRINT "";
      CASE 4: PRINT "/";
    END SELECT
    taste$ = INKEY$
  LOOP WHILE taste$ = ""
LOOP WHILE taste$ <> CHR$(27)
COLOR 15, 0                      'wei/schwarz-Bildschirm wiederherstellen
CLS
LOCATE 12, 30: PRINT "... und Tsch!"
END

FUNCTION Datum$
'****************************************************************************
' Function DATUM$: Erzeugung d. Datums in deutscher Schreibweise (10 Zeichen)
' ===========================================================================
' Das Datum wird aus der Systemvariablen DATE$ gelesen. Dort hat es das
' Format     mm-dd-jjjj   .  Hieraus wird das Datum im deutschen Format
'
' (c) Thomas Antoni, 15.05.09
'
'***************************************************************************

d$ = DATE$
Datum$ = MID$(d$, 4, 2) + "." + LEFT$(d$, 2) + "." + RIGHT$(d$, 4)

END FUNCTION

SUB RandomNo (randomfield%())
'*****************************************************************************
' RandomNo = QBasic-Subroutine  zum Erzeugen von Zufallszahlen ohne Doubletten
' ============================================================================
' bergabeparameter:
'   randomfield()= Feld das mit Zufallszahlen gefllt werden soll. Die Feld-
'   lnge ist beliebig. Das Feld kann im aufrufenden Programm statisch oder
'   dynamisch deklariert sein.
'
' Beschreibung:
'    RandomNo erwartet, da die Indices des Feldes von 1 bis <Anzahl Zufalls-
'    zahlen> luft. Das Feld wird mit den Ganzzahlen 1 bis <Anzahl Zufalls-
'    zahlen> in zuflliger Reihenfolge gefllt. Jede der Zahlen kommt also
'    genau einmal vor.
'    RandomNo ist ideal geeignet fr Quiz-Programme, Vokabeltrainer und
'    Mathe-Trainer, bei denen die zu hufige Wiederholung von Fragen
'    unerwnscht ist
'
' (c) Thomas Antoni, 26.09.99 - 26.09.99
'*****************************************************************************
RANDOMIZE TIMER
rananz% = UBOUND(randomfield%) - LBOUND(randomfield%) + 1 'Anz. Feldelemente
FOR i% = 1 TO rananz%
  DO
    ranno% = INT(RND * rananz%) + 1     'Zufallszahl zwischen 1 und rananz%
    fertig% = -1                        'Vorbesetzung: keine Doublette (TRUE)
    FOR k% = 1 TO i% - 1                'bereits erzeugte

      IF ranno% = randomfield%(k%) THEN 'Doubletten ausschlieen
        fertig% = 0                     'FALSE: ranno%=Doublette
        EXIT FOR
      END IF
    NEXT k%
  LOOP UNTIL fertig%
randomfield%(i%) = ranno%
NEXT i%
END SUB

