'------------------- Menpunkte von MatheFix --------------------------------
DECLARE SUB Primzerl ()
DECLARE SUB geradesn ()
DECLARE SUB geradepu ()
DECLARE SUB Primzahl ()
DECLARE SUB ggTkgV ()
DECLARE SUB LinGlei2 ()

'------------------- diverse Utilities --------------------------------------
DECLARE SUB EndeEsc (zeile%) 'Gibt Fuzeile "Ende: Esc" in Zeile% aus,
                             'Rckkehr wenn Esc bettigt
DECLARE FUNCTION Neu1Ende0% (zeile%)
                             'gibt Schludialog in Zeile% aus, liefert 1 zu-
                             'rck wenn beliebige und 0 wenn Esc bettigt
DECLARE FUNCTION dialogzahl# (spalte%, Text$)
                             'gibt den Text$ in Spalte% aus und fragt eine
                             'DOUBLE-Gleitpunktzahl ab, die sie zurckliefert.
                             'bei Fehleingabe wird die CONST ungueltig# =
                             '1.79769D+308 rckgeliefert (grte DOUBLE-Zahl)
DECLARE FUNCTION Datum$ ()   'liefert Datum i.deut. Schreibweise, 10 Zeichen
DECLARE SUB ProgressBar (prozent%)
                             'gibt Fortschrittbalken i.d. Zeilen 24+25 aus

'****************************************************************************
'*
'* MatheFix.BAS - QBASIC-Mathematik-Programm
'* ========================================================================
'* Kleines Mathematikprogramm
'*
'* (c) Thomas Antoni, 13.04.99 - 04.07.99
'*     thomas.antoni@erlf.siemens.de
'*
'****************************************************************************

'*************** Deklaration von Tasten zur Ereignisverfolgung **************
KEY 15, CHR$(0) + CHR$(51)          'Kommataste
KEY 16, CHR$(0) + CHR$(1)           'Esc-Taste, noch nicht benutzt

'*************** Beginn des Hauptprogramms **********************************

'------------------------ Titelzeile und Men ausgeben ----------------------
language$ = "d"
start:
COLOR 0, 7                          'schwarze Schrift auf hellgrauem Grund
WIDTH 80, 25                        'normaler Textmodus: 80 Spalten, 25 Zeilen
CLS
COLOR 15, 4                         'Kopfzeile wei auf rot
PRINT "         MatheFix   V1.0       (c) Thomas Antoni, 1999                          ";
LOCATE , 70
PRINT Datum$
COLOR 0, 7
IF language$ = "d" THEN             'Deutssprachiges Men
  PRINT
  PRINT "  (1)  Taschenrechner"
  PRINT "  (2)  Beschreibung zum Taschenrechner"
  PRINT "  (3)  Teilbarkeitsregeln"
  PRINT "  (4)  Primzahlen 1 bis 4000"
  PRINT "  (5)  Primfaktorzerlegung"
  PRINT "  (6)  ggT und kgV"
  PRINT "  (7)  Geradengleichung aus 2 Punkten"
  PRINT "  (8)  Schnittpunkt zweier Geraden"
  PRINT "  (9)  Lineare Gleichungen mit 2 Unbekannten"
  PRINT
  PRINT "  (e)  English-Language Menue"

ELSE                                'Englischprachiges Men
  PRINT
  PRINT "  (1)  pocket calculator"
  PRINT "  (2)  instructions of pocket calculator"
  PRINT "  (3)  rules of divisibility"
  PRINT "  (4)  prime numbers from 1 to 4000"
  PRINT "  (5)  prime-factor disaggregation"
  PRINT "  (6)  greatest common divisor & smalles common multiple"
  PRINT "  (7)  straight-line equation from two points"
  PRINT "  (8)  intersection point of two straight lines"
  PRINT "  (9)  linear equations with two unknown quantities"
  PRINT
  PRINT "  (d)  Deutschsprachiges Men"
END IF

PRINT
LOCATE 21, 3
COLOR 14, 1                         'gelb auf blau
PRINT " Whle gewnschte Funktion (1) bis (8)"
LOCATE 25, 1
COLOR 15, 4                         'Farbe wei auf rot
PRINT "                 Beenden: Esc                                                 ";

'----------------------- Tastenabfrage ---------------------------------------
DO
COLOR 0, 7                          'Normalfarbe schwarz auf hellgrau
taste$ = INKEY$
SELECT CASE taste$

CASE "1"
  CLS
  PRINT " --------- Nenner immer mit Nachkommastellen eingeben, z.B. 3.0 statt 3 -------"
  PRINT " --------- Winkel in Radian oder  [Grad] / 180*pi  eingeben             -------"
  LOCATE 25
  COLOR 15, 4                       'in Farbe wei auf rot Esc-Hinweis ausgeb.
  PRINT "                      Beenden: Esc                                            ";
  COLOR 0, 7
  SHELL "calcul"
  GOTO start

CASE "2"
  SHELL "list calcul.txt"
  GOTO start

CASE "3"
  SHELL "list teilbar.txt"
  GOTO start

CASE "4"
  CALL Primzahl
  GOTO start

CASE "5"
  CALL Primzerl
  GOTO start

CASE "6"
  CALL ggTkgV
  GOTO start

CASE "7"
  CALL geradepu
  GOTO start

CASE "8"
  CALL geradesn
  GOTO start

CASE "9"
  CALL LinGlei2
  GOTO start

CASE "e"
  language$ = "e"
  GOTO start

CASE "d"
  language$ = "d"
  GOTO start

END SELECT

'----------------------- animierten Drehbalken in Fuzeile anzeigen ----------
  COLOR 15, 4                                 'wei auf rot
  Starttime! = TIMER
  DO: LOOP UNTIL TIMER > Starttime! + .15     '150 ms Wartezeit
  LOCATE 25, 72
  PRINT TIME$;                   'Uhrzeit anzeigen

  LOCATE , 2                     'Drehbalken als Ttigkeitsanzeige
  k% = k% + 1
  IF k% > 4 THEN k% = 1
  SELECT CASE k%
    CASE 1: PRINT "";           ' ";" ==> Cursor bleibt in aktueller Zeile
    CASE 2: PRINT "\";
    CASE 3: PRINT "";
    CASE 4: PRINT "/";
  END SELECT

LOOP WHILE taste$ <> CHR$(27) OR taste$ = ""

COLOR 15, 0                      'wei/schwarz-Bildschirm wiederherstellen
CLS
END


'*************** Deklaration von Subroutinen auf Hauptprogr.level **********

'--------------------------------------------------------------------------
' TuNIX: QBasic-Subroutine, die nur aus einem Return besteht (zur Ereig-
'        nisverfolgung, von DialogZahl verwendet)
'
'--------------------------------------------------------------------------
TuNix:
RETURN


'************* Deklaration von Konstanten **********************************
CONST pi# = 3.14159265358979#
CONST ungueltig# = 1.79769D+308   'Ungltige Eingabe := grte DOUBLE-Floa-
                                  'ting-Point-Zahl; erzeugt von DialogZahl

FUNCTION Datum$
'****************************************************************************
' Function DATUM$: Erzeugung d. Datums in deutscher Schreibweise (10 Zeichen)
' ===========================================================================
' Das Datum wird aus der Systemvariablen DATE$ gelesen. Dort hat es das
' Format     mm-dd-jjjj   .  Hieraus wird das Datum im deutschen Format
'
' (c) Thomas Antoni, 15.05.09
'
'***************************************************************************

d$ = DATE$
Datum$ = MID$(d$, 4, 2) + "." + LEFT$(d$, 2) + "." + RIGHT$(d$, 4)
END FUNCTION

FUNCTION dialogzahl# (spalte%, Text$)
'****************************************************************************
' Eingabe einer LONG Gleitpunktzahl mit vorhergehender Textausgabe in 1 Zeile
' ===========================================================================
' In der aktuellen Bildschirmzeile wird zunchst der Text angezeigt (Gleich-
' heitszeichen mu mit bergeben werden).
' Am Anschlu erfolgt gelb auf blau die Zahleneingabe. Nach der Eingabe
' wird das Fragezeichen gelscht (d.h. mit einem "schwarz auf hellgrauem"
' Blank berschrieben).
' Durch folgende Manahmen werden Fehlermeldungen vermieden:
'   1. Die Eingabezahl wird zunchst als String abgelegt
'   2. Die Kommataste wird per Ereignisverfolgung unterdrckt
'
' Aufrufbeispiel: Dialogtext ab Spalte 2 und LONG-Wert eingeben
'
'          z1# = DialogZahl#(2," Gib die erste  Zahl ein: z1# =")
'          IF z1# = ungueltig# THEN EXIT DO  'ungltige mehrzeilige Eingabe
'
' (c) Thomas Antoni, 26.04.99
'
'***************************************************************************


                                    'Trick: Ereignisverfolgung fr Kommataste:
ON KEY(15) GOSUB TuNix              'Drcken der Kommataste wird nicht
KEY(15) ON                          'bercksichtigt (Deklaration von Key 15
                                    'und SUB TuNix im Hauptprogramm)


zeile% = CSRLIN                     'Zeilennummer merken
LOCATE , spalte%
PRINT Text$;
COLOR 14, 1                         'Eingabe gelb auf blau
INPUT ; z$                          'Zahl als String einlesen z.Unterdckung
                                    'e. Fehlermeldg.bei falsch. Zahlenformat.
                                    ' ";" ==> Cursor bleibt hinter Eingabe
IF CSRLIN <> zeile% THEN            'bei mehrzeiliger Eingabe Fehlermeldung
   zz# = ungueltig#                 'ungueltig# = im Hauptprogr. deklar. Const
ELSE
   zz# = VAL(z$)                    'String in Zahl umwandeln
   LOCATE , spalte% + LEN(Text$)
                                    'Cursor aufs Fragezeichen
   COLOR 0, 7                       'Farbe wieder schwarz auf grau
   PRINT SPACE$(LEN(z$) + 2);       'Eingabe mit Blanks berschreiben, d.h.
                                    'lschen
   LOCATE , spalte% + LEN(Text$) + 1 'Cursor auf die alte Zahleneingabe
   COLOR 14, 1                       'gelb auf blau
   PRINT zz#                        'tatschlich wirksame Zahl an alter
                                    'Stelle ausgeben
   COLOR 0, 7                       'wieder schwarz auf hellgrau
END IF
dialogzahl# = zz#

KEY(15) OFF                         'Ereignisverfolgung fr Kommataste beend.
END FUNCTION

SUB EndeEsc (zeile%)
'***********************************************************************
' Abbruchdialog "Beenden mit Esc-Taste" in Zeile% ausgeben
' Max.wert fr Zeile%: 25 bei Screen 0 und 80/25 Zeichen
'                      49 bei Screen 0 und 80/50 Zeichen)
' Die Meldezeile ist in weier Schrift auf rotem Grund angelegt.
' am Beginn der Zeile wird ein animierter Drehbalken angezeigt.
' Aufrufbeispiel:
'
'             CALL EndeEsc
'             GOTO Ende
'
'***********************************************************************

LOCATE zeile%
COLOR 15, 4                         'Farbe wei auf rot
PRINT "                Beenden: Esc                                                  ";

DO
  taste$ = INKEY$
  Starttime! = TIMER
  DO: LOOP UNTIL TIMER > Starttime! + .15     '150 ms Wartezeit

  LOCATE , 72
  PRINT TIME$;                     'Uhrzeit anzeigen

  LOCATE , 2                       'Drehbalken als Ttigkeitsanzeige
  k% = k% + 1
  IF k% > 4 THEN k% = 1
  SELECT CASE k%
    CASE 1: PRINT "";             ' ";" ==> Cursor nicht auf nchst.Zeile
    CASE 2: PRINT "\";
    CASE 3: PRINT "";
    CASE 4: PRINT "/";
  END SELECT
LOOP WHILE taste$ <> CHR$(27) OR taste$ = ""

COLOR 0, 7                          'schwarz/hellgraue Farbe wiederherstellen
END SUB

SUB geradepu
'***************************************************************************
' GERADEPU - Subroutine zum Ermitteln d.Geradengleichung aus 2 Punkten
' ===========================================================================
' Eingegeben werden in einem Dialog die beiden Punkte
'         A(x_A ; y_A) und  B(x_B ; y_B).
' Hieraus wird die explizite Form der Geradengleichung
          y = mx + t
' berechnet (und angezeigt) entsprechend folgender Beziehungen:
'         m = (y_A - y_B) / (x_B - x_A)
'         t = y_A - m * x_A
' Der Ausnahmefall x_A = x_B (d.h. die Gerade verluft parallel zur y-Achse)
' wird als getrennt betrachtet, um die Division durch Null zu vermeiden.
'
' Verwendete Befehle: SGN, TIME, INKEY$, CSRLIN, INPUT, COLOR, LOCATE, PRINT
'
' (c) Thomas Antoni, 09.04.99 - 28.04.99
'***************************************************************************


'----------- Eingabe der 4 Koordinaten --------------------------------------

gepu00:
COLOR 0, 7                          'schwarze Schrift auf hellgrauem Grund
WIDTH 80, 25                        'normaler Textmodus: 80 Spalten, 25 Zeilen
CLS                                 'Bildschirm rcksetzen

COLOR 15, 4                         'Titelzeile: weie Schrift, roter Grund
PRINT "   Explizite Form der Geradengleichung aus zwei Punkten ermitteln               ";
LOCATE , 70
PRINT Datum$
COLOR 0, 7

PRINT
PRINT " Koordinateneingabe fr Punkt A:"
PRINT
PRINT "      Gib die X-Koordinate x_A des ersten Punktes A ein:"
xa# = dialogzahl#(15, "x_A =")
IF xa# = ungueltig THEN GOTO gepu40
PRINT

PRINT "      Gib die Y-Koordinate y_A des ersten Punktes A ein:"
ya# = dialogzahl#(15, "y_A =")
IF ya# = ungueltig THEN GOTO gepu40
PRINT


PRINT " Koordinateneingabe fr Punkt B: "
PRINT
PRINT "      Gib die X-Koordinate x_B des zweiten Punktes B ein:"
xb# = dialogzahl#(15, "x_B =")
IF xb# = ungueltig THEN GOTO gepu40

PRINT
PRINT "      Gib die Y-Koordinate y_B des zweiten Punktes B ein:"
yb# = dialogzahl#(15, "y_B =")
PRINT
IF yb# = ungueltig THEN GOTO gepu40
GOTO gepu50

'---------------- Abbruch bei ngltiger mehrzeiliger Eingabe --------------
gepu40:
LOCATE 22, 10
COLOR 15, 2                            'Meldung wei auf grn darstellen
PRINT " Fehlerhafte Eingabe ber mehr als eine Zeile !!! "
GOTO gepu120

'---------------- Berechnung der Geradengleichung --------------------------
gepu50:
PRINT
PRINT " Die Geradengleichung lautet:"
PRINT
LOCATE 22, 8
COLOR 15, 2                            'Ergebnis wei auf grn darstellen

IF xb# = xa# THEN                      'Division durch Null unterdrcken
   LOCATE , 10
   PRINT "Geradengleichung ist unbestimmt! Die Gerade ist zur y-Achse parallel!"
ELSE
   m# = (yb# - ya#) / (xb# - xa#)
   t# = ya# - m# * xa#
   IF SGN(t#) = -1 THEN vz$ = "-" ELSE vz$ = "+"
   PRINT " y = "; m#; "* x  "; vz$; " "; ABS(t#)
END IF

'------------- Schludialog: Beenden oder Wiederholen ------------------------
gepu120:
IF Neu1Ende0%(25) = 1 THEN GOTO gepu00
END SUB

SUB geradesn
'***************************************************************************
' GERADESN - Subroutine zum Ermitteln d.Schnittpunktes zweier Geraden
' ===========================================================================
' Eingegeben werden in einem Dialog zwei Geraden, die jeweils aus 2 Punkten
' bestehen oder in d. expliziten Geradengleichung y = mx * t eingegeben werden
' knnen.
'
' Ist eine der Geraden durch zwei Punkte (z.B. A und B) vorgegeben, so wird
' hieraus zunchst nach den Formeln
'         m = (y_A - y_B) / (x_B - x_A)
'         t = y_A - m * x_A
' die explizite Form der Geradengleichung  y = m*x + t  gebildet.
' Der Ausnahmefall x_A = x_B (d.h. die Gerade verluft parallel zur y-Achse)
' wird getrennt betrachtet, um die Division durch Null zu vermeiden. Die Gera-
' dengleichung lautet in diesem Ausnahmefall "x=x_A"
'
' Anschlieend liegen beide Geraden dann in der expliziten Form vor:
'         y1 = m1 * t + t1
'         y2 = m2 * t + t2.
' Hieraus wird anhand folgender Formeln der Schnittpunkt S(x_S  y_S) der
' beiden Geraden gem folgender Formeln berechnet und angezeigt:
'         xs = (t2-t1) / m2-m1)
'         ys = m1 * xs + t1
' Die folgenden beiden Ausnahmeflle werden vorher getrennt betrachtet:
' Fall 1: Verlaufen die beiden Geraden parallel zueinander (m1=m2) oder velau-
'         fen beide Geraden parallel zur Y-Achse, so gibt es
'         keinen Schnittpunkt und es erfolgt eine entsprechende Anzeige.
' Fall 2: Verluft genau eine der beiden Geraden (z.B. Gerade 1) parallel zur
'         Y-Achse, so ergibt sich der Schnittpunkt durch die Gleichungen
'         x_S = x_A1 und y_S = m2 * x_A1  +  t_2
'
' (c) Thomas Antoni, 18.04.99 - 08.05.99
'***************************************************************************


'================= Eingabe der Titelzeile ===================================
gesn00:
COLOR 0, 7                          'schwarze Schrift auf hellgrauem Grund
WIDTH 80, 25                        'normaler Textmodus: 80 Spalten, 25 Zeilen
CLS                                 'Bildschirm rcksetzen u.hellgrau frben

COLOR 15, 4                         'Titelzeile: weie Schrift, roter Grund
PRINT "         Berechnung des Schnittpunktes zweier Geraden                      ";
LOCATE , 70
PRINT Datum$
COLOR 0, 7


'================== Eingabe der Geraden 1 ===================================

'----------------Eingabeform von Gerade 1 abfragen --------------------------
FOR i% = 3 TO 13                    'senkrechten Strich in d. Mitte zeichnen
LOCATE i%, 40
PRINT ""
NEXT i%

LOCATE 3
PRINT " Eingabe der Geraden 1 Ŀ"
PRINT
PRINT "  Whle die Eingabeform: Ŀ"
PRINT "                                    "
PRINT "  1  = explizite Form (y = m*x + t) "
PRINT "  2  = zwei Punkte    (A und B)     "
PRINT "  Esc= Abbruch                      "
PRINT "                                    "
PRINT "                       ";
LOCATE , 8
COLOR 14, 1
PRINT " Gib 1 oder 2 ein   ";
LOCATE , 26, 1, 3, 5                'blinkenden Cursor in Spalte 26 akti-
                                    'vieren; Cursor= 3.-5. Pixelzeile
gesn20:
DO: taste$ = INKEY$
LOOP WHILE taste$ = ""
LOCATE , 26, 0                      'Cursor deaktivieren

IF taste$ = "1" THEN
  eingform1% = 1
ELSEIF taste$ = "2" THEN
  eingform1% = 2
ELSEIF taste$ = CHR$(27) THEN       'Abbruch bei Esc
  COLOR 0, 7
  LOCATE 2
  FOR i% = 2 TO 22
    PRINT SPACE$(80)                'Bildschirn ab Zeile 2 lschen
  NEXT i%
  GOTO gesn90
ELSE
  LOCATE , 26, 1, 3, 5              'Cursor wieder aktivieren
  GOTO gesn20
END IF

COLOR 0, 7
LOCATE CSRLIN - 7, 1
PRINT SPACE$(39)                    'vorherige 7 Zeilen lschen
PRINT SPACE$(39)
PRINT SPACE$(39)
PRINT SPACE$(39)
PRINT SPACE$(39)
PRINT SPACE$(39)
PRINT SPACE$(39)
PRINT SPACE$(39)

LOCATE CSRLIN - 8

bestimmbar1% = 1                    'Vorbesetzung: Geradengleichung 2
                                    'bestimmbar (nicht aprallel z. Y-Achse)

'---------------Gerade 1 in der expliziten Form eingeben --------------------
IF eingform1% = 1 THEN
   PRINT
   PRINT " y = m*x + t"
   PRINT "     "
   PRINT "     "
   PRINT "     "
   PRINT "      m =";
   m1# = dialogzahl(12, "")
   IF m1# = ungueltig# THEN GOTO gesn100
   LOCATE CSRLIN - 4
   PRINT "          "
   PRINT "           t=";
   t1# = dialogzahl(17, "")
   IF t1# = ungueltig# THEN GOTO gesn100
   PRINT


'--------------- Gerade 1 ber zwei Punkte eingeben ------------------------
ELSE
   PRINT
   PRINT " Gib  Punkt A ein:"
   xa1# = dialogzahl(4, "x_A =")
   IF xa1# = ungueltig# THEN GOTO gesn100
   ya1# = dialogzahl(4, "y_A =")
   IF ya1# = ungueltig# THEN GOTO gesn100
   PRINT
   PRINT " Gib  Punkt B ein:"
   xb1# = dialogzahl(4, "x_B =")
   IF xb1# = ungueltig# THEN GOTO gesn100
   yb1# = dialogzahl(4, "y_B =")
   IF yb1# = ungueltig# THEN GOTO gesn100

   LOCATE 12
   PRINT "Ĵ"

'------- Gerade 1:  Gleichung ermitteln/ anzeigen  bei 2-Punkte-Eingabe -----
   PRINT " Die Geradengleichung 1 lautet:"
   IF xa1# <> xb1# THEN
                                          'explizite Geradengleichung bestimm-
                                          'bar, da nicht parallel zur y-Achse
      m1# = (yb1# - ya1#) / (xb1# - xa1#) 'Berechnung der expliziten Form
      t1# = ya1# - m1# * xa1#

      PRINT " y = m*x + t                           "
      PRINT "     "
      PRINT "     "
      PRINT "     "
      PRINT "      m =";
      COLOR 15, 2                         'Ergebnis wei auf grn
      PRINT " "; m1#
      COLOR 0, 7                          'wieder schwarz auf grau
      LOCATE CSRLIN - 4
      PRINT "          "
      PRINT "           t=";
      COLOR 15, 2
      PRINT " "; t1#
      COLOR 0, 7

   ELSE
      bestimmbar1% = 0                    'explizite Form nicht bestimmbar
      COLOR 15, 2                         'Ergebnis wei auf grn
      LOCATE CSRLIN + 1, 4
      PRINT "x = "; xa1#                  'Geradengleichung lautet x=xa
      COLOR 0, 7                          'wieder schwarz auf grau
   END IF

END IF

FOR i% = 3 TO 19            'senkrechten Strich in d. Mitte zeichnen
LOCATE i%, 40
PRINT ""
NEXT i%
IF eingform1% = 2 THEN
  LOCATE 12, 40
  PRINT ""
END IF

LOCATE 19
PRINT " "


'================== Eingabe der Geraden 2 ===================================

'----------------Eingabeform von Gerade 2 abfragen --------------------------

LOCATE 3, 40
PRINT " Eingabe der Geraden 2 "
PRINT
LOCATE , 41
PRINT "  Whle die Eingabeform: Ŀ"
LOCATE , 41
PRINT "                                    "
LOCATE , 41
PRINT "  1  = explizite Form (y = m*x + t) "
LOCATE , 41
PRINT "  2  = zwei Punkte    (A und B)     "
LOCATE , 41
PRINT "  Esc= Abbruch                      "
LOCATE , 41
PRINT "                                    "
LOCATE , 41
PRINT "                      ";
LOCATE , 48
COLOR 14, 1
LOCATE , 48
PRINT " Gib 1 oder 2 ein  ";
LOCATE , 66, 1, 3, 5
gesn202:
DO: taste$ = INKEY$
LOOP WHILE taste$ = ""
LOCATE , , 0

IF taste$ = "1" THEN
  eingform2% = 1
ELSEIF taste$ = "2" THEN
  eingform2% = 2
ELSEIF taste$ = CHR$(27) THEN        'Abbruch bei Esc
  COLOR 0, 7
  LOCATE 2
  FOR i% = 2 TO 22
    PRINT SPACE$(80)                 'Bildschirm ab Zeile 2 lschen
    NEXT i%
    GOTO gesn90
ELSE
  LOCATE , 66, 1, 8
  GOTO gesn202
END IF

COLOR 0, 7
LOCATE CSRLIN - 7
LOCATE , 41
PRINT SPACE$(39)                     'vorherige 7 Zeilen lschen
LOCATE , 41
PRINT SPACE$(39)
LOCATE , 41
PRINT SPACE$(39)
LOCATE , 41
PRINT SPACE$(39)
LOCATE , 41
PRINT SPACE$(39)
LOCATE , 41
PRINT SPACE$(39)
LOCATE , 41
PRINT SPACE$(39)
LOCATE , 41
PRINT SPACE$(39)

LOCATE CSRLIN - 8

bestimmbar2% = 1                    'Vorbesetzung: Geradengleichung 2
                                    'bestimmbar (nicht aprallel z. Y-Achse)

'---------------Gerade 2 in der expliziten Form eingeben --------------------
IF eingform2% = 1 THEN
   LOCATE , 41
   PRINT
   LOCATE , 41
   PRINT " y = m*x + t"
   LOCATE , 41
   PRINT "     "
   LOCATE , 41
   PRINT "     "
   LOCATE , 41
   PRINT "     "
   LOCATE , 41
   PRINT "      m =";
   m2# = dialogzahl(52, "")
   IF m2# = ungueltig# THEN GOTO gesn100
   LOCATE CSRLIN - 4, 41
   PRINT "          "
   LOCATE , 41
   PRINT "           t=";
   t2# = dialogzahl(57, "")
   IF t2# = ungueltig# THEN GOTO gesn100
   PRINT

'--------------- Gerade 2 ber zwei Punkte eingeben ------------------------

ELSE
   PRINT
   LOCATE , 41
   PRINT " Gib  Punkt A ein:"
   xa2# = dialogzahl(44, "x_A =")
   IF xa2# = ungueltig# THEN GOTO gesn100
   ya2# = dialogzahl(44, "y_A =")
   IF ya2# = ungueltig# THEN GOTO gesn100
   PRINT
   LOCATE , 41
   PRINT " Gib  Punkt B ein:"
   xb2# = dialogzahl(44, "x_B =")
   IF xb2# = ungueltig# THEN GOTO gesn100
   yb2# = dialogzahl(44, "y_B =")
   IF yb2# = ungueltig# THEN GOTO gesn100

   LOCATE , 40
   PRINT ""
   IF eingform1% = 1 THEN
      LOCATE CSRLIN - 1, 40
      PRINT ""
   END IF


'------- Gerade 2:  Gleichung ermitteln/ anzeigen  bei 2-Punkte-Eingabe -----
   LOCATE , 41
   PRINT " Die Geradengleichung 2 lautet:"
   LOCATE , 41
   IF xa2# <> xb2# THEN
                                          'explizite Geradengleichung bestimm-
                                          'bar, da nicht parallel zur y-Achse
      m2# = (yb2# - ya2#) / (xb2# - xa2#) 'Berechnung der expliziten Form
      t2# = ya2# - m2# * xa2#

      LOCATE , 41
      PRINT " y = m*x + t"
      LOCATE , 41
      PRINT "     "
      LOCATE , 41
      PRINT "     "
      LOCATE , 41
      PRINT "     "
      LOCATE , 41
      PRINT "      m =";
      COLOR 15, 2                         'Ergebnis wei auf grn
      LOCATE , 49
      PRINT " "; m2#
      COLOR 0, 7                          'wieder schwarz auf grau
      LOCATE CSRLIN - 4
      LOCATE , 41
      PRINT "          "
      LOCATE , 41
      PRINT "           t=";
      COLOR 15, 2
      LOCATE , 55
      PRINT " "; t2#
      COLOR 0, 7

   ELSE
      bestimmbar2% = 0                    'explizite Form nicht bestimmbar
      COLOR 15, 2                         'Ergebnis wei auf grn
      LOCATE CSRLIN + 1, 45
      PRINT "x = "; xa2#                  'Geradengleichung lautet x=xa
      COLOR 0, 7                          'wieder schwarz auf grau
   END IF
END IF


'============= Schnittpunkt S (x_S ; y_S) berechnen und ausgeben =============
LOCATE 21, 3

IF bestimmbar1% = 0 AND bestimmbar2% = 0 THEN
   GOTO gesn95                         'beide Geraden sind parallel z.Y-Achse
ELSEIF bestimmbar1% = 0 THEN           'Gerade 1 ist parallel zur Y-Achse
   xs# = xa1#
   ys# = m2# * xa1# + t2#
ELSEIF bestimmbar2% = 0 THEN           'Gerade 2 ist parallel zur Y-Achse
   xs# = xa2#
   ys# = m1# * xa2# + t1#
ELSE
   IF m1# = m2# THEN                   'parallele Geraden => kein Schnittpunkt
      GOTO gesn95                      'Division durch Null unterdrcken
   ELSE                                '"Normalfall": beide Geraden schief
      xs# = (t2# - t1#) / (m1# - m2#)
      ys# = m1# * xs# + t1#
   END IF
END IF

PRINT " Die Geraden 1 und 2 schneiden sich im folgenden Schnittpunkt S (x_s  y_s): "
   LOCATE , 10
LOCATE 23, 10
COLOR 15, 2                            'Ergebnis wei auf grn
   PRINT " S = ( x_s = "; xs#; "  y_s = "; ys#; ")"


'------------- Schludialog: Beenden oder Wiederholen ------------------------
gesn90:
IF Neu1Ende0%(25) = 1 THEN
   GOTO gesn00
ELSE
   GOTO gesnend
END IF

'------------- Meldung "kein Schnittpunkt, da parallele Geraden" -------------
gesn95:
COLOR 15, 2
PRINT " Die Geraden sind zueinander parallel ==> Es gibt keinen Schnittpunkt ! "
GOTO gesn90

'------------- Fehlermelgd. u.Neubeginn bei fehlerhafter Eingabe ------------
gesn100:
LOCATE 23, 3
COLOR 15, 2
PRINT " Fehlerhafte Eingabe ber mehr als eine Zeile !!! "
GOTO gesn90

gesnend:
COLOR 0, 7                              'Farbe wieder schwarz auf hellgrau
END SUB

SUB ggTkgV
'****************************************************************************
' ggTkgV - Unterprogrammm zur Ermittlung von ggT und kgv zweier Zahlen
' ========================================================================
' Es wird der ggT der beiden Zahlen z1 und z2 gebildet und angezeigt. Auerdem
' wird der gekrzte Bruch z1/z2 ausgegeben.
' Anschlieend wird das kleinste gemeinsame Vielfache von z1 und z2 ermittelt
' nach der Formel kgV = z1*z2/ggT und die ermeiterten gleichnamig gemachten
' Brche 1/z1 und 1/z2 ausgegeben.
'
' Algorithmen aus {2/13}, noch etwas optimiert.
'
' (c) Thomas Antoni, 13.04.99 -15.04.99
'****************************************************************************

'----------- Titelzeile und Eingabe der beiden Zahlen z1 und z2 -------------
anfang:
COLOR 0, 7                          'schwarze Schrift auf hellgrauem Grund
WIDTH 80, 25                        'normaler Textmodus: 80 Spalten, 25 Zeilen
CLS
COLOR 15, 4
PRINT " Grter gemeins.Teiler /kleinstes gemeins.Vielfaches zweier Zahlen             ";
LOCATE , 70
PRINT Datum$
COLOR 0, 7
PRINT
z1# = dialogzahl#(2, "Gib die erste  Zahl ein: z1 =")
x# = z1#
PRINT
z2# = dialogzahl#(2, "Gib die zweite Zahl ein: z2 =")
y# = z2#

'----------- Ermittlung und Anzeige des ggT ---------------------------------
IF z1# = 0 OR z2# = 0 THEN GOTO abbruch1 'Division durch Null unterdrcken
IF ABS(z1#) > 2000000000 OR ABS(z2#) > 2000000000 THEN
GOTO abbruch2                            'MOD wandelt in Ganzzahl, daher
END IF                                   'Zahlenbereich auf LONG begrenzen

IF z1# > z2# THEN SWAP z1#, z2#
DO
   rest# = z2# MOD z1#
   ggt# = z1#
   IF rest# < 1 THEN EXIT DO
   z2# = z1#
   z1# = rest#
LOOP
PRINT
PRINT "  "
PRINT
PRINT " Der grte gemeinsame Teiler ist  : ";
COLOR 15, 2                            'Ergebnis wei auf grn darstellen
PRINT " ggT = "; ggt#
COLOR 0, 7
PRINT
COLOR 0, 7
PRINT " Der gekrzte Bruch z1/z2 lautet   : ";
COLOR 15, 2
PRINT x#; "/"; y#; " = "; x# / ggt#; "/"; y# / ggt#
COLOR 0, 7
PRINT


'----------- Ermittlung und Anzeige des kgV ---------------------------------
PRINT "  "
PRINT
kgv# = x# * y# / ggt#
PRINT " Das kleinste gemeins.Vielfache ist: ";
COLOR 15, 2                            'Ergebnis wei auf grn darstellen
PRINT " kgV = "; kgv#
COLOR 0, 7
PRINT
PRINT " Die gleichnamig gemachten Brche lauten:"
PRINT
LOCATE , 38
COLOR 15, 2
PRINT " 1/"; x#; " = "; kgv# / x#; "/"; kgv#
LOCATE , 38
PRINT " 1/"; y#; " = "; kgv# / y#; "/"; kgv#
PRINT
GOTO schluss

'------------ Abbruchdialog, wenn eine der Zahlen z1 oder z2 = Null ---------
abbruch1:
LOCATE 20, 10
COLOR 15, 2                            'Ergebnis wei auf grn darstellen
PRINT " ggT und kgV knnen nicht bestimmt werden, da z1 oder z2 = 0 !"
GOTO schluss

'-- Abbruchdialog, wenn z1 oder z2 den LONG-Zahlenbereich berschreitet -----
abbruch2:
LOCATE 20, 10
COLOR 15, 2                            'Ergebnis wei auf grn darstellen
PRINT " ggT und kgV nicht bestimmbar, da z1 oder z2 > 2 000 000 000 !"



'----------- Schludialog in Zeile 25: Wiederholen oder beenden -------------
schluss:
IF Neu1Ende0%(25) = 1 THEN GOTO anfang

END SUB

SUB LinGlei2
'*****************************************************************************
' LinGlei - Subroutine zur Lsung von Linearen Gleichungen mit 2 Unbekannten
' ===========================================================================
' Eingegeben werden in einem Dialog zwei Lineare Gleichungen der Form
'          a1x + b1y = c1
'          a2x + b2y = c2
' Hieraus werden x und y berechnet anhand der folgenden Formeln:
'          x = (b2c1 - b1c2) / (a1b2 - a2b1)
'          y = (a1c2 - a2c1) / (a1b2 - a2b1)
' Wenn der Nenner a1b2-a2b1 Null ist, gibt es keine Lsung und es erfolgt eine
' entsprechende Anzeige (die Graphen der beiden Gleichungen verlaufen parallel
' zueinander).
'
'T. Antoni (c) 12.6.99 - 13.06.99
'*****************************************************************************

'================= Ausgabe der Titelzeile ===================================
ling00:
COLOR 0, 7                          'schwarze Schrift auf hellgrauem Grund
WIDTH 80, 25                        'normaler Textmodus: 80 Spalten, 25 Zeilen
CLS                                 'Bildschirm rcksetzen u.hellgrau frben

COLOR 15, 4                         'Titelzeile: weie Schrift, roter Grund
PRINT "           Lsung von Linearen Gleichungen mit 2 Unbekannten                    ";
LOCATE , 70
PRINT Datum$
COLOR 0, 7

'================== Eingabe der Gleichung 1 =================================
LOCATE 2, 2
PRINT
PRINT " Gib die erste Gleichung ein:"
PRINT
PRINT "    ax + by = c"
PRINT
a1# = dialogzahl(8, "a =")
IF a1# = ungueltig# THEN GOTO ling100
b1# = dialogzahl(8, "b =")
IF b1# = ungueltig# THEN GOTO ling100
c1# = dialogzahl(8, "c =")
IF c1# = ungueltig# THEN GOTO ling100

'=================== Eingabe der Gleichung 2 =================================
LOCATE 10, 3
PRINT
PRINT " Gib die zweite Gleichung ein:"
PRINT
PRINT "    ax + by = c"
PRINT
a2# = dialogzahl(8, "a =")
IF a2# = ungueltig# THEN GOTO ling100
b2# = dialogzahl(8, "b =")
IF b2# = ungueltig# THEN GOTO ling100
c2# = dialogzahl(8, "c =")
IF c2# = ungueltig# THEN GOTO ling100

'=========== Nenner berechnen, Abbruch wenn Nenner = 0 =======================
nenner# = a1# * b2# - a2# * b1#
IF nenner# = 0 THEN GOTO ling95        'Es gibt keine Lsung, da Div. durch 0

'===================== Ergebnis berechnen und ausgeben =======================
x# = (b2# * c1# - b1# * c2#) / nenner#
y# = (a1# * c2# - a2# * c1#) / nenner#
LOCATE 20, 2
PRINT "Die Lsung lautet:"
LOCATE 22, 12
COLOR 15, 2                            'Ergebnis wei auf grn
PRINT " x = "; x#
LOCATE 23, 12
PRINT " y = "; y#


'------------- Schludialog: Beenden oder Wiederholen ------------------------
ling90:
IF Neu1Ende0%(25) = 1 THEN
   GOTO ling00
ELSE
   GOTO lingend
END IF

'-------- Meldung "Es gibt keine Lsung fr x und y  (Divison durch 0) ------
ling95:
COLOR 15, 2
LOCATE 23, 3
PRINT " Es gibt keine Lsung: Die Graphen beider Geraden verlaufen parallel ! "
GOTO ling90

'------------- Fehlermelgd. u.Neubeginn bei fehlerhafter Eingabe ------------
ling100:
LOCATE 23, 3
COLOR 15, 2
PRINT " Fehlerhafte Eingabe ber mehr als eine Zeile !!! "
GOTO ling90

lingend:
COLOR 0, 7                              'Farbe wieder schwarz auf hellgrau

END SUB

FUNCTION Neu1Ende0% (zeile%)
'***********************************************************************
' Abbruchdialog in Zeile% (max. Zeile 25 bei Screen 0 und 80/25 Zeichen)
' - liefert eine 1 zurck bei "neue Berechnung"
' - liefert eine 0 zurck bei "Beenden"
' Die Meldezeile ist in weier Schrift auf rotem Grund angelegt.
' am Beginn der Zeile wird ein animierter Drehbalken angezeigt.
' Aufrufbeispiel:
'             IF Neu1Ende0%(23) = 1 THEN GOTO anfang
'             END SUB
'
'***********************************************************************

LOCATE zeile%
COLOR 15, 4                         'Farbe wei auf rot
PRINT "       Neue Berechnung: beliebige Taste         Beenden: Esc                ";

DO
  taste$ = INKEY$

  Starttime! = TIMER
  DO: LOOP UNTIL TIMER > Starttime! + .15   '200 ms Wartezeit

  LOCATE , 72
  PRINT TIME$;                              'Uhrzeit anzeigen

  LOCATE , 2                                'Drehbalken als Ttigkeitsanzeige
  k% = k% + 1
  IF k% > 4 THEN k% = 1
  SELECT CASE k%
    CASE 1: PRINT "";                      ' ";" ==> Cursor bleibt in aktuell.Zeile
    CASE 2: PRINT "\";
    CASE 3: PRINT "";
    CASE 4: PRINT "/";
  END SELECT

LOOP WHILE taste$ = ""

IF taste$ <> CHR$(27) THEN Neu1Ende0% = 1 ELSE Neu1Ende0 = 0
COLOR 15, 0                        'wei/schwarz-Bildschirm wiederherstellen

END FUNCTION

SUB Primzahl

'***************************************************************************
' PRIMZAHL - Subroutine
' ==========================================================================
' Einfacher, noch verbesserungsfhiger Algorithmus: Alle ungeraden Zahlen i%
' im Bereich werden durch jede ungerade Zahl, die zwischen 3 und  der Qua-
' dratwurzel aus i% liegt, geteilt (eigentlich brauchte nur die Teilbarkeit
' durch die in diesem Bereich liegende Primzahlen geprft zu werden!).
'
' Wenn der durch den MOD-Operator ermittelte Rest bei einer dieser Di-
' visionen einmal = 0 ist (d.h. die Division geht auf), so handelt es sich
' nicht um eine Primzahl
'
' (c) Thomas Antoni, 05.04.99 - 27.04.99
'***************************************************************************

'---------------- Kopf- und Fuzeile ausgeben -------------------------------
WIDTH 80, 50                          'Bildschirm mit 50 Zeilen, je 80 Spalten
COLOR 0, 7                            'schwarze Schrift auf hellgrauem Grund
CLS
COLOR 15, 4                           'Kopf-/ Fuzeile wei auf rot
PRINT "                     Primzahlen von 1 bis 4350                                  ";
LOCATE , 70
PRINT Datum$
COLOR 0, 7                            'wieder schwarz hellgrau
LOCATE 3
PRINT " 1"
PRINT " 2"
y% = 4
x% = 1

FOR i% = 3 TO 4350 STEP 2              'zu betrachtender Zahlenbereich
  FOR n% = 3 TO SQR(i%)
    IF (i% MOD n%) = 0 THEN GOTO nexti 'ohne Rest teilbar ==> keine Primzahl
  NEXT n%
  y% = y% + 1                          'keine Teilbarkeit ==> i% ist Primzahl
  IF y% = 49 THEN                      'Spalte vollgeschrieben ==> nchste
    y% = 3                             'Spalte um 7 Zeichen versetzt
    x% = x% + 6
  END IF
  LOCATE y%, x%
  PRINT i%
nexti:
NEXT i%

CALL EndeEsc(50)                       'Beenden-Zeile mit Drehbalken ausgeben
END SUB

SUB Primzerl
'****************************************************************************
'Subroutine Primzerl": Primfaktorzerlegung einer Zahl z bis 2*10^9
'==================================================================
'Alle Zahlen i bis zur Wurzel aus z werden nach dem in der Subroutine
'PRIMZAHL beschriebenen Algorithmus daraufhin abgeprft, ob Sie eine Primzahl
'sind. Wenn ja, wird festgestellt, ob und wie oft z durch durch i teilbar ist
'und das Ergebnis auf den Bildschirm ausgegeben. z wird gleich entsprechende
'Male durch i geteilt, so da in z& immer die noch unzerlegte Restmenge
'darstellt.
'Ist diese Restmenge auf "1" zusammengeschmolzen, so ist die Primfaktor-
'zerlegung fertig.
'
'__WICHTIG__: Ebenso ist die Primfaktorzerlegung fertig,
'wenn die gerade betrachtete Zahl i kleiner als die Wurzel der Restmenge z&
'ist: In diesem Fall ist die Restmenge selbst eine Primzahl und gehrt somit
'der Primfaktorzerlegung an. Dies war fr den Programmierer nicht leicht zu
'erkennen!!
'
'Whrend des Rechenlaufes wird ein Fortschrittsbalken d. Lnge (i&^2/Eingabe-
'zahl * 100%) ausgegeben mit Hilfe der Subroutine ProgressBar
'
'Erforderliche Rechenzeit fr .BAS-Programm auf Pentium 100 MHz im Worst Case
'(1999073521=44711^2): ca. 32 sec
'
' (c) T.Antoni, 11.5.99 - 17.05.99
'****************************************************************************

pze000:
COLOR 0, 7                          'schwarze Schrift auf hellgrauem Grund
WIDTH 80, 25                        'normaler Textmodus: 80 Spalten, 25 Zeilen
CLS                                 'Bildschirm rcksetzen

'========= Ausgabe der Kopfzeile und Eingabe der Zahl z =====================
COLOR 15, 4                         'Titelzeile: weie Schrift, roter Grund
PRINT "   Primfaktorzerlegung einer Zahl im Bereich 1 ... 2 * 10^9                     ";
LOCATE , 70
PRINT Datum$
COLOR 0, 7

LOCATE 6
PRINT " Gib die in Primfaktoren zu zerlegende Zahl ein: "
x# = dialogzahl#(4, "z =")
IF x# = ungueltig OR x# < 1 OR x# > 2000000000 THEN GOTO pze110
                                    'ungltige Eingabe oder z liegt auerhalb
                                    'der Grenzen
z& = x#                             'Typwandlung DOUBLE ==> LONG
eingabezahl& = z&                   'Eingegebene Zahl merken (fr ProgressBar)
CALL ProgressBar(0)                 'Fortschrittsbalken initialisieren

'================ z durch Primzahlen n& bis z/2 teilen ======================
zistprim% = 1                       'Vorbesetzung "z ist Primzahl"
erstprint% = 1                      'Vorbesetzung "erste Bildschirmausgabe"

FOR n& = 1 TO SQR(z&)               'Es brauchen nur die ungeraden Zahlen bis
                                    'Wurzel z& betrachet zu werden (z&
                                    'schmilzt u.U. im Laufe der Zerlegung
                                    '(siehe unten) nur ungerade Zahlen knnen
                                    'Primzahlen sein
  IF n& = 1 THEN i& = 2:  ELSE i& = n& 'Ausnahme: auch 2 ist Primzahl

'-------------- prfen ob i& Primzahl ist (siehe SUB Primzahl) --------------
  iistprim% = 1                       'Vorbesetzung "i& ist Primzahl"
  IF i& > 2 THEN                      '2 ist sowieso Primzahl
    FOR k& = 3 TO SQR(i&) STEP 2      'alle ungeraden Zahlen bis Wurzel i& ..
      IF (i& MOD k&) = 0 THEN iistprim% = 0
    NEXT k&                           '..prfen, ob i& dadurch teilbar
  END IF

  IF iistprim% = 1 THEN

'-------------- Fortschrittsbalken und eventuellen Abbruch bearbeiten -------
    zf% = zf% + 1                     'Fortschrittsbalken im Interesse der
    IF zf% > 7 THEN                   'Rechengeschwindigkeit nur jedes 8.
      zf% = 0                         'mal bearbeiten
      CALL ProgressBar((i& ^ 2 / eingabezahl&) * 100)'erledigten Prozentanteil
                                      'am Fortschrittsbalken anzeigen
      IF INKEY$ = CHR$(27) THEN           'bei Esc-Taste abbrechen + Neueingabe
        COLOR 0, 7
        LOCATE 2
        FOR i% = 2 TO 22
         PRINT SPACE$(80)                'Bildschirm ab Zeile 2 lschen
        NEXT i%
        GOTO pze000
      END IF
    END IF

'-------------- prfen und anzeigen, wie oft z& durch die Primzahl ----------
'-------------- i& teilbar ist                                     ----------
    potenz% = 0                       'Vorbesetzg.: z& keinmal durch i& teilb.

    WHILE (z& MOD i&) = 0          'z& ohne Rest durch i& teilbar
      zistprim% = 0                   'z& ist keine Primzahl
      z& = z& / i&                    'Noch zu zerlegende Restmenge von z&
      potenz% = potenz% + 1           'sooft ist z& durch i& teilbar
    WEND

    IF potenz% > 0 THEN               'ist z& durch i& teilbar?
      IF erstprint% = 1 THEN          'handelt es sich um die erste Ausgabe?
        erstprint% = 0
        LOCATE 18
        PRINT " Die Primfaktorzerlegung lautet:"
        LOCATE , 4
        COLOR 15, 2                   'Ergebnis wei auf grn darstellen
        PRINT " z =";                 'bei Erstausgabe fhrendes "z=" ausgeben
      ELSE
        COLOR 15, 2                   'Ergebnis wei auf grn darstellen
        PRINT "*";                    'ansonsten fhrendes Multipl.zeichen
      END IF
      IF potenz% = 1 THEN
        PRINT " "; i&; " ";           'einmal teilbar => kein Potenzzeichen"
      ELSE
        PRINT " "; i&; "^"; potenz%; " "; 'mehrmals teilbar => ^Potenz anzeigen
      END IF
      IF z& = 1 THEN GOTO pze120      'Zerlegung fertig, wenn Restmenge =1
    END IF

  END IF
NEXT n&

IF zistprim% = 0 THEN           'Eingabezahl war mindestens einmal teilbar,
  COLOR 15, 2
  PRINT "* "; z&;               'aber Restmenge durch keine Primzahl bis Wur-
                                'zel (Restmenge) teilbar ==> Restmenge ist
                                'selbst eine Primzahl u. gehrt z.Zerlegung
                                'Ergebnis wei auf grn darstellen

'===================== z& ist Primzahl ==> entspr. Bildschirmausgabe ========
ELSE
  LOCATE 19, 4
  COLOR 15, 2                   'Ergebnis wei auf grn darstellen
  PRINT " z ist eine Primzahl und nur durch 1 und sich selbst teilbar !!! ";                 'bei Erstausgabe fhrendes "z=" ausgeben
END IF
GOTO pze120

'================ Abbruch bei ungltiger oder mehrzeiliger Eingabe ==========
pze110:
LOCATE 19, 4
COLOR 15, 2                     'Meldung wei auf grn darstellen
PRINT " Fehlerhafte Eingabe:  z < 1  oder  z > 2 000 000 000 !!! ";

'============= Schludialog: Beenden oder Wiederholen ========================
pze120:
COLOR 0, 7
LOCATE 24, 1                    'eventuellen Fortschr.balken lschen
PRINT SPC(79); " ";
BEEP                            'Piepston zur Fertigmeldung
LOCATE 25, 1
IF Neu1Ende0%(25) = 1 THEN GOTO pze000

END SUB

SUB ProgressBar (prozent%)
'***************************************************************************
' Subroutine ProgressBar
' ----------------------
' Gibt einen Fortschrittsbalken in Zeile 24,25 aus, deren Lnge durch den
' bergabeparameter prozent% (0...100) vorgegeben wird (je 2% =ein Zeichen).
' Vor der erstmaligen Nutzung des Progess Bars mu die Subroutine mit dem
' Aufruf ProgressBar(0) initialisiert werden.
'
' Die Cursorposition wird durch die SUB nicht verndert: Die vor dem Aufruf
' der SUB bestehende Cursorposition wird abgespeichert und vor Verlassen der
' SUB wieder restauriert.
'
' Der Progress Bar bentigt nur 2 Bildschirmzeilen, ist also sehr platz-
' sparend!
'
' (c) T.Antoni, 10.5.99 -17.05.99
'***************************************************************************

zeile% = CSRLIN                    'Cursorsposition abspeichern (merken)
spalte% = POS(0)

IF prozent% = 0 THEN               'Fortschrittsbalken initialisieren
  LOCATE 24, 1
  COLOR 15, 4                      'wei auf rot
  PRINT " Berechne... "; STRING$(50, ""); "  Abbruch: Esc   ";
  LOCATE 25, 1
  PRINT "             "; STRING$(50, ""); "                 ";
ELSE
  COLOR 2, 4
  IF prozent% >= 100 THEN prozent% = 99
  balkenlaenge% = INT(prozent% / 2) + 1
  LOCATE 24, 14
  PRINT STRING$(balkenlaenge%, "");
  LOCATE 25, 14
  PRINT STRING$(balkenlaenge%, "");
END IF

LOCATE zeile%, spalte%             'alte Cursorsposition restaurieren
COLOR 0, 7                         'alte Farbe ebenso (sw auf hellgrau)
END SUB

