'***************************************************************************
'
' MenuMous.bas - Menue mit Mausbedienung fuer QBasic im Textmodus
' ==========================================================================
' Der verwendete Maustreiber stammt von einem unbekannten Autor und eignet
' sich im Prinzip fuer alle SCREENS.
'
' Achtung: Bei Verwendung von QuickBasic 4.5 bzw. 7.1 muss die QuickLibrary
' ~~~~~~~~ eingebunden werden (Entwicklungsumgebung starten mit "QB.EXE /L"
'          bzw. "QBX.EXE /L" ; wegen des Befehls CALL ABSOLUTE))
'
'
'   \         (c) Thomas Antoni, 1.11.02 - 1.11.02
'    \ /\           Mailto:thomas@antonis.de
'    ( )            www.antonis.de  --- www.qbasic.de
'  .( o ).
'              ----==== Hottest QBasic Stuff on Earth !!! ====----
'
'***************************************************************************

'-------------------------- Maus-Routinen ----------------------------------
DECLARE SUB MouseDriver (AX%, bx%, CX%, DX%)
   'Maustreiber, wird nur von anderen SUBs, nicht v. Hauptprogr. aufgerufen
DECLARE SUB MouseHide ()
   'Mauszeiger unsichtbar machen
DECLARE FUNCTION MouseInit% ()
   'Maus initialisieren, liefert -1 zurck, wenn Maus gefunden
DECLARE SUB MousePut (X%, y%)
   'Mauszeiger an den Koordinaten X%/Y% anzeigen
DECLARE SUB MouseShow ()
   'Mauszeiger in der Bildschirm-Mitte sichbar machen
DECLARE SUB MouseStatus (LB%, RB%, Xmouse%, Ymouse%)
   'Tasten-Status und Mauskoordinaten abfragen  (LB% / RB% = -1 wenn
   'Linke / Rechte Maustaste gedrckt)

'---------- Maschinensprache-Code fuer Maustreiber erstellen ----------------
DIM SHARED mouse$
RESTORE
mouse$ = SPACE$(57) 'Maschinensprache-Code als String in mouse$ ablegen
FOR I% = 1 TO 57
  READ A$
  H$ = CHR$(VAL("&H" + A$))
  MID$(mouse$, I%, 1) = H$
NEXT I%
'Maschinensprache-Befehle (57 Bytes)
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00


'--------- Maus initialisieren und anzeigen, ob Maus gefunden --------------
CLS
MS% = MouseInit%
IF MS% THEN
  PRINT " Maus gefunden und initialisiert"
  PRINT " ... weiter mit beliebiger Taste"
  DO: LOOP WHILE INKEY$ = ""
ELSE
  PRINT "Maus nicht gefunden": SLEEP: END
END IF

'-------- Mauszeiger in Bildschirm-Mitte anzeigen --------------------------
MouseShow

'-------- Menue anzeigen ---------------------------------------------------
DO
CLS
COLOR 15, 1   'weiss auf blau
PRINT
LOCATE 3, 5: PRINT "[ Aufraeumen    ]"
LOCATE 4, 5: PRINT "[ Schlafen      ]"
LOCATE 5, 5: PRINT "[ Ins Kino gehen]"
LOCATE 6, 5: PRINT "[ Maus testen   ]"
LOCATE 7, 5: PRINT "[ Beenden       ]"
COLOR 15, 0   'wieder wei auf schwarz
PRINT
PRINT " Klicke auf die gewuenschte Funktion"

'-------- Warten bis die linke Maustaste aufs Menuefeld klickt -------------
DO
  CALL MouseStatus(LB%, RB%, Xmouse%, Ymouse%)
  xt% = Xmouse% / 8 + 1        'Pixelkoordinaten in Textkoordinaten umrechnen
  yt% = Ymouse% / 8 + 1
LOOP UNTIL LB% AND xt% > 4 AND xt% < 22 AND yt% > 2 AND yt% < 8
  'Schleife wiederholen bis linke Maustaste bettigt und Maus-Cursor sich
  'innerhalb des Menuefeldes befindet (Spalte 5-21 und Zeile 3-7)

'-----------  Menue abhaengig von der angeklicken Zeile bearbeiten -----------------
  SELECT CASE yt%
    CASE 3: CLS : PRINT " Du hast Aufraeumen gewhlt"
    CASE 4: CLS : PRINT " Du hast Schlafen gewhlt"
    CASE 5: CLS : PRINT " Du hast Ins Kino gehen gewaehlt"
 
'---- Maus testen u.Testergebnisse zyklisch anzeigen ----
    CASE 6
      CLS
      DO
        CALL MouseStatus(LB%, RB%, Xmouse%, Ymouse%)
        LOCATE 5, 1
        PRINT "Maus-Test ... beenden mit beliebiger Tastatur-Taste"
        PRINT
        PRINT "  Linke Maustaste: "; LB%, "Rechte Maustaste: "; RB%
        PRINT "  X-Position: "; Xmouse%, "Y-Position: "; Ymouse%
      LOOP WHILE INKEY$ = ""

'---- Beenden -----------------------------
     CASE 7
       CLS
       END      'Programmabbruch

   END SELECT

'------------ Wiederholen/Beenden-Dialog ----------------------------------
LOCATE 24, 12
COLOR 15, 1                                 'weiss auf blau
PRINT "  Zum Menue [beliebige Tastatur-Taste]    Beenden [Esc] ";
COLOR 15, 0                                 'wieder wei auf schwarz
DO: taste$ = INKEY$: LOOP WHILE taste$ = "" 'Warten auf Tastenbetaetigung
IF taste$ = CHR$(27) THEN CLS : END         'Beenden mit Esc
LOOP                                        'Ruecksprung zum "Menue anzeigen"

SUB MouseDriver (AX%, bx%, CX%, DX%)
'----------------------- Maustreiber aufrufen ------------------------------
DEF SEG = VARSEG(mouse$)
  mouse% = SADD(mouse$)
  CALL Absolute(AX%, bx%, CX%, DX%, mouse%)
END SUB

SUB MouseHide
'----------------- Mauszeiger unsichtbar machen -----------------------------
 AX% = 2
 CALL MouseDriver(AX%, 0, 0, 0)
END SUB

FUNCTION MouseInit%
'----------- Maus initialisieren ----------------------------------------
AX% = 0
  CALL MouseDriver(AX%, 0, 0, 0)
  MouseInit% = AX% '-1 falls Maus gefunden, 0 falls Maus nicht gefunden
END FUNCTION

SUB MousePut (X%, y%)
'------------ Mauszeiger auf die Koordinaten X%/Y% setzen  -----------------
  AX% = 4
  CX% = X%
  DX% = y%
  CALL MouseDriver(AX%, 0, CX%, DX%)
END SUB

SUB MouseShow
'----------------- Mauszeiger in Bildschirmmitte sichbar machen -------------
AX% = 1
  CALL MouseDriver(AX%, 0, 0, 0)
END SUB

SUB MouseStatus (LB%, RB%, Xmouse%, Ymouse%)
'---------------- Mausposition und Tastenstatus ermitteln ------------------
AX% = 3
  MouseDriver AX%, bx%, CX%, DX%
  LB% = ((bx% AND 1) <> 0) '-1 / 0 = linke Taste gedrueckt / nicht gedrueckt
  RB% = ((bx% AND 2) <> 0) ' dito fuer rechte Maustaste
  Xmouse% = CX%
  Ymouse% = DX%
END SUB

