'***************************************************************************
' MouseDeu.bas - Maustreiber fuer QBasic und QuickBasic fuer alle SCREENs
' ==========================================================================
' Dieser Maustreiber stammt von einem unbekannten Programmierer. Er eignet
' sich im Prinzip fuer alle SCREENS inklusive den Textbildschirm SCREEN 0.
' Ausfuehrliche deutsche Kommentare eingefuegt von Thomas Antoni
'
'
'   \         (c) Thomas Antoni, 1.11.02 - 4.11.02
'    \ /\           Mailto:thomas@antonis.de
'    ( )            www.antonis.de  --- www.qbasic.de
'  .( o ).
'              ----==== Hottest QBasic Stuff on Earth !!! ====----
'
'***************************************************************************

'-------------------------- Maus-Routinen ----------------------------------
DECLARE SUB MouseDriver (AX%, bx%, CX%, DX%)
   'Maustreiber, wird nur von anderen SUBs, nicht v. Hauptprogr. aufgerufen
DECLARE SUB MouseHide ()
   'Mauszeiger unsichtbar machen
DECLARE FUNCTION MouseInit% ()
   'Maus initialisieren, liefert -1 zurueck, wenn Maus gefunden
DECLARE SUB MousePut (X%, Y%)
   'Mauszeiger an den Koordinaten X%/Y% anzeigen
DECLARE SUB MouseShow ()
   'Mauszeiger in der Bildschirm-Mitte sichtbar machen
DECLARE SUB MouseStatus (LB%, RB%, Xmouse%, Ymouse%)
   'Tasten-Status und Mauskoordinaten abfragen  (LB% / RB% = -1 wenn
   'Linke / Rechte Maustaste gedrueckt)

'---------- Maschinensprache-Code fuer Maustreiber erstellen ----------------
DIM SHARED mouse$
RESTORE
mouse$ = SPACE$(57) 'Maschinensprache-Code als String in mouse$ hinterlegen
FOR I% = 1 TO 57
  READ A$
  H$ = CHR$(VAL("&H" + A$))
  MID$(mouse$, I%, 1) = H$
NEXT I%
'Maschinensprache-Befehle (57 Bytes)
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

'--------- Maus initialisieren und anzeigen, ob Maus gefunden --------------
CLS
MS% = MouseInit%
IF MS% THEN
  PRINT "Maus gefunden und initialisiert"
ELSE
  PRINT "Maus nicht gefunden": SLEEP: END
END IF

'-------- Mauszeiger in Bildschirm-Mitte anzeigen --------------------------
MouseShow

'-------- Maus testen und Status anzeigen -----------------------------------
DO
  CALL MouseStatus(LB%, RB%, Xmouse%, Ymouse%)
  LOCATE 5, 1
  PRINT "Maus-Status-Anzeige ...... Beenden mit beliebiger Tastatur-Taste"
  PRINT
  PRINT "Linke Maustaste: "; LB%, "Rechte Maustaste: "; RB%
  PRINT "X-Position: "; Xmouse%, "Y-Position: "; Ymouse%
LOOP WHILE INKEY$ = ""

SUB MouseDriver (AX%, bx%, CX%, DX%)
'----------------------- Maustreiber aufrufen ------------------------------
DEF SEG = VARSEG(mouse$)
  mouse% = SADD(mouse$)
  CALL Absolute(AX%, bx%, CX%, DX%, mouse%)
END SUB

SUB MouseHide
'----------------- Mauszeiger unsichtbar machen -----------------------------
 AX% = 2
 CALL MouseDriver(AX%, 0, 0, 0)
END SUB

FUNCTION MouseInit%
'----------- Maus initialisieren ----------------------------------------
AX% = 0
  CALL MouseDriver(AX%, 0, 0, 0)
  MouseInit% = AX% '-1 falls Maus gefunden, 0 falls Maus nicht gefunden
END FUNCTION

SUB MousePut (X%, Y%)
'------------ Mauszeiger auf die Koordinaten X%/Y% setzen  -----------------
  AX% = 4
  CX% = X%
  DX% = Y%
  CALL MouseDriver(AX%, 0, CX%, DX%)
END SUB

SUB MouseShow
'--------------- Mauszeiger in Bildschirmmitte sichtbar machen -------------
AX% = 1
  CALL MouseDriver(AX%, 0, 0, 0)
END SUB

SUB MouseStatus (LB%, RB%, Xmouse%, Ymouse%)
'---------------- Mausposition und Tastenstatus ermitteln ------------------
AX% = 3
  MouseDriver AX%, bx%, CX%, DX%
  LB% = ((bx% AND 1) <> 0) '-1 / 0 = linke Taste gedrueckt / nicht gedrueckt
  RB% = ((bx% AND 2) <> 0) ' dito fuer rechte Maustaste
  Xmouse% = CX%
  Ymouse% = DX%
END SUB

