DECLARE FUNCTION Intext$ (length%)
DECLARE FUNCTION Passwrd$ (length%)
'****************************************************************************
' PASSWRD.BAS = QBasic-Function zur Passworteingabe definierter Lnge
' ===========================================================================
' Komfort-Version mit einem farbigen Eingabefeld begrenzter Lnge fr das
' Passwort. Das Hauptprogramm stellt lediglich einen "Testrahmen" zur
' Demonstration der Function Passwrd$ dar und mu vom Anwender individuell
' angepat werden.
'
'
'   \         (c) Thomas Antoni, 12.07.99 - 5.11.02
'    \ /\           Mailto:thomas@antonis.de
'    ( )            http://www.antonis.de  
'  .( o ).
'              ----==== Hottest QBasic Stuff on Earth !!! ====----
'
'****************************************************************************

DO
  CLS
  LOCATE 4
  PRINT "  -----===== Willkommen zu Passwrd4! =====-----"
  PRINT
  PRINT "  Gib das Passwort ein (max 14 Zeichen):"
  LOCATE 9, 8
'-------------------------
  eingabe$ = Passwrd$(14)
'-------------------------
  COLOR 15, 0        'Farbe wieder Wei auf Schwarz
  LOCATE 15, 2
  IF eingabe$ = CHR$(27) THEN
    PRINT "Du hast die Eingabe mit Esc abgebrochen, und es wurde CHR(27) zurckgeliefert"
  ELSE
    PRINT "Du hast folgendes eingegeben:"
    LOCATE 17, 8
    PRINT eingabe$
  END IF
  LOCATE 20, 2
  PRINT "Wiederholung mit beliebiger Taste, Abbruch mit Esc"
  DO: taste$ = INKEY$
  LOOP WHILE taste$ = ""
LOOP WHILE taste$ <> CHR$(27)
  CLS
  LOCATE 12, 8
  PRINT "Danke, da Du Passwrd$ ausprobiert hast!"
  SLEEP 1
END

FUNCTION Passwrd$ (length%)
'*****************************************************************************
' Passwrd$ (length%) - QBasic Funktion zur Passwort-Eingabe
' ============================================================================
' Diese Funktion ersetzt den INPUT-Befehl und ermglicht eine Passwort-
' Eingabe mit whlbarer Maximallnge. Die eingebenen Zeichen werden als
' Sternchen angezeigt.
' Die Funktion liefert maximal length% alphanumerische Text-Zeichen zurck,
' die ber die Tastatur eingeben werden knnen. Die Tastatureingabe wird
' mit der Enter-Taste abgeschlossen. Ein Editieren des Eingabetextes ist
' mit der Backspace-Taste mglich. ber die Esc-Taste lt sich eine Eingabe
' abbrechen; in diesem Falle liefert Intext den Wert   CHR(27) zurck (ASCII-
' Code von Esc).
' Die Cursortasten sowie Delete, Home und End werden nicht ausgewertet.
' Das Eingabefeld erscheint als blauer Kasten auf den Bildschirm. Das Echo
' der eingegebenen Zeichen erfolgt in Form von Sternchen.
'
' Das aufrufende Programm ist dafr verantwortlich
'   - den Cursor vor dem Aufruf richtig zu setzen (z.B. mit LOCATE)
'   - nach Abschlu der Funktion die alten Bildschirmfarben wiederher-
'     zustellen
'   - den Abbruch der Eingabe durch die Esc-Taste zu bearbeiten (in diesem
'     Fall ist der Rcklieferwert CHR$(27) )
'   - Die Reaktion auf ein falsch oder richtig eingegebenes Passwort anzu-
'     stoen
'   - Das ndern des Passworts in einem Dialog zu offerieren.
'
' (c) Thomas Antoni, 12.07.99 - 05.11.02
'****************************************************************************

COLOR 14, 3 'gelb auf cyan
begin% = POS(0): row% = CSRLIN           'Cursorposition Spalte/Zeile sichern
text$ = "": key$ = ""

DO
'------------------ Enter- und Esc-Taste bearbeiten -------------------------
  IF key$ = CHR$(13) THEN EXIT DO        'Ende wenn Enter bettigt
  IF key$ = CHR$(27) THEN                'bei Abbruch ASCII-Zeichen von Esc
    text$ = CHR$(27)                     'zurckliefern
    EXIT DO
  END IF

'------------------------ Backspace-Taste bearbeiten ------------------------
  IF key$ = CHR$(8) AND LEN(text$) > 0 THEN  'Backspace und Textlnge > 0 ?
    text$ = LEFT$(text$, LEN(text$) - 1)     'Text um 1 Zeichen krzen

'-------------------------- andere Tasten bearbeiten ------------------------
  ELSEIF key$ > CHR$(29) AND key$ < CHR$(255) THEN 'alfanum. Taste?
    IF LEN(text$) = length% THEN             'Text hat schon die volle Lnge
      text$ = LEFT$(text$, LEN(text$) - 1) + key$ 'letztes Zeichen austauschen
    ELSE
      text$ = text$ + key$                   'ansonsten Tastenzeichen anfgen
    END IF
  END IF
'--------------- Sternchen und Cursor auf Bildschirm ausgeben ---------------
  LOCATE row%, begin%: PRINT SPACE$(length%); 'Eingabefeld lschen/blau frben
  LOCATE , begin%: PRINT STRING$(LEN(text$), "*");               'Text ausgeben
  IF LEN(text$) < length% THEN csrpos% = POS(0) ELSE csrpos% = POS(0) - 1
  LOCATE row%, csrpos%, 1, 1         'Cursor in Pixelzeilen 0-3 der darunter-
                                     'liegenden Zeile blinkend ausgeben
  DO: key$ = INKEY$: LOOP WHILE key$ = ""     'warten bis Taste bettigt
LOOP
LOCATE , , 0                         'Cursor wieder deaktivieren
Passwrd$ = text$
END FUNCTION

