DECLARE SUB intro ()
'---------- Deklaration der Subroutinen (Unterprogramme) --------------------
DECLARE SUB Bounce ()           ' )
DECLARE SUB LoadArena ()        ' )
DECLARE SUB Controls ()         ' ) ----------- Bounce-Bildschirmschoner
DECLARE SUB BuildTables ()      ' )
DECLARE SUB AssembleArena ()    ' )
DECLARE SUB Hilfe ()                           'Hilfetext anzeigen
DECLARE SUB Spread (Text$, Row%, Col%, Delay!) 'Text aus der Mitte heraus-
                                               'wachsen lassen
'****************************************************************************
'
' PI-RECHN.BAS - Berechnung von Pi nach der Monte-Carlo-Methode
' ==================================================================
' QBasic-Programm zur Berechnung der Zahl Pi nach der Zufallsmethode:
' Zunchst wird ein Quadrat und dessen Innenkreis auf den Bildschirm gezeich-
' net. Dann erzeugt das Programm "Zufallstropfen" (Pixel) zuflliger Farbe,
' die in das Quadrat "regnen". Die Tropfen werden in der Variablen n gezhlt.
' Liegt ein Tropfen im Inkreis, so wird zustzlich die Variable k um "1"
' erhht. Die Zahl Pi ergibt sich aus der Formel   Pi = 4k / n
'
'  c) Marc Antoni 22.09.00 - 05.10.00
'       marc@antonis.de
'       http://www.antonis.de
'
'****************************************************************************

'--- Globale anwenderdefinierte Felder + Variable fr Bounce deklarieren ----

TYPE type3d
        X AS INTEGER
        Y AS INTEGER
        z AS INTEGER
END TYPE

TYPE Connect
        a AS INTEGER
        B AS INTEGER
END TYPE

TYPE move3d
        X AS INTEGER
        Y AS INTEGER
        z AS INTEGER
        xdir AS INTEGER
        ydir AS INTEGER
        zdir AS INTEGER
        Col AS INTEGER
END TYPE

COMMON SHARED Max%
Max% = 100                                 'Anzahl Blle fr Bounce
DIM SHARED p(0 TO Max%) AS move3d
DIM SHARED Arena(0 TO 7) AS type3d
DIM SHARED Drawlist(12) AS Connect
DIM SHARED WorldAngle%, speed%

DIM SHARED cost(360) AS SINGLE
DIM SHARED sint(360) AS SINGLE

'---------------------- (1) Start Hauptprogramm -----------------------------
CALL intro
SCREEN 12            'VGA-Bildschirm 640 x 480 x 16 Farben
anz& = 10000         'Vorbesetzung der Tropfenzahl

DO                   'Beginn der Dauerschleife
neubild:             'Sprungmarke
WIDTH 80, 60 '80 Spalten und 60 Zeilen fr Texte
VIEW                 'Koordinatenverschiebung rckgngig machen
CLS

'------------------------- (2) Mentexte anzeigen ---------------------------
COLOR 9
LOCATE 3, 1          'Textcursor auf Zeile 2, Spalte 1 setzen
PRINT "                                                          "
PRINT "                          "
PRINT "                                               "
PRINT "                                              "

CALL Spread("nach der Monte Carlo - Methode  (c) Marc Antoni, 2000", 8, 40, 4)
SLEEP 1
COLOR 11                                 'Farbe Helltrkis
LOCATE 40, 55: PRINT "[Leertaste]"
LOCATE 41, 55: PRINT "  "
LOCATE 42, 55: PRINT "   Neustart";

LOCATE 44, 55: PRINT "[Enter]"
LOCATE 45, 55: PRINT "  "
LOCATE 46, 55: PRINT "   Tropfenzahl ndern";

LOCATE 48, 55: PRINT "[F1]"
LOCATE 49, 55: PRINT "  "
LOCATE 50, 55: PRINT "   Hilfe"

LOCATE 52, 55: PRINT "[F2]"
LOCATE 53, 55: PRINT "  "
LOCATE 54, 55: PRINT "   Bildschirmschoner"

LOCATE 56, 55: PRINT "[Esc]"
LOCATE 57, 55: PRINT "  "
LOCATE 58, 55: PRINT "   Programm beenden";

'-------------------- (3) Kreis und Viereck Zeichnen ------------------------
VIEW (10, 74)-(639, 479)      'Koordinatenverschiebung: (x=10|y=75) ==> (0|0)
                              'alle knftigen Zeichenbefehle beziehen sich auf
                              'diese neuen Pixelkoordinaten

FOR i% = 0 TO 200 STEP 1      'Quadrat ploppt animiert auf
  LINE (200 - i%, 200 - i%)-(200 + i%, 200 + i%), 10, B
  LINE (200 - i%, 200 - i%)-(200 + i%, 200 + i%), 0, B
NEXT i%

CIRCLE (200, 200), 200, 12    'Kreis mit M(x|y), r=200, Farbe 12=hellrot
LINE (0, 0)-(400, 400), 10, B 'Quadrat zwischen (x1|y1) und (x2|y2)
                              'Farbe 10 = grn
k& = 0                   'Anzahl i.d. Kreis gefall. Tropfen inititialisieren
RANDOMIZE TIMER          'Zufallsgenerator initialisieren

'------------------- (4) Zufallspixel erzeugen in Schleife ------------------
FOR n& = 1 TO anz&
  X% = INT(RND * 401)    'x-Koordinate = Zufallszahl zwischen 0 und 400
  Y% = INT(RND * 401)    'y-Koordinate = dito
  f% = INT(RND * 15) + 1 'Zufallsfarbe 1-15 (ohne schwarz=0)
  PSET (X%, Y%), f%      'Zufallspunkt zeichnen
     
'------- (5) ermitteln, ob Tropfen im Kreis liegt und Pi berechnen  ---------
  z& = (X% - 200) ^ 2 + (Y% - 200) ^ 2   'Abstand M_P des Tropfens vom Kreis-
  mp! = SQR(z&)                          'mittelpunkt nach Pythagoras
  IF mp! < 200.5 THEN k& = k& + 1        'Tropfen im Kreis ==> Zhler erhhen
  pi! = (4 * k&) / n&

'-------------------- (6) Tropfenzahl und Pi anzeigen -----------------------
  COLOR 10: LOCATE 16, 55: PRINT n&;
  COLOR 11: PRINT "von"; anz&; "Tropfen"
  COLOR 10: LOCATE 18, 55: PRINT k&;
  COLOR 11: PRINT "Tropfen im Kreis "
  LOCATE 20, 56: PRINT "Pi_berechnet=";
  COLOR 10: PRINT USING " #.######"; pi!  'Pi mit 1 Vor- und 6 Nachkommastell.
  COLOR 11: LOCATE 22, 56: PRINT "Pi_tatschl.= 3.141593"

'------------------- (7) Tastenabfrage und -Bearbeitung ---------------------
  Taste$ = INKEY$
  SELECT CASE Taste$            'Verzweigung abhngig von d.bettigt.Taste
    CASE CHR$(32)               'Leertaste -> Nochmal tropfen lassen
      GOTO neubild
   CASE CHR$(13)                'Enter bettigt -> Tropfenzahl-Eingabe
      VIEW: CLS : LOCATE 28, 5
      INPUT "Gib die Anzahl der Pixel ein (1...2 000 000 000): "; anz&
      GOTO neubild
    CASE CHR$(0) + CHR$(59)      'F1-Taste bettigt
      CALL Hilfe                 'Hilfetext anzeigen
      GOTO neubild
    CASE CHR$(0) + CHR$(60)      'F2-Taste bettigt
      CALL Bounce                'Bildschirmschoner starten
      SCREEN 12                  'VGA-Bildschirm reaktivieren
      GOTO neubild
    CASE CHR$(27)                'Esc-Taste bettigt
      VIEW: CLS                  'Koord.verschiebg. rckgngig, Bild lschen
      COLOR 14                   'Farbe gelb
      LOCATE 27, 32: PRINT "..... und Tsch"
      SLEEP 1                    '1 sec warten
      CALL Spread("Besuchen Sie meine Homepage  http://www.antonis.de !!", 32, 40, 4)
      SLEEP 1                    '1 sec warten
      END                        'Programm verlassen
  END SELECT
NEXT n&                          'nchsten Tropfen bearbeiten
BEEP                             'Piepston
SLEEP 6                          '6 sec warten
LOOP                             'Rcksprung zum Beginn der Dauerschleife

'----------------- Konstanten fr Bounce-Bildschirmschoner ------------------
BoxData:
DATA 110,50,50, 210,50,50, 110,150,50, 210,150,50
DATA 110,50,-50, 210,50,-50, 110,150,-50, 210,150,-50
ConnectData:

'front face connects
DATA 1,2, 3,4, 1,3, 2,4
'back face connects
DATA 5,6, 7,8, 5,7, 6,8
'interplane connects
DATA 1,5, 2,6, 3,7, 4,8

SUB AssembleArena
'--------------------------- fr Bounce-Bildschirmschoner -------------------
    FOR X% = 0 TO 11
        ptr1% = Drawlist(X%).a
        ptr2% = Drawlist(X%).B
        LINE (Arena(ptr1%).X + cost(WorldAngle%) * Arena(ptr1%).z, Arena(ptr1%).Y + sint(WorldAngle%) * Arena(ptr1%).z)-(Arena(ptr2%).X + cost(WorldAngle%) * Arena(ptr2%).z, Arena(ptr2%).Y + sint(WorldAngle%) * Arena(ptr2%).z), 31
    NEXT
END SUB

SUB Bounce
'--------------------------- Bounce-Bildschirmschoner -----------------------
' 3D Bouncer, written by Luke Molnar
' Another program from
' http://members.aol.com/mkwebsite/index.html

RANDOMIZE TIMER
'$DYNAMIC

CONST pi = 3.141592
DEFINT A-Z

' Max% = 10     'Anzahl der Blle
' CLS
SCREEN 7
CLS
LOCATE 14, 3: COLOR 1: PRINT "Optionen-Einstellung mit ? - Taste"
SLEEP 2

WorldAngle% = 0
speed% = 2

' Initialize the points.
FOR X% = 0 TO Max%
        p(X%).X = INT(RND * 99) + 1 + 110
        p(X%).Y = INT(RND * 99) + 1 + 50
        p(X%).z = INT(RND * 49) + 1 - INT(RND * 49) + 1
       
        IF X% MOD 3 = 0 THEN
                IF INT(RND * 2) + 1 = 1 THEN p(X%).xdir = 1 * (INT(RND * 3) + 1) ELSE p(X%).xdir = -1 * (INT(RND * 3) + 1)
                p(X%).Col = 1
        END IF
        IF X% MOD 3 = 1 THEN
                IF INT(RND * 2) + 1 = 1 THEN p(X%).ydir = 1 * (INT(RND * 3) + 1) ELSE p(X%).ydir = -1 * (INT(RND * 3) + 1)
                p(X%).Col = 5
        END IF
        IF X% MOD 3 = 2 THEN
                IF INT(RND * 2) + 1 = 1 THEN p(X%).zdir = 1 * (INT(RND * 3) + 1) ELSE p(X%).zdir = -1 * (INT(RND * 3) + 1)
                p(X%).Col = 4
        END IF
      
NEXT

BuildTables


' The Arena routines basically load up a cube and draw it.
' The box encompasses every point, in 3 dimensions.
' The cube is 50x50x50
LoadArena
AssembleArena


SCREEN , , 2, 0
' Main routine

DO

        PCOPY 3, 2
        FOR X% = 0 TO Max%
                IF Pause% <> 1 THEN
                        p(X%).X = p(X%).X + p(X%).xdir
                        p(X%).Y = p(X%).Y + p(X%).ydir
                        p(X%).z = p(X%).z + p(X%).zdir
                END IF

                SELECT CASE p(X%).X
                        CASE IS >= 210, IS <= 110: p(X%).xdir = -1 * p(X%).xdir
                END SELECT
                SELECT CASE p(X%).Y
                        CASE IS >= 150, IS <= 50: p(X%).ydir = -1 * p(X%).ydir
                END SELECT
                SELECT CASE p(X%).z
                        CASE IS <= -50, IS >= 50: p(X%).zdir = -1 * p(X%).zdir
                END SELECT
              
                nx% = p(X%).X + cost(WorldAngle%) * p(X%).z
                ny% = p(X%).Y + sint(WorldAngle%) * p(X%).z
              
                SELECT CASE p(X%).Col
                        CASE 1: IF XTog% = 0 THEN ok% = 1
                        CASE 5: IF YTog% = 0 THEN ok% = 1
                        CASE 4: IF ZTog% = 0 THEN ok% = 1
                END SELECT
                IF ok% = 1 THEN
                        IF POINT(nx%, ny%) = 0 THEN PSET (nx%, ny%), p(X%).Col
                END IF
                ok% = 0
        NEXT

        AssembleArena

        a$ = INKEY$
        SELECT CASE UCASE$(a$)
                CASE "+": speed% = speed% + 1
                CASE "-": speed% = speed% - 1
                CASE "P": Pause% = Pause% XOR 1
                CASE "X": XTog% = XTog% XOR 1
                CASE "Y": YTog% = YTog% XOR 1
                CASE "Z": ZTog% = ZTog% XOR 1
                CASE "?": Controls
                CASE ELSE: IF a$ <> "" THEN EXIT DO
        END SELECT
     
        PCOPY 2, 0

        WorldAngle% = WorldAngle% + speed%
        SELECT CASE WorldAngle%
                CASE IS >= 360: WorldAngle% = 0
                CASE IS < 0: WorldAngle% = 360
        END SELECT
     
LOOP
'--------- DATA-Anwesungen sind ans Ende des Hauptprogramms verlagert -----
END SUB

REM $STATIC
DEFSNG A-Z
SUB BuildTables
'------------------------ fr Bounce-Bildschirmschoner -----------------------
        CONST pi = 3.141592
        FOR Angle% = 0 TO 360
                sint(Angle%) = SIN(Angle% * pi / 180)
                cost(Angle%) = COS(Angle% * pi / 180)
        NEXT
END SUB

DEFINT A-Z
SUB Controls
'------------------------- fr Bounce-Bildschirmschoner ---------------------
LOCATE 6, 2
LINE (10, 30)-(280, 130), 0, BF
COLOR 4
PRINT "   Key            Effect"
COLOR 15
PRINT
PRINT "  + or -  : Increase/Decrease"
PRINT "            cube rotation speed"
PRINT
PRINT "     P    : Toggle paused pixels."
PRINT "     X    : Toggle X-Axis bouncing"
PRINT "     Y    : Toggle Y-Axix bouncing"
PRINT "     Z    : Toggle Z-Axis bouncing"
LINE (10, 30)-(280, 130), 15, B
PCOPY 2, 0
DO: LOOP UNTIL INKEY$ <> ""
END SUB

DEFSNG A-Z
SUB Hilfe
'--------------------------- Hilfetext anzeigen ----------------------------

  VIEW      'Koordinatenverschiebung rckgngig
  COLOR 10  'Textfarbe grn
  CLS
LOCATE 12
PRINT "        --------------Funktionsweise des Pi-Berechners:--------------"
PRINT
PRINT
PRINT
PRINT "  Dieses QBasic-Programm dient dazu die Kreiszahl Pi zu berechnen und"
PRINT "  benutzt dabei das Monte-Carlo Annherungsverfahren."
PRINT
PRINT "  1. Das Programmm zeichnet ein Quadrat mit Innenkreis."
PRINT "  2. Eine einstellbare Anzahl von Pixeln (=Tropfen) werden mit Hilfe des"
PRINT "     Zufallsgenerators in das Quadrat gesetzt."
PRINT "  3. Das Programm berprft, ob der gefallene Tropfen im Kreis liegt oder"
PRINT "     auerhalb."
PRINT "      - Tropfenzahl im Kreis = k"
PRINT "      - Zahl der insgesamt gefallenen Tropfen im Quadrat = n"
PRINT "  4. Durch die Formel Pi=4*k/n wird Pi bestimmt."
PRINT
PRINT "  Anmerkung:"
PRINT "  Da es (fast) unmglich ist, einen 100% Zufallsgenerator auf einem Computer"
PRINT "  zu programmieren, wird es meinem Programm natrlich nicht gelingen die"
PRINT "  Kreistzahl Pi sehr exakt zu bestimmen."
PRINT "  Wenn man genau darauf achtet kann man sogar ein Muster in den (zufllig)"
PRINT "  gesetzten Pixeln erkennen."
PRINT
PRINT
PRINT "  ___________________________________________________________________________"
PRINT
PRINT "    Verbeserungsvorschlge und Kommentare an    :";
COLOR 9: PRINT " marc@antonis.de"
PRINT
COLOR 10
PRINT "    Wennn Sie mehr ber die Programmiersprache"
PRINT "    QBasic wissen mchten, dann besuchen Sie"
PRINT "    meine Homepage                              :";
COLOR 9: PRINT " http://www.antonis.de"
COLOR 10
PRINT "  ___________________________________________________________________________"
PRINT
PRINT
PRINT
PRINT "    --------Viel Spa mit dem Pi-Berechner wnscht Marc Antoni ! ---------"
COLOR 14
LINE (4, 12)-(626, 478), 14, B
LOCATE 60, 30: PRINT " ............. zurck mit beliebiger Taste  ";
SLEEP
END SUB

SUB intro
'----------------------------- Intro-Bildschirm anzeigen ---------------------

SCREEN 13
CLS
RANDOMIZE TIMER
FOR Y% = 0 TO 199
FOR X% = 0 TO 319
PSET (X%, Y%), INT(RND * 255) + 1

NEXT X%
NEXT Y%
DO
IF Red > 2 THEN Red = Red - INT(RND * 2)
IF Grn > 2 THEN Grn = Grn - INT(RND * 2)

IF Blu > 2 THEN Blu = Blu - INT(RND * 2)
IF Red < 61 THEN Red = Red + INT(RND * 2)
IF Grn < 61 THEN Grn = Grn + INT(RND * 2)
IF Blu < 61 THEN Blu = Blu + INT(RND * 2)
OUT &H3C8, INT(RND * 255) + 1

OUT &H3C9, Red
OUT &H3C9, Grn
OUT &H3C9, Blu
PSET (INT(RND * 320), INT(RND * 200)), INT(RND * 255) + 1
LOCATE 10, 4: PRINT " Pi-Berechnung nach Monte Carlo "
LOCATE 12, 12: PRINT " (c) Marc Antoni "
LOOP UNTIL INKEY$ <> ""

END SUB

SUB LoadArena
'----------------------- fr Bounce-Bildschirmschoner -----------------------
        RESTORE BoxData
        FOR X% = 0 TO 7
                READ Arena(X%).X, Arena(X%).Y, Arena(X%).z
        NEXT

        RESTORE ConnectData
        FOR X% = 0 TO 11
                READ Drawlist(X%).a, Drawlist(X%).B
                Drawlist(X%).a = Drawlist(X%).a - 1
                Drawlist(X%).B = Drawlist(X%).B - 1
        NEXT
END SUB

SUB Spread (Text$, Row%, Col%, Delay)

'*******************************************************************************
'*  Spreads text on the screen in both directions starting from the specified  *
'*  coordinates.  Delay is measured in 100ths of a second                      *
'*******************************************************************************

'   convert delay to single precision
    d! = Delay

'   always have at least 1/20 sec. delay
    IF d! < 1 THEN
       d! = 5
    END IF

'   change to 100ths
    d! = d! / 100

'   if null, get out
    IF Text$ = "" THEN
       EXIT SUB
    END IF
  
    Txt$ = Text$

'   make text length even if not already so
    IF LEN(Txt$) MOD 2 = 1 THEN
       Txt$ = Txt$ + " "
    END IF

'   divide text into left and right sides
    LeftSide$ = LEFT$(Txt$, LEN(Txt$) \ 2)
    RightSide$ = RIGHT$(Txt$, LEN(Txt$) \ 2)

    FOR X% = 1 TO LEN(RightSide$)

        LOCATE Row%, Col%
        PRINT RIGHT$(RightSide$, X%);

'       print a letter from the left side
        IF (Col% - X%) >= 1 THEN
          LOCATE Row%, Col% - X%
          PRINT LEFT$(LeftSide$, X%);
        END IF

        CurrentTimer! = TIMER
        WHILE TIMER < (CurrentTimer! + d!)
        WEND    'Wait for timer to increase by d!

        IF INKEY$ <> "" THEN
           d! = 0        'if a key is pressed, stop delaying
        END IF
      
    NEXT X%
END SUB

