DECLARE SUB ProgressBar (prozent%)
'***************************************************************************
' PROGRES.BAS - QBasic-Programm zur Erzeugung eines Fortschrittbalkens
' ======================================================================
' (Demonstration der SUB  ProgressBar)
'
' (c) Thomas Antoni, 30.05.99
'       thomas.antoni@erlf.siemens.de
'***************************************************************************

COLOR 0, 7
CLS
FOR p% = 0 TO 100
  CALL ProgressBar(p%)
  zeit = TIMER: WHILE TIMER < zeit + .05: WEND   'Wartezeit ca. 0.05 sec
  IF INKEY$ = CHR$(27) THEN END                  'Abbruch mit Esc-Taste
NEXT p%
WHILE INKEY$ = "": WEND
END

SUB ProgressBar (prozent%)
'***************************************************************************
' Subroutine ProgressBar
' ----------------------
' Gibt einen Fortschrittsbalken in Zeile 24,25 aus, deren Lnge durch den
' bergabeparameter prozent% (0...100) vorgegeben wird (je 2% =ein Zeichen).
' Vor der erstmaligen Nutzung des Progess Bars mu die Subroutine mit dem
' Aufruf ProgressBar(0) initialisiert werden.
'
' Die Cursorposition wird durch die SUB nicht verndert: Die vor dem Aufruf
' der SUB bestehende Cursorposition wird abgespeichert und vor Verlassen der
' SUB wieder restauriert.
'
' Der Progress Bar bentigt nur 2 Bildschirmzeilen, ist also sehr platz-
' sparend!
'
' (c) T.Antoni, 10.5.99 -17.05.99
'***************************************************************************

zeile% = CSRLIN                    'Cursorsposition abspeichern (merken)
spalte% = POS(0)

IF prozent% = 0 THEN               'Fortschrittsbalken initialisieren
  LOCATE 24, 1
  COLOR 15, 4                      'wei auf rot
  PRINT " Berechne... "; STRING$(50, ""); "  Abbruch: Esc   ";
  LOCATE 25, 1
  PRINT "             "; STRING$(50, ""); "                 ";
ELSE
  COLOR 2, 4
  IF prozent% >= 100 THEN prozent% = 99
  balkenlaenge% = INT(prozent% / 2) + 1
  LOCATE 24, 14
  PRINT STRING$(balkenlaenge%, "");
  LOCATE 25, 14
  PRINT STRING$(balkenlaenge%, "");
END IF

LOCATE zeile%, spalte%             'alte Cursorsposition restaurieren
COLOR 0, 7                         'alte Farbe ebenso (sw auf hellgrau)
END SUB

