'***************************************************************************
' SHOWHEX.BAS - HEX-Viewer in QBasic
' ===================================
' Zeigt den Inhalt einer waehlbaren, beliebig grossen Datei im Hex-Code auf
' dem Bildschirm an. Zusaetzlich erscheint am linken Bildschirmrand in jeder
' Zeile jeweils die Hex-Adresse des ersten Zeichens und am rechten Rand der
' Zeileninhalt als ASCII-Text, soweit es sich um abdruckbare Zeichen
' handelt.
' Somit aehnelt das Erscheinungsbild weitgehend demjenigen eines
' professionellen Hex-Editors. SHOWHEX.BAS ist ein ideales Tool fuer Hacker
' und Leute, die fremde und eigene Dateien und Programme ausspaehen wollen.
'
' Nach einer Idee von NicTheQuick (NicolasG@web.de)
'
'   \         (c) Thomas Antoni, 19.7.02 - 09.11.02
'    \ /\           Mailto:thomas@antonis.de
'    ( )            www.antonis.de --- www.qbasic.de
'  .( o ).
'                      ----==== Hottest QBasic Stuff on Earth !!! ====----
'
'***************************************************************************
'
WIDTH 80, 50    'VGA-Aufloesung mit 50 Zeilen a 80 Spalten
COLOR 0, 7: CLS 'Schwarz auf Hellgrau
Block% = 768    '48 Zeilen a 16 Bytes je Bildschirm anzeigen
adresse& = -16
text$ = ""
INPUT "Gib den Pfad und Namen der Datei ein "; Datei$
OPEN Datei$ FOR BINARY AS #1
DO UNTIL LOC(1) = LOF(1)
  IF LOF(1) - LOC(1) < Block% THEN
    Block% = LOF(1) - LOC(1)
    ende% = 1                      'Merker "letzter Block"
  END IF
  Bytes$ = SPACE$(Block%)
  GET #1, , Bytes$                 'Block einlesen
  FOR Bytenummer& = 1 TO Block%
    IF Bytenummer& MOD 16 = 1 THEN 'Zeilenanfang erreicht?
      adresse& = adresse& + 16     'Adresse aktualisieren
      a$ = HEX$(adresse&)          'Adresse Hex-Wandeln
      LOCATE , 9 - LEN(a$): PRINT a$ + ":   ";  '.. und anzeigen
    END IF
    zeichen$ = MID$(Bytes$, Bytenummer&, 1)
    byte% = ASC(zeichen$)
    IF byte% < 32 THEN zeichen$ = CHR$(254)    'nicht abdruckbares Zeichen
    text$ = text$ + zeichen$
    hexa$ = HEX$(byte%)
    IF LEN(hexa$) = 1 THEN hexa$ = "0" + hexa$ 'fuehrende 0 anhaengen
    PRINT hexa$;                   'aktuelles Byte im Hex-Code anzeigen
    IF Bytenummer& MOD 16 <> 0 THEN
      PRINT " ";
    ELSE
      PRINT "   " + text$: text$ = ""          'ASCII-Text anzeigen
    END IF
  NEXT Bytenummer&
  IF ende% = 1 THEN       'Dateiende erreicht
    LOCATE , 63
    PRINT text$
    COLOR 15, 1           'weiss auf blau fuer Ende-Text
    PRINT
    PRINT SPACE$(80);     'blauen Balken anzeigen
    LOCATE , 21
    PRINT "Dateiende erreicht, Abbruch mit [Esc]";
    DO: LOOP WHILE INKEY$ <> CHR$(27)
    END
  ELSE
    COLOR 15, 1           'weiss auf blau fuer Fusszeile
    LOCATE 50, 1
    PRINT SPACE$(80);     'blauen Balken anzeigen
    LOCATE 50, 19
    PRINT "Weiter [beliebige Taste]    Abbruch [Esc]";
  END IF
  DO: taste$ = INKEY$: LOOP WHILE taste$ = ""
  IF taste$ = CHR$(27) THEN END
  COLOR 0, 7              'wieder schwarz auf grau
  CLS
LOOP
CLOSE #1

