DECLARE SUB KurveZeichnen (amplitude!, frequenz!)
DECLARE SUB KoordinatenZeichnen ()
'*****************************************************************************
' SINUS.BAS - QBasic-Programm zur Demo der Koordinatenskalierung wit WINDOW
' ==========================================================================
' Ausgabe von Sinus-Kurven nach einem Programmvorschlag in Lit. {11/214}:
' Zuncht wird mit VIEW ein Bildschirmausschnitt festgelegt. Mit WINDOW werden
' dann die Bildshirmkoordinaten folgendermaen definiert, gezeichnet und be-
' schriftet:
'
'  - X-Achse in der Mitte des Bildschirmausschnitts von -180 bis 180
'  - Y-Achse in der Mitte des Bildshirmausschnitts, unten=-1, oben =1
'
' Nachdem die Eingabewerte fr Amplitude und Frequenz eingegeben wurden,
' wird die entsprechende Sinus-Kurve auf den Bildschirm gezeichnet.
'
' Verwendte Befehle: WINDOW, VIEW
'
' (c) Thomas Antoni, Rosieres/ Frankreich    27.08.99
'       thomas.antoni.erlf.siemens.de
'*****************************************************************************

'--- Deklarationen ----------------------------------------------------------
CONST pi = 3.141593
CONST xmax% = 630, xmitte! = pi
CONST ymax% = 410, ymitte% = 1

'--- Bildschirm u.Koordinatensystem einrichten ------------------------------

SCREEN 11   'VGA-Bildschirm 640*480*2
VIEW (0, 10)-(xmax%, ymax%) 'Bildschirmausschnitt definieren, auf
                            'den sich alle folgenden Koordinaten
                            'angaben beziehen
WINDOW (-xmitte!, -ymitte%)-(xmitte!, ymitte%)
                            'Kordinatenskalierung bezogen auf die Ecken des
                            'obigen Bildschirmausschnitt einrichten:
                            ' - (x,y) Ecke unten links = (-xmitte!, -ymitte%)
                            ' - (x,y) Ecke oben rechts = (xmitte!, ymitte%)
DO
  CALL KoordinatenZeichnen

'--- Werte-Eingabe (Amplitude und Frequenz der anzuzeigenden Sinus-Kurve) ---
  LOCATE 2, 2
  INPUT "Amplitude (0..1.0): "; amplitude
  LOCATE 3, 2
  INPUT "Frequenz          : "; frequenz

'--- Sinus-Kurve mit diesen Werten zeichnen ---------------------------------
  CALL KurveZeichnen((amplitude), (frequenz)) 'Parameter in Klammern ==> call
                                              'by value

'--- Wiederholen/ Beenden-Dialog -------------------------------------------
  LOCATE 4, 2
  PRINT ".......... Wiederholung mit beliebiger Taste, Ende mit Esc"
  DO
    taste$ = INKEY$
  LOOP WHILE taste$ = ""
  IF taste$ = CHR$(27) THEN END
  CLS
LOOP

END

SUB KoordinatenZeichnen

'--- X-Achse --------------------------------
LINE (-xmitte!, 0)-(xmitte!, 0)
FOR x% = -2 TO 2
  LOCATE 15, x% * 19 + 39
  PRINT STR$(90 * x%)
NEXT x%

'--- Y-Achse --------------------------------
LINE (0, -ymitte%)-(0, ymitte%)
FOR y% = -1 TO 1
  LOCATE y% * 12 + 14, 37
  PRINT -y%
NEXT y%

END SUB

SUB KurveZeichnen (amplitude, frequenz)
PSET (xmittel!, 0)

FOR x! = -xmitte! TO xmitte! STEP .02
  y! = amplitude * SIN(x! * frequenz)
  LINE -(x!, y!)
NEXT x!

END SUB

