'****************************************************************************
'
' STOPCALC.BAS - Stochastik Power Calculator fr PowerBASIC
' ============
' Ablauffhig unter: PowerBASIC 3.5 (nicht PB 2.x und FirstBASIC)
' PowerBasic-Programm zum Berechnen vieler in der Wahrscheinlichkeits-
' rechnung (Stochastik) bentigten Funktionen. Dieses Programm ersetzt dicke
' Tafelwerke und bietet eine wesentlich hhere Genauigkeit. Auch der
' untersttzte Zahlenbereich ist wesentlich grer als derjenige vieler
' Tafelwerke und fast aller Taschenrechner.
'
' Es wird der Datentyp EXT verwendet (Erweiterte 80-Bit-Gleitpunktzahl).
' Damit sind Zahlen bis ca. 3,4 +- 10^4942 darstellbar!!
'
' Dieser Zahlenbereich ermglicht es z.B., Fakultten bis 1754! zu berechnen.
' Die meisten Taschenrechner gehen nur bis 10^99 enstpricht maximal 69!
' QBasic geht nur bis 170!, weil es dort nur maximal 64 Bit lange Gleit-
' punktzahlen gibt (Zahlenbereich bis 4 * 10^323 ).
'
'
'   \         (c) Marc Antoni, 4.7.03 - 26.7.03
'    \ /\           Mailto:marc@antonis.de
'    ( )            http://www.antonis.de
'  .( o ).
'              ----==== Hottest QBasic Stuff on Earth !!! ====----
'
' Testdaten
' ---------
'   69! = 1,7112 * 10^98
'  170! = 7,2574 * 10^306  (Grenze bei QB)
'  499! = 2.4403 * 10^1131 (nur bei PB)
' 1754! = 1.9793 * 10^4930 (Grenze bei PB)
' 
' (10 aus 35)    = 183 579 396
' (17 aus 35)    = 4 537 567 650
' (35 aus 65)    = 3,0091  * 10^18
' (80 aus 170)   = 6,82525 * 10^49
' (134 aus 269)  = 4,60177 * 10^79  (Grenze bei QB)
' (999 aus 2222) = 1,61267 * 10^662 (nur bei PB)
' (1480 aus 2955)= 5,11005 * 10^887 (Grenze bei PB)
' 
' B(n=100;  p=0,2;  k=19)  = 0,09807
' B(n=200;  p=0,5;  k=100) = 0,05635
' B(n=2950; p=0,01; k=23)  = 0,03804 (bei QB nur mit Poisson)
' B(n=2955; p=0,1;  k=1480)= 1.64485 * 10^-660 (Grenze bei PB)
'
' B(n=100; p=0,2; k=0...19) = 0,46016
' B(n=200; p=0,5; k=0...100)= 0,52817
' 
' B(n=100; p=0,2; k=13...19) = 0,43483
' B(n=200; p=0,5; k=92...100)= 0,41366
'
' Portierung von QBasic
' ---------------------
' - Suffix fr Floating-Point-Variablen: "##" statt "#" (80 statt 64 Bit)
' - "EXIT LOOP" statt "EXIT DO"
' - In FUNCTION-Deklarationen "parameter#" durch "EXT" ersetzen
' - Programmname StoPCalc statt StoCalc (in Kopfzeile u.Progr.kopf)
' - Mit $ERROR ALL ON  alle Fehlererkennungen aktivieren
'
'****************************************************************************
$ERROR ALL ON                       'Alle Fehlererkennungen aktivieren
DECLARE SUB Kopfzeile ()            'Kopfzeile anzeigen
DECLARE SUB Exponent ()             'n^k berechnen
DECLARE SUB Fakultaet ()            'Bedienoberflche fr n!
DECLARE SUB Binominal ()            'Bedienoberflche fr (k aus n)
DECLARE SUB Bernoulli ()            'Bernoulliwahrscheinlichkeit fr   k Treffer
DECLARE SUB Bernoulli0k ()          'Bernoulliwahrscheinlichk. fr 0...k Treffer
DECLARE SUB Bernoullik1k2 ()        'Bernoulliwahrscheinl. fr   k1...k2 Treffer
DECLARE SUB Poisson ()              'Poisson'sche Approximation
DECLARE FUNCTION nFakul## (EXT)     'n! berechnen
DECLARE FUNCTION KausN## (EXT, EXT) '(k aus n) berechnen
'
ON ERROR GOTO Fehler 'Fehler "Zahlenbereich berschritten" abfangen
                     'Fehlerbearbeitung: siehe am Schluss des Hauptprogramms
DO
WIDTH 80, 50      'VGA-Auflsung mit 80 Spalten, 25 Zeilen
NeuMenue:         'Einsprung von Fehlerbearbeitung (unten im Hauptprogramm)
COLOR 0, 7        'schwarze Schrift auf hellgrauem Grund
CLS
CALL Kopfzeile
LOCATE 6
PRINT " Was willst Du berechnen ?"
PRINT
PRINT "         k"
PRINT " (1)    n .............,,,,,.... Exponentialfunktion (n hoch k)"
PRINT " "
PRINT " (2)    n! ...........,,,,,..... Fakultt von n"
PRINT
PRINT " (3)   ( n )"
PRINT "       ( k ) ........,,,,,...... Binominalkoeffizient (k aus n)"
PRINT
PRINT
PRINT " (4)   B(n; p; k) .............. Bernoullikette"
PRINT "                                  - Wahrscheinlichkeit fr k Treffer"
PRINT "                             "
PRINT "      __k__"
PRINT "      \ "
PRINT " (5)   > B(n; p; i) ............ Bernoullikette"
PRINT "      /                           - Summenwahrscheinlichkeit fr 0...k Treffer"
PRINT "      ------"
PRINT "       i=0"
PRINT
PRINT
PRINT "      __k2_ "
PRINT "      \"
PRINT " (6)   > B(n; p; i) ............ Bernoullikette"
PRINT "      /                           - Summenwahrscheinlichkeit fr k1...k2 Treffer"
PRINT "      ------"
PRINT "       i=k1"
PRINT
PRINT "                     k"
PRINT "                          -"
PRINT " (7)  B(n; p; k) ~  * e   ... Bernoullikette"
PRINT "                    k!             - Poissonsche Nherung ( = n * p)"
PRINT "                                     fr groe n und kleine p"
PRINT
PRINT
PRINT " (Esc)  ......................... Beenden"
PRINT ""
LOCATE 47, 3
COLOR 14, 1                         'gelb auf blau
PRINT " Whle gewnschte Funktion (1) bis (7), bzw. (Esc) zum Beenden   ";
LOCATE , 66, 1 'blinkenden Cursor in Spalte 66 anzeigen
COLOR 0, 7     'Farbe wieder schwarz auf grau
DO: Taste$ = INKEY$: LOOP UNTIL Taste$ <> "" 'Warten auf Tastenbettigung
NeuBerechnung: 'Einsprung von d.Fehlerroutine, verzweigen zur aktuell.Funktion
SELECT CASE Taste$
  CASE "1": CALL Exponent
  CASE "2": CALL Fakultaet
  CASE "3": CALL Binominal
  CASE "4": CALL Bernoulli
  CASE "5": CALL Bernoulli0k
  CASE "6": CALL Bernoullik1k2
  CASE "7": CALL Poisson
  CASE CHR$(27): END   'Programm beenden mit Esc
END SELECT
LOOP
END
'
'***** Fehler-Routine fr alle Fehler
Fehler:
PRINT
PRINT
COLOR 15, 4      'wei auf rot
PRINT
LOCATE , 3
PRINT "      FEHLER: Zahlenbereich von 10^4932 berschritten !!!      "
PRINT
PRINT
COLOR 14, 1      'gelb auf blau
LOCATE , 3
PRINT " Neue Berechnung...[beliebige Taste]   zum Hauptmen...[Esc]   ";
LOCATE , 64, 1   'Blink-Cursor in Spalte 64
COLOR 0, 7       'wieder schwarz auf grau
DO: t$ = INKEY$: LOOP WHILE t$ = ""'Warten auf Tastenbettigung
IF t$ = CHR$(27) THEN
  RESUME NeuMenue       'Zurck zum Hauptmen
ELSE
  RESUME NeuBerechnung  'Zurck zur Neuberechnung
END IF


SUB Bernoulli
'*****************************************************************************
' Bernoulli =  SUB zur Berechnung der Bernoulli-Wahrscheinlichkeit
' ===========
' Diese SUB berechnet die Wahrscheinlichkeit, bei einer Bernullikette
' mit n Versuchen (d.h. "der Lnge n") genau k Treffer zu erzielen, wobei
' fr jeden Versuch die Trefferwahrscheinlichkeit p gilt. Das nennt man auch
' "Wahrscheinlichkeitsverteilung".
'
' Beispiel: Urnenversuch: Ziehen von n Kugeln mit Zurcklegen; die
' Wahrscheinlichkeit, eine weie Kugel zu ziehen = p ("Trefferwahrscheinlich-
' keit; wie gro ist die Wahrscheinlichkeit, dass x=k weie Kugeln dabei
' sind?
'
' (c)  Marc Antoni , 6.7.2003
'*****************************************************************************
DO
CLS
PRINT
PRINT " Berechng. d. Bernoulli-Wahrscheinlichkeit fr k Treffer bei n Versuchen"
PRINT " -----------------------------------------------------------------------"
PRINT
PRINT "    Ŀ"
PRINT "                                             "
PRINT "                     ( n )    k        n-k   "
PRINT "      B(n; p; k)  =  ( k ) * p  * (1-p)      "
PRINT "                                             "
PRINT "    "
PRINT
INPUT " Gib die Anzahl der Versuche ein        : n = ", n##
PRINT
INPUT " Gib die Anzahl der Treffer ein         : k = ", k##
PRINT
PRINT " Gib die Wahrscheinlichkeit je Treffer"
PRINT "   ein mit Dezimalpunkt und max 15"
PRINT "   Nachkommastellen "
PRINT "   z.B. 0.333333333333 fr 1/3"
INPUT "   oder 0.4            fr 40%          : p = ", p##
PRINT
PRINT
bp## = KausN(k##, n##) * p## ^ k## * (1 - p##) ^ (n## - k##)
PRINT " Ergebnis........................B(n; p; k) ="; bp##
'
'******* Wiederholen/Beenden-Dialog
PRINT
PRINT
PRINT
COLOR 14, 1      'gelb auf blau
LOCATE , 3
PRINT " Wiederholen...[beliebige Taste]   zum Hauptmen...[Esc]   ";
LOCATE , 60, 1   'Blink-Cursor in Spalte 60
COLOR 0, 7       'schwarz auf grau
'warten auf Tastenbetaetigung"
DO: Taste$ = INKEY$: LOOP WHILE Taste$ = ""
IF Taste$ = CHR$(27) THEN EXIT DO      'Zum Hauptmen mit Esc
LOOP
END SUB


SUB Bernoulli0k
'*****************************************************************************
' Bernoulli0k =  SUB z.Berechnung d.Summenwahrscheinlichkeit fr 0...k Treffer
' ============
' Diese Sub berechnet die Wahrscheinlichkeit, bei einer Bernullikette
' mit n Versuchen (d.h. "der Lnge n") zwischen 0 und k Treffer zu erzielen,
' wobei fr jeden Versuch die Trefferwahrscheinlichkeit p gilt.
'
' (c)  Marc Antoni , 6.7.2003
'*****************************************************************************
DO
CLS
PRINT
PRINT " Berechng. d. Bernoulli-Summenwahrscheinlichkeit fr 0...k Treffer"
PRINT " -----------------------------------------------------------------"
PRINT
PRINT "    Ŀ"
PRINT "                                             "
PRINT "                           __k__             "
PRINT "                           \                 "
PRINT "         p ( 0<=x<=k )  =   > B(n; p; i)     "
PRINT "                           /                 "
PRINT "                                      "
PRINT "                            i=0              "
PRINT "                                             "
PRINT "    "
PRINT
PRINT
INPUT " Gib die Anzahl der Versuche ein         : n = ", n##
PRINT
INPUT " Gib die Anzahl der Treffer ein          : k = ", k##
PRINT
PRINT " Gib die Wahrscheinlichkeit je Treffer"
PRINT "   ein mit Dezimalpunkt und max. 15"
PRINT "   Nachkommastellen "
PRINT "   z.B. 0.333333333333 fr 1/3"
INPUT "   oder 0.4            fr 40%           : p = ", p##
PRINT
PRINT
bp## = 0
FOR i## = 0 TO k##
  bp## = bp## + KausN(i##, n##) * p## ^ i## * (1 - p##) ^ (n## - i##)
NEXT i##
PRINT " Ergebnis......................p ( 0<=x<=k ) ="; bp##
'
'******* Wiederholen/Beenden-Dialog
PRINT
PRINT
PRINT
COLOR 14, 1       'gelb auf blau
LOCATE , 3
PRINT " Wiederholen...[beliebige Taste]   zum Hauptmen...[Esc]   ";
LOCATE , 60, 1    'Blink-Cursor in Spalte 60
COLOR 0, 7        'schwarz auf grau
'warten auf Tastenbetaetigung"
DO: Taste$ = INKEY$: LOOP WHILE Taste$ = ""
IF Taste$ = CHR$(27) THEN EXIT LOOP      'Zum Hauptmen mit Esc
LOOP
END SUB


SUB Bernoullik1k2
'*****************************************************************************
' Bernoullik1k2 =  SUB z.Berechnung d.Summenwahrsch. fr k1...k2 Treffer
' ===============
' Diese Sub berechnet die Wahrscheinlichkeit, bei einer Bernullikette
' mit n Versuchen (d.h. "der Lnge n") zwischen k1 und k2 Treffer zu erzielen,
' wobei fr jeden Versuch die Trefferwahrscheinlichkeit p gilt.
'
' (c)  Marc Antoni , 6.7.2003
'*****************************************************************************
DO
CLS
PRINT
PRINT " Berechng. d. Bernoulli-Summenwahrscheinlichkeit fr k1...k2 Treffer"
PRINT " -------------------------------------------------------------------"
PRINT
PRINT "    Ŀ"
PRINT "                                             "
PRINT "                            __k2__           "
PRINT "                            \                "
PRINT "        p ( 0<=x<=k )   =    > B(n; p; i)    "
PRINT "                            /                "
PRINT "                                     "
PRINT "                            i=k1             "
PRINT "                                             "
PRINT "    "
PRINT
PRINT
INPUT " Gib die Anzahl der Versuche ein          : n  = ", n##
PRINT
INPUT " Gib die untere Trefferzahl ein           : k1 = ", k1##
PRINT
INPUT " Gib die obere Trefferzahl ein            : k2 = ", k2##
PRINT
PRINT " Gib die Wahrscheinlichkeit je Treffer"
PRINT "   ein mit Dezimalpunkt und max. 15"
PRINT "   Nachkommastellen "
PRINT "   z.B. 0.333333333333 fr 1/3"
INPUT "   oder 0.4            fr 40%             : p  = ", p##
PRINT
PRINT
bp## = 0
FOR i## = k1## TO k2##
  bp## = bp## + KausN(i##, n##) * p## ^ i## * (1 - p##) ^ (n## - i##)
NEXT i##
PRINT " Ergebnis......................p ( k1<=x<=k2 )  ="; bp##
'                                                 
'******* Wiederholen/Beenden-Dialog
PRINT
PRINT
PRINT
COLOR 14, 1    'gelb auf blau
LOCATE , 3
PRINT " Wiederholen...[beliebige Taste]   zum Hauptmen...[Esc]   ";
LOCATE , 60, 1 'Blink-Cursor in Spalte 60
COLOR 0, 7     'schwarz auf grau
'warten auf Tastenbetaetigung"
DO: Taste$ = INKEY$: LOOP WHILE Taste$ = ""
IF Taste$ = CHR$(27) THEN EXIT LOOP      'Zum Hauptmen mit Esc
LOOP
END SUB


SUB Binominal
'***************************************************************
' Binominal =  Sub zur Berechnung des Binominalkoeffizienten
' ===========
' Diese Sub berechnet de Binominalkoeffizienten
' k aus n (manchmal auch "n ueber k" genannt).
'
' In der Wahrscheinlichkeitsrechnung wird der
' Binominalkoeffizient verwendet, um die Anzahl der
' Moeglichkeiten zu ermitteln, k aus insgesamt n unter-
' schiedlichen Elementen zu kombinieren. Dabei wird die
' Reihenfolge nicht beruecksichtigt, und die Elemente
' werden nach dem "Ziehen" nicht zurckgelegt.
' Beispiel: Beim Lotto "6 aus 49" gibt es 6 aus 49
' Moeglichkeiten, den Lottoschein auszufuellen.
'
' Diese SUB enthlt nur die Bedienungsoberflche. Die
' eigentliche Berechnung findet in der SUB "KausN" statt
'
' (c)  Marc Antoni , 6.7.2003
'*********************************************************
'
DO
CLS
CALL Kopfzeile
PRINT
PRINT " Berechnung des Binominalkoeffizienten k aus n"
PRINT " ---------------------------------------------"
PRINT
PRINT SPACE$(20); "( n )"
PRINT SPACE$(20); "( k )"
PRINT
PRINT
INPUT " Gib k ein : ", k##
INPUT " Gib n ein : ", n##
'
PRINT
PRINT
'
PRINT " Binominalkoeffizient (k aus n) ="; KausN##(k##, n##)
'
'******* Wiederholen/Beenden-Dialog
PRINT
COLOR 14, 1     'gelb auf blau
LOCATE , 3
PRINT " Wiederholen...[beliebige Taste]   zum Hauptmen...[Esc]   ";
LOCATE , 60, 1  'Blink-Cursor in Spalte 60
COLOR 0, 7      'schwarz auf grau
'warten auf Tastenbetaetigung"
DO: Taste$ = INKEY$: LOOP WHILE Taste$ = ""
IF Taste$ = CHR$(27) THEN EXIT LOOP      'Zum Hauptmen mit Esc
LOOP
END SUB


SUB Exponent
'***************************************************************
' Exponent =  Sub zur Berechnung der Exponentialfunktion n^k
' ===========
'
' Es wird der Datentyp EXT verwendet (erweiterte
' 80-Bit-Gleitpunktzahl). Damit sind Zahlen bis ca.
' 3,4 * 10^4932 darstellbar.
'
' (c)  Marc Antoni , 29.6.2003 - 9.7.2003
'*********************************************************
'
DO
CLS
CALL Kopfzeile
PRINT
PRINT "                                     k"
PRINT " Berechnung der Exponentialfunktion n  bis 10^4932"
PRINT " -------------------------------------------------"
PRINT
INPUT " Gib n ein :   n = ", n##
INPUT " Gib k ein :   k = ", k##
'
PRINT
PRINT
PRINT "               k"
PRINT "              n  = "; n## ^ k##
'
'*******Wiederholen/Beenden-Dialog
PRINT
PRINT
COLOR 14, 1     'gelb auf blau
LOCATE , 3
PRINT " Wiederholen...[beliebige Taste]   zum Hauptmen...[Esc]   ";
LOCATE , 60, 1  'Blink-Cursor in Spalte 60
COLOR 0, 7      'schwarz auf grau
'warten auf Tastenbetaetigung"
DO: Taste$ = INKEY$: LOOP WHILE Taste$ = ""
IF Taste$ = CHR$(27) THEN EXIT LOOP      'Zum Hauptmen mit Esc
LOOP
END SUB


SUB Fakultaet
'*****************************************************************
' Fakultaet = SUB zur Berechnung der Fakultaet n! einer Zahl n
' ==========
' Es wird der Datentyp EXT verwendet (Erweiterte
' 90-Bit-Gleitpunktzahl). Damit sind Zahlen bis ca.
' 3,4 * 10^4932 darstellbar.
'
' Dieser Zahlenbereich ermoeglicht es, Fakultaeten bis
' zu 1754! zu berechnen. Die meisten Taschenrechner gehen
' nur bis 10^99 enstpricht maximal 69! QBasic geht nur bis 170!.
'
' Diese SUB enthlt nur die Bedienungsoberflche. Die
' eigentliche Berechnung findet in der SUB "nFakul" statt

'
' (c)  Marc Antoni , 5.7.2003 - 9.7.2003
'*****************************************************************
'
DO
CLS
CALL Kopfzeile
PRINT
PRINT " Berechnung der Fakultt n! einer Zahl n"
PRINT " ----------------------------------------"
PRINT
INPUT " Gib n ein (maximal 1754):  n  = ", n##
PRINT
PRINT "                            n! ="; nFakul##(n##)
  '*******Wiederholen/Beenden-Dialog
PRINT
COLOR 14, 1     'gelb auf blau
LOCATE , 3
PRINT " Wiederholen...[beliebige Taste]   zum Hauptmen...[Esc]   ";
LOCATE , 60, 1  'Blink-Cursor in Spalte 60
COLOR 0, 7      'schwarz auf grau
'warten auf Tastenbetaetigung"
DO: Taste$ = INKEY$: LOOP WHILE Taste$ = ""
IF Taste$ = CHR$(27) THEN EXIT LOOP      'Zum Hauptmen mit Esc
LOOP
END SUB


FUNCTION KausN## (k##, n##)
'***************************************************************************
' KausN## (k##, n##) - Funktion zur Berechnung des Binominalkoeffizenten
' ===============   k aus n
'
' Die folgende, naheliegende und auch gut funktionierende Berechnungsformel
' habe ich verworfen, um den Zahlenbereich besser auszunutzen und auch
' Werte von n oberhalb von 1754:
'         KausN## = nFakul##(n##) / (nFakul##(k##) * nFakul##(n## - k##))
'
' Durch folgenden Trick wurde der Bereich fuer k und n deutlich erhoeht:
' Der Bruch (k aus n) = n! / ((n-k)! * k!) wird vor der weiteren Berechnung
' durch den groesseren der beiden Nennerfaktoren gekuerzt wird. Dadurch
' ergibt sich eine wesentliche Vergroesserung des Wertebereiches fuer n
' und k eber 1754 hinaus. Mit dieser Methode ist z.B. (999 aus 2222)
' berechenbar, whrend bei der "konventionellen" Methode schon bei
' (999 aus 1755) ein Zahlenueberlauf auftritt.
'
' (c)  Marc Antoni , 4.7.2003 - 9.7.2003
'***************************************************************************
'
'Fallunterscheidung: n!/(n-k)! * k! erst durch den groesseren
'der beiden Nennerfaktoren (n-k)! bzw. k! kuerzen
IF k## > n## / 2 THEN 'k! > (n-k)! -> durch k! kuerzen
  nk## = 1
  FOR i## = k## + 1 TO n##
    nk## = nk## * i##
  NEXT i##
  biko## = nk## / nFakul##(n## - k##)
ELSE                'k! <= (n-k)! -> durch (n-k! kuerzen
  nk## = 1
  FOR i## = n## - k## + 1 TO n##
    nk## = nk## * i##
  NEXT i##
  biko## = nk## / nFakul##(k##)
END IF
KausN## = biko##
END FUNCTION


SUB Kopfzeile
'*************************************************************************
' Kopfzeile - SUB zum Anzeigen der Kopfzeile von StoCalc
' =========
'
' (c)  Marc Antoni , 4.7.2003
'*************************************************************************
COLOR 15, 4                         'Kopfzeile wei auf rot
PRINT "   StoPCalc  - Stochastischer Power Calculator V1.0   (c)  Marc Antoni , 2003   "
COLOR 0, 7
END SUB


FUNCTION nFakul## (m##)
'*************************************************************************
' nFakul## (m##) = FUNCTION zur Berechnung der Fakultaet m! einer Zahl m
' ============
' Es wird der Datentyp EXT verwendet (erweiterte
' 80-Bit-Gleitpunktzahl). Damit sind Zahlen bis ca.
' 3,4 * 10^4932 darstellbar.
'
' Dieser Zahlenbereich ermoegtlicht es, Fakultaeten bis
' zu 1754! zu berechnen. Die meisten Taschenrechner gehen
' nur bis 10^99 enstpricht maximal 69! QBasic geht nur bis
' 170!
'
' (c)  Marc Antoni , 5.7.2003 - 26.7.2003
'*************************************************************************
f## = 1
FOR i## = 1 TO m##
  f## = f## * i##
NEXT i##
nFakul## = f##
END FUNCTION

SUB Poisson
'*****************************************************************************
' Poisson =  SUB zur Berechnung der Possin-Verteilung
' ========
' Diese SUB berechnet die Wahrscheinlichkeit, bei einer Bernullikette
' mit n Versuchen (d.h. "der Lnge n") genau k Treffer zu erzielen, wobei
' fr jeden Versuch die Trefferwahrscheinlichkeit p gilt. Das nennt man auch
' "Wahrscheinlichkeitsverteilung". Dazu wird die Nherungsmethode nach
' Poisson verwendet, die sich bei groen Werten von "n" und kleinen
' Werten von "p" anbietet. Typische Anwendungen hierfr gibt es beim
' radioaktiven Zerfall und in der Vewrsicherungsmathematik.
'
' Beispiel: Urnenversuch: Ziehen von n Kugeln mit Zurcklegen; die
' Wahrscheinlichkeit, eine weie Kugel zu ziehen = p ("Trefferwahrscheinlich-
' keit;
' wie gro ist die Wahrscheinlichkeit, da x=k weie Kugeln dabei sind?
'
'
' (c)  Marc Antoni , 11.7.2003
'*****************************************************************************
DO
CLS
PRINT
PRINT " Berechng. d. Bernoulli-Wahrscheinlichkeit ber die Poisson'sche Nherung"
PRINT " ------------------------------------------------------------------------"
PRINT
PRINT "    Ŀ"
PRINT "                                                 "
PRINT "                      k                          "
PRINT "                           -                   "
PRINT "       B(n; p; k) ~  * e    ; ( = n * p)    "
PRINT "                     k!                          "
PRINT "                                                 "
PRINT "         fr n -> Unendlich und kleines p        "
PRINT "                                                 "
PRINT "    "
PRINT
INPUT " Gib die Anzahl der Versuche ein        : n = ", n##
PRINT
INPUT " Gib die Anzahl der Treffer ein         : k = ", k##
PRINT
PRINT " Gib die Wahrscheinlichkeit je Treffer"
PRINT "   ein mit Dezimalpunkt und max 15"
PRINT "   Nachkommastellen "
PRINT "   z.B. 0.333333333333 fr 1/3"
INPUT "   oder 0.4            fr 40%          : p = ", p##
PRINT
PRINT
mue## = n## * p##
e## = 2.71828182845905##   'Eulersche Konstante e
bp## = ((mue## ^ k##) / nFakul##(k##)) * e## ^ (-mue##)
PRINT " Ergebnis........................B(n; p; k) ~"; bp##
'
'******* Wiederholen/Beenden-Dialog
PRINT
PRINT
PRINT
COLOR 14, 1      'gelb auf blau
LOCATE , 3
PRINT " Wiederholen...[beliebige Taste]   zum Hauptmen...[Esc]   ";
LOCATE , 60, 1   'Blink-Cursor in Spalte 60
COLOR 0, 7       'schwarz auf grau
'warten auf Tastenbetaetigung"
DO: Taste$ = INKEY$: LOOP WHILE Taste$ = ""
IF Taste$ = CHR$(27) THEN EXIT DO      'Zum Hauptmen mit Esc
LOOP
END SUB

'----==== Ende des Programms ====----

