DECLARE SUB TOP96 (score&, HISCOREONLY%, playername$, vgalines%, scorefile$)
'****************************************************************************
'
' TOP96 - A QBASIC Subroutine generating a highscore screen with 46/96 entries
' ============================================================================
'
' This program contains the following two parts:
'  - TOP46.BAS    = Main program for testing and demonstrating TOP96        
'  - TOP46        = A cool highscore generator SUBroutine for SCREEN 0
'                   with 46 entries in normal mode and 96 entries (!) in VGA
'                   textmode.
'                   This brings much more fun to your game because gamers
'                   can much easier enter the Hall of Fame.
'
' Refer to SUB TOP96 for more information
'
' When you integrate the TOP96 SUB into your programm you'll also have to
' include the user-defined  "TYPE hiscore" declaration into your main module,
' i.e. the 7 lines directly following this header box.
'
' Credits to Carlo Teubner and Tim Truman:
' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' - TOP96 is based on another very good highscore generator named
'   "HISCORE.BAS" from Carlo Teubner. Visit Carlo's homepage at
'               http://home.t-online.de/home/C.Teubner
'   for getting HISCORE.BAS and other neat QBasic-related stuff, e.g. a nice
'   German-language QBasic turorial.
' - I've also taken some very smart programming ideas from the game
'   "QBINVADE.BAS" made by Tim Truman which can be downloaded from
'               http://www.qbasic.com
'   QBasic.com is one of the best QBasic websites of the universe.
'
' (c) Thomas Antoni 06.07.99 - 24.07.99
'       thomas.antoni@erlf.siemens.de
'****************************************************************************

'------ Include the following TYPE declaration into your main module! -------
TYPE hiscore                         'Anwenderspezifischen Datentyp
                                     '"Hiscore-Eintrag" deklarieren
  rank AS INTEGER                    'Platz in der Bestenliste (2 Bytes)
  nam AS STRING * 14                 'Name des Spielers
  points AS LONG                     'Punkte (4 Bytes, max. 9999999)
  date AS STRING * 8                 'Datum
END TYPE                             'Gesamtlnge e.Datensatzes= 2+14+4+8
                                     '=28 Bytes

'---------- The following is for demonstration and testing only -------------
'---------- and not necessary to be included in your main program -----------

DO
CLS
PRINT
PRINT " ***************************************************************"
PRINT " **    Welcome to TOP96                        (c) T.Antoni   **"
PRINT " **    This is a Tutorial of the TOP96 Highscore-SUBroutine   **"
PRINT " ***************************************************************"
PRINT
PRINT "Please enter the actual score-parameter SCORE& (0...9999999)  ";
COLOR 14: INPUT "", score&: COLOR 15

PRINT
PRINT " +---------------------------------------------------------+"
PRINT " |  Now you'll be prompted for the remaining 3 Parameters. |"
PRINT " |  Answer all prompts with Enter to go the normal way!    |"
PRINT " +---------------------------------------------------------+"
PRINT "                     (Enter) ... proceed"
PRINT "                     (Esc)   ... Abort Top96"
DO: key$ = INKEY$: LOOP WHILE key$ = ""
IF key$ = CHR$(27) THEN END
CLS
PRINT
PRINT "Select Display Mode (Parameter HISCOREONLY%) :"
PRINT " (Enter) ... Highscore-List always displayed"
PRINT " (1)     ... Highscore-List only displayed if highscore reached"
PRINT " (Esc)   ... Abort TOP96"
PRINT
HISCOREONLY% = 0
DO: key$ = INKEY$: LOOP WHILE key$ = ""
IF key$ = "1" THEN HISCOREONLY% = 1
IF key$ = CHR$(27) THEN END

PRINT
PRINT "Enter the Player's Number or Name (Parameter PLAYERNAME$) :"
PRINT " (Enter) ... Single Player Game with name dialog"
PRINT " (1)     ... Player 1's score   with name dialog"
PRINT " (2)     ... Player 2's score   with name dialog"
PRINT " (3)     ... Player 3's score   with name dialog"
PRINT " (4)     ... Player 4's score   with name dialog"
PRINT " (5)     ... Name transferred via Parameter PLAYERNAME$, no name dialog"
PRINT " (Esc)   ... Abort TOP96"
PRINT
playername$ = ""  'Default: single player game
DO: key$ = INKEY$: LOOP WHILE key$ = ""
SELECT CASE key$
 CASE "1" TO "4": playername$ = key$
 CASE "5"
  COLOR 14
  INPUT "     Enter Player Name (max 14 characters) "; playername$
  COLOR 15
 CASE CHR$(27): END
END SELECT


PRINT
PRINT "Select Number of Lines (Parameter VGALINES%):"
PRINT " (Enter) ... 25 Lines (46 score entries, normal Mode, fits all graphic cards)"
PRINT " (1)     ... 50 Lines (96 score entries, VGA Text-Mode)"
PRINT " (Esc)   ... Abort TOP96"
PRINT
vgalines% = 0   'Default: no VGA-Lines (normal 25-Lines arrangement)
DO: key$ = INKEY$: LOOP WHILE key$ = ""
IF key$ = "1" THEN vgalines% = 1
IF key$ = CHR$(27) THEN END
IF vgalines% THEN scorefile$ = "C:\top96.dat" ELSE scorefile$ = "c:\top46.dat"
CALL TOP96(score&, HISCOREONLY%, playername$, vgalines%, scorefile$)
LOCATE 4

PRINT " +------------------------ Tutorial Pass Finished --------------------------+"
PRINT " |"
PRINT " | The SUB"
PRINT " |"
PRINT " |         TOP96 (score&, HISCOREONLY%, playername$, vgalines%, scorefile$)"
PRINT " |"
PRINT " | has been invoked by the following command"
PRINT " |"
PRINT " |    CALL Top96 ("; score&; ", "; HISCOREONLY%; ", "; CHR$(34) + playername$ + CHR$(34); ","; vgalines%; ", "; CHR$(34) + scorefile$ + CHR$(34); ")"
PRINT " |"
PRINT " | Highscores have been written to C:\TOP46.DAT or C:\TOP96.DAT"
PRINT " | Path and filename can be user-defined via the SCOREFILE$ parameter"
PRINT " |"
PRINT " +--------------------------------------------------------------------------+"
PRINT
PRINT "        (any Key)... Restart the Tutorial"
PRINT "        (Esc)    ... Abort TOP96"
DO: key$ = INKEY$: LOOP WHILE key$ = ""
IF key$ = CHR$(27) THEN END
LOOP

SUB TOP96 (score&, HISCOREONLY%, playername$, vgalines%, scorefile$)
'****************************************************************************
' TOP96 - QBasic-SUBroutine, generates a highscore sreen with 46/96 entries
' =========================================================================
' The 46 highest scores, or 96 respectively in VGA textmode are displayed on a
' highscore screen and saved in a highscore file.
'
' Subroutine parameters:
'  - score&       <== actual score, value range 0...99,999,999
'  - hiscoreonly% <== 0= highscore screen is displayed with each call of TOP96
'                     1= highscore screen is only displayed when a new entry
'                        in the highscore list is made
'  - playername$  <== Player-Name
'                     ""        = (empty string) Single Player Game. The
'                                 Player's name is fetched from a name-
'                                 input dialog
'                     "1"..."8" = Player-No in case of a muliplayer game, is
'                                 used to identify the player in the name
'                                 input dialog box
'                     "any name"= Direct transfer of the player's name string
'                                 (max 14 characters) from the calling pro-
'                                 gram. Name-input dialog is skipped. Use this
'                                 mode if the game itself already as a
'                                 player's name input dialog
'  - vgalines%    <== Number of lines
'                     0= 25 Lines, normal arrangement, fits all graphic cards
'                             ==> 46 entries in the highscore list
'                     1= 50 Lines, i.e. max VGA text-mode line count
'                             ==> 96 entries in the highscore list
'  - scorefile$   <== Path and name of the highscore file (e.g. "C:\TOP46.DAT"
'                             or ".\NIBBLES.SCR")
' Calling examples:
'  - CALL Top96 (4711, 0, "", 0, "C:\QIX.SCR")       '"normal usage"
'        - 4711 = points reached
'        - 0       = show scores always
'        - ""      = single-player game with name-entering dialog
'        - 0       = normal textscreen with 46 entries
'        - qix.scr = Highscore-file in the c:\ root directory
'  - CALL Top96 (points%, 1, "Tom", 1, ".\QIX.DAT")  '"special usage"
'        - points% = points reached
'        - 1       = show score-list only in case of a highscore-entry
'        - "Tom"   = Player-Name directly transferred (no name-entering dialog)
'        - 1       = VGA textscreen with 96 entries
'        - qix.dat = Highscore-File in current directory
'
' (c) Thomas Antoni, 09.07.99 - 24.07.99
'****************************************************************************

linecount% = 25: scorecount% = 46 'normale Anzahl Zeilen u. Hiscore-Eintrge
IF vgalines% THEN
  linecount% = 50  'VGA-Version: 50 Zeilen
  scorecount% = 96 '... und 96 Eintrge
END IF

'--- Hiscoreliste; Typdeklaration im Hauptprogramm!
DIM scorelist(linecount% * 2 - 4) AS hiscore

'-------- Heutiges Datum im Format "dd.mm.jj" und "dd.mm.jjjj" -------------
d$ = DATE$
datum$ = MID$(d$, 4, 2) + "." + LEFT$(d$, 2) + "." + RIGHT$(d$, 2)
datumlang$ = MID$(d$, 4, 2) + "." + LEFT$(d$, 2) + "." + RIGHT$(d$, 4)

'------------- Hiscore-Datei in Hiscore-Feld einlesen ----------------------
OPEN scorefile$ FOR RANDOM AS #1 LEN = 28 'Hiscore-Datei ffnen
FOR i% = 1 TO scorecount%             'alle Datenstze von Hiscore-Datei in
  GET #1, i%, scorelist(i%)           'Hiscore-Feld einlesen
NEXT i%
CLOSE #1

'------- Hiscore-Feld und -Datei initialisieren falls Datei ------------------
'------- noch nicht existent
IF scorelist(1).points = 0 THEN       'Existiert d.Hiscore-Datei noch nicht?
  OPEN scorefile$ FOR RANDOM AS #1 LEN = 28
  FOR i% = 1 TO (linecount% - 2) * 2  'Hiscore-Liste initialisieren
    scorelist(i%).rank = i%
    scorelist(i%).nam = SPACE$(14)    'Name=Blanks
    scorelist(i%).points = 0          '0 Punkte
    scorelist(i%).date = SPACE$(8)    'Datum=Leerzeichen
    PUT #1, i%, scorelist(i%)         'Datensatz in Hiscoredatei schreiben
  NEXT i%
  CLOSE #1
END IF

'---------- Falls neuer Hiscore: Playernamens-Eingabe vorbereiten ------------
IF score& > 99999999 THEN score& = 99999999 'Score auf 8 Stellen begrenzen
newhiscore% = 0                'Vorbesetzung: aktueller Score ist kein Hiscore

FOR i% = 1 TO scorecount%
  IF score& > scorelist(i%).points THEN 'Hiscore-Eintrag fllig !!!

    newhiscore% = 1            'Neuer Highscore-Eintrag ==> Jubelsound
    PLAY "MBT240L64MLO4CECECECECECECADADADADADADADADADFGFGFGFGFGFGFG"
    directname% = 0            'Vorbesetzung: Name wird i.Dialog erfragt
    SELECT CASE playername$
      CASE "": player$ = ""
      CASE "1" TO "8": player$ = "Player " + playername$
      CASE ELSE
        directname% = 1        'Namens-Eingabe berspringen
        neuername$ = LTRIM$(playername$)
    END SELECT
  
    IF directname% = 0 THEN
      WIDTH 80, 25             '25-Zeilen-Mode
      COLOR 1, 1: CLS          'Bildschirm blau einfrben

      COLOR 15, 4              'wei auf roten Kasten fr
      LOCATE 7, 15             'Namensdialog malen
      PRINT ""; STRING$(48, ""); ""
      FOR y% = 8 TO 18
      LOCATE , 15
      PRINT ""; SPACE$(48); ""
      NEXT y%
      LOCATE , 15
      PRINT ""; STRING$(48, ""); ""
      LOCATE 9, 21:  PRINT "Herzlichen Glckwunsch, "; playername$; " !!!"
      LOCATE 11, 21: PRINT "Du hast"; score&; " Punkte und kannst"
      LOCATE 12, 21: PRINT "Dich in die Highscore-Liste eintragen."
      LOCATE 14, 21: PRINT "Wie lautet Dein Name?"
      LOCATE 16, 23: PRINT player$;
      IF playername$ > "0" THEN PRINT " ="
      LOCATE 17, 34: PRINT ".............."
      LOCATE 18, 31: PRINT "(maximal 14 Zeichen)"

'---------- Namenseingabedialog in auf 14 Zeichen begrenztem Feld ------------
      COLOR 14, 1 'gelb auf blau
      text$ = "": key$ = ""

      DO
'--------- Enter-Taste bearbeiten ------------------------
        IF key$ = CHR$(13) THEN EXIT DO            'Ende wenn Enter bettigt

'--------- Backspace-Taste bearbeiten --------------------
        IF key$ = CHR$(8) AND LEN(text$) > 0 THEN  'Backspace u.Textlnge >0 ?
          text$ = LEFT$(text$, LEN(text$) - 1)     'Text um 1 Zeichen krzen

'--------- andere Tasten bearbeiten ----------------------
        ELSEIF key$ > CHR$(29) AND key$ < CHR$(255) THEN 'alphanum. Taste?
          IF LEN(text$) = 14 THEN  'Text hat schon die volle Lnge ==> letztes
            text$ = LEFT$(text$, LEN(text$) - 1) + key$  'Zeichen austauschen
          ELSE
            text$ = text$ + key$         'ansonsten Tastenzeichen anfgen
          END IF
        END IF
'--------- text$ + Cursor auf Bildschirm ausgeben ------
        LOCATE 16, 34: PRINT SPACE$(14); 'Eingabefeld lschen/blau frben
        LOCATE , 34: PRINT text$;                  'Text ausgeben
        IF LEN(text$) < 14 THEN csrpos% = POS(0) ELSE csrpos% = POS(0) - 1
        LOCATE 16 + 1, csrpos%, 1, 0, 2 'Cursor in Pixelzeilen 0-3 der darun-
                                        'terliegenden Zeile blinkend ausgeben
        DO: key$ = INKEY$: LOOP WHILE key$ = ""    'warten bis Taste bettigt
      LOOP
      LOCATE , , 0, 7, 8                 'Cursor wieder deaktivieren
      neuername$ = text$
    END IF

'----------- neuen Highscore in Hiscore-Feld eintragen ----------------------
    FOR k% = scorecount% - 1 TO i% STEP -1 'alle Eintrge mit kleinerem
                             'Score um einen Listenplatz nach unten schieben
      scorelist(k% + 1).nam = scorelist(k%).nam
      scorelist(k% + 1).points = scorelist(k%).points
      scorelist(k% + 1).date = scorelist(k%).date
    NEXT k%
    scorelist(i%).nam = neuername$    'neuen Eintrag vornehmen
    scorelist(i%).points = score&
    scorelist(i%).date = datum$

'--------------- neue Hiscore-Liste auf den Bildschirm ausgeben -------------
    GOSUB ShowScore              'Lokale Sub: Hiscore anzeigen
    kopftext$ = "COOL !  " + RTRIM$(scorelist(i%).nam) + ": Du hast" + STR$(score&) + " Punkte und somit einen Highscore!"
    GOSUB KopfFussZeile          'Lokale Sub: Kopfzeile mit Begrung u. Fu-
                                 'zeile mit Beenden-Dialog anzeigen

'--------------- neue Hiscore-Liste ins Hiscore-File transferieren -------------

    OPEN scorefile$ FOR RANDOM AS #1 LEN = 28
    FOR n% = 1 TO scorecount%
      PUT #1, n%, scorelist(n%)
    NEXT n%
    CLOSE #1
    EXIT FOR

  END IF
NEXT i%

'------------- auch bei nicht erreichtem Eintrag Highscore anzeigen ----------
'------------- wenn  hiscoreonly%=0
IF (newhiscore% = 0) AND (HISCOREONLY% = 0) THEN
  PLAY "MBO0L32cdcdcdcdcd"        'Trauersound, weil kein Eintrag
  GOSUB ShowScore                 'Lokale Sub, zeigt Hiscore-Liste an
  kopftext$ = "Du hast" + STR$(score&) + " Punkte. Sorry - leider kein Highscore!"
  GOSUB KopfFussZeile             'Kopf- und Fuzeile ausgeben
END IF
GOTO top96end                     'Aussprung aus der SUB TOP96

'--------- ShowScore: Lokale Subroutine, zeigt Hiscore-Liste an   ------------
ShowScore:
IF vgalines% THEN WIDTH 80, 50    'VGA-Bildschirm 50 Zeilen 'a 80 Spalten
COLOR 0, 7: CLS                   'schwarz auf hellgrau
platz% = 1: border$ = ""          'Rangnummer und Trennlinie initialisieren
FOR q% = 2 TO 40 STEP 38          '2 Durchlufe: fr linke und rechte Bild-
                                  'schirmhlfte (Startspalte 2 und 40)
  FOR y% = 2 TO linecount% - 1    'Schleife ber alle Zeilen
    LOCATE y%, q%                 'Cursor auf Startspalte
    COLOR 0, 7                    'Normalfarbe = schwarz auf hellgrau
    PRINT border$;                'Trennlinie ausgeben
    IF platz% = i% AND newhiscore% = 1 THEN
      COLOR 15, 2                 'neuen Eintrag wei auf grn highlighten
    END IF
    PRINT USING "##"; scorelist(platz%).rank;
    PRINT ". "; scorelist(platz%).nam; " ";
    PRINT USING "########"; scorelist(platz%).points;
    PRINT "  "; scorelist(platz%).date;
    platz% = platz% + 1           'Rangnummer erhhen
  NEXT y%
  border$ = " "
NEXT q%                           'das gleiche fr d.rechte Bildschirmhlfte
RETURN

'--------- KopfFussZeile: Lokale Subroutine z.Anzeigen von Kopf- -------------
'--------- und Fuzeile mit Drehbalken, Beendigungshinweis u.Uhrzeit ---------
KopfFussZeile:
LOCATE 1, 1                          'Kopfzeile mit Begrungstext
COLOR 15, 4                          'Kopfzeile rot einfrben
PRINT SPACE$(80)
LOCATE 1, (80 - LEN(kopftext$)) / 2  'Kopfzeile mittig anzeigen
PRINT kopftext$

LOCATE linecount%, 1                 'Fuzeile
PRINT "         Beenden: Beliebige Taste                                             ";
BEEP
DO
  taste$ = INKEY$
  Starttime! = TIMER
  DO: LOOP UNTIL TIMER > Starttime! + .15     '150 ms Wartezeit
  LOCATE , 57
  PRINT " "; datumlang$; "  "; TIME$;  'Uhrzeit + Datum anzeigen
  LOCATE , 2                             'Drehbalken als Ttigkeitsanzeige
  k% = k% + 1
  IF k% > 4 THEN k% = 1
  SELECT CASE k%
    CASE 1: PRINT "";
    CASE 2: PRINT "\";
    CASE 3: PRINT "";
    CASE 4: PRINT "/";
  END SELECT
LOOP WHILE taste$ = ""
RETURN

top96end:
WIDTH 80, 25       '25-zeiligen...
COLOR 15, 0: CLS   '...S/W-Bildschirm restaurieren
END SUB

