 '****************************************************************************
' TXT2HTML.BAS = Textdatei in HTML-Datei umwandeln
' ================================================
' Dieses Q(uick)Basic-Programm wandelt alle im Verzeichnis C:\TMP\ vorge-
' fundenen Windows-, Unicode- oder DOS-Textdateien mit der Dateiendung
'  ".TXT" in gleichnamige HTML-Dateien mit der Dateiendung ".HTM" um. Die
' resultierenden HTML-Dateien werden im Unterverzeichnis C:\TMP\HTML\
' hinterlegt und lassen sich mit jedem beliebigen Web-Browser betrachten.
' Die TXT-Dateien selbst bleiben unveraendert.
'
' Wenn eine TXT-Datei einen langen Dateinamen hat, der nicht den 8+3-DOS-
' Konventionen entspricht, dann erhaelt die resultierende HTML-Datei einen
' abgekuerzeten 8+3-Namen. Aus "Barcelona_Reise.txt" wird z.B.
' "Barcel~1.htm".
'
' Anmerkung
' -------------------------------------
' Eine HTML-Indexdatei INDEX.HTM mit einem anklickbaren Inhaltsverzeichnis
' aller erzeugten HTML-Dateien koennen Sie mit meinem beiliegenden Programm
' INDEXGEN.BAS bequem erzeugen
'
' Optionen
' -------------------------------------
' Im Optionen-Dialog hat der Anwender folgende Wahlmoeglichkeiten:
' - Die zu wandelnden TXT-Dateien koennen im Windows-ANSI-Format (Default),
'   im DOS-ASCII-Format oder im Unicode-Format (UTF-16) vorliegen.
'   Das Programm wandelt ASCII- und Unicode-Dateien Zeile fuer Zeile in
'   ANSI-Text um, bevor es die Zeile in HTML konvertiert.
' - Die erste Zeile kann wahlweise als Ueberschrift formatiert werden
'   mit <h1> und in der Schriftart "Arial Narrow" (Default: keine
'   Ueberschrifts-Formatierung)
' - Das Programm wandelt Web- und Mailadressen auf Wunsch automatisch
'   in anklickbare Web-Links um (Default)
' - Bei Bedarf wird am Ende des HTML-Dokuments eine Fusszeile mit
'   Copyright-Vermerk "(c) Thomas Antoni" und Datum/Uhrzeit eingefuegt
'   (Default)
'
' Folgende Variablen dienen zur Vorgabe dieser Optionen:
'        - TextFormat%     = Format des zu konvertierenden Textes
'                                  0 = Windows-ANSI (Vorbesetzung)
'                                  1 = DOS-ASCII-Format
'                                  2 = Unicode-Format (UTF-16)
'        - Zeil1Ueberschr% = Erste Zeile als Ueberschrift formatieren
'                                  0 = nein (Vorbesetzung)
'                                  1 = ja
'        - Weblinks%       = Web- und Mailadressen in Links umwandeln
'                                  0 = nein
'                                  1 = ja (Vorbesetzung)
'        - Fusszeile%      = Fusszeile  mit Datum/Uhrzeit einfuegen
'                                  0 = nein
'                                  1 = ja (Vorbesetzung)
'
' Die gewaehlten Optionen gehen bei Verlassen des Programms nicht verloren,
' sondern sie werden in der Datei C:\TXT2HTML.INI abgespeichert und
' beim naechsten Programmstart wieder aktiviert.
'
' Die zu konvertierenden TXT-Dateien muessen folgende Voraussetzungen
' erfuellen:
' - Der Text wird in der vorhandenen Formatierung mit allen Zeilenumbruechen
'   in die HTML-Datei uebernommen. TXT2HTML fuegt keinerlei Zeilenumbrueche
'   und Leerzeilen hinzu. Sinnvoll ist es z.B., die TXT-Datei mit 80 Zeichen
'   je Zeile und mit Leerzeilen zwischen den Absaetzen vorzuformatieren.
' - Internetadressen muessen mit "www.", "http://" oder "https://" beginnen.
'   Direkt nach einer Internetadresse darf nur dann ein Punkt stehen, wenn
'   auf diesen ein Leerzeichen oder ein Zeilenumbruch folgt.
' - Internet- und E-Mail-Adressen durfen nicht durch einen Zeilenumbruch
'   unterbrochen werden, sondern muessen jeweils komplett in einer Zeile
'   stehen.
' - Internetadressen werden dergestalt in Links umgewandelt, dass die
'   angeklickte Webseite grundsaetzlich in einem neuen Browserfenster
'   erscheint. Dies bewirkt der vom Programm eingefuegte HTML-Parameter
'   target="_blank".
' - Die TXT-Dateien sollten keine Tabulatoren (CHR$(09)) enthalten, weil fuer
'   deren ordnungsgemaesse Darstellung keine Garantie uebernommen werden
'   kann. Tabulatoren sollte man vor der Konvertierung durch Leerzeichen
'   ersetzen.
' - Zeilenumbrueche knnen durch folgende Zeichenfolgen dargestellt werden:
'     > CR LF  = 0D0A_hex
'     > CR     = 0D_hex
'     > LF     = 0A_hex
'
' Zu den unterstuetzten Textformaten
' -------------------------------------
' - Fuer den ANSI-Code wird der Zeichensatz ISO 8859-1 vorausgesetzt
'   ("Latin 1/Westlich")
' - Fuer den ASCII-Code wird MS-DOS-Codeseite 437 ("Englisch") vorausgesetzt
' - Fuer den Unicode wird die Kodierung UTF-16 vorausgesetzt, wobei nur
'   jeweils das niederwertige Byte (=ISO 8859-1) bearbeitet wird.
'
' Zur Behandlung von Unicode-Textdateien
' --------------------------------------
' Das Programm wandelt Unicode-Textdateien (UTF-16-Kodierung) vor der HTML-
' Konvertierung zunaechst in ANSI-Text um. Fuer die Codes 0 bis
' 255 enthaelt die Unicode-Codetabelle als Untermenge (Subset) den in den
' westlichen Laendern gebraeuchlichen Windows-ANSI- Zeichensatz ISO 8859-1
' ("Latin 1 / Westlich"). Das hoeherwertige Byte der einzelnen
' 16-Bit-Codestellen wird hierbei also quasi nicht benutzt und enthaelt
' jeweils ausschliesslich Nullen (d.h. das "Nullzeichen" CHR$(0) ).
' Daher reicht es fuer die Umwandlung von Unicode- in ANSI- Text normalerweise
' aus, alle im Text vorhandenen Nullzeichen CHR$(0) zu loeschen. Dieses
' vereinfachte Verfahren wird vom Programm verwendet. Es versagt erst dann,
' wenn exotische fremdsprachliche Sonderzeichen vorhanden sind.
'
' Es gibt bei Unicode noch eine Besonderheit zu beachten: Einige Unicode-
' Textdateien enthalten in den ersten beiden Bytes die sogenannte
' BOM-Markierung (Byte Order Mark) FFFE_hexa (CHR$(255) + CHR$(254)) oder
' FEFF_hexa (CHR$(254) + CHR$(255)). Auch MS Word und der Windows-Editor
' fuegen diese Markierung vor dem eigentlichen Text ein. Die BOM-Markierung
' kennzeichnet die Byte-Reihenfolge innerhalb der 16-Bit- Zeichencodes -
' Low-Byte vor High-Byte oder umgekehrt. Die beiden BOM-Markierungs-Bytes
' muessen, falls vorhanden, bei der Konvertierung ins ANSI-Format
' ausgeblendet werden.

' (c) Thomas Antoni, 27.1.2005 - 29.9.2009
'       thomas@antonis.de  --- www.qbasic.de  --- www.antonis.de
'
'***************************************************************************
'
'***************************************************************************
'                      Deklaration von SUBs und FUNCTIONs
'***************************************************************************
DECLARE FUNCTION ASCII2ANSI$ (t$, CodeTabelle%())
                                      'ASCII- in ANSI-Text wandeln
DECLARE SUB DIRlist ()                'TXT-Textdateien im Verzeichnis
                                      '"c:\tmp\" suchen und deren Namen in
                                      '"c:\tmp\dirtxt.tmp" hinterlegen
DECLARE FUNCTION mail2link$ (t$)      'Mailadressen in Links umwandeln
DECLARE SUB Replace (t$, oldstring$, newstring$)
                                      'beliebigen Text suchen und ersetzen
DECLARE FUNCTION Sonderz2Entities$ (t$)
                                      'Sonderzeichen in HTML-Entities wandeln
DECLARE FUNCTION URL2link$ (t$)       'Internetadressen in Link umwandeln
'
'***************************************************************************
'                ASCII-ANSI-Code-Umwandlungstabelle einlesen
'               aus DATA-Zeilen; fuer die Function ASCII2ANSI$
'***************************************************************************
DIM tabelle%(128)
FOR i% = 0 TO 127               'ANSI Codes fuer die ASCII-Zeichen 128-255
  READ tabelle%(i%)
NEXT
'
DO                              'Das Programm kann beliebig oft wiederholt
                                'werden
'
'***************************************************************************
'                Rot-weissen Startbildschirm anzeigen
' Unveraenderbare (statische) Inhalte: Titelzeile, Kurzanleitung
' und Options-Feld
'***************************************************************************
COLOR 4, 7                      'rote Schrift auf hellgrau
WIDTH 80, 50                    'grosser VGA-Bildschirm mit 50 Zeilen
CLS                             'Bildschirm hellgrau einfaerben
COLOR 15, 4                     'Titelzeile weiss auf rot
PRINT "           TXT2HTML V1.0 -  TXT-HTML-Konverter (c) Thomas Antoni  2009          ";
'
FOR Zeile% = 2 TO 49            'rote Seitenbalken malen
  LOCATE Zeile%, 1: PRINT " ";
  LOCATE Zeile%, 80: PRINT " ";
NEXT Zeile%
'
LOCATE 50, 1: PRINT SPC(79); " "; 'Fusszeile rot malen
'
COLOR 0, 7                        'Schwarz auf Weiss
'
LOCATE 4, 19: PRINT "                 "
LOCATE 5, 19: PRINT "                              "
LOCATE 6, 19: PRINT "                               "
LOCATE 7, 19: PRINT "                            "
'
LOCATE 9, 4
PRINT " Dieses Programm konvertiert alle im Verzeichnis C:\TMP\ vorgefundenen"
LOCATE 10, 4
PRINT " Textdateien *.TXT zu HTML-Webseiten *.HTM und hinterlegt sie"
LOCATE 11, 4
PRINT " dort ins Unterverzeichnis C:\TMP\HTML\ ."
'
'******************************** Optonsfeld anzeigen **********************
'Anmerkung: die Anzeige erfolgt ohne die "X" fuer aktivierte Optionen.
'Die "X" werden spaeter durch die lokale SUB OptionsXanzeige eingetragen
'
Zeile% = 14            'Beginn des
Spalte% = 16           '... Optionenfeldes
LOCATE Zeile%
LOCATE , Spalte%: PRINT "ͻ"
LOCATE , Spalte%: PRINT "              OPTIONEN ...                     "
LOCATE , Spalte%: PRINT "      ndern mit den Tasten [F1]...[F4]        "
LOCATE , Spalte%: PRINT "      Zurcksetzen mit [F5]                    "
LOCATE , Spalte%: PRINT "͹"
LOCATE , Spalte%: PRINT " [F1] Format der Textdatei(en)                 "
LOCATE , Spalte%: PRINT "  "
LOCATE , Spalte%: PRINT "           [ ] Windows-ANSI-Format             "
LOCATE , Spalte%: PRINT "           [ ] DOS-ASCII-Format                "
LOCATE , Spalte%: PRINT "           [ ] Unicode-Format (UTF-16)         "
LOCATE , Spalte%: PRINT "͹"
LOCATE , Spalte%: PRINT " [F2] 1. Zeile als berschrift formatieren     "
LOCATE , Spalte%: PRINT "  "
LOCATE , Spalte%: PRINT "           [ ] Nein                            "
LOCATE , Spalte%: PRINT "           [ ] Ja                              "
LOCATE , Spalte%: PRINT "͹"
LOCATE , Spalte%: PRINT " [F3] Web- und Mailadressen in Links umwandeln "
LOCATE , Spalte%: PRINT "  "
LOCATE , Spalte%: PRINT "           [ ] Nein                            "
LOCATE , Spalte%: PRINT "           [ ] Ja                              "
LOCATE , Spalte%: PRINT "͹"
LOCATE , Spalte%: PRINT " [F4] Fuzeile mit Datum/Uhrzeit einfgen      "
LOCATE , Spalte%: PRINT "  "
LOCATE , Spalte%: PRINT "           [ ] Nein                            "
LOCATE , Spalte%: PRINT "           [ ] Ja                              "
LOCATE , Spalte%: PRINT "ͼ"
'
'
'******* Optionen aus INI-Datei "c:\txt2html.ini" lesen und "X" anzeigen *****
'Die Programmpassagen zum Lesen und Shreiben der Optionen wurde aus meinem
'bewhrtem Programm ClockFix bernommen.
'Wie ich durch Tests herausfand, muss die Fehlermeldung beim ffnen einer
'noch nicht vorhandenen INI-Datei unterschiedlich unterschiedlich behandelt
'werden bei BAS- und bei -EXE-Programmen.
ON ERROR GOTO neu                   'Fehlerbearbeitung "nicht vorhandene
                                    'Datei" (kommt nur bei kompiliertem .EXE
                                    'Programm)
OPEN "c:\txt2html.ini" FOR INPUT AS #1
IF LOF(1) = 0 THEN                  'INI-Datei existiert noch nicht (Laenge =
                                    '0 Bytes (funktioniert nur bei BAS-Progr.)
                                    '=> Vorbesetzungsverte (Defaults) setzen
  TextFormat% = 0        'TXT-Datei hat Windows-ANSI-Format
  Zeil1Ueberschr% = 0    '1. Zeile nicht als Ueberschrift formatieren
  Weblinks% = 1          'Web- u.Mailadressen in Links umwandeln
  Fusszeile% = 1         'Fusszeile einfuegen (Nachspann)
ELSE
  INPUT #1, Dummy$, TextFormat%, Zeil1Ueberschr%, Weblinks%, Fusszeile%
                         'Optionen aus Datei bernehmen
END IF
CLOSE #1
GOTO weiter
neu:                     'INI-Datei existiert noch nicht
                         '=> Vorbesetzungsverte (Defaults) setzen
  TextFormat% = 0        'TXT-Datei hat Windows-ANSI-Format
  Zeil1Ueberschr% = 0    '1. Zeile nicht als Ueberschrift formatieren
  Weblinks% = 1          'Web- u.Mailadressen in Links umwandeln
  Fusszeile% = 1         'Fusszeile einfuegen (Nachspann)
weiter:
'
GOSUB OptionsXanzeige  '"X" an den richtigen Stellen im Optionsfeld anzeigen
'
'***************************************************************************
'                          Optionen bearbeiten
'            (lesen, aendern, "X" anzeigen, abspeichern)
'***************************************************************************
'
'****************** Optionen aendern falls F1...F5 betaetigt *****************
COLOR 15, 1                                  'weiss auf blau
LOCATE 42, 5
PRINT " [beliebige Taste]...Konvertierung starten   [F1-F5]...Optionen ndern "
COLOR 0, 7                                   'schwarz auf hellgrau
'
DO
DO: taste$ = INKEY$: LOOP UNTIL taste$ <> "" 'Warten auf Tastenbetaetigung
Optionenaenderung% = 1     'Vorbesetzung "Optionen geaendert"
'
SELECT CASE taste$
  CASE CHR$(0) + CHR$(59)  'F1-Taste ======> Textformat bearbeiten
    TextFormat% = TextFormat% + 1
    IF TextFormat% = 3 THEN TextFormat% = 0
  CASE CHR$(0) + CHR$(60)  'F2-Taste ======> 1.Zeile = Ueberschrift bearb.
    Zeil1Ueberschr% = Zeil1Ueberschr% + 1
    IF Zeil1Ueberschr% = 2 THEN Zeil1Ueberschr% = 0
  CASE CHR$(0) + CHR$(61)  'F3-Taste ======> Linkumwandlung bearbeiten
    Weblinks% = Weblinks% + 1
    IF Weblinks% = 2 THEN Weblinks% = 0
  CASE CHR$(0) + CHR$(62)  'F4-Taste ======> Fusszeile bearbeiten
    Fusszeile% = Fusszeile% + 1
    IF Fusszeile% = 2 THEN Fusszeile% = 0
  CASE CHR$(0) + CHR$(63)  'F5-Taste ======> Optionen zuruecksetzen
    TextFormat% = 0        'TXT-Datei hat Windows-ANSI-Format
    Zeil1Ueberschr% = 0    '1. Zeile nicht als Ueberschrift formatieren
    Weblinks% = 1          'Web- u.Mailadressen in Links umwandeln
    Fusszeile% = 1         'Fusszeile einfuegen (Nachspann)
  CASE ELSE                'andere Taste ==> Konvertierung starten
    Optionenaenderung% = 0 'Optionen nicht geaendert
END SELECT
'
'
'************** X"-Anzeigen fuer Optionen aktualisieren *********************
IF Optionenaenderung% = 1 THEN       'F1...F5 betaetigt
  GOSUB OptionsXanzeige  '"X" an d.richtigen Stellen im Optionsfeld anzeigen
                         'Optionen abspeichern
  OPEN "c:\txt2html.ini" FOR OUTPUT AS #1
  WRITE #1, "Ini-Datei fuer TXT2HTML (c)T.Antoni", TextFormat%, Zeil1Ueberschr%, Weblinks%, Fusszeile%
  CLOSE #1
'
'************** Optionen in txt2html.ini abspeichern ************************
ELSE                       'andere Taste betaetigt ==> keine weiteren
                           'Optionsaenderungen bearbeiten, sondern
  EXIT DO                  'Konvertierung starten
END IF
LOOP                       'Ruecksprung zur erneuten Tastenabfrage
'
LOCATE 42, 2
PRINT SPACE$(78);           'Eingabeaufforderungs-Zeile loeschen
'
'****************************************************************************
'                 Aktuelle .TXT-Datei ermitteln und oeffnen
'****************************************************************************
'
'******* Namen der in C:\TMP\*.TXT vorhandenen Textdateien einlesen und *****
'******* Dateiliste in C:\TMP\dirtxt.tmp ablegen                        *****
CALL DIRlist
'
'******* Namen der aktuellen ASCII-Text-Datei einlesen **********************
AnzahlDateien% = 0
SHELL "MD c:\tmp\HTML"    'Verzeichnis zum Hinterlegen der resultierenden
                          'HTML-Dateien erstellen. diese Anweisung verursacht
                          'die DOS - Fehleranzeige "Erweiterter Fehler 183",
                          'wenn das Verzeichnis HTML\ bereits vorhanden ist
COLOR , 4: LOCATE 42, 80: PRINT " "; 'roten Rand restaurieren: erste zwei
LOCATE 43, 1: PRINT " ";             'Buchstaben "Er" d.Fehlermeldg. loeschen)
COLOR , 7: PRINT SPC(30);            'Rest der Fehlermeldung 183 in der
                                     'Anzeige loeschen
OPEN "c:\tmp\dirtxt.tmp" FOR INPUT AS #3
DO UNTIL EOF(3)                    'Schleife ueber alle Textdateien
  LINE INPUT #3, Datei$            'Textzeile mit Textdatei-Namen einlesen
  AnzahlDateien% = AnzahlDateien% + 1
  LOCATE 42, 5: PRINT "Bearbeitete Datei   : "
  LOCATE 42, 29: PRINT SPC(40);    'alte Dateinamensanzeige loeschen
  LOCATE 42, 29: PRINT Datei$;
  LOCATE 42, 44: PRINT "("; AnzahlDateien%; ". Datei )"
  LOCATE 44, 5: PRINT "Umgewandelte Zeilen : "
  LOCATE 44, 28: PRINT SPC(10); 'alte Zeilenzahl-Anzeige loeschen
'
'*********- aktuelle TXT-Textdatei und HTML-Ergebnisdatei oeffnen **********
  OPEN "C:\tmp\" + Datei$ FOR INPUT AS #1            'TXT-Datei oeffnen
  HTMDatei$ = LEFT$(Datei$, LEN(Datei$) - 3) + "HTM" 'Datei-Endung TXT durch
                                                     'HTM ersetzen
  OPEN "C:\tmp\HTML\" + HTMDatei$ FOR OUTPUT AS #2   'HTML-Datei oeffnen
'
'****************************************************************************
'                 Vorspann in HTML-Datei einfuegen
'****************************************************************************
'
PRINT #2, "<!DOCTYPE HTML PUBLIC "; CHR$(34);
PRINT #2, "-//W3C//DTD HTML 4.01 Transitional//EN"; CHR$(34); ">"
                               'Dokumententyp und HTML-Sprachversion angeben
'
PRINT #2, "<html>"
PRINT #2, "<head>"
d$ = LEFT$(Datei$, LEN(Datei$) - 4)  '".TXT" aus dem Dateinamen
PRINT #2, "<title>" + d$ + "</title>"  'ausblenden fuer die Titelanzeige
'
PRINT #2, "<meta http-equiv="; CHR$(34); "Content-Type"; CHR$(34);
PRINT #2, " content="; CHR$(34); "text/html; charset=iso-8859-1"; CHR$(34); ">"
                               'Text-Zeichensatz angeben
'
PRINT #2, "<!-- This File has been automatically created by TXT2HTML -->"
PRINT #2, "<!-- ~ TXT2HTML converts any Windows-ANSI, Unicode and DOS-ASCII textfile into HTML -->"
PRINT #2, "<!-- ~ TXT2HTML has been written in QBasic by (c)Thomas Antoni, 2009 -->"
PRINT #2, "<!-- ~ TXT2HTML is freeware. Download on www.qbasic.de -->"
'
PRINT #2, "</head>"
PRINT #2, "<body> <center> <table width=90%><tr><td><pre>"
                 'Die Anzeige der HTML-Datei erfolgt "preformatiert" (in
                 'nichtproportionaler Schriftart mit allen Leerzeichen und
                 'Zeilenvorschueben) sowie mit einem Rand von je 5% auf
                 'der linken und der rechten Bildschirmseite
'
'****************************************************************************
'       Alle Textzeilen "HTMLisieren" und in HTML-Datei eintragen
'****************************************************************************
'
'************************ Erste Zeile bearbeiten ****************************
'---- erste Textzeile einlesen
IF NOT EOF(1) THEN          'End Of File bereits erkannt -> Dateigroesse = 0
                            'Erste Zeile ueberspringen (Es wird sofort zum
                            '"Nachspann" gesprungen und eine HTML-Datei ohne
                            'Inhalt angelegt)
  LINE INPUT #1, t$
  ZeilenAnz& = 1            'Anzahl der bearbeiteten Zeilen
'
'---- ASCII-ANSI-Wandlung
  IF TextFormat% = 1 THEN t$ = ASCII2ANSI$(t$, tabelle%())
'
'---- UNICODE-ANSI-Wandlung (siehe Kommentar-Kopf oben im Quelltext)
  IF TextFormat% = 2 THEN   'Unicode-Text -> Die ersten beiden Textbytes
                            'koennen die BOM-Markierung (Byte Order Mark)
                            'FFFE_hexa oder FEFF_hexa enthalten, die
                            'auszublenden ist
    IF LEN(t$) >= 2 THEN
      BOM$ = LEFT$(t$, 2)   'erste zwei Textzeichen lesen
      IF (BOM$ = CHR$(255) + CHR$(254)) OR (BOM$ = CHR$(254) + CHR$(255)) THEN
                            'BOM-Markierung vorhanden?
        t$ = RIGHT$(t$, LEN(t$) - 2) 'BOM-Markierung ausblenden
      END IF
    END IF
    CALL Replace(t$, CHR$(0), "")  'Nullzeichen loeschen
    CALL Replace(t$, CHR$(10), "") 'ueberfluessige CR-Zeichen
  END IF                           '.. (0A_hex = Wagenruecklauf) loeschen
'
'---- Sonderzeichen in HTML-Entities wandeln
  t$ = Sonderz2Entities$(t$)
'
'---- Erste Zeile in fett formatierte HTML-Ueberschrift wandeln,
'---- falls gewuenscht
  IF Zeil1Ueberschr% = 1 THEN
    Zeile1$ = "</pre><font face=" + CHR$(34) + "Arial Narrow, Arial, Helvetica"
    Zeile1$ = Zeile1$ + CHR$(34) + ">"       'Schriftart fuer Ueberschrift
    Zeile1$ = Zeile1$ + "<h1>" + t$ + "</h1></font><pre>"
    t$ = Zeile1$
  END IF
'
'---- Mail- und Internetadressen in Links umwandeln, falls gewuenscht
'---- (wird auch fuer die erste Zeile unterstuetzt)
  IF Weblinks% = 1 THEN t$ = URL2link$(mail2link$(t$))
'
'---- erste HTML-Zeile abspeichern
  PRINT #2, t$
ELSE                    'Dateigroesse = 0 -> "0 Zeilen bearbeitet"
  LOCATE 44, 28
  PRINT "0"
END IF
'
'*********************** Folgezeilen bearbeiten *****************************
DO UNTIL EOF(1)         'Schleife wiederholen bis alle Zeilen eingelesen
  LINE INPUT #1, t$     'Textzeile einlesen
  ZeilenAnz& = ZeilenAnz& + 1
  LOCATE 44, 28
  PRINT ZeilenAnz&
'
'---- ASCII-ANSI-Wandlung
  IF TextFormat% = 1 THEN t$ = ASCII2ANSI$(t$, tabelle%())
'
'---- UNICODE-ANSI-Wandlung (siehe Kommentar-Kopf oben im Quelltext)
  IF TextFormat% = 2 THEN
    CALL Replace(t$, CHR$(0), "")  'Nullzeichen loeschen
    CALL Replace(t$, CHR$(10), "") 'ueberfluessige CR-Zeichen
  END IF                           '.. (0A_hex = Wagenruecklauf) loeschen
'
'---- Sonderzeichen in HTML-Entities wandeln
  t$ = Sonderz2Entities$(t$)
'
'---- Mail- und Internetadressen in Links umwandeln, falls gewuenscht
  IF Weblinks% = 1 THEN t$ = URL2link$(mail2link$(t$))
'
'----  HTML-Zeile abspeichern
  PRINT #2, t$
LOOP
'
'****************************************************************************
'     Nachspann mit Datum, Uhrzeit und Copyright in HTML-Datei einfuegen
'****************************************************************************
'
IF Fusszeile% = 1 THEN
  d$ = DATE$                       'System-Datum einlesen
  Datum$ = MID$(d$, 4, 2) + "." + LEFT$(d$, 2) + "." + RIGHT$(d$, 4)
            'System-Datum mm-dd-jjjj ins deutsche Format dd.mm.jjjj umwandeln
  PRINT #2, "</pre><hr><br><font size = 2>Converted to HTML by TXT2HTML ";
  PRINT #2, "(&copy;Thomas Antoni), "; Datum$; ",  "; TIME$; "</font><br><br>"
END IF
'
PRINT #2, "</td></tr></table></center></body></html>"
CLOSE #1, #2
'
'****************************************************************************
'  Wiederholen bis alle TXT-Dateien konvertiert sind
'****************************************************************************
LOOP
CLOSE #3
KILL "c:\tmp\dirtxt.tmp"
LOCATE 46, 5
PRINT "Fertig!"; AnzahlDateien%; "Datei(en) konvertiert und in ";
PRINT "C:\TMP\HTML\ hinterlegt"
'
'****************************************************************************
'             Fertigmeldung und Wiederholen/Beenden-Dialog
'****************************************************************************
LOCATE 48, 5
COLOR 15, 1                                  'weiss auf blau
PRINT "      [beliebige Taste]...Beenden     [Eing]...Neue Konvertierung      "
DO: taste$ = INKEY$: LOOP UNTIL taste$ <> "" 'Warten auf belieb. Tastendruck
IF taste$ <> CHR$(13) THEN
  CLS
  END
END IF
LOOP                                         'zurueck z. Programmwiederholg.
END
'
'****************************************************************************
'  "Alter Testrahmen" fuer die Functions mail2link$ und URL2link$
'  ==================
'         (Mail- und Internetadressen in Links wandeln)
' Kann gelegentlich geloescht, stoert aber nicht, weil der Code hinter dem
' Programmende steht und daher nie durchlaufen wird. Der Testrahmen kann
' fuer spaetere Fehlersuche und Ergaenzungen vielleicht noch von Nutzen sein.
'****************************************************************************
CLS
DO
PRINT
PRINT "Gib einen Text mit URL(s) und Mailadressen ein (Eingabetaste zum Beenden): "
LINE INPUT t$
IF t$ = "" THEN END                  'Beenden mit Eingabetaste
PRINT
PRINT URL2link$(mail2link$(t$))      'Mailadressen und URLs in Links umwandeln
LOOP                                 'und anzeigen
END
'********************** Ende "Alter Testrahmen" *****************************
'
'
'****************************************************************************
' OptionsXanzeige = Lokale SUBroutine zum Anzeigen der "X" an den richtigen
' ===============   Stellen im Optionsfeld
'****************************************************************************
OptionsXanzeige:
'
'************** Spalte, in der die "X" stehen ermitteln *********************
xs% = Spalte% + 13
'
'************** alle "X" loeschen *******************************************
LOCATE Zeile% + 7, xs%: PRINT " "
LOCATE Zeile% + 8, xs%: PRINT " "
LOCATE Zeile% + 9, xs%: PRINT " "
LOCATE Zeile% + 13, xs%: PRINT " "
LOCATE Zeile% + 14, xs%: PRINT " "
LOCATE Zeile% + 18, xs%: PRINT " "
LOCATE Zeile% + 19, xs%: PRINT " "
LOCATE Zeile% + 23, xs%: PRINT " "
LOCATE Zeile% + 24, xs%: PRINT " "
'
'************** "X" an den richtigen Stellen setzen *************************
LOCATE Zeile% + 7 + TextFormat%, xs%: PRINT "X"
LOCATE Zeile% + 13 + Zeil1Ueberschr%, xs%: PRINT "X"
LOCATE Zeile% + 18 + Weblinks%, xs%: PRINT "X"
LOCATE Zeile% + 23 + Fusszeile%, xs%: PRINT "X"
RETURN
'
'****************************************************************************
' Code-Umwandlungstabelle ASCII-ANSI fuer die Function ASCII2ANSI$
' ================================================================
' Diese Tabelle enthaelt die aequivalenten ANSI-Codes fuer die ASCII-
' Codestellen 128 bis 255. An jedem der ASCII-Code-Plaetze 128...255 ist der
' dafuer einzusetzende ANSI-Code angegeben. Alle Zeichen, fuer die es bei
' ANSI keine Entsprechung gibt, werden durch ein Leerzeichen ersetzt (CHR$(032)).
'****************************************************************************
DATA                                         199, 252: 'ASCII-Codes 128-129
DATA 233, 226, 228, 224, 229, 231, 234, 235, 232, 239: 'ASCII-Codes 130-139
DATA 238, 236, 196, 197, 201, 230, 198, 244, 246, 249: 'ASCII-Codes 140-149
DATA 255, 249, 255, 214, 220, 162, 163, 165, 032, 131: 'ASCII-Codes 150-159
DATA 225, 237, 243, 250, 241, 209, 032, 032, 191, 043: 'ASCII-Codes 160-169
DATA 172, 189, 188, 161, 171, 187, 124, 124, 124, 124: 'ASCII-Codes 170-179
DATA 043, 043, 043, 043, 043, 043, 124, 043, 043, 043: 'ASCII-Codes 180-189
DATA 043, 043, 043, 043, 043, 043, 045, 043, 043, 043: 'ASCII-Codes 190-199
'
DATA 043, 043, 043, 043, 043, 045, 043, 043, 043, 043: 'ASCII-Codes 200-209
DATA 043, 043, 043, 043, 043, 043, 043, 043, 043, 124: 'ASCII-Codes 210-219
DATA 043, 124, 124, 043, 170, 223, 032, 182, 202, 243: 'ASCII-Codes 220-229
DATA 181, 134, 164, 056, 254, 240, 156, 248, 202, 110: 'ASCII-Codes 230-239
DATA 061, 177, 032, 032, 131, 131, 247, 126, 176, 183: 'ASCII-Codes 240-249
DATA 173, 086, 179, 178, 124, 255                    : 'ASCII-Codes 250-255
'

FUNCTION ASCII2ANSI$ (t$, CodeTabelle%())
'***************************************************************************
' ASCII2ANSI$ = Umwandlung eines ASCII-Textes in einen ANSI-Text
' ===========
' Diese Q(uick)Basic-FUNCTION wandelt einen DOS-ASCII-Text t$ ins
' Windows-ANSI-Format um. Die ASCII- und ANSI-Codes 0 bis 127 stellen
' dieselben Zeichen dar. Eine  Konvertierung ist also nur fuer die Codes 128
' bis 255 erforderlich. Das sind die Zeichencodes fuer die Umlaute,
' landesspezifischen Zeichen und "Kastensymbole". Diese Zeichen werden in
' dem ASII-Text gemaess der Code-Tabelle ersetzt. Der Tabellenplatz
' in dieser Code-Tabelle kennzeichnet dabei den (ACCII-Code - 127) und der
' Tabelleninhalt den zugehoerigen ANSI-Code. Fuer den Buchtstaben a-Umlaut
' ist z.B. das Tabellenelement CodeTabelle%(5) zustaendig, weil a-Umlaut
' den ASCII-Code 132 hat (132-127 = 5). In diesem Feldelement muss der Wert
' 228 hinterlegt sein; das ist der ANSI-Code des kleinen a-Umlauts.
' Die Codetabelle muss vom aufrufenden Programm bereitgestellt werden.
'
' Alle "Kastensymbole" mit einer und zwei Linien werden durch "-"
' und "+" ersetzt.
'
' Als ANSI-Code wird der in ISO 8859-1 spezifizierte Zeichensatz "Latin 1 /
' Westlich" vorausgesetzt (Windows-Codeseite 1252 - Westeuropaeisch)
'
' Beim ASCII-Code wird die MS-DOS-Codeseite 437 ("Englisch") zugrundegelegt,
' die auf deutschsprachigen PCs mit MS-DOS bis 6.22 und Windows 3.1
' vorkonfiguriert ist.
'
' Windows ab der Version 95 verwendet stattdessen die etwas abweichende
' Codeseite 850 ("Mehrsprachig/Lateinisch") mit weniger Kastensymbolen und
' mehr landesspezifischen Zeichen. Trotzdem sollte das Programm mit fast
' allen deutschsprachigen ASCII-Texten funktionieren. Das Programm laesst
' sich leicht fuer die Codeseite 850 modifizieren: Es muss dazu lediglich
' die DATA-Tabelle leicht angepasst werden. Auch eine ANSI-ASCII-Wandlung
' laesst sich durch eine entsprechende Belegung der Code-Tabelle
' bewerkstelligen.
'
' (c) Thomas Antoni, 28.1.2004 - 22.1.2008
'***************************************************************************
tANSI$ = ""                        'ANSI-Text vorbesetzen
'
FOR i% = 1 TO LEN(t$)              'alle ASCII-Zeichen in t$ bearbeiten
  zeichen$ = MID$(t$, i%, 1)       'ASCII-Textzeichen extrahieren
  ZeichenCode% = ASC(zeichen$)     'ASCII-Code des Zeichens ermitteln
  IF ZeichenCode% > 127 THEN       'Codes ueber 127 muess.konvertiert werden
    ZeichenCode% = CodeTabelle%(ZeichenCode% - 128)
                                   'zugehoerige ANSI-Code ermitteln
  END IF
  tANSI$ = tANSI$ + CHR$(ZeichenCode%)
NEXT
'
ASCII2ANSI$ = tANSI$
END FUNCTION

'
SUB DIRlist
'****************************************************************************
' DIRlist = Textdateien im Verzeichnis "c:\tmp\" suchen und deren Namen
' =======   in der Datei "c:\tmp\dirtxt.tmp" hinterlegen
'
' Diese Q(uick)Basic-Subroutine ermittelt die Namen aller im Verzeichnis
' "c:\tmp\" vorhandenen Textdateien, die die Dateierweiterung "TXT" besitzen.
' Alle ermittelten Dateinamen werden in der Datei "c:\tmp\dirtxt.tmp"
' hinterlegt - je Dateinamen eine Zeile.
'
' Hierzu erzeugt die Subroutine zunaechst ein Dateiverzeichnis mit Hilfe des
' DOS-Kommandos "DIR". Dann durchsucht sie dieses Dateiverzeichnis nach
' entsprechenden Dateinamen. Vor und hinter dem Dateinamen muss sich ein
' Leerzeichen oder ein Zeilenvorschub befinden.
'
' Die vom DIR-Kommando erzeugte Dateiliste sieht leider unter DOS und
' unter den verschiedenen Windows-Versionen jeweils vollkommen
' unterschiedlich aus. Die Subroutine DIRlist beherrscht bezueglich der
' Dateinamen sowohl die verschiedenen Windows-Formate als auch das
' QBasic/DOS-Format des DIR-Befehls. Bei der Windows-Variante steht ein
' Punkt vor der Dateierweiterung, bei der DOS-Variante ein Leerzeichen.
' Bei Dateinamen, die die 8+3 Laenge nicht ausnutzen, werden ausserdem
' beim DOS-Format vom DIR-Befehl entsprechende Blanks eingefuegt, die
' ausgeblendet werden muessen.
'
'    Beispiele: Windows-Variante |  DOS-Variante
'               -----------------+-----------------
'               abc.txt          |  abc      txt
'               abcdefgh.txt     |  abcdefgh txt
'               Barcelona.txt    |  BARCEL~1 TXT  <= Langer Dateiname!
'
' Wenn eine TXT-Datei einen langen Dateinamen hat, der nicht den 8+3-DOS-
' Konventionen entspricht, dann wird sie in der erzeugten Dateiliste
' dirtxt.tmp mit ihrem abgekuerzten 8+3-Namen angegeben.
' "Barcelona_Reise.txt" wird z.B. aufgelistet als "Barcel~1.txt".

' Das aufrufende Programm ist dafuer verantwortlich, die erzeugte
' Datei "c:\tmp\dirtxt.tmp", die die Dateiliste beinhaltet, nach der
' Auswertung wieder zu loeschen.
'
' (c)Thomas Antoni - www.qbasic.de - 25.1.2008 - 25.9.2009
'****************************************************************************
SHELL "dir c:\tmp > c:\tmp\dirlist.tmp" 'Dateiliste erzeugen und in die Datei
                                        '"c:\tmp\dirlist.tmp" umleiten
OPEN "c:\tmp\dirlist.tmp" FOR INPUT AS #1
OPEN "c:\tmp\dirtxt.tmp" FOR OUTPUT AS #2
DO UNTIL EOF(1)           'Schleife ueber alle Textzeilen
  LINE INPUT #1, t$       'Textzeile einlesen
  tlen% = LEN(t$)         'Laenge der Textzeile
  anfang% = 1             'Anfangsposition f.Suche vorbesetzen auf 1.Zeichen
  gefunden% = 1           'Vorbesetzung: "Textdatei in aktueller Zeile
                          'gefunden"
'
'********* Textzeile nach d.Suchstring ".txt" bzw. " txt" durchsuchen ********
  DOSvariante% = 1        'Vorbesetzung: Dateiname ist in der DOS-Varian-
                          'te mit Blank statt Punkt angegeben
  TXTpos% = INSTR(anfang%, LCASE$(t$), " txt")
                          'nach " txt" bzw. " TXT" (mit Blank) suchen
                          '(DOS-Variante)
  IF TXTpos% = 0 THEN
    TXTpos% = INSTR(anfang%, LCASE$(t$), ".txt")
                          'nach ".txt" bzw. ".TXT" suchen (Windows-Variante)
    IF TXTpos% = 0 THEN
      gefunden% = 0       'weder " txt" noch ".txt" gefunden ->
                          'keine Textdatei in aktueller Zeile
    ELSE
      DOSvariante% = 0    'Merker "Der Dateiname ist in d. Windows-Variante mit
                          'Punkt statt Blank angegeben"
    END IF
  END IF
  IF gefunden% = 1 THEN   'Gefundene TXT-Datei weiterbearbeiten
'
'***** Dateiname rechts m.Zeilenvorschub od. Leerzeich.korrekt abgeschlossen?
    IF (TXTpos% + 3 >= tlen%) OR (MID$(t$, TXTpos% + 4, 1) = " ") THEN
      TXTrechtsOK% = 1      'Dateiname rechts korrekt abgeschlossen
    ELSE
      TXTrechtsOK% = 0      'Dateiname rechts nicht korrekt abgeschlosen
    END IF
'
'****** Dateiname links m.Zeilenvorschub od. Leerzeich.korrekt abgeschlossen?
    FOR i% = TXTpos% - 1 TO TXTpos% - 8 STEP -1
                                            '8 Zeichen vor ".txt" durchsuchen
      IF i% = 1 THEN                        'Zeilenvorschub
        TXTlinksOK% = 1
        EXIT FOR
      ELSEIF MID$(t$, i% - 1, 1) = " " THEN 'Leerzeichen
        TXTlinksOK% = 1
        EXIT FOR
      ELSE                                  'nicht korrekt abgeschlossen
        TXTlinksOK% = 0
      END IF
    NEXT
'
'****** gefundenen Dateinamen extrahieren und anzeigen wenn korrektes Format
    IF TXTlinksOK% = 1 AND TXTrechtsOK% = 1 THEN
                                     'TXT-Datei gefunden u.korrektes Format?
      IF DOSvariante% = 0 THEN       'Windows-Variante
        DateiName$ = MID$(t$, i%, TXTpos% - i% + 4)

      ELSE          'DOS-Variante des Dateinamens mit festem 8+3-Format (mit
                    'Leerzeichen aufgefuellt und mit Leerzeichen statt Punkt)
        DateiName$ = MID$(t$, TXTpos% - 8, 12)
       '
       '----- alle Leerzeichen im 8+3-String loeschen
       t1$ = ""                        'Zwischenpuffer vorbesetzen
       FOR n% = 1 TO LEN(DateiName$)   'Schleife ueber alle Textzeichen
         zeichen$ = MID$(DateiName$, n%, 1)           'Zeichen isolieren
         IF zeichen$ <> " " THEN t1$ = t1$ + zeichen$ 'Leerzeich.ausblenden
       NEXT
       '
       '----- Punkt einfuegen
       DateiName$ = LEFT$(t1$, LEN(t1$) - 3) + ".TXT"
     END IF
     PRINT #2, DateiName$
  END IF
END IF
LOOP
'
CLOSE #1, #2
KILL "c:\tmp\dirlist.tmp"
END SUB

'
FUNCTION mail2link$ (t$)
'****************************************************************************
' MAIL2LINK$ = Mailadresse in Textzeile erkennen und in HTML-Link umwandeln
' ==========
' - Diese FUNCTION durchsucht die uebergebene Textzeile t$ nach Mailadressen
'   und wandelt diese in HTML-Links um. Die Textzeile darf keine Zeilen-
'   vorschuebe (CR, LF) enthalten. Es duerfen beliebig viele Mailadressen
'   und einzeln stehende at-Zeichen "@" vorkommen.
'
' - Gueltige Mailadressen nnn@mmm.oo muessen in der Textzeile wie folgt
'   angeordnet sein:
'
'           +------------------ linkspos%  )
'           |  +--------------- atpos%     )___ Zeichenpositionen
'           |  |   +----------- punktpos%  )    innerhalb der Zeile
'           |  |   | +--------- rechtspos% )
'           |  |   | |
'           v  v   v v ________ eigentliche Mailadresse
'           __________/
'           |        |
'    xxx_TL_nnn@mmm.oo_TR_yyy
'    |||||||||| ||| |||||||||
'    |||||||||| ||| ||||||+++-- beliebige Zeichen oder keine Zeichen
'    |||||||||| ||| ||++++----- rechtes Trennzeichen, Blank oder Zeilenende
'    |||||||||| ||| ++--------- mindestens 2 Zeichen (z.B. "de" oder "com")
'    |||||||||| +++------------ mindestens ein Zeichen
'    |||||||+++---------------- mindestens ein Zeichen
'    |||++++------------------- linkes Trennzeichen oder Zeilenanfang
'    +++----------------------- beliebige Zeichen oder keine Zeichen
'
'   Anmerkungen zu den Trennzeichen:
'   . _TL_ = Zeilenanfang oder linkes Trennzeichen (Leerzeichen oder eines
'            der Zeichen ":,;([{"")
'   . _TR_ = Zeilenende oder ein Leerzeichen, dem beliebig viele Trennzeichen
'            aus ".:,;)]}"" vorangestellt sein duerfen
'
' - Die Interpretation von E-Mailadressen durch den "Mailadesssen-Parser"
'   verhaelt sich exakt wie diejenige von Outlook Express.
'
' (c) Thomas Antoni, 27.1.2005 - 20.9.2009
'       thomas@antonis.de  -- www.qbasic.de  --- www.antonis.de
'
'***************************************************************************
'
'*************** Vorbesetzungen von Variablen ******************************
TrennL$ = " :,;([{" + CHR$(34)      'Linke Trennzeichen fuer Mailadresse
                                    '(Leerzeichen und Anfuehrungszeichen
                                    'sind auch dabei)
TrennR$ = ".:,;)]}" + CHR$(34)      'Rechte Trennzeichen fuer Mailadresse
                                    'Leerzeichen ist nicht dabei, nach
                                    'diesem wird gesondert gesucht
anfang% = 1                         'Anfangsposition fuer die Suche nach
                                    'einer Mailadresse auf Zeilenbeginn
                                    'vorbesetzen
fertig% = 0                         'Vorbesetzung "Zeile noch nicht fertig
                                    'durchsucht"
'
'***** Maildresse lokalisieren und extrahieren *****************************
DO
  mailadresse% = 1                  'Vorbesetzung "Gueltige Mailadresse"
'
'*** @ suchen und Text links davon analysieren
  atpos% = INSTR(anfang%, t$, "@")  'Position des @-Zeichens suchen
  IF atpos% = 0 OR atpos% > LEN(t$) - 4 THEN EXIT DO  'Kein @ gefunden oder @
                                    'zu dicht am Zeilenende -> Ende der
                                    'Mailsuche
  linkspos% = anfang%               'Vorbesetzung: Kein Trennzeichen gefunden
                                    '(Mailadresse beginnt am Zeilenanfang)
  FOR i% = anfang% TO atpos%        'Trennzeichen links vom @ suchen
    z$ = MID$(t$, i%, 1)
    IF INSTR(TrennL$, z$) > 0 THEN  'aktuelles Zeichen=linkes Trennzeichen?
      linkspos% = i% + 1
    END IF
  NEXT
  IF atpos% = linkspos% THEN        'kein Zeichen zwischen linkem
     mailadresse% = 0               'Trennzeichen und @ -> keine gueltige
     anfang% = atpos% + 1           'Mailadresse, Mailadr.-Suche nach dem @
  END IF                            'erneut beginnen
'
'*** Text rechts vom @-Zeichen analysieren
  punktgefunden% = 0                'Vorbesetzung: noch kein Punkt gefunden
  IF mailadresse% = 1 THEN          'Nur durchfuehren, wenn links alles OK
    mailadresse% = 0                'Vorbesetzung "keine gueltige Mailadr.
    IF atpos% > LEN(t$) - 4 THEN    'weniger als 3 Zeichen bis
                                    'Zeilenende vorhanden?->keine gueltige
      EXIT DO                       'Mailadresse. Textzeile fertig bearbeitet
                                    '-> Mail-Suche abbrechen
    ELSE
      FOR i% = atpos% + 1 TO LEN(t$)
                                      'Blank rechts der URL-Kennung suchen
        z$ = MID$(t$, i%, 1)          'aktuelles Zeichen auslesen
        IF z$ = "." AND punktgefunden% = 0 THEN 'noch kein Punkt gefunden?
          punktgefunden% = 1          'erster Punkt bereits gefunden.
          punktpos% = i%              'Position des ersten nach dem @ gefundenen
                                      'Punktes
          IF punktpos% > atpos% + 1 THEN mailadresse = 1
                                      'mindestens 1 Zeichen zwischen @ und
                                      'dem Punkt -> es handelt sich evtl. um
                                      'eine gueltige Mailadresse
          IF punktpos% = LEN(t$) THEN
            mailadresse% = 0          'ungueltige Mailadresse, wenn der Punkt
                                      'am Zeilenende steht
          ELSEIF MID$(t$, punktpos% + 1, 1) = " " THEN
            mailadresse% = 0          'ungueltige Mailadresse, wenn gleich
                                      'nach dem Punkt ein Blank steht
          ELSE
            mailadresse% = 1          'ansonsten gueltige Mailadresse
          END IF
        END IF
        IF z$ = " " THEN              'Blank gefunden ->
          rechtspos% = i% - 1         'Mailadress-Ende = Zeichen vor d. Blank
          EXIT FOR                    'Analyse des Textes rechts vom @ beenden
        END IF
'
        IF i% >= LEN(t$) THEN         'kein Leerz. gefunden -> der ganze Rest
          rechtspos% = LEN(t$)        'bis Zeilenende gehoert zur URL
          fertig% = 1                 'Zeile fertig durchsucht
        END IF
      NEXT
'
'*** alle links vom Blank stehenden Trennzeichen aus der Mailadresse ausblenden
      IF mailadresse% = 0 THEN          'ungueltige Mailadresse ?
        anfang% = atpos% + 1            'Beginn d.naechsten Mailadr.-Suche
      ELSE
        DO
          lz$ = MID$(t$, rechtspos%, 1) 'Letztes Zeichen der Mailadresse
          Trennz% = INSTR(TrennR$, lz$) > 0  'Ist es ein rechtes Trennzeichen?
          IF Trennz% THEN
            rechtspos% = rechtspos% - 1 'Trennzeichen ausblenden
          END IF
        LOOP WHILE Trennz%              'Wiederholen solange links Trennzeichen
                                        'gefunden werden
'
'*** Mailadresse extrahieren falls mindestens 4 Zeichen nach dem @ vorhanden
        IF (atpos% > rechtspos% - 4) OR (rechtspos% < punktpos% + 2) THEN
                                        'weniger als 3 Zeichen nach dem
                                        '@ ? oder weniger als 2 Zeichen nach
                                        'dem Punkt -> keine gueltige
                                        'Mailadresse!
          anfang% = rechtspos% + 1      'Suche hinter d.Wort mit d.Blank
        ELSE                            'wieder beginnen
          mail$ = MID$(t$, linkspos%, rechtspos% - linkspos% + 1)
'
'*** Link einfuegen und neuen Text zurueckliefern ***************************
          t1$ = LEFT$(t$, linkspos% - 1)
          t1$ = t1$ + "<a href=" + CHR$(34) + "mailto:" + mail$ + CHR$(34) + ">"
          t1$ = t1$ + mail$ + "</a>"
          anfang% = LEN(t1$)        'Anfangsposition fuer erneute Suche
                                    'nach einem @-Zeichen im naechsten
                                    'Schleifendurchlauf
          t1$ = t1$ + RIGHT$(t$, LEN(t$) - rechtspos%)
          t$ = t1$
        END IF
      END IF
    END IF
  END IF
LOOP WHILE fertig% = 0              'naechste Mailadresse suchen falls Zeile
'                                   'noch nicht fertig durchsucht
mail2link$ = t$
END FUNCTION

'
SUB Replace (text$, oldstring$, newstring$)
'***************************************************************************
' Replace = QBasic SUBroutine for Replacing Text in a String
' =======   QBasic-SUBroutine zum Suchen und Ersetzen von Textpassagen
'
' Deutsche Beschreibung
' --------------------------
' Diese Q(uick)Basic-SUBroutine wertet den Textstring aus, der in dem
' Uebergabeparameter "text$" hinterlegt ist und der aus beliebigen ASCII-
' oder ANSI-Textzeichen besteht. Replace$ sucht in diesem Textstring nach
' allen Vorkommen des Suchtextes "oldstring$" und ersetzt diese durch das
' Textstueck "newstring$".
'
' Anmerkung: Bei den Zeichenketten fuer das Suchen und Ersetzen wird die
' ~~~~~~~~~  Gross- und Kleinschreibung der Buchstaben beruecksichtigt.
'
' English-Language Description
' ----------------------------
' This SUBroutine goes through a textstring "text$" containing ASCII or
' ANSI characters. It searches for all occurrences of the string
' "oldstring$" and replaces them by "newstring$".
'
' Note: Characters in the find string are handled case sensitive. I.e.,
' ~~~~~ lower/upper case letters are distinguished when finding strings.
'
' (c)Thomas Antoni - thomas@antonis.de - www.antonis.de, 14.4.01 - 17.1.08
'
'***************************************************************************
oldlength% = LEN(oldstring$)
newlength% = LEN(newstring$)
textptr% = 1                              'initialize text pointer
DO
  foundptr% = INSTR(textptr%, text$, oldstring$)
                                          'pointer to oldstring in text
  IF foundptr% > 0 THEN                   'old string found?
    text$ = LEFT$(text$, foundptr% - 1) + newstring$ + MID$(text$, foundptr% + oldlength%)
                                          'replace old by new string
    textptr% = foundptr% + newlength%     'set text pointer behind new string
    IF textptr% > LEN(text$) THEN EXIT DO 'text already completely analyzed
  ELSE EXIT DO                            '-> exit SUBroutine
  END IF
LOOP
END SUB

FUNCTION Sonderz2Entities$ (t$)
'***************************************************************************
' Sonderz2Entities$ = Umwandeln von Sonderzeichen in HTML-Entities
' =================
' Diese Q(uick)Basic-Function wandelt im vorliegenden Text t$ einige (nicht
' alle!) Sonderzeichen und Umlaute aus dem im Windows ANSI-Zeichensatz
' in HTML-Entities um. Einige dieser Umwandlungen sind erforderlich, weil
' der Windows-ANSI-Zeichensatz Latin 1 an einigen wenigen Codestellen von
' ISO-8859-1 abweicht.
'
' (c)Thomas Antoni -- www.qbasic.de -- 22.2.2008 - 10.3.2009
'***************************************************************************
CALL Replace(t$, "&", "&amp;")
CALL Replace(t$, "<", "&lt;")
CALL Replace(t$, ">", "&gt;")
CALL Replace(t$, CHR$(169), "&copy;")   'Copyright-Zeichen
CALL Replace(t$, CHR$(228), "&auml;")   'kleines a-Umlaut
CALL Replace(t$, CHR$(246), "&ouml;")   'kleines o-Umlaut
CALL Replace(t$, CHR$(252), "&uuml;")   'kleines u-Umlaut
CALL Replace(t$, CHR$(196), "&Auml;")   'grosses A-Umlaut
CALL Replace(t$, CHR$(214), "&Ouml;")   'grosses O-Umlaut
CALL Replace(t$, CHR$(220), "&Uuml;")   'grosses U-Umlaut
CALL Replace(t$, CHR$(223), "&szlig;")  'Eszet (scharfes S)
CALL Replace(t$, CHR$(153), "&#8482;")  'Trademark-Zeichen TM
CALL Replace(t$, CHR$(149), "&#8226;")  'dicker Mittelpunkt
                                        '  (Aufzaehlungszeichen)
CALL Replace(t$, CHR$(151), "&#8212;")  'Langer Bindestrich
CALL Replace(t$, CHR$(128), "&#8364;")  'Euro-Zeichen
Sonderz2Entities$ = t$
END FUNCTION

'
FUNCTION URL2link$ (t$)
'****************************************************************************
' URL2LINK = Internetadresse in Textzeile suchen und in HTML-Link umwandeln
' ========
' - Diese FUNCTION durchsucht die uebergebene Textzeile t$ nach Interneta-
'   dressen (URLs) und wandelt diese in HTML-Links um. Die Textzeile darf
'   keine Zeilenvorschuebe (CR, LF) enthalten. Es duerfen beliebig viele URLs
'   und einzeln stehende (von Leerzeichen umschlossenen) Textpassagen "WWW"
'   und "HTTP" enthalten. Letztere werden nicht in Links umgewandelt. Eine
'   gefundene URL wird durch folgenden Text ersetzt und somit in einen
'   nternet-Link umgewandelt:
'        <a href="[http://]URL" target="_blank">URL</a>"
'   Das "http://" wird vorangestellt, wenn die URL mit "www." beginnt.
'   Der HTML-Parameter "target="_blank" sorgt dafuer, dass die verlinkte
'   Webseite in einem neuen Browser-Fenster geoeffnet wird.
' - URLs beginnen mit einer der folgenden URL-Kennungen:
'   . URL-Kennung =  "http:/", "https:/" oder "www." .
'   Hinter den ersten beiden URL-Kennungen kann ein "www" stehen, muss aber
'   nicht. Gross- und Kleinbuchstaben werden nicht unterschieden, so sind
'   etwa "hTtP" und HTTP" gleichwertig mit "http". FTP-Adressen werden nicht
'   ausgewertet. Das Programm ist aber leicht hierfuer erweiterbar.
' - URLs muessen folgendermassen in der Textzeile angeordnet sein
'         "xxx_TL_URL-Kennung_nnn_TR_xxx"
'   . xxx  = beliebige oder kein Zeichen
'   . _TL_ = Zeilenanfang oder linkes Trennzeichen (Leerzeichen oder eines
'            der Zeichen ".:,;([{"" (Punkt ist also auch erlaubt!)
'   . URL-Kennung_ = siehe oben
'   . n    = beliebiges Zeichen inklusive Punkt. Mindestens ein Punkt und
'            2 weitere Zeichen <> _TL_ oder Blank muessen vorhanden sein
'            Hierbei handelt es sich um das Landes-Kennzeichen, z.B. ".de",
'            "com" usw.
'   . _TR_ = Zeilenende oder ein Leerzeichen, dem beliebig viele Rechte
'            Trennzeichen aus ".:,;)]}"" vorangestellt sein duerfen
'   Dieser "URL-Parser" verhaelt sich wesentlich "gutmuetiger" als z.B.
'   derjenige von Outlook 97 und erkennt viel mehr URLs als dieser.
'
' (c) Thomas Antoni, 13.1.2008 - 10.3.2009
'       thomas@antonis.de  --- www.qbasic.de  --- www.antonis.de
'
'***************************************************************************
'
'*************** Vorbesetzungen von Variablen ******************************
TrennL$ = " .:,;([{" + CHR$(34)     'Linke Trennzeichen fuer URL
                                    '(Leerzeichen und Anfuerungszeichen sind
                                    'auch dabei)
TrennR$ = ".:,;)]}" + CHR$(34)      'Rechte Trennzeichen fuer URL
                                    'Leerzeichen ist nicht dabei, nach
                                    'diesem wird gesondert gesucht
anfang% = 1                         'Anfangsposition fuer die Suche nach
                                    'einer URL auf Zeilenanfang
                                    'vorbesetzen
fertig% = 0                         'Vorbesetzung "Zeile noch nicht fertig
                                    'durchsucht"
'
AnzURLkenng% = 3                    'Anzahl der URL-Kennungen
DIM URLkenng$(AnzURLkenng%)         'Feld fuer URL-Kennungen (erweiterbar!)
URLkenng$(0) = "http:/"             'URL-Kennungen (in Kleinbuchstaben!)
URLkenng$(1) = "https:/"
URLkenng$(2) = "www."
'
tlen% = LEN(t$)                     'Laenge der Textzeile
'
'************* URL lokalisieren und extrahieren *****************************
DO
'*** erste (am weitesten links stehende) URL-Kennung in d.Textzeile suchen

  URLposMin% = tlen%                'Vorbesetzung fuer vorderste Fundstelle
  FOR i% = 0 TO AnzURLkenng% - 1    'Schleife ueber alle URL-Kennungen
    URLpos% = INSTR(anfang%, LCASE$(t$), URLkenng$(i%))
                                    'Position d. URL-Kennung suchen
    IF (URLpos% > 0) AND (URLpos% < URLposMin%) THEN
                                    'URL-Kennung gefunden und Position vor
                                    'alten  Fundstelle gelegen?
       URLposMin% = URLpos%         'Neue Fundstelle liegt vor d.alten
       iMin% = i%                   'Index der URL-Kennung merken
    END IF
  NEXT
  IF URLposMin% = tlen% THEN EXIT DO
                                    'Kein URL-Kennung in t$ gefunden -> Ende
                                    'der URL-Suche
  URLpos% = URLposMin%              'Fundstelle der am weitesten links
                                    'liegenden URL-Kennung
  i% = iMin%                        'Index der dazugehoerigen URL-Kennung
'
'************  kontrollieren, ob vor der URL linkes Trennzeich.vorhanden
  IF URLkenng$(i%) = "www." THEN www% = 1 ELSE www% = 0
                                    'Merker "alleiniges www. ohne http://"
  URLkenngRechtsPos% = URLpos% + LEN(URLkenng$(i%))
                                    'Position des 1. Zeichens nach der
                                    'gefundenen URL-Kennung
  IF URLpos% = 1 THEN               'URL-Kennung am Zeilenanfang ->
    TLgef% = 1                      'linkes Trennzeichen gefunden
  ELSE
    z$ = MID$(t$, URLpos% - 1, 1)   'Zeichen links von d. URL-Kennung lesen
    IF INSTR(TrennL$, z$) > 0 THEN  'aktuelles Zeichen=linkes Trennzeichen?
      TLgef% = 1                    'linkes Trennzeichen vorhanden
    ELSE
      TLgef% = 0                    'linkes Trennzeichen nicht vorhanden
      anfang% = URLkenngRechtsPos%  'Anfangsposition fuer die naechste URL-
                                    'Suche in t$
    END IF                          ' -> nicht in Link umwandeln!
  END IF
'
'*** Text rechts von der URL-Kennung analysieren
  IF TLgef% = 1 THEN                 'Nur durchfuehren, wenn links alles OK
'
    istURL% = 0                      'Vorbesetzung: Es handelt sich nicht
                                     'um eine gueltige URL
    IF URLkenngRechtsPos% > tlen% - 3 THEN 'weniger als 3 Zeichen bis
                                     'Zeilenende vorhanden?->keine guelt.URL
      EXIT DO                        'Textzeile fertig bearbeitet -> URL-
                                     'Suche abbrechen
    ELSE
      FOR i% = URLkenngRechtsPos% TO tlen%
                                      'Blank rechts der URL-Kennung suchen
        z$ = MID$(t$, i%, 1)          'aktuelles Zeichen auslesen
        IF z$ = "." THEN istURL% = 1  'Punkt in d. URL gefunden -> es handelt
                                      'sich um eine gueltige URL
        IF z$ = " " THEN rechtspos% = i% - 1: EXIT FOR  'Leerzeichen gefunden
        IF i% >= tlen% THEN           'kein Leerz. gefunden -> der ganze Rest
          rechtspos% = tlen%          'bis Zeilenende gehoert zur URL
          fertig% = 1                 'Zeile fertig durchsucht
        END IF
      NEXT
'
'*** alle links vom Blank stehenden Trennzeichen aus der URL ausblenden
      IF istURL% = 0 THEN               'ungueltige URL ?
        anfang% = URLkenngRechtsPos%    'Beginn d.naechsten URL-Suche
      ELSE
        DO
          lz$ = MID$(t$, rechtspos%, 1) 'Letztes Zeichen der URL
          Trennz% = INSTR(TrennR$, lz$) > 0  'Ist es ein rechtes Trennzeichen?
          IF Trennz% THEN
            rechtspos% = rechtspos% - 1 'Trennzeichen ausblenden
          END IF
        LOOP WHILE Trennz%              'Wiederholen solange links Trennzeichen
                                        'gefunden werden
'
'*** URL extrahieren falls mindestens 3 Zeichen nach der URL-Kennung vorhanden
        IF URLkenngRechtsPos% > rechtspos% - 3 THEN
                                        'weniger als 3 Zeichen nach d.URL-
                                        'Kennung? -> keine gueltige URL!
          anfang% = rechtspos% + 1      'Suche hinter d.Wort mit d.Blank
        ELSE                            'wieder beginnen
          URL$ = MID$(t$, URLpos%, rechtspos% - URLpos% + 1)
'
'*** Link einfuegen und neuen Text zurueckliefern **************************
          t1$ = LEFT$(t$, URLpos% - 1) + "<a href=" + CHR$(34)
          IF www% = 1 THEN t1$ = t1$ + "http://"
                                    'einer URL-Kennung "www."  muss
                                    '"http:/" vorangestellt werden
          t1$ = t1$ + URL$ + CHR$(34)
          t1$ = t1$ + " target=" + CHR$(34) + "_blank" + CHR$(34) + ">"
          t1$ = t1$ + URL$ + "</a>"
          anfang% = LEN(t1$)
                                    'Anfangsposition fuer erneute Suche
                                    'nach einer URL-Kennung im naechsten
                                    'Schleifendurchlauf
          t1$ = t1$ + RIGHT$(t$, tlen% - rechtspos%)
          t$ = t1$                  'Zeile aktualisieren
          tlen% = LEN(t$)           'Zeilenlaenge aktualisieren
        END IF
      END IF
    END IF
  END IF
LOOP WHILE fertig% = 0            'naechste URL suchen falls Zeile
'                                 'noch nicht fertig durchsucht
URL2link$ = t$
END FUNCTION

