'***************************************************************************
' UNI2ANSI.BAS V1.0 = Umwandlung einer Unicode- in eine ANSI-Textdatei
' ============
' Dieses Q(uick)Basic-Programm wandelt alle im Verzeichnis C:\TMP\ vorge-
' fundenen Unicode-Textdateien ins Windows-ANSI-Format um und hinterlegt
' die resultierenden ANSI-Dateien im Unterverzeichnis C:\TMP\ANSI\.
'
' Die umzuwandelnden Unicode-Dateien muessen die Dateierweiterung ".TXT"
' besitzen. Die ANSI-Ergebnisdateien erhalten dieselben Namen wie die
' jeweiligen Unicode-Dateien. Die Unicode-Dateien bleiben unveraendert.
'
' Die maximale Dateigroesse betraegt 2 GB !
'
' Lange Dateinamen werden zu 8+3 Zeichen verkrzt, so wird etwa
' C:\TMP\BARCELONA.TXT zu C:\TMP\ANSI\BARCEL~1.TXT konvertiert.
'
' Als ANSI-Code wird der in ISO 8859-1 spezifizierte Zeichensatz "Latin 1 /
' Westlich" (Code-Page 1252) vorausgesetzt.
'
' Fuer die Codes 0 bis 255 enthaelt die Unicode-Codetabelle als Untermenge
' (Subset) den in den westlichen Laendern gebraeuchlichen Windows-ANSI-
' Zeichensatz ISO 8859-1 ("Latin 1 / Westlich"). Das hoeherwertige Byte der
' einzelnen 16-Bit-Codestellen wird hierbei also quasi nicht benutzt und
' enthaelt jeweils ausschliesslich Nullen (d.h. das "Nullzeichen" CHR$(0) ).
' Daher reicht es fuer die Umwandlung von Unicode- in ANSI- Text normalerweise
' aus, alle im Text vorhandenen Nullzeichen CHR$(0) zu loeschen. Dieses
' Verfahren versagt erst dann, wenn total exotische fremdsprachliche
' Sonderzeichen vorhanden sind.
'
' Alles hier Gesagte gilt fuer "normale" Unicode-Textdateien in der "UTF-16"-
' Kodierung im westlichen Sprachraum, wie sie z.B. mit MS Word oder dem MS-
' Windows- Texteditor (ab Windows XP) erzeugt werden knnen (mit "Speichern
' unter ... | Dateityp | Unicode Text (*.txt)"). Das ebenfalls, z.B. bei
' E-Mails und im Web, verbreitete "UTF-8" wird von UNI2ANSI.BAS nicht
' unterstuetzt. Das genauer zu erklaeren, wuerde zu weit fuehren. Wer mehr
' darueber und ueber den Unicode erfahren will, der lese bitte den
' entsprechenden Artikel in der Wikipedia unter
' http://de.wikipedia.org/wiki/Unicode .
'
' Es gibt noch eine Besonderheit zu beachten: Einige Unicode-Textdateien
' enthalten in den ersten beiden Bytes die sogenannte BOM-Markierung (Byte
' Order Mark) FFFE_hexa (CHR$(255) + CHR$(254)) oder FEFF_hexa
' (CHR$(254) + CHR$(255)). Auch MS Word und der Windows-Editor Notepad.exe
' fuegen diese Markierung vor dem eigentlichen Text ein. Die BOM-Markierung
' kennzeichnet die Adress-Reihenfolge innerhalb der 16-Bit- Zeichencodes -
' niederwertiges Byte vor dem hherwertigen Byte ("Unicode Little Endian")
' oder umgekehrt ("Unicode Big Endian"; weniger gebraeuchlich). Die beiden
' BOM-Markierungs-Bytes muessen, falls vorhanden, bei der Konvertierung ins
' ANSI-Format ausgeblendet werden.
'
' (c) Thomas Antoni, 28.1.2004 - 23.11.2009
'***************************************************************************
'
DECLARE SUB DIRlist ()              '.TXT-Textdateien im Verzeichnis
                                    '"c:\tmp\" suchen und deren Namen in
                                    '"c:\tmp\dirtxt.tmp" hinterlegen
DECLARE SUB Replace (t$, oldstring$, newstring$)
                                    'beliebigen Text suchen und ersetzen
'
'
DO
'**** rot-weissen Bildschirm mit Titelzeile und Kurzanleitung anzeigen *****
COLOR 0, 7: CLS                   'Bildschirm weiss einfaerben
COLOR 15, 4                       'Titelzeile weiss auf rot
PRINT "         UNI2ANSI V1.0 -  Unicode-ANSI-Konverter (c) Thomas Antoni  2009        ";
'
FOR zeile% = 2 TO 24              'rote Seitenbalken malen
  LOCATE zeile%, 1: PRINT " ";
  LOCATE zeile%, 80: PRINT " ";
NEXT zeile%
'
LOCATE 25, 1: PRINT SPC(79); " "; 'Fusszeile rot malen
'
COLOR 0, 7                        'Schwarz auf Weiss
'
LOCATE 4, 20: PRINT "                "
LOCATE 5, 20: PRINT "                    "
LOCATE 6, 20: PRINT "                          "
LOCATE 7, 20: PRINT "                   "
'
LOCATE 9, 4
PRINT " Dieses Programm konvertiert alle im Verzeichnis C:\TMP\ vorgefundenen"
LOCATE 10, 4
PRINT " Unicode-Textdateien *.TXT ins Windows-ANSI-Format und hinterlegt sie"
LOCATE 11, 4
PRINT " dort im Unterverzeichnis ANSI\ ."
'
'
'-- Namen d. Unicode-Textdateien C:\TMP\*.TXT einlesen in C:\TMP\dirtxt.tmp
CALL DIRlist
'
'---- Namen der aktuellen Unicode-Textdatei einlesen -----------------------
AnzahlDateien% = 0
SHELL "MD c:\tmp\ANSI"    'Verzeichnis zum Hinterlegen der resultierenden
                          'ANSI-Dateien erstellen. diese Anweisung verursacht
                          'die DOS - Fehleranzeige "Erweiterter Fehler 183",
                          'wenn das Verzeichnis ANSI\ bereits vorhanden ist
COLOR , 4: LOCATE 12, 1: PRINT " "; 'roten Rand restaurieren
COLOR , 7: PRINT SPC(30);          'Fehlermeldung 183 in d.Anzeige loeschen
OPEN "c:\tmp\dirtxt.tmp" FOR INPUT AS #3
DO UNTIL EOF(3)                    'Schleife ueber alle Textdateien
  LINE INPUT #3, Datei$            'Textzeile mit Textdatei-Namen einlesen
  AnzahlDateien% = AnzahlDateien% + 1
  LOCATE 14, 5: PRINT "Bearbeitete Datei   : "
  LOCATE 14, 29: PRINT SPC(12); 'alte Dateinamensanzeige loeschen
  LOCATE 14, 29: PRINT Datei$
  LOCATE 16, 5: PRINT "Umgewandelte Zeilen : "

  LOCATE 16, 28: PRINT SPC(10); 'alte Zeilenzahl-Anzeige loeschen
'
'**** aktuelle Unicode-Textdatei und ANSI-Ergebnisdatei oeffnen *******
  OPEN "C:\tmp\" + Datei$ FOR INPUT AS #1
  OPEN "C:\tmp\ANSI\" + Datei$ FOR OUTPUT AS #2
'
'***************** erste Zeile bearbeiten ******************************
LINE INPUT #1, t$                'Erste Textzeile einlesen
anz& = 1
'
IF LEN(t$) >= 2 THEN
  BOM$ = LEFT$(t$, 2)            'erste zwei Textzeichen lesen
  IF (BOM$ = CHR$(255) + CHR$(254)) OR (BOM$ = CHR$(254) + CHR$(255)) THEN
                                 'BOM-Markierung FFFE_hex oder
                                 'FEFF_hex vorhanden?
    t$ = RIGHT$(t$, LEN(t$) - 2) 'BOM-Markierung ausblenden
  END IF
END IF
'
CALL Replace(t$, CHR$(0), "")    'Nullzeichen loeschen
CALL Replace(t$, CHR$(10), "")   'ueberfluessige CR-Zeichen
                                 '(Wagenruecklauf) loeschen
PRINT #2, t$                     'erste Zeile in Zieldatei schreiben
'
'***************** restliche Zeilen bearbeiten *************************
DO UNTIL EOF(1)
  LINE INPUT #1, t$              'Textzeile einlesen
  anz& = anz& + 1
  LOCATE 16, 28: PRINT anz&      'Anzahl d.gewandelten Zeilen anzeigen
  CALL Replace(t$, CHR$(0), "")  'Nullzeichen loeschen
  CALL Replace(t$, CHR$(10), "") 'ueberfluessige CR-Zeichen
  PRINT #2, t$
LOOP
CLOSE #1, #2
LOOP
CLOSE #3
KILL "c:\tmp\dirtxt.tmp"
BEEP
LOCATE 18, 5
PRINT "Fertig!"; AnzahlDateien%; "Datei(en) konvertiert und in ";
PRINT "C:\TMP\ANSI\ hinterlegt"
'
'************* Wiederholen/Beenden-Dialog ************************************
LOCATE 22, 5
COLOR 15, 1                                  'weiss auf blau
PRINT "      [beliebige Taste]...Beenden     [Eing]...Neue Konvertierung      "
DO: taste$ = INKEY$: LOOP UNTIL taste$ <> "" 'Warten auf belieb. Tastendruck
IF taste$ <> CHR$(13) THEN
  CLS
  END
END IF
LOOP

'
'
SUB DIRlist
'****************************************************************************
' DIRlist = Textdateien im Verzeichnis "c:\tmp\" suchen und deren Namen
' =======   in der Datei "c:\tmp\dirtxt.tmp" hinterlegen
'
' Diese Q(uick)Basic-Subroutine ermittelt die Namen aller im Verzeichnis
' "c:\tmp\" vorhandenen Textdateien, die die Dateierweiterung "TXT" besitzen.
' Alle ermittelten Dateinamen werden in der Datei "c:\tmp\dirtxt.tmp"
' hinterlegt - je Dateinamen eine Zeile.
'
' Hierzu erzeugt die Subroutine zunaechst ein Dateiverzeichnis mit Hilfe des
' DOS-Kommandos "DIR". Dann durchsucht sie dieses Dateiverzeichnis nach
' entsprechenden Dateinamen. Vor und hinter dem Dateinamen muss sich ein
' Leerzeichen oder ein Zeilenvorschub befinden.
'
' Die vom DIR-Kommando erzeugte Dateiliste sieht leider unter DOS und
' unter den verschiedenen Windows-Versionen jeweils vollkommen
' unterschiedlich aus. Die Subroutine DIRlist beherrscht bezueglich der
' Dateinamen sowohl die verschiedenen Windows-Formate als auch das
' QBasic/DOS-Format des DIR-Befehls. Bei der Windows-Variante steht ein
' Punkt vor der Dateierweiterung, bei der DOS-Variante ein Leerzeichen.
' Bei Dateinamen, die die 8+3 Laenge nicht ausnutzen, werden ausserdem
' beim DOS-Format vom DIR-Befehl entsprechende Blanks eingefuegt, die
' ausgeblendet werden muessen.
'
'    Beispiele: Windows-Variante |  DOS-Variante
'               -----------------+-----------------
'               abc.txt          |  abc      txt
'               abcdefgh.txt     |  abcdefgh txt
'               Barcelona.txt    |  BARCEL~1 TXT  <= Langer Dateiname!
'
' Wenn eine TXT-Datei einen langen Dateinamen hat, der nicht den 8+3-DOS-
' Konventionen entspricht, dann wird sie in der erzeugten Dateiliste
' dirtxt.tmp mit ihrem abgekuerzten 8+3-Namen angegeben.
' "Barcelona_Reise.txt" wird z.B. aufgelistet als "Barcel~1.txt".

' Das aufrufende Programm ist dafuer verantwortlich, die erzeugte
' Datei "c:\tmp\dirtxt.tmp", die die Dateiliste beinhaltet, nach der
' Auswertung wieder zu loeschen.
'
' (c)Thomas Antoni - www.qbasic.de - 25.1.2008 - 25.9.2009
'****************************************************************************
SHELL "dir c:\tmp > c:\tmp\dirlist.tmp" 'Dateiliste erzeugen und in die Datei
                                        '"c:\tmp\dirlist.tmp" umleiten
OPEN "c:\tmp\dirlist.tmp" FOR INPUT AS #1
OPEN "c:\tmp\dirtxt.tmp" FOR OUTPUT AS #2
DO UNTIL EOF(1)           'Schleife ueber alle Textzeilen
  LINE INPUT #1, t$       'Textzeile einlesen
  tlen% = LEN(t$)         'Laenge der Textzeile
  anfang% = 1             'Anfangsposition f.Suche vorbesetzen auf 1.Zeichen
  gefunden% = 1           'Vorbesetzung: "Textdatei in aktueller Zeile
                          'gefunden"
'
'********* Textzeile nach d.Suchstring ".txt" bzw. " txt" durchsuchen ********
  DOSvariante% = 1        'Vorbesetzung: Dateiname ist in der DOS-Varian-
                          'te mit Blank statt Punkt angegeben
  TXTpos% = INSTR(anfang%, LCASE$(t$), " txt")
                          'nach " txt" bzw. " TXT" (mit Blank) suchen
                          '(DOS-Variante)
  IF TXTpos% = 0 THEN
    TXTpos% = INSTR(anfang%, LCASE$(t$), ".txt")
                          'nach ".txt" bzw. ".TXT" suchen (Windows-Variante)
    IF TXTpos% = 0 THEN
      gefunden% = 0       'weder " txt" noch ".txt" gefunden ->
                          'keine Textdatei in aktueller Zeile
    ELSE
      DOSvariante% = 0    'Merker "Der Dateiname ist in d. Windows-Variante mit
                          'Punkt statt Blank angegeben"
    END IF
  END IF
  IF gefunden% = 1 THEN   'Gefundene TXT-Datei weiterbearbeiten
'
'***** Dateiname rechts m.Zeilenvorschub od. Leerzeich.korrekt abgeschlossen?
    IF (TXTpos% + 3 >= tlen%) OR (MID$(t$, TXTpos% + 4, 1) = " ") THEN
      TXTrechtsOK% = 1      'Dateiname rechts korrekt abgeschlossen
    ELSE
      TXTrechtsOK% = 0      'Dateiname rechts nicht korrekt abgeschlosen
    END IF
'
'****** Dateiname links m.Zeilenvorschub od. Leerzeich.korrekt abgeschlossen?
    FOR i% = TXTpos% - 1 TO TXTpos% - 8 STEP -1
                                            '8 Zeichen vor ".txt" durchsuchen
      IF i% = 1 THEN                        'Zeilenvorschub
        TXTlinksOK% = 1
        EXIT FOR
      ELSEIF MID$(t$, i% - 1, 1) = " " THEN 'Leerzeichen
        TXTlinksOK% = 1
        EXIT FOR
      ELSE                                  'nicht korrekt abgeschlossen
        TXTlinksOK% = 0
      END IF
    NEXT
'
'****** gefundenen Dateinamen extrahieren und anzeigen wenn korrektes Format
    IF TXTlinksOK% = 1 AND TXTrechtsOK% = 1 THEN
                                     'TXT-Datei gefunden u.korrektes Format?
      IF DOSvariante% = 0 THEN       'Windows-Variante
        DateiName$ = MID$(t$, i%, TXTpos% - i% + 4)

      ELSE          'DOS-Variante des Dateinamens mit festem 8+3-Format (mit
                    'Leerzeichen aufgefuellt und mit Leerzeichen statt Punkt)
        DateiName$ = MID$(t$, TXTpos% - 8, 12)
       '
       '----- alle Leerzeichen im 8+3-String loeschen
       t1$ = ""                        'Zwischenpuffer vorbesetzen
       FOR n% = 1 TO LEN(DateiName$)   'Schleife ueber alle Textzeichen
         zeichen$ = MID$(DateiName$, n%, 1)           'Zeichen isolieren
         IF zeichen$ <> " " THEN t1$ = t1$ + zeichen$ 'Leerzeich.ausblenden
       NEXT
       '
       '----- Punkt einfuegen
       DateiName$ = LEFT$(t1$, LEN(t1$) - 3) + ".TXT"
     END IF
     PRINT #2, DateiName$
  END IF
END IF
LOOP
'
CLOSE #1, #2
KILL "c:\tmp\dirlist.tmp"
END SUB

'
SUB Replace (text$, oldstring$, newstring$)
'***************************************************************************
' Replace = QBasic SUBroutine for Replacing Text in a String
' =======   QBasic-SUBroutine zum Suchen und Ersetzen von Textpassagen
'
' Deutsche Beschreibung
' --------------------------
' Diese Q(uick)Basic-SUBroutine wertet den Textstring aus, der in dem
' Uebergabeparameter "text$" hinterlegt ist und der aus beliebigen ASCII-
' oder ANSI-Textzeichen besteht. Replace$ sucht in diesem Textstring nach
' allen Vorkommen des Suchtextes "oldstring$" und ersetzt diese durch das
' Textstueck "newstring$".
'
' Anmerkung: Bei den Zeichenketten fuer das Suchen und Ersetzen wird die
' ~~~~~~~~~  Gross- und Kleinschreibung der Buchstaben beruecksichtigt.
'
' English-Language Description
' ----------------------------
' This SUBroutine goes through a textstring "text$" containing ASCII or
' ANSI characters. It searches for all occurrences of the string
' "oldstring$" and replaces them by "newstring$".
'
' Note: Characters in the find string are handled case sensitive. I.e.,
' ~~~~~ lower/upper case letters are distinguished when finding strings.
'
' (c)Thomas Antoni - thomas@antonis.de - www.antonis.de, 14.4.01 - 17.1.08
'
'
'***************************************************************************
oldlength% = LEN(oldstring$)
newlength% = LEN(newstring$)
textptr% = 1                              'initialize text pointer
DO
  foundptr% = INSTR(textptr%, text$, oldstring$)
                                          'pointer to oldstring in text
  IF foundptr% > 0 THEN                   'old string found?
    text$ = LEFT$(text$, foundptr% - 1) + newstring$ + MID$(text$, foundptr% + oldlength%)
                                          'replace old by new string
    textptr% = foundptr% + newlength%     'set text pointer behind new string
    IF textptr% > LEN(text$) THEN EXIT DO 'text already completely analyzed
  ELSE EXIT DO                            '-> exit SUBroutine
  END IF
LOOP
END SUB

