'****************************************************************************
' UNITFIX.BAS = Einheiten-Umrechner fuer physikalische Einheiten
' ===========
' Dieses Q(uick)Basic-Programm konvertiert 96 verschiedene physikalische
' Einheiten ineinander. Die Konvertierung erfolgt zwischen metrischen bzw.
' SI-Einheiten einerseits und britischen ("UK" oder "Imperial" Masssystem)
' bzw. US Einheiten andererseits. Ausserdem gibt es weitere haeufig
' benoetigte Umrechnungen wie PS <-> KW und ha <-> qm.
'
' Je Menuezeile gibt es zwei Umrechnungen: Quell- -> Zieleinheit und die
' Umkehrrichtung Ziel -> Quelleinheit. Alle Umrechnungsdaten sind in
' DATA-Zeilen am Ende des Hauptprogramms hinterlegt, so dass sich das
' Programm leicht an andere Masseinheiten anpassen und bequem erweitern
' laesst. Das angezeigte Ergebnis wird zur besseren Lesbarkeit auf 8
' signifikante Stellen gerundet.
'
' Internet-Links zur Einheitenkonvertierung:
'   > Der sehr gute und komfortable Offline-Einheitenkonverter "Convert"
'     fuer Windows und Linux steht auf www.joshmadison.com/software zum
'     Herunterladen bereit.
'   > Gute Online-Einheitenkonverter gibt es auf
'        . www.cleavebooks.co.uk/scol/
'        . www.onlineconversion.com/
'        . http://unit-converter.org/index_de.html (in deutscher Sprache)
'   > Eine aeusserst umfangreiche Einheiten-Umrechnungstabelle namens
'     Dictionary of Units"  gibt es auf
'        . www.cleavebooks.co.uk/dictunit/.
'     Dort findet man auch viele Hintergrundinformationen zum Thema
'     "Einheiten".
'
' (c) Thomas Antoni, 19.3.2005 - 12.3.2008 - www.qbasic.de
'****************************************************************************
'
DECLARE FUNCTION intext$ (length%)    'Zahleneingabe begrenzter Laenge
DECLARE FUNCTION Gerundet$ (Zahl#, Stellen%)
                                      'Zahl auf signifikante Stellen runden
DECLARE SUB Kasten ()                 'Kasten aus Doppelstrichen malen
'
'********************* Felder deklarieren ***********************************

OPTION BASE 1 'Feldelemente beginnen ab Index 1 statt 0
'
TYPE Berechnung
  Artikel AS STRING * 3              'Artikel der physikalischen Groesse im
                                     'Akkusativ:  den / die / das
  PhysikalGroesse AS STRING * 14     'z.B. Laenge, Gewicht usw.
  Quelleinheit AS STRING * 11
  Zieleinheit AS STRING * 11
  Rechenart AS STRING * 3            'MUL, DIV, FAR oder KEL; siehe unten bei
                                     'den DATA-Zeilen
  Faktor AS DOUBLE                   'Umrechnungsfaktor
END TYPE
'
READ AnzUmrech%     'Anzahl der Umrechnungszeilen aus 1. DATA-Zeile
DIM Umrechnung(AnzUmrech%) AS Berechnung
'
'************* Alle Umrechnungsdaten aus DATA-Zeilen einlesen ***************
FOR i% = 1 TO AnzUmrech%
  READ Umrechnung(i%).Artikel
  READ Umrechnung(i%).PhysikalGroesse
  READ Umrechnung(i%).Quelleinheit
  READ Umrechnung(i%).Zieleinheit
  READ Umrechnung(i%).Rechenart
  READ Umrechnung(i%).Faktor
NEXT
'
'
'****************************************************************************
'*                          Menuebildschirm anzeigen                        *
'****************************************************************************
DO
COLOR 4, 7                     'rote Schrift auf hellgrau
WIDTH 80, 50
CLS
'**************** rote Bildschirmumrandung malen ****************************
LOCATE 1, 1: PRINT STRING$(80, CHR$(219));
FOR zeile% = 2 TO 49
  LOCATE zeile%, 1: PRINT CHR$(219);
  LOCATE zeile%, 80: PRINT CHR$(219);
NEXT
LOCATE 50, 1: PRINT STRING$(80, CHR$(219));
'
'*************** Titelzeile im oberen Rand anzeigen *************************
COLOR 15, 4                     'weisse Schrift auf rot
LOCATE 1, 4
PRINT " UnitFix - Einheitenrechner  (c) Thomas Antoni, 12.03.2008 - www.qbasic.de ";
'
'************ Einheitenliste anzeigen (Zeilenzahl = AnzUmrech%) *************
'Bildschirmaufbau (3 Beispielzeilen):
'         1         2         3         4         5         6         7         8
'12345678901234567890123456789012345678901234567890123456789012345678901234567890
'  Spritverbrauch(01)miles/gal  -> l/100km    (02)l/100km    -> miles/gal
'  Volumen.......(03)US gallons -> l          (04)l          -> Us gallons
'  Laenge........(05)inches/Zoll-> mm         (06)mm         -> inches/Zoll
'
'  <- 14 Zeich.->      <11 Zeich.>   <11 Zeich.>      <11 Zeich.>   <11 Zeich.>
'
Pfeil$ = CHR$(196) + CHR$(16) + " "   'Pfeilsymbol "->"
LOCATE 2
COLOR , 7          'hellgrauer Hintergrund
AlteGroesse$ = ""
FOR i% = 1 TO AnzUmrech% 'Anzahl der Zeilen mit je 2 Umrechnungen
  COLOR 0          'schwarze Schrift
  LOCATE i% + 1    'Cursor in aktuelle Zeile
  'Physikal. Groesse nur anzeigen, wenn neu gegenueber Vorzeile
  LOCATE , 17
  PRINT CHR$(186); 'Trennstrich
  IF Umrechnung(i%).PhysikalGroesse <> AlteGroesse$ THEN
    AlteGroesse$ = Umrechnung(i%).PhysikalGroesse
    LOCATE , 3:  PRINT RTRIM$(Umrechnung(i%).PhysikalGroesse);
    PRINT STRING$(17 - POS(0), ".");  'von momentaner Cursorposition bis
                                      'Spalte 17 mit Punkten auffuellen
  END IF
  COLOR 1          'blaue Schrift fuer erste Zeilen-Haelfte
  LOCATE , 18: PRINT USING "(##)"; i% * 2 - 1;
  LOCATE , 22
  PRINT CHR$(179); 'Trennstrich
  LOCATE , 23: PRINT Umrechnung(i%).Quelleinheit;
  LOCATE , 34: PRINT Pfeil$; Umrechnung(i%).Zieleinheit;
  LOCATE , 48
  COLOR 0          'schwarze Schrift
  PRINT CHR$(186); 'Trennstrich
  COLOR 4          'braune Schrift fuer zweite Zeilen-Haelfte
  LOCATE , 49: PRINT USING "(##)"; i% * 2;
  LOCATE , 53
  PRINT CHR$(179); 'Trennstrich
  LOCATE , 54: PRINT Umrechnung(i%).Zieleinheit;
  LOCATE , 65: PRINT Pfeil$; Umrechnung(i%).Quelleinheit;
NEXT
'
'----- Eingabe-Aufforderung
LOCATE 50, 9
COLOR 15, 1             'weiss auf hellblau
PRINT " Whle die Umrechnungsart (1...";
PRINT USING "##)"; AnzUmrech% * 2;
PRINT " oder [Esc] zum Beenden:    ";
'
DO                        'max 2 Tasten einlesen (Esc oder Zahl)
  LOCATE , 71: PRINT " "; 'Blank hinter das Eingabefeld
  LOCATE , 67
  t$ = intext$(2)         'Tastatureingabe-FUNCTION: 2 Zahlen o. Esc eingeben
  IF t$ = CHR$(27) THEN   'Programmabbruch bei Esc
    CLS
    END
  END IF
  Umr% = VAL(t$)          'Eingabetext "00" bis "99" in Zahl wandeln
LOOP UNTIL (Umr% >= 1) AND (Umr% <= AnzUmrech% * 2)
                          'Schleifenwiederholung bis d.Eingabezahl im zulaess.
                          'Bereich 1 - Anzahl Umrechn.zeilen * 2 liegt
'
'****************************************************************************
'*                            Berechnungsbildschirm                         *
'****************************************************************************
'
DO
'******************** rote Bildschirmumrandung malen ************************
COLOR 4, 7                     'rote Schrift auf hellgrau
CLS
LOCATE 1, 1: PRINT STRING$(80, CHR$(219));
FOR zeile% = 2 TO 49
  LOCATE zeile%, 1: PRINT CHR$(219);
  LOCATE zeile%, 80: PRINT CHR$(219);
NEXT
LOCATE 50, 1: PRINT STRING$(80, CHR$(219));
'
'******************* Titelzeile im oberen Rand anzeigen *********************
COLOR 15, 4                     'weisse Schrift auf rot
LOCATE 1, 4
PRINT " UnitFix - Einheitenrechner  (c) Thomas Antoni, 12.03.2008 - www.qbasic.de ";
'

'*************** ungerader Menuepunkt: Quelleinheit -> Zieleinheit **********
COLOR 0, 7 'schwarze Schrift auf hellgrau
IF Umr% MOD 2 = 1 THEN         'ungerader Menuepunkt?
  i% = Umr% \ 2 + 1            'Feldelement i.anwenderdefin.Feld "Berechnung"
'----- Quellgroesse erfragen
  CALL Kasten                  'Kasten aus Doppellinien fuer Ueberschrift
  LOCATE 6, 25
  PRINT "Umrechnung "; RTRIM$(Umrechnung(i%).Quelleinheit); " ";
  PRINT CHR$(196) + CHR$(16);  'Pfeilsymbol "->"
  PRINT " "; RTRIM$(Umrechnung(i%).Zieleinheit);
  LOCATE 15, 15
  PRINT "Gib "; Umrechnung(i%).Artikel; " ";
  PRINT RTRIM$(Umrechnung(i%).PhysikalGroesse);
  PRINT " in "; RTRIM$(Umrechnung(i%).Quelleinheit); " ein : ";
  COLOR 15, 1                      'Eingabefeld weiss auf gruen
  Eingabe$ = intext$(16)           'Eingaberoutine max 16 Stellen
  IF Eingabe$ = CHR$(27) THEN      'Wurde die Esc-Taste betaetigt?
    EXIT DO                        'Berechnung abbrechen, zurueck z.Menue
  ELSE
    Quellgroesse# = VAL(Eingabe$) 'Eingabegroesse in Zahl wandeln
  END IF
'
'------------ Umrechnung durchfuehren
  SELECT CASE Umrechnung(i%).Rechenart
    CASE "FAR"                                 'Fahrenheit -> Celsius
      Zielgroesse# = (Quellgroesse# - 32) / 1.8
    CASE "KEL"                                 'Kelvin -> Celsius
      Zielgroesse# = Quellgroesse# - 273.15
    CASE "DIV"                                 'Division
      Zielgroesse# = Umrechnung(i%).Faktor / Quellgroesse#
    CASE ELSE                                  'Multiplikation
      Zielgroesse# = Umrechnung(i%).Faktor * Quellgroesse#
  END SELECT
'
'------------- Ergebnis anzeigen
  LOCATE 19, 15
  COLOR 15, 2                                   'weiss auf gruen
  PRINT Quellgroesse#; RTRIM$(Umrechnung(i%).Quelleinheit); " = ";
  PRINT Gerundet$(Zielgroesse#, 8);             'Ergebnis auf 8 signifikante
                                                'Stellen gerundet anzeigen
  PRINT " "; RTRIM$(Umrechnung(i%).Zieleinheit); " ";
'
'
'*************** gerader Menuepunkt: Zieleinheit -> Quelleinheit ************
'Wie bei geraden Menuepunkten, jedoch Umkehrung der Quell- und Zielgroessen
'sowie der Berechungsvorschriften
'
'-------------- Zielgroesse erfragen
ELSE
  i% = Umr% \ 2               'Feldelement im anwenderdefin. Feld "Berechnung"
  CALL Kasten                 'Kasten aus Doppellinien fuer Ueberschrift
  LOCATE 6, 25
  PRINT "Umrechnung "; RTRIM$(Umrechnung(i%).Zieleinheit); " ";
  PRINT CHR$(196) + CHR$(16); 'Pfeilsymbol 
  PRINT " "; RTRIM$(Umrechnung(i%).Quelleinheit);
  LOCATE 15, 15
  PRINT "Gib "; RTRIM$(Umrechnung(i%).Artikel); " ";
  PRINT RTRIM$(Umrechnung(i%).PhysikalGroesse);
  PRINT " in "; RTRIM$(Umrechnung(i%).Zieleinheit); " ein : ";
  COLOR 15, 1                  'Eingabefeld weiss auf gruen
  Eingabe$ = intext$(16)       'Eingaberoutine, max 16 Stellen
  IF Eingabe$ = CHR$(27) THEN  'Wurde die Esc-Taste betaetigt?
    EXIT DO                    'Berechnung abbrechen, zurueck z.Menue
  ELSE
    Zielgroesse# = VAL(Eingabe$) 'Eingabegroesse in Zahl wandeln
  END IF
'
'----- Umrechnung durchfuehren (mit Umkehrung der Rechenvorschrift)
  SELECT CASE Umrechnung(i%).Rechenart
    CASE "FAR"                                         'Celsius -> Fahrenheit
      Quellgroesse# = (Zielgroesse# * 1.8) + 32
    CASE "KEL"                                         'Celsius -> Kelvin
      Quellgroesse# = Zielgroesse# + 273.15
    CASE "DIV"                                         'Division
      Quellgroesse# = (Umrechnung(i%).Faktor) / Zielgroesse#
    CASE ELSE                                          'Multiplikation
      Quellgroesse# = (1 / Umrechnung(i%).Faktor) * Zielgroesse#
  END SELECT
'
'---- Ergebnis anzeigen
  LOCATE 19, 15
  COLOR 15, 2                                    'weiss auf gruen
  PRINT Zielgroesse#; RTRIM$(Umrechnung(i%).Zieleinheit); " = ";
  PRINT Gerundet$(Quellgroesse#, 8);             'Ergebnis auf 8 signifikante
                                                 'Stellen gerundet anzeigen
  PRINT " "; RTRIM$(Umrechnung(i%).Quelleinheit); " ";
END IF
'
'************************ Wiederholen/Beenden-Dialog *************************
  LOCATE 50, 10
  COLOR 15, 1               'weiss auf hellblau
  PRINT " [beliebige Taste]...Neue Berechnung " + CHR$(179);
  PRINT " [Esc]...Zurck zum Men ";
  Taste$ = INPUT$(1)        'Warten bis eine Taste betaetigt
  IF Taste$ = CHR$(27) THEN EXIT DO
LOOP
LOOP
'
'****************************************************************************
'*                 DATA-Zeilen mit Umrechnungskonstanten                    *
'****************************************************************************
'
'Umrechnungsformel bei "MUL": Zieleinheit = Faktor * Quelleinheit
'                             (1 [Quelleinheit] = Faktor [Zieleinheit])
'     "            "   "DIV": Zieleinheit = Faktor / Quelleinheit
'     "            "   "FAR": Sonderformeln fuer Umrechng F <-> C
'     "            "   "KEL": Sonderformeln fuer Umrechnung K (Kelvin) <-> C
'
DATA 48: 'Anzahl der Umrechnungszeilen mit je 2 Umrechnungen
'                              
'  Artikel| Physikal.Groesse| Quelleinheit | Zieleinheit | Rech.art| Faktor
'            < 14 Zeichen >    <11 Zeich.>    <11 Zeich.>
DATA "die", "Temperatur",     "F(Fahrenh)", "C",         "FAR", 1#
DATA "die", "Temperatur",      "K (Kelvin)", "C",         "KEL", 1#

DATA "den", "Spritverbrauch", "miles/USgal", "l/100km",    "DIV", 235.21#

DATA "die", "Geschwindigkt",  "km/h",        "m/s",        "MUL", 0.2777778#
DATA "die", "Geschwindigkt",  "miles/h",     "km/h",       "MUL", 1.6093426#
DATA "die", "Geschwindigkt",  "kn (Knoten)", "km/h",       "MUL", 1.852#

DATA "die", "Lnge",          "inch(Zoll)",  "mm",         "MUL", 25.4#
DATA "die", "Lnge",          "feet",        "m",          "MUL", 0.3048#
DATA "die", "Lnge",          "yd",          "m",          "MUL", 0.9144#
DATA "die", "Lnge",          "miles",       "km",         "MUL", 1.609343#
DATA "die", "Lnge",          "Seemeilen",   "km",         "MUL", 1.852#

DATA "die", "Flche",         "sq inches",   "cm",        "MUL", 6.4516#
DATA "die", "Flche",         "sq feet",     "m",         "MUL", 0.092903#
DATA "die", "Flche",         "sq yd",       "m",         "MUL", 0.8361#
DATA "die", "Flche",         "ha",          "m",         "MUL", 10000#
DATA "die", "Flche",         "sq miles",    "km",        "MUL", 2.589988#
DATA "die", "Flche",         "acres",       "m",         "MUL", 4047#

DATA "das", "Volumen",        "US gallons",  "l (Liter)",  "MUL", 3.7853285#
DATA "das", "Volumen",        "UK gallons",  "l (Liter)",  "MUL", 4.545965#
DATA "das", "Volumen",        "cu inches",   "l (Liter)",  "MUL", 0.0164#
DATA "das", "Volumen",        "cu feet",     "m",         "MUL", 28.317707#
DATA "das", "Volumen",        "UK pints",    "l (Liter)",  "MUL", 0.5682456#

DATA "den", "Druck",          "PSI(lb/in)", "bar (atm)",  "MUL", 0.06894757#
DATA "den", "Druck",          "PSI(lb/in)", "hPa (mbar)", "MUL", 68.94757#

DATA "die", "Kraft",          "kp",          "N",          "MUL", 9.80665#
DATA "die", "Kraft",          "lb force",    "N",          "MUL", 4.448222#
DATA "die", "Kraft",          "oz force",    "N",          "MUL", 0.278013851#

DATA "das", "Drehmoment",     "kpm",         "Nm",         "MUL", 9.80665#
DATA "das", "Drehmoment",     "ftlb",       "Nm",         "MUL", 1.355818#

DATA "die", "Masse",          "lb (pounds)", "kg",         "MUL", 0.4535924#
DATA "die", "Masse",          "oz (ounces)", "g",          "MUL", 28.34952#
DATA "die", "Masse",          "US tons",     "t (metric)" ,"MUL", 0.90718474#
DATA "die", "Masse",          "UK tons",     "t (metric)" ,"MUL", 1.0160469088#

DATA "die", "Leistung",       "hp (mechan)", "kW (kJ/s)",  "MUL", 0.7457#
DATA "die", "Leistung",       "hp (elektr)", "kW (kJ/s)",  "MUL", 0.746#
DATA "die", "Leistung",       "PS",          "kW (kJ/s)",  "MUL", 0.7355#
DATA "die", "Leistung",       "ftlb/s",     "W (J/s)",    "MUL", 1.355810#
DATA "die", "Leistung",       "kcal/h",      "W (J/s)",    "MUL", 1.16263#
DATA "die", "Leistung",       "kpm/s",       "W (J/s)",    "MUL", 9.80665#

DATA "die", "Energie/Arbeit", "ftlb",       "J (Nm, Ws)", "MUL", 1.355818#
DATA "die", "Energie/Arbeit", "kWh",         "KJ (KNm)",   "MUL", 3600#
DATA "die", "Energie/Arbeit", "PSh",         "MJ (MNm)",   "MUL", 2.6478#
DATA "die", "Energie/Arbeit", "hph",         "MJ (MNm)",   "MUL", 2.6845#
DATA "die", "Energie/Arbeit", "kcal",        "KJ (kNm)",   "MUL", 4.1868#

DATA "den", "Volumenstrom",   "cu feet/min", "l/s",        "MUL", 0.4719474#
DATA "den", "Volumenstrom",   "US gal/min",  "l/s",        "MUL", 0.0630901964#

DATA "den", "Massenstrom",    "lb/min",      "kg/s",       "MUL", 0.007559873#

DATA "den", "Winkel",         "rad(Radian)", "  (Grad)",  "MUL", 57.2958#

'
FUNCTION Gerundet$ (Zahl#, Stellen%)
'****************************************************************************
' Gerundet$ = Rundung einer Gleitpunktzahl auf eine waehlbare Anzahl von
' =========   Stellen unabhaengig von der Position des Dezimalpunktes
'
' Diese Q(uick)Basic-Funktion rundet die uebergebene positive oder negative
' Gleitpunkt-Zahl# auf eine einstellbare Anzahl von Stellen% (maximal 9
' Stellen). Dabei spielt die Position des Dezimalpunktes keine Rolle.
' Bei den Nachkommastellen werden direkt hinter dem Dezimalpunkt stehende
' Nullen nicht in die Anzahl der Stellen% einbezogen (siehe untenstehende
' Beispiele).
'
' Diese Methode nutzt den zulaessigen Wertebereich des in Klammern stehenden
' Arguments des CLNG-Befehls optimal aus. Das Argument muss im LONG-INTEGER-
' Wertebereich von +- 2 Milliarden liegen, sonst gibt es einen
' Programmabbruch mit "Ueberlauf"-Meldung.
'
' Es kommt das Verfahren der "Wissenschaftlichen Rundung" zum Einsatz,
' bei der eine 5 nur dann aufgerundet wird, wenn links davor eine ungerade
' Ziffer steht. Beispiele fuer die wissenschaftliche Rundung:
'       >  2.475 wird zu 2.48 aufgerundet, weil "7" eine ungerade Zahl ist
'       >  2.465 wird zu 2.46 abgerundet , weil "4" eine gerade Zahl ist.
'          Beim Verfahren der "Kaufmaennischen Rundung" wuerde auf 2.47
'          aufgerundet
'
' Fuer die Wissenschaftliche Rundung wird der CLNG()-Befehl verwendet. Die
' dadurch gewonne Ganzzahl wird per Zeichenverarbeitung wieder zu einer
' Kommazahl zusammengesetzt, um Rundungsfehler zu vermeiden (Trick !!!).
'
' Beispiele: Stellen%  = 4 (Rundung auf 4 signifikante Stellen)
' ~~~~~~~~~~ Zahl# = 1.34567               => Gerundet$ = 1.346
'            Zahl# = 134.567               => Gerundet$ = 134.6
'            Zahl# = -13456789             => Gerundet$ = -13460000
'            Zahl# = 1.345678943897283D-02 => Gerundet$ = 0.01346
'            Zahl# = 0.134567              => Gerundet$ = 0.1346
'            Zahl# = 0.00134567            => Gerundet$ = 0.001346
'                   |----|=> Nullen nach dem Dezimalpunkt werden nicht
'                            einbezogen (zaehlen nicht als zu rundende
'                            "Stellen%")
'            Stellen% = 8
'            Zahl# = 9.806650001#          => Gerundet$ = 9.80665
'            ("Problemfall", wird korrekt gerundet)
'
' Hinweis 1: In QB ist fuer die Kaufmaennische Rundung der INT-Befehl und
' ~~~~~~~~~~ fuer die Wissenschaftliche Rundung die Befehle CINT und CLNG
'            "zustaendig".
'
' Hinweis 2: Die Anzahl der zu rundenden Stellen darf nicht groesser als
' ~~~~~~~~~~ 9 sein, weil sonst u.U. der zulaessige Wertebereich des
'            Arguments des CLNG-Befehls von ca. 2 Milliarden (2 * 10^9)
'            ueberschritten wird und ein Programmabbruch wegen
'            Zahlenueberlauf erfolgt.
'
'       (c) Thomas Antoni --- www.antonis.de, 18.2.2008 - 12.3.2008
'****************************************************************************
'
'**************** Kommaposition ermitteln mit Hilfe des  ********************
'**************** dekadischen Logarithmus (Logarithmus zur Basis 10) ********                                    ******
'Die Position des Kommas von Zahl# ergibt sich durch den (ganzzahligen Anteil
'des dekadischen Logarithmus von |Zahl#|) + 1. Negative Werte bedeuten: Das
'Komma steht links von der ersten Ziffer <> 0.
'Beispiele:
' Zahl# = 123,456    => KommaPosition% =  3
' Zahl# = 1.23456    => KommaPosition% =  1
' Zahl# = 0.123456   => KommaPosition% =  0
' Zahl# = 0.00123456 => KommaPosition% = -2
'
IF Zahl# = 0 THEN Gerundet$ = "0": EXIT FUNCTION
                                   'Fehlerabbruch wegen LOG(0) vermeiden
KommaPosition% = INT(LOG(ABS(Zahl#)) / LOG(10)) + 1

'
'**************** Gerundeten "Rohwert" als String ermitteln *****************
'**************** (enthaelt nur die signifikanten Stellen)  *****************
G$ = LTRIM$(STR$(CLNG(Zahl# * 10 ^ (Stellen% - KommaPosition%))))
'
'************************ Vorzeichen abtrennen ******************************
IF LEFT$(G$, 1) = "-" THEN         'Negative Zahl?
  Vorzeichen$ = "-"
  G$ = RIGHT$(G$, LEN(G$) - 1)     'Minuszeichen ausblenden
ELSE
  Vorzeichen$ = ""
END IF
'
'*********** Vor- und Nachkommastellen zusammensetzen (mit String- **********
'*********** verarbeitung, zur Vermeidung weiterer Rundungsfehler) **********
IF KommaPosition% >= Stellen% THEN 'Nur Vorkommastellen vorhanden
  G$ = G$ + STRING$(KommaPosition% - Stellen%, "0")
ELSEIF KommaPosition% > 0 THEN     'Vor- und Nachkommastellen vorhanden
  G$ = LEFT$(G$, KommaPosition%) + "." + RIGHT$(G$, Stellen% - KommaPosition%)
ELSE                               'Nur Nachkommastellen vorhanden
  G$ = "0." + STRING$(-KommaPosition%, "0") + G$
END IF
'
'*********** Irrelevante Nullen und allein stehenden Dezimalpunkt ***********
'*********** rechts der Nachkommastellen loeschen                 ***********
'Beispiele: 2. => 2 und 1.23000 => 1.23
'
IF KommaPosition% < Stellen% THEN     'Komma vorhanden?
  FOR i% = LEN(G$) TO 1 STEP -1
    Rechts$ = MID$(G$, i%)            'Rechts stehendes Zeichen
    IF Rechts$ = "0" OR Rechts$ = "." THEN
                                      'irrelevante Null oder Dezimalpunkt ...
      G$ = LEFT$(G$, LEN(G$) - 1)     '... loeschen
      IF Rechts$ = "." THEN EXIT FOR  'Beenden, wenn Dezimalpunkt gefunden
    ELSE
      EXIT FOR
    END IF
  NEXT i%
END IF
'
'************ Vorzeichen wieder hinzufuegen und Ergebnis uebergeben *********
Gerundet$ = Vorzeichen$ + G$
END FUNCTION

'
FUNCTION intext$ (length%)
'****************************************************************************
' INTEXT = QBasic-Function zur Zahleneingabe definierter Laenge
' =====================================================================
' Ersetzt den INPUT-Befehl. An die FUNCTION intext$() wird die Laenge
' des Eingabefeldes uebergeben. intext$() realisiert dann eine auf diese
' Laenge begrenzte Zahleneingabe ueber die Tastatur. An das aufrufende
' Programm wird die eingegebene Zahl als String zurueckgeliefert. Esc
' bricht die Eingabe ab und es wird das Esc-Zeichen zurueckgeliefert
' (= CHR$(27) ). Mit der Backspace-Taste laesst sich der Eingabetext
' editieren. Dezimalpunkt und Dezimalkomma sind gleichermassen erlaubt.
' Alle Tasten ausser 0...9, Punkt, Komma, Backspace und Esc bleiben
' unbeachtet. Das aufrufende programm ist dafuer verantwortlich, den Cursor
' und die Farben fuer die Eingabe zu setzen und bei Bedarf die zurueck-
' gelieferte Zahl mit VAL(intext$(n)) von einer String-Groesse in eine
' numerische Zahlengroesse umzuwandeln.
'
' (c) Thomas Antoni - www.antonis.de, 16.1.2008
'****************************************************************************
'
column% = POS(0)                              'Cursor-Spaltenposition sichern
text$ = "": key$ = ""
PRINT "[" + SPACE$(length%) + "]";            'Eingabefeld anzeigen
DO
SELECT CASE key$
    CASE CHR$(13): EXIT DO                    'Eingabetaste -> Ende d.Eingabe
    CASE CHR$(27)
      text$ = CHR$(27)                        'Esc -> CHR$(27) rueckliefern
      EXIT DO
    CASE CHR$(8)                              'Backspace-Taste
      IF LEN(text$) > 0 THEN                  'Falls Textlaenge > 0 ...
        text$ = LEFT$(text$, LEN(text$) - 1)  '... Text um 1 Zeichen kuerzen
      END IF
    CASE ELSE
     IF (key$ >= "0" AND key$ <= "9") OR key$ = "." THEN
                                              'Handelt es sich um e.Nummern-
                                              'Taste oder Dezimalpunkt?
       IF LEN(text$) = length% THEN           'hat Text schon d.volle Laenge
         text$ = LEFT$(text$, LEN(text$) - 1) + key$ 'letzt.Zeichen austauschen
       ELSE
         text$ = text$ + key$                 'ansonsten Tastenzeich.anfuegen
       END IF
     END IF
  END SELECT
  LOCATE , column% + 1: PRINT SPACE$(length%); 'altem Text loeschen
  LOCATE , column% + 1: PRINT text$;          'Neuen Text anzeigen
  x% = LEN(text$)                             'relative Cursorposition
  IF x% = length% THEN x% = x% - 1 'Eingabefeld voll->Cursor aufs letzt.Zeichen
  LOCATE , column% + x% + 1, 1                'Cursor anzeigen
  DO: key$ = INKEY$: LOOP UNTIL key$ <> ""    'Warten auf Tastenbetaetigung
  IF key$ = "," THEN key$ = "."               'Komma automatisch durch Dezi-
                                              'malpunkt ersetzen
LOOP
intext$ = text$
END FUNCTION

'
SUB Kasten
'***************************************************************************
' KASTEN = QBasic-Subroutine zum Zeichnen eines Kastens aus Doppellinien
' =====================================================================
' Diese Subroutine zeichnet im Textmodus einen Kasten aus Doppellinien
' zwischen den Punkten Zeile/Spalte 4/5 und 8/75.
'***************************************************************************
LOCATE 4, 5
PRINT CHR$(201); STRING$(70, CHR$(205)); CHR$(187); 'oberer Kastenrand
FOR zeile% = 5 TO 7                                 '3 Mittelzeilen
  LOCATE zeile%, 5
  PRINT CHR$(186); SPACE$(70); CHR$(186);
NEXT zeile%
LOCATE 8, 5
PRINT CHR$(200); STRING$(70, CHR$(205)); CHR$(188); 'unterer Kastenrand
END SUB

