'******************************************************************************
' ZEICHNE1.BAS - QBASIC-Programm: Bildschirmschoner aus farbigen Linien
' =========================================================================
' Bildschirmschoner mit farbigem Strahlenstern in einem 400*400-Pixelfeld
' in der Mitte des VGA-Bildschirms
'  - linke oberer Ecke bei  x1=120, Y1=40
'  - rechte untere Ecke bei x2=520, y2=440
'
' Verwendete Befehle: SCREEN, LINE, TIMER (Zeiten erzeugen)
'
' (c) Thomas Antoni, 14.03.99
'       thomas.antoni@erlf.siemens.de
'******************************************************************************

SCREEN 12                 'VGA-Bildschirm mit 640*480 Pixeln u.16 Farben
DO                        'Dauerschleife
  CLS
  FOR i% = 0 TO 400 STEP 4
    starttime# = TIMER
    endtime# = TIMER
    LINE (120 + i%, 40)-(520 - i%, 440), (i% / 9) MOD 14 + 1
                           'Linie Zeichnen von (x1,y1) bis (x2,y2) mit ex-
                           'perimentell berechneter Farbe
    WHILE (endtime# - starttime# < .001)  'Warteschleife ca. 70 msec
      endtime# = TIMER
      IF INKEY$ <> "" THEN EXIT DO
    WEND
  NEXT i%
  FOR i% = 0 TO 400 STEP 4
    starttime# = TIMER
    endtime# = TIMER
    LINE (520, 40 + i%)-(120, 440 - i%), i% MOD 15
    WHILE (endtime# - starttime# < .0001)
      IF INKEY$ <> "" THEN END
      endtime# = TIMER
    WEND
  NEXT i%
LOOP
END

