DECLARE SUB Zeit (MilliSec%, Schleifen&)
DECLARE FUNCTION ZEITMES& (dialog%)

'****************************************************************************
' ZEITMES.BAS - Erzeugung von Microdelays mit einer Auflsung von 1 ms
' ===================================================================
'
' Dies Hauptprogramm zeigt beispielhaft, wie man Prozessor-unabhngige Warte-
' Zeiten mit einer Auflsung von 1 ms erzeugen kann mit hilfe der folgenden
' beiden enthaltenen Subroutinen:
'
'   - Zeitmes& (Dialog%) 'ermittelt die Anzahl FOR-Schleifen je ms, die -
'                        'falls Dialog&=1 - mit einem vom Anwender abgefragten
'                        'Geschwindigkeitsfaktor von 0.1 bis 10 behaftet ist
'   - Zeit (MilliSec%, Schleifen&) 'erzeugt eine Wartezeit der in "MilliSec%"
'                                  'bergebenen Lnge. In "Schleifen&" ist
'                                  'die vorher durch ZeitMes& ermittelte An-
'                                  'zahl von FOR-Schleifen zu bergeben
'
' Aufrufbeispiele:
' ----------------
' Beispiel 1: Erzeugung einer Wartezeit von 30 msec ohne Abfrage eines
'             Geschwindigkeitsfaktors:
'                    msec& = Zeitmes&(0)        'Anzahl For-Schleifen je ms
'                    ...
'                    CALL Zeit (30, msec&)      'Warteschleife 30 msec
'
' Beispiel 2: Erzeugung je einer Wartezeit von 1 sec mit Geschwindigkeitsfak-
'             tor in einer Dauerschleife bis beliebige Taste bettigt und
'             jeweils Anzeige der verstrichenen Sekunden:
'
'                    msec& = Zeitmes&(1)           'Anzahl For-Schleifen je ms
'                     ...                          'mit Geschw.faktor-Abfrage
'                    z = 1
'                    WHILE INKEY$ = ""
'                       CALL Zeit (1000, msec&)    'Warteschleife 1000msec=1s
'                       z = z + 1
'                       PRINT z; " Sec"
'                    WEND
'
' (c)Thomas Antoni, 07.04.99 - 15.05.99
'    thomas.antoni@erlf.siemens.de
'****************************************************************************




msec& = ZEITMES&(1)                      'Anzahl FOR-Schleifen je ms
                                         'ermitteln, vorher Geschw.faktor
                                         'in Dialog abfragen
PRINT
z = 1
WHILE INKEY$ = ""
  CALL Zeit(1000, msec&)                 'Wartezeit von 1 s erzeugen
  z = z + 1
  PRINT z; " Sec"                        'fortlaufenden Sekunden auf Bild-
WEND                                     'schirm ausgeben
END

SUB Zeit (MilliSec%, Schleifen&)
'****************************************************************************
'
' ZEIT - QBasic-Subroutine zur Prozessor-unabhngigen Zeitenerzeugung
' ========================================================================
'
' Beschreibung:
' --------------
' "Zeit" erzeugt eine Prozessor-unabhngige Wartezeit mit 1 ms Auflsung
' und einer max. Zeit bis 2^15ms (30s)
'
' bergabeparameter:
' -------------------
' Die gewnschte Lnge der Wartezeit in msec wird im
' Parameter MilliSec% bergeben wird (Short Integer Wert); als zweiter Para-
' meter "Schleifen&" wird die Anzahl von Programmschleifen je msec
' bergeben (Long Integer Wert, der durch die vorher aufzurufende Funktion
' "ZeitMes&" ermittelt werden mu; siehe unten).
'
' Realisierung:
' ----------------
' Die Wartezeit wird durch viele FOR-Schleifen realisiert, deren Anzahl sich
' aus dem Produkt der gewnschten Wartezeit in Millisekunden und dem Pro-
' zorabhngigen Faktor "Schleifen&" ergibt.
' Damit auch extrem schnellen knftigen Prozessoren der Long Integer Zahlen-
' bereich nicht berschritten wird, ist die Wartezeit durch zwei
' ineinandergeschachtelte Schleifen realisiert.
'
' Vorher die Funktion "ZeitMes&" aufrufen!
' ------------------------------------------
' Bevor "Zeit" erstmals aufgerufen wird, mu einmal die Funktion "ZeitMes&"
' aufgerufen werden, um als Prozessor-abhngigen Faktor die Anzahl
' "Schleifen&" von FOR-Schleifen fr eine Millisec zu ermitteln, die von der
' Geschwindigkeit des verwendeten Prozessors abhngt und von der Tatsache,
' ob es sich um ein interpetiertes .BAS- oder eine kompiliertes .EXE-
' Programm handelt.
'                            Zeitmes& hat den bergabeparameter "Dialog%".
' Falls der Parameter "Dialog%" = 1 ist, wird zunchst
' in einem Dialog ein zustzlicher Geschwindigkeitfaktor von 1 bis 100
' abgefragt (entspricht Geschwindigkeitserhhung um den Faktor 0,1...10).
'
'
' Beispiel: Erzeugen einer Wartezeit von 250 msec mit Dialog zur Eingabe
' --------- eines Geschwindigkeitsfaktors:
'
'            Schleifen& = ZeitMes&(1)   'Schleifenzahl je msec ermitteln mit
'            ...                        'Geschwindigkeitsfaktor-Dialog
'            CALL Zeit (250,Schleifen&) 'Wartezeit 250 msec
'
' (c) Thomas Antoni, 07.04.99-15.05.99
'****************************************************************************

FOR n% = 0 TO MilliSec%
  FOR i& = 0 TO Schleifen&
  NEXT i&
NEXT n%
END SUB

FUNCTION ZEITMES& (dialog%)
'****************************************************************************
'
' ZEITMES&.BAS - QBasic-Funktion zur Prozessor-unabhngigen Zeitmessung
' ========================================================================
'
' Beschreibung:
' --------------
' Zeitmes& erzeugt einen Long Integer Wert, der der Anzahl FOR-Schleifen zur
' Erzeugung einer Wartezeit von einer Millisekunde entspricht.
' Die ereichbare Genauigkeit betrgt +-25% mit Ausreiern im Bereich
' -44% ... +80%.
'
' ___ Schritt 1:___
' Falls der Parameter "Dialog%" = 1 ist, wird zunchst
' in einem Dialog ein zustzlicher Geschwindigkeitfaktor von 1 bis 100
' abgefragt (entspricht Geschwindigkeitserhhung um den Faktor 0,1...10).
'
' __ Schritt 2: ___
' Zur Erreichung der Prozessorunabhngigkeit wird die Anzahl von
' WHILE - Schleifen pro s ermittelt und daraus die Anzahl von FOR-Schleifen
' je msec, welche dann von der Funktion Zeitmes& zurckgeliefert wird.
' Das Verhltnis gemessene WHILE-/ zurckgegebenen FOR-Schleifen wurde
' empirisch an verschiedensten PCs vom 386SX/20MHz bis zum Pentium MMX 266
' MHz ermittelt.
'
'
' Aufrufbeispiele:
' ----------------
' Beispiel 1: Erzeugung einer Wartezeit von 30 msec ohne Abfrage eines
'             Geschwindigkeitsfaktors:
'                    msec& = Zeitmes&(0)        'Anzahl For-Schleifen je ms
'                    ...
'                    CALL Zeit (30, msec&)      'Warteschleife 30 msec
'
' Beispiel 2: Erzeugung je einer Wartezeit von 1 sec mit Geschwindigkeitsfak-
'             tor in einer Dauerschleife bis beliebige Taste bettigt und
'             jeweils Anzeige der verstrichenen Sekunden:
'
'                    msec& = Zeitmes&(1)           'Anzahl For-Schleifen je ms
'                     ...                          'mit Geschw.faktor-Abfrage
'                    z = 1
'                    WHILE INKEY$ = ""
'                       CALL Zeit (1000, msec&)    'Warteschleife 1000msec=1s
'                       z = z + 1
'                       PRINT z; " Sec"
'                    WEND
'
' (c) Thomas Antoni, 07.04.99 - 15.05.99
'****************************************************************************





' Schritt 1: Abfrage des Geschwindigkeitsfaktors
' -----------------------------------------------
SpeedFactor = 10          'Normalen Speedfactor vorbesetzen
IF dialog% = 1 THEN       'soll Geschw.faktor abgefragt werden?
  CLS
  PRINT "Gib Geschwindigkeitsfaktor 1...100 ein:"
  PRINT
  PRINT
  PRINT
  PRINT "       1 = langsamste Geschwindigkeit"
  PRINT "      10 = normale Geschwindigkeit"
  PRINT "     100 = schnellste Geschwindigkeit"
  PRINT "   Enter = berspringen (normale Geschw.)"
  PRINT
  LOCATE 3, 8
  INPUT SpeedFactor%
  IF SpeedFactor% < 1 OR SpeedFactor% > 100 THEN : SpeedFactor% = 10
  PRINT
  CLS
END IF



' Schritt 2a:  Messung der Anzahl WHILE-Schleifen i% je 1 s (Variable i&):
' ------------------------------------------------------------------------
' bei Pentium MMX 233 MHz, EXE-Programm im Win95 DOS-Fenster: 53726
' bei Pentium 100 MHz,     BAS-Programm unter DOS           :  6358
' bei Pentium 100 MHz,     EXE-Programm unter DOS           : 28978
' bei Pentium 100 MHz,     EXE-Programm im Win95 DOS-Fenster: 16854
' bei 486/66 MHz,          BAS-Programm unter DOS           :  2670
' bei 486/66 MHz,          EXE-Programm unter DOS           : 14711
' bei Toshiba 486/50MHz,   BAS-Programm im Win95 DOS-Fenster:  1700
' bei SNI 386SX/20MHz,     BAS-Programm unter DOS           :   402

i& = 1
Anfangszeit! = TIMER
WHILE (TIMER - Anfangszeit!) < 1!
  i& = i& + 1
WEND

PRINT "Anzahl While-Schleifen in 1 sec = "; i&

' Schritt 2b: Ermittlung der Anzahl FOR-Schleifen je msec:
' -------------------------------------------------------------


MilliSec& = 108 * i& / 1000            'empirisch ermittelte Formel
PRINT "Anzahl For-Schleifen je msec    = "; MilliSec&

' Schritt 2c: Anpassung an Speed Factor
' ----------------------------------------
MilliSec& = MilliSec& * 10 / SpeedFactor%
PRINT "Speed Factor                    = "; SpeedFactor%
IF MilliSec& = 0 THEN : MilliSec& = 1 'kleinster Wert = 1, z.B. bei 8086ger
ZEITMES& = MilliSec&

END FUNCTION

