DIM pal(255) AS LONG, pic(32001) AS INTEGER
DIM nbits AS INTEGER, bmpinfosize AS INTEGER
DIM headersize AS INTEGER, picwidth AS INTEGER, picheight AS INTEGER
DIM comptype AS INTEGER, ngroups AS INTEGER, x AS LONG, y AS LONG
DEFINT A-D

CLS
INPUT "Name of file"; filename$
INPUT "Save as"; savename$
OPEN filename$ FOR BINARY AS #1

header$ = SPACE$(14)
sizing$ = SPACE$(4)
GET #1, 1, header$
GET #1, 15, sizing$
bmpinfosize = CVI(sizing$)
'bmpinfosize - Is the size of the information header for the bitmap.
'              Different bitmap versions have variations in filetypes.
'              40 is a standard windows 3.1 bitmap.
'              12 is for OS/2 bitmaps
'The next routine reads in the appropriate headers and color tables.
'nbits is the number of bits per pixel - i.e. number of colours

'       | # of   |
'Offset | bytes  | Function (value)
'-------+--------+--- General Picture information starts here---------
'  0    |   2    | (BM) - Tells us that the picture is in bmp format
'  2    |   4    | Size of the file (without header?)
'  6    |   2    | (0) Reserved1 - Must be zero
'  8    |   2    | (0) Reserved2 - Must be zero
'  10   |   4    | Number of bytes offset of the picture data
'-------+--------+--- Information Header starts here -----------------
'  14   |   4    | (40/12) Size of information header (Win3.1/OS2)
'  18   |   4    | Picture width in pixels
'  22   |   4    | Picture Height in pixels
'  26   |   2    | (1) Number of planes, must be 1
'  28   |   2    | Number of bits per pixel (bpp), must be 1,4,8 or 24
'  30   |   4    | (0) Compression - 0 means no compression, 1,2 are RLEs
'  34   |   4    | Image size in bytes
'  38   |   4    | picture width in pels per metre
'  42   |   4    | picture height in pels per metre
'  46   |   4    | (0) Number of colors used in the picture, 0 means all
'  50   |   4    | (0) Number of important colors, 0 means all
'-------+--------+--- Palette data starts here -----------------------
'  54   |   1    | (b) - blue intensity component, color 0 - range 0 to 255
'  55   |   1    | (g) - green intensity component, color 0 - range 0 to 255
'  56   |   1    | (r) - red intensity component, color 0 - range 0 to 255
'  57   |   1    | (0) - unused
'  58   |   1    | (b) - blue intensity component, color 0 - range 0 to 255
'  ...  | ...    |
'  54   | 4*2^bpp| total range of palette
'-------+--------+--- Image data starts here -------------------------
'54+    | width* | Bitmap data starting at lower left portion of the
'(4*2^n)| height*| image moving from left towards right. Moving up 1
'       | (8/bpp)| pixel when at the right hand side of the image, starting
'       |        | from the left side again, until the top right of the
'       |        | image is reached

'Note that this format is slightly different for a OS/2 Bitmap.
'The header is the same up to (but not including) bit 30-
'The palette color values follow at bit 30, with the form...
'1 byte blue intensity
'1 byte green intensity
'1 byte red intensity
'For each color of the picture.
'Bitmapped image data follows the color tables

IF bmpinfosize = 12 THEN
   infoheader$ = SPACE$(12)
   GET #1, 15, infoheader$
   nbits = CVI(MID$(infoheader$, 15, 4))
  
   IF nbits = 1 THEN
      palet$ = SPACE$(6)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 4 THEN
      palet$ = SPACE$(48)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 8 THEN
      palet$ = SPACE$(768)
      GET #1, bmpinfosize + 15, palet$
   END IF
ELSEIF bmpinfosize = 40 THEN
   infoheader$ = SPACE$(40)
   GET #1, 15, infoheader$
   nbits = CVI(MID$(infoheader$, 15, 4))
   IF nbits = 1 THEN
      palet$ = SPACE$(8)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 4 THEN
      palet$ = SPACE$(64)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 8 THEN
      palet$ = SPACE$(1024)
      GET #1, bmpinfosize + 15, palet$
   END IF
END IF
     

PRINT "Type of file (Should be BMP): "; MID$(header$, 1, 2)
PRINT "Size of file: "; CVL(MID$(header$, 3, 4))
PRINT "Reserved 1: "; CVI(MID$(header$, 7, 2))
PRINT "Reserved 2: "; CVI(MID$(header$, 9, 2))
PRINT "Number of bytes offset from beginning: "; CVL(MID$(header$, 11, 4))
PRINT
headersize = CVL(MID$(infoheader$, 1, 4))
PRINT "Size of header: "; headersize

picwidth = CVL(MID$(infoheader$, 5, 4))
PRINT "Width: "; picwidth

picheight = CVL(MID$(infoheader$, 9, 4))
PRINT "Height: "; picheight

PRINT "Planes: "; CVI(MID$(infoheader$, 13, 4))
PRINT "Bits per plane: "; nbits
PRINT

IF headersize = 40 THEN
   PRINT "Compression: ";
   comptype = CVL(MID$(infoheader$, 17, 4))
   IF comptype = 0 THEN PRINT "None"
   IF comptype = 1 THEN PRINT "Run Length - 8 Bits"
   IF comptype = 2 THEN PRINT "Run Length - 4 Bits"
  
   PRINT "Image Size (bytes): "; CVL(MID$(infoheader$, 21, 4))
   PRINT "X size (pixels per meter): "; CVL(MID$(infoheader$, 25, 4))
   PRINT "Y size (pixels per meter): "; CVL(MID$(infoheader$, 29, 4))
   PRINT "Number of colors used: "; CVL(MID$(infoheader$, 33, 4))
   PRINT "Number of important colors: "; CVL(MID$(infoheader$, 37, 4))
END IF
PRINT
PRINT "Press Any key to continue."
SLEEP

IF nbits = 1 THEN
   SCREEN 11
ELSEIF nbits = 4 THEN
   SCREEN 12
ELSEIF nbits = 8 OR nbits = 24 THEN
   SCREEN 13
END IF
IF bmpinfosize = 40 THEN ngroups = 4
IF bmpinfosize = 12 THEN ngroups = 3

IF nbits = 24 THEN
   IF ngroups = 3 THEN
      FOR c = 0 TO 63
         d = c * 4
         palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d)
         palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d + 1)
         palet$ = palet$ + CHR$(d) + CHR$(d + 1) + CHR$(d)
         palet$ = palet$ + CHR$(d + 1) + CHR$(d) + CHR$(d)
      NEXT c
   ELSEIF ngroups = 4 THEN
      FOR c = 0 TO 63
         d = c * 4
         palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d) + CHR$(0)
         palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d + 1) + CHR$(0)
         palet$ = palet$ + CHR$(d) + CHR$(d + 1) + CHR$(d) + CHR$(0)
         palet$ = palet$ + CHR$(d + 1) + CHR$(d) + CHR$(d) + CHR$(0)
      NEXT c
   END IF
END IF

FOR x = 1 TO LEN(palet$) STEP ngroups
   zb% = INT(ASC(MID$(palet$, x, 1)) \ 4)
   zg% = INT(ASC(MID$(palet$, x + 1, 1)) \ 4)
   zr% = INT(ASC(MID$(palet$, x + 2, 1)) \ 4)
   OUT &H3C8, ((x - 1) \ ngroups)
   OUT &H3C9, zr%
   OUT &H3C9, zg%
   OUT &H3C9, zb%
   pal((x - 1) \ ngroups) = zb% * 65536 + zg% * 256 + zr%
NEXT x

DEF SEG = &HA000
IF nbits = 24 THEN
   dat$ = "   "
   FOR y = picheight - 1 TO 0 STEP -1
      FOR x = 0 TO picwidth - 1
         GET 1, , dat$
         IF x < 320 AND y < 200 THEN POKE x + 320 * y, ASC(dat$)
         GET 1, , dat$
         GET 1, , dat$
      NEXT
   NEXT
ELSEIF nbits = 8 THEN
   dat$ = " "
   FOR y = picheight - 1 TO 0 STEP -1
      FOR x = 0 TO picwidth - 1
         GET 1, , dat$
         IF x < 320 AND y < 200 THEN POKE x + 320 * y, ASC(dat$)
      NEXT
   NEXT
ELSEIF nbits = 4 THEN
   dat$ = " "
   FOR y = picheight - 1 TO 0 STEP -1
      FOR x = 0 TO picwidth - 1 STEP 2
        GET 1, , dat$
        PSET (x, y), ASC(dat$) AND 15
        PSET (x + 1, y), ASC(dat$) AND 240 \ 16
      NEXT
   NEXT
ELSEIF nbits = 1 THEN
   dat$ = " "
   FOR y = picheight - 1 TO 0 STEP -1
      FOR x = 0 TO (picwidth - 1) \ 8
        GET 1, , dat$
        IF x < 80 AND y < 480 THEN POKE x + 80 * y, ASC(dat$)
      NEXT
   NEXT
END IF

CLOSE
'FOR xx% = 0 TO 319
'   FOR xy% = 0 TO 199
'      IF POINT(xx%, xy%) < 96 THEN PSET (xx%, xy%), 0
'   NEXT
'NEXT
GET (0, 0)-(picwidth - 1, picheight - 1), pic
DEF SEG = VARSEG(pic(0))
pw& = picwidth
ph& = picheight
BSAVE savename$, VARPTR(pic(0)), pw& * ph& + 3
SLEEP

