'***********************************************************
'                        SHOW.BAS
'          Copyright (C) Kay Glahn & DMV-Verlag
' Programm zum Darstellen von Icons und kleinen Bitmaps
'            auf einer beliebigen Grafikkarte
'                Compiler:  Quick Basic 4.5
'***********************************************************

DIM SHARED tempo(1 TO 402) AS INTEGER

DECLARE SUB GetGraf (mode%)
DECLARE FUNCTION bestvideo% ()
DECLARE SUB ReadPixel (Pixel() AS LONG, Farbe() AS INTEGER, BitProPix%, Begin&, Grose&)
DEFINT A-Z
ON ERROR GOTO Errorhandler

TYPE video
  maxx AS INTEGER
  maxy AS INTEGER
  maxh AS INTEGER
  maxv AS INTEGER
  Maxcolor AS INTEGER
END TYPE

DIM graf AS video
DIM Farbe(0 TO 15) AS INTEGER
DIM Kenn AS STRING * 2

datei$ = ""
PRINT "Icon- und Bitmap-Betrachter (C) 1991 Kay Glahn & DMV-Verlag"
PRINT
IF datei$ = "" THEN
  FILES "*.bmp"
  INPUT "Anzuzeigende Datei : ", datei$
  name$ = datei$
  datei$ = datei$ + ".bmp"
ELSE
  SLEEP 3
END IF
OPEN datei$ FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL datei$
  PRINT "Die Datei "; datei$; " existiert nicht !"
  END
END IF
GET #1, 1, Kenn
GET #1, 3, Art%
GET #1, 5, Anzahl%
Endung$ = UCASE$(MID$(datei$, INSTR(datei$, ".") + 1, 3))
IF Endung$ = "BMP" AND Kenn = "BM" THEN
  GET #1, 19, Breite&
  GET #1, 23, Hohe&
  GET #1, 29, BitProPix%
  Grose& = Hohe& * Breite& * BitProPix% / 8
  GET #1, 11, Begin&
ELSE
  PRINT "Die Datei "; datei$
  PRINT "ist eine ungltige Bitmap- oder Icon-Datei !"
  CLOSE
  END
END IF
IF Hohe& * Breite& > 32767 THEN
  PRINT "Bild zu gro !"
  CLOSE
  END
END IF

DIM Pixel(Hohe& * Breite&) AS LONG
CALL ReadPixel(Pixel(), Farbe(), BitProPix%, Begin&, Grose&)
CLS
best = bestvideo
CALL GetGraf(best)
IF best = 0 THEN
  PRINT "Kein grafikfhiger Videoadapter vorhanden !"
  SLEEP 2
  CLOSE
  END
END IF
IF graf.Maxcolor < 2 ^ BitProPix% THEN
  PRINT "Ihre Grafikkarte kann nicht gengend Farben darstellen !"
  SLEEP 2
  CLOSE
  END
END IF
PRINT "Bild wird nun geladen !"
PRINT "Gre kann mit <+> und <-> verndert werden, abbruch mit bel. Taste !"
SLEEP 2
SCREEN best
f = 1
DO
  CLS
  Counter = 1
  FOR x = Hohe& TO 1 STEP -1
    FOR y = 1 TO Breite&
      LINE ((y * f - f + 1) + 100, (x * f - f + 1) + 100)-((y * f) + 100, (x * f) + 100), Farbe(Pixel(Counter)), BF
      Counter = Counter + 1
    NEXT
  NEXT
GET (101, 101)-(139, 139), tempo
DEF SEG = VARSEG(tempo(1))
BSAVE name$ + ".spr", VARPTR(tempo(1)), 804
LINE (100, 100)-(140, 140), 15, B
  DO
    Taste$ = INKEY$
  LOOP WHILE Taste$ = ""
  IF Taste$ = "+" THEN f = f + 1
  IF Taste$ = "-" THEN f = f - 1
  IF f = 0 THEN f = 1
LOOP UNTIL Taste$ <> "+" AND Taste$ <> "-"
SCREEN 0, 0, 0
END
Errorhandler:
  PRINT "Systemfehler !"
  SLEEP 2
  CLOSE
  END
Videoerr:
  SELECT CASE bestmode
    CASE 12 'VGA
      bestmode = 11 'MCGA
    CASE 11 'MCGA
      bestmode = 9  'EGA256
    CASE 9  'EGA256
      bestmode = 10 'MONO
    CASE 10 'MONO
      bestmode = 2  'CGA
    CASE 2  'CGA
      bestmode = 3  'HERC
    CASE ELSE
      bestmode = 0  'KEINE
  END SELECT
  RESUME
EGAErr:
  bestmode = 8 'EGA64
  RESUME NEXT

'Ermittlung des besten Grafikmodus
FUNCTION bestvideo
  SHARED bestmode
  bestmode = 12 'VGA
  ON ERROR GOTO Videoerr
  IF bestmode = 0 THEN
    SCREEN 0
    WIDTH 80, 25
    bestvideo = bestmode
    EXIT FUNCTION
  END IF
  SCREEN bestmode
  ON ERROR GOTO EGAErr
  IF bestmode = 9 THEN SCREEN 8, , 1
  ON ERROR GOTO Errorhandler
  SCREEN 0, , 0
  WIDTH 80, 25
  bestvideo = bestmode
END FUNCTION

'Ermittlung der Auflsung und der Anzahl der Farben
SUB GetGraf (mode)
  SHARED graf AS video
  SELECT CASE mode
    CASE 1
      graf.maxx = 320
      graf.maxy = 200
      graf.maxh = 40
      graf.maxv = 25
      graf.Maxcolor = 4
    CASE 2
      graf.maxx = 640
      graf.maxy = 200
      graf.maxh = 80
      graf.maxv = 25
      graf.Maxcolor = 2
    CASE 3
      graf.maxx = 720
      graf.maxy = 348
      graf.maxh = 80
      graf.maxv = 25
      graf.Maxcolor = 2
    CASE 4
      graf.maxx = 640
      graf.maxy = 400
      graf.maxh = 80
      graf.maxv = 25
      graf.Maxcolor = 1
    CASE 7
      graf.maxx = 320
      graf.maxy = 200
      graf.maxh = 40
      graf.maxv = 25
      graf.Maxcolor = 16
    CASE 8
      graf.maxx = 640
      graf.maxy = 200
      graf.maxh = 80
      graf.maxv = 25
      graf.Maxcolor = 16
    CASE 9
      graf.maxx = 640
      graf.maxy = 350
      graf.maxh = 80
      graf.maxv = 25
      graf.Maxcolor = 16
    CASE 10
      graf.maxx = 640
      graf.maxy = 350
      graf.maxh = 80
      graf.maxv = 25
      graf.Maxcolor = 2
    CASE 11
      graf.maxx = 640
      graf.maxy = 480
      graf.maxh = 80
      graf.maxv = 30
      graf.Maxcolor = 2
    CASE 12
      graf.maxx = 640
      graf.maxy = 480
      graf.maxh = 80
      graf.maxv = 30
      graf.Maxcolor = 16
    CASE 13
      graf.maxx = 320
      graf.maxy = 200
      graf.maxh = 40
      graf.maxv = 25
      graf.Maxcolor = 256
    CASE ELSE
  END SELECT
END SUB

'Lesen der Daten aus der Datei
SUB ReadPixel (Pixel() AS LONG, Farbe() AS INTEGER, BitProPix%, Begin&, Grose&)
  Counter = 1
  DIM Byte AS STRING * 1
  SELECT CASE BitProPix%
    CASE 1
      FOR i = 1 TO Grose& * 8 STEP 8
        GET #1, Begin& + Counter, Byte
        Wert = ASC(Byte)
        Pixel(i + 7) = Wert AND 1
        Pixel(i + 6) = (Wert AND 2) / 2
        Pixel(i + 5) = (Wert AND 4) / 4
        Pixel(i + 4) = (Wert AND 8) / 8
        Pixel(i + 3) = (Wert AND 16) / 16
        Pixel(i + 2) = (Wert AND 32) / 32
        Pixel(i + 1) = (Wert AND 64) / 64
        Pixel(i) = (Wert AND 128) / 128
        Counter = Counter + 1
      NEXT i
      Farbe(0) = 0
      Farbe(1) = 15
    CASE 4
      FOR i = 1 TO Grose& * 2 STEP 2
        GET #1, Begin& + Counter, Byte
        Wert = ASC(Byte)
        Pixel(i + 1) = (Wert AND 15)
        Pixel(i) = (Wert AND 240) / 16
        Counter = Counter + 1
      NEXT
      Farbe(0) = 0
      Farbe(1) = 4
      Farbe(2) = 2
      Farbe(3) = 6
      Farbe(4) = 1
      Farbe(5) = 5
      Farbe(6) = 3
      Farbe(7) = 8
      Farbe(8) = 7
      Farbe(9) = 12
      Farbe(10) = 10
      Farbe(11) = 14
      Farbe(12) = 9
      Farbe(13) = 13
      Farbe(14) = 11
      Farbe(15) = 15
    CASE ELSE
      PRINT "Es knne nur 2- und 16-farbige Bilder angezeigt werden !"
      CLOSE
      END
  END SELECT
END SUB

