'*****************************************************************
'** Das Programm zeigt GIF Bilder an.                           **
'** Man kann Sie von 640x400 bis 1024x768 Pixel anzeigen lassen **
'** Die Bilder sollten aber nicht mehr als 256 Farben haben.    **
'** Man kann mich unter MichaelHagemann@GMX.DE                  **
'** oder ber meine Seite http://www.KaiHagemann.de erreichen.  **
'** Ich wrde mich freuen wann man mir schreibt wie einem das   **
'** Programm gefallen hat.                                      **
'** Ich mchte allen aber bieten, diesen Hinweis drin zulassen  **
'*****************************************************************
DECLARE FUNCTION GetByte% ()
DECLARE FUNCTION VesaStatus% ()
DECLARE FUNCTION FileExist% (t$)
DECLARE SUB INTERRUPTX2 (IntNo AS INTEGER, Inreg AS ANY, OutReg AS ANY)
DECLARE SUB SetVESAMode (Mode%)
DECLARE SUB GetVESAInfo (Mode%)
DECLARE SUB SwitchBank (Win%)
DECLARE SUB VPSET (X%, Y%, Col%)
DECLARE SUB DVGIF (file$, Task%)
DEFINT A-Z
TYPE VbeInfoBlock
  VbeSignature          AS STRING * 4
  VbeVersion            AS INTEGER
  OemStringPtr          AS LONG
  Capabilities          AS STRING * 4
  VideoModePtr          AS LONG
  TotalMemory           AS INTEGER
  OemSoftwareRev        AS INTEGER
  OemVendorNamePtr      AS LONG
  OemProductNamePtr     AS LONG
  OemProductRevPtr      AS LONG
  Reserved              AS STRING * 222
  OemData               AS STRING * 256
END TYPE
TYPE ModeInfoBlock
  Attr                AS INTEGER
  WinAAttr            AS STRING * 1
  WinBAttr            AS STRING * 1
  Gran                AS INTEGER
  Size                AS INTEGER
  WinASeg             AS INTEGER
  WinBSeg             AS INTEGER
  FarWindow           AS LONG
  BytesScanLine       AS INTEGER
  WidthPixels         AS INTEGER
  HeightPixels        AS INTEGER
  WidthChar           AS STRING * 1
  HeightChar          AS STRING * 1
  Planes              AS STRING * 1
  BitsPerPixel        AS STRING * 1
  Banks               AS STRING * 1
  MemoryModel         AS STRING * 1
  BankSize            AS STRING * 1
  Pages               AS STRING * 1
  Reserved            AS STRING * 1
  RedMask             AS STRING * 1
  RedField            AS STRING * 1
  GreenMask           AS STRING * 1
  GreenField          AS STRING * 1
  BlueMask            AS STRING * 1
  BlueField           AS STRING * 1
  ReservedMask        AS STRING * 1
  ReservedPosition    AS STRING * 1
  DirectColorInfo     AS STRING * 1
  VideoBuffer         AS LONG
  OffscreenMemory     AS LONG
  KBOffscreenMemory   AS INTEGER
  Reserved2           AS STRING * 206
END TYPE
TYPE RegTypeX
  ax AS INTEGER
  bx AS INTEGER
  cx AS INTEGER
  dx AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  flags AS INTEGER
  ds AS INTEGER
  ES AS INTEGER
END TYPE
CONST FALSE = 0, TRUE = NOT FALSE
DIM VbeInfoBlock AS VbeInfoBlock, ModeInfoBlock AS ModeInfoBlock
DIM Register AS RegTypeX
DIM VESAMode(4)
VESAMode(1) = &H100
VESAMode(2) = &H101
VESAMode(3) = &H103
VESAMode(4) = &H105
SCREEN 0, 0, 0
CLS
IF VesaStatus% = 0 THEN
  PRINT "VESA VGA ist nicht bereit."
  PRINT "Insttallieren Sie den Treiber fr Ihre Grafikkarte,"
  PRINT "und starten neu."
  END
END IF
INPUT "Name of GIF file? >", file$
IF FileExist%(file$) = 0 THEN
  PRINT "Eine Datei mit dem Namen existiert nicht!"
  END
END IF
IF INSTR(file$, ".") = 0 THEN file$ = file$ + ".gif"
CALL DVGIF(file$, 1)
DO
  DO
    PRINT
    PRINT "Image ="; TotalX; "x "; TotalY
    PRINT
    PRINT "(1)  -   640x400x256"
    PRINT "(2)  -   640x480x256"
    PRINT "(3)  -   800x600x256"
    PRINT "(4)  -  1024x768x256"
    PRINT
    INPUT "Welches Display wnschen Sie? (1-4, 0 to exit) >", A$
    VM = VAL(A$)
  LOOP UNTIL VM > -1 AND VM < 5
  IF VM = 0 THEN END
  CALL GetVESAInfo(VM)
  IF (ModeInfoBlock.Attr AND 1) THEN EXIT DO
  PRINT "Der Modus wird nicht untersttze, whlen Sie einen andern."
LOOP
SCREEN 13
CALL SetVESAMode(VM)
DIM RefTable&(ModeInfoBlock.HeightPixels - 1)
FOR I& = 0 TO ModeInfoBlock.HeightPixels - 1
  RefTable&(I&) = I& * ModeInfoBlock.BytesScanLine
NEXT I&
WinSize& = ModeInfoBlock.Size * 1024&
CALL DVGIF(file$, 2)
DO
LOOP WHILE INKEY$ = ""
SCREEN 0, 0, 0
WIDTH 80
END
InterruptXASM:
DATA  190
DATA 55,8B,EC,8B,5E,0C,8B,17,0A,F6
DATA 74,07,C7,07,FF,FF,E9,A7,00,8B
DATA 5E,06,8B,1F,2E,88,97,77,00,32
DATA C0,80,FA,25,74,05,80,FA,26,75
DATA 02,0C,02,50,1E,06,56,57,9C,8B
DATA 76,0A,80,FA,20,7C,05,80,FA,30
DATA 7C,0A,81,7C,08,FF,FF,74,03,8B
DATA 6C,08,8B,44,0E,25,D5,0F,50,8B
DATA 04,8B,5C,02,8B,4C,04,8B,54,06
DATA 8B,7C,0C,FF,74,0A,81,7C,12,FF
DATA FF,74,03,8E,44,12,81,7C,10,FF
DATA FF,74,03,8E,5C,10,5E,9D,CD,00
DATA 55,8B,EC,9C,83,C5,0E,F6,46,FE
DATA 02,74,02,45,45,1E,56,8E,5E,FC
DATA 8B,76,08,89,04,89,5C,02,89,4C
DATA 04,89,54,06,8F,44,0A,89,7C,0C
DATA 8F,44,10,8C,44,12,8F,44,0E,8F
DATA 44,08,F6,46,FE,02,74,02,44,44
DATA 9D,5F,5E,07,1F,58,5D,CA,08,00

SUB DVGIF (file$, Task%) STATIC
DIM Prefix(4095), Suffix(4095), OutStack(4095), shiftout(8)
DIM powersof2(11) AS LONG, WorkCode AS LONG
SHARED TotalX, TotalY
SHARED ModeInfoBlock AS ModeInfoBlock, NumWindows
FOR A = 0 TO 7: shiftout(8 - A) = 2 ^ A: NEXT A
FOR A = 0 TO 11: powersof2(A) = 2 ^ A: NEXT A
SELECT CASE Task%
  CASE 1
    OPEN file$ FOR BINARY AS #1
    A$ = "      ": GET #1, , A$
    IF A$ <> "GIF87a" THEN PRINT "Not a GIF87a file.": END
    GET #1, , TotalX: GET #1, , TotalY: A = GetByte
    NumColors = 2 ^ ((A AND 7) + 1): NoPalette = (A AND 128) = 0
    Background = GetByte
    IF GetByte <> 0 THEN PRINT "Bad screen descriptor.": END
    IF NoPalette = 0 THEN P$ = SPACE$(NumColors * 3): GET #1, , P$
    DO
      A = GetByte
      IF A = 44 THEN
        EXIT DO
      ELSEIF A <> 33 THEN
        PRINT "Unknown extension type.": END
      END IF
      A = GetByte
      DO: A = GetByte: A$ = SPACE$(A): GET #1, , A$: LOOP UNTIL A = 0
    LOOP
    GET #1, , XStart: GET #1, , YStart: GET #1, , XLength: GET #1, , YLength
    XEnd = XStart + XLength: YEnd = YStart + YLength: A = GetByte
    IF A AND 128 THEN PRINT "Can't handle local colormaps.": END
    Interlaced = A AND 64: PassNumber = 0: PassStep = 8
    A = GetByte
    ClearCode = 2 ^ A
    EOSCode = ClearCode + 1
    FirstCode = ClearCode + 2: NextCode = FirstCode
    StartCodeSize = A + 1: CodeSize = StartCodeSize
    StartMaxCode = 2 ^ (A + 1) - 1: MaxCode = StartMaxCode
    BitsIn = 0: BlockSize = 0: BlockPointer = 1
    X = XStart: Y = YStart
    Floc% = LOC(1) + 1
    CLOSE #1
  CASE 2
    IF NoPalette = 0 THEN
      OUT &H3C7, 0: OUT &H3C8, 0
      FOR A = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(P$, A, 1)) \ 4: NEXT A
    END IF
    FOR A = 0 TO NumWindows - 1
      SwitchBank A
      LINE (0, 0)-(319, 199), Background, BF
    NEXT A
    OPEN file$ FOR BINARY AS #1
    SEEK #1, Floc%
    DO
      GOSUB GetCode
      IF code <> EOSCode THEN
        IF code = ClearCode THEN
          NextCode = FirstCode
          CodeSize = StartCodeSize
          MaxCode = StartMaxCode
          GOSUB GetCode
          CurCode = code: LastCode = code: LastPixel = code
            IF X < ModeInfoBlock.WidthPixels THEN VPSET X, Y, LastPixel
            X = X + 1: IF X = XEnd THEN GOSUB NextScanLine
        ELSE
          CurCode = code: StackPointer = 0
          IF code > NextCode THEN EXIT DO
          IF code = NextCode THEN
            CurCode = LastCode
            OutStack(StackPointer) = LastPixel
            StackPointer = StackPointer + 1
          END IF
          DO WHILE CurCode >= FirstCode
            OutStack(StackPointer) = Suffix(CurCode)
            StackPointer = StackPointer + 1
            CurCode = Prefix(CurCode)
          LOOP
          LastPixel = CurCode
          IF X < ModeInfoBlock.WidthPixels THEN VPSET X, Y, LastPixel
          X = X + 1: IF X = XEnd THEN GOSUB NextScanLine
          FOR A = StackPointer - 1 TO 0 STEP -1
            IF X < ModeInfoBlock.WidthPixels THEN VPSET X, Y, OutStack(A)
            X = X + 1: IF X = XEnd THEN GOSUB NextScanLine
          NEXT A
          IF NextCode < 4096 THEN
            Prefix(NextCode) = LastCode
            Suffix(NextCode) = LastPixel
            NextCode = NextCode + 1
            IF NextCode > MaxCode AND CodeSize < 12 THEN
              CodeSize = CodeSize + 1
              MaxCode = MaxCode * 2 + 1
            END IF
          END IF
          LastCode = code
        END IF
      END IF
    LOOP UNTIL DoneFlag OR code = EOSCode OR INKEY$ <> ""
    CLOSE #1
END SELECT
EXIT SUB
NextScanLine:
  IF Interlaced THEN
    Y = Y + PassStep
    IF Y >= YEnd THEN
      PassNumber = PassNumber + 1
      SELECT CASE PassNumber
        CASE 1: Y = 4: PassStep = 8
        CASE 2: Y = 2: PassStep = 4
        CASE 3: Y = 1: PassStep = 2
      END SELECT
    END IF
  ELSE
    Y = Y + 1
  END IF
  X = XStart: DoneFlag = Y > ModeInfoBlock.HeightPixels
RETURN
GetCode:
  IF BitsIn = 0 THEN GOSUB ReadBufferedByte: LastChar = A: BitsIn = 8
  WorkCode = LastChar \ shiftout(BitsIn)
  DO WHILE CodeSize > BitsIn
    GOSUB ReadBufferedByte: LastChar = A
    WorkCode = WorkCode OR LastChar * powersof2(BitsIn)
    BitsIn = BitsIn + 8
  LOOP
  BitsIn = BitsIn - CodeSize
  code = WorkCode AND MaxCode
RETURN
ReadBufferedByte:
  IF BlockPointer > BlockSize THEN
    BlockSize = GetByte
    A$ = SPACE$(BlockSize): GET #1, , A$
    BlockPointer = 1
  END IF
  A = ASC(MID$(A$, BlockPointer, 1)): BlockPointer = BlockPointer + 1
RETURN
END SUB

FUNCTION FileExist% (t$)
DIM f AS STRING * 64
DIM Inx AS RegTypeX
DIM Outx AS RegTypeX
Inx.ax = &H2F00
CALL INTERRUPTX2(&H21, Inx, Outx)
DTAAddr = Outx.bx
f$ = LTRIM$(RTRIM$(UCASE$(t$))) + CHR$(0)
Inx.ds = VARSEG(f$)
Inx.dx = VARPTR(f$)
Inx.ax = &H4E00
Inx.cx = -1
CALL INTERRUPTX2(&H21, Inx, Outx)
IF Outx.flags AND 1 THEN
  FileExist% = 0
ELSE
  FileExist% = 1
END IF
END FUNCTION

FUNCTION GetByte%
A$ = " ": GET #1, , A$: GetByte = ASC(A$)
END FUNCTION

SUB GetVESAInfo (Mode%)
SHARED VESAMode%(), Register AS RegTypeX, ModeInfoBlock AS ModeInfoBlock
Register.ax = &H4F01
Register.cx = VESAMode%(Mode%)
Register.ES = VARSEG(ModeInfoBlock)
Register.DI = VARPTR(ModeInfoBlock)
CALL INTERRUPTX2(&H10, Register, Register)
END SUB

SUB INTERRUPTX2 (IntNo%, Inreg AS RegTypeX, OutReg AS RegTypeX) STATIC
IF NOT MachineCode% THEN
  RESTORE InterruptXASM
  READ nASMBYTES%
  REDIM ASMBuffer(0 TO nASMBYTES% - 1) AS STRING * 1
END IF
DEF SEG = VARSEG(ASMBuffer(0))
offset% = VARPTR(ASMBuffer(0))
IF NOT MachineCode% THEN
  FOR I% = 0 TO nASMBYTES% - 1
    READ code$
    POKE offset% + I%, VAL("&H" + code$)
  NEXT I%
  MachineCode% = TRUE
END IF
CALL Absolute(IntNo%, Inreg, OutReg, offset%, offset%)
DEF SEG
END SUB

SUB SetVESAMode (Mode%)
SHARED VESAMode%(), CurrentBank%, Register AS RegTypeX
Register.ax = &H4F02
Register.bx = VESAMode%(Mode%)
CALL INTERRUPTX2(&H10, Register, Register)
CurrentBank% = -1
END SUB

SUB SwitchBank (Win%)
SHARED Register AS RegTypeX
Register.ax = &H4F05
Register.bx = &H0
Register.dx = Win%
CALL INTERRUPTX2(&H10, Register, Register)
END SUB

FUNCTION VesaStatus%
SHARED Register AS RegTypeX, VbeInfoBlock AS VbeInfoBlock
VbeInfoBlock.VbeSignature = "VBE2"
Register.ax = &H4F00
Register.ES = VARSEG(VbeInfoBlock)
Register.DI = VARPTR(VbeInfoBlock)
CALL INTERRUPTX2(&H10, Register, Register)
IF Register.ax = &H4F AND VbeInfoBlock.VbeSignature = "VESA" THEN
  VesaStatus% = -1
ELSE
  VesaStatus% = 0
END IF
END FUNCTION

SUB VPSET (X%, Y%, Colour%)
SHARED ModeInfoBlock AS ModeInfoBlock
SHARED RefTable&(), CurrentBank%, WinSize&
Temp& = RefTable&(Y%) + X%
A% = Temp& \ WinSize&
IF A% <> CurrentBank% THEN
  SwitchBank A%
  CurrentBank% = A%
END IF
DEF SEG = &HA000
POKE (Temp& MOD WinSize&) AND 65535, Colour%
DEF SEG
END SUB

