'             
'               ͸
'                Welcome to a tutorial by By Nic Fouhy 
'               ;
'
'                         VISIT MY WEBSITE AT:       
'                      http://www.qbworld.8k.com/
'             
'                             18 March 2000
'
'                Please do not alter this file in any way
'                if you plan on giving it away somewhere.
'              
'               If you want to change it then E-mail me at:
'              
'                         nicfouhy@hotmail.com
'
'                      and I will get back to you.
'
'       We are going to go over three different ways of creating
'       graphics.  We will be drawing a smiley face out of
'       each method.  Here they are:
'
'       1)  We will be using the simple built-in graphic commands
'           to draw the smiley face.  These commands are easy to
'           use but take a long time to do really good graphics.
'           The commands are: LINE (we'll be using other commands
'           to compliment this one) and PSET .
'
'       2)  We will be using DATA statements and from them we get
'           our picture.  These are more easy than the commands
'           above for detailed graphics, but I wouldn't do it this
'           way if you want a big picture.  We put a whole lot of
'           numbers after the data statements and then we READ
'           (I did that in capitals because it's a QBasic command)
'           the picture of the smiley face, or whatever you put in
'           the DATA statements into arrays (arrays are little
'           blocks of memory that you can store things in like words
'           and numbers, this is what we'll be doing with numbers).
'           I'll explain more when we get there.
'
'       3)  Saving and loading sprites.  This is a little more
'           complex than the other two, it involves saving your
'           picture as a file onto your computer.  It is by far the
'           most easy way to do graphics (that is if you use a QB
'           drawing utility).  We are going to save our DATA
'           statements that we used in method 2 as a QB picture file.
'           We do this by using QBasics built in BSAVE command. 
'           After we have saved it we can then load it again later
'           by using the BLOAD command (pretty simple commands you
'           say, well they are!).

'   By the way, to type anything you wan't (like I am here) that you
'   don't want QBasic to pick up when the program runs we use the '
'   before whatever you type.  You can also use REM like I'll show
REM you on this line!

' Or if you are really smart (heavy sarcasm there) you can use REM to
' do clever things like this:

REM ind me to do that thing!


'        ͸
'        METHOD Number 1
'        ;

SCREEN 13  ' This is the best screen for doing graphics in.  It is a
           ' VGA screen that has the most colours to choose from 256
           ' of them already preset for you (I say already preset
           ' because you can change them, but that is a whole new
           ' tutorial all on its own.  It has a screen resolution of
           ' 320 * 200 (pixels I'm talking about, if you don't know
           ' what pixels are don't worry because I explain in just a
           ' few moments).  You don't need to put CLS at the top of
           ' the screen because QBasic already does it for when you
           ' use the SCREEN command, by the way there are 13 screens
           ' to choose from all have their own ups and downs.  To
           ' see some more SCREEN descriptions just click on SCREEN
           ' so that the cursor is underneath it, then click Help up
           ' on the top right hand side.  You will see it says
           ' Topic: SCREEN click on it and a list will come up.


' The PSET function

' I'll draw the smiley face using the PSET command and then explain.
' By the way for people that don't know what a pixel is, pixels are
' little square dots on your monitor.  We can change and munipulate
' these little dots to make pictures.  Right now you computer is
' using dots, if you look hard enough you might be able to see them.

LOCATE 12, 12
PRINT "The PSET way..." ' PRINT whats in the brackets
                        ' to tell us which method
                        ' QBasic is using.

'First row of pixels     ' PSET if you havn't already figured it out
PSET (3, 1), 14          ' means pixel set, so what's on the left is
PSET (4, 1), 14          ' telling QBasic to set the pixels at at
PSET (5, 1), 14          ' the positions inside the brackets.  The
PSET (6, 1), 14          ' number after the brackets is the colour
PSET (7, 1), 14          ' number (14 = yellow).
PSET (8, 1), 14
                         ' For example:
'Second row of pixels    ' Think of the screen as a table.  We are 
PSET (2, 2), 14          ' using screen 13 with has a resolution of
PSET (9, 2), 14          ' 320 * 200 remember so in our table we
                         ' will have 200 columns and 320 rows. Look
'Third row of pixels     ' at the first row of pixels.  The first
PSET (1, 3), 14          ' number is the row number and the second
PSET (10, 3), 14         ' (yep thats right) is the column number.
                         ' The last number is the colour number
'Fourth row of pixels    ' so.... This means it'll fill up the cell
PSET (1, 4), 14          ' located at 3, 1 with the colour yellow.
PSET (4, 4), 14
PSET (7, 4), 14          ' Get it?
PSET (10, 4), 14

'Fifth row of pixels
PSET (1, 5), 14
PSET (4, 5), 14
PSET (7, 5), 14
PSET (10, 5), 14

'Sixth row of pixels
PSET (1, 6), 14
PSET (10, 6), 14

'Seventh row of pixels
PSET (1, 7), 14
PSET (3, 7), 14
PSET (8, 7), 14
PSET (10, 7), 14

'Eigth row of pixels                 ' As you can see, drawing pictures
PSET (1, 8), 14                      ' like this would take for ever!
PSET (4, 8), 14                      ' So that is why a lot of QBasic
PSET (5, 8), 14                      ' programmers do not use this
PSET (6, 8), 14                      ' statement much.
PSET (7, 8), 14
PSET (10, 8), 14

'Ninth row of pixels
PSET (2, 9), 14
PSET (9, 9), 14

'Tenth and last row of pixels
PSET (3, 10), 14
PSET (4, 10), 14
PSET (5, 10), 14
PSET (6, 10), 14
PSET (7, 10), 14
PSET (8, 10), 14

DO: LOOP UNTIL INKEY$ <> "": CLS

' Now we'll use the LINE command.

CLS  ' So that the screen is fresh ready to draw again.

LOCATE 12, 12
PRINT "The LINE way..." ' PRINT whats in the speech marks
                        ' to tell us which method QBasic
                        ' is using.

'First row of pixels       ' The LINE command is a lot like the PSET
LINE (3, 1)-(8, 1), 14     ' one.  You can probably guess whats
                           ' going on here.  Well, even if you did
'First coloumn of pixels   ' guess congrats but I'm still going to
LINE (1, 3)-(1, 8), 14     ' tell you what it does. 

'Second row of pixels      ' Like I said the LINE command is a lot
LINE (2, 2)-(2, 2), 14     ' like the PSET command, except in this
LINE (9, 2)-(9, 2), 14     ' one you have to use 2 sets of
                           ' co-ordinates.  One to tell QBasic
'Second coloumn of pixels  ' where to start the LINE and one to
LINE (10, 3)-(10, 8), 14   ' tell it where to stop.  The first set
                           ' is where it starts, and the second is
'Fourth column of pixels   ' where it finishes.  Again, the last
LINE (4, 4)-(4, 5), 14     ' number is the one that holds the
                           ' colour.
'Seventh row of pixels
LINE (3, 7)-(3, 7), 14     ' There are other attributes you can
LINE (8, 7)-(8, 7), 14     ' add on to help you do your graphics.
                           ' These are B and BF.  You add these on
'Seventh column of pixels  ' at the very end after the colour
LINE (7, 4)-(7, 5), 14     ' number.  
                           '
'Eigth row of pixels       ' E.G
LINE (4, 8)-(7, 8), 14     ' LINE (25, 25)-(50, 50), 2, BF
                           ' Will draw a 25 * 25 size box and fill
'Ninth row of pixels       ' it in with green.
LINE (2, 9)-(2, 9), 14     '
LINE (9, 9)-(9, 9), 14     ' LINE (25, 25)-(50, 50), 2, B
                           ' Will draw a 25 * 25 size box (it won't
'Tenth row of pixels       ' fill it in though).
LINE (3, 10)-(8, 10), 14

' I could have used the PSET command for row 2 and line 8.
' However, I didn't so that I could show you how to use the
' line command and that you could use it to make only one dot
' (just like PSET).

DO: LOOP UNTIL INKEY$ <> ""   ' This just stops the program from
                              ' going any further until a key is
                              ' pressed.
'        ͸
'        METHOD Number 2
'        ;

CLS
LOCATE 12, 12
PRINT "The DATA way..."

' These are the DATA statements, ͻ
' you can see the smiley face          
' in the numbers.  14 = yellow         
' 00 = black.  QBasic is going         
' to read these numbers as pixels      
' and then draw them to the            
' screen.                    ͼ
'                                  

DATA 00,00,14,14,14,14,14,14,00,00  
DATA 00,14,00,00,00,00,00,00,14,00 
DATA 14,00,00,00,00,00,00,00,00,14 
DATA 14,00,00,14,00,00,14,00,00,14  
DATA 14,00,00,14,00,00,14,00,00,14  
DATA 14,00,00,00,00,00,00,00,00,14  
DATA 14,00,14,00,00,00,00,14,00,14  
DATA 14,00,00,14,14,14,14,00,00,14
DATA 00,14,00,00,00,00,00,00,14,00
DATA 00,00,14,14,14,14,14,14,00,00


XLength = 10        ' These are variables which tell us what
YLength = 10        ' the length and the width of the picture
                    ' are.
                     
FOR Y = 1 TO YLength
   FOR X = 1 TO XLength
      READ PixelColour
      PSET (X, Y), PixelColour
   NEXT X
NEXT Y

' The above code looks quite tricky, but is actually very BASIC
' (get it?).  FOR...NEXT loops are used to go through loops a
' certain amount of times (specified by you).  After the FOR you must
' give a variable then an equals sign then the first number then
' TO then the second number.  The loop will start at the first number
' and finish at the second.
'
' E.G
' FOR counter = 1 TO 10
'    PRINT counter
' NEXT counter
'
' That will PRINT 1 - 10 down the screen when you run it.
' Are you starting to understand LOOPs? Good, lets move on...
'
' There are 2 FOR...NEXT loops above, that means the first one
' won't go up one until the the one in the middle has gone from
' 1 TO 10.

' READ Pixel means that QBasic is going to READ the first peice
' of DATA you typed which is 00 into the variable called Pixel.
' When it goes through the loop again it will READ 00 again,
' then 14, then 14.... and so on. Once it finishes going through
' the loop 10 times it will start on the next row.
'
'       2nd time
'         ||
'         
' DATA 00,00,14,14,14,14,14,14,00,00   ' This is the 1st line of DATA
'                                    ' statements.
'      ||
'   1st time
'

DO: LOOP UNTIL INKEY$ <> ""


'        ͸
'        METHOD Number 3
'        ;

LOCATE 12, 12
PRINT "                 "      ' Just to clear anything that is there.
LOCATE 12, 12
PRINT "Now BSAVing..."

DIM HAPPYFACE(51)        ' We must first DIM an array to store our
                         ' DATA in.  We are making a picture
                         ' the size of 10 * 10, so... to get the
                         ' amount of bytes we are going to need
                         ' we use the below formula:

                         ' (Width * Height) \ 2 + 1

                         ' For our HappyFace array we do:
                        
                         ' (10 * 10) = 100
                         ' 100 \ 2 = 50
                         ' 50 + 1 = 51 <----  Our answer!!!

LOCATE 14, 15
INPUT "SAVE AS"; FileName$
'                    
'                    
' This will ask you for a name to save the
' picture as.  Type what ever you wan't but
' delete the file after you have saved it.


GET (1, 1)-(10, 10), HAPPYFACE  ' This GET command is a lot like
                                ' the LINE one, it works the same
                                ' with the co-ordinates and
                                ' everything.
                                '
                                ' QBasic is going to GET all the
                                ' data from the position 0, 0 to 9, 9.
                                ' The HAPPYFACE bit is the array
                                ' that we DIMed before.  All the
                                ' info from the GET command is
                                ' going to be put into this array\
                                ' peice of memory that we called
                                ' HAPPYFACE.

                                ' We get the picture from the last
                                ' method we used to draw the happy
                                ' face. 

CLS ' Clear the screen so its ready to draw and so you don't
    ' think I'm cheating!

'DEF = Default   
'    SEG = Segment          
'   
DEF SEG = VARSEG(HAPPYFACE(0))
'         
'         
'    VARSEG(HAPPYFACE(0)) = A part of the computer that is holding
'                           all the memory that QBasic is using
'                           (where we put our array).
'
'   So.......      
'
'       Default Segment = Memory where we stored the array
'
'
'     This will create a new file called what ever you typed in
'         when QBasic asked you SAVE AS?
'    
'                   
BSAVE FileName$, VARPTR(HAPPYFACE(0)), 150
DEF SEG      '    
             '     This opens the file that you created and puts
             '        all the info into the file.  The bit at the end
             '        (the 100 bit) will tell QBasic that, that is
             '        how big the file is.  We get this number by:
             
'        Vertical Number of Pixels * Horizontal Number of Pixels + 50
'        Which for us is:
'        10 * 10 + 50 and that equals 100!!!!! (aren't I good!)

' The DEF SEG thing on the next line means that it will reset
' the Default Segment back to the default Default Segment.  :)


' Now we are going to load our picture using BLOAD.
'
' Instead of puting the data from the array into a file using BSAVE we
' are going to get the data from the file that you saved the HappyFace
' to before.  QBasic inputs all the data from the file into the array
' you want.

' It goes a little like this...


'     Remember that we must DIM an array to store the data from        
'         the file into.
DIM LoadedPicture(51)


LOCATE 12, 12
PRINT "Now BLOADing..."
LOCATE 14, 12
PRINT "                      "  ' This will get rid of the SAVE AS? text.
DO: LOOP UNTIL INKEY$ <> ""


DEF SEG = VARSEG(LoadedPicture(0))   ' All of this is exactly the same as
                                     ' the BSAVE bit

BLOAD FileName$, VARPTR(LoadedPicture(0))
' Instead of putting data to a file, this time we are going to
' read the data from the file.

DEF SEG   ' Resets the Default Segment back to the
          ' default Default Segment.  :)

PUT (1, 1), LoadedPicture  ' PUT is like GET.  GET gets and PUT puts,
'                          the co-ords in the brackets is where the
'                          array is going to be put (you can't just
'      The vertical      put any old array there though, it has
'         No of pixels.     to be a graphic array either loaded into
'                           QBasic, like where doing or with the GET
' The horizontal             command).  The top left hand corner
' no of pixels               pixel of the picture will be PUT where
' across the screen.         the numbers say.
                         
DO: LOOP UNTIL INKEY$ <> ""

CLS
LOCATE 11, 12
PRINT "Remember, this is"
LOCATE 12, 12
PRINT "a tutorial by Nic."

DO: LOOP UNTIL INKEY$ <> ""


' Well, I am obviously at the end of the tutorial now.  I hope all
' you QBasic fanatics out there will enjoy and learn from this
' tutorial, if not then never mind.

' If you like it, or don't then E-mail me and tell me that at:
'                       nicfouhy@hotmail.com

' VISIT MY WEBSITE!!!!!!!!!!!!  AT: http://www.qbworld.8k.com/

