'===========================================================================
' Subject: OPEN BMP VERSION 0.4              Date: 04-23-99 (18:32)       
'  Author: Yousuf Philips                    Code: QB, QBasic, PDS        
'  Origin: philipz@emirates.net.ae         Packet: GRAPHICS.ABC
'===========================================================================
''''''''''''''''''''''''''''''''''''''''
' Program    : Loads BMP Files         '
' Name       : OPENBMP Version 0.4     '
' Programmer : Yousuf Philips          '
' Company    : Y P I                   '
' Updated On : 29th of Dec. 1998       '
' Email - [philipz85@hotmail.com]      '
' [http://members.xoom.com/Philipz/]   '
''''''''''''''''''''''''''''''''''''''''

'/*               Do not edit this file if you distribute it.              */'
'/*  (c) Copyrighted by YPI in 1998 | All Rights Reserved | Public Domain  */'

'/* This program has been created by YPI (Basic Programming Incorporation) */'
'/* as a utility to load BMP files.                                        */'
'/*                                                                        */'
'/* What's New -                                                           */'
'/*            * 24-BIT loading is in color                                */'
'/*            * 8-BIT loading was increased                               */'
'/*            * 4-BIT loading was increased                               */'

'/* If you use any of this code in your program then you must credit YPI.  */'

DECLARE SUB BMPInfo (FileName$)
DECLARE SUB SHOWBMP (FileName$)
DECLARE SUB ChangePalette (Alg%)
DECLARE SUB Open24 (ImageWidth%, ImageHeight%, OffsetOfBitMap%)

COMMON SHARED X AS INTEGER, Y AS INTEGER

CLS
PRINT
PRINT " Fast BMP Loader for QBASIC - OPENBMP ver 0.4"
PRINT " (c) YPI (BASIC Programming Incorporation) 1998"
'FILES "*.bmp"
INPUT " Enter File Name - ", FileName$

IF LEN(LTRIM$(FileName$)) = 0 THEN
   END
ELSEIF LCASE$(RIGHT$(FileName$, 4)) <> ".bmp" THEN
   FileName$ = FileName$ + ".bmp"
END IF

CALL BMPInfo(FileName$)
Wait$ = INPUT$(1)
CALL SHOWBMP(FileName$)
CLOSE
Wait$ = INPUT$(1)

DEFINT A-Z
SUB BMPInfo (FileName$)

'/* Opens the specified File Name */'
OPEN FileName$ FOR BINARY AS #1
'/* If the file name specified is empty then a line of text is printed, */'
'/* the file is then deleted and the program ends */'
IF LOF(1) = 0 THEN
   PRINT " FILE IS EMPTY"
   CLOSE #1
   KILL FileName$
   END
END IF

CLS
'/* Extracts the first 2 bytes of the file */'
ValidBMP$ = SPACE$(2)
GET #1, 1, ValidBMP$: PRINT
IF ValidBMP$ = "BM" THEN
   PRINT " Valid BMP FILE"
ELSE
   PRINT " InValid BMP FILE"
END IF

'/* Extracts the Size of the file without the header */'
SizeOfFile$ = SPACE$(4)
GET #1, 3, SizeOfFile$
PRINT " Size of the file -"; CVL(SizeOfFile$); " or "; LOF(1)

'/* Extracts the offset of the picture data in the file */'
LocationOfPictureData$ = SPACE$(4)
GET #1, 11, LocationOfPictureData$
PRINT " Location in file of Picture Data    -"; CVL(LocationOfPictureData$)

'/* Extracts the BMP type (Win or OS/2) */'
BMPType$ = SPACE$(4)
GET #1, 15, BMPType$
PRINT : PRINT " BMP Type       - ";
IF CVL(BMPType$) = 12 THEN
   PRINT "OS/2"
   PRINT " Size Of Header - 12"
ELSEIF CVL(BMPType$) = 40 THEN
   PRINT "Windows"
   PRINT " Size Of Header - 40"
ELSE
   PRINT "Unknown Type"
END IF

'/* Extracts the Width and Height in Pixels of the Image */'
'/* and also the number of bits per pixel (bpp) */'
PixelWidth$ = SPACE$(4): PixelHeight$ = SPACE$(4)
BitsPerPixel$ = SPACE$(2): NoPlanes$ = SPACE$(2): Compress$ = SPACE$(4)
GET #1, 19, PixelWidth$
GET #1, 23, PixelHeight$
GET #1, 27, NoPlanes$
GET #1, 29, BitsPerPixel$
GET #1, 31, Compress$
PRINT
PRINT " Width of Image in Pixels           -"; CVL(PixelWidth$)
PRINT " Height of Image in Pixels          -"; CVL(PixelHeight$)
PRINT " Number of Planes                   -"; CVI(NoPlanes$)
PRINT " Number of Bits Per Pixel (bpp)     -"; CVI(BitsPerPixel$)
PRINT " Number of Colors Used in the Image -"; 2# ^ CVI(BitsPerPixel$)
IF CVL(Compress$) = 0 THEN
   PRINT " No Compression"
ELSEIF CVL(Compress$) = 1 THEN
   PRINT " RLE - 8-Bit Compression"
ELSEIF CVL(Compress$) = 2 THEN
   PRINT " RLE - 4-Bit Compression"
END IF
CLOSE

END SUB

SUB ChangePalette (Alg)

IF Alg = 1 THEN
   '/* An excellent color palette from PALSTUFF.BAS [Graphics.abc|09/1995] */'
   '/* Created by Steve Demo                                               */'
   Change$ = "#####M#M##MMM##M#MM8#MMM88888b8b88bbb88b8bbb8bbb+++"
   Change$ = Change$ + "...222555999===@@@DDDHHHKKKOOOSSSVVVZZZ^^^bbb3##8##"
   Change$ = Change$ + "=##?&&B**E--H11K55N88Q<<T@@XDDZII]NN_SSbYY3+#8-#=/#"
   Change$ = Change$ + "B2#G4#L6#Q9#V;#\>#\B*]F2^K:_OA`TIaXQb]Y33#66#99#<<#"
   Change$ = Change$ + "??#BB#EE#HH#LL#OO#RR#UU#XX#[[#^^#bb##8%#:(#<,#?/#A3"
   Change$ = Change$ + "#C7#F:#H>#KB#ME#OI#RM#TP#WT#YX#\\YbYRbQJbJG^GDZDAWA"
   Change$ = Change$ + ">S>;O;8L85H52E2/A/,=,):)&6&$3#YbbQbbJbbE__A\\=ZZ:VV"
   Change$ = Change$ + "7RR5NN2JJ0FF-BB*>>(::%66#33Y^bQ[bJXbBUb:Rb3Ob+Mb#Jb"
   Change$ = Change$ + "#F\#BV#>P#:J#6D#3?#/9#,3YYbQRbJJbEE_@@\<<Y88V55R33N"
   Change$ = Change$ + "11J..F,,B**>'':%%6##3/@$2B#5D#8F#;H#>J#AL#DN#GP#JR#"
   Change$ = Change$ + "MT#PV#SX#VZ#Y\#]_#bYb`S`^N^\H\ZCZX=XV8VT3UP0QL.MH+I"
   Change$ = Change$ + "D(EA&A<%<7$73#3-+&1-'5/):2+;3+=4,?5-@6-B7.D8/E9/G:0"
   Change$ = Change$ + "I;1J<1L=2N>3O?3Q@4SA5UB6VD8WF;XH>YJAZMD[OG\QJ]SM^VP"
   Change$ = Change$ + "_XS`ZVb]ZZ##X)#W0#U6#T;#S@#RF#PJ#ON#CN#6M#*M##L(#K3"
   Change$ = Change$ + "#K?#KH#FL#>M#5M#-N6#Q>#QD#QL#QQ#NQ#FQ#@Q#9Q#1R#+R##"
   Change$ = Change$ + "bbb"
   FOR Loops = 0 TO 255
      OUT &H3C8, Loops
      OUT &H3C9, ASC(MID$(Change$, Loops * 3 + 1, 1)) - 35
      OUT &H3C9, ASC(MID$(Change$, Loops * 3 + 2, 1)) - 35
      OUT &H3C9, ASC(MID$(Change$, Loops * 3 + 3, 1)) - 35
   NEXT Loops
   Change$ = ""
ELSE
   '/* Randomized color palette */'
   FOR Loops = 1 TO 255
      Blue = INT(RND * 256) \ 4
      Green = INT(RND * 256) \ 4
      Red = INT(RND * 256) \ 4
      OUT &H3C8, Loops
      OUT &H3C9, Red
      OUT &H3C9, Green
      OUT &H3C9, Blue
   NEXT Loops
END IF

END SUB

SUB Open24 (ImageWidth, ImageHeight, OffsetOfBitMap)

DIM ColorPalette(255, 3)
DIM PixelArray(2000, 3)
ColorDif = 3

SCREEN 13
'/* Sub which changes the palette */'
'/* Valid values - 1 - Color Palette created by Steve Demo                 */'
'/*                0 - Random Color Palette                                */'
'/* If you want to use your own color palette edit the function, and if you*/'
'/* think you palette works well with the program send it to us.           */'
CALL ChangePalette(1)

'/* Capture the current color palette into an array                        */'
FOR Loops = 0 TO 255
   OUT &H3C7, Loops
   ColorPalette(Loops, 1) = INP(&H3C9)
   ColorPalette(Loops, 2) = INP(&H3C9)
   ColorPalette(Loops, 3) = INP(&H3C9)
NEXT Loops

'/* Calculate the number of bytes per line for the current image           */'
LineExtract$ = SPACE$(ImageWidth * 3)
IF (4 - ((ImageWidth * 3) MOD 4)) <> 4 THEN
   LineExtract$ = LineExtract$ + SPACE$(4 - ((ImageWidth * 3) MOD 4))
END IF
LineExtract& = LEN(LineExtract$)

IF OffsetOfBitMap = 0 THEN OffsetOfBitMap = 55

'/* Resize image to fit the Screen                                         */'
ActualHeight! = 199 / (ImageHeight - 1)
ActualWidth! = 319 / (ImageWidth - 1)
IF ActualHeight! > 1 THEN ActualHeight! = 1
IF ActualWidth! > 1 THEN ActualWidth! = 1
ActualHeight1! = (ImageHeight - 1) / 199
ActualWidth1! = (ImageWidth - 1) / 319
IF ActualHeight1! < 1 THEN ActualHeight1! = 1
IF ActualWidth1! < 1 THEN ActualWidth1! = 1
'WHILE INKEY$ <> "": WEND

FOR YHeight = ImageHeight - 1 TO 0 STEP -ActualHeight1!
   '/* Extract only the image lines which will be shown                    */'
   GET #1, OffsetOfBitMap + ((ImageHeight - YHeight - 1) * LineExtract&) + 1, LineExtract$
   FOR XWidth = 0 TO ImageWidth - 1 STEP ActualWidth1!
       XWidthPosition = XWidth * 3
       '/* Extract the RGB of each pixel                                   */'
       PixelBlue = ASC(MID$(LineExtract$, XWidthPosition + 1, 1)) \ 4
       PixelGreen = ASC(MID$(LineExtract$, XWidthPosition + 2, 1)) \ 4
       PixelRed = ASC(MID$(LineExtract$, XWidthPosition + 3, 1)) \ 4
       PixelPut = 0: Movement = ColorDif + 1
       '/* Check if the RGB or an RGB close to it are in the color array   */'
       FOR PixelArraySearch = 1 TO ArrayNo
          IF PixelBlue >= PixelArray(PixelArraySearch, 1) - ColorDif AND PixelBlue <= PixelArray(PixelArraySearch, 1) + ColorDif THEN
             IF PixelGreen >= PixelArray(PixelArraySearch, 2) - ColorDif AND PixelGreen <= PixelArray(PixelArraySearch, 2) + ColorDif THEN
                IF PixelRed >= PixelArray(PixelArraySearch, 3) - ColorDif AND PixelRed <= PixelArray(PixelArraySearch, 3) + ColorDif THEN
                   PSET (XWidth * ActualWidth!, YHeight * ActualHeight!), PixelArray(PixelArraySearch, 0)
                   PixelPut = 1
                   EXIT FOR
                END IF
             END IF
          END IF
       NEXT PixelArraySearch
       IF PixelPut = 0 THEN
          '/* Algorithm to find the closest color in the color palette */'
          DO
             FOR Loops = 0 TO 255
                IF PixelBlue >= (ColorPalette(Loops, 3) - Movement) AND PixelBlue <= (ColorPalette(Loops, 3) + Movement) THEN
                   IF PixelGreen >= (ColorPalette(Loops, 2) - Movement) AND PixelGreen <= (ColorPalette(Loops, 2) + Movement) THEN
                      IF PixelRed >= (ColorPalette(Loops, 1) - Movement) AND PixelRed <= (ColorPalette(Loops, 1) + Movement) THEN
                         IF ColorPalette(Loops, 1) = ColorPalette(Loops, 2) AND ColorPalette(Loops, 2) = ColorPalette(Loops, 3) AND Movement > 3 THEN
                            IF PixelBlue = PixelGreen AND PixelBlue = PixelRed THEN
                               PSET (XWidth * ActualWidth!, YHeight * ActualHeight!), Loops
                               IF ArrayNo < 2000 THEN
                                  ArrayNo = ArrayNo + 1
                                  PixelArray(ArrayNo, 1) = PixelBlue
                                  PixelArray(ArrayNo, 2) = PixelGreen
                                  PixelArray(ArrayNo, 3) = PixelRed
                                  PixelArray(ArrayNo, 0) = Loops
                               END IF
                               EXIT DO
                            END IF
                         ELSE
                            PSET (XWidth * ActualWidth!, YHeight * ActualHeight!), Loops
                            IF ArrayNo < 2000 THEN
                            ArrayNo = ArrayNo + 1
                               PixelArray(ArrayNo, 1) = PixelBlue
                               PixelArray(ArrayNo, 2) = PixelGreen
                               PixelArray(ArrayNo, 3) = PixelRed
                               PixelArray(ArrayNo, 0) = Loops
                            END IF
                            EXIT DO
                         END IF
                      END IF
                   END IF
                END IF
             NEXT Loops
             Movement = Movement + 1
          LOOP
       END IF
   NEXT XWidth
NEXT YHeight
CLOSE

END SUB

DEFSNG A-Z
SUB SHOWBMP (FileName$)

OPEN FileName$ FOR BINARY AS #1
IF LOF(1) = 0 THEN
   PRINT " FILE IS EMPTY"
   CLOSE #255
   KILL FileName$
   EXIT SUB
END IF

'/* Extracts the first 2 bytes of the file */'
ValidBMP$ = SPACE$(2)
GET #1, 1, ValidBMP$
'/* If the first 2 bytes of the file are not BM then a line of text is printed, */'
'/* and the program ends */'
IF ValidBMP$ <> "BM" THEN
   PRINT " THE FILE SPECIFIED IS NOT A VALID BMP"
   EXIT SUB
END IF

'/* Extracts the offset of the picture data in the file */'
LocationOfPictureData$ = SPACE$(4)
GET #1, 11, LocationOfPictureData$
LocationOfPictureData = CVL(LocationOfPictureData$)

'/* Extracts the BMP type (Win or OS/2) */'
BMPType$ = SPACE$(4)
GET #1, 15, BMPType$
'/* If the BMPType is for OS/2 then the a line of text is printed, then */'
'/* program ends */'
IF CVL(BMPType$) = 12 OR CVL(BMPType$) = 64 THEN
   PRINT " THIS BMP IS FOR THE OS/2 AND CAN'T BE OPENED IN THIS VERSION OF OPENBMP"
   PRINT " PLEASE SEND ANY OS/2 BMP TO phililpz85@hotmail.com"
   PRINT " BY SENDING OS/2 BMP's TO US, WE WILL HOPEFULLY BE ABLE TO OPEN THEM IN THE"
   PRINT " NEXT VERSION OF OPENBMP"
   EXIT SUB
END IF

'/* Extracts the Width and Height in Pixels of the Image */'
'/* and also the number of bits per pixel (bpp) */'
PixelWidth$ = SPACE$(4)
PixelHeight$ = SPACE$(4)
BitsPerPixel$ = SPACE$(2)
Compression$ = SPACE$(4)
GET #1, 19, PixelWidth$
GET #1, 23, PixelHeight$
GET #1, 29, BitsPerPixel$
GET #1, 31, Compression$
PixelWidth = CVL(PixelWidth$)
PixelHeight = CVL(PixelHeight$)
BitsPerPixel = CVI(BitsPerPixel$)
NumberOfColors = 2 ^ BitsPerPixel

'/* Changing to suitable screen modes to display the Image */'
IF BitsPerPixel = 1 THEN
   IF PixelWidth > 640 OR PixelHeight > 480 THEN
      PRINT " 1-BIT IMAGE IS TO LARGE"
      EXIT SUB
   END IF
   SCREEN 11
ELSEIF BitsPerPixel = 4 THEN
   SCREEN 12
ELSEIF BitsPerPixel = 8 THEN
   SCREEN 13
ELSEIF BitsPerPixel = 16 OR BitsPerPixel = 32 THEN
   PRINT " Error 16-BIT and 32-BIT BMPs cannot be loaded"
   CLOSE #1
   EXIT SUB
END IF

'/* If image is not 24-bit then load palette information from file */'
IF BitsPerPixel <> 24 THEN
   '/* Extracts Palette information for the colors used in the image */'
   PaletteColors$ = SPACE$(NumberOfColors * 4)
   GET #1, 55, PaletteColors$

   FOR Loops = 0 TO NumberOfColors - 1
   '/* Changes the Palette of each color to the one specified in the file */'
      IF BitsPerPixel = 1 AND Loops = 1 THEN Loops = 15
      OUT &H3C8, Loops
      IF BitsPerPixel = 1 AND Loops = 15 THEN Loops = 1
      OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 3, 1)) \ 4 'Red
      OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 2, 1)) \ 4 'Green
      OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 1, 1)) \ 4 'Blue
   NEXT Loops

   '/* Finds correct location of Picture data */'
   IF LocationOfPictureData = 0 THEN
      LocationOfPictureData = LOC(255) + 1
   ELSE
      LocationOfPictureData = LocationOfPictureData + 1
   END IF
END IF

IF CVL(Compression$) = 1 THEN
   PixelColors$ = SPACE$(1): NoOfSameColors$ = SPACE$(1)
   RightMovement$ = SPACE$(1):  UpMovement$ = SPACE$(1)
   ActualWidth = PixelWidth / 320: ActualHeight = PixelHeight / 200
   IF ActualWidth < 1 THEN ActualWidth = 1
   IF ActualHeight < 1 THEN ActualHeight = 1
   X = 0: Y = PixelHeight - 1
   DO
      GET #1, , NoOfSameColors$
      IF ASC(NoOfSameColors$) <> 0 THEN
         GET #1, , PixelColors$
         IF X + ASC(NoOfSameColors$) = PixelWidth THEN NoOfSameColors$ = CHR$(ASC(NoOfSameColors$) - 1)
         LINE (X / ActualWidth, Y / ActualHeight)-STEP(ASC(NoOfSameColors$) / ActualWidth, 0), ASC(PixelColors$)
         X = X + ASC(NoOfSameColors$)
      ELSE
         GET #1, , PixelColors$
         IF ASC(PixelColors$) = 0 THEN
            X = 0: Y = Y - 1
            IF Y < 0 THEN EXIT SUB
            '/* Used to skip the unnecessary lines in large pictures
            WHILE Y MOD ActualHeight <> 0
               DO
                  GET #1, , NoOfSameColors$
                  IF ASC(NoOfSameColors$) <> 0 THEN
                     GET #1, , PixelColors$
                  ELSE
                     GET #1, , PixelColors$
                     IF ASC(PixelColors$) = 0 THEN
                        EXIT DO
                     ELSEIF ASC(PixelColors$) = 1 THEN
                        EXIT SUB
                     ELSEIF ASC(PixelColors$) = 2 THEN
                        Bytez$ = SPACE$(2)
                        GET #1, , Bytez$
                        EXIT DO
                     ELSE
                        Bytez$ = SPACE$(ASC(PixelColors$))
                        IF ASC(PixelColors$) MOD 2 = 1 THEN Bytez$ = Bytez$ + " "
                        GET #1, , Bytez$
                     END IF
                  END IF
               LOOP
               Y = Y - 1
            WEND
         ELSEIF ASC(PixelColors$) = 1 THEN
            EXIT DO
         ELSEIF ASC(PixelColors$) = 2 THEN
            GET #1, , RightMovement$
            GET #1, , UpMovement$
            X = X + ASC(RightMovement$): Y = Y + ASC(UpMovement$)
         ELSE
            PixelColor$ = SPACE$(1)
            FOR Loops = 1 TO ASC(PixelColors$)
               GET #1, , PixelColor$
               PSET (X / ActualWidth, Y / ActualHeight), ASC(PixelColor$)
               X = X + 1
            NEXT Loops
            IF ASC(PixelColors$) MOD 2 = 1 THEN GET #1, , PixelColor$
         END IF
      END IF
   LOOP
   EXIT SUB
ELSEIF CVL(Compression$) = 2 THEN
   PixelColors$ = SPACE$(1): NoOfSameColors$ = SPACE$(1)
   RightMovement$ = SPACE$(1):  UpMovement$ = SPACE$(1)
   ActualWidth = PixelWidth / 640: ActualHeight = PixelHeight / 480
   IF ActualWidth < 1 THEN ActualWidth = 1
   IF ActualHeight < 1 THEN ActualHeight = 1
   X = 0: Y = PixelHeight - 1
   DO
      GET #1, , NoOfSameColors$
      IF ASC(NoOfSameColors$) <> 0 THEN
         GET #1, , PixelColors$
          FOR Loops = 0 TO ASC(NoOfSameColors$) - 1 STEP 2
             PSET (X / ActualWidth, Y / ActualHeight), ASC(PixelColors$) \ 16
             X = X + 1
             IF Loops + 1 <> ASC(NoOfSameColors$) THEN
                PSET (X / ActualWidth, Y / ActualHeight), ASC(PixelColors$) AND 15
                X = X + 1
             END IF
          NEXT Loops
      ELSE
         GET #1, , PixelColors$
         IF ASC(PixelColors$) = 0 THEN
            X = 0: Y = Y - 1
            IF Y < 0 THEN EXIT SUB
            '/* Used to skip the unnecessary lines in large pictures
            WHILE Y MOD ActualHeight <> 0
               DO
                  GET #1, , NoOfSameColors$
                  IF ASC(NoOfSameColors$) <> 0 THEN
                     GET #1, , PixelColors$
                  ELSE
                     GET #1, , PixelColors$
                     IF ASC(PixelColors$) = 0 THEN
                        EXIT DO
                     ELSEIF ASC(PixelColors$) = 1 THEN
                        EXIT SUB
                     ELSEIF ASC(PixelColors$) = 2 THEN
                        Bytez$ = SPACE$(2)
                        GET #1, , Bytez$
                        EXIT DO
                     ELSE
                        PixelColors = ASC(PixelColors$)
                        IF PixelColors MOD 2 = 1 THEN
                           PixelColors = PixelColors + 1
                        END IF
                        PixelColors = PixelColors / 2
                        IF PixelColors MOD 2 = 1 THEN
                           PixelColors = PixelColors + 1
                        END IF
                        Bytez$ = SPACE$(PixelColors)
                        GET #1, , Bytez$
                     END IF
                 END IF
               LOOP
               Y = Y - 1
            WEND
         ELSEIF ASC(PixelColors$) = 1 THEN
            EXIT DO
         ELSEIF ASC(PixelColors$) = 2 THEN
            GET #1, , RightMovement$
            GET #1, , UpMovement$
            X = X + ASC(RightMovement$): Y = Y + ASC(UpMovement$)
         ELSE
            PixelColor$ = SPACE$(1): PixelColors = ASC(PixelColors$)
            FOR Loops = 0 TO PixelColors - 1
               IF Loops MOD 2 = 0 THEN
                  GET #1, , PixelColor$
                  PSET (X / ActualWidth, Y / ActualHeight), ASC(PixelColor$) \ 16
                  X = X + 1
               END IF
               IF Loops MOD 2 = 1 THEN
                  PSET (X / ActualWidth, Y / ActualHeight), ASC(PixelColor$) AND 15
                  X = X + 1
               END IF
            NEXT Loops
            IF PixelColors MOD 2 = 1 THEN
               PixelColors = PixelColors + 1
            END IF
            NoOfBytes = PixelColors / 2
            IF (NoOfBytes MOD 2) = 1 THEN
               GET #1, , PixelColor$
            END IF
         END IF
      END IF
   LOOP
   EXIT SUB
END IF

IF BitsPerPixel = 24 THEN
   '/* 24-bit BMP loading algorithm taken from 24BITBMP.BAS (YPI) */'
   CALL Open24(INT(PixelWidth), INT(PixelHeight), INT(LocationOfPictureData))
   EXIT SUB
ELSEIF BitsPerPixel = 8 THEN
   LineExtract$ = SPACE$(PixelWidth)
   IF (4 - (PixelWidth MOD 4)) <> 4 THEN
      LineExtract$ = LineExtract$ + SPACE$(4 - (PixelWidth MOD 4))
   END IF
   LineExtract& = LEN(LineExtract$)
   ActualHeight! = 199 / (PixelHeight - 1)
   ActualWidth! = 319 / (PixelWidth - 1)
   IF ActualHeight! > 1 THEN ActualHeight! = 1
   IF ActualWidth! > 1 THEN ActualWidth! = 1
   ActualHeight1! = (PixelHeight - 1) / 199
   ActualWidth1! = (PixelWidth - 1) / 319
   IF ActualHeight1! < 1 THEN ActualHeight1! = 1
   IF ActualWidth1! < 1 THEN ActualWidth1! = 1
   IF ActualHeight! = 1 AND ActualWidth! = 1 THEN
      SEEK #1, LocationOfPictureData
      FOR Y = PixelHeight - 1 TO 0 STEP -1
         GET #1, , LineExtract$
         FOR X = 0 TO PixelWidth - 1
            PSET (X, Y), ASC(MID$(LineExtract$, X + 1, 1))
         NEXT X
      NEXT Y
   ELSE
      FOR Y = 0 TO PixelHeight - 1 STEP ActualHeight1!
         GET #1, LocationOfPictureData + ((PixelHeight - Y - 1) * LineExtract&), LineExtract$
         FOR X = 0 TO PixelWidth - 1 STEP ActualWidth1!
            PSET (X * ActualWidth!, Y * ActualHeight!), ASC(MID$(LineExtract$, X + 1, 1))
         NEXT X
      NEXT Y
   END IF
ELSEIF BitsPerPixel = 4 THEN
   LineExtract$ = SPACE$(PixelWidth \ 2)
   IF (4 - ((PixelWidth MOD 8) / 2)) <> 4 THEN
      LineExtract$ = LineExtract$ + SPACE$((4 - ((PixelWidth MOD 8) / 2)))
   END IF
   LineExtract& = LEN(LineExtract$)
   ActualHeight! = 479 / (PixelHeight - 1)
   ActualWidth! = 639 / (PixelWidth - 1)
   IF ActualHeight! > 1 THEN ActualHeight! = 1
   IF ActualWidth! > 1 THEN ActualWidth! = 1
   ActualHeight1! = (PixelHeight - 1) / 479
   ActualWidth1! = (PixelWidth - 1) / 639
   IF ActualHeight1! < 1 THEN ActualHeight1! = 1
   IF ActualWidth1! < 1 THEN ActualWidth1! = 1
   IF ActualWidth! = 1 AND ActualHeight! = 1 THEN
      SEEK #1, LocationOfPictureData
      FOR Y = PixelHeight - 1 TO 0 STEP -1
         GET #1, , LineExtract$
         FOR X = 0 TO (PixelWidth / 2) - 1
            PixelColor = ASC(MID$(LineExtract$, X + 1, 1))
            PSET (X * 2, Y), PixelColor \ 16
            IF (X * 2) + 1 < PixelWidth THEN
               PSET ((X * 2) + 1, Y), PixelColor AND 15
            END IF
         NEXT X
      NEXT Y
   ELSE
      FOR Y = 0 TO PixelHeight - 1 STEP ActualHeight1!
         GET #1, LocationOfPictureData + ((PixelHeight - 1 - Y) * LineExtract&), LineExtract$
         FOR X = 0 TO (PixelWidth / 2) - 1 STEP ActualWidth1!
            PixelColor = ASC(MID$(LineExtract$, X + 1, 1))
            PSET (X * ActualWidth! * 2, Y * ActualHeight!), PixelColor \ 16
            IF (X * 2) + 1 < PixelWidth THEN
               PSET ((X * ActualWidth! * 2) + 1, Y * ActualHeight!), PixelColor AND 15
            END IF
         NEXT X
      NEXT Y
   END IF
ELSEIF BitsPerPixel = 1 THEN
   LineExtract$ = SPACE$(PixelWidth \ 8)
   IF (4 - ((PixelWidth MOD 32) / 8)) <> 4 THEN
      LineExtract$ = LineExtract$ + SPACE$((4 - ((PixelWidth MOD 32) / 8)))
   END IF
   LineExtract& = LEN(LineExtract$)
   FOR Y = 0 TO PixelHeight - 1
      DEF SEG = &HA000
      GET #1, LocationOfPictureData + ((PixelHeight - Y - 1) * LineExtract&), LineExtract$
      FOR X = 0 TO CINT(PixelWidth / 8) - 1
         IF Y < 409 THEN
            POKE (Y * 80 + X), ASC(MID$(LineExtract$, X + 1, 1))
         ELSE
            DEF SEG = &HA7D0
            POKE ((Y - 400) * 80 + X), ASC(MID$(LineExtract$, X + 1, 1))
         END IF
      NEXT X
   NEXT Y
   DEF SEG
END IF

END SUB
