'===========================================================================
' Subject: OPENPCX VERSION 0.3               Date: 11-01-98 (05:17)       
'  Author: Yousuf Philips                    Code: QB, QBasic, PDS        
'  Origin: philipz@emirates.net.ae         Packet: GRAPHICS.ABC
'===========================================================================
''''''''''''''''''''''''''''''''''''''
' Program    : Loads PCX Files       '
' Name       : OPENPCX Version 0.3   '
' Programmer : Yousuf Philips        '
' Company    : Y P I                 '
' Updated On : 15th of August 1998   '
' Email - [philipz85@hotmail.com]    '
' [http://members.xoom.com/Philipz/] '
''''''''''''''''''''''''''''''''''''''

'/*               Do not edit this file if you distribute it.              */'
'/*  (c) Copyrighted by YPI in 1998 | All Rights Reserved | Public Domain  */'

'/* This program has been created by YPI (Basic Programming Incorporation) */'
'/* as a utility to load PCX files. Steven Sensarns created a PCX loader   */'
'/* but didn't have any comments about how it worked and has no proper     */'
'/* programming structure. But the worst thing about it is that it only    */'
'/* loads 8-bit PCXs which are 320 X 200. This PCX loader is part of a     */'
'/* series of PCX loaders which have been created by YPI. The source code  */'
'/* for version 0.1 and 0.2 haven't been distributed and won't because this*/'
'/* version (0.3) is many times faster. But if you want it then, just ask. */'
'/* This PCX loader will load any 8-bit PCX.                               */'

'/* If you use any of this code in your program then you must credit YPI.  */'
'/* This program has been placed in Public Domain and All Rights Are       */'
'/* Reserved.                                                              */'

'/* YPI has also created a BMP loader and an FLI player. The source can be */'
'/* gotten from our website <http://members.xoom.com/Philipz/>             */'
'/* The YPI Website has programs for beginners, tutorials and utilities.   */'

DECLARE SUB PCXInfo (FileName$)
DECLARE SUB ShowPCX (FileName$)

DIM SHARED X, Y, BegX, BegY, EndX AS INTEGER

CLS
PRINT
PRINT " PCX Loader for QBASIC - By YPI BASIC Programming Incorporation"
FILES "*.pcx"
INPUT " Enter File Name - ", FileName$

IF LEN(LTRIM$(FileName$)) = 0 THEN
   END
ELSEIF INSTR(FileName$, ".") = 0 THEN
   FileName$ = FileName$ + ".pcx"
END IF

CALL PCXInfo(FileName$)
Wait$ = INPUT$(1)
CALL ShowPCX(FileName$)
Wait$ = INPUT$(1)

SUB PCXInfo (FileName$)

OPEN FileName$ FOR BINARY AS #255
IF LOF(255) = 0 THEN
   PRINT " FILE IS EMPTY"
   CLOSE #255
   KILL FileName$
   EXIT SUB
END IF
  
CLS
PRINT

'/* Extract PCX Validation information */'
ValidPCX1$ = SPACE$(1): ValidPCX2$ = SPACE$(1): Version$ = SPACE$(1)
GET #255, 1, ValidPCX1$
GET #255, 2, Version$
GET #255, 3, ValidPCX2$

'/* Checks if the file is a valid PCX */'
IF ASC(ValidPCX1$) <> 10 THEN
   PRINT " InValid PCX FILE"
ELSEIF ASC(ValidPCX2$) <> 1 THEN
   PRINT " PCX FILE Maybe Corrupted"
ELSE
   PRINT " VALID PCX FILE"
END IF

IF ASC(Version$) = 0 THEN
   PRINT " Version - 2.5 of PC PaintBrush"
ELSEIF ASC(Version$) = 2 THEN
   PRINT " Version - 2.8 with palette"
ELSEIF ASC(Version$) = 3 THEN
   PRINT " Version - 2.8 without palette"
ELSEIF ASC(Version$) = 4 THEN
   PRINT " PC PaintBrush for Windows"
ELSEIF ASC(Version$) = 5 THEN
   PRINT " Version - 3 or greater"
END IF

'/* Extract number of bits per pixel (bpp), Image Width and Height and */'
'/* Number of Planes */'
BitsPerPixel$ = SPACE$(1): WidthInPixels$ = SPACE$(2): HeightInPixels$ = SPACE$(2)
NoOfPlanes$ = SPACE$(1): ScreenSize$ = SPACE$(8): PaletteInfo$ = SPACE$(2)
GET #255, 4, BitsPerPixel$
GET #255, 5, ScreenSize$
GET #255, 13, WidthInPixels$
GET #255, 15, HeightInPixels$
GET #255, 66, NoOfPlanes$
GET #255, 69, PaletteInfo$

PRINT
PRINT " Number of Bits -"; ASC(BitsPerPixel$)
PRINT " Screen Size - ["; CVI(LEFT$(ScreenSize$, 2)); ","; CVI(MID$(ScreenSize$, 3, 2)); "]";
PRINT " - ["; CVI(MID$(ScreenSize$, 5, 2)); ","; CVI(RIGHT$(ScreenSize$, 2)); "]"
PRINT " Width -"; CVI(WidthInPixels$)
PRINT " Height -"; CVI(HeightInPixels$)

PRINT
PRINT " Number Of Planes -"; ASC(NoOfPlanes$)
PRINT " Palette Information - ";
IF CVI(PaletteInfo$) = 0 OR CVI(PaletteInfo$) = 1 THEN
   PRINT "Color or B&W Image"
ELSE
   PRINT "Gray Scale Image"
END IF
CLOSE

END SUB

SUB ShowPCX (FileName$)

OPEN FileName$ FOR BINARY AS #255
IF LOF(255) = 0 THEN
   PRINT " FILE IS EMPTY"
   CLOSE #255
   KILL FileName$
   EXIT SUB
END IF
   
'/* Extract PCX Validation information */'
ValidPCX1$ = SPACE$(1): ValidPCX2$ = SPACE$(1): Version$ = SPACE$(1)
GET #255, 1, ValidPCX1$
GET #255, 2, Version$
GET #255, 3, ValidPCX2$

'/* Checks if the file is a valid PCX */'
IF ASC(ValidPCX1$) <> 10 THEN
   PRINT " InValid PCX File"
   EXIT SUB
ELSEIF ASC(ValidPCX2$) <> 1 THEN
   PRINT " PCX File Maybe Corrupted"
   EXIT SUB
END IF

IF ASC(Version$) <> 5 THEN
   PRINT " OPENPCX only supports Version 5 of PCX Files "
   PRINT " PLEASE SEND A COPY OF THIS IMAGE TO philipz85@hotmail.com"
   PRINT " HOPEFULLY WE WILL OPEN IT IN THE NEXT VERSION"
   EXIT SUB
END IF

'/* Extract number of bits per pixel (bpp), Image Width and Height and */'
'/* Number of Planes */'
BitsPerPixel$ = SPACE$(1): WidthInPixels$ = SPACE$(2): HeightInPixels$ = SPACE$(2)
ScreenSize$ = SPACE$(8): BytesPerLine$ = SPACE$(2)
GET #255, 4, BitsPerPixel$
GET #255, 5, ScreenSize$
GET #255, 13, WidthInPixels$
GET #255, 15, HeightInPixels$
GET #255, 67, BytesPerLine$

'/* Only 8-bit PCX's can be opened in this version of OpenPCX */'
IF ASC(BitsPerPixel$) <> 8 THEN
   Wordz$ = "THIS VERSION OF OPENPCX ONLY SUPPORTS 8-BIT PCX's"
   LOCATE , (80 - LEN(Wordz$)) / 2: PRINT Wordz$
   EXIT SUB
END IF

'/* If the Encoded program didn't specify the Width and Height in Pixels */'
IF BytesPerLine$ = MKI$(0) THEN
   BytesPerLine$ = MKI$(CVI(MID$(ScreenSize$, 5, 2)) - CVI(LEFT$(ScreenSize$, 2)) + 1)
END IF
HeightInPixels$ = MKI$(CVI(RIGHT$(ScreenSize$, 2)) - CVI(MID$(ScreenSize$, 3, 2)) + 1)
WidthInPixels$ = BytesPerLine$

SCREEN 13

SEEK #255, LOF(255) - 767
PaletteRed$ = SPACE$(1): PaletteGreen$ = SPACE$(1): PaletteBlue$ = SPACE$(1)
FOR Loops = 0 TO 255
   GET #255, , PaletteRed$
   GET #255, , PaletteGreen$
   GET #255, , PaletteBlue$
   OUT &H3C8, Loops
   OUT &H3C9, ASC(PaletteRed$) \ 4
   OUT &H3C9, ASC(PaletteGreen$) \ 4
   OUT &H3C9, ASC(PaletteBlue$) \ 4
NEXT Loops

ActualWidth = CVI(WidthInPixels$) / 320
ActualHeight = CVI(HeightInPixels$) / 200
IF ActualWidth < 1 THEN ActualWidth = 1
IF ActualHeight < 1 THEN ActualHeight = 1

SEEK #255, 129
NumberOfLoops$ = SPACE$(1): PixelColor$ = SPACE$(1): X = 0: Y = 0
'/* If the image will fit properly on screen 13 */'
IF ActualWidth = 1 AND ActualHeight = 1 THEN
   DO
      GET #255, , NumberOfLoops$
      IF ASC(NumberOfLoops$) > 191 THEN
        '/* If the ascii of the byte extracted from the file has a value   */'
        '/* greater than 191 then the ascii of the byte - 192 gives the    */'
        '/* number of following pixels which have the color of the ascii of*/'
        '/* of the next byte extracted from the file                       */'
         GET #255, , PixelColor$
         LINE (X, Y)-STEP(ASC(NumberOfLoops$) - 192, 0), ASC(PixelColor$)
         X = X + ASC(NumberOfLoops$) - 192
      ELSE
        '/* If the ascii of the byte extracted from the file has a value   */'
        '/* less then 192 then the ascii is the color of the following pixel*/'
         PixelColor$ = NumberOfLoops$
         PSET (X, Y), ASC(NumberOfLoops$)
         X = X + 1
      END IF
      '/* When the variable X has the value which is equal to the Width of */'
      '/* image then it jumps to the beginning of the next line            */'
      IF X >= CVI(WidthInPixels$) THEN
         X = 0: Y = Y + 1
      END IF
   LOOP UNTIL Y >= CVI(HeightInPixels$) - 1
ELSE
   '/* The below is the same code as the above exept it resizes the image   */'
   '/* so that it fits the screen                                           */'
   DO
      GET #255, , NumberOfLoops$
      IF ASC(NumberOfLoops$) > 191 THEN
         GET #255, , PixelColor$
         BegX = X / ActualWidth: BegY = Y / ActualHeight
         EndX = (ASC(NumberOfLoops$) - 192) / ActualWidth
         LINE (BegX, BegY)-STEP(EndX, 0), ASC(PixelColor$)
         X = X + (ASC(NumberOfLoops$) - 192)
      ELSE
         PixelColor$ = NumberOfLoops$
         BegX = X / ActualWidth: BegY = Y / ActualHeight
         PSET (BegX, BegY), ASC(PixelColor$)
         X = X + 1
      END IF
      IF X >= CVI(WidthInPixels$) THEN
         X = 0: Y = Y + 1
      END IF
   LOOP UNTIL Y >= CVI(HeightInPixels$) - 1
END IF
CLOSE

END SUB
