''
'' scc.bas -- client for Simple Chat protocol
'' copyleft 2002 by v1ctor (av1ctor@yahoo.com.br)
''

'option explicit

defint a-z
'$include: '..\..\inc\dsock.bi'
'$include: 'schat.bi'


const SCC.OFFLINE%	= 0%
const SCC.ONLINE%	= 1%

const SCC.CONNECTING%= 2%
const SCC.CONNECTED% = 3%

const SCC.JOINING%	= 4%
const SCC.JOINED%	= 5%

const SCC.STATES%	= 6%

type TSC
	state			as integer
	nick			as string * 8 'SC.NICKLEN	
	hostSocket		as long
	ha				as sockaddrIn
	cmd				as integer
end type

type TUSER
	prv				as integer
	nxt				as integer
	state			as integer
	nick			as string * 8 'SC.NICKLEN	
end type

type TMSG
	prv				as integer
	nxt				as integer
	length			as integer
	msg				as string * 160 'SC.MAXLEN
end type


'' protos :::
declare function sccInit%		( )
declare sub 	 sccEnd			( )
declare sub 	 sccMain		( )
declare function sccReceive%	( )
declare function sccConnecting% ( )
declare function sccConnect% 	( text as string )
declare sub 	 sccDisconnect  ( )
declare sub 	 sccUIProcess 	( text as string )
declare function sccUI%			( )
declare sub 	 sccProcess		( )
declare function sccSend%		( )

declare sub 	 scUserInit 	( )
declare function scUserNew% 	( )
declare function scUserAdd% 	( nick as string )
declare sub 	 scUserFree 	( u as integer )
declare sub 	 scUserDel 		( u as integer )
declare function scUserByNick% 	( nick as string )

declare sub 	 scMsgInit 		( mLst as TLIST, mTB() as TMSG, imax as integer )
declare function scMsgNew% 		( mLst as TLIST, mTB() as TMSG )
declare sub 	 scMsgAdd 		( mLst as TLIST, mTB() as TMSG, m as integer, length as integer)
declare sub 	 scMsgFree 		( mLst as TLIST, mTB() as TMSG, m as integer )
declare sub 	 scMsgDelTail 	( mLst as TLIST, mTB() as TMSG )
declare sub 	 scMsgDelHead 	( mLst as TLIST, mTB() as TMSG )

declare sub 	 sccTokenize 	( text as string, tokenc as integer, tokenv() as string, tokenp() as integer, maxc as integer )

'' globals :::
dim shared ctx as TSC

dim shared scUserLst as TLIST, scUserTB(0 to SC.MAXUSERS-1) as TUSER
dim shared scIMsgLst as TLIST, scIMsgTB(0 to SC.MAXMSGS-1) as TMSG
dim shared scOMsgLst as TLIST, scOMsgTB(0 to SC.MAXMSGS-1) as TMSG

dim shared sttTB ( 0 to SCC.STATES-1) as string

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	
	sttTB(SCC.OFFLINE) = "OFFLINE"
	sttTB(SCC.ONLINE) = "ONLINE"
	sttTB(SCC.CONNECTING) = "CONNECTING"
	sttTB(SCC.CONNECTED) = "CONNECTED"
	sttTB(SCC.JOINING) = "JOINING"
	sttTB(SCC.JOINED) = "JOINED"

	if ( not sccInit ) then end
	
	sccMain
	
	sccEnd

'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
'' client routines
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function sccInit%
	dim nRet as integer
	dim wsaDat as WSAData	
	dim wVersionRequested as integer

	sccInit = 0
	
	ctx.state = SCC.OFFLINE
	ctx.hostSocket = 0
	ctx.cmd = 0
	ctx.nick = space$( SC.NICKLEN )

	'' initialize queues
	scUserInit
	scMsgInit scIMsgLst, scIMsgTB(), SC.MAXMSGS
	scMsgInit scOMsgLst, scOMsgTB(), SC.MAXMSGS

	''
	'' Initialize WinSock.dll
	''
	wVersionRequested = MAKEWORD( 1, 1 )
	nRet = WSAStartup( wVersionRequested, wsaDat )
	if ( nRet <> 0 ) then
		print "[ERROR] WSAStartup():"; nRet
		exit function
	end if

	''
	'' Check WinSock version
	''
	if ( wsaDat.wVersion <> wVersionRequested ) then
		print "ERROR! WinSock version not supported"
		nRet = WSACleanup
		exit function
	end if
	    
	screen 0: width 80
	cls
	view print 1 to 23
	locate 1, 1

    sccInit = -1
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub sccEnd
	dim nRet as integer, u as integer
	
	''
	'' close socket
	''
	if ( ctx.hostSocket <> 0 ) then
		nRet = shutdown( ctx.hostSocket, 2 )
		nRet = closesocket( ctx.hostSocket )
		ctx.hostSocket = 0
	end if
	
	''
	'' Release WinSock
	''	
	nRet = WSACleanup
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub sccMain
    dim finish as integer
    
    finish = 0
	do until ( finish <> 0 )
		
		if ( sccReceive ) then
			print "[ERROR] sccReceive(): "; WSAGetLastError
			exit do
		end if
		
		finish = sccUI
		
		sccProcess
		
		if ( sccSend ) then
			print "[ERROR] sccSend (): "; WSAGetLastError
			exit do
		end if

		if ( ctx.cmd = SCP.QUIT ) then
			sccDisconnect
		end if
		
		ctx.cmd = 0
			
	loop

end sub 

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function sccReceive%
    dim rfds(0 to 1) as long, efds(0 to 1) as long
	dim tv AS timeval
	dim nRet as integer, m as integer
	
	sccReceive = 0
	
	if ( ctx.state = SCC.OFFLINE ) then exit function
	
	tv.tvSec = 0: tv.tvUsec = 0
		
	rfds(0) = 1
	rfds(1) = ctx.hostSocket
	efds(0) = 1
	efds(1) = ctx.hostSocket
    nRet = selectsocket( 0, rfds(0), 0, efds(0), tv )
		
	if ( nRet = 0 ) then exit function
	   
    if ( (nRet < 0) or (efds(0) <> 0) ) then
        sccReceive = -1
        exit function
	end if
	   
	m = scMsgNew( scIMsgLst, scIMsgTB() )
	if ( m <> -1 ) then
				
		nRet = recv( ctx.hostSocket, _
					 MAKELONG( varptr( scIMsgTB(m).msg ), varseg( scIMsgTB(m).msg ) ), _
				     SC.MAXLEN, 0 )
		if ( nRet <> SOCKET.ERROR ) then
			if ( nRet = 0 ) then 				'' connection closed?
				sccDisconnect
				exit function
			end if
	
			scMsgAdd scIMsgLst, scIMsgTB(), ( m ), nRet
				
		else
			scMsgDelTail scIMsgLst, scIMsgTB()
		end if
	end if
	
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function sccConnecting%
	dim wfds(0 to 1) as long, efds(0 to 1) as long
	dim tv AS timeval
	dim nRet as integer
	
	sccConnecting = 0
	
	if ( (ctx.state <> SCC.CONNECTING) or (ctx.hostSocket = 0) ) then exit function
	
	tv.tvSec = 0: tv.tvUsec = 0
		
	wfds(0) = 1
	wfds(1) = ctx.hostSocket
	efds(0) = 1
	efds(1) = ctx.hostSocket
	nRet = selectsocket( 0, 0, wfds(0), efds(0), tv )
		
	if ( nRet = 0 ) then exit function
	   
	if ( (nRet < 0) or (efds(0) <> 0) ) then
	   	ctx.state = SCC.OFFLINE
    	nRet = closesocket( ctx.hostSocket )
    	ctx.hostSocket = 0
	   	
	   	if ( efds(0) <> 0 ) then WSASetLastError WSAEHOSTUNREACH
	   	
	   	sccConnecting = -1
	   	exit function
	end if
	
	ctx.state = SCC.CONNECTED
	
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function sccConnect% ( text as string )
	dim nRet as integer
	dim port as integer, pHost as long, p as integer
	dim sa as sockaddrIn

	sccConnect = 0
	
	if ( (ctx.state <> SCC.OFFLINE) ) then 
		print "[ERROR] sccConnect(): Already connected or connecting"
		exit function
	end if
	
	p = instr( text, ":" )
	if ( p > 0 ) then
		port = val( mid$( text, 1, p-1 ) )
		text = left$( text, p-1 )
	else
		port = SC.DEFPORT
	end if
	
	''
	'' Resolve host name
	''
	pHost = gethostbyname( text )
    if ( pHost = NULL ) then
        print "[ERROR] gethostbyname()"; WSAGetLastError
        exit function
    end if

	''
	'' Fill in the address structure
	''
	sa.sinfamily = AF.INET
	sa.sinaddr.saddr = hostent.hAddrList( pHost )
	sa.sinport = htons( port )

    ''
    '' Create a TCP/IP stream socket
    ''
    ctx.hostSocket = socket( AF.INET, SOCK.STREAM, IPPROTO.TCP )
    if ( ctx.hostSocket = INVALID.SOCKET ) then
        print "[ERROR] socket():"; WSAGetLastError
        sccConnect = -1
        exit function
    end if
	
    '' put socket in non-blocking mode
    if ( ioctlsocket( ctx.hostSocket, FIONBIO, 1 ) = SOCKET.ERROR ) then 
    	print "[ERROR] ioctlsocket():"; WSAGetLastError
    	nRet = closesocket( ctx.hostSocket )
    	ctx.hostSocket = 0
    	sccConnect = -1
    	exit function
    end if
	
	nRet = connect( ctx.hostSocket, sa, len( sa ) )
	if ( nRet = SOCKET.ERROR ) then	
		if ( WSAGetLastError <> WSAEWOULDBLOCK ) then
    		nRet = closesocket( ctx.hostSocket )
    		ctx.hostSocket = 0
    		sccConnect = -1
    		exit function
    	end if
	end if

	ctx.state = SCC.CONNECTING
	
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub sccDisconnect
	dim nRet as integer

	if ( ctx.hostSocket = 0 ) then exit sub
	
	if ( ctx.state = SCC.OFFLINE ) then 
		print "[ERROR] sccDisconnect(): not connected"
		exit sub
	end if

	if ( ctx.hostSocket <> 0 ) then
		nRet = shutdown( ctx.hostSocket, 2 )
		nRet = closesocket( ctx.hostSocket )
		ctx.hostSocket = 0
	end if
	
	'' reinitialize queues
	scUserInit
	scMsgInit scIMsgLst, scIMsgTB(), SC.MAXMSGS
	scMsgInit scOMsgLst, scOMsgTB(), SC.MAXMSGS
	
	ctx.state = SCC.OFFLINE
	
	print "*** Disconnected"

end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub sccTokenize ( text as string, tokenc as integer, tokenv() as string, tokenp() as integer, maxc as integer )
    dim cmd as string
    dim p as integer, char as integer, l as integer

	p = 1
	l = len( text )
	tokenc = 0
	
	do
		do
			char = asc( mid$( text, p, 1 ) )
			p = p + 1
			l = l - 1
		loop while ( ((char = 32) or (char = 7)) and (l > 0) )
		
		tokenp(tokenc) = p - 1
		if ( l = 0 ) then
            if ( (char <> 32) and (char <> 7) ) then 
                tokenv(tokenc) = chr$( char )
                tokenc = tokenc + 1
            end if

            exit do
        end if

		do
			tokenv(tokenc) = tokenv(tokenc) + chr$( char )
			char = asc( mid$( text, p, 1 ) )
			p = p + 1
			l = l - 1
		loop until ( (char = 32) or (char = 7) or (l = 0) )
		
		if ( (char <> 32) and (char <> 7) ) then 
			tokenv(tokenc) = tokenv(tokenc) + chr$( char )
		end if
		
		tokenc = tokenc + 1
	loop while ( (l > 0) and (tokenc < maxc) )
end sub


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub sccUIProcess ( text as string )
	dim q as integer
	dim tokenc as integer, tokenv(0 to 3) as string, tokenp(0 to 3) as integer
	static nick as string * 8
		
	text = ltrim$( rtrim$( text ) )
	
	'' process commands
	if ( left$( text, 1 ) = "/" ) then
	
		sccTokenize text, tokenc, tokenv(), tokenp(), 2
				
		select case ucase$( tokenv(0) )
			case "/QUIT"
				text = ""
				ctx.cmd = SCP.QUIT
				
			case "/JOIN"
				if ( ctx.nick = space$( SC.NICKLEN ) ) then
					print "*** Choose a nick first"
				else
					q = sccConnect( tokenv(1) )
				end if
			    exit sub
			    
			case "/NICK"
				print "*** "; rtrim$(ctx.nick); " is now known as "; tokenv(1)
				ctx.nick = tokenv(1)
				exit sub

			case "/MSG"            	            	
            	nick = tokenv(1)
            	if ( tokenp(1) + len( tokenv(1) ) + 1 < len( text ) ) then
            		text = mid$( text, tokenp(1) + len( tokenv(1) ) + 1 )
            	            	
            		if ( ctx.state = SCC.ONLINE ) then
            			print "-> [msg("; tokenv(1); ")] "; text
            		end if
            	
            		text = nick + text
            		ctx.cmd = SCP.PRIV
            	else
            		exit sub
            	end if
            	
			case "/CLEAR"
				cls 2
				exit sub
			
			case else
				print "*** Unknow command"
				exit sub
		end select
	
	'' just pure text
	else
		ctx.cmd = SCP.TEXT
	end if
	
	if ( ctx.state <> SCC.ONLINE ) then
		print "*** Not connected"
		exit sub
	end if
	
	'' add to outcoming msg queue
	if ( (len( text ) > 0) or (ctx.cmd <> 0) ) then
		q = scMsgNew( scOMsgLst, scOMsgTB() )
		if ( q = -1 ) then exit sub
		scOMsgTB(q).msg = chr$( ctx.cmd ) + text + chr$( 0 )
		scMsgAdd scOMsgLst, scOMsgTB(), ( q ), 1 + len( text ) + 1
	end if

end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function sccUI%
	static firstRun as integer, users as integer, imsgs as integer, omsgs as integer, state as integer
	static text as string, tlen as long, nick as string * 8
	dim k as string, curRow as integer
	dim m as integer, u as integer, cmd as integer
	
	sccUI = 0
	
	curRow = csrlin
	view print
	
	'' update status bar
	if ( not firstRun ) then
		firstRun = -1
		users = -1
		omsgs = -1
		imsgs = -1
		state = -1
	end if
			
	if ( users <> scUserLst.items ) then
		users = scUserLst.items
		locate 25, 1
		print "U:"; users; "    ";
	end if
		
	if ( omsgs <> scOMsgLst.items ) then
		omsgs = scOMsgLst.items
		locate 25, 10
		print "O:"; omsgs; "    ";
	end if

	if ( imsgs <> scIMsgLst.items ) then
		imsgs = scIMsgLst.items
		locate 25, 20
		print "I:"; imsgs; "    ";
	end if
	
	if ( state <> ctx.state ) then
		state = ctx.state
		locate 25, 80 - ( len( sttTB(state) ) + 4 )
		print "     "; sttTB(state);
	end if	
	
	view print 1 to 23: locate curRow, 1

	'' process input
	k = inkey$
	if ( len( k ) > 0 ) then
		select case asc( k )
			case 27							'' esc
				sccUI = -1	
				
			case 8							'' backspc
				if ( len( text ) > 1 ) then
					text = left$( text, len( text ) - 1 )
				else
					text = ""
				end if
				
			case 13							'' enter
				if ( len( text ) > 0 ) then
					sccUIProcess text
					text = ""
				end if

			case 32 to 127			
				if ( len( text ) < SC.MAXLEN ) then
					text = text + k
				end if
		end select
	end if
	
	if ( tlen <> len( text ) ) then
		curRow = csrlin: view print 
		tlen = len( text )
		locate 24, 1
		print text; space$( 80 - len( text ) );
		view print 1 to 23: locate curRow, 1
	end if
	

	'' show joins/quits/text
	m = scIMsgLst.head
	do while ( m <> -1 )
		
		cmd = asc( left$( scIMsgTB(m).msg, 1 ) )
		
		select case cmd
			
			''''''''''''''''''''''''''''
			case SCP.JOIN						'' <JOIN><nick>\0
				print "*** Joins: "; mid$( scIMsgTB(m).msg, 1+1, SC.NICKLEN )

			''''''''''''''''''''''''''''
            case SCP.QUIT                       '' <QUIT><nick>\0
                print "*** Parts: "; mid$( scIMsgTB(m).msg, 1+1, SC.NICKLEN )

			''''''''''''''''''''''''''''
			case SCP.TEXT						'' <TEXT><nick><text>\0
				nick = mid$( scIMsgTB(m).msg, 1+1, SC.NICKLEN )
				if ( nick <> ctx.nick ) then
					print "<"; rtrim$(nick); "> ";
				end if
				
				print mid$( scIMsgTB(m).msg, 1+1+SC.NICKLEN, scIMsgTB(m).length-1-1-SC.NICKLEN )
		
			''''''''''''''''''''''''''''
			case SCP.PRIV						'' <PRIV><nick><text>\0
				print "*"; rtrim$(mid$( scIMsgTB(m).msg, 1+1, SC.NICKLEN )); "* "; mid$( scIMsgTB(m).msg, 1+1+SC.NICKLEN, scIMsgTB(m).length-1-1-SC.NICKLEN )

		end select
	
		m = scIMsgTB(m).nxt
	loop


end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub sccProcess static
	dim i as integer, m as integer, q as integer, u as integer
	dim cmd as integer, p as integer
	dim users as integer, nick as string * 8
	
	'' 
	select case ctx.state
		case SCC.CONNECTING
			if ( sccConnecting ) then
				print "[ERROR] sccConnecting(): "; WSAGetLastError
				exit sub
			end if
		
		case SCC.CONNECTED
			q = scMsgNew( scOMsgLst, scOMsgTB() )
			if ( q <> -1 ) then 
				scOMsgTB(q).msg = chr$( SCP.JOIN ) + ctx.nick + chr$( 0 )
				scMsgAdd scOMsgLst, scOMsgTB(), ( q ), 1 + SC.NICKLEN + 1
        
        		ctx.state = SCC.JOINING
        	end if
        	
        case SCC.JOINED
			q = scMsgNew( scOMsgLst, scOMsgTB() )
			if ( q <> -1 ) then
				scOMsgTB(q).msg = chr$( SCP.LIST ) + chr$( 0 )
				scMsgAdd scOMsgLst, scOMsgTB(), ( q ), 1 + 1
        
        		ctx.state = SCC.ONLINE
        	end if
        
    end select
	
	
	m = scIMsgLst.head
	do while ( m <> -1 )
		
		cmd = asc( left$( scIMsgTB(m).msg, 1 ) )
		
		select case cmd
			
			''''''''''''''''''''''''''''
			case SCP.JOIN					'' <JOIN><nick>\0
				
				nick = mid$( scIMsgTB(m).msg, 1+1, SC.NICKLEN )
				
				if ( (ctx.state = SCC.JOINING) and (nick = ctx.nick) ) then
					 ctx.state = SCC.JOINED
				end if
				
				if ( scUserByNick( nick ) = -1 ) then 
					if ( not scUserAdd( nick ) ) then
					end if
				end if
			
			''''''''''''''''''''''''''''
			case SCP.REFUSED				'' <REFUSED>\0
				print "*** Nick already in use"
				sccDisconnect
				exit sub
				
			''''''''''''''''''''''''''''
			case SCP.QUIT					'' <QUIT><nick>\0

				u = scUserByNick( mid$( scIMsgTB(m).msg, 1+1, SC.NICKLEN ) )
				if ( u <> -1 ) then scUserDel ( u )
			
			''''''''''''''''''''''''''''
			case SCP.LIST
				'' recv: <LIST><users><nicks list>\0
			
				users = asc( mid$( scIMsgTB(m).msg, 1+1, 1 ) )
				p = 1+1+1
				do while ( users > 0 )
				    
				    nick = mid$( scIMsgTB(m).msg, p, SC.NICKLEN )
				    if ( scUserByNick( nick ) = -1 ) then 
				    	if ( not scUserAdd( nick ) ) then
						end if
				    end if
				    
				    p = p + SC.NICKLEN
				    
				    users = users - 1
				loop


			''''''''''''''''''''''''''''
			case SCP.TEXT
				'' recv: <TEXT><nick><text>\0


			''''''''''''''''''''''''''''
			case SCP.PRIV
				'' recv: <PRIV><nick><text>\0
			

			''''''''''''''''''''''''''''
			case SCP.PING
				'' recv: <PING>\0
				'' send: <PONG>\0
				
				q = scMsgNew( scOMsgLst, scOMsgTB() )
				if ( q = -1 ) then exit do
				scOMsgTB(q).msg = chr$( SCP.PONG ) + chr$( 0 )
				scMsgAdd scOMsgLst, scOMsgTB(), ( q ), 1 + 1
				
		end select
		
		m = scIMsgTB(m).nxt
		scMsgDelHead scIMsgLst, scIMsgTB()
	loop
	
end sub


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function sccSend%
    dim wfds(0 to 1) as long, efds(0 to 1) as long
	dim tv AS timeval
	dim nRet as integer, m as integer, i as integer
	
	sccSend = 0
	
	if ( (scOMsgLst.items = 0) ) then exit function
	
	if ( (ctx.state = SCC.OFFLINE) or (ctx.state = SCC.CONNECTING) ) then
		m = scOMsgLst.head
		do while ( m <> -1 )
			i = scOMsgTB(m).nxt
			scMsgDelHead scOMsgLst, scOMsgTB()
			m = i
		loop
		exit function
	end if
	
	
	tv.tvSec = 0: tv.tvUsec = 0
		
	wfds(0) = 1
	wfds(1) = ctx.hostSocket
    efds(0) = 1
    efds(1) = ctx.hostSocket
    nRet = selectsocket( 0, 0, wfds(0), efds(0), tv )
		
	if ( nRet = 0 ) then exit function
	   
    if ( (nRet < 0) or (efds(0) <> 0) ) then
	   	sccSend = -1
	   	exit function
	end if

	m = scOMsgLst.head
	do while ( m <> -1 )
		nRet = send( ctx.hostSocket, _
					 MAKELONG( varptr( scOMsgTB(m).msg ), varseg( scOMsgTB(m).msg ) ), _
					 scOMsgTB(m).length, 0 )
		if ( nRet <> scOMsgTB(m).length ) then exit do
		
		m = scOMsgTB(m).nxt
		scMsgDelHead scOMsgLst, scOMsgTB()
	loop
	
end function

    
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
'' user routines
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scUserInit static
	dim i as integer, p as integer, n as integer
	
	scUserLst.head = -1
	scUserLst.tail = -1
	scUserLst.fhead = 0
	scUserLst.items = 0
	
	p = -1
	n = 1
	for i = 0 to (SC.MAXUSERS-1)-1
		scUserTB(i).prv = p
		scUserTB(i).nxt = n
		p = i
		n = n + 1
	
		scUserTB(i).state = 0
		scUserTB(i).nick = string$( SC.NICKLEN, 32 )
	next i 
	
	scUserTB(SC.MAXUSERS-1).prv = p
	scUserTB(SC.MAXUSERS-1).nxt = -1
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scUserNew% static
	dim i as integer, t as integer, n as integer
	
	i = scUserLst.fhead
	if ( i = -1 ) then
		scUserNew = -1
		exit function
	end if
	
	'' del from free list
	n = scUserTB(i).nxt
	if ( n <> -1 ) then
		 scUserTB(n).prv = -1
	end if
	scUserLst.fhead = n
	
	'' add to alloc list
	t = scUserLst.tail
	if ( t <> -1 ) then
		scUserTB(t).nxt = i
	else
		scUserLst.head = i
	end if
	scUserTB(i).prv = t
	scUserTB(i).nxt = -1
	scUserLst.tail = i
		
	scUserLst.items = scUserLst.items + 1
	
	scUserNew = i
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scUserAdd% ( nick as string ) static
    dim u as integer
	
	u = scUserNew
	if ( u = -1	) then 
		scUserAdd = 0
		exit function
	end if
		
	scUserTB(u).state = -1
	scUserTB(u).nick = nick
	
	scUserAdd = -1
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scUserFree ( u as integer ) static
	dim p as integer, n as integer, h as integer

	'' del from alloc list
	p = scUserTB(u).prv
	n = scUserTB(u).nxt
	if ( p <> -1 ) then
		scUserTB(p).nxt = n
	else
		scUserLst.head = n
	end if
	if ( n <> -1 ) then
		scUserTB(n).prv = p
	else
		scUserLst.tail = p
	end if
	
	'' add to free list
	h = scUserLst.fhead
	scUserTB(u).prv = -1
	scUserTB(u).nxt = h
	if ( h <> -1 ) then
		scUserTB(h).prv = u
	end if
	scUserLst.fhead = u
	
	scUserLst.items = scUserLst.items - 1

end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scUserDel ( u as integer )
	dim nRet as integer

	scUserFree ( u )
	
	scUserTB(u).state = 0
	scUserTB(u).nick = string$( SC.NICKLEN, 32 )
	
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scUserByNick% ( nick as string ) static
	dim i as integer
	
	i = scUserLst.head
	do while ( i <> -1 )
		if ( scUserTB(i).nick = nick ) then exit do
		i = scUserTB(i).nxt
	loop
	
	scUserByNick = i
end function


'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
'' message processing 
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgInit ( mLst as TLIST, mTB() as TMSG, imax as integer ) static
	dim i as integer, p as integer, n as integer
	
	mLst.head = -1
	mLst.tail = -1
	mLst.fhead = 0
	mLst.items = 0
	
	p = -1
	n = 1
	for i = 0 to (imax-1)-1
		mTB(i).prv = p
		mTB(i).nxt = n
		p = i
		n = n + 1
	next i 
	
	mTB(imax-1).prv = p
	mTB(imax-1).nxt = -1
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scMsgNew% ( mLst as TLIST, mTB() as TMSG ) static
	dim i as integer, t as integer, n as integer
	
	i = mLst.fhead
	if ( i = -1 ) then
		scMsgNew = -1
		exit function
	end if
	
	'' del from free list
	n = mTB(i).nxt
	if ( n <> -1 ) then
		 mTB(n).prv = -1
	end if
	mLst.fhead = n
	
	'' add to alloc list
	t = mLst.tail
	if ( t <> -1 ) then
		mTB(t).nxt = i
	else
		mLst.head = i
	end if
	mTB(i).prv = t
	mTB(i).nxt = -1
	mLst.tail = i
		
	mLst.items = mLst.items + 1

	scMsgNew = i
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgAdd ( mLst as TLIST, mTB() as TMSG, m as integer, length as integer ) static
	
	mTB(m).length = length
	
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgFree ( mLst as TLIST, mTB() as TMSG, m as integer ) static
	dim p as integer, n as integer, h as integer

	'' del from alloc list
	p = mTB(m).prv
	n = mTB(m).nxt
	if ( p <> -1 ) then
		mTB(p).nxt = n
	else
		mLst.head = n
	end if
	if ( n <> -1 ) then
		mTB(n).prv = p
	else
		mLst.tail = p
	end if
	
	'' add to free list
	h = mLst.fhead
	mTB(m).prv = -1
	mTB(m).nxt = h
	if ( h <> -1 ) then
		mTB(h).prv = m
	end if
	mLst.fhead = m
	
	mLst.items = mLst.items - 1

end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgDelTail ( mLst as TLIST, mTB() as TMSG ) static

	scMsgFree mLst, mTB(), ( mLst.tail )
	
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgDelHead ( mLst as TLIST, mTB() as TMSG ) static

	scMsgFree mLst, mTB(), ( mLst.head )

end sub
