''
'' scs.bas -- server for Simple Chat protocol
'' copyleft 2002 by v1ctor (av1ctor@yahoo.com.br)
''

'option explicit

defint a-z
'$include: '..\..\inc\dsock.bi'
'$include: 'schat.bi'

const SCS.OFFLINE% 	= 0%
const SCS.ONLINE% 	= 1%
const SCS.JOINING%	= 2%

type TSC
	sname			as string * 16				'' server name
	listenSocket 	as long
end type

type TUSER
	prv				as integer
	nxt				as integer
	state			as integer
	s				as long
	nick			as string * 8 'SC.NICKLEN	
	ping			as integer					'' secs passed since last PONG answer
	fmsg			as integer					'' first msg on queue to send
end type

type TMSG
	prv				as integer
	nxt				as integer
	cnt				as integer
	sender			as integer
	receiver		as integer
	length			as integer
	msg				as string * 160 'SC.MAXLEN
end type

'' protos :::
declare sub 	 main 			( argc as integer, argv() as string )
declare sub 	 parseCmd 		( argc as integer, argv() as string )

declare function scsInit%		( port as integer )
declare sub 	 scsEnd			( )
declare sub 	 scsMain		( )
declare sub 	 scsTimeout 	( )
declare function scsUI%			( )
declare function scsAccept% 	( )
declare function scsReceive% 	( )
declare sub 	 scsProcess		( )
declare function scsSend%		( )

declare sub 	 scUserInit 	( )
declare function scUserNew% 	( )
declare function scUserAdd% 	( s as long )
declare sub 	 scUserFree 	( u as integer )
declare sub 	 scUserDel 		( u as integer )
declare function scUserBySocket% ( s as long )
declare function scUserByNick% 	( nick as string )
declare sub 	 scUserUpdList 	( head as integer )
declare sub 	 scUserSendMsgs ( u as integer )

declare sub 	 scMsgInit 		( mLst as TLIST, mTB() as TMSG, imax as integer )
declare function scMsgNew% 		( mLst as TLIST, mTB() as TMSG )
declare sub      scMsgAdd       ( mLst as TLIST, mTB() as TMSG, m as integer, length as integer, s as integer)
declare sub      scMsgToAdd     ( mLst as TLIST, mTB() as TMSG, m as integer, length as integer, s as integer, r as integer)
declare sub 	 scMsgFree 		( mLst as TLIST, mTB() as TMSG, m as integer )
declare sub 	 scMsgDelTail 	( mLst as TLIST, mTB() as TMSG )
declare sub 	 scMsgDelHead 	( mLst as TLIST, mTB() as TMSG )
declare sub 	 scMsgDel 		( mLst as TLIST, mTB() as TMSG, m as integer )
declare sub 	 scMsgUpdList 	( mLst as TLIST, mTB() as TMSG )

'' globals :::
dim shared ctx as TSC

dim shared scUserLst as TLIST, scUserTB(0 to SC.MAXUSERS-1) as TUSER
dim shared scIMsgLst as TLIST, scIMsgTB(0 to SC.MAXUSERS-1) as TMSG
dim shared scOMsgLst as TLIST, scOMsgTB(0 to SC.MAXMSGS-1) as TMSG

dim shared NEWLINE as string

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	NEWLINE = chr$( 13 ) + chr$( 10 )	
	dim argc as integer, argv(0 to 9) as string
	
	parseCmd argc, argv()
	main argc, argv()
    end

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub main ( argc as integer, argv() as string )
	dim port as integer
	
	if ( argc > 0 ) then 
		port = val( argv(0) )
	else
		port = SC.DEFPORT
	end if
	
	if ( not scsInit( port ) ) then exit sub
	
	scsMain
	
	scsEnd

end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub parseCmd ( argc as integer, argv() as string )
    dim cmd as string
    dim p as integer, char as integer
    
	cmd = lcase$( command$ + chr$( 13 ) )
	
	p = 1
	argc = 0
	
	do
		do
			char = asc( mid$( cmd, p, 1 ) )
			p = p + 1
		loop while ( (char = 32) or (char = 7) )
		
		if char = 13 then exit do

		do
			argv(argc) = argv(argc) + chr$( char )
			char = asc( mid$( cmd, p, 1 ) )
			p = p + 1
		loop until ( (char = 32) or (char = 7) or (char = 13) )
		
		argc = argc + 1
	loop while ( char <> 13 )
	
	cmd = ""
		
end sub

'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
'' server routines
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scsInit% ( port as integer )
	dim nRet as integer
	dim wsaDat as WSAData	
	dim wVersionRequested as integer
	dim saServer as sockaddrIn

	ctx.listenSocket = 0
    ctx.sname = "SC-Serv"
	
	scsInit = 0
	
	'' initialize queues
	scUserInit
	scMsgInit scIMsgLst, scIMsgTB(), SC.MAXUSERS
	scMsgInit scOMsgLst, scOMsgTB(), SC.MAXMSGS

	''
	'' Initialize WinSock.dll
	''
	wVersionRequested = MAKEWORD( 1, 1 )
	nRet = WSAStartup( wVersionRequested, wsaDat )
	if ( nRet <> 0 ) then
		print "ERROR! WSAStartup():"; nRet
		exit function
	end if

	''
	'' Check WinSock version
	''
	if ( wsaDat.wVersion <> wVersionRequested ) then
		print "ERROR! WinSock version not supported"
		nRet = WSACleanup
		exit function
	end if
	    
    ''
    '' Create a TCP/IP stream socket to "listen" with
    ''
    ctx.listenSocket = socket( AF.INET, SOCK.STREAM, IPPROTO.TCP )
    if ( ctx.listenSocket = INVALID.SOCKET ) then
        print "ERRO! socket()"; WSAGetLastError
        exit function
    end if
    
	''
	'' Fill in the address structure
	''
	saServer.sinfamily = AF.INET
	saServer.sinaddr.saddr = INADDR.ANY
	saServer.sinport = htons( port )

	''
	'' bind the name to the socket
	''
	nRet = bind( ctx.listenSocket, saServer, len( saServer ) )	
	if ( nRet = SOCKET.ERROR ) then	
		print "ERROR! bind()"; WSAGetLastError
		nRet = closesocket( ctx.listenSocket )
		exit function
	end if
	
	''
	'' Set the socket to listen
	''
	nRet = listen( ctx.listenSocket, SOMAXCONN )
	if ( nRet = SOCKET.ERROR ) then
		print "ERROR! listen()"; WSAGetLastError
		nRet = closesocket( ctx.listenSocket )
		exit function
	end if
	
	
	screen 0: width 80
	cls

    
    scsInit = -1
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scsEnd
	dim nRet as integer, u as integer
	
	''
	'' close connection to all clients
	''
	u = scUserLst.head
	do while ( u <> -1 )
        nRet = shutdown( scUserTB(u).s, 2 )
        nRet = closesocket( scUserTB(u).s )
		u = scUserTB(u).nxt
	loop
	
	''
	'' close listen socket
	''
	if ( ctx.listenSocket <> 0 ) then
		nRet = shutdown( ctx.listenSocket, 2 )
		nRet = closesocket( ctx.listenSocket )
		ctx.listenSocket = 0
	end if
	
    ''
	'' Release WinSock
	''	
	nRet = WSACleanup
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scsMain
    dim finish as integer
    
    finish = 0	
	do until ( finish <> 0 )
		
		if ( scsAccept	) then 
			print "[ERROR] scsAccept(): "; WSAGetLastError
			exit do
		end if
		
		if ( scsReceive ) then
			print "[ERROR] scsReceive(): "; WSAGetLastError
			exit do
		end if
		
		finish = scsUI
		
		scsProcess
		
		scsTimeout
		
		if ( scsSend ) then
			print "[ERROR] scsSend (): "; WSAGetLastError
			exit do
		end if
	
	loop

end sub 

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scsTimeout
	'' ... check for client timeout here ...
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scsUI%
	static firstRun as integer, users as integer, imsgs as integer, omsgs as integer
	dim k as string, curRow as integer
	dim m as integer, u as integer, cmd as integer
	
	scsUI = 0
	
	curRow = csrlin
	view print
	
	if ( not firstRun ) then
		firstRun = -1
		users = -1
		omsgs = -1
		imsgs = -1
	end if
	
	if ( users <> scUserLst.items ) then
		users = scUserLst.items
		locate 25, 1
		print "Users:"; users; "    ";
	end if
		
	if ( omsgs <> scOMsgLst.items ) then
		omsgs = scOMsgLst.items
		locate 25, 15
		print "oMsgs:"; omsgs; "    ";
	end if

	if ( imsgs <> scIMsgLst.items ) then
		imsgs = scIMsgLst.items
		locate 25, 30
		print "iMsgs:"; imsgs; "    ";
	end if
	
	'' check keys
	k = inkey$
	if ( len( k ) > 0 ) then
		select case asc( k )
			case 27
				scsUI = -1	
		end select
	end if
	
	'' show joins/quits
	view print 1 to 24
	locate curRow, 1
    
	m = scIMsgLst.head
	do while ( m <> -1 )
		
		u = scIMsgTB(m).sender
		cmd = asc( left$( scIMsgTB(m).msg, 1 ) )
		
		select case cmd
			
			''''''''''''''''''''''''''''
			case SCP.JOIN						'' <JOIN><nick>\0
				print "*** Joins: "; mid$( scIMsgTB(m).msg, 1+1, SC.NICKLEN )

			''''''''''''''''''''''''''''
			case SCP.QUIT						'' <QUIT>\0
				print "*** Parts: "; scUserTB(u).nick
		
			''''''''''''''''''''''''''''
            case SCP.TEXT                       '' <TEXT><text>\0
                print "<"; rtrim$( scUserTB(u).nick ); "> "; mid$( scIMsgTB(m).msg, 1+1, scIMsgTB(m).length-1-1 )

			''''''''''''''''''''''''''''
			case SCP.PRIV						'' <PRIV><nick><text>\0
                print "*"; rtrim$( scUserTB(u).nick ); "* ->[("; rtrim$( mid$( scIMsgTB(m).msg, 1+1, SC.NICKLEN ) ); ")] "; mid$( scIMsgTB(m).msg, 1+1+SC.NICKLEN, scIMsgTB(m).length-1-1-SC.NICKLEN )

		end select
	
		m = scIMsgTB(m).nxt
	loop

end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scsAccept%
    dim rfds(0 to 1) as long, efds(0 to 1) as long
	dim tv AS timeval
	dim nRet as integer
	dim s as long
	dim sa as sockaddrIn, lensa as integer
	
	scsAccept = 0
	do
		tv.tvSec = 0: tv.tvUsec = 0
        rfds(0) = 1
        rfds(1) = ctx.listenSocket
        efds(0) = 1
        efds(1) = ctx.listenSocket
        nRet = selectsocket( 0, rfds(0), 0, efds(0), tv )
		
		if ( nRet = 0 ) then exit function

        if ( (nRet < 0) or (efds(0) <> 0) ) then
            scsAccept = -1
	    	exit function
	    end if
	    
	    lensa = len( sa )
	    s = accept( ctx.listenSocket, sa, lensa )
	    if ( s = INVALID.SOCKET ) then
	    	scsAccept = -1
	    	exit function
		end if

	    if ( not scUserAdd( s ) ) then exit function
	loop
	
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scsReceive%
    dim rfds(0 to SC.MAXUSERS) as long
	dim tv AS timeval
	dim nRet as integer, i as integer, u as integer, m as integer
	
	scsReceive = 0
	
	if ( scUserLst.items = 0 ) then 		
		if ( scIMsgLst.items <> 0 ) then
			m = scIMsgLst.head
			do while ( m <> -1 )
				i = scIMsgTB(m).nxt
				scMsgDelHead scIMsgLst, scIMsgTB()
				m = i
			loop
		end if
		
		exit function
	end if

    tv.tvSec = 0: tv.tvUsec = 0
		
	i = 0
	u = scUserLst.head
	do while ( u <> -1 )
		rfds(1+i) = scUserTB(u).s
		i = i + 1
		u = scUserTB(u).nxt
	loop
	rfds(0) = i
		
    nRet = selectsocket( 0, rfds(0), 0, 0, tv )
		
	if ( nRet = 0 ) then exit function
	   
    if ( nRet < 0 ) then
	   	scsReceive = -1
	   	exit function
	end if

	for i = 1 to rfds(0)
	   	u = scUserBySocket( rfds(i) )
        if ( u <> -1 ) then
			m = scMsgNew( scIMsgLst, scIMsgTB() )
			if ( m <> -1 ) then				
				nRet = recv( scUserTB(u).s, _
						     MAKELONG( varptr( scIMsgTB(m).msg ), varseg( scIMsgTB(m).msg ) ), _
						     SC.MAXLEN, 0 )
                if ( (nRet = SOCKET.ERROR) or (nRet = 0) ) then
                    scIMsgTB(m).msg = chr$( SCP.QUIT ) + chr$( 0 )
                    nRet = 1 + 1
                end if
	
                scMsgAdd scIMsgLst, scIMsgTB(), ( m ), nRet, u
			end if
	   	end if
	next i	
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scsProcess static
	dim i as integer, m as integer, q as integer, u as integer, r as integer
    dim cmd as integer, l as integer, lastPubMsg as integer
	dim userlist as string, users as integer, nick as string * 8
	
    lastPubMsg = -1
	m = scIMsgLst.head
	do while ( m <> -1 )
		
		u = scIMsgTB(m).sender
		l = scIMsgTB(m).length
		cmd = asc( left$( scIMsgTB(m).msg, 1 ) )
		
		select case cmd
			
			''''''''''''''''''''''''''''
			case SCP.JOIN
				'' recv: <JOIN><nick>\0
				'' send: <JOIN><nick>\0 or <REFUSED>\0
				
				nick = mid$( scIMsgTB(m).msg, 1+1, l-1 )
				
				q = scMsgNew( scOMsgLst, scOMsgTB() )
				if ( q = -1 ) then exit do
				
				if ( scUserByNick( nick ) = -1 ) then
                    if ( lastPubMsg = -1 ) then lastPubMsg = q
                    scUserTB(u).nick = nick
					scUserTB(u).state = SCS.ONLINE
					scOMsgTB(q).msg = chr$( SCP.JOIN ) + mid$( scIMsgTB(m).msg, 1+1, l-1 )
					scMsgAdd scOMsgLst, scOMsgTB(), ( q ), l, u
				
				else
					scOMsgTB(q).msg = chr$( SCP.REFUSED ) + chr$( 0 )
					l = 1 + 1
                    scMsgToAdd scOMsgLst, scOMsgTB(), ( q ), l, u, u
				end if
				
			
			''''''''''''''''''''''''''''
			case SCP.QUIT
				'' recv: <QUIT>\0
				'' send: <QUIT><nick>\0

				if ( scUserTB(u).state = SCS.ONLINE ) then
					q = scMsgNew( scOMsgLst, scOMsgTB() )
					if ( q = -1 ) then exit do
                    if ( lastPubMsg = -1 ) then lastPubMsg = q
				
					scOMsgTB(q).msg = chr$( SCP.QUIT ) + scUserTB(u).nick + chr$( 0 )
					scMsgAdd scOMsgLst, scOMsgTB(), ( q ), 1 + SC.NICKLEN + 1, u
				end if
				
				scUserDel ( u )
			
			''''''''''''''''''''''''''''
			case SCP.LIST
				'' recv: <LIST>\0
				'' send: <LIST><users><nicks list>\0
			
				if ( scUserTB(u).state = SCS.ONLINE ) then
					i = scUserLst.head
					do while ( i <> -1 )
						q = scMsgNew( scOMsgLst, scOMsgTB() )
						if ( q = -1 ) then exit do
				    
				    	l = SC.MAXLEN - 1+1+1
				    	userlist = ""
				    	users = 0
				    	do while ( ( i <> -1 ) and ( l-SC.NICKLEN >= 0 ) )
				    		userlist = userlist + scUserTB(i).nick
				    		l = l - SC.NICKLEN
							i = scUserTB(i).nxt
							users = users + 1
				    	loop
				    
				    	scOMsgTB(q).msg = chr$( SCP.LIST ) + chr$( users ) + userlist + chr$( 0 )
                        scMsgToAdd scOMsgLst, scOMsgTB(), ( q ), 1+1+1 + (SC.MAXLEN - 1+1+1) - l, u, u
					loop
				end if

			''''''''''''''''''''''''''''
			case SCP.TEXT
				'' recv: <TEXT><text>\0
				'' send: <TEXT><nick><text>\0

				if ( scUserTB(u).state = SCS.ONLINE ) then
					q = scMsgNew( scOMsgLst, scOMsgTB() )
					if ( q = -1 ) then exit do
                    if ( lastPubMsg = -1 ) then lastPubMsg = q
					scOMsgTB(q).msg = chr$( SCP.TEXT ) + scUserTB(u).nick + mid$( scIMsgTB(m).msg, 1+1, l-1 )
					scMsgAdd scOMsgLst, scOMsgTB(), ( q ), l + SC.NICKLEN, u
				end if
				

			''''''''''''''''''''''''''''
			case SCP.PRIV
				'' recv: <PRIV><toNick><text>\0
				'' send: <PRIV><nick><text>\0
			
				if ( scUserTB(u).state = SCS.ONLINE ) then
					r = scUserByNick( mid$( scIMsgTB(m).msg, 1+1, SC.NICKLEN ) )
					if ( r <> -1 ) then
						if ( scUserTB(r).state = SCS.ONLINE ) then
							q = scMsgNew( scOMsgLst, scOMsgTB() )
							if ( q = -1 ) then exit do
							scOMsgTB(q).msg = chr$( SCP.PRIV ) + scUserTB(u).nick + mid$( scIMsgTB(m).msg, 1+1+SC.NICKLEN, l-1-SC.NICKLEN )
                            scMsgToAdd scOMsgLst, scOMsgTB(), ( q ), l, u, r
						end if
					end if
				end if
			

			''''''''''''''''''''''''''''
			case SCP.PONG
				'' recv: <PONG>\0
				'' send: .
				
				scUserTB(u).ping = 0
				
		end select
		
		m = scIMsgTB(m).nxt
		scMsgDelHead scIMsgLst, scIMsgTB()
	loop
	
    if ( lastPubMsg <> -1 ) then scUserUpdList lastPubMsg
	
    scMsgUpdList scOMsgLst, scOMsgTB()
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scsSend%
    dim wfds(0 to SC.MAXUSERS) as long, efds(0 to SC.MAXUSERS) as long
	dim tv AS timeval
	dim nRet as integer, i as integer, u as integer, m as integer
	
	scsSend = 0
	
	if ( scOMsgLst.items = 0  ) then exit function
	
	if ( scUserLst.items = 0 ) then
		m = scOMsgLst.head	
		do while ( m <> -1 )
			i = scOMsgTB(m).nxt
			scMsgDelHead scOMsgLst, scOMsgTB()
			m = i
		loop
		exit function
	end if
	
	tv.tvSec = 0: tv.tvUsec = 0
		
	i = 0
	u = scUserLst.head
	do while ( u <> -1 )
		wfds(1+i) = scUserTB(u).s
        efds(1+i) = scUserTB(u).s
		i = i + 1
		u = scUserTB(u).nxt
	loop
	wfds(0) = i
    efds(0) = i

    nRet = selectsocket( 0, 0, wfds(0), 0, tv )
		
	if ( nRet = 0 ) then exit function
	   
    if ( (nRet < 0)  ) then 'or (efds(0) <> 0)
	   	scsSend = -1
	   	exit function
	end if
	   
	for i = 1 to wfds(0)
	   	u = scUserBySocket( wfds(i) )
	   	if ( u <> -1 ) then scUserSendMsgs u
	next i
	
end function

'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
'' user routines
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scUserInit static
	dim i as integer, p as integer, n as integer
	
	scUserLst.head = -1
	scUserLst.tail = -1
	scUserLst.fhead = 0
	scUserLst.items = 0
	
	p = -1
	n = 1
	for i = 0 to (SC.MAXUSERS-1)-1
		scUserTB(i).prv = p
		scUserTB(i).nxt = n
		p = i
		n = n + 1
	
		scUserTB(i).state = SCS.OFFLINE
        scUserTB(i).nick = space$( SC.NICKLEN )
	next i 
	
	scUserTB(SC.MAXUSERS-1).prv = p
	scUserTB(SC.MAXUSERS-1).nxt = -1
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scUserNew% static
	dim i as integer, t as integer, n as integer
	
	i = scUserLst.fhead
	if ( i = -1 ) then
		scUserNew = -1
		exit function
	end if
	
	'' del from free list
	n = scUserTB(i).nxt
	if ( n <> -1 ) then
		 scUserTB(n).prv = -1
	end if
	scUserLst.fhead = n
	
	'' add to alloc list
	t = scUserLst.tail
	if ( t <> -1 ) then
		scUserTB(t).nxt = i
	else
		scUserLst.head = i
	end if
	scUserTB(i).prv = t
	scUserTB(i).nxt = -1
	scUserLst.tail = i
		
	scUserLst.items = scUserLst.items + 1
	
	scUserNew = i
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scUserAdd% ( s as long ) static
    dim u as integer
	
	u = scUserNew
	if ( u = -1	) then 
		scUserAdd = 0
		exit function
	end if
		
	scUserTB(u).state = SCS.JOINING
	scUserTB(u).s = s
    scUserTB(u).nick = space$( SC.NICKLEN )
	scUserTB(u).fmsg = -1
	scUserTB(u).ping = 0
	
	scUserAdd = -1
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scUserFree ( u as integer ) static
	dim p as integer, n as integer, h as integer

	'' del from alloc list
	p = scUserTB(u).prv
	n = scUserTB(u).nxt
	if ( p <> -1 ) then
		scUserTB(p).nxt = n
	else
		scUserLst.head = n
	end if
	if ( n <> -1 ) then
		scUserTB(n).prv = p
	else
		scUserLst.tail = p
	end if
	
	'' add to free list
	h = scUserLst.fhead
	scUserTB(u).prv = -1
	scUserTB(u).nxt = h
	if ( h <> -1 ) then
		scUserTB(h).prv = u
	end if
	scUserLst.fhead = u
	
	scUserLst.items = scUserLst.items - 1

end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scUserDel ( u as integer )
	dim nRet as integer

	nRet = shutdown( scUserTB(u).s, 2 )
	nRet = closesocket( scUserTB(u).s )
	
	scUserFree ( u )
	
	scUserTB(u).state = SCS.OFFLINE
    scUserTB(u).nick = space$( SC.NICKLEN )
	
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scUserBySocket% ( s as long ) static
	dim i as integer
	
	i = scUserLst.head
	do while ( i <> -1 )
		if ( scUserTB(i).s = s ) then exit do
		i = scUserTB(i).nxt
	loop
	
	scUserBySocket = i
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scUserByNick% ( nick as string ) static
	dim i as integer
	
	i = scUserLst.head
	do while ( i <> -1 )
		if ( scUserTB(i).nick = nick ) then exit do
		i = scUserTB(i).nxt
	loop
	
	scUserByNick = i
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scUserUpdList ( head as integer )
	dim i as integer

	i = scUserLst.head
	do while ( i <> -1 )
		if ( scUserTB(i).fmsg = -1 ) then scUserTB(i).fmsg = head
		i = scUserTB(i).nxt
	loop
	
end sub	

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scUserSendMsgs ( u as integer ) static
	dim m as integer, n as integer
	dim r as integer, s as integer
	dim nRet as integer
	
	m = scUserTB(u).fmsg
	do while ( m <> -1 )
		s = scOMsgTB(m).sender
		r = scOMsgTB(m).receiver
		'if ( ( s <> u ) or ( s = r ) ) then
			if ( ( r = -1 ) or ( r = u ) ) then
				nRet = send( scUserTB(u).s, _
							 MAKELONG( varptr( scOMsgTB(m).msg ), varseg( scOMsgTB(m).msg ) ), _
							 scOMsgTB(m).length, 0 )
				if ( nRet <> scOMsgTB(m).length ) then exit do
			
				scOMsgTB(m).cnt = scOMsgTB(m).cnt - 1
			end if
		'end if
		
		n = scOMsgTB(m).nxt
		if ( scOMsgTB(m).cnt = 0 ) then scMsgDel scOMsgLst, scOMsgTB(), ( m )
		m = n
	loop
	scUserTB(u).fmsg = m
	
end sub


'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
'' message processing 
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgInit ( mLst as TLIST, mTB() as TMSG, imax as integer ) static
	dim i as integer, p as integer, n as integer
	
	mLst.head = -1
	mLst.tail = -1
	mLst.fhead = 0
	mLst.items = 0
	
	p = -1
	n = 1
	for i = 0 to (imax-1)-1
		mTB(i).prv = p
		mTB(i).nxt = n
		p = i
		n = n + 1
	next i 
	
	mTB(imax-1).prv = p
	mTB(imax-1).nxt = -1
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
function scMsgNew% ( mLst as TLIST, mTB() as TMSG ) static
	dim i as integer, t as integer, n as integer
	
	i = mLst.fhead
	if ( i = -1 ) then
		scMsgNew = -1
		exit function
	end if
	
	'' del from free list
	n = mTB(i).nxt
	if ( n <> -1 ) then
		 mTB(n).prv = -1
	end if
	mLst.fhead = n
	
	'' add to alloc list
	t = mLst.tail
	if ( t <> -1 ) then
		mTB(t).nxt = i
    else
		mLst.head = i
	end if
	mTB(i).prv = t
	mTB(i).nxt = -1
	mLst.tail = i
		
    mLst.items = mLst.items + 1

    scMsgNew = i
end function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgAdd ( mLst as TLIST, _
               mTB() as TMSG, _
               m as integer, _
               length as integer, _
               s as integer) static
	
	mTB(m).length = length
    mTB(m).sender = s
	mTB(m).receiver = -1
	mTB(m).cnt = scUserLst.items
    
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgToAdd ( mLst as TLIST, _
                 mTB() as TMSG, _
                 m as integer, _
                 length as integer, _
                 s as integer, _
                 r as integer) static
	
	mTB(m).length = length
    mTB(m).sender = s
    mTB(m).receiver = r
    mTB(m).cnt = 1

    if ( scUserTB(r).fmsg = -1 ) then scUserTB(r).fmsg = m
	
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgFree ( mLst as TLIST, mTB() as TMSG, m as integer )
	dim p as integer, n as integer, h as integer

	'' del from alloc list
	p = mTB(m).prv
	n = mTB(m).nxt
	
	if ( p <> -1 ) then
		mTB(p).nxt = n
	else
		mLst.head = n
	end if
	if ( n <> -1 ) then
		mTB(n).prv = p
	else
		mLst.tail = p
	end if
	
	'' add to free list
	h = mLst.fhead
	mTB(m).prv = -1
	mTB(m).nxt = h
	if ( h <> -1 ) then
		mTB(h).prv = m
	end if
	mLst.fhead = m
	
    mLst.items = mLst.items - 1

end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgDelTail ( mLst as TLIST, mTB() as TMSG ) static

	scMsgFree mLst, mTB(), ( mLst.tail )
	
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgDelHead ( mLst as TLIST, mTB() as TMSG ) static

	scMsgFree mLst, mTB(), ( mLst.head )

end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgDel ( mLst as TLIST, mTB() as TMSG, m as integer ) static

	scMsgFree mLst, mTB(), ( m )
	
end sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
sub scMsgUpdList ( mLst as TLIST, mTB() as TMSG )
	dim m as integer, i as integer, u as integer

	m = mLst.head
	do while ( m <> -1 )
		i = mTB(m).nxt
		u = mTB(m).receiver
		if ( u <> -1 ) then
			'' bug: msg can stay with in queue if user slot was occuped in
            ''      the mid time by another user. users need unique IDs for
            ''      fixing that.
			if ( scUserTB(u).state = SCS.OFFLINE ) then 
				scMsgDelHead mLst, mTB()
			end if
		
		else
			if ( mTB(m).cnt > scUserLst.items ) then mTB(m).cnt = scUserLst.items
			if ( mTB(m).cnt <= 0 ) then scMsgDelHead mLst, mTB()
		end if
		m = i
	loop
	
end sub	
