      '$DYNAMIC
      TYPE RegTypeX
      ax    AS INTEGER
      Bx    AS INTEGER
      cx    AS INTEGER
      dx    AS INTEGER
      bp    AS INTEGER
      si    AS INTEGER
      di    AS INTEGER
      flags AS INTEGER
      ds    AS INTEGER
      es    AS INTEGER
      END TYPE
      
      TYPE TrackType
      sector AS LONG
      length AS LONG
      ttype AS INTEGER
      END TYPE
      TYPE RGB
      r AS INTEGER
      G AS INTEGER
      b AS INTEGER
      END TYPE
      TYPE RGBs
      r AS SINGLE
      G AS SINGLE
      b AS SINGLE
      END TYPE
      
      DECLARE FUNCTION CDDriveCheck% (drive%)
      DECLARE FUNCTION CDGetDrives$ ()
      DECLARE FUNCTION CDGetError$ (enum%)
      DECLARE FUNCTION CDGetStatus% ()
      DECLARE FUNCTION CDGetVersion% ()
      DECLARE FUNCTION CDctlI$ (drive%, info$)
      DECLARE FUNCTION Dec$ (Text$, newcode$)
      DECLARE FUNCTION Enc$ (Text$, newcode$)
      DECLARE SUB CDIAudio (drive%, chn0%, vol0%, chn1%, vol1%, chn2%, vol2%, chn3%, vol3%)
      DECLARE SUB CDIDoor (drive%, state%)
      DECLARE SUB CDIHead (drive%, sect&)
      DECLARE SUB CDIInfo (drive%, low%, high%)
      DECLARE SUB CDISize (drive%, lsect&)
      DECLARE SUB CDITrack (drive%, track%, start&, ttype%)
      DECLARE SUB CDOAudio (drive%, chn0%, vol0%, chn1%, vol1%, chn2%, vol2%, chn3%, vol3%)
      DECLARE SUB CDOClose (drive%)
      DECLARE SUB CDOLock (drive%, locked%)
      DECLARE SUB CDOOpen (drive%)
      DECLARE SUB CDRPlay (drive%, startSector&, playSectors&)
      DECLARE SUB CDRRead (drive%, ssect&, rsnum%, data$)
      DECLARE SUB CDRResume (drive%)
      DECLARE SUB CDRStop (drive%)
      DECLARE SUB CDRequest (drive%, req%, info$)
      DECLARE SUB CDctlO (drive%, info$)
      DECLARE SUB DrawBtn (b%, T%)
      DECLARE SUB DrawTime (X%, Y%, T%)
      DECLARE SUB Inter (IntNum%, Regs AS ANY)
      DECLARE SUB HSG2Red (min%, Sec%, frm%, HSG&)
      DECLARE SUB LoadRaw (tseg%, tptr%, inum%, wid%, hei%, nsbl%, nsel%, nsbi%, nsei%)
      DECLARE SUB MAdd (vseg%, vptr%, add%)
      DECLARE SUB MemDec (mseg%, mptr%, mlen%)
      DECLARE SUB Mouse (ax%, Bx%, cx%, dx%)        'Calls the mouse interrupt
      DECLARE SUB MouseActive (a%)                  'Installation check
      DECLARE SUB MouseBorders (x1%, y1%, x2%, y2%) 'Show mouse cursor
      DECLARE SUB MouseGetStat (b%, X%, Y%)         'Get mouse buttons and position
      DECLARE SUB MouseHideCursor ()                'Hide mouse cursor
      DECLARE SUB MouseReset ()                     'Reset mouse driver
      DECLARE SUB MouseSetMickey (X%, Y%)           'Define mickey:pixel ratio
      DECLARE SUB MouseSetXY (X%, Y%)               'Set mouse position
      DECLARE SUB MouseShowCursor ()                'Show mouse cursor
      DECLARE SUB NoMore ()
      DECLARE SUB Red2HSG (HSG&, min%, Sec%, frm%)
      DECLARE SUB SetPal (a%, r%, G%, b%)
      DECLARE SUB Shuffle (Text$)
      DECLARE SUB Sort (Text$)
      DECLARE SUB Vgatext (Text$, X%, Y%, Colr%, TSize%)

      DIM SHARED Regs AS RegTypeX, CDRStatus%
      '** Allocate momory
      DIM SHARED bpos(7) AS INTEGER
      DIM SHARED cursor(389) AS INTEGER
      DIM SHARED symbol(7817) AS INTEGER
      DIM SHARED button(5855) AS INTEGER
      DIM SHARED digits(912) AS INTEGER
      DIM SHARED textes(5263) AS INTEGER
      DIM SHARED textsm(5634) AS INTEGER
      DIM SHARED optntx(1607) AS INTEGER
      DIM SHARED volume(295) AS INTEGER
      

      REM Ŀ
      REM Ŀ
      REM                                                             
      REM  THE MEGA CD PLAYER                                         
      REM                                                             
      REM  Interface       : Davey T                                  
      REM  CD & mouse routs: Andrew G and Davey T                     
      REM  Beta testing    : Andrew G                                 
      REM                                                             
      REM  QBasic version  : bernt@figaro@swipnet.se                  
      REM  Contact         : Davey T : audio.squad@mailbox.swipnet.se 
      REM                    Andrew G: zapf_dingbat@juno.com          
      REM                                                             
      REM  Theese files belong to MCD:                                
      REM     Source:       Compiled:     Comment:                    
      REM     CDPROG.BAS    CDPROG.EXE    CD player                   
      REM     MCD2WAV.BAS   MCD2WAV.EXE   Track copy                  
      REM     MCD.DAT       MCD.DAT       Data file                   
      REM     MCD.CFG       MCD.CFG       Config. file                
      REM     MCDTEST.TXT   MCDTEST.TXT   Test results                
      REM     MCD.TXT       MCD.TXT       Info file                   
      REM ٳ
      REM 
      REM
      
      ON ERROR GOTO EH
      
      
      CLS : LOCATE , , 0
      
      PRINT "Welcome to The Mega CD! (MCD /? for help)"
      PRINT
      
      '** Version check MSCDEX
      Version% = CDGetVersion%
      IF Version% < 210 THEN PRINT "MSCDEX v2.1 or later has not been installed!": END
      PRINT "MSCDEX version:"; Version% / 100
      PRINT "Scanning for drives..."
      
      '** Get CD-ROM drive to use
      list$ = CDGetDrives$
      drives% = LEN(list$)
      IF drives% = 0 THEN PRINT "No CD-ROMs was found!": SLEEP 5: CLS : END
      IF drives% > 1 THEN
      PRINT "Found"; drives%; "CD-ROMs! Theese are: ";
      FOR n% = 1 TO drives%
      PRINT CHR$(ASC(MID$(list$, n%, 1)) + 65); " ";
      NEXT n%
      PRINT : PRINT "Please choose one: ";
      LOCATE , , 1
      DO
      drive% = ASC(UCASE$(INPUT$(1))) - 65
      IF drive% < 0 THEN drive% = 255
      LOOP UNTIL INSTR(list$, CHR$(drive%)) > 0
      LOCATE , , 0
      PRINT CHR$(drive% + 65)
      ELSE
      drive% = ASC(list$)
      PRINT "Found 1 CD-ROM's! Using "; CHR$(drive% + 65)
      s! = TIMER: DO: LOOP WHILE ABS(TIMER - s!) < .5
      END IF
      IF CDDriveCheck%(drive%) <> 0 THEN PRINT "This drive and/or MSCDEX is not working correctly!": END
      
      '** Check and reset mouse driver
      MouseActive a%
      IF a% = 0 THEN PRINT "Need a mouse to run!": END
      MouseReset
      
      '** Set screen mode 13h and clear palette
      SCREEN 13
      FOR n% = 0 TO 254
      SetPal n%, 0, 0, 0
      NEXT n%
      SetPal 255, 63, 63, 63
      COLOR 255: PRINT "Loading!"
      
      '** Read config
      OPEN "MCD.CFG" FOR BINARY ACCESS READ AS #1
      GET #1, , rmod%
      CLOSE #1
      
      '** Set mouse borders
      MouseBorders 0, 0, 607, 183
      
      
      '** Set button positions
      bpos(0) = 26: bpos(1) = 76: bpos(2) = 100: bpos(3) = 150
      bpos(4) = 174: bpos(5) = 198: bpos(6) = 222: bpos(7) = 272
      
      OPEN "mcd.dat" FOR BINARY ACCESS READ AS #1
      
      '** Load logo and screen
      LoadRaw &HA000, 0, 1, 180, 32, 70, 70, 0, 0
      LoadRaw &HA000, 0, 1, 318, 156, 1, 1, 10240, 0
      
      '** Load graphics into GET/PUT buffers
      LoadRaw VARSEG(digits(0)), VARPTR(digits(0)), 11, 9, 18, 0, 0, 4, 0
      LoadRaw VARSEG(button(0)), VARPTR(button(0)), 24, 22, 22, 0, 0, 4, 0
      LoadRaw VARSEG(textes(0)), VARPTR(textes(0)), 7, 75, 20, 0, 0, 4, 0
      LoadRaw VARSEG(textsm(0)), VARPTR(textsm(0)), 5, 75, 30, 0, 0, 4, 0
      LoadRaw VARSEG(symbol(0)), VARPTR(symbol(0)), 6, 51, 51, 0, 0, 4, 1
      LoadRaw VARSEG(cursor(0)), VARPTR(cursor(0)), 2, 16, 16, 0, 0, 4, 0
      LoadRaw VARSEG(optntx(0)), VARPTR(optntx(0)), 4, 50, 16, 0, 0, 4, 0
      LoadRaw VARSEG(volume(0)), VARPTR(volume(0)), 2, 12, 12, 0, 0, 4, 0
      CLOSE #1
      
      '** Set sizes of GET/PUT buffers
      FOR n% = 0 TO 5: symbol(n% * 1303) = 408: symbol(n% * 1303 + 1) = 51: NEXT n%
      FOR n% = 0 TO 23: button(n% * 244) = 176: button(n% * 244 + 1) = 22: NEXT n%
      FOR n% = 0 TO 2: cursor(n% * 130) = 128: cursor(n% * 130 + 1) = 16: NEXT n%
      FOR n% = 0 TO 10: digits(n% * 83) = 72: digits(n% * 83 + 1) = 18: NEXT n%
      FOR n% = 0 TO 6: textes(n% * 752) = 600: textes(n% * 752 + 1) = 20: NEXT n%
      FOR n% = 0 TO 4: textsm(n% * 1127) = 600: textsm(n% * 1127 + 1) = 30: NEXT n%
      FOR n% = 0 TO 3: optntx(n% * 402) = 400: optntx(n% * 402 + 1) = 16: NEXT n%
      FOR n% = 0 TO 3: volume(n% * 74) = 96: volume(n% * 74 + 1) = 12: NEXT n%
      
      '** Erase the loading text
      LINE (0, 0)-(63, 15), 0, BF
      
      '** Set palette
      FOR n% = 0 TO 63
      SetPal n%, n%, n%, n%
      NEXT n%
      FOR n% = 0 TO 63
      SetPal n% + 64, n% * 4, n% * 4, (n% / 64) * (n% \ 16)
      NEXT n%
      FOR n% = 0 TO 63
      SetPal n% + 192, n% \ 4, n% \ 4, n%
      NEXT n%
      
      '** Reset variables
      lmod% = -1: ltrack% = -1: lhigh% = -1
      limin% = -1: lisec% = -1: lifrm% = -1
      ltmin% = -1: ltsec% = -1: ltfrm% = -1
      lrmod% = -1: llvol% = -1: lrvol% = -1
      CDIAudio drive%, n%, lvol%, n%, rvol%, n%, n%, n%, n%
      
      '** Stuff...
      mxo% = 0: myo% = 0
      RANDOMIZE TIMER
      
      '** Main loop
      DO
      
      '** Get mouse position & buttons, sync to screen and erase old mouse cursor
      MouseGetStat mxp%, myp%, mbs%
      mxp% = (mxp% \ 2) MOD 304: myp% = myp% MOD 184
      WAIT &H3DA, 8: WAIT &H3DA, 1
      PUT (mxo%, myo%), cursor(260), PSET
      
      '** Get button number
      IF down% > 0 OR mbs% = 1 THEN
      btnp% = 0
      IF myp% > 115 AND myp% < 137 THEN
      FOR n% = 0 TO 7
      IF mxp% > bpos(n%) AND mxp% < bpos(n%) + 22 THEN btnp% = n% + 1
      NEXT n%
      END IF
      END IF
      
      '** Handle mouse button
      IF mbs% = 1 AND lmb% = 0 THEN
      IF btnp% > 0 THEN
      
      '** Buttons
      down% = btnp%
      ELSE
      IF myp% > 155 AND myp% < 172 AND mxp% > 30 AND mxp% < 140 THEN
      
      '** Direct click
      IF mxp% < 85 THEN
      rmod% = rmod% XOR 1
      IF rmod% AND 1 THEN Shuffle list$ ELSE Sort list$
      ELSE
      rmod% = rmod% XOR 2
      END IF
      ELSEIF myp% > 147 AND myp% < 159 THEN
      
      '** Scroll bars
      xpos% = 177 + lvol% / 2.48
      IF mxp% > xpos% + 0 AND mxp% < xpos% + 12 THEN vctl% = 1
      ELSEIF myp% > 166 AND myp% < 189 THEN
      xpos% = 177 + rvol% / 2.48
      IF mxp% > xpos% + 0 AND mxp% < xpos% + 12 THEN vctl% = 2
      END IF
      END IF
      ELSEIF mbs% = 0 AND lmb% = 1 THEN
      IF down% > 0 THEN
      DrawBtn down% - 1, 0
      IF btnp% = down% THEN bclick% = down%
      END IF
      down% = 0: btnp% = 0
      END IF
      lmb% = mbs%
      
      '** Handle scrollbars
      IF vctl% THEN
      IF mbs% = 1 THEN
      IF vctl% = 1 THEN
      lvol% = ((mxp% - 5) - 177) * 2.48
      IF lvol% < 0 THEN lvol% = 0
      IF lvol% > 255 THEN lvol% = 255
      ELSE
      rvol% = ((mxp% - 5) - 177) * 2.48
      IF rvol% < 0 THEN rvol% = 0
      IF rvol% > 255 THEN rvol% = 255
      END IF
      ELSEIF mbs% = 2 OR mbs% = 3 THEN
      lvol% = ((mxp% - 5) - 177) * 2.48
      IF lvol% < 0 THEN lvol% = 0
      IF lvol% > 255 THEN lvol% = 255
      rvol% = lvol%
      ELSE
      vctl% = 0
      END IF
      END IF
      
      '** Check enabled
      IF down% > 0 THEN
      IF (enable% AND 2 ^ (down% - 1)) = 0 THEN down% = 0
      END IF
      
      '** Draw button
      IF lbtn% <> btnp% THEN
      IF down% > 0 THEN
      IF btnp% = down% THEN DrawBtn down% - 1, 1 ELSE DrawBtn down% - 1, 0
      END IF
      lbtn% = btnp%
      END IF
      
      '** Update message, symbols and buttons
      IF mode% <> lmod% THEN
      SELECT CASE mode%
      CASE 0 '* NO CD
      sym% = (1) + (0) * 8 + (3) * 64 + (6) * 512: enable% = 128
      CASE 1 '* PLAY
      sym% = (3) + (2) * 8 + (0) * 64 + (5) * 512: enable% = 254
      CASE 2 '* PAUSE
      sym% = (4) + (2) * 8 + (1) * 64 + (8) * 512: enable% = 207
      CASE 3 '* STOP
      sym% = (5) + (2) * 8 + (2) * 64 + (3) * 512: enable% = 201
      CASE 4 '* DATA
      sym% = (2) + (1) * 8 + (4) * 64 + (13) * 512: enable% = 200
      CASE 5 '* ERROR
      sym% = (0) + (0) * 8 + (4) * 64 + (11) * 512: enable% = 0
      CASE 6 '* SEARCH
      sym% = (6) + (4) * 8 + (5) * 64 + (9) * 512
      END SELECT
      IF mode% > 0 AND mode% < 4 AND ttype% = 2 THEN sym% = sym% + 8
      PUT (169, 50), textes((sym% AND 7) * 752), PSET
      PUT (169, 70), textsm(((sym% AND 56) \ 8) * 1127), PSET
      PUT (251, 50), symbol(((sym% AND 448) \ 64) * 1303), PSET
      IF enable% <> lenable% THEN
      FOR n% = 0 TO 7
      IF enable% AND 2 ^ n% THEN DrawBtn n%, 0 ELSE DrawBtn n%, 2
      NEXT n%
      lenable% = enable%
      END IF
      pmod% = (sym% AND 7680) \ 512: lmod% = mode%
      END IF
      
      '** Update track and time
      IF track% <> ltrack% THEN DrawTime 85, 49, track%: ltrack% = track%
      IF high% <> lhigh% THEN DrawTime 130, 49, high%: lhigh% = high%
      IF imin% <> limin% THEN DrawTime 85, 67, imin%: limin% = imin%
      IF isec% <> lisec% THEN DrawTime 112, 67, isec%: lisec% = isec%
      IF ifrm% <> lifrm% THEN DrawTime 459, 67, ifrm%: lifrm% = ifrm%
      IF tmin% <> ltmin% THEN DrawTime 85, 85, tmin%: ltmin% = tmin%
      IF tsec% <> ltsec% THEN DrawTime 112, 85, tsec%: ltsec% = tsec%
      IF tfrm% <> ltfrm% THEN DrawTime 459, 85, tfrm%: ltfrm% = tfrm%
      
      '** Update rep modes
      IF rmod% <> lrmod% THEN
      PUT (30, 156), optntx((rmod% AND 1) * 402), PSET
      PUT (90, 156), optntx(804 + (rmod% AND 2) * 201), PSET
      lrmod% = rmod%
      END IF
      
      '** Update volume bars and volume
      IF lvol% <> llvol% OR rvol% <> lrvol% THEN
      CDOAudio drive%, 0, lvol%, 1, rvol%, 2, lvol%, 3, rvol%
      IF lvol% <> llvol% THEN
      IF llvol% >= 0 THEN
      xpos% = 177 + llvol% / 2.48
      PUT (xpos%, 148), volume(148), PSET
      END IF
      xpos% = 177 + lvol% / 2.48
      GET (xpos%, 148)-(xpos% + 11, 159), volume(148)
      PUT (xpos%, 148), volume(74), AND
      PUT (xpos%, 148), volume(0), OR
      llvol% = lvol%
      END IF
      IF rvol% <> lrvol% THEN
      IF lrvol% >= 0 THEN
      xpos% = 177 + lrvol% / 2.48
      PUT (xpos%, 167), volume(222), PSET
      END IF
      xpos% = 177 + rvol% / 2.48
      GET (xpos%, 167)-(xpos% + 11, 178), volume(222)
      PUT (xpos%, 167), volume(74), AND
      PUT (xpos%, 167), volume(0), OR
      lrvol% = rvol%
      END IF
      END IF
      
      '** Draw new cursor
      GET (mxp%, myp%)-(mxp% + 15, myp% + 15), cursor(260)
      PUT (mxp%, myp%), cursor(130), AND
      PUT (mxp%, myp%), cursor(0), OR
      mxo% = mxp%: myo% = myp%
      
      '** Change the palette (192 to 255)
      s% = (s% + 1) MOD 63
      IF s% > 31 THEN I% = 63 - (s% - 32) * 2 ELSE I% = s% * 2
      FOR n% = 0 TO 63
      IF pmod% AND 1 THEN
      I% = 63 - ((s% + n%) MOD 63) * 2
      IF I% < 0 THEN I% = 0
      END IF
      SetPal n% + 128, I% * (pmod% AND 2) \ 2, I% * (pmod% AND 4) \ 4, I% * (pmod% AND 8) \ 8
      NEXT n%
      
      '** Check status
      CDIDoor drive%, state%
      
      '** Check CD status
      IF (state% AND 1) = 0 AND (mode% = 0 OR mode% = 5) THEN
      CDISize drive%, cdsize&
      Status% = CDGetStatus%
      IF (Status% AND 255) > 0 THEN state% = 1: mode% = 5 ELSE mode% = 0
      ELSEIF (state% AND 1) = 1 AND mode% = 5 THEN
      Status% = CDGetStatus%
      IF (Status% AND 255) = 0 THEN mode% = 0
      END IF
      
      IF state% AND 1 THEN
      
      '** Handle tray open
      IF mode% <> 0 AND mode% <> 5 THEN
      mode% = 0
      END IF
      IF bclick% = 8 THEN
      CDOClose drive%
      END IF
      bclick% = 0
      ELSE
      
      '** Handle everything else
      IF mode% = 0 THEN
      mode% = 3: ltrk% = -1
      
      '** Scan CD
      CDIInfo drive%, low%, high%: track% = low%
      REDIM tracks(low% TO high%) AS TrackType
      CDISize drive%, cdsize&: last& = cdsize&: list$ = ""
      FOR n% = high% TO low% STEP -1
      CDITrack drive%, n%, sect&, ttype%
      tracks(n%).sector = sect&
      tracks(n%).length = last& - sect&
      tracks(n%).ttype = ttype%
      last& = sect&
      IF ttype% <> 1 THEN list$ = list$ + CHR$(n%)
      NEXT n%
      IF rmod% AND 1 THEN Shuffle list$ ELSE Sort list$
      END IF
      
      '** Handle key presses
      IF down% = 5 OR down% = 6 THEN
      IF ldown% = 0 THEN CDRStop drive%: mode% = 6: ldown% = down%: sspd% = 0
      IF btnp% = down% THEN
      sspd% = sspd% + 1: IF sspd% = 751 THEN sspd% = 750
      IF down% = 5 THEN hpos& = hpos& - (sspd% \ 10) ELSE hpos& = hpos& + (sspd% \ 10)
      ELSEIF sspd% > 0 THEN
      sspd% = 0
      END IF
      IF hpos& > cdsize& - 1 THEN hpos& = tracks(1).sector
      IF hpos& < tracks(1).sector THEN hpos& = cdsize& - 1
      ELSEIF down% = 0 AND (ldown% = 5 OR ldown% = 6) THEN
      IF ttype% = 1 THEN
      imin% = 0: isec% = 0: ifrm% = 0
      mode% = 4
      ELSE
      CDRPlay drive%, hpos&, tracks(track%).sector + tracks(track%).length - hpos&
      mode% = 1
      END IF
      ldown% = 0
      END IF
      
      '** Handle key clicks
      IF bclick% > 0 THEN
      SELECT CASE bclick%
      CASE 1 '* PLAY
      IF mode% = 3 THEN
      CDRPlay drive%, tracks(track%).sector, tracks(track%).length - 1
      ELSEIF mode% = 2 THEN
      CDRResume drive%
      END IF
      mode% = 1
      CASE 2 '* PAUSE
      IF mode% = 1 THEN
      CDRStop drive%
      mode% = 2
      ELSEIF mode% = 2 THEN
      CDRResume drive%
      mode% = 1
      END IF
      CASE 3 '* STOP
      IF mode% = 1 THEN CDRStop drive%
      mode% = 3
      CASE 4 '* PREVIOUS
      IF high% <> low% THEN
      IF (imin% OR isec%) = 0 AND ifrm% < 5 THEN
      track% = track% - 1
      IF track% < low% THEN track% = high%
      END IF
      IF mode% = 1 THEN
      CDRPlay drive%, tracks(track%).sector, tracks(track%).length - 1
      ELSE
      mode% = 3
      END IF
      END IF
      CASE 7 '* NEXT
      IF high% <> low% THEN
      track% = track% + 1
      IF track% > high% THEN track% = low%
      IF mode% = 1 THEN
      CDRPlay drive%, tracks(track%).sector, tracks(track%).length - 1
      ELSE
      mode% = 3
      END IF
      END IF
      CASE 8 '* EJECT
      CDOOpen drive%
      END SELECT
      bclick% = 0
      END IF
      
      '** Calculate track time
      IF mode% = 1 OR mode% = 6 THEN
      IF mode% = 1 THEN CDIHead drive%, hpos&
      FOR track% = high% TO low% STEP -1
      IF hpos& >= tracks(track%).sector THEN EXIT FOR
      NEXT track%
      IF track% < low% THEN track% = low%
      tpos& = hpos& - tracks(track%).sector
      HSG2Red imin%, isec%, ifrm%, tpos&: ifrm% = ifrm% \ 7.5
      ELSEIF mode% = 3 THEN
      imin% = 0: isec% = 0: ifrm% = 0
      END IF
      
      '** Handle track info (length, type, etc...)
      IF track% <> ltrk% THEN
      tlen& = tracks(track%).length
      ltrk% = track%
      ttype% = tracks(track%).ttype
      HSG2Red tmin%, tsec%, tfrm%, tlen&: tfrm% = tfrm% \ 7.5
      IF ttype% = 1 AND mode% <> 6 THEN
      IF mode% = 1 THEN
      track% = track% + 1: ltrk% = track%
      IF track% > high% THEN track% = low%
      CDRPlay drive%, tracks(track%).sector, tracks(track%).length - 1
      ELSE
      mode% = 4
      END IF
      END IF
      END IF
      
      Status% = CDGetStatus%
      
      '** Turn on playback if CD is playing and no error has occured
      IF mode% <> 1 AND mode% <> 6 AND (Status% AND 767) = 512 THEN
      mode% = 1: CDIHead drive%, hpos&
      FOR track% = high% TO low% STEP -1
      IF hpos& >= tracks(track%).sector THEN EXIT FOR
      NEXT track%
      IF track% < low% THEN track% = low%
      CDRPlay drive%, hpos&, tracks(track%).sector + tracks(track%).length - hpos&
      END IF
      
      '** Turn off playback if CD is not playing or handle next track
      IF mode% = 1 AND (Status% AND 512) = 0 THEN
      IF hpos& < tracks(track%).sector + 75 AND track% > low% THEN track% = track% - 1
      endoftrk& = tracks(track%).sector + tracks(track%).length
      IF hpos& > endoftrk& - 150 AND hpos& <= endoftrk& THEN
      trk% = INSTR(list$, CHR$(track%))
      trk% = trk% + 1
      IF trk% > LEN(list$) THEN
      trk% = 1
      track% = ASC(MID$(list$, trk%, 1))
      IF rmod% AND 2 THEN CDRPlay drive%, tracks(track%).sector, tracks(track%).length - 1 ELSE mode% = 3
      ELSE
      track% = ASC(MID$(list$, trk%, 1))
      CDRPlay drive%, tracks(track%).sector, tracks(track%).length - 1
      END IF
      ELSE
      mode% = 3
      END IF
      END IF
      
      '** Error
      IF (Status% AND 255) > 0 THEN mode% = 5
      END IF
      LOOP UNTIL INKEY$ = CHR$(27)
      
      '** Play to end of cd on quit
      IF mode% = 1 THEN CDRPlay drive%, hpos&, cdsize& - hpos&
      
      '** Write config
      OPEN "MCD.CFG" FOR BINARY ACCESS WRITE AS #1
      PUT #1, , rmod%
      CLOSE #1
      
      NoMore
      END
      
EH:
      WIDTH 80, 25: CLS
      PRINT "Fatal error - quitting!"
      END

REM $STATIC
      FUNCTION CDctlI$ (drive%, info$)
      REM
      REM Ŀ
      REM  CDxtlI    Inputs data from the CD-ROM device driver using IOCTL 
      REM  In:                                                             
      REM   drive%   Specifies the drive number (0=A)                      
      REM   info$    Data to output                                        
      REM  Out:                                                            
      REM   Returns  Modified info$ string                                 
      REM 
      REM
      
      io$ = CHR$(0)                                 'Media descriptior (0)
      io$ = io$ + MKI$(SADD(info$))                 'Offset of IOCTL data
      io$ = io$ + MKI$(VARSEG(info$))               'Segment of IOCTL data
      io$ = io$ + MKI$(LEN(info$))                  'Bytes to transfer
      io$ = io$ + MKI$(0)                           'Starting sector number (0)
      io$ = io$ + MKL$(0)                           'Volume ID (0)
      CDRequest drive%, 3, io$                      'Call function 3 (IOCTL read)
      CDctlI$ = info$
      END FUNCTION

      SUB CDctlO (drive%, info$)
      REM
      REM Ŀ
      REM  CDxtlO   Outputs data to the CD-ROM device driver using IOCTL 
      REM  In:                                                           
      REM   drive%  Specifies the drive number (0=A)                     
      REM   info$   Data to output                                       
      REM 
      REM
      io$ = CHR$(0)                                 'Media descriptior (0)
      io$ = io$ + MKI$(SADD(info$))                 'Offset of IOCTL data
      io$ = io$ + MKI$(VARSEG(info$))               'Segment of IOCTL data
      io$ = io$ + MKI$(LEN(info$))                  'Bytes to transfer
      io$ = io$ + MKI$(0)                           'Starting sector number (0)
      io$ = io$ + MKL$(0)                           'Volume ID (0)
      CDRequest drive%, 12, io$                     'Call function 14 (IOCTL write)
      END SUB

      FUNCTION CDDriveCheck% (drive%)
      REM
      REM Ŀ
      REM  CDDriveCheck%  Checks whether a drive is a valid CD-ROM            
      REM                 drive or not                                        
      REM  In:                                                                
      REM   drive%        Specifies the drive number (0=A)                    
      REM  Out:                                                               
      REM   Returns 0     MSCDEX is installed and this drive is supported     
      REM   Returns 1     MSCDEX is installed but this drive is not supported 
      REM   Returns 2     MCCDEX is not installed                             
      REM 
      REM
      Regs.ax = &H150B                   'Drive Check
      Regs.cx = drive%                   'Drive number (0=A)
      CALL Inter(&H2F, Regs)             'Call the interrupt
      IF Regs.Bx = &HADAD THEN
      CDDriveCheck% = 0                 'Might be needed
      IF Regs.ax = 0 THEN CDDriveCheck% = 1
      ELSE
      CDDriveCheck% = 2
      END IF
      END FUNCTION

      FUNCTION CDGetDrives$
      REM
      REM Ŀ
      REM  CDGetDrives$         Find CD-ROM drives                       
      REM   Out:                                                         
      REM    Returns            String containing the CD-ROM drive list  
      REM 
      REM
      
      Regs.ax = &H1500                   'Installation check
      Regs.Bx = 0
      CALL Inter(&H2F, Regs)  'Call the interrupt
      list$ = SPACE$(Regs.Bx)
      Regs.ax = &H150D                   'Get drive letters
      Regs.es = VARSEG(list$): Regs.Bx = SADD(list$)
      CALL Inter(&H2F, Regs)  'Call the interrupt
      CDGetDrives$ = list$
      END FUNCTION

      FUNCTION CDGetError$ (enum%)
      REM
      REM Ŀ
      REM  CDGetError$          Get error from error num             
      REM   In:                                                      
      REM    enum%              Specifies the error number (0 to 17) 
      REM   Out:                                                     
      REM    Returns            Error text                           
      REM 
      REM
      
      SELECT CASE enum%
      CASE 0: e$ = "No error"
      CASE 1: e$ = "Write protect violation"
      CASE 2: e$ = "Unknown unit"
      CASE 3: e$ = "Drive not ready"
      CASE 4: e$ = "Unknown command"
      CASE 5: e$ = "CRC error"
      CASE 6: e$ = "Bad request structure length"
      CASE 7: e$ = "Seek error"
      CASE 8: e$ = "Unknown media"
      CASE 9: e$ = "Sector not found"
      CASE 10: e$ = "Out of paper"
      CASE 11: e$ = "Write fault"
      CASE 12: e$ = "Read fault"
      CASE 13: e$ = "General failure"
      CASE 14, 15: e$ = "Unknown"
      CASE 16: e$ = "Invalid disk change"
      CASE 17: e$ = "Multiple errors has occured"
      END SELECT
      CDGetError$ = e$
      END FUNCTION

      FUNCTION CDGetStatus%
      REM
      REM Ŀ
      REM  CDGetStatus          Get CD status          
      REM   Out:                                       
      REM    Returns            Status and error code  
      REM 
      REM
      
      'IF INT(TIMER / 4) AND 1 THEN CDRStatus% = CDRStatus% OR 1 'Error check
      CDGetStatus% = CDRStatus%
      CDRStatus% = 0
      END FUNCTION

      FUNCTION CDGetVersion%
      REM
      REM Ŀ
      REM  CDGetVersion         Checks MSCDEX version           
      REM   Out:                                                
      REM    Returns            MSCDEX version                  
      REM 
      REM
      
      Regs.ax = &H150C                   'Version check
      CALL Inter(&H2F, Regs)  'Call the interrupt
      CDGetVersion% = (Regs.Bx AND 255) + (Regs.Bx \ 256) * 100
      END FUNCTION

      SUB CDIAudio (drive%, chn0%, vol0%, chn1%, vol1%, chn2%, vol2%, chn3%, vol3%)
      REM
      REM Ŀ
      REM  CDIAudio          IOCTL input: get volumes                       
      REM   In:                                                             
      REM    drive%          Specifies the drive number (0=A)               
      REM   Out:                                                            
      REM    chn0% to chn3%  Returns the in channels for out channel 0 to 3 
      REM    vol0% to vol3%  Returns the volume for out channel 0 to 3      
      REM 
      REM
      
      ctl$ = CHR$(4)                                'IOCTL function 4 (volume chan)
      ctl$ = ctl$ + SPACE$(8)                       'Space for return info
      ctl$ = CDctlI$(drive%, ctl$)
      chn0% = ASC(MID$(ctl$, 2, 1)): vol0% = ASC(MID$(ctl$, 3, 1))
      chn1% = ASC(MID$(ctl$, 4, 1)): vol1% = ASC(MID$(ctl$, 5, 1))
      chn2% = ASC(MID$(ctl$, 6, 1)): vol2% = ASC(MID$(ctl$, 7, 1))
      chn3% = ASC(MID$(ctl$, 8, 1)): vol3% = ASC(MID$(ctl$, 9, 1))
      END SUB

      SUB CDIDoor (drive%, state%)
      REM
      REM Ŀ
      REM  CDIDoor              IOCTL input: get door status
      REM   In:
      REM    drive%             Specifies the drive number (0=A)
      REM   Out:
      REM    state% bit 0       0 door closed, 1 door open
      REM    state% bit 1       0 door unlocked, 1 door locked
      REM 
      REM
      
      ctl$ = CHR$(6)                                'IOCTL function 6 (device stat)
      ctl$ = ctl$ + MKL$(0)                         'Space for return info
      ctl$ = CDctlI$(drive%, ctl$)
      state% = (ASC(MID$(ctl$, 2, 1)) AND 3)
      IF (state% AND 1) THEN state% = state% AND 1
      END SUB

      SUB CDIHead (drive%, sect&)
      REM
      REM Ŀ
      REM  CDIHead              IOCTL input: get curremt head position
      REM   In:
      REM    drive%             Specifies the drive number (0=A)
      REM   Out:
      REM    sect&              Current sector
      REM 
      REM
      
      ctl$ = CHR$(1)                                'IOCTL function 1  (head loc)
      ctl$ = ctl$ + CHR$(0)
      ctl$ = ctl$ + SPACE$(4)                       'Space for return info
      ctl$ = CDctlI$(drive%, ctl$)                  'Get status get the right bits
      sect& = CVL(MID$(ctl$, 3, 4))
      END SUB

      SUB CDIInfo (drive%, low%, high%)
      REM
      REM Ŀ
      REM  CDIInfo              IOCTL input: get audio cd info    
      REM   In:                                                   
      REM    drive%             Specifies the drive number (0=A)  
      REM   Out:                                                  
      REM    low%               Lowest track number               
      REM    high%              Highest track number              
      REM 
      REM
      
      ctl$ = CHR$(10)                               'IOCTL function 10 (disk info)
      ctl$ = ctl$ + SPACE$(6)                       'Space for return info
      ctl$ = CDctlI$(drive%, ctl$)
      low% = ASC(MID$(ctl$, 2, 1))                  'Get return info
      high% = ASC(MID$(ctl$, 3, 1))
      END SUB

      SUB CDISize (drive%, lsect&)
      REM
      REM Ŀ
      REM  CDISize              IOCTL input: get volume size       
      REM   In:                                                    
      REM    drive%             Specifies the drive number (0=A)   
      REM   Out:                                                   
      REM    lsect&             Volume size (last sector)          
      REM 
      REM
      
      ctl$ = CHR$(8)                                'IOCTL function 8 (vol size)
      ctl$ = ctl$ + SPACE$(4)                       'Space for return info
      ctl$ = CDctlI$(drive%, ctl$)
      lsect& = CVL(MID$(ctl$, 2, 4)) - 150
      END SUB

      SUB CDITrack (drive%, track%, start&, ttype%)
      REM
      REM Ŀ
      REM  CDITrack             IOCTL input: get track information       
      REM   In:                                                          
      REM    drive%             Specifies the drive number (0=A)         
      REM    track%             Which track to get info from             
      REM   Out:                                                         
      REM    start&             Start position of this track             
      REM    ttype%             0 audio stereo, 1 data, 2 audio surround 
      REM 
      REM
      
      ctl$ = CHR$(11)                               'IOCTL function 11 (track info)
      ctl$ = ctl$ + CHR$(track%)
      ctl$ = ctl$ + SPACE$(5)                       'Space for return info
      ctl$ = CDctlI$(drive%, ctl$)
      Red2HSG start&, ASC(MID$(ctl$, 5, 1)), ASC(MID$(ctl$, 4, 1)), ASC(MID$(ctl$, 3, 1))
      ttype% = (ASC(MID$(ctl$, 7, 1)) AND 192) / 48
      END SUB

      SUB CDOAudio (drive%, chn0%, vol0%, chn1%, vol1%, chn2%, vol2%, chn3%, vol3%)
      REM
      REM Ŀ
      REM  CDOAudio             IOCTL output: set volumes                   
      REM   In:                                                             
      REM    drive%             Specifies the drive number (0=A)            
      REM   Out:                                                            
      REM    chn0% to chn3%     Sets the in channels for out channel 0 to 3 
      REM    vol0% to vol3%     Sets the volume for out channel 0 to 3      
      REM 
      REM
      
      ctl$ = CHR$(3)                                'IOCTL function 4 (volume chan)
      ctl$ = ctl$ + CHR$(chn0%) + CHR$(vol0%)
      ctl$ = ctl$ + CHR$(chn1%) + CHR$(vol1%)
      ctl$ = ctl$ + CHR$(chn2%) + CHR$(vol2%)
      ctl$ = ctl$ + CHR$(chn3%) + CHR$(vol3%)
      CDctlO drive%, ctl$
      END SUB

      SUB CDOClose (drive%)
      REM
      REM Ŀ
      REM  CDOClose             IOCTL output: close the CD-ROM tray 
      REM   In:                                                     
      REM    drive%             Specifies the drive number (0=A)    
      REM 
      REM
      
      CDctlO drive%, CHR$(5)                        'IOCTL function 5 (close tray)
      END SUB

      SUB CDOLock (drive%, locked%)
      REM
      REM Ŀ
      REM  CDOLock              IOCTL output: lock/unlock the CD-ROM tray 
      REM   In:                                                           
      REM    drive%             Specifies the drive number (0=A)          
      REM    locked%            Cero unlocks the tray, noncero locks it   
      REM 
      REM
      
      ctl$ = CHR$(1)                                'IOCTL function 1 (lock door)
      IF locked% THEN ctl$ = ctl$ + CHR$(1) ELSE ctl$ = ctl$ + CHR$(0)
      CDctlO drive%, ctl$
      END SUB

      SUB CDOOpen (drive%)
      REM
      REM Ŀ
      REM  CDOOpen              IOCTL output: open the CD-ROM tray 
      REM   In:                                                    
      REM    drive%             Specifies the drive number (0=A)   
      REM 
      REM
      
      CDctlO drive%, CHR$(0)                        'IOCTL function 0 (open tray)
      END SUB

      SUB CDRequest (drive%, req%, info$)
      REM
      REM Ŀ
      REM  CDRequest            Makes a request to MSCDEX        
      REM   In:                                                  
      REM    drive%             Specifies the drive number (0=A) 
      REM    req%               Request code                     
      REM    info$              Request information              
      REM 
      REM
      
      Regs.ax = &H1510
      Regs.cx = drive%
      request$ = CHR$(13) + CHR$(0) + CHR$(req%) + SPACE$(10) + info$
      Regs.es = VARSEG(request$): Regs.Bx = SADD(request$)
      CALL Inter(&H2F, Regs)  'Call the interrupt
      
      stat% = CVI(MID$(request$, 4, 2))
      IF stat% AND -32768 THEN
      IF CDRStatus% AND 255 THEN
      CDRStatus% = 17
      ELSE
      CDRStatus% = (stat% AND 255) + 1
      END IF
      ELSE
      CDRStatus% = 0
      END IF
      CDRStatus% = CDRStatus% + (stat% AND 768)
      END SUB

      SUB CDRFetch (drive%, ssect&, rsnum%)
      REM
      REM Ŀ
      REM  CDRFetch$            Request: prefetch sectors        
      REM   In:                                                  
      REM    drive%             Specifies the drive number (0=A) 
      REM    ssect&             Starting sector                  
      REM    rsnum%             Number of sector to read         
      REM 
      REM
      
      io$ = CHR$(0)                                'Set adressing mode to HSG
      io$ = io$ + MKL$(0)                          'Transfer adress (not used)
      io$ = io$ + MKI$(rsnum%)                     'Number of sectors to prefetch
      io$ = io$ + MKL$(ssect&)                     'Starting sector number
      io$ = io$ + CHR$(1)                          'Set data read mode to raw
      io$ = io$ + CHR$(0)                          'Set interleave size to 0
      io$ = io$ + CHR$(0)                          'Set interleave skip factor to 0
      CDRequest drive%, 130, io$                   'Call function 130 (prefetch)
      END SUB

      SUB CDRPlay (drive%, startSector&, playSectors&)
      REM
      REM Ŀ
      REM  CDRPlay              Request: play audio              
      REM   In:                                                  
      REM    drive%             Specifies the drive number (0=A) 
      REM    startSector&       Where to begin playing           
      REM    playSectors&       How many sectors to play         
      REM 
      REM
      
      cdr$ = CHR$(0)                                'Set adressing mode to HSG
      cdr$ = cdr$ + MKL$(startSector&)              'Set start sector
      cdr$ = cdr$ + MKL$(playSectors&)              'Set number of sectors to play
      CDRequest drive%, 132, cdr$                   'Call function 132 (play)
      END SUB

      SUB CDRRead (drive%, ssect&, rsnum%, data$)
      REM
      REM Ŀ
      REM  CDRRead$             Request: read sectors             
      REM   In:                                                   
      REM    drive%             Specifies the drive number (0=A)  
      REM    ssect&             Starting sector                   
      REM    rsnum%             Number of sector to read          
      REM   Out:                                                  
      REM    data$              Read sectors                      
      REM 
      REM
      
      IF LEN(data$) < 2352 * rsnum% THEN EXIT SUB
      io$ = CHR$(0)                                'Set adressing mode to HSG
      io$ = io$ + MKI$(SADD(data$))                'Offset of sector buffer
      io$ = io$ + MKI$(VARSEG(data$))              'Segment of sector buffer
      io$ = io$ + MKI$(rsnum%)                     'Number of sectors to read
      io$ = io$ + MKL$(ssect&)                     'Starting sector number
      io$ = io$ + CHR$(1)                          'Set data read mode to raw
      io$ = io$ + CHR$(0)                          'Set interleave size to 0
      io$ = io$ + CHR$(0)                          'Set interleave skip factor to 0
      CDRequest drive%, 128, io$                   'Call function 128 (read long)
      END SUB

      SUB CDRResume (drive%)
      REM
      REM Ŀ
      REM  CDRResume            Request: resume playing audio    
      REM   In:                                                  
      REM    drive%             Specifies the drive number (0=A) 
      REM 
      REM
      
      CDRequest drive%, 136, ""                     'Call function 136 (resume)
      END SUB

      SUB CDRStop (drive%)
      REM
      REM Ŀ
      REM  CDRStop              Request: stop playing audio      
      REM   In:                                                  
      REM    drive%             Specifies the drive number (0=A) 
      REM 
      REM
      
      CDRequest drive%, 133, ""                     'Call function 133 (stop)
      END SUB

      SUB DrawBtn (b%, T%)
      PUT (bpos(b%), 115), button((b% + 8 * T%) * 244), PSET
      END SUB

      SUB DrawTime (X%, Y%, T%)
      IF X% > 319 THEN
      X% = X% - 320
      IF min% >= 0 AND T% <= 9 THEN
      PUT (X%, Y%), digits(83 * (T% MOD 10)), PSET
      ELSE
      PUT (X%, Y%), digits(996), PSET
      END IF
      ELSE
      IF min% >= 0 AND T% <= 99 THEN
      PUT (X%, Y%), digits(83 * (T% \ 10)), PSET
      PUT (X% + 9, Y%), digits(83 * (T% MOD 10)), PSET
      ELSE
      PUT (X%, Y%), digits(996), PSET
      PUT (X% + 9, Y%), digits(996), PSET
      END IF
      END IF
      END SUB

      SUB HSG2Red (min%, Sec%, frm%, HSG&)
      IF HSG& <= 445500 AND HSG& >= 0 THEN
      frm% = HSG& MOD 75
      Sec% = (HSG& MOD 4500) \ 75
      min% = HSG& \ 4500
      ELSE
      frm% = -1
      END IF
      END SUB

DEFINT A-Z
      SUB Inter (IntNum%, Regs AS RegTypeX) STATIC
      REM
      REM Ŀ
      REM  Task: Do Bios routines with interrupt routines 
      REM  PARAMETERS                                     
      REM  IntNum%  - Interrupt number                    
      REM  Regs     - User defined variable               
      REM 
      REM
      
      STATIC FileNum, IntOffset, Loaded
      
      IF NOT Loaded THEN                        ' Loaded = 0 (First time)
      IntCode$ = SPACE$(160)
      FOR I% = 0 TO 39
      SELECT CASE I%
      CASE 0: MID$(IntCode$, 1, 4) = MKL$(-2081649835)
      CASE 1: MID$(IntCode$, 5, 4) = MKL$(1465256172)
      CASE 2: MID$(IntCode$, 9, 4) = MKL$(1586189598)
      CASE 3: MID$(IntCode$, 13, 4) = MKL$(273124102)
      CASE 4: MID$(IntCode$, 17, 4) = MKL$(1979711293)
      CASE 5: MID$(IntCode$, 21, 4) = MKL$(1200561668)
      CASE 6: MID$(IntCode$, 25, 4) = MKL$(306678544)
      CASE 7: MID$(IntCode$, 29, 4) = MKL$(1979711293)
      CASE 8: MID$(IntCode$, 33, 4) = MKL$(1200561668)
      CASE 9: MID$(IntCode$, 37, 4) = MKL$(138906386)
      CASE 10: MID$(IntCode$, 41, 4) = MKL$(-1946663287)
      CASE 11: MID$(IntCode$, 45, 4) = MKL$(72321799)
      CASE 12: MID$(IntCode$, 49, 4) = MKL$(-1962518645)
      CASE 13: MID$(IntCode$, 53, 4) = MKL$(2139818615)
      CASE 14: MID$(IntCode$, 57, 4) = MKL$(309853964)
      CASE 15: MID$(IntCode$, 61, 4) = MKL$(41418503)
      CASE 16: MID$(IntCode$, 65, 4) = MKL$(-96039138)
      CASE 17: MID$(IntCode$, 69, 4) = MKL$(521172991)
      CASE 18: MID$(IntCode$, 73, 4) = MKL$(1543007883)
      CASE 19: MID$(IntCode$, 77, 4) = MKL$(-1957355059)
      CASE 20: MID$(IntCode$, 81, 4) = MKL$(40799212)
      CASE 21: MID$(IntCode$, 85, 4) = MKL$(-1946394999)
      CASE 22: MID$(IntCode$, 89, 4) = MKL$(-1893857698)
      CASE 23: MID$(IntCode$, 93, 4) = MKL$(1996488262)
      CASE 24: MID$(IntCode$, 97, 4) = MKL$(126427130)
      CASE 25: MID$(IntCode$, 101, 4) = MKL$(-1979955573)
      CASE 26: MID$(IntCode$, 105, 4) = MKL$(1334379079)
      CASE 27: MID$(IntCode$, 109, 4) = MKL$(106400004)
      CASE 28: MID$(IntCode$, 113, 4) = MKL$(138905944)
      CASE 29: MID$(IntCode$, 117, 4) = MKL$(-1995802743)
      CASE 30: MID$(IntCode$, 121, 4) = MKL$(-1885598593)
      CASE 31: MID$(IntCode$, 125, 4) = MKL$(-1895428537)
      CASE 32: MID$(IntCode$, 129, 4) = MKL$(1183519303)
      CASE 33: MID$(IntCode$, 133, 4) = MKL$(273123838)
      CASE 34: MID$(IntCode$, 137, 4) = MKL$(1583292250)
      CASE 35: MID$(IntCode$, 141, 4) = MKL$(-899816053)
      CASE 36: MID$(IntCode$, 145, 4) = MKL$(2&)
      CASE 37: MID$(IntCode$, 149, 4) = MKL$(0&)
      CASE 38: MID$(IntCode$, 153, 4) = MKL$(0&)
      CASE 39: MID$(IntCode$, 157, 4) = MKL$(0&)
      CASE ELSE
      END SELECT
      NEXT I%
      
      IntOffset = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1 ' int # offset
      Loaded = -1
      END IF
      SELECT CASE IntNum%
      CASE &H25, &H26, IS > 255               ' ignorera dessa Inter
      CASE ELSE
      DEF SEG = VARSEG(IntCode$)
      MID$(IntCode$, IntOffset, 1) = CHR$(IntNum%) ' Ange Intersrutin
      CALL Absolute(Regs, SADD(IntCode$))        ' anropa rutinen
      END SELECT
      END SUB

DEFSNG A-Z
      SUB LoadRaw (tseg%, tptr%, inum%, wid%, hei%, nsbl%, nsel%, nsbi%, nsei%)
      REM
      REM Ŀ
      REM  Loads a raw file containing multiple images into memory buffer 
      REM                                                                 
      REM  tseg%   segment of buffer                                      
      REM  tptr%   pointer of buffer                                      
      REM  inum%   number of images to read                               
      REM  wid%    width of images to load                                
      REM  hei%    height of images to load                               
      REM  nsbl%   number of bytes to skip at beginning of each line      
      REM  nsel%   number of bytes to skip at end of each line            
      REM  nsbi%   number of bytes to skip at beginning of each image     
      REM  nsei%   number of bytes to skip at end of each image           
      REM 
      
      WHILE tptr% > 15: tptr% = tptr% - 16: tseg% = tseg% + 1: WEND
      X$ = SPACE$(wid%): bseg% = VARSEG(X$): bptr% = SADD(X$)
      WHILE bptr% > 15: bptr% = bptr% - 16: bseg% = bseg% + 1: WEND
      FOR n% = 0 TO inum% - 1
      MAdd tseg%, tptr%, nsbi%
      FOR Y% = 0 TO hei% - 1
      GET #1, , X$
      MAdd vsetseg%, tptr%, nsbl%
      FOR X% = 0 TO wid% - 1
      DEF SEG = bseg%: p% = PEEK(bptr% + X%)
      DEF SEG = tseg%: POKE tptr%, p%
      MAdd vsetseg%, tptr%, 1
      NEXT X%
      MAdd vsetseg%, tptr%, nsel%
      NEXT Y%
      MAdd vsetseg%, tptr%, nsei%
      NEXT n%
      END SUB

      SUB MAdd (vseg%, vptr%, add%)
      IF vptr% > 32767 - add% THEN
      vptr% = -32769 + (add% - (32767 - vptr%))
      ELSE
      vptr% = vptr% + add%
      END IF
      END SUB

      SUB MemDec (mseg%, mptr%, mlen%)
      WHILE mptr% > 15: mptr% = mptr% - 16: mseg% = mseg% + 1: WEND
      code$ = "NO GRAPHICS BLANKA!"
      cseg% = VARSEG(code$): cptr% = VARPTR(code$): clen% = LEN(code$) - 1
      WHILE cptr% > 15: cptr% = cptr% - 16: cseg% = cseg% + 1: WEND
      FOR m% = 0 TO mlen% - 1
      cp% = (cp% + 1) MOD clen%
      DEF SEG = cseg%: cb% = PEEK(cptr% + cp%)
      DEF SEG = mseg%: POKE mptr% + m%, PEEK(mptr% + m%) XOR cb%
      NEXT m%
      END SUB

      SUB Mouse (ax%, Bx%, cx%, dx%)
      Regs.ax = ax%
      Regs.Bx = Bx%
      Regs.cx = cx%
      Regs.dx = dx%
      CALL Inter(&H33, Regs)
      ax% = Regs.ax
      Bx% = Regs.Bx
      cx% = Regs.cx
      dx% = Regs.dx
      END SUB

      SUB MouseActive (a%)
      DEF SEG = 0
      mseg% = CVI(CHR$(PEEK(207)) + CHR$(PEEK(206)))
      mofs% = CVI(CHR$(PEEK(205)) + CHR$(PEEK(204)))
      IF mseg% OR mofs% THEN
      DEF SEG = mseg%
      IF PEEK(mofs%) = 207 THEN a% = 0 ELSE a% = -1
      ELSE
      a% = 0
      END IF
      DEF SEG
      END SUB

      SUB MouseBorders (x1%, y1%, x2%, y2%)
      Mouse 7, 0, x1%, x2%
      Mouse 8, 9, y1%, y2%
      END SUB

      SUB MouseGetStat (X%, Y%, b%)
      Mouse 3, b%, X%, Y%
      END SUB

      SUB MouseHideCursor
      Mouse 2, 0, 0, 0
      END SUB

      SUB MouseReset
      Mouse 0, 0, 0, 0
      END SUB

      SUB MouseSetMickey (X%, Y%)
      Mouse 15, 0, X%, Y%
      END SUB

      SUB MouseSetXY (X%, Y%)
      Mouse 4, 0, X%, Y%
      END SUB

      SUB MouseShowCursor
      Mouse 1, 0, 0, 0
      END SUB

      SUB NoMore
      '** Clear screen in cool (?) way
      FOR X% = -199 TO 52
      IF X% MOD 8 = 0 THEN WAIT &H3DA, 8: WAIT &H3DA, 1
      FOR w% = 15 TO 0 STEP -1
      xp% = X% - (7 - w%)
      LINE (xp%, 0)-(xp% + 199, 199), 192 + (w% * 4)
      LINE (120 - xp%, 0)-(120 - xp% + 199, 199), 192 + (w% * 4)
      NEXT w%
      NEXT X%
      
      '** Fade bar
      FOR w% = 39 TO 0 STEP -1
      WAIT &H3DA, 8: WAIT &H3DA, 1
      FOR z% = 0 TO 63
      X% = z% * (w% / 40)
      SetPal z% + 192, X% \ 4, X% \ 4, X%
      NEXT z%
      NEXT w%
      
      '** Reset screen
      SCREEN 12
      '** Display quit message
      X% = 72
      Y% = 168
      Attr% = 30

      Vgatext "Ŀ", (X%), Y% + 0, Attr%, 16
      Vgatext " THE MEGA CD PLAYER                                         ", (X%), Y% + 16, Attr%, 16
      Vgatext "                                                            ", (X%), Y% + 32, Attr%, 16
      Vgatext " Interface       : Davey T                                  ", (X%), Y% + 48, Attr%, 16
      Vgatext " CD & mouse routs: Andrew G and Davey T                     ", (X%), Y% + 64, Attr%, 16
      Vgatext " Beta testing    : Andrew G                                 ", (X%), Y% + 80, Attr%, 16
      Vgatext " QBASIC version  : bernt.figaro@.swipnet.se                 ", (X%), Y% + 96, Attr%, 16
      Vgatext " Version 2.3 QBASIC                                         ", (X%), Y% + 112, Attr%, 16
      Vgatext "                                                            ", (X%), Y% + 128, Attr%, 16
      Vgatext " Contact         : Davey T : audio.squad@mailbox.swipnet.se ", (X%), Y% + 144, Attr%, 16
      Vgatext "                   Andrew G: zapf_dingbat@juno.com          ", (X%), Y% + 160, Attr%, 16
      Vgatext "", (X%), Y% + 176, Attr%, 16

      Vgatext "Hit any key !", 272, 465, 14, 16
      DO
      LOOP UNTIL LEN(INKEY$)
      '** Clear palette entry
      SetPal 7, 0, 0, 0

      WIDTH 80, 25

      '** YES! There is a reason for this line...
      COLOR 7, 0
      CLS

      END SUB

      SUB Red2HSG (HSG&, min%, Sec%, frm%)
      HSG& = CDBL(min%) * 4500 + Sec% * 75 + frm% - 150
      END SUB

      SUB SetPal (a%, r%, G%, b%)
      OUT &H3C7, a%: OUT &H3C8, a%
      OUT &H3C9, r%: OUT &H3C9, G%: OUT &H3C9, b%
      END SUB

      SUB Shuffle (Text$)
      FOR n% = 1 TO LEN(Text$)
      z% = INT(RND * LEN(Text$)) + 1
      X$ = MID$(Text$, n%, 1)
      MID$(Text$, n%, 1) = MID$(Text$, z%, 1)
      MID$(Text$, z%, 1) = X$
      NEXT n%
      END SUB

      SUB Sort (Text$)
      FOR n% = 1 TO LEN(Text$)
      FOR z% = n% + 1 TO LEN(Text$)
      IF MID$(Text$, z%, 1) < MID$(Text$, n%, 1) THEN
      X$ = MID$(Text$, n%, 1)
      MID$(Text$, n%, 1) = MID$(Text$, z%, 1)
      MID$(Text$, z%, 1) = X$
      END IF
      NEXT z%
      NEXT n%
      END SUB

      SUB Vgatext (Text$, X%, Y%, Colr%, TSize%)
      REM
      REM +----------------------------------------------------------+
      REM + (STATIC ==> All local variables are defined  STATIC      +
      REM +----------------------------------------------------------+
      REM
      REM +-----------------------------------------+
      REM + *** GRAPHIC TEXT WRITING ROUTINE ***    +
      REM + X, Y = pixel coordinates                +
      REM + Colr = mixed foregound/background color +
      REM + (BG*16 + FG), BG = 0 black background   +
      REM + TSize% (code size):                     +
      REM +  8 = 8x8 font                           +
      REM + 14 = 8x14 font                          +
      REM + 16 = 8x16 font                          +
      REM + 32 = 16x16 font                         +
      REM + 64 = 16x32) font                        +
      REM +-----------------------------------------+
      REM
      Ln% = LEN(Text$)
      IF Ln% = 0 THEN EXIT SUB  'if no text

      IF GPXFlg% = 0 THEN     'test for avoiding dobule width mask
      REDIM C2X%(15)           'bit mask for making double width char
      C2X%(0) = 0              'precalculated mask for max far
      C2X%(1) = 3
      C2X%(2) = 12
      C2X%(3) = 15
      C2X%(4) = 48
      C2X%(5) = 51
      C2X%(6) = 60
      C2X%(7) = 63
      C2X%(8) = 192
      C2X%(9) = 195
      C2X%(10) = 204
      C2X%(11) = 207
      C2X%(12) = 240
      C2X%(13) = 243
      C2X%(14) = 252
      C2X%(15) = 255
      GPXFlg% = -1              'Set the flag to true
      END IF

      IF TSize% <> SaveSze% THEN 'another test, avoiding repeats
      Dixi% = 8: Expand% = 0
      SELECT CASE TSize%
      CASE 8: Ftype = &H300: Font = 8: DY% = 8
      CASE 14: Ftype = &H200: Font = 14: DY% = 14
      CASE 16: Ftype = &H600: Font = 16: DY% = 16
      CASE 32: Ftype = &H600: Font = 16: DY% = 16: Dixi% = 16: Expand% = 1
      CASE 64: Ftype = &H600: Font = 16: DY% = 32: Dixi% = 16: Expand% = 2
      END SELECT
      Regs.ax = &H1130
      REM
      REM +-------------------------------------------+
      REM + AH = 11h: Get offset to an internal font  +
      REM + AL = 30h: get the font address            +
      REM +-------------------------------------------+
      REM
      Regs.Bx = Ftype                     'BX = font type
      CALL Inter(&H10, Regs)              'INT 10h, gives:
      FontSeg = Regs.es                   'actual segement
      FontAdrs = Regs.bp                  'offset
      SaveSze% = TSize%                   'save the size for next time
      END IF

      Fg% = Colr% AND 15                   'split Colr
      Bg% = Colr% \ 16

      DEF SEG = FontSeg                   'segement for VGA BIOS

      FOR I = 1 TO Ln%                    'For each char in the string
      cc% = ASC(MID$(Text$, I, 1))        'Get char code(0...255)
      Addr = Font * cc% + FontAdrs        'Get VGA BIOS address
      Cy% = Y%                            'top for start writing char
      IF Bg% THEN
      LINE (X%, Y%)-(X% + Dixi% - 1, Y% + DY% - 1), Bg%, BF 'do backGround
      END IF
      FOR J = 0 TO Font - 1               'for every scan line for the font
      scanline = PEEK(Addr + J)           'get scan line byte
      IF Expand% THEN                     'If double....
      lo% = scanline AND 15               'low nibble for scan line
      hi% = scanline \ 16                 'high nibble
      FOR k = 1 TO Expand%
      zwi& = CLNG(C2X%(hi%)) * 256        'long integer: low byte --> high byte
      IF zwi& > 32767 THEN
      scanline = zwi& - 65536
      ELSE
      scanline = zwi&
      END IF

      LINE (X%, Cy%)-(X% + 7, Cy%), Fg%, , scanline  'transfer scan line
      zwi& = CLNG(C2X%(lo%)) * 256        'long integer: low byte --> high byte
      IF zwi& > 32767 THEN
      scanline = zwi& - 65536
      ELSE
      scanline = zwi&
      END IF
      LINE (X% + 8, Cy%)-(X% + 15, Cy%), Fg%, , scanline  'transfer scan line
      Cy% = Cy% + 1                        'next scan linje
      NEXT k                               'again if double height
      ELSE                                 'normaly char
      zwi& = CLNG(scanline) * 256          'long integer: low byte --> high byte
      IF zwi& > 32767 THEN
      scanline = zwi& - 65536
      ELSE
      scanline = zwi&
      END IF
      LINE (X%, Cy%)-(X% + 7, Cy%), Fg%, , scanline  'transfer scan line
      Cy% = Cy% + 1                        'next scan linje
      END IF
      NEXT J
      X% = X% + Dixi%                        'next char
      NEXT I

      DEF SEG                              'back to Basic segement

      END SUB

