DECLARE SUB Inter (IntNum%, Regs AS ANY)
DECLARE FUNCTION CDGetStatus% ()
DECLARE FUNCTION CDGetVersion% ()
DECLARE FUNCTION CDGetDrives$ ()
DECLARE FUNCTION CDGetError$ (enum%)
DECLARE FUNCTION CDDriveCheck% (drive%)
DECLARE FUNCTION CDctlI$ (drive%, info$)
DECLARE SUB Red2HSG (HSG&, min%, sec%, frm%)
DECLARE SUB CDRequest (drive%, req%, info$)
DECLARE SUB CDIInfo (drive%, low%, high%)
DECLARE SUB CDITrack (drive%, track%, start&, ttype%)
DECLARE SUB CDISize (drive%, lsect&)
DECLARE SUB CDIDoor (drive%, state%)
DECLARE SUB CDRRead (drive%, ssect&, rsnum%, data$)
DECLARE SUB HSG2Red (min%, sec%, frm%, HSG&)
DECLARE FUNCTION FixRead$ (valid$, max%, esc$)

'$DYNAMIC
ON ERROR GOTO EH
TYPE RegTypeX
 ax AS INTEGER: bx AS INTEGER: cx AS INTEGER: dx AS INTEGER: bp AS INTEGER
 si AS INTEGER: di AS INTEGER: f  AS INTEGER: ds AS INTEGER: es AS INTEGER
END TYPE
DIM SHARED Regs AS RegTypeX, CDRStatus%

CLS
PRINT "Welcome to MCD2WAV - A 'Mega CD' utility!"
PRINT

'** Version check MSCDEX
Version% = CDGetVersion%
IF Version% < 210 THEN PRINT "MSCDEX v2.1 or later has not been installed!": END
PRINT "MSCDEX version:"; Version% / 100
PRINT "Scanning for drives..."

'** Get CD-ROM drive to use
list$ = CDGetDrives$
drives% = LEN(list$)
IF drives% = 0 THEN PRINT "No CD-ROMs was found!": END
IF drives% > 1 THEN
 PRINT "Found"; drives%; "CD-ROMs! Theese are: ";
 FOR n% = 1 TO drives%
  PRINT CHR$(ASC(MID$(list$, n%, 1)) + 65); " ";
 NEXT n%
 PRINT : PRINT "Please choose one: ";
 LOCATE , , 1
 DO
  drive% = ASC(UCASE$(INPUT$(1))) - 65
  IF drive% < 0 THEN drive% = 255
 LOOP UNTIL INSTR(list$, CHR$(drive%)) > 0
 LOCATE , , 0
 PRINT CHR$(drive% + 65)
ELSE
 drive% = ASC(list$)
 PRINT "Found 1 CD-ROM's! Using "; CHR$(drive% + 65)
 s! = TIMER: DO: LOOP WHILE ABS(TIMER - s!) < .5
END IF
IF CDDriveCheck%(drive%) <> 0 THEN PRINT "This drive and/or MSCDEX is not working correctly!": END
PRINT

'** Make sure there's a CD in the drive
CDIDoor drive%, state%
IF state% AND 1 THEN
 PRINT "Insert a CD or press any key to quit...";
 DO
  IF INKEY$ <> "" THEN END
  CDIDoor drive%, state%
 LOOP UNTIL (state% AND 1) = 0
END IF
 
'** Get and display tracks info
CDIInfo drive%, low%, high%
PRINT "There are"; high% - low% + 1; "tracks on this CD ranging from"; low%; "to"; high%
PRINT

'** Get tracks to copy
DO

 '** Update track list
 FOR y% = 0 TO 9
  FOR x% = 0 TO 9
   n% = y% * 10 + x%
   IF n% >= low% AND n% <= high% THEN COLOR 7 ELSE COLOR 8
   IF INSTR(copy$, CHR$(n%)) > 0 THEN COLOR 12
   LOCATE y% + 11, 1 + x% * 4
   IF y% = 0 THEN PRINT "0";
   PRINT LTRIM$(STR$(n%));
  NEXT x%
 NEXT y%

 '** Get input
 COLOR 7
 LOCATE 9, 1: PRINT "Copy track (leave blank when done):   ";
 LOCATE 9, 37: x$ = FixRead$("0123456789", 2, "*")
 IF x$ = "*" THEN LOCATE 22, 1: PRINT "Aborted!": END
 IF x$ = "" THEN EXIT DO
 IF VAL(x$) < low% OR VAL(x$) > high% THEN
  BEEP
 ELSE
  n% = VAL(x$): I% = INSTR(copy$, CHR$(n%))
  IF I% = 0 THEN
   copy$ = copy$ + CHR$(n%)
  ELSE
   copy$ = LEFT$(copy$, I% - 1) + MID$(copy$, I% + 1)
  END IF
 END IF
LOOP
LOCATE 22, 1
IF LEN(copy$) = 0 THEN PRINT "No tracks selected!": END

'valid$ = "!#$%&'()-0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghij"
'valid$ = valid$ + "klmnopqrstuvwxyz{}~"
'valid$ = valid$ + ""
'valid$ = valid$ + ""

'** Get output filename
valid$ = "!#$%&'()-0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`abcdefghijklmnop"
valid$ = valid$ + "qrstuvwxyz{}~"
valid$ = valid$ + ""
DO
 PRINT "Save output as (max 6 letters - no extension)"
 PRINT ": "; : x$ = FixRead$(valid$, 6, "")
 IF x$ = "" THEN END
LOOP UNTIL x$ <> ""
xf$ = x$
 
'** Display copy info
CLS
PRINT "MCD2WAV!"
PRINT STRING$(80, 196)
VIEW PRINT 3 TO 25

'** Loop to copy tracks
FOR n% = 1 TO LEN(copy$)
 track% = ASC(MID$(copy$, n%, 1))

 '** Get track info and make sure it can be copied
 IF track% = high% THEN
  CDISize drive%, trend&
 ELSE
  CDITrack drive%, track% + 1, trend&, ttype%
 END IF
 CDITrack drive%, track%, sect&, ttype%
 IF ttype% <> 0 THEN PRINT "Can't copy track"; track%; "it isn't stereo!": GOTO CNext

 file$ = xf$
 IF track% < 10 THEN file$ = file$ + "0"
 file$ = file$ + LTRIM$(STR$(track%)) + ".wav"
 PRINT
 PRINT "----------"
 PRINT "Copying track"; track%; "to "; file$; "..."

 '** Make some calculations
 start& = sect&
 length& = trend& - start&
 fixed& = (length& \ 8) * 8
 IF length& \ 8 < length& / 8 THEN fixed& = fixed& + 8
 fixes% = fixed& - length&
 fsiz& = 44 + fixed& * 2352

 '** Display final file size
 PRINT "Full size:";
 PRINT STR$(fsiz& \ 1000000);
 PRINT STR$((fsiz& MOD 1000000) \ 1000);
 PRINT STR$((fsiz& MOD 1000000) MOD 1000); " bytes"
 PRINT

 '** Display track info
 HSG2Red min%, sec%, frm%, length&
 PRINT USING "Length : ## min, ## sec"; min%; sec%

 '** Make sure file is empty and open it
 OPEN file$ FOR OUTPUT AS #1: CLOSE #1
 OPEN file$ FOR BINARY ACCESS WRITE AS #1

 '** Write header
 x$ = "RIFF": PUT #1, , x$       '* RIFF ID
 x$ = MKL$(0): PUT #1, , x$      '* RIFF length (size - 8)
 x$ = "WAVE": PUT #1, , x$       '* WAVE ID
 x$ = "fmt ": PUT #1, , x$       '* FMT ID
 x$ = MKL$(16): PUT #1, , x$     '* FMT Length
 x$ = MKI$(1): PUT #1, , x$      '* Format tag - 1 (PCM)
 x$ = MKI$(2): PUT #1, , x$      '* Channels - 2 (Stereo)
 x$ = MKI$(-21436): PUT #1, , x$ '* Sampling rate (44100hz)
 x$ = MKI$(0): PUT #1, , x$      '* Bytes per sec
 x$ = MKL$(176400): PUT #1, , x$ '* Block align (2chn*44100hz*(16bit/8))
 x$ = MKI$(4): PUT #1, , x$      '* Bytes per sample (2chn*16bit)
 x$ = MKI$(16): PUT #1, , x$     '* Bits
 x$ = "data": PUT #1, , x$       '* Data ID
 x$ = MKL$(0): PUT #1, , x$      '* Data length (size - 44)

 '** Copy track
 DIM xr AS STRING * 18816
 DO
  IF length& > 8 THEN size% = 8 ELSE size% = length&
  length& = length& - size%
 
  '** Display progress
  ss& = sect& - start&
  IF ss& MOD 75 = 0 THEN
   HSG2Red min%, sec%, frm%, ss&
   LOCATE , 1
   PRINT USING "Copying: ## min, ## sec - ###%"; min%; sec%; 100 / fixed& * ss&
  END IF
 
  '** Read, save and increment sector for next read
  CDRRead drive%, sect&, size%, xr
  PUT #1, , xr
  sect& = sect& + size%

  '** Error checking
  e% = CDGetStatus% AND 255
  IF e% > 0 THEN emsg$ = CDGetError$(e%)
  IF INKEY$ = CHR$(27) THEN e% = 17: emsg$ = "User aborted"
 
  '** Display error message
  IF e% > 0 THEN
   PRINT
   PRINT "ERROR: "; emsg$; "!";
   fixes% = 0
   EXIT DO
  END IF
 LOOP UNTIL length& = 0

 '** Fix file
 PRINT : PRINT "Fixing file..."
 SEEK #1, 5: x$ = MKL$(LOF(1) - 8): PUT #1, , x$
 SEEK #1, 41: x$ = MKL$(LOF(1) - 44): PUT #1, , x$

 '** Clear invalid sectors
 IF fixes% > 0 THEN
  SEEK #1, (fixed& - fixes%) * 2352 + 45
  x$ = CHR$(0)
  FOR f% = 1 TO fixes% * 2352
   PUT #1, , x$
  NEXT f%
 END IF
 PRINT "Done! Final size:"; LOF(1)
 CLOSE #1
CNext:
NEXT n%
PRINT
END

'** Error handler
EH:
 CLS
 PRINT "A fatal error has occured!"
 PRINT "Error code -"; ERR
 END

REM $STATIC
FUNCTION CDctlI$ (drive%, info$)
 'CDxtlI               Inputs data from the CD-ROM device driver using IOCTL
 ' In:
 '  drive%             Specifies the drive number (0=A)
 '  info$              Data to output
 ' Out:
 '  Returns            Modified info$ string

 io$ = CHR$(0)                                 'Media descriptior (0)
 io$ = io$ + MKI$(SADD(info$))                 'Offset of IOCTL data
 io$ = io$ + MKI$(VARSEG(info$))               'Segment of IOCTL data
 io$ = io$ + MKI$(LEN(info$))                  'Bytes to transfer
 io$ = io$ + MKI$(0)                           'Starting sector number (0)
 io$ = io$ + MKL$(0)                           'Volume ID (0)
 CDRequest drive%, 3, io$                      'Call function 3 (IOCTL read)
 CDctlI$ = info$
END FUNCTION

FUNCTION CDDriveCheck% (drive%)
 'CDDriveCheck%        Checks whether a drive is a valid CD-ROM drive or not
 ' In:
 '  drive%             Specifies the drive number (0=A)
 ' Out:
 '  Returns 0          MSCDEX is installed and this drive is supported
 '  Returns 1          MSCDEX is installed but this drive is not supported
 '  Returns 2          MCCDEX is not installed

 Regs.ax = &H150B                   'Drive Check
 Regs.cx = drive%                   'Drive number (0=A)
 CALL Inter(&H2F, Regs)  'Call the interrupt
 IF Regs.bx = &HADAD THEN
  CDDriveCheck% = 0                 'Might be needed
  IF Regs.ax = 0 THEN CDDriveCheck% = 1
 ELSE
  CDDriveCheck% = 2
 END IF
END FUNCTION

FUNCTION CDGetDrives$
 'CDGetDrives$         Find CD-ROM drives
 ' Out:
 '  Returns            String containing the CD-ROM drive list

 Regs.ax = &H1500                   'Installation check
 Regs.bx = 0
 CALL Inter(&H2F, Regs)  'Call the interrupt
 list$ = SPACE$(Regs.bx)
 Regs.ax = &H150D                   'Get drive letters
 Regs.es = VARSEG(list$): Regs.bx = SADD(list$)
 CALL Inter(&H2F, Regs)  'Call the interrupt
 CDGetDrives$ = list$
END FUNCTION

FUNCTION CDGetError$ (enum%)
 'CDGetError$          Get error from error num
 ' In:
 '  enum%              Specifies the error number (0 to 17)
 ' Out:
 '  Returns            Error text

 SELECT CASE enum%
  CASE 0: e$ = "No error"
  CASE 1: e$ = "Write protect violation"
  CASE 2: e$ = "Unknown unit"
  CASE 3: e$ = "Drive not ready"
  CASE 4: e$ = "Unknown command"
  CASE 5: e$ = "CRC error"
  CASE 6: e$ = "Bad request structure length"
  CASE 7: e$ = "Seek error"
  CASE 8: e$ = "Unknown media"
  CASE 9: e$ = "Sector not found"
  CASE 10: e$ = "Out of paper"
  CASE 11: e$ = "Write fault"
  CASE 12: e$ = "Read fault"
  CASE 13: e$ = "General failure"
  CASE 14, 15: e$ = "Unknown"
  CASE 16: e$ = "Invalid disk change"
  CASE 17: e$ = "Multiple errors has occured"
 END SELECT
 CDGetError$ = e$
END FUNCTION

FUNCTION CDGetStatus%
 'CDGetStatus          Get CD status
 ' Out:
 '  Returns            Status and error code

 'IF INT(TIMER / 4) AND 1 THEN CDRStatus% = CDRStatus% OR 1 'Error check
 CDGetStatus% = CDRStatus%
 CDRStatus% = 0
END FUNCTION

FUNCTION CDGetVersion%
 'CDGetVersion         Checks MSCDEX version
 ' Out:
 '  Returns            MSCDEX version

 Regs.ax = &H150C                   'Version check
 CALL Inter(&H2F, Regs)  'Call the interrupt
 CDGetVersion% = (Regs.bx AND 255) + (Regs.bx \ 256) * 100
END FUNCTION

SUB CDIAudio (drive%, chn0%, vol0%, chn1%, vol1%, chn2%, vol2%, chn3%, vol3%)
 'CDIAudio             IOCTL input: get volumes
 ' In:
 '  drive%             Specifies the drive number (0=A)
 ' Out:
 '  chn0% to chn3%     Returns the in channels for out channel 0 to 3
 '  vol0% to vol3%     Returns the volume for out channel 0 to 3

 ctl$ = CHR$(4)                                'IOCTL function 4 (volume chan)
 ctl$ = ctl$ + SPACE$(8)                       'Space for return info
 ctl$ = CDctlI$(drive%, ctl$)
 chn0% = ASC(MID$(ctl$, 2, 1)): vol0% = ASC(MID$(ctl$, 3, 1))
 chn1% = ASC(MID$(ctl$, 4, 1)): vol1% = ASC(MID$(ctl$, 5, 1))
 chn2% = ASC(MID$(ctl$, 6, 1)): vol2% = ASC(MID$(ctl$, 7, 1))
 chn3% = ASC(MID$(ctl$, 8, 1)): vol3% = ASC(MID$(ctl$, 9, 1))
END SUB

SUB CDIDoor (drive%, state%)
 'CDIDoor              IOCTL input: get door status
 ' In:
 '  drive%             Specifies the drive number (0=A)
 ' Out:
 '  state% bit 0       0 door closed, 1 door open
 '  state% bit 1       0 door unlocked, 1 door locked

 ctl$ = CHR$(6)                                'IOCTL function 6 (device stat)
 ctl$ = ctl$ + MKL$(0)                         'Space for return info
 ctl$ = CDctlI$(drive%, ctl$)
 state% = (ASC(MID$(ctl$, 2, 1)) AND 3)
 IF (state% AND 1) THEN state% = state% AND 1
END SUB

SUB CDIInfo (drive%, low%, high%)
 'CDIInfo              IOCTL input: get audio cd info
 ' In:
 '  drive%             Specifies the drive number (0=A)
 ' Out:
 '  low%               Lowest track number
 '  high%              Highest track number

 ctl$ = CHR$(10)                               'IOCTL function 10 (disk info)
 ctl$ = ctl$ + SPACE$(6)                       'Space for return info
 ctl$ = CDctlI$(drive%, ctl$)
 low% = ASC(MID$(ctl$, 2, 1))                  'Get return info
 high% = ASC(MID$(ctl$, 3, 1))
END SUB

SUB CDISize (drive%, lsect&)
 'CDISize              IOCTL input: get volume size
 ' In:
 '  drive%             Specifies the drive number (0=A)
 ' Out:
 '  lsect&             Volume size (last sector)

 ctl$ = CHR$(8)                                'IOCTL function 8 (vol size)
 ctl$ = ctl$ + SPACE$(4)                       'Space for return info
 ctl$ = CDctlI$(drive%, ctl$)
 lsect& = CVL(MID$(ctl$, 2, 4)) - 150
END SUB

SUB CDITrack (drive%, track%, start&, ttype%)
 'CDITrack             IOCTL input: get track information
 ' In:
 '  drive%             Specifies the drive number (0=A)
 '  track%             Which track to get info from
 ' Out:
 '  start&             Start position of this track
 '  ttype%             0 audio stereo, 1 data, 2 audio surround

 ctl$ = CHR$(11)                               'IOCTL function 11 (track info)
 ctl$ = ctl$ + CHR$(track%)
 ctl$ = ctl$ + SPACE$(5)                       'Space for return info
 ctl$ = CDctlI$(drive%, ctl$)
 Red2HSG start&, ASC(MID$(ctl$, 5, 1)), ASC(MID$(ctl$, 4, 1)), ASC(MID$(ctl$, 3, 1))
 ttype% = (ASC(MID$(ctl$, 7, 1)) AND 192) / 48
END SUB

SUB CDRequest (drive%, req%, info$)
 'CDRequest            Makes a request to MSCDEX
 ' In:
 '  drive%             Specifies the drive number (0=A)
 '  req%               Request code
 '  info$              Request information

 Regs.ax = &H1510
 Regs.cx = drive%
 request$ = CHR$(13) + CHR$(0) + CHR$(req%) + SPACE$(10) + info$
 Regs.es = VARSEG(request$): Regs.bx = SADD(request$)
 CALL Inter(&H2F, Regs)  'Call the interrupt

 stat% = CVI(MID$(request$, 4, 2))
 IF stat% AND -32768 THEN
  IF CDRStatus% AND 255 THEN
   CDRStatus% = 17
  ELSE
   CDRStatus% = (stat% AND 255) + 1
  END IF
 ELSE
  CDRStatus% = 0
 END IF
 CDRStatus% = CDRStatus% + (stat% AND 768)
END SUB

SUB CDRFetch (drive%, ssect&, rsnum%)
 'CDRFetch$            Request: prefetch sectors
 ' In:
 '  drive%             Specifies the drive number (0=A)
 '  ssect&             Starting sector
 '  rsnum%             Number of sector to read

 io$ = CHR$(0)                                'Set adressing mode to HSG
 io$ = io$ + MKL$(0)                          'Transfer adress (not used)
 io$ = io$ + MKI$(rsnum%)                     'Number of sectors to prefetch
 io$ = io$ + MKL$(ssect&)                     'Starting sector number
 io$ = io$ + CHR$(1)                          'Set data read mode to raw
 io$ = io$ + CHR$(0)                          'Set interleave size to 0
 io$ = io$ + CHR$(0)                          'Set interleave skip factor to 0
 CDRequest drive%, 130, io$                   'Call function 130 (prefetch)
END SUB

SUB CDRRead (drive%, ssect&, rsnum%, data$)
 'CDRRead$             Request: read sectors
 ' In:
 '  drive%             Specifies the drive number (0=A)
 '  ssect&             Starting sector
 '  rsnum%             Number of sector to read
 ' Out:
 '  data$              Read sectors

 IF LEN(data$) < 2352 * rsnum% THEN EXIT SUB
 io$ = CHR$(0)                                'Set adressing mode to HSG
 io$ = io$ + MKI$(SADD(data$))                'Offset of sector buffer
 io$ = io$ + MKI$(VARSEG(data$))              'Segment of sector buffer
 io$ = io$ + MKI$(rsnum%)                     'Number of sectors to read
 io$ = io$ + MKL$(ssect&)                     'Starting sector number
 io$ = io$ + CHR$(1)                          'Set data read mode to raw
 io$ = io$ + CHR$(0)                          'Set interleave size to 0
 io$ = io$ + CHR$(0)                          'Set interleave skip factor to 0
 CDRequest drive%, 128, io$                   'Call function 128 (read long)
END SUB

FUNCTION FixRead$ (valid$, max%, esc$)
 LOCATE , , 1: x$ = ""
 DO
  I$ = INKEY$
  SELECT CASE I$
   CASE CHR$(8)
    IF LEN(x$) > 0 THEN
     x$ = LEFT$(x$, LEN(x$) - 1)
     LOCATE , POS(0) - 1: PRINT " "; : LOCATE , POS(0) - 1
    END IF
   CASE CHR$(13)
    EXIT DO
   CASE CHR$(27)
    x$ = esc$
    EXIT DO
   CASE ELSE
    IF INSTR(valid$, I$) > 0 THEN
     IF LEN(x$) < max% THEN
      x$ = x$ + I$
      PRINT I$;
     END IF
    END IF
  END SELECT
 LOOP
 LOCATE , , 0: PRINT : FixRead$ = x$
END FUNCTION

SUB HSG2Red (min%, sec%, frm%, HSG&)
 IF HSG& <= 445500 AND HSG& >= 0 THEN
  frm% = HSG& MOD 75
  sec% = (HSG& MOD 4500) \ 75
  min% = HSG& \ 4500
 ELSE
  frm% = -1
 END IF
END SUB

DEFINT A-Z
      SUB Inter (IntNum%, Regs AS RegTypeX) STATIC

      REM  Task: Do Bios routines with interrupt routines
      REM  PARAMETERS
      REM  IntNum%  - Interrupt number
      REM  Regs     - User defined variable

      STATIC FileNum, IntOffset, Loaded

      IF NOT Loaded THEN                        ' Loaded = 0 (First time)
      IntCode$ = SPACE$(160)
      FOR I% = 0 TO 39
      SELECT CASE I%
      CASE 0: MID$(IntCode$, 1, 4) = MKL$(-2081649835)
      CASE 1: MID$(IntCode$, 5, 4) = MKL$(1465256172)
      CASE 2: MID$(IntCode$, 9, 4) = MKL$(1586189598)
      CASE 3: MID$(IntCode$, 13, 4) = MKL$(273124102)
      CASE 4: MID$(IntCode$, 17, 4) = MKL$(1979711293)
      CASE 5: MID$(IntCode$, 21, 4) = MKL$(1200561668)
      CASE 6: MID$(IntCode$, 25, 4) = MKL$(306678544)
      CASE 7: MID$(IntCode$, 29, 4) = MKL$(1979711293)
      CASE 8: MID$(IntCode$, 33, 4) = MKL$(1200561668)
      CASE 9: MID$(IntCode$, 37, 4) = MKL$(138906386)
      CASE 10: MID$(IntCode$, 41, 4) = MKL$(-1946663287)
      CASE 11: MID$(IntCode$, 45, 4) = MKL$(72321799)
      CASE 12: MID$(IntCode$, 49, 4) = MKL$(-1962518645)
      CASE 13: MID$(IntCode$, 53, 4) = MKL$(2139818615)
      CASE 14: MID$(IntCode$, 57, 4) = MKL$(309853964)
      CASE 15: MID$(IntCode$, 61, 4) = MKL$(41418503)
      CASE 16: MID$(IntCode$, 65, 4) = MKL$(-96039138)
      CASE 17: MID$(IntCode$, 69, 4) = MKL$(521172991)
      CASE 18: MID$(IntCode$, 73, 4) = MKL$(1543007883)
      CASE 19: MID$(IntCode$, 77, 4) = MKL$(-1957355059)
      CASE 20: MID$(IntCode$, 81, 4) = MKL$(40799212)
      CASE 21: MID$(IntCode$, 85, 4) = MKL$(-1946394999)
      CASE 22: MID$(IntCode$, 89, 4) = MKL$(-1893857698)
      CASE 23: MID$(IntCode$, 93, 4) = MKL$(1996488262)
      CASE 24: MID$(IntCode$, 97, 4) = MKL$(126427130)
      CASE 25: MID$(IntCode$, 101, 4) = MKL$(-1979955573)
      CASE 26: MID$(IntCode$, 105, 4) = MKL$(1334379079)
      CASE 27: MID$(IntCode$, 109, 4) = MKL$(106400004)
      CASE 28: MID$(IntCode$, 113, 4) = MKL$(138905944)
      CASE 29: MID$(IntCode$, 117, 4) = MKL$(-1995802743)
      CASE 30: MID$(IntCode$, 121, 4) = MKL$(-1885598593)
      CASE 31: MID$(IntCode$, 125, 4) = MKL$(-1895428537)
      CASE 32: MID$(IntCode$, 129, 4) = MKL$(1183519303)
      CASE 33: MID$(IntCode$, 133, 4) = MKL$(273123838)
      CASE 34: MID$(IntCode$, 137, 4) = MKL$(1583292250)
      CASE 35: MID$(IntCode$, 141, 4) = MKL$(-899816053)
      CASE 36: MID$(IntCode$, 145, 4) = MKL$(2&)
      CASE 37: MID$(IntCode$, 149, 4) = MKL$(0&)
      CASE 38: MID$(IntCode$, 153, 4) = MKL$(0&)
      CASE 39: MID$(IntCode$, 157, 4) = MKL$(0&)
      CASE ELSE
      END SELECT
      NEXT I%

      IntOffset = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1 ' int # offset
      Loaded = -1
      END IF
      SELECT CASE IntNum%
      CASE &H25, &H26, IS > 255               ' ignorera dessa Inter
      CASE ELSE
      DEF SEG = VARSEG(IntCode$)
      MID$(IntCode$, IntOffset, 1) = CHR$(IntNum%) ' Ange Intersrutin
      CALL Absolute(Regs, SADD(IntCode$))        ' anropa rutinen
      END SELECT
      END SUB

DEFSNG A-Z
SUB Red2HSG (HSG&, min%, sec%, frm%)
 HSG& = CDBL(min%) * 4500 + sec% * 75 + frm% - 150
END SUB

