DECLARE SUB Squirt ()
DECLARE FUNCTION DetectFM% ()
DECLARE SUB WriteReg (Reg%, info%)
DECLARE FUNCTION getInput$ (def$, Max%)
DECLARE SUB Maxs (Varb%, Max%)
DECLARE SUB HideMouse ()
DECLARE SUB ShowMouse ()
DECLARE SUB MouseOn ()
DECLARE FUNCTION At% (x%, y%)
DECLARE FUNCTION FromH% (x%, y%, w%)
DECLARE SUB GetMXY (x%, y%)
DECLARE SUB Mouse (M0%, M1%, M2%, M3%)
DECLARE FUNCTION MBtn% ()
DECLARE FUNCTION MouseActive% ()
'$INCLUDE: 'qb.bi'

ON ERROR GOTO OhNo

TYPE InsType
 InsName AS STRING * 8
 InsSett AS STRING * 11
END TYPE

DIM Instrument(1 TO 256) AS InsType
DIM SHARED XPs%, YPs%, Fixd%, Bar%, Vars%

CLS
PRINT "Starting up instrument editor..."
IF MouseActive% = 0 THEN PRINT "Mouse not found!": END

IF DetectFM% = 0 THEN PRINT "FM chip not found!": END
FOR n% = 0 TO &HF5
 WriteReg n%, 0
NEXT n%

OPEN "INSTDATA.FMI" FOR BINARY ACCESS READ AS #1
 id$ = STRING$(14, 0)
 GET #1, , id$
 IF id$ <> "FMTInstruments" THEN PRINT "Invalid instrument file!": END
 ver$ = STRING$(2, 0)
 GET #1, , ver$
 IF ver$ <> CHR$(1) + CHR$(0) THEN PRINT "This version is not supported!": END
 Name$ = STRING$(20, 0)
 GET #1, , Name$
 PRINT "Loading";
 x$ = CHR$(0)
 GET #1, , x$
 Max% = ASC(x$) + 1
 PRINT Max%;
 PRINT "instruments from '"; Name$; "' ";
 FOR n% = 1 TO Max%
  GET #1, , Instrument(n%).InsName
  PRINT Instrument(n%).InsName;
  LOCATE , POS(0) - 8
  FOR del% = 1 TO 2048: NEXT del%
 NEXT n%
 FOR n% = 1 TO Max%
  GET #1, , Instrument(n%).InsSett
  PRINT Instrument(n%).InsName;
  LOCATE , POS(0) - 8
  FOR del% = 1 TO 2048: NEXT del%
 NEXT n%
 PRINT
CLOSE #1

WIDTH 80, 25
CLS
LOCATE 1, 1, 0

PRINT "The FM tracker instrument editor!"
PRINT
PRINT "Instruments:       Setting:              Modulator:         Carrier:"
PRINT
PRINT "  Pitch vibrato:        [ ]                [ ]"
PRINT "                Amplitude vibrato:    [ ]                [ ]"
PRINT "                Sustaining sound:     [ ]                [ ]"
PRINT "                Envelope scaling:     [ ]                [ ]"
PRINT "                Frequency multiplier: <0--------------> <0-------------->"
PRINT "                Level scaling:        <0----------->    <0----------->   "
PRINT "                Output level:         <0--------------> <0-------------->"
PRINT "                Attack rate:          <0--------------> <0-------------->"
PRINT "                Decay rate:           <0--------------> <0-------------->"
PRINT "                Sustain level:        <0--------------> <0-------------->"
PRINT "                Release rate:         <0--------------> <0-------------->"
PRINT "                Wave select:          () ( ) ( ) ( )    () ( ) ( ) ( )"
PRINT "                Feedback:             <0------------->"
PRINT "  Connection:           [ ]"
PRINT
PRINT "[ Add ][ Delete ]  Instrument name:      {        }                   [ Test ]"
PRINT
PRINT "                                         [ Quit now! ]  [ Abort all changes! ]"

INum% = 1
GOSUB GetOpts

Top% = 1
MTop% = Max% - 11
GOSUB ShowInst

MouseOn

DO
 GetMXY XPs%, YPs%
 XPs% = INT(XPs% / 8) + 1: YPs% = INT(YPs% / 8) + 1

 Btns% = MBtn%
 IF Btns% = 1 AND LBtn% = 0 THEN
  OSC% = SC%
  SC% = -1
 
  FOR n% = 0 TO 11
   IF FromH(3, 6 + n%, 11) THEN
    IF Top% + n% <= Max% THEN LInum% = INum%: INum% = Top% + n%: SC% = 0
   END IF
  NEXT n%
 
  IF At(43, 5) THEN MPVib% = NOT MPVib%: SC% = 2
  IF At(62, 5) THEN CPVib% = NOT CPVib%: SC% = 3
  IF At(43, 6) THEN MAVib% = NOT MAVib%: SC% = 4
  IF At(62, 6) THEN CAVib% = NOT CAVib%: SC% = 5
  IF At(43, 7) THEN MSSnd% = NOT MSSnd%: SC% = 6
  IF At(62, 7) THEN CSSnd% = NOT CSSnd%: SC% = 7
  IF At(43, 8) THEN MEScl% = NOT MEScl%: SC% = 8
  IF At(62, 8) THEN CEScl% = NOT CEScl%: SC% = 9

  IF At(42, 9) THEN MFMul% = MFMul% - 1: SC% = 10
  IF At(59, 9) THEN MFMul% = MFMul% + 1: SC% = 10
  IF At(61, 9) THEN CFMul% = CFMul% - 1: SC% = 11
  IF At(78, 9) THEN CFMul% = CFMul% + 1: SC% = 11
 
  IF At(42, 10) THEN MLScl% = MLScl% - 1: SC% = 12
  IF At(56, 10) THEN MLScl% = MLScl% + 1: SC% = 12
  IF At(61, 10) THEN CLScl% = CLScl% - 1: SC% = 13
  IF At(75, 10) THEN CLScl% = CLScl% + 1: SC% = 13
  
  IF At(42, 11) THEN MOLev% = MOLev% - 1: SC% = 14
  IF At(59, 11) THEN MOLev% = MOLev% + 1: SC% = 14
  IF At(61, 11) THEN COLev% = COLev% - 1: SC% = 15
  IF At(78, 11) THEN COLev% = COLev% + 1: SC% = 15

  IF At(42, 12) THEN MARat% = MARat% - 1: SC% = 16
  IF At(59, 12) THEN MARat% = MARat% + 1: SC% = 16
  IF At(61, 12) THEN CARat% = CARat% - 1: SC% = 17
  IF At(78, 12) THEN CARat% = CARat% + 1: SC% = 17
 
  IF At(42, 13) THEN MDRat% = MDRat% - 1: SC% = 18
  IF At(59, 13) THEN MDRat% = MDRat% + 1: SC% = 18
  IF At(61, 13) THEN CDRat% = CDRat% - 1: SC% = 19
  IF At(78, 13) THEN CDRat% = CDRat% + 1: SC% = 19

  IF At(42, 14) THEN MSLev% = MSLev% - 1: SC% = 20
  IF At(59, 14) THEN MSLev% = MSLev% + 1: SC% = 20
  IF At(61, 14) THEN CSLev% = CSLev% - 1: SC% = 21
  IF At(78, 14) THEN CSLev% = CSLev% + 1: SC% = 21

  IF At(42, 15) THEN MRRat% = MRRat% - 1: SC% = 22
  IF At(59, 15) THEN MRRat% = MRRat% + 1: SC% = 22
  IF At(61, 15) THEN CRRat% = CRRat% - 1: SC% = 23
  IF At(78, 15) THEN CRRat% = CRRat% + 1: SC% = 23

  IF At(43, 16) THEN MWSel% = 0: SC% = 24
  IF At(47, 16) THEN MWSel% = 1: SC% = 24
  IF At(51, 16) THEN MWSel% = 2: SC% = 24
  IF At(55, 16) THEN MWSel% = 3: SC% = 24
  IF At(62, 16) THEN CWSel% = 0: SC% = 25
  IF At(66, 16) THEN CWSel% = 1: SC% = 25
  IF At(70, 16) THEN CWSel% = 2: SC% = 25
  IF At(74, 16) THEN CWSel% = 3: SC% = 25
 
  IF At(42, 17) THEN FBack% = FBack% - 1: SC% = 26
  IF At(58, 17) THEN FBack% = FBack% + 1: SC% = 26
 
  IF At(43, 18) THEN CNect% = NOT CNect%: SC% = 27
 
  IF FromH(43, 20, 8) THEN
   HideMouse
   LOCATE 20, 43
   n$ = getInput$(IName$, 8)
   IF n$ <> "" THEN IName$ = UCASE$(n$)
   SC% = 28
   ShowMouse
  END IF

  IF FromH(2, 20, 5) THEN SC% = 29
  IF FromH(9, 20, 8) THEN SC% = 30
 
  IF FromH(43, 22, 11) THEN
   HideMouse
   LOCATE 24, 2, 1: PRINT "Quit really? ";
   DO
    in$ = UCASE$(INKEY$)
   LOOP UNTIL in$ = "Y" OR in$ = "N"
   LOCATE 24, 2, 1: PRINT STRING$(40, 32);
   LOCATE , , 0
   IF in$ = "Y" THEN GOTO qwit
   ShowMouse
  END IF
  IF FromH(58, 22, 20) THEN
   LOCATE 24, 2, 1: PRINT "Abort everything? ";
   DO
    in$ = UCASE$(INKEY$)
   LOOP UNTIL in$ = "Y" OR in$ = "N"
   LOCATE 24, 2, 1: PRINT STRING$(40, 32);
   LOCATE , , 0
   IF in$ = "Y" THEN CLS : END
  END IF
 
  IF FromH(72, 20, 6) THEN
  
   GOSUB MakeInst
   RESTORE FMIRegs
   FOR n% = 1 TO 11
    IF n% AND 1 THEN READ WReg% ELSE WReg% = WReg% + 3
    WriteReg WReg%, ASC(MID$(IDat$, n%, 1))
   NEXT n%
  
   Freq% = &H16B
   Octv% = 3
   WriteReg &HA0, Freq% AND &HFF
   WriteReg &HB0, INT(Freq% / 256) OR 32 OR (Octv% * 4)
   DO
   LOOP UNTIL MBtn% = 0
   
   WriteReg &HA0, 0
   WriteReg &HB0, 0
 
  END IF
 
  Bar% = 0
  IF SC% = -1 THEN SC% = OSC% ELSE GOSUB Update
 ELSEIF Btns% = 1 THEN
  OSC% = SC%
  SC% = -1
 
  IF ABS(TIMER - sky!) >= .1 THEN
   sky! = TIMER

   IF At(16, 5) THEN IF Top% > 1 THEN Top% = Top% - 1: SC% = 1
   IF At(16, 18) THEN IF Top% < MTop% THEN Top% = Top% + 1: SC% = 1
 
   IF FromH(43, 9, 16) THEN MFMul% = XPs% - 43: SC% = 10
   IF FromH(62, 9, 16) THEN CFMul% = XPs% - 62: SC% = 11
 
   IF FromH(43, 10, 13) THEN MLScl% = XPs% - 43: SC% = 12
   IF FromH(62, 10, 13) THEN CLScl% = XPs% - 62: SC% = 13
 
   IF FromH(43, 11, 16) THEN MOLev% = XPs% - 43: SC% = 14
   IF FromH(62, 11, 16) THEN COLev% = XPs% - 62: SC% = 15

   IF FromH(43, 12, 16) THEN MARat% = XPs% - 43: SC% = 16
   IF FromH(62, 12, 16) THEN CARat% = XPs% - 62: SC% = 17
 
   IF FromH(43, 13, 16) THEN MDRat% = XPs% - 43: SC% = 18
   IF FromH(62, 13, 16) THEN CDRat% = XPs% - 62: SC% = 19
 
   IF FromH(43, 14, 16) THEN MSLev% = XPs% - 43: SC% = 20
   IF FromH(62, 14, 16) THEN CSLev% = XPs% - 62: SC% = 21
 
   IF FromH(43, 15, 16) THEN MRRat% = XPs% - 43: SC% = 22
   IF FromH(62, 15, 16) THEN CRRat% = XPs% - 62: SC% = 23

   IF FromH(43, 17, 15) THEN FBack% = XPs% - 43: SC% = 26
 
   Bar% = -1
   IF SC% = -1 THEN SC% = OSC% ELSE GOSUB Update
  END IF
 END IF

Main:
 LBtn% = Btns%

 in$ = INKEY$
LOOP

Update:
 HideMouse
 SELECT CASE SC%
  CASE 0
   GOSUB MakeInst
   IF Instrument(LInum%).InsSett <> IDat$ OR Instrument(LInum%).InsName <> Name$ THEN
    LOCATE 24, 2, 1: PRINT "Changes has been made, save? ";
    DO
     in$ = UCASE$(INKEY$)
    LOOP UNTIL in$ = "Y" OR in$ = "N"
    LOCATE 24, 2, 1: PRINT STRING$(40, 32);
    LOCATE , , 0
    IF in$ = "Y" THEN
     Instrument(LInum%).InsSett = IDat$
     Instrument(LInum%).InsName = Name$
    END IF
   END IF
   GOSUB GetOpts
   GOSUB ShowInst
  CASE 1
   GOSUB ShowInst
  CASE 2: LOCATE 5, 43: IF MPVib% THEN PRINT "X"; :  ELSE PRINT " ";
  CASE 3: LOCATE 5, 62: IF CPVib% THEN PRINT "X"; :  ELSE PRINT " ";
  CASE 4: LOCATE 6, 43: IF MAVib% THEN PRINT "X"; :  ELSE PRINT " ";
  CASE 5: LOCATE 6, 62: IF CAVib% THEN PRINT "X"; :  ELSE PRINT " ";
  CASE 6: LOCATE 7, 43: IF MSSnd% THEN PRINT "X"; :  ELSE PRINT " ";
  CASE 7: LOCATE 7, 62: IF CSSnd% THEN PRINT "X"; :  ELSE PRINT " ";
  CASE 8: LOCATE 8, 43: IF MEScl% THEN PRINT "X"; :  ELSE PRINT " ";
  CASE 9: LOCATE 8, 62: IF CEScl% THEN PRINT "X"; :  ELSE PRINT " ";
  CASE 10: Maxs MFMul%, 15
  CASE 11: Maxs CFMul%, 15
  CASE 12: Maxs MLScl%, 3
  CASE 13: Maxs CLScl%, 3
  CASE 14: Maxs MOLev%, 63
  CASE 15: Maxs COLev%, 63
  CASE 16: Maxs MARat%, 15
  CASE 17: Maxs CARat%, 15
  CASE 18: Maxs MDRat%, 15
  CASE 19: Maxs CDRat%, 15
  CASE 20: Maxs MSLev%, 15
  CASE 21: Maxs CSLev%, 15
  CASE 22: Maxs MRRat%, 15
  CASE 23: Maxs CRRat%, 15
  CASE 24
   FOR n% = 0 TO 3
    LOCATE 16, 43 + n% * 4: IF n% = MWSel% THEN PRINT "";  ELSE PRINT " ";
   NEXT n%
  CASE 25
   FOR n% = 0 TO 3
    LOCATE 16, 62 + n% * 4: IF n% = CWSel% THEN PRINT "";  ELSE PRINT " ";
   NEXT n%
  CASE 26
   Maxs FBack%, 7
   LOCATE 17, 43: PRINT STRING$(Fixd%, "-"); ""; STRING$(14 - Fixd%, "-");
   IF Fixd% > 7 THEN
    LOCATE , POS(0) - (14 - Fixd%) - LEN(STR$(Vars%))
   ELSE
    LOCATE , POS(0) - (14 - Fixd%)
   END IF
   PRINT LTRIM$(STR$(Vars%));
  CASE 27
   LOCATE 18, 43: IF CNect% THEN PRINT "X"; :  ELSE PRINT " ";
  CASE 28
   LOCATE 20, 43: PRINT IName$ + STRING$(8 - LEN(IName$), 32);
  CASE 29
   IF Max% < 256 THEN
    FOR z% = 1 TO Max%
     IF IName$ < Instrument(z%).InsName THEN EXIT FOR
    NEXT z%
    Max% = Max% + 1: Top% = Max% - 11
    IF Top% < 1 THEN Top% = 1
    MTop% = Max% - 11: INum% = Max%
   
    GOSUB MakeInst
    Instrument(Max%).InsName = Name$: Instrument(Max%).InsSett = IDat$
    GOSUB ShowInst
  
   END IF
  CASE 30
   IF Max% > 1 THEN
    FOR n% = INum% TO Max% - 1
     Instrument(n%).InsName = Instrument(n% + 1).InsName
     Instrument(n%).InsSett = Instrument(n% + 1).InsSett
    NEXT n%
    Max% = Max% - 1
    MTop% = MTop% - 1
    IF Top% + 11 > Max% AND Top% > 1 THEN Top% = Top% - 1
    IF INum% > Max% THEN INum% = INum% - 1
   
    IF Top% = 0 THEN Top% = 1
    GOSUB ShowInst
    GOSUB GetOpts
   END IF

 END SELECT
 IF SC% > 9 AND SC% < 24 THEN
  SCY% = INT((SC% - 10) / 2) + 9
  IF SC% MOD 2 = 0 THEN LOCATE SCY%, 43 ELSE LOCATE SCY%, 62
  IF SC% = 12 OR SC% = 13 THEN
   PRINT STRING$(Fixd%, "-"); ""; STRING$(12 - Fixd%, "-");
   IF Fixd% > 6 THEN
    LOCATE , POS(0) - (12 - Fixd%) - LEN(STR$(Vars%))
   ELSE
    LOCATE , POS(0) - (12 - Fixd%)
   END IF
  ELSE
   PRINT STRING$(Fixd%, "-"); ""; STRING$(15 - Fixd%, "-");
   IF Fixd% > 7 THEN
    LOCATE , POS(0) - (15 - Fixd%) - LEN(STR$(Vars%))
   ELSE
    LOCATE , POS(0) - (15 - Fixd%)
   END IF
  END IF
  PRINT LTRIM$(STR$(Vars%));
 END IF
  
 ShowMouse
 RETURN

GetOpts:
 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 1, 1))
 IF InsDat% AND 128 THEN MPVib% = -1 ELSE MPVib% = 0
 IF InsDat% AND 64 THEN MAVib% = -1 ELSE MAVib% = 0
 IF InsDat% AND 32 THEN MSSnd% = -1 ELSE MSSnd% = 0
 IF InsDat% AND 16 THEN MEScl% = -1 ELSE MEScl% = 0
 MFMul% = InsDat% AND 15

 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 2, 1))
 IF InsDat% AND 128 THEN CPVib% = -1 ELSE CPVib% = 0
 IF InsDat% AND 64 THEN CAVib% = -1 ELSE CAVib% = 0
 IF InsDat% AND 32 THEN CSSnd% = -1 ELSE CSSnd% = 0
 IF InsDat% AND 16 THEN CEScl% = -1 ELSE CEScl% = 0
 CFMul% = InsDat% AND 15

 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 3, 1))
 MLScl% = (InsDat% AND 192) / 64: MOLev% = InsDat% AND 63

 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 4, 1))
 CLScl% = (InsDat% AND 192) / 64: COLev% = InsDat% AND 63

 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 5, 1))
 MARat% = (InsDat% AND 240) / 16: MDRat% = InsDat% AND 15

 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 6, 1))
 CARat% = (InsDat% AND 240) / 16: CDRat% = InsDat% AND 15

 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 7, 1))
 MSLev% = (InsDat% AND 240) / 16: MRRat% = InsDat% AND 15

 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 8, 1))
 CSLev% = (InsDat% AND 240) / 16: CRRat% = InsDat% AND 15

 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 9, 1))
 MWSel% = InsDat% AND 3

 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 10, 1))
 CWSel% = InsDat% AND 3

 InsDat% = ASC(MID$(Instrument(INum%).InsSett, 11, 1))
 FBack% = (InsDat% AND 14) / 2
 IF InsDat% AND 1 THEN CNect% = -1 ELSE CNect% = 0

 Name$ = Instrument(INum%).InsName
 IName$ = ""
 FOR n% = 1 TO 8
  IF MID$(Name$, n%, 1) = CHR$(0) THEN EXIT FOR
  IName$ = IName$ + MID$(Name$, n%, 1)
 NEXT n%

 FOR SC% = 2 TO 28
  GOSUB Update
 NEXT SC%

RETURN

MakeInst:
 InsDat% = MFMul%
 IF MEScl% THEN InsDat% = InsDat% + 16
 IF MSSnd% THEN InsDat% = InsDat% + 32
 IF MAVib% THEN InsDat% = InsDat% + 64
 IF MPVib% THEN InsDat% = InsDat% + 128
 IDat$ = CHR$(InsDat%)

 InsDat% = CFMul%
 IF CEScl% THEN InsDat% = InsDat% + 16
 IF CSSnd% THEN InsDat% = InsDat% + 32
 IF CAVib% THEN InsDat% = InsDat% + 64
 IF CPVib% THEN InsDat% = InsDat% + 128
 IDat$ = IDat$ + CHR$(InsDat%)

 InsDat% = MOLev% + MLScl% * 64
 IDat$ = IDat$ + CHR$(InsDat%)

 InsDat% = COLev% + CLScl% * 64
 IDat$ = IDat$ + CHR$(InsDat%)

 InsDat% = MDRat% + MARat% * 16
 IDat$ = IDat$ + CHR$(InsDat%)

 InsDat% = CDRat% + CARat% * 16
 IDat$ = IDat$ + CHR$(InsDat%)

 InsDat% = MRRat% + MSLev% * 16
 IDat$ = IDat$ + CHR$(InsDat%)

 InsDat% = CRRat% + CSLev% * 16
 IDat$ = IDat$ + CHR$(InsDat%)

 IDat$ = IDat$ + CHR$(MWSel%) + CHR$(CWSel%)

 InsDat% = FBack% * 2
 IF CNect% THEN InsDat% = InsDat% + 1
 IDat$ = IDat$ + CHR$(InsDat%)

 Name$ = IName$ + STRING$(8 - LEN(IName$), 0)

 RETURN

FMIRegs:
 DATA 32,64,96,128,224,192

ShowInst:
 FOR n% = 0 TO 11
  ths% = Top% + n%
  LOCATE 6 + n%, 3:
  IF ths% > Max% THEN
   COLOR 7, 0: PRINT "           ";
  ELSE
   IF ths% = INum% THEN COLOR 0, 7 ELSE COLOR 7, 0
   PRINT HEX$(ths% - 1); "  ";
   LOCATE 6 + n%, 6: PRINT Instrument(ths%).InsName;
  END IF
 NEXT n%

 COLOR 7, 0
 RETURN

qwit:
 GOSUB MakeInst
 IF Instrument(INum%).InsSett <> IDat$ OR Instrument(INum%).InsName <> Name$ THEN
  LOCATE 24, 2, 1: PRINT "Changes has been made, save? ";
  DO
   in$ = UCASE$(INKEY$)
  LOOP UNTIL in$ = "Y" OR in$ = "N"
  LOCATE 24, 2, 1: PRINT STRING$(40, 32);
  LOCATE , , 0
  IF in$ = "Y" THEN
   Instrument(INum%).InsSett = IDat$
   Instrument(INum%).InsName = Name$
  END IF
 END IF
 CLS
 OPEN "INSTDATA.FMI" FOR OUTPUT AS #1: CLOSE #1     'Clear
 PRINT "Sorting..."
 FOR n% = 1 TO Max%
  FOR z% = n% + 1 TO Max%
   IF Instrument(n%).InsName > Instrument(z%).InsName THEN 'Can't use swap with
    IName$ = Instrument(n%).InsName                        'fixed string or QB
    ISett$ = Instrument(n%).InsSett                        'will hang...
    Instrument(n%).InsName = Instrument(z%).InsName
    Instrument(n%).InsSett = Instrument(z%).InsSett
    Instrument(z%).InsName = IName$
    Instrument(z%).InsSett = ISett$
   END IF
  NEXT z%
 NEXT n%
 PRINT "Saving..."
 OPEN "INSTDATA.FMI" FOR BINARY ACCESS WRITE AS #1
  id$ = "FMTInstruments"
  PUT #1, , id$
  ver$ = CHR$(1) + CHR$(0)
  PUT #1, , ver$
  Name$ = "Standard DATA bank" + CHR$(0) + CHR$(0)
  PUT #1, , Name$
  x$ = CHR$(Max% - 1)
  PUT #1, , x$
  FOR n% = 1 TO Max%
   PUT #1, , Instrument(n%).InsName
  NEXT n%
  FOR n% = 1 TO Max%
   PUT #1, , Instrument(n%).InsSett
  NEXT n%
 CLOSE #1
 PRINT "Instrument file updated!"
 END
OhNo:
 HideMouse
 CLS
 PRINT "An unknown error has occured!"
 END

FUNCTION At% (x%, y%)
 IF x% = XPs% AND y% = YPs% THEN At% = -1
END FUNCTION

FUNCTION DetectFM%
 WriteReg 4, &H60
 WriteReg 4, &H80
 data1% = INP(&H388)
 WriteReg 2, &HFF
 WriteReg 4, &H21
 FOR d% = 1 TO 150: x% = INP(&H388): NEXT d%
 data2% = INP(&H388)
 WriteReg 4, &H60
 WriteReg 4, &H80
 IF (data1% AND &HE0) = 0 AND (data2% AND &HE0) = &HC0 THEN DetectFM% = -1
END FUNCTION

FUNCTION FromH% (x%, y%, w%)
 IF XPs% >= x% AND XPs% < x% + w% AND YPs% = y% THEN FromH% = -1
END FUNCTION

FUNCTION getInput$ (def$, Max%)
 COLOR 7
 LOCATE , , 1
 got$ = def$
 PRINT got$;
 DO
  in$ = INKEY$
  SELECT CASE in$
   CASE CHR$(8)
    IF LEN(got$) > 0 THEN
     got$ = LEFT$(got$, LEN(got$) - 1)
     LOCATE , POS(0) - 1
     PRINT " ";
     LOCATE , POS(0) - 1
    END IF

   CASE CHR$(13)
    IF LEN(got$) = 0 THEN
     BEEP
    ELSE
     getInput$ = got$
     GOTO Inputed
    END IF
   CASE CHR$(27)
    getInput$ = ""
    GOTO Inputed
   CASE ELSE
    IF LEN(in$) = 1 THEN
     IF LEN(got$) < Max% THEN
      PRINT in$;
      got$ = got$ + in$
     END IF
    END IF
  END SELECT
 LOOP
Inputed:
 LOCATE , , 0

END FUNCTION

SUB GetMXY (x%, y%) STATIC
Mouse 3, 0, x%, y%
END SUB

SUB HideMouse STATIC
CALL Mouse(2, 0, 0, 0)
END SUB

SUB Maxs (Varb%, Max%)
 IF Bar% THEN Varb% = CINT(Varb% / (16 / (Max% + 1)))
 IF Varb% < 0 THEN Varb% = 0
 IF Varb% > Max% THEN Varb% = Max%
 Fixd% = INT(16 / (Max% + 1) * Varb%)
 Vars% = Varb%
END SUB

SUB MBorders (x%, y%, h%, v%) STATIC
Mouse 7, 0, x%, h%
Mouse 8, 9, y%, v%
END SUB

DEFINT A-Z
FUNCTION MBtn% STATIC
Mouse 3, Buttons%, 0, 0
MBtn% = Buttons%
END FUNCTION

DEFSNG A-Z
SUB Mouse (M0%, M1%, M2%, M3%) STATIC
DIM InRegs AS RegType, OutRegs AS RegType
InRegs.ax = M0%
InRegs.bx = M1%
InRegs.cx = M2%
InRegs.dx = M3%
CALL INTERRUPT(51, InRegs, OutRegs)
M0% = OutRegs.ax
M1% = OutRegs.bx
M2% = OutRegs.cx
M3% = OutRegs.dx
END SUB

DEFLNG A-Z
FUNCTION MouseActive% STATIC
DEF SEG = 0
mseg& = 256 * PEEK(51 * 4 + 3) + PEEK(51 * 4 + 2)
moff& = 256 * PEEK(51 * 4 + 1) + PEEK(51 * 4)
IF mseg& OR moff& THEN
DEF SEG = mseg&
IF PEEK(moff&) = 207 THEN
MouseActive% = 0
ELSE
MouseActive% = -1
END IF
ELSE
MouseActive% = 0
END IF
DEF SEG
END FUNCTION

DEFSNG A-Z
SUB MouseOff STATIC
Mouse 0, 0, 0, 0
END SUB

SUB MouseOn STATIC
Mouse 0, 0, 0, 0
Mouse 1, 0, 0, 0
END SUB

SUB SetMXY (x%, y%) STATIC
Mouse 4, 0, x%, y%
END SUB

SUB ShowMouse STATIC
Mouse 1, 0, 0, 0
END SUB

SUB Squirt
 SOUND 500, .1
END SUB

SUB WriteReg (Reg%, info%)
 OUT &H388, Reg%
 FOR d% = 1 TO 6: x% = INP(&H388): NEXT d%
 OUT &H389, info%
 FOR d% = 1 TO 35: x% = INP(&H388): NEXT d%
END SUB

