'- PLEASE READ!!!! - - - - - - - - - - - - - - - - - - - - - - - - -
'- - - - - - - - - - - - - - - - - - - - - - - - - PLEASE READ!!!! -
'
'Files which should be in this package:
' FMTRACK.BAS                             The main program
' IEDITOR.BAS                             Instrument editor
' FMTRACK.IMG                             FMTracker logo
' FMTRACK.FNT                             FMTracker graphics font
' INSTDATA.FMI                            Instruments
' CHILD.FMT                               Children's tune
' GROOVE.FMT                              Pasco's groove tune
' PIANOW.FMT                              Piano Waves / MC Dreamer
' DRUMS.FMT                               Drum set
'
'----------------->>>>> USE AT YOUR OWN RISC!! <<<<<-----------------
'WARNING!! This is the Beta version! I DO NOT take responsibility for
'ANYTHING this program might do to any part of the known universe!!!!
'----------------->>>>> USE AT YOUR OWN RISC!! <<<<<-----------------
'
'This program probably has a few bugs, so if you find any of them
'please mail them to me with a description of exactly what you were
'doing when you found the bug. If the program displays the "Unknown
'error!" message I would be greatful if you could, as above, send
'me a description of what you were doing when the message appeared!
'
'** This is FMTracker v1.1b written by Davey W Taylor -97/98
'** Contact me at: audio.squad@mailbox.swipnet.se
'** http://home3.swipnet.se/~w-32992/basic/
'                 . *  /\  ,    .  ) *       Author:  Davey W Taylor
'  ENJOY!      _______/oo\____/\________     Tester: Andrew S Gibson
'                    /____\ /____\ William
'- PLEASE READ!!!! - - - - - - - - - - - - - - - - - - - - - - - - -
'- - - - - - - - - - - - - - - - - - - - - - - - - PLEASE READ!!!! -

DECLARE FUNCTION DetectFM% ()
DECLARE FUNCTION GetYN% (mess$)
DECLARE FUNCTION GetInput$ (mess$, def$, max%)
DECLARE FUNCTION GetOpt% (mess$, now%)
DECLARE SUB WriteReg (reg%, info%)
DECLARE SUB InitFM ()
DECLARE SUB PalTo (max%, div%)
DECLARE SUB GetPal (n%, r%, g%, b%)
DECLARE SUB SetPal (n%, r%, g%, b%)
DECLARE SUB SetFont (Start%, Chars%, font$)
DECLARE SUB ResetFont ()
DECLARE SUB TBoxF (x1%, y1%, x2%, y2%)
DECLARE SUB TBoxE (x1%, y1%, x2%, y2%)
DECLARE SUB UpdateInst ()
DECLARE SUB UpdateTrax (Center%)
DECLARE SUB UpdateMusx (Track%, Center%, ChanHi%)
DECLARE SUB UpdateVols (Vols%())
DECLARE SUB SetInstruments ()
DECLARE SUB Edit (Patt%, Center%)
DECLARE SUB PlayIt (sTrack%, sPos%)
DECLARE SUB ClrMsg ()
DECLARE SUB Msg (mess$)
DECLARE SUB WaitKey (mess$)

ON ERROR GOTO Unknown
PRINT "Initializing The FM Tracker..."
PRINT
PRINT "Allocating memory..."

TYPE ChType
 ChName AS STRING * 8
 ChSett AS STRING * 11
END TYPE

DIM SHARED OrigPal(15) AS STRING * 3
DIM SHARED NewPal(15) AS STRING * 3
DIM SHARED Options(255) AS STRING
DIM SHARED Channel(7) AS ChType
DIM SHARED Tracks%, InstOn%, PattLen%, PatN%
DIM SHARED TrackList(255) AS STRING * 1
DIM SHARED Delay(255) AS INTEGER
n% = 0                                         'Program will NOT work without
DIM SHARED Pattern(n%, n%, n%) AS STRING * 1   'this, so don't think i'm
                                               'stupid... :)
DIM SHARED NoteF(11) AS INTEGER
DIM BarText(3) AS STRING

PRINT "Loading frequency table..."
NoteF(0) = &H16B: NoteF(1) = &H181: NoteF(2) = &H198
NoteF(3) = &H1B0: NoteF(4) = &H1CA: NoteF(5) = &H1E5
NoteF(6) = &H202: NoteF(7) = &H220: NoteF(8) = &H241
NoteF(9) = &H263: NoteF(10) = &H287: NoteF(11) = &H2AE

PRINT "Loading messages..."
BarText(0) = " Welcome to FMTracker 1.1! Written by Davey W Taylor. Tested by Andrew G! "
BarText(1) = " A great music utility written entirely in BASIC!!!   Tested by Andrew G! "
BarText(2) = " A great music utility written entirely in Quick Basic v4.5!! ENJOY IT!!! "
BarText(3) = " Welcome to FMTracker 1.1! Written by Davey *William* Taylor. ENJOY IT!!! "

TrakMode% = 20

PRINT "Initializing instruments..."
OPEN "INSTDATA.FMI" FOR BINARY ACCESS READ AS #1
 DBID$ = STRING$(14, 0)
 GET #1, , DBID$
 IF DBID$ <> "FMTInstruments" THEN PRINT "Invalid FMT instrument file!": END
 DBVer$ = STRING$(2, 0)
 GET #1, , DBVer$
 IF DBVer$ <> CHR$(1) + CHR$(0) THEN PRINT "Not version 1.0 instrument file!": END
 DBName$ = STRING$(20, 0)
 GET #1, , DBName$
 PRINT "Loading "; DBName$; " -";
 x$ = CHR$(0)
 GET #1, , x$
 insts% = ASC(x$) + 1
 PRINT insts%; "instruments!"
 DIM SHARED Instrument(insts% - 1) AS ChType
 FOR n% = 0 TO insts% - 1
  GET #1, , Instrument(n%).ChName
 NEXT n%
 FOR n% = 0 TO insts% - 1
  GET #1, , Instrument(n%).ChSett
 NEXT n%
CLOSE #1

PRINT "Initializing FM chip..."
IF DetectFM% = 0 THEN PRINT "FM chip not found!": END
InitFM

GOSUB SetMode
GOSUB ResetAll

ON ERROR GOTO SetError
SCREEN 13
IF ErrorCode% = 0 THEN
 OPEN "fmtrack.img" FOR BINARY ACCESS READ AS #1
 pal$ = SPACE$(768): GET #1, , pal$
 FOR n% = 0 TO 255
  r% = ASC(MID$(pal$, n% * 3 + 1, 1)) \ 4
  g% = ASC(MID$(pal$, n% * 3 + 2, 1)) \ 4
  b% = ASC(MID$(pal$, n% * 3 + 3, 1)) \ 4
  OUT &H3C7, n%: OUT &H3C8, n%
  OUT &H3C9, r%: OUT &H3C9, g%: OUT &H3C9, b%
 NEXT n%
 Row$ = SPACE$(320): BSeg% = VARSEG(Row$): bsad% = SADD(Row$)
 FOR y% = 1 TO 200
  GET #1, , Row$
  VSeg% = &HA1E0 + y% * 20
  FOR x% = 0 TO 319
   DEF SEG = BSeg%
   b% = PEEK(bsad% + x%)
   DEF SEG = VSeg%
   POKE x%, b%
  NEXT x%
 NEXT y%
 DEF SEG
 CLOSE #1
 WHILE INKEY$ = "": WEND
END IF
ON ERROR GOTO Unknown

WIDTH 80, 25
PRINT "Loading font..."
OPEN "fmtrack.fnt" FOR BINARY ACCESS READ AS #1
 font$ = STRING$(720, 0)
 GET #1, , font$
CLOSE #1
SetFont 179, 45, font$
PRINT "Done!"

CLS

FOR n% = 0 TO 15
 GetPal n%, r%, g%, b%
 OrigPal(n%) = CHR$(r%) + CHR$(g%) + CHR$(b%)
NEXT n%

NewPal(0) = CHR$(0) + CHR$(0) + CHR$(0)     'Black
NewPal(1) = CHR$(0) + CHR$(15) + CHR$(31)   'Background blue
NewPal(2) = CHR$(0) + CHR$(7) + CHR$(15)
NewPal(3) = CHR$(0) + CHR$(31) + CHR$(63)
NewPal(6) = CHR$(31) + CHR$(31) + CHR$(31)  'Grey & white
NewPal(7) = CHR$(63) + CHR$(63) + CHR$(63)
NewPal(8) = CHR$(31) + CHR$(0) + CHR$(0)    'Dark red, orange & green
NewPal(9) = CHR$(31) + CHR$(31) + CHR$(0)
NewPal(10) = CHR$(0) + CHR$(31) + CHR$(0)
NewPal(11) = CHR$(63) + CHR$(0) + CHR$(0)   'Bright red, orange & green
NewPal(12) = CHR$(63) + CHR$(63) + CHR$(0)
NewPal(13) = CHR$(0) + CHR$(63) + CHR$(0)
NewPal(14) = CHR$(31) + CHR$(31) + CHR$(31) 'Grey & white
NewPal(15) = CHR$(63) + CHR$(63) + CHR$(63)

PalTo 15, 1

TBoxF 1, 1, 80, 25        'Background
COLOR 3: LOCATE 1, 2: PRINT " ";
COLOR 11: PRINT "The FM Tracker: ";
COLOR 3: PRINT " "; : COLOR 2
LOCATE 25, 76: PRINT "";

FOR n% = 0 TO 7
 TBoxE 2 + 8 * n%, 15, 9 + 8 * n%, 24
 TBoxE 34 + 4 * n%, 2, 37 + 4 * n%, 13
 COLOR 15: LOCATE 16, 3 + n% * 8: PRINT "F"; LTRIM$(STR$(n% + 1));
 COLOR 8: LOCATE 16, 5 + n% * 8: PRINT "";
 COLOR 13: LOCATE 16, 7 + n% * 8: PRINT "";
NEXT n%

TBoxE 66, 15, 79, 24
TBoxE 2, 2, 17, 13
TBoxE 18, 2, 33, 13
TBoxE 66, 2, 79, 13

COLOR 2, 1: LOCATE 14, 2: PRINT "";
COLOR 3: PRINT "";
COLOR 7, 0: PRINT STRING$(74, 32);
COLOR 3, 1: PRINT "";
COLOR 2: PRINT "";

COLOR 7, 0

FOR y% = 0 TO 9
 COLOR 8 + LOG(y% + 1)
 FOR x% = 0 TO 7
  LOCATE 3 + y%, 35 + 4 * x%: PRINT "";
 NEXT x%
NEXT y%

COLOR 7
LOCATE 3, 3: PRINT "Tracks:";

LOCATE 3, 19: PRINT "Track:";                              'Track help text
LOCATE 4, 20: PRINT CHR$(27) + "/" + CHR$(26); : COLOR 6: PRINT "   select";
LOCATE 5, 27: PRINT "track"; : COLOR 7
LOCATE 6, 20: PRINT "Ctrl";
LOCATE 7, 20: PRINT CHR$(27) + "/" + CHR$(26); : COLOR 6: PRINT "   change";
LOCATE 8, 25: PRINT "pattern"; : COLOR 7
LOCATE 10, 20: PRINT "Insert "; : COLOR 6: PRINT "track"; : COLOR 7
LOCATE 11, 20: PRINT "Delete "; : COLOR 6: PRINT "track"; : COLOR 7
LOCATE 12, 20: PRINT "+/-"; : COLOR 6: PRINT "    delay"; : COLOR 7

LOCATE 3, 67: PRINT "Commands:";                           'Program help text
LOCATE 4, 68: PRINT "N"; : COLOR 6: PRINT "ew"; : COLOR 7
LOCATE 5, 68: PRINT "E"; : COLOR 6: PRINT "dit"; : COLOR 7
LOCATE 6, 68: PRINT "P"; : COLOR 6: PRINT "lay"; : COLOR 7
LOCATE 8, 68: PRINT "L"; : COLOR 6: PRINT "oad"; : COLOR 7
LOCATE 9, 68: PRINT "S"; : COLOR 6: PRINT "ave"; : COLOR 7
LOCATE 10, 68: PRINT "Q"; : COLOR 6: PRINT "uit ("; : COLOR 7: PRINT "ESC"; : COLOR 6: PRINT ")";

UpdateInst

Delay(0) = 4

UpdateTrax 1
UpdateMusx 0, 0, 0

DO
 WAIT &H3DA, 8
 WAIT &H3DA, 12

 IF BarCount% = 3 THEN
  IF Bounce% = 0 THEN
   BarPos% = BarPos% + 1
   IF BarPos% = 64 THEN
    Bounce% = 1
    BTextNum% = (BTextNum% + 1) MOD 4
   END IF
  ELSE
   BarPos% = BarPos% - 1
   IF BarPos% = 0 THEN
    Bounce% = 0
    BTextNum% = (BTextNum% + 1) MOD 4
   END IF
  END IF
  LOCATE 14, 4 + BarPos%
  COLOR 0: PRINT MID$(BarText(BTextNum%), BarPos% + 1, 1);
  COLOR 6: PRINT MID$(BarText(BTextNum%), BarPos% + 2, 2);
  COLOR 7: PRINT MID$(BarText(BTextNum%), BarPos% + 4, 4);
  COLOR 6: PRINT MID$(BarText(BTextNum%), BarPos% + 8, 2);
  COLOR 0: PRINT MID$(BarText(BTextNum%), BarPos% + 10, 1);
  BarCount% = 0
 ELSE
  BarCount% = BarCount% + 1
 END IF

Keys:
 in$ = INKEY$
 SELECT CASE in$
  CASE "N", "n"
   FOR n% = 0 TO 8
    Options(n%) = STR$(2 ^ n%)
   NEXT n%
   Options(9) = ""
  
   numeric$ = "0123456789"
   new$ = GetInput$("Choose track length (1 to 256): ", LTRIM$(STR$(TrakMode%)), 3)
   IF LEN(new$) = 0 THEN GOTO Keys
   FOR n% = 1 TO LEN(new$)
    IF INSTR(numeric$, MID$(new$, n%, 1)) = 0 THEN
     WaitKey "Invalid track length!"
     GOTO Keys
    END IF
   NEXT n%
   IF VAL(new$) > 256 THEN
    WaitKey "Invalid track length!"
    GOTO Keys
   END IF
  
   TrakMode% = VAL(new$)
   SongName$ = ""
   GOSUB SetMode
   Msg "Clearing..."
   File$ = ""
   GOSUB ResetAll
   COLOR 3, 1: LOCATE 1, 2: PRINT " ";
   COLOR 11: PRINT "The FM Tracker: ";
   COLOR 3: PRINT " ";
   PRINT STRING$(58, ""); : COLOR , 0
   UpdateTrax 1
   UpdateMusx 0, 0, 0
   UpdateInst
   ClrMsg

  CASE "L", "l"
   IF GetYN%("Clear everthing and load new?") THEN
    File$ = GetInput$("Filename: ", "", 64)
    IF File$ = "" THEN GOTO Keys
    ErrorCode% = 0
    ON ERROR GOTO SetError
    OPEN File$ FOR INPUT AS #1: CLOSE #1
    IF ErrorCode% = 0 THEN
     OPEN File$ FOR BINARY ACCESS READ AS #1
    
     Msg "Loading..."
     id$ = "FMTracker"
     Ver$ = CHR$(1) + CHR$(1)
     Tracker$ = STRING$(20, 0)
     SongSave$ = STRING$(32, 0)
     x$ = CHR$(0)
     
     GET #1, , id$
     IF id$ <> "FMTracker" THEN WaitKey "Not an FMTracker file!": GOTO Loaded
     
     GET #1, , Ver$
     IF Ver$ <> CHR$(1) + CHR$(1) THEN WaitKey "Not version 1.1!": GOTO Loaded
     
     GET #1, , Tracker$
     GET #1, , SongSave$
    
     FOR n% = 0 TO 7
      GET #1, , Channel(n%).ChName
      GET #1, , Channel(n%).ChSett
     NEXT n%
    
     GET #1, , x$
    
     TrakMode% = ASC(x$) + 1
    
     GOSUB SetMode
    
     GET #1, , x$
     Tracks% = ASC(x$) + 1
    
     ByeMess$ = "Tried to load corrupted file!"

     GET #1, , x$
     IF ASC(x$) > PatN% THEN GOTO ByeBye
     Pats% = ASC(x$) + 1
     
     FOR n% = 0 TO Tracks% - 1
      GET #1, , TrackList(n%)
      IF ASC(TrackList(n%)) > PatN% THEN GOTO ByeBye
     NEXT n%
     
     FOR n% = 0 TO Tracks% - 1
      GET #1, , x$
      Delay(n%) = ASC(x$)
     NEXT n%
    
     PatList$ = STRING$(Pats%, 0)
     GET #1, , PatList$
     FOR n% = 1 TO LEN(PatList$)
      IF ASC(MID$(PatList$, n%, 1)) > PatN% THEN GOTO ByeBye
      pn% = ASC(MID$(PatList$, n%, 1))
      FOR ChNum% = 0 TO 7
       FOR IPos% = 0 TO PattLen%
        GET #1, , x$
        XVal% = ASC(x$)
        IF XVal% AND 128 THEN
         IPos% = IPos% + (XVal% AND 127)
        ELSE
         Pattern(pn%, IPos%, ChNum%) = CHR$(XVal%)
        END IF
       NEXT IPos%
      NEXT ChNum%
     NEXT n%
    
     IF ErrorCode% <> 0 THEN GOTO ByeBye
    
     SongName$ = ""
     FOR n% = 1 TO 32
      IF MID$(SongSave$, n%, 1) = CHR$(0) THEN EXIT FOR
      SongName$ = SongName$ + MID$(SongSave$, n%, 1)
     NEXT n%
    
     COLOR 3, 1: LOCATE 1, 2: PRINT " ";
     COLOR 11: PRINT "The FM Tracker: "; SongName$;
     COLOR 3: PRINT " ";
     PRINT STRING$(58 - LEN(SongName$), ""); : COLOR , 0
    
     Track% = 1
     MusPos% = 1
     UpdateTrax 1
     UpdateMusx ASC(TrackList(0)), 0, 0
     UpdateInst
     ClrMsg
   
    ELSE
     WaitKey "Can't load file!"
    END IF
   END IF
Loaded:
   CLOSE #1
   ON ERROR GOTO Unknown

  CASE "S", "s"
   OFile$ = File$
   File$ = GetInput$("Filename: ", File$, 64)
   IF File$ = "" THEN File$ = OFile$: GOTO Keys
   OSong$ = SongName$
   SongName$ = GetInput$("Song title: ", SongName$, 32)
   IF SongName$ = "" THEN SongName$ = OSong$: GOTO Keys
  
   ErrorCode% = 0
   ON ERROR GOTO SetError
   OPEN File$ FOR OUTPUT AS #1: CLOSE #1
   IF ErrorCode% = 0 THEN
    COLOR 3, 1: LOCATE 1, 2: PRINT " ";
    COLOR 11: PRINT "The FM Tracker: "; SongName$;
    COLOR 3: PRINT " ";
    PRINT STRING$(58 - LEN(SongName$), ""); : COLOR , 0
   
    OPEN File$ FOR BINARY ACCESS WRITE AS #1
  
    Msg "Saving..."
    id$ = "FMTracker"
    Ver$ = CHR$(1) + CHR$(1)
    Tracker$ = "The FM Tracker!" + STRING$(5, 0)
    SongSave$ = SongName$ + STRING$(32 - LEN(SongName$), 0)
   
    PUT #1, , id$
    PUT #1, , Ver$
    PUT #1, , Tracker$
    PUT #1, , SongSave$
   
    FOR n% = 0 TO 7
     PUT #1, , Channel(n%).ChName
     PUT #1, , Channel(n%).ChSett
    NEXT n%
   
    x$ = CHR$(TrakMode% - 1)
    PUT #1, , x$
   
    x$ = CHR$(Tracks% - 1)
    PUT #1, , x$
  
    PatPList$ = ""
    FOR n% = 0 TO PatN%
     Used% = 0
     FOR IPos% = 0 TO PattLen%
      IF Pattern(n%, IPos%, 0) > CHR$(0) THEN Used% = -1
      IF Pattern(n%, IPos%, 1) > CHR$(0) THEN Used% = -1
      IF Pattern(n%, IPos%, 2) > CHR$(0) THEN Used% = -1
      IF Pattern(n%, IPos%, 3) > CHR$(0) THEN Used% = -1
      IF Pattern(n%, IPos%, 4) > CHR$(0) THEN Used% = -1
      IF Pattern(n%, IPos%, 5) > CHR$(0) THEN Used% = -1
      IF Pattern(n%, IPos%, 6) > CHR$(0) THEN Used% = -1
      IF Pattern(n%, IPos%, 7) > CHR$(0) THEN Used% = -1
     NEXT IPos%
     IF Used% THEN PatPList$ = PatPList$ + CHR$(n%)
    NEXT n%
   
    TrkList$ = ""
    FOR n% = 0 TO Tracks% - 1
     TrkList$ = TrkList$ + TrackList(n%)
    NEXT n%
   
    Unused% = 0
    FOR n% = 1 TO LEN(PatPList$)
     IF INSTR(TrkList$, MID$(PatPList$, n%, 1)) = 0 THEN
      Unused% = -1
     END IF
    NEXT n%
   
    IF Unused% THEN Discard% = GetYN%("Discard unused patterns?")

    PatList$ = ""
    FOR n% = 1 TO LEN(PatPList$)
     x$ = MID$(PatPList$, n%, 1)
     IF INSTR(TrkList$, x$) > 0 THEN
      PatList$ = PatList$ + x$
     ELSE
      IF Discard% = 0 THEN PatList$ = PatList$ + x$
     END IF
    NEXT n%
   
    IF LEN(PatList$) = 0 THEN PatList$ = CHR$(0)

    x$ = CHR$(LEN(PatList$) - 1)
    PUT #1, , x$
   
    PUT #1, , TrkList$

    FOR n% = 0 TO Tracks% - 1
     x$ = CHR$(Delay(n%))
     PUT #1, , x$
    NEXT n%
    
    PUT #1, , PatList$
   
    FOR n% = 1 TO LEN(PatList$)
     IF ASC(MID$(PatList$, n%, 1)) > PatN% THEN GOTO ByeBye
     pn% = ASC(MID$(PatList$, n%, 1))
     FOR ChNum% = 0 TO 7
      UUsed% = 0
      FOR IPos% = 0 TO PattLen%
       IF Pattern(pn%, IPos%, ChNum%) > CHR$(0) THEN
        IF UUsed% > 0 THEN
         x$ = CHR$(128 + UUsed% - 1)
         PUT #1, , x$
         UUsed% = 0
        END IF
        x$ = Pattern(pn%, IPos%, ChNum%)
        PUT #1, , x$
       ELSE
        UUsed% = UUsed% + 1
        IF UUsed% = 128 THEN
         x$ = CHR$(255)
         PUT #1, , x$
         UUsed% = 0
        END IF
       END IF
      NEXT IPos%
      IF UUsed% > 0 THEN
       x$ = CHR$(128 + UUsed% - 1)
       PUT #1, , x$
      END IF
     NEXT ChNum%
    NEXT n%
   
    IF ErrorCode% <> 0 THEN WaitKey "An error occured during save... File might be corrupt!"
    ON ERROR GOTO Unknown
   
    CLOSE #1
    ClrMsg

   END IF

  CASE "Q", "q", CHR$(27)
   IF GetYN%("Are you sure you want to quit?") = 0 THEN GOTO Keys
   IF GetYN%("Are you really sure?") = 0 THEN GOTO Keys
   ByeMess$ = "Davey W Taylor - 97"
   
ByeBye:
   CLS
   CLOSE #1
   FOR n% = 0 TO 15
    r% = ASC(MID$(OrigPal(n%), 1, 1))
    g% = ASC(MID$(OrigPal(n%), 2, 1))
    b% = ASC(MID$(OrigPal(n%), 3, 1))
    SetPal n%, r%, g%, b%
   NEXT n%
  
   ResetFont
   COLOR 7, 0
   PRINT ByeMess$
   END
 
  CASE "P", "p"
   PalTo 7, 4
   TrackN% = Track% - 1
   PlayIt TrackN%, MusPos%
   Track% = TrackN%
   PalTo 15, 1

  CASE "1" TO "8"
   inum% = VAL(in$) - 1
   now% = 1
   FOR n% = 0 TO insts% - 1
    Options(n%) = Instrument(n%).ChName
    Ins$ = Instrument(n%).ChName
    IF Ins$ = Channel(inum%).ChName THEN now% = n% + 1
   NEXT n%
   new% = GetOpt%("Instrument for channel" + STR$(inum% + 1) + ": ", now%)
   IF new% > 0 THEN
    Channel(inum%).ChName = Instrument(new% - 1).ChName
    Channel(inum%).ChSett = Instrument(new% - 1).ChSett
   END IF
   UpdateInst
 
  CASE CHR$(0) + "K"
   IF Track% > 1 THEN
    Track% = Track% - 1
    MusPos% = 1
    UpdateTrax Track%
    UpdateMusx ASC(TrackList(Track% - 1)), MusPos% - 1, 0
   END IF
 
  CASE CHR$(0) + "M"
   IF Track% < Tracks% THEN
    Track% = Track% + 1
    MusPos% = 1
    UpdateTrax Track%
    UpdateMusx ASC(TrackList(Track% - 1)), MusPos% - 1, 0
   END IF
 
  CASE CHR$(0) + "R"
   IF Tracks% < 256 THEN
    Tracks% = Tracks% + 1
    Track% = Tracks%
    MusPos% = 1
    TrackList(Track% - 1) = CHR$(0)
    Delay(Track% - 1) = 4
    UpdateTrax Track%
    UpdateMusx ASC(TrackList(Track% - 1)), MusPos% - 1, 0
   END IF
 
  CASE CHR$(0) + "S"
   IF Tracks% > 1 THEN
    FOR n% = Track% - 1 TO Tracks% - 2
     TrackList(n%) = TrackList(n% + 1)
    NEXT n%
    Tracks% = Tracks% - 1
    MusPos% = 1
    IF Track% > Tracks% THEN Track% = Tracks%
    UpdateTrax Track%
    UpdateMusx ASC(TrackList(Track% - 1)), MusPos% - 1, 0
   END IF
 
  CASE "+"
   Delay(Track% - 1) = Delay(Track% - 1) + 1
   IF Delay(Track% - 1) = 9 THEN Delay(Track% - 1) = 8
   UpdateTrax Track%

  CASE "-"
   Delay(Track% - 1) = Delay(Track% - 1) - 1
   IF Delay(Track% - 1) = 0 THEN Delay(Track% - 1) = 1
   UpdateTrax Track%
  
  CASE CHR$(0) + "s"
   IF TrackList(Track% - 1) > CHR$(0) THEN
    TrackList(Track% - 1) = CHR$(ASC(TrackList(Track% - 1)) - 1)
    MusPos% = 1
    UpdateTrax Track%
    UpdateMusx ASC(TrackList(Track% - 1)), MusPos% - 1, 0
   END IF
 
  CASE CHR$(0) + "t"
   IF TrackList(Track% - 1) < CHR$(PatN%) THEN
    TrackList(Track% - 1) = CHR$(ASC(TrackList(Track% - 1)) + 1)
    MusPos% = 1
    UpdateTrax Track%
    UpdateMusx ASC(TrackList(Track% - 1)), MusPos% - 1, 0
   END IF
 
  CASE CHR$(0) + "H"
   IF MusPos% > 1 THEN
    MusPos% = MusPos% - 1
   ELSE
    MusPos% = PattLen% + 1
   END IF
   UpdateMusx ASC(TrackList(Track% - 1)), MusPos% - 1, 0
 
  CASE CHR$(0) + "P"
   IF MusPos% < PattLen% + 1 THEN
    MusPos% = MusPos% + 1
   ELSE
    MusPos% = 1
   END IF
   UpdateMusx ASC(TrackList(Track% - 1)), MusPos% - 1, 0
  
  CASE CHR$(0) + ";" TO CHR$(0) + "B"
   InstNum% = ASC(RIGHT$(in$, 1)) - 59
   Inst% = 2 ^ InstNum%
   IF InstOn% AND Inst% THEN was% = 0 ELSE was% = 1
   InstOn% = InstOn% AND (255 - Inst%)
   InstOn% = InstOn% OR Inst% * was%
   LOCATE 16, 5 + InstNum% * 8
   IF (InstOn% AND Inst%) = 0 THEN
    COLOR 8: PRINT ""
   ELSE
    COLOR 11: PRINT ""
   END IF
   LOCATE 16, 7 + InstNum% * 8
   IF InstOn% AND Inst% THEN
    COLOR 10: PRINT ""
   ELSE
    COLOR 13: PRINT ""
   END IF

  CASE "E", "e"
   COLOR 15
   LOCATE 3, 19: PRINT "Edit: ";
   LOCATE 4, 20: PRINT CHR$(27) + "/" + CHR$(26); : COLOR 14: PRINT "   select";
   LOCATE 5, 25: PRINT "channel"; : COLOR 15
   LOCATE 6, 20: PRINT CHR$(24) + "/" + CHR$(25); : COLOR 14: PRINT "     move";
   LOCATE 7, 20: PRINT "      marker"; : COLOR 15
   LOCATE 8, 25: PRINT "       "; : COLOR 15
   LOCATE 8, 20: PRINT "+/-"; : COLOR 14: PRINT "    pitch";
   LOCATE 9, 25: PRINT "channel"; : COLOR 15
   LOCATE 10, 20: PRINT "            ";
   LOCATE 11, 20: PRINT "PgUp"; : COLOR 14: PRINT "    copy"; : COLOR 15
   LOCATE 12, 20: PRINT "PgDown"; : COLOR 14: PRINT " paste"; : COLOR 15
  
   PalTo 13, 4
  
   Edit ASC(TrackList(Track% - 1)), MusPos%
  
   PalTo 15, 1
  
   COLOR 7
   LOCATE 3, 19: PRINT "Track:";
   LOCATE 4, 20: PRINT CHR$(27) + "/" + CHR$(26); : COLOR 6: PRINT "   select";
   LOCATE 5, 25: PRINT "  track"; : COLOR 7
   LOCATE 6, 20: PRINT "Ctrl        ";
   LOCATE 7, 20: PRINT CHR$(27) + "/" + CHR$(26); : COLOR 6: PRINT "   change";
   LOCATE 8, 20: PRINT "     pattern"; : COLOR 7
   LOCATE 9, 25: PRINT "       ";
   LOCATE 10, 20: PRINT "Insert "; : COLOR 6: PRINT "track"; : COLOR 7
   LOCATE 11, 20: PRINT "Delete "; : COLOR 6: PRINT "track"; : COLOR 7
   LOCATE 12, 20: PRINT "+/-"; : COLOR 6: PRINT "    delay"; : COLOR 7
  
  CASE "#"
  
   Msg "The FM Tracker! Special thank's to Andrew S Gibson for his excellent help!"

   p1! = 0: p2! = 0: p3! = 0
   WHILE INKEY$ = ""
     p1! = p1! + .0314: PVal1! = (1 + COS(p1!)) / 2
     IF p1! > 6.28 THEN p1! = p1! - 6.28
     p2! = p2! + .0628: PVal2! = (1 + COS(p2!)) / 2
     IF p2! > 6.28 THEN p2! = p2! - 6.28
     p3! = p3! + .0942: PVal3! = (1 + COS(p3!)) / 2
     IF p3! > 6.28 THEN p3! = p3! - 6.28
    
     WAIT &H3DA, 8
     FOR n% = 1 TO 15
      r% = ASC(MID$(NewPal(n%), 1, 1)) * PVal1!
      g% = ASC(MID$(NewPal(n%), 2, 1)) * PVal2!
      b% = ASC(MID$(NewPal(n%), 3, 1)) * PVal3!
      SetPal n%, r%, g%, b%
     NEXT n%
   WEND
   PalTo 15, 1

   ClrMsg

 END SELECT
LOOP

SetMode:
 PatN% = 4096 \ TrakMode% - 1
 IF PatN% > 255 THEN PatN% = 255
 PattLen% = TrakMode% - 1
 REDIM SHARED Pattern(PatN% + 1, PattLen%, 7)  AS STRING * 1
 RETURN

ResetAll:
 FOR n% = 0 TO 7
  Channel(n%).ChName = Instrument(0).ChName
  Channel(n%).ChSett = Instrument(0).ChSett
 NEXT n%
 FOR n% = 0 TO 255
  TrackList(n%) = CHR$(0)
  Delay(n%) = 4
 NEXT n%
 FOR n% = 0 TO PatN%
  FOR IPos% = 0 TO PattLen%
   Pattern(n%, IPos%, 0) = CHR$(0)
   Pattern(n%, IPos%, 1) = CHR$(0)
   Pattern(n%, IPos%, 2) = CHR$(0)
   Pattern(n%, IPos%, 3) = CHR$(0)
   Pattern(n%, IPos%, 4) = CHR$(0)
   Pattern(n%, IPos%, 5) = CHR$(0)
   Pattern(n%, IPos%, 6) = CHR$(0)
   Pattern(n%, IPos%, 7) = CHR$(0)
  NEXT IPos%
 NEXT n%
 Tracks% = 1
 Track% = 1
 MusPos% = 1
 RETURN

SetError:
 ErrorCode% = ERR
 RESUME NEXT

Unknown:
 COLOR 11, 0
 CLS
 PRINT "Unknown error! Font and palette was not restored!"
 END

FMIRegs:
 DATA 32,64,96,128,224,192

SUB ClrMsg
 COLOR 7
 LOCATE 14, 4: PRINT STRING$(74, 32);
END SUB

FUNCTION DetectFM%
 WriteReg 4, &H60
 WriteReg 4, &H80
 data1% = INP(&H388)
 WriteReg 2, &HFF
 WriteReg 4, &H21
 FOR d% = 1 TO 150: x% = INP(&H388): NEXT d%
 data2% = INP(&H388)
 WriteReg 4, &H60
 WriteReg 4, &H80
 IF (data1% AND &HE0) = 0 AND (data2% AND &HE0) = &HC0 THEN DetectFM% = -1
END FUNCTION

SUB Edit (Patt%, Center%)
 Msg "Editing! ENTER done. [Shift+]CDEFGAB note. 0-7 octave. X stop. DEL erase."
 EChan% = 1
 Row% = Center% - 1
 UpdateMusx Patt%, Row%, 1
 Hi$ = ". !" + CHR$(34) + "0"
 Lo$ = ". !" + CHR$(34) + "0"

 SetInstruments

 Kbdl% = 18
 DO
 
  KBds% = INP(96): IF KBds% = Kbdl% THEN KBds% = 0 ELSE Kbdl% = KBds%
  IF KBds% < 128 THEN
   DEF SEG = 65: IF PEEK(7) AND 3 THEN KBds% = KBds% + 128: DEF SEG
   Key$ = CHR$(KBds%)
   IF INSTR(Hi$, Key$) THEN
   
    Pat% = ASC(Pattern(Patt%, Row%, EChan% - 1)) - 2
    IF Pat% < 0 THEN Pat% = 37
    Octv% = INT(Pat% / 12): This% = INSTR(Hi$, Key$) + Octv% * 12
    Pattern(Patt%, Row%, EChan% - 1) = CHR$(This% + 1)
    Freq% = NoteF(INSTR(Hi$, Key$) - 1): Chan% = (Chan% + 1) MOD 8
    WriteReg &HA0 + EChan% - 1, Freq% AND &HFF
    WriteReg &HB0 + EChan% - 1, INT(Freq% / 256) OR 32 OR (Octv% * 4)
    UpdateMusx Patt%, Row%, EChan%
  
   END IF
  ELSE
   KBds% = KBds% - 128: Key$ = CHR$(KBds%)
   IF INSTR(Lo$, Key$) THEN
   
    FOR Chan% = 0 TO 7
     WriteReg &HB0 + Chan%, 0: WriteReg &HA0 + Chan%, 0
    NEXT Chan%
  
   END IF
  END IF
 
  in$ = INKEY$
  SELECT CASE in$
   CASE CHR$(13): EXIT DO
   CASE CHR$(0) + "H"
    Row% = Row% - 1
    IF Row% = -1 THEN Row% = PattLen%
    UpdateMusx Patt%, Row%, EChan%

   CASE CHR$(0) + "P"
    Row% = (Row% + 1) MOD (PattLen% + 1)
    UpdateMusx Patt%, Row%, EChan%

   CASE CHR$(0) + "K"
    EChan% = EChan% - 1
    IF EChan% = 0 THEN EChan% = 8
    UpdateMusx Patt%, Row%, EChan%

   CASE CHR$(0) + "M"
    EChan% = EChan% + 1
    IF EChan% = 9 THEN EChan% = 1
    UpdateMusx Patt%, Row%, EChan%

   CASE "0" TO "7"
    Pat% = ASC(Pattern(Patt%, Row%, EChan% - 1)) - 2
    IF Pat% = -1 THEN Pat% = 0
    Note% = Pat% MOD 12
    This% = VAL(in$) * 12 + Note% + 2
    Pattern(Patt%, Row%, EChan% - 1) = CHR$(This%)
    UpdateMusx Patt%, Row%, EChan%
  
   CASE "X", "x"
    Pattern(Patt%, Row%, EChan% - 1) = CHR$(1)
    UpdateMusx Patt%, Row%, EChan%
  
   CASE " ", CHR$(0) + "S"
    Pattern(Patt%, Row%, EChan% - 1) = CHR$(0)
    UpdateMusx Patt%, Row%, EChan%
  
   CASE "+"
    FOR n% = 0 TO PattLen%
     This% = ASC(Pattern(Patt%, n%, EChan% - 1))
     IF This% = 97 THEN EXIT FOR
    NEXT n%
    IF n% = PattLen% + 1 THEN
     FOR n% = 0 TO PattLen%
      This% = ASC(Pattern(Patt%, n%, EChan% - 1))
      IF This% > 1 THEN Pattern(Patt%, n%, EChan% - 1) = CHR$(This% + 1)
     NEXT n%
    END IF
    UpdateMusx Patt%, Row%, EChan%

   CASE "-"
    FOR n% = 0 TO PattLen%
     This% = ASC(Pattern(Patt%, n%, EChan% - 1))
     IF This% = 2 THEN EXIT FOR
    NEXT n%
    IF n% = PattLen% + 1 THEN
     FOR n% = 0 TO PattLen%
      This% = ASC(Pattern(Patt%, n%, EChan% - 1))
      IF This% > 1 THEN Pattern(Patt%, n%, EChan% - 1) = CHR$(This% - 1)
     NEXT n%
    END IF
    UpdateMusx Patt%, Row%, EChan%
  
   CASE CHR$(0) + "I"
    FOR Chan% = 0 TO 7
     FOR n% = 0 TO PattLen%
      Pattern(PatN% + 1, n%, Chan%) = Pattern(Patt%, n%, Chan%)
     NEXT n%
    NEXT Chan%

   CASE CHR$(0) + "Q"
    IF GetYN%("Replace this track with clipboard?") THEN
     FOR Chan% = 0 TO 7
      FOR n% = 0 TO PattLen%
       Pattern(Patt%, n%, Chan%) = Pattern(PatN% + 1, n%, Chan%)
      NEXT n%
     NEXT Chan%
     UpdateMusx Patt%, Row%, EChan%
    END IF
    Msg ""
  
  END SELECT
 LOOP

 UpdateMusx Patt%, Row%, 0
 Center% = Row% + 1
 ClrMsg
END SUB

FUNCTION GetInput$ (mess$, def$, max%)
 COLOR 7
 LOCATE 14, 4: PRINT STRING$(74, 32);
 got$ = def$
 LOCATE 14, 4, 1: PRINT mess$; got$;
 DO
  in$ = INKEY$
  SELECT CASE in$
   CASE CHR$(8)
    IF LEN(got$) > 0 THEN
     got$ = LEFT$(got$, LEN(got$) - 1)
     LOCATE , POS(0) - 1
     PRINT " ";
     LOCATE , POS(0) - 1
    END IF

   CASE CHR$(13)
    IF LEN(got$) = 0 THEN
     BEEP
    ELSE
     GetInput$ = got$
     GOTO Inputed
    END IF
   CASE CHR$(27)
    GetInput$ = ""
    GOTO Inputed
   CASE ELSE
    IF LEN(in$) = 1 THEN
     IF LEN(got$) < max% THEN
      PRINT in$;
      got$ = got$ + in$
     END IF
    END IF
  END SELECT
 LOOP
Inputed:
 LOCATE 14, 4, 0: PRINT STRING$(74, 32);
END FUNCTION

FUNCTION GetOpt% (mess$, now%)
 COLOR 7
 LOCATE 14, 4: PRINT STRING$(74, 32);
 LOCATE 14, 4: PRINT mess$;
 ps% = POS(0)
 DO UNTIL Options(max%) = ""
  max% = max% + 1
 LOOP
 max% = max% - 1
 sel% = now% - 1
 PRINT Options(sel%);
 DO
  SELECT CASE INKEY$
   CASE CHR$(13)
    GetOpt% = sel% + 1
    LOCATE 14, 4: PRINT STRING$(74, 32);
    EXIT FUNCTION
   CASE CHR$(27)
    GetOpt% = 0
    LOCATE 14, 4: PRINT STRING$(74, 32);
    EXIT FUNCTION
   CASE CHR$(0) + "H"
    IF sel% > 0 THEN
     LOCATE , ps%: PRINT STRING$(LEN(Options(sel%)), 32);
     sel% = sel% - 1
     LOCATE , ps%: PRINT Options(sel%);
    END IF
   CASE CHR$(0) + "P"
    IF sel% < max% THEN
     LOCATE , ps%: PRINT STRING$(LEN(Options(sel%)), 32);
     sel% = sel% + 1
     LOCATE , ps%: PRINT Options(sel%);
    END IF
  END SELECT
 LOOP
END FUNCTION

SUB GetPal (n%, r%, g%, b%)
 p% = n%
 SELECT CASE p%
  CASE 6: p% = 20
  CASE 8 TO 15: p% = p% + 48
 END SELECT
 OUT &H3C7, p%
 OUT &H3C8, p%
 r% = INP(&H3C9)
 g% = INP(&H3C9)
 b% = INP(&H3C9)
END SUB

FUNCTION GetYN% (mess$)
 COLOR 15
 LOCATE 14, 4: PRINT STRING$(74, 32);
 LOCATE 14, 4: PRINT mess$;
 DO
  in$ = UCASE$(INKEY$)
 LOOP UNTIL in$ = "Y" OR in$ = "N"
 IF in$ = "Y" THEN GetYN% = -1
 LOCATE 14, 4: PRINT STRING$(74, 32);
END FUNCTION

SUB InitFM
 FOR n% = 0 TO &HF5
  WriteReg n%, 0
 NEXT n%
END SUB

SUB Msg (mess$) STATIC
 COLOR 15
 LOCATE 14, 4: PRINT STRING$(74, 32); : LOCATE 14, 4
 IF mess$ = "" THEN
  PRINT last$
 ELSE
  PRINT mess$;
  last$ = mess$
 END IF
END SUB

SUB PalTo (max%, div%)
 FOR n% = 0 TO max%
  r% = ASC(MID$(NewPal(n%), 1, 1)) \ div%
  g% = ASC(MID$(NewPal(n%), 2, 1)) \ div%
  b% = ASC(MID$(NewPal(n%), 3, 1)) \ div%
  SetPal n%, r%, g%, b%
 NEXT n%
END SUB

SUB PlayIt (ioTrack%, oPos%)
 Msg "Playing... ENTER stop. F1 through F8 channel on/off."
 DEF SEG = 0

 SetInstruments

 DIM VBar(7) AS INTEGER

 n% = ioTrack% - 1
 nxt& = PEEK(1133)
 nxt& = (PEEK(1132) + nxt& * 256) MOD 65536

 DO
  n% = n% + 1
  IF n% = Tracks% THEN n% = 0
  PlyPat% = ASC(TrackList(n%))
 
  nxt& = nxt& - TDel%
  TDel% = Delay(n%)
  nxt& = nxt& + TDel%
 
  FOR IPos% = 0 TO PattLen%
   
   DO
    now& = PEEK(1133)
    now& = (PEEK(1132) + now& * 256) MOD 65536
   LOOP UNTIL now& >= nxt&
   nxt& = (nxt& + TDel%) MOD 65536
  
   FOR Chan% = 0 TO 7
    Note% = ASC(Pattern(PlyPat%, IPos%, Chan%)) - 2
    IF Note% > -2 THEN
     WriteReg &HA0 + Chan%, 0
     WriteReg &HB0 + Chan%, 0
    END IF
    IF Note% >= 0 THEN
     IF (InstOn% AND (2 ^ Chan%)) = 0 THEN
      Octv% = INT(Note% / 12)
      Freq% = NoteF%(Note% MOD 12)
      WriteReg &HA0 + Chan%, Freq% AND &HFF
      WriteReg &HB0 + Chan%, INT(Freq% / 256) OR 32 OR (Octv% * 4)
      VBar(Chan%) = 11
     END IF
    END IF
    IF VBar(Chan%) > 0 THEN VBar(Chan%) = VBar(Chan%) - 1
   NEXT Chan%
  
   UpdateMusx PlyPat%, IPos%, 0
   UpdateTrax n% + 1
   UpdateVols VBar()
  
   in$ = INKEY$
   IF in$ <> "" THEN
    IF in$ = CHR$(13) THEN GOTO Done
    IF in$ >= CHR$(0) + ";" AND in$ <= CHR$(0) + "B" THEN
     InstNum% = ASC(RIGHT$(in$, 1)) - 59
     Inst% = 2 ^ InstNum%
     IF InstOn% AND Inst% THEN was% = 0 ELSE was% = 1
     InstOn% = InstOn% AND (255 - Inst%)
     InstOn% = InstOn% OR Inst% * was%
     LOCATE 16, 5 + InstNum% * 8
     IF (InstOn% AND Inst%) = 0 THEN
      COLOR 8: PRINT ""
     ELSE
      COLOR 11: PRINT ""
     END IF
     LOCATE 16, 7 + InstNum% * 8
     IF InstOn% AND Inst% THEN
      COLOR 10: PRINT ""
     ELSE
      COLOR 13: PRINT ""
     END IF
    END IF
   END IF
  NEXT IPos%
 LOOP

Done:
 FOR Chan% = 0 TO 7
  WriteReg &HA0 + Chan%, 0: WriteReg &HB0 + Chan%, 0: VBar(Chan%) = 0
 NEXT Chan%
 UpdateVols VBar()
 ioTrack% = n% + 1
 oPos% = IPos% + 1
 DEF SEG
 ClrMsg
END SUB

SUB ResetFont
 asm$ = CHR$(184) + CHR$(3) + CHR$(0)
 asm$ = asm$ + CHR$(205) + CHR$(16)
 asm$ = asm$ + CHR$(184) + CHR$(0) + CHR$(76)
 asm$ = asm$ + CHR$(205) + CHR$(33)
 OPEN "~temp.com" FOR BINARY ACCESS WRITE AS #1
  PUT #1, , asm$
 CLOSE #1
 SHELL "~temp.com"
 KILL "~temp.com"
END SUB

SUB SetFont (Start%, Chars%, font$)
 asm$ = CHR$(184) + CHR$(0) + CHR$(17)            'MOV AX, 1100h
 asm$ = asm$ + CHR$(187) + CHR$(0) + CHR$(16)     'MOV BX, 1000h
 asm$ = asm$ + CHR$(186) + CHR$(Start%) + CHR$(0) 'MOV DX, Start%
 asm$ = asm$ + CHR$(185) + CHR$(Chars%) + CHR$(0) 'MOV CX, Chars%
 asm$ = asm$ + CHR$(189) + CHR$(22) + CHR$(1)     'MOV BP, offset FONT
 asm$ = asm$ + CHR$(205) + CHR$(16)               'INT 10h
 asm$ = asm$ + CHR$(184) + CHR$(0) + CHR$(76)     'MOV AX, 4C00h
 asm$ = asm$ + CHR$(205) + CHR$(33)               'INT 21h
 asm$ = asm$ + font$

 OPEN "~temp.com" FOR BINARY ACCESS WRITE AS #1
  PUT #1, , asm$
 CLOSE #1
 SHELL "~temp.com"
 KILL "~temp.com"
END SUB

SUB SetInstruments
 FOR Chan% = 0 TO 7
  ChanX% = (Chan% MOD 3) + 8 * INT(Chan% / 3)
  Inst$ = Channel(Chan%).ChSett
  RESTORE FMIRegs
  FOR n% = 1 TO 11
   IF n% AND 1 THEN READ reg% ELSE reg% = reg% + 3
   IF n% = 11 THEN WReg% = reg% + Chan% ELSE WReg% = reg% + ChanX%
   WriteReg WReg%, ASC(MID$(Inst$, n%, 1))
  NEXT n%
 NEXT Chan%
END SUB

SUB SetPal (n%, r%, g%, b%)
 p% = n%
 SELECT CASE p%
  CASE 6: p% = 20
  CASE 8 TO 15: p% = p% + 48
 END SELECT
 OUT &H3C7, p%
 OUT &H3C8, p%
 OUT &H3C9, r%
 OUT &H3C9, g%
 OUT &H3C9, b%
END SUB

SUB TBoxE (x1%, y1%, x2%, y2%)

 COLOR 0, 1
 COLOR 2: LOCATE y1%, x1%: PRINT ""; : LOCATE y2%, x1%: PRINT "";
 COLOR 3: LOCATE y1%, x2%: PRINT ""; : LOCATE y2%, x2%: PRINT "";
 FOR x% = x1% + 1 TO x2% - 1
  COLOR 2: LOCATE y1%, x%: PRINT "";
  COLOR 3: LOCATE y2%, x%: PRINT "";
 NEXT x%
 FOR y% = y1% + 1 TO y2% - 1
  COLOR 2: LOCATE y%, x1%: PRINT "";
  COLOR 3: LOCATE y%, x2%: PRINT "";
 NEXT y%
 COLOR 0, 0
 FOR x% = x1% + 1 TO x2% - 1
  FOR y% = y1% + 1 TO y2% - 1
   LOCATE y%, x%: PRINT " ";
  NEXT y%
 NEXT x%
END SUB

SUB TBoxF (x1%, y1%, x2%, y2%)
                                            
 COLOR 0, 1
 COLOR 3: LOCATE y1%, x1%: PRINT ""; : LOCATE y2%, x1%: PRINT "";
 COLOR 2: LOCATE y1%, x2%: PRINT ""; : LOCATE y2%, x2%: PRINT "";
 FOR x% = x1% + 1 TO x2% - 1
  COLOR 3: LOCATE y1%, x%: PRINT "";
  COLOR 2: LOCATE y2%, x%: PRINT "";
 NEXT x%
 FOR y% = y1% + 1 TO y2% - 1
  COLOR 3: LOCATE y%, x1%: PRINT "";
  COLOR 2: LOCATE y%, x2%: PRINT "";
 NEXT y%
 COLOR 0, 1
 FOR x% = x1% + 1 TO x2% - 1
  FOR y% = y1% + 1 TO y2% - 1
   LOCATE y%, x%: PRINT " ";
  NEXT y%
 NEXT x%
END SUB

SUB UpdateInst
 FOR n% = 0 TO 7
  COLOR 7
  LOCATE 16 + n%, 67: PRINT LTRIM$(STR$(n% + 1));
  COLOR 6
  PRINT " - ";
  PRINT Channel(n%).ChName;
 NEXT n%
END SUB

SUB UpdateMusx (Patt%, Center%, ChanHi%)
 Notes$ = "C C#D D#E F F#G G#A A#B "

 FOR Chan% = 0 TO 7
  COLOR 14
  FOR n% = 0 TO 2
   LOCATE 19 - n%, 3 + 8 * Chan%
   IF Center% - n% < 1 THEN
    PRINT "      ";
   ELSE
   
    Pat% = ASC(Pattern(Patt%, Center% - n% - 1, Chan%)) - 2
    Note% = Pat% MOD 12
    octa% = INT(Pat% / 12)
    num$ = HEX$(Center% - n% - 1)
    IF LEN(num$) = 1 THEN num$ = "0" + num$
   
    PRINT num$; " ";
    IF Note% = -2 THEN
     PRINT "---";
    ELSEIF Note% = -1 THEN
     PRINT "-X-";
    ELSE
     nstr$ = MID$(Notes$, 1 + Note% * 2, 2)
     octa$ = LTRIM$(STR$(octa%))
     PRINT nstr$; octa$;
    END IF
  
   END IF
  NEXT n%
 
  FOR n% = 0 TO 3
   IF n% = 0 THEN
    IF ChanHi% = 0 THEN
     COLOR 15
    ELSE
     IF ChanHi% = Chan% + 1 THEN COLOR 15
    END IF
   END IF
  
   LOCATE 20 + n%, 3 + 8 * Chan%
   IF Center% + n% > PattLen% THEN
    PRINT "      ";
   ELSE
   
    Pat% = ASC(Pattern(Patt%, Center% + n%, Chan%)) - 2
    Note% = Pat% MOD 12
    octa% = INT(Pat% / 12)
    num$ = HEX$(Center% + n%)
    IF LEN(num$) = 1 THEN num$ = "0" + num$
   
    PRINT num$; " ";
    IF Note% = -2 THEN
     PRINT "---";
    ELSEIF Note% = -1 THEN
     PRINT "-X-";
    ELSE
     nstr$ = MID$(Notes$, 1 + Note% * 2, 2)
     octa$ = LTRIM$(STR$(octa%))
     PRINT nstr$; octa$;
    END IF
  
   END IF
   IF n% = 0 THEN COLOR 14
  NEXT n%
 NEXT Chan%
END SUB

SUB UpdateTrax (Center%)
 
 top% = Center% - 4
 IF top% < 1 THEN top% = 1
 numto% = top% + 8
 IF numto% > Tracks% THEN top% = Tracks% - 8: numto% = Tracks%
 IF top% < 1 THEN top% = 1


 FOR n% = 0 TO numto% - top%
  IF n% = Center% - top% THEN COLOR 7 ELSE COLOR 6
  LOCATE 4 + n%, 4
  tname$ = HEX$(n% + top% - 1)
  IF LEN(tname$) = 1 THEN tname$ = "0" + tname$
  PRINT tname$; " : ";
  pname$ = HEX$(ASC(TrackList(n% + top% - 1)))
  IF LEN(pname$) = 1 THEN pname$ = "0" + pname$
  PRINT pname$; "  - " + LTRIM$(STR$(Delay(n% + top% - 1)));
 NEXT n%

 FOR n% = numto% - top% TO 7
  LOCATE 5 + n%, 4: PRINT "            "
 NEXT n%

END SUB

DEFINT A-Z
SUB UpdateVols (Vols())
 FOR x% = 0 TO 7
  FOR y% = 0 TO 9 - Vols(x%)
   COLOR 8 + LOG(y% + 1)
   LOCATE 3 + y%, 35 + 4 * x%: PRINT "";
  NEXT y%
 
  FOR y% = 10 - Vols(x%) TO 9
   COLOR 11 + LOG(y% + 1)
   LOCATE 3 + y%, 35 + 4 * x%: PRINT "";
  NEXT y%
 NEXT x%
END SUB

DEFSNG A-Z
SUB WaitKey (mess$)
 COLOR 7
 LOCATE 14, 4: PRINT STRING$(74, 32);
 LOCATE 14, 4: PRINT mess$ + " Press any key...";
 WHILE INKEY$ = "": WEND
 LOCATE 14, 4: PRINT STRING$(74, 32);
END SUB

SUB WriteReg (reg%, info%)
 OUT &H388, reg%
 FOR d% = 1 TO 6: x% = INP(&H388): NEXT d%
 OUT &H389, info%
 FOR d% = 1 TO 35: x% = INP(&H388): NEXT d%
END SUB

