' ===========================================================================
'                            
'                                           
'                                    
'                                       
'                      
' ===========================================================================
'                     Copyright 2000 Sebastian Mate
'
'                  - An "impossible with QB"-program -
'
'
' Program:     RealMIDI
' Description: The first REAL MIDI-player for QB!
' Author:      Sebastian Mate (jmate@t-online.de)
' Version:     1.00

' Welcome
' -------
' Yes, this THE first real MIDI-player for QB that is not using any resident
' programs! It's directly reading, interpreting and playing the file on
' your soundcard using the FM-Synthesis or even on your built-in speaker!

' Disclaimer
' ----------
' The programmer assumes no responsibility for any harm or costs
' that comes from using the material contained in these files and to
' you, your computer, or anything relating to your existence. No
' warranty is provided or implied on these files!
' This file is provided as is.
' You can use this program in any way you want, however, please
' give me credits.

' Limitations
' -----------
' Every program has it's possitive and negative aspects. My proggy, too.
' Read them:

'  [+]  for professional use
'  [+]  doesn't need any TSR-program (memory resident)
'  [+]  no errors with other software
'  [+]  can play lyrics (requires a small modifaction, see source)
'  [+]  easy to run
'  [+]  sound-output via FM-Synthesis (soundcard) or internal speaker
'  [-]  only MIDI-format 0 is supported
'  [-]  only 9 Tracks and 9 voices at one time
'  [-]  not a complete drumset with some problems (read below)

' Is RealMIDI good for games?
' ---------------------------
' If you want to play music in the background while the game is running,
' no. RealMIDI is using delays, and this would make your program slow.
'  RealMIDI was written to allow you to convert MIDI-files into other
' formats and to write MIDI-applications (sequencers, etc.).

' The Nine Voices
' ---------------
' Yes, RealMIDI only supports only 9 voices at one time and is limited
' to 9 MIDI-Tracks. Why?! The default soundcard can only output 9 channels.
' Other MIDI-players can manage to play 16 or more tracks once using
' only the 9 channels. However, I tried to do so, but it did not work very
' well. The 9 voices: each of the nine channels can output only 1 sound.
' Normaly, FM-synthesis soundcards can generate 32 sounds. The next version
' of RealMIDI can do this.
' You will notice, if you play an other MIDI-0 file with more than 9 tracks,
' that the sequencer shows that "there's something playing". There is nothing
' playing.
' I think: 9 voices once are enouth for a OK sound. If you run this program,
' you will see...

' The drumset
' -----------
' The biggest problem of RealMIDI is the drumset. It can't detect it, so
' you have to set the channel manually. I have noticed, during the sequencing
' the demonstration file, that my sequencer used every time channel 10 for
' the drumset (a MIDI-specification?). But this is out of the 9 channels,
' and I had to make the drumset-track a piano to store it on track 9.
' The dumset is incomplete. It's simply using a snare-drum.

' Credits
' -------
' This program would not be possible without using parts from to two
' other great programmers:
' -> Luke Erren wrote a program that could play MIDI-files using the
'    MPU404-interface. You have to connect your computer to a MIDI-keyboard.
' -> Davey W. Taylor, he wrote a FM-Tracer from which I used the support
'    for the FM-Synthesis.
'
' Tons of changes had been made, but now it's working. If you like this
' program and want to get more "impossible with QB"-source, visit my site:
' -> How to connect QB to the Internet
' -> How to translate Enlish to German text (with a QB-program!)
' -> and more...
'
' http://www.gimi.debox.de

' Any Questions!?
' ---------------
' Oh, please e-mail me! I would be glad to know your opinion about this and
' my other "impossible with QB"-programs. Thx.
' -> jmate@t-online.de

' !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
' !!! Now press [F5] and enjoy !!!
' !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


' Start of the program:
DECLARE SUB ResetFM ()
DECLARE SUB setinstruments ()
DECLARE SUB WriteReg (reg%, info%)
DECLARE SUB Drum ()
DECLARE SUB MidiNote (Note%, Volume%, channel%)
DECLARE FUNCTION NextNumber! ()
DECLARE FUNCTION Nibble$ (Cr$, l!)
DECLARE FUNCTION Nibble2Number! (ch$)
DECLARE FUNCTION ReadTimeSignature$ ()
DECLARE FUNCTION ReadBPM! ()
DECLARE FUNCTION ReadText$ ()
DECLARE FUNCTION ReadFourBytes! ()
DECLARE FUNCTION ReadTwoBytes! ()
DECLARE FUNCTION ReadVarLen! ()
TYPE ChType
 ChName AS STRING * 8
 ChSett AS STRING * 11
END TYPE
DIM SHARED Channe(8) AS ChType
DIM SHARED Instrname(127) AS STRING, FRQ%, channel%
DIM Header AS STRING * 4
DIM TweeByte AS STRING * 2
DIM VierByte AS STRING * 4
DIM FileType AS STRING * 2
DIM l AS INTEGER
DIM SHARED voiceset(0 TO 127) AS INTEGER
DIM SHARED voicetab(0 TO 127) AS INTEGER
DIM SHARED i AS LONG, ChUse(0 TO 8) AS INTEGER
DIM SHARED A AS STRING * 1, drumset%, lead%, PTIME, PPOS, Volume%, onchan(0 TO 15) AS INTEGER, OutPt%
DIM SHARED vol(1 TO 16) AS INTEGER, text(30) AS STRING, CHANON(1 TO 16) AS INTEGER, realvol(0 TO 8) AS INTEGER

'=========================== RealMIDI-Setup =============================

file$ = "DEMO.MID"        ' The input-file
drumset% = 9              ' The drumset-track
OutPt% = 1                ' Output-device.
			  '  0 = Internal speaker
			  '  1 = FM-Synthesis (soundcard)

'========================================================================


CLS
PRINT "Init...";

ON ERROR GOTO diverr:
diverr:
RESUME div:
div:
Tijd = TIMER
FOR i = 1 TO 100000: NEXT i: Wl = 2 / (TIMER - Tijd)

' Read the sound-file:
DIM InLen(16) AS INTEGER
OPEN "INSTDATA.FMI" FOR BINARY ACCESS READ AS #1
 DBID$ = STRING$(14, 0)
 GET #1, , DBID$
 IF DBID$ <> "FMTInstruments" THEN PRINT "Invalid FMT instrument file!": END
 DBVer$ = STRING$(2, 0)
 GET #1, , DBVer$
 IF DBVer$ <> CHR$(1) + CHR$(0) THEN PRINT "Not version 1.0 instrument file!": END
 DBName$ = STRING$(20, 0)
 GET #1, , DBName$
 X$ = CHR$(0)
 GET #1, , X$
 insts% = ASC(X$) + 1
 DIM SHARED Instrument(insts%)  AS ChType
 FOR n% = 1 TO insts%
  GET #1, , Instrument(n%).ChName
 NEXT n%
 FOR n% = 1 TO insts%
  GET #1, , Instrument(n%).ChSett
 NEXT n%
CLOSE #1

ResetFM

DLTIME = TIMER
PTIME = TIMER
PPOS = 39
XPOS = 1

' Detect the PC's speed. We have to do very short delays which only
' can be done with FOR ... NEXT loops.

zeit! = TIMER
tempo = 120
t = 100
DO
 FOR Wacht = 1 TO t * (1.5 / tempo) * 100: NEXT Wacht
 mdelay% = mdelay% + 1
LOOP UNTIL zeit + 1 < TIMER
mdelay% = mdelay% / 80

' Reset Card:
FOR port = &H210 TO &H280 STEP &H10
  OUT port + &H6, 1
  FOR Count = 1 TO 100
    OUT port + &H6, 0
    Stat = INP(port + &HE)
    Stat = INP(port + &HA)
    IF Stat = &HAA THEN EXIT FOR
  NEXT Count
NEXT port


PRINT " OK."
PRINT
PRINT "RealMIDI is going to play a sample file. You might have to"
PRINT "adjust the speed with [+] and [-]. Hit any key..."
SLEEP


' Draw Screen:
CLS
COLOR 15, 1: LOCATE 1, 1: PRINT " RealMIDI Sequencer version 1.00                                                "
COLOR 0, 7
PRINT
PRINT "";
PRINT " TR VOICE               VOLUME      OUTPUT  CH                             ";
PRINT "";
FOR X = 1 TO 16
 COLOR 0, 7
 PRINT "    empty ";
 LOCATE , 1
 PRINT X;
 LOCATE , 26: COLOR 8, 0:
 PRINT ""
NEXT
LOCATE 22, 1: COLOR 0, 7: PRINT "";
LOCATE 24, 1: COLOR 0, 7: PRINT " [ESC] Exit  [+] Speed  [-] Speed ";
LOCATE 25, 1: COLOR 0, 1: PRINT "                                             Copyright (C) 2000 Sebastian Mate ";


' Read the General-MIDI names and translation for the sound-database.
' The sound-database does not contain all 127 General-MIDI sounds.
FOR i = 0 TO 127
 READ Instrname(i)
 READ n$: voicetab(i) = VAL(n$)
NEXT i

' Open and start playing the MIDI-file:

IF INSTR(file$, ".") = 0 THEN file$ = file$ + ".MID"
OPEN file$ FOR BINARY AS #1
 GET 1, , Header
 IF Header <> "MThd" THEN PRINT "Not a valid MIDI file"; Er: STOP
 GET 1, , VierByte
 GET 1, , FileType
 IF ASC(RIGHT$(FileType, 1)) = 0 THEN
 ELSE
   COLOR 15, 0: CLS : PRINT "Multy tracks, this file type is not supported.": END
 END IF
 Tracks = ReadTwoBytes
 LOCATE 25, 1: COLOR 15, 1
 tempo = ReadTwoBytes
 PRINT tempo; "bpm";
 tempo = 120
  FOR i = 1 TO Tracks
   GET 1, , Header
   IF Header = "MTrk" THEN
    TrkLengte = ReadFourBytes + LOC(1)
    WHILE (LOC(1) < TrkLengte) AND Stoppen = 0

     X$ = INKEY$:
     IF X$ = CHR$(27) THEN CLS : ResetFM: END
     IF X$ = "-" THEN Wl = Wl + .5
     IF X$ = "=" OR X$ = "+" THEN Wl = Wl - .5

     t = ReadVarLen ' Read the delay until we do anything and delay:
     FOR ar% = 1 TO mdelay%
      FOR Wacht = 1 TO t * (1.5 / tempo) * 100 * Wl: NEXT Wacht
     NEXT ar%

     totaltime! = totaltime! + t ' Might be useful for you...
     
     GET 1, , A ' Get the MIDI-command...

     IF A = CHR$(255) THEN '... we have a meta-command!
       GET #1, , A
       SELECT CASE ASC(A)
	CASE 0:  PRINT "Sequence Number : "; ReadText$
	CASE 1
	 lyric$ = ReadText$ ' You can use this
	CASE 32: PRINT "MIDI ch. Prefix.. ": A$ = ReadText$: REM <====== What is this ?
	CASE 47: ResetFM: CLS : SYSTEM
	CASE 81: tempo = (60000000 / ReadBPM):
	  LOCATE 25, 1: COLOR 15, 1: PRINT INT(tempo); "bpm ";
	CASE 84: PRINT "SMPTE Offset    : "; : t$ = ReadText$: PRINT ASC(LEFT$(t$, 1)); " "; ASC(MID$(t$, 2, 1))
	CASE 88 ' Time signature
	  n$ = ReadTimeSignature$
	CASE 89 ' Key signature
	  n$ = ReadText$
	CASE 127 'Sequencer-specific Meta Event
	  n$ = ReadText$
	CASE ELSE: t$ = ReadText$ ' Unkown Meta Event
       END SELECT
      ELSE
      
      IF HEX$(ASC(A)) = "F0" OR HEX$(ASC(A)) = "F7" THEN
	t$ = ReadText$
      ELSE

      IF Nibble$(A, 1) = "8" THEN 'Send: Note Off
	channel% = Nibble2Number(Nibble$(A, 0))
	Note% = NextNumber
	Volume% = NextNumber
	IF OutPt% = 0 THEN SOUND 0, 0
	IF channel% <> drumset% - 1 AND OutPt% = 1 THEN
	 WriteReg &HA0 + channel%, 0
	 WriteReg &HB0 + channel%, 0
	END IF
	 ChUse(onchan(channel%)) = 0
	 InLen(channel%) = 0
       END IF
      
       IF Nibble$(A, 1) = "9" THEN 'Send: Note On
	channel% = Nibble2Number(Nibble$(A, 0))
	Note% = NextNumber
	Volume% = NextNumber
	CALL MidiNote(Note%, Volume%, channel%)
	InLen(channel%) = 40
       END IF

       IF Nibble$(A, 1) = "A" THEN 'Key after-touch
	 Temp = Nibble2Number(Nibble$(A, 0))
	 Temp = NoteName(NextNumber)
	 Temp = NextNumber
       END IF

       IF Nibble$(A, 1) = "B" THEN
	channel% = Nibble2Number(Nibble$(A, 0))
	Instrmnt% = NextNumber
	NewVal% = NextNumber
       END IF


       IF Nibble$(A, 1) = "C" THEN ' Change voice
	channel% = Nibble2Number(Nibble$(A, 0))
	Instrmnt% = NextNumber
	 LOCATE channel% + 6, 1
	 LOCATE , 1
	 COLOR 0, 7
	 PRINT "    empty ";
	 COLOR 1, 7: LOCATE , 5: PRINT Instrname(Instrmnt%); " ";
	 voiceset(channel%) = voicetab(Instrmnt%) + 3
	 LOCATE channel% + 6, 1: COLOR 0, 7: PRINT channel% + 1;
	 COLOR 8, 7: LOCATE , 40: PRINT Instrument(voiceset(channel%)).ChName
	 COLOR 0, 7
       END IF

      IF Nibble$(A, 1) = "D" THEN ' <- ???
       Temp = Nibble2Number(Nibble$(A, 0))
       Temp = NextNumber
      END IF

      IF Nibble$(A, 1) = "E" THEN 'Pitch wheel change
       wchannel% = Nibble2Number(Nibble$(A, 0))
       Bottom% = NextNumber
       Top% = NextNumber
      END IF

      IF DLTIME + .005 < TIMER THEN ' Used to show the volume
       DLTIME = TIMER
       FOR V% = 1 TO 16
       IF vol(V%) > 0 THEN vol(V%) = vol(V%) - 1
       IF V% < 8 THEN
	IF realvol(V%) > 0 THEN realvol(V%) = realvol(V%) - 1
	IF realvol(V%) = 0 THEN ChUse(V%) = 0
       END IF
	LOCATE V% + 5, 26: COLOR 8, 0:
	 PRINT ""
	LOCATE V% + 5, 26: COLOR 10, 0:
	 FOR s% = 1 TO vol(V%)
	  IF s% > 7 THEN COLOR 14
	  IF s% > 10 THEN COLOR 12
	  PRINT "";
	 NEXT s%
	COLOR 7, 0
       NEXT V%
      END IF

     END IF
    END IF

'---------------------------
    
   WEND
  END IF
 NEXT i
CLOSE #1

Instrmntname:
DATA "Acoustic Grand","46","Bright Acoustic","46","Electric Grand","46"
DATA "Honky-Tonk","32","Electric Piano 1","46","Electric Piano 2","46"
DATA "Harpsichord","32","Clav","19","Celesta","15"
DATA "Glockenspiel","46","Music Box","46","Vibraphone","46"
DATA "Marimba","46","Xylophone","71","Tubular Bells","11"
DATA "Dulcimer","32","Drawbar Organ","45","Percussive Organ","45"
DATA "Rock Organ","45","Church Organ","45","Reed Organ","45"
DATA "Accoridan","1","Harmonica","1","Tango Accordian","1"
DATA "Acoustic Guitar(nylon)","29","Acoustic Guitar(steel)","29","Electric Guitar(jazz)","24"
DATA "Electric Guitar(clean)","24","Electric Guitar(muted)","24","Overdriven Guitar","29"
DATA "Distortion Guitar","29","Guitar Harmonics","29","Acoustic Bass","6"
DATA "Electric Bass(finger)","54","Electric Bass(pick)","49","Fretless Bass","49"
DATA "Synth Bass 2","49","Violin","70","Viola","70"
DATA "Cello","16","Contrabass","16","Tremolo Strings","58"
DATA "Pizzicato Strings","31","Orchestral Strings","58","Timpani","58"
DATA "String Ensemble 1","58","String Ensemble 2","58","SynthStrings 1","58"
DATA "SynthStrings 2","58","Choir Aahs","70","Voice Oohs","70"
DATA "Synth Voice","70","Orchestra Hit","56","Trumpet","67"
DATA "Trombone","67","Tuba","68","Muted Trumpet","67"
DATA "French Horn","28","Brass Section","13","SynthBrass 1","13"
DATA "SynthBrass 2","13","Soprano Sax"," 50","Alto Sax","50"
DATA "Tenor Sax","62","Baritone Sax","50","Oboe","44"
DATA "English Horn","26","Bassoon","7","Clarinet","18"
DATA "Piccolo","47","Flute","27","Recorder","27"
DATA "Pan Flute","27","Blown Bottle","27","Skakuhachi","27"
DATA "Whistle","27","Ocarina","27","Lead 1 (square)","46"
DATA "Lead 2 (sawtooth)","46","Lead 3 (calliope)","46","Lead 4 (chiff)","46"
DATA "Lead 5 (charang)","46","Lead 6 (voice)","46","Lead 7 (fifths)","46"
DATA "Lead 8 (bass+lead)","46","Pad 1 (new age)","46","Pad 2 (warm)","46"
DATA "Pad 3 (polysynth)","46","Pad 4 (choir)","46","Pad 5 (bowed)","46"
DATA "Pad 6 (metallic)","46","Pad 7 (halo)","46","Pad 8 (sweep)","46"
DATA "FX 1 (rain)","55","FX 2 (soundtrack)","45","FX 3 (crystal)","45"
DATA "FX 4 (atmosphere)","45","FX 5 (brightness)","45","FX 6 (goblins)","45"
DATA "FX 7 (echoes)","64","FX 8 (sci-fi)","1","Sitar","53"
DATA "Banjo","5","Shamisen","5","Koto","5"
DATA "Kalimba","71","Bagpipe","4","Fiddle","70"
DATA "Shanai","46","Tinkle Bell","46","Agogo","46"
DATA "Steel Drums","64","Woodblock","71","Taiko Drum","71"
DATA "Melodic Tom","64","Synth Drum","71","Reverse Cymbal","71"
DATA "Guitar Fret Noise","71","Breath Noise","71","Seashore","71"
DATA "Bird Tweet","17","Telephone Ring","17","Helicopter","56"
DATA "Applause","56","Gunshot","63","Unknown Instrmnt","46"


FMIRegs:
 DATA 32,64,96,128,224,192

SUB Drum
' Generates a "drum-sound" for the speaker.

FOR d = 1 TO 150
X = INT(RND * 2)
FOR n& = 1 TO 50: NEXT
IF X = 0 THEN OUT 97, 1
IF X = 1 THEN OUT 97, 2
NEXT
END SUB

SUB MidiNote (Note%, Volume%, channel%)
 'Plays a note

 FRQ% = (440 / 32) * (2 ^ ((Note% - 9) / 12)) ' Convert note to frequency.

 vol(channel% + 1) = Volume% / 10

 IF OutPt% = 1 THEN
  setinstruments
  chan% = channel%
  Freq% = FRQ%
  Octv% = 5
  WriteReg &HA0 + chan%, Freq% AND &HFF
  WriteReg &HB0 + chan%, INT(Freq% / 256) OR 32 OR (Octv% * 4)
 END IF

 IF OutPt% = 0 AND FRQ% > 36 THEN
  IF channel% = drumset% - 1 THEN Drum
  IF channel% <> drumset% - 1 THEN SOUND 0, 0: SOUND FRQ%, 36
 END IF

END SUB

FUNCTION NextNumber
 GET #1, , A
 NextNumber = ASC(A)
END FUNCTION

FUNCTION Nibble$ (Cr$, l)
 ' A Nibble are 4 Bit or a half byte. Strange name!

 IF l = 1 THEN
    Nibble$ = LEFT$(HEX$(ASC(Cr$) AND 240), 1)
  ELSE
   Nibble$ = RIGHT$(HEX$(ASC(Cr$) AND 15), 1)
 END IF
END FUNCTION

FUNCTION Nibble2Number (ch$)
 SELECT CASE ch$
   CASE "0": Nibble2Number = 0
   CASE "1": Nibble2Number = 1
   CASE "2": Nibble2Number = 2
   CASE "3": Nibble2Number = 3
   CASE "4": Nibble2Number = 4
   CASE "5": Nibble2Number = 5
   CASE "6": Nibble2Number = 6
   CASE "7": Nibble2Number = 7
   CASE "8": Nibble2Number = 8
   CASE "9": Nibble2Number = 9
   CASE "A": Nibble2Number = 10
   CASE "B": Nibble2Number = 11
   CASE "C": Nibble2Number = 12
   CASE "D": Nibble2Number = 13
   CASE "E": Nibble2Number = 14
   CASE "F": Nibble2Number = 15
 END SELECT
END FUNCTION

FUNCTION ReadBPM
 DIM Temp AS LONG
 GET #1, , A
 IF A = CHR$(3) THEN
  FOR i = 1 TO 3
   GET #1, , A
   Temp = (Temp * 256) + ASC(A)
  NEXT i
 END IF
 ReadBPM = Temp
END FUNCTION

FUNCTION ReadFourBytes
 GET #1, , A
 t = ASC(A) * 2 ^ 8
 GET #1, , A
 t = (ASC(A) + t) * 2 ^ 8
 GET #1, , A
 t = (ASC(A) + t) * 2 ^ 8
 GET #1, , A
 ReadFourBytes = t + ASC(A)
END FUNCTION

FUNCTION ReadText$
 Lengte = ReadVarLen
 FOR tt = 1 TO Lengte
  GET #1, , A
  Temp$ = Temp$ + A
 NEXT tt
 ReadText$ = Temp$
END FUNCTION

FUNCTION ReadTimeSignature$

 GET 1, , A
 GET 1, , A: T1 = ASC(A)
 GET 1, , A: T2 = ASC(A)
 GET 1, , A
 GET 1, , A

 ReadTimeSignature$ = STR$(T1) + " /" + STR$(2 ^ T2)

END FUNCTION

FUNCTION ReadTwoBytes
 GET #1, , A
 t = ASC(A) * 2 ^ 8
 GET #1, , A
 ReadTwoBytes = t + ASC(A)
END FUNCTION

FUNCTION ReadVarLen
 GET #1, , A
 Value = ASC(A)
 IF (Value AND 128) THEN
  Value = (Value AND 127)
  DO
   GET #1, , A
   Value2 = ASC(A)
   Value = (Value * (2 ^ 7)) + (Value2 AND 127)
  LOOP WHILE (Value2 AND 128)
 END IF
 ReadVarLen = Value
END FUNCTION

SUB ResetFM
 FOR n% = 0 TO &HF5
  WriteReg n%, 0
 NEXT n%
END SUB

SUB setinstruments
  chan% = channel%
  IF chan% > 8 THEN EXIT SUB
  realvol(chan%) = Volume% / 10
  ChanX% = (chan% MOD 3) + 8 * INT(chan% / 3)
  IF channel% <> drumset% - 1 THEN Inst$ = Instrument(voiceset(channel%)).ChSett
  LOCATE channel% + 6, 40: COLOR 15, 7: PRINT Instrument(voiceset(channel%)).ChName
  IF channel% = drumset% - 1 THEN
    WriteReg &HA0 + chan%, 0
    WriteReg &HB0 + chan%, 0
  Inst$ = Instrument(55 + 3).ChSett: COLOR 15, 7: LOCATE channel% + 6, 40: PRINT Instrument(55 + 3).ChName
  END IF
  LOCATE channel% + 6, 49: PRINT chan%
  RESTORE FMIRegs
   FOR n% = 1 TO 11
    IF n% AND 1 THEN READ reg% ELSE reg% = reg% + 3
    IF n% = 11 THEN WReg% = reg% + chan% ELSE WReg% = reg% + ChanX%
    WriteReg WReg%, ASC(MID$(Inst$, n%, 1))
   NEXT n%
END SUB

SUB WriteReg (reg%, info%)
 OUT &H388, reg%
 FOR d% = 1 TO 6: X% = INP(&H388): NEXT d%
 OUT &H389, info%
 FOR d% = 1 TO 35: X% = INP(&H388): NEXT d%
END SUB

