'
'                                PLAYSND.BAS
'
' This is a sample file made to show how to load a .SND file and how to play
' your sound effects. All you need to do is to move the two sub routines
' contained within this file into your own program file.
' (IMPORTANT: You also need to put a '$DYNAMIC at the beginning of your
' program, since the load routine uses a REDIM command).
'
' Then all you have to do is:
' - Declare a matrix of strings in which the sounds will be stored.
'  
'                  REDIM SHARED Snd(1 to 500) as string*30
'
'   please note that here we declare up to 500 sounds available. This will be
'   redimensioned by the LoadFX function to store only the sounds contained
'   within your file.
'
' - First load your .SND file in memory (the load process also provides on
'   allocating memory for the sounds, stored within strings) with the
'   function:
' 
'                        Result = LOADFX("FileName$")
'
'   where "FileName$" is the full file name, with extension. This function
'   returns a -1 (TRUE) if the load is successful, a 0 if the file does not
'   exists, a 1 if the sound file contains an unknown sound format, or a 2
'   if the file contains an advanced sound format not yet supported.
'
' - To play a sound at any time, make this call:
'
'                                PLAYFX FXnum
'
'   where FXnum is the id number of the sound you want to play.
'
' See the example and you'll understand everything.
' If you have any problem, just E-Mail me. The address is specified in the
' main program.
'
' --------------------------------------------------------------------------

' Here begins the program

' Remember to put an $DYNAMIC on the first line of your programs!
'$DYNAMIC
DEFINT A-Z

' Here follows the routines declarations.
DECLARE SUB PlayFX (FXnum)
DECLARE FUNCTION LoadFX (FileName$)

' Here we allocate memory for 500 sounds. This will be redimensioned by
' the load function.
REDIM SHARED Snd(1 TO 500) AS STRING * 30

' Here we load the sample sound file. This routine also provides to allocate
' the needed memory for the sounds.
Result = LoadFX("SAMPLE.SND")

' Now we check if the load process is successful.
SELECT CASE Result

CASE 0  ' Error: specified file can't be found in the current directory!
  PRINT "Error: file not found."
  PRINT : END

CASE 1  ' Unknown file format encountered!
  PRINT "Unknown file format!"
  PRINT : END

CASE 2  ' We tried to load a sound file which is coded with an advanced format.
  PRINT "Advanced file format encoutered."
  PRINT : END
END SELECT

' All appears to be OK. Then we play the first sound.
PlayFX 1
' You can do this simple command everywhere in your program.
' The slowdown will be minimal, but pay attention: these routine doesn't
' check if a sound blaster compatible sound card is present...

' Well, it's all. Now it's up to you...

REM $STATIC
FUNCTION LoadFX (FileName$)
'
' This routine loads specified sound file.
'
OPEN FileName$ FOR BINARY AS #1
IF LOF(1) = 0 THEN LoadFX = 0: CLOSE #1: EXIT FUNCTION
DIM id AS STRING * 4
GET #1, , id
IF MID$(id, 1, 2) <> "SL" THEN LoadFX = 1: CLOSE #1: EXIT FUNCTION
IF MID$(id, 3, 2) <> "10" THEN LoadFX = 2: CLOSE #1: EXIT FUNCTION
GET #1, , NumSound
REDIM Snd(1 TO NumSound) AS STRING * 30
FOR i = 1 TO NumSound
  GET #1, , Snd(i)
  temp$ = SPACE$(20)
  GET #1, , temp$
NEXT i
CLOSE #1
LoadFX = -1

END FUNCTION

SUB PlayFX (Num)
'
' Plays specified FX num.
'
FOR i = 1 TO 15
  OUT &H388, ASC(MID$(Snd(Num), (i * 2) - 1, 1))
  FOR ii = 1 TO 6: temp = INP(&H388): NEXT ii
  OUT &H389, ASC(MID$(Snd(Num), (i * 2)))
  FOR ii = 1 TO 35: temp = INP(&H388): NEXT ii
NEXT i

END SUB

