'
'                           QuickBasic  SoundLab
'
'                    Version 1.0 by Angelo Mottola soft
'                              (C) April 1997
'
'
' This program is freeware. This means you can use it as you need it, without
' limitations; feel free to distribute this software to other people.
'
' If you have any suggestion or you just want to do a comment to my work,
' why don't you send me an E-Mail at my address:
'
'                          -----------------------
'                          angelillo@geocities.com
'                          -----------------------
'
' Also, visit my home page located at:
'
'             -------------------------------------------------
'             http://www.geocities.com/SiliconValley/Lakes/7303
'             -------------------------------------------------
'
' And now, what are you waiting for? Press shift-F5 to run!!
'

'$DYNAMIC
DEFINT A-Z

TYPE ColorType
  Text AS INTEGER
  BackText AS INTEGER
  Er AS INTEGER
  BackEr AS INTEGER
  Menu AS INTEGER
  BackMenu AS INTEGER
  Main AS INTEGER
  BackMain AS INTEGER
END TYPE

TYPE FXType
  Channel AS INTEGER
  CTremolo AS INTEGER
  MTremolo AS INTEGER
  CVibrato AS INTEGER
  MVibrato AS INTEGER
  CMultiplier AS INTEGER
  MMultiplier AS INTEGER
  CAttenuation AS INTEGER
  MAttenuation AS INTEGER
  CAttack AS INTEGER
  MAttack AS INTEGER
  CDecay AS INTEGER
  MDecay AS INTEGER
  CSustain AS INTEGER
  MSustain AS INTEGER
  CRelease AS INTEGER
  MRelease AS INTEGER
  FeedBack AS INTEGER
  Connection AS INTEGER
  CWave AS INTEGER
  MWave AS INTEGER
  Frequency AS INTEGER
  Octave AS INTEGER
END TYPE

TYPE RegTypeX
  ax AS INTEGER
  bx AS INTEGER
  cx AS INTEGER
  dx AS INTEGER
  bp AS INTEGER
  si AS INTEGER
  di AS INTEGER
  flags AS INTEGER
  ds AS INTEGER
  es AS INTEGER
END TYPE

DECLARE SUB MouseStatus (Lb, Rb, xMouse, yMouse)
DECLARE SUB MouseRange (x1, y1, x2, y2)
DECLARE SUB MousePut (x, y)
DECLARE SUB MouseHide ()
DECLARE SUB MouseDriver (ax, bx, cx, dx)
DECLARE SUB MouseShow ()
DECLARE SUB Init ()
DECLARE SUB Welcome ()
DECLARE SUB PlayFX (Num)
DECLARE SUB SetVol (Volume)
DECLARE SUB DrawWindow (x1, y1, x2, y2, tCol, bCol, Title$)
DECLARE SUB DisplayError (ErrCode)
DECLARE SUB Hilight (x1, y1, tCol, bCol, Text$)
DECLARE SUB EditInstrument ()
DECLARE SUB EditSound ()
DECLARE SUB FXToCode ()
DECLARE SUB CodeToFX ()
DECLARE SUB PrintStat (x1, y1, Num)
DECLARE SUB MainLoop ()
DECLARE SUB Delay (Tim!)
DECLARE SUB EditWave (Which)
DECLARE SUB CheckInstrument ()
DECLARE SUB CheckSound ()
DECLARE SUB CheckGlobal ()
DECLARE SUB Message (Text$)
DECLARE SUB DrawBar (Length)
DECLARE SUB ShowInfo ()
DECLARE SUB MenuFile ()
DECLARE SUB MenuEdit ()
DECLARE SUB MenuOptions ()
DECLARE SUB Load (File$)
DECLARE SUB Save (File$)
DECLARE SUB ShowRegs ()
DECLARE SUB ShowChStats ()
DECLARE SUB About ()
DECLARE SUB Sort (A$(), Low, High)
DECLARE SUB INTERRUPTX (in, inreg AS RegTypeX, outreg AS RegTypeX)
DECLARE FUNCTION MouseInit ()
DECLARE FUNCTION ReadBit (Byte, Bit)
DECLARE FUNCTION SetBit (Byte, Bit)
DECLARE FUNCTION ResetBit (Byte, Bit)
DECLARE FUNCTION RShift (Byte, Bits)
DECLARE FUNCTION LShift (Byte, Bits)
DECLARE FUNCTION Ask (Text$)
DECLARE FUNCTION Dir$ (FileSpec$)
DECLARE FUNCTION FileSelect$ (Mode)
DECLARE FUNCTION PickSound (Text$)

CONST FALSE = 0, TRUE = NOT FALSE, MaxSound = 500
CONST DOS = &H21
CONST SetDTA = &H1A00, FindFirst = &H4E00, FindNext = &H4F00

DIM SHARED mouse$: mouse$ = SPACE$(57)
DIM SHARED y, x, Oldx, Oldy, StartTime$
DIM SHARED FX AS FXType, Snd(MaxSound) AS STRING * 50, TempSnd AS STRING * 50
DIM SHARED BasePort, Volume, Col AS ColorType, Shadows, Border, Ext AS STRING * 3
DIM SHARED Edit, FileName$, CurSound, NumSound, ChData(8, 15), LastErr

ON TIMER(1) GOSUB TimeCheck: TIMER OFF
ON ERROR GOTO ErrorHandle
Init
MainLoop
END

ErrorHandle:
DisplayError ERR
RESUME NEXT

TimeCheck:
PCOPY 7, 0
COLOR Col.Menu, Col.BackMenu
LOCATE 25, 70: PRINT TIME$ + "   ";
PCOPY 0, 7
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
RETURN

MouseData:
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

DefaultConfig:
DATA 15,1,12,4,0,3,0,7,8,-1,1,"SND"

NatureFeeling:
DATA 15,2,7,4,0,2,0,4

Psycho:
DATA 15,5,13,2,14,1,0,7

BlackAndWhite:
DATA 15,7,8,7,15,8,0,7

ChannelData:
DATA B0,20,23,40,43,60,63,80,83,A0,BD,C0,E0,E3,B0
DATA B1,21,24,41,44,61,64,81,84,A1,BD,C1,E1,E4,B1
DATA B2,22,25,42,45,62,65,82,85,A2,BD,C2,E2,E5,B2
DATA B3,28,2B,48,4B,68,6B,88,8B,A3,BD,C3,E8,EB,B3
DATA B4,29,2C,49,4C,69,6C,89,8C,A4,BD,C4,E9,EC,B4
DATA B5,2A,2D,4A,4D,6A,6D,8A,8D,A5,BD,C5,EA,ED,B5
DATA B6,30,33,50,53,70,73,90,93,A6,BD,C6,F0,F3,B6
DATA B7,31,34,51,54,71,74,91,94,A7,BD,C7,F1,F4,B7
DATA B8,32,35,52,55,72,75,92,95,A8,BD,C8,F2,F5,B8

REM $STATIC
SUB About
'
' Displays help window
'
Hilight 23, 1, Col.Menu, Col.BackMenu, " About "
DrawWindow 10, 5, 69, 22, Col.Menu, Col.BackMenu, "About"
LOCATE 7, 35: PRINT "QuickBasic"
LOCATE 8, 36: PRINT "SOUNDLAB"
LOCATE 10, 34: PRINT "version  1.0"
LOCATE 11, 21: PRINT "by Angelo Mottola soft  (C) April 1997"
LOCATE 13, 26: PRINT "Programmed by Angelo Mottola"
LOCATE 14, 19: PRINT "Bit manipulation routines by Luis Espinoza"
LOCATE 16, 12: PRINT "If you have any comment or suggestion send me an E-Mail:"
LOCATE 17, 28: PRINT "angelillo@geocities.com"
LOCATE 18, 22: PRINT "Also, visit my home page located at:"
LOCATE 19, 16: PRINT "http://www.geocities.com/SiliconValley/Lakes/7303"
LOCATE 21, 37: PRINT "< OK >"
Message "About program informations"
PCOPY 0, 4
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 4, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    IF y = 21 AND x > 36 AND x < 43 THEN EXIT DO
  END IF
LOOP
Hilight 37, 21, Col.Menu, Col.BackMenu, "< OK >"
PCOPY 7, 0
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
Delay .3

END SUB

FUNCTION Ask (Text$)
'
' Draws a window asking the confirm for the question in Text$
'
PCOPY 0, 4
DrawWindow ((81 - (LEN(Text$) + 6)) \ 2), 10, ((81 - (LEN(Text$) + 6)) \ 2) + (LEN(Text$) + 4), 15, Col.Menu, Col.BackMenu, "Please confirm operation"
LOCATE 12, ((81 - (LEN(Text$) + 6)) \ 2) + 3: PRINT Text$
LOCATE 14, 32: PRINT "< OK >    < NO >"
PCOPY 0, 3
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 3, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    IF y = 14 THEN
      SELECT CASE x
      CASE 32 TO 37
        Hilight 32, 14, Col.Menu, Col.BackMenu, "< OK >"
        PCOPY 4, 0: Ask = TRUE: EXIT DO
      CASE 42 TO 47
        Hilight 42, 14, Col.Menu, Col.BackMenu, "< NO >"
        PCOPY 4, 0: Ask = FALSE: EXIT DO
      END SELECT
    END IF
  END IF
LOOP

END FUNCTION

SUB CheckGlobal
'
' Checks if global parameters are changed or if a menu is selected.
'
SELECT CASE y
CASE 1
  SELECT CASE x
  CASE 2 TO 7: MenuFile
  CASE 8 TO 13: MenuEdit
  CASE 14 TO 22: MenuOptions
  CASE 23 TO 28: About
  END SELECT
CASE 4
  SELECT CASE x
  CASE 5 TO 10
    Hilight 5, 4, Col.Text, Col.BackText, "<PLAY>"
    LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
    FXToCode
    PlayFX CurSound
    Message "Sound sent to the port."
    Delay .2
  CASE 13 TO 18
    Hilight 13, 4, Col.Text, Col.BackText, "<STOP>"
    LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
    FOR i = &H0 TO &HF5
      OUT &H388, i
      OUT &H389, 0
    NEXT i
    Message "Sound stopped."
    Delay .2
  CASE 21 TO 26
    IF CurSound < NumSound THEN
      Hilight 21, 4, Col.Text, Col.BackText, "<NEXT>"
      PCOPY 7, 0
      FXToCode
      CurSound = CurSound + 1
      LOCATE 4, 40: PRINT USING "###/###"; CurSound; NumSound
      IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
      LOCATE 3, 3: PRINT STRING$(73, s$)
      s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(CurSound), 31, 20))
      LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
      Delay .05
      PCOPY 0, 7
      IF Edit = 1 THEN EditInstrument ELSE EditSound
    ELSE
      Message "No such sound."
      Delay .3
    END IF
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  CASE 29 TO 34
    IF CurSound > 1 THEN
      Hilight 29, 4, Col.Text, Col.BackText, "<PREV>"
      PCOPY 7, 0
      FXToCode
      CurSound = CurSound - 1
      LOCATE 4, 40: PRINT USING "###/###"; CurSound; NumSound
      IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
      LOCATE 3, 3: PRINT STRING$(73, s$)
      s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(CurSound), 31, 20))
      LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
      Delay .05
      PCOPY 0, 7
      IF Edit = 1 THEN EditInstrument ELSE EditSound
    ELSE
      Message "No such sound."
      Delay .3
    END IF
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  CASE 58
    IF Volume > 1 THEN
      PCOPY 7, 0
      COLOR Col.Main, Col.BackMain
      LOCATE 4, 58 + Volume: PRINT CHR$(177);
      Volume = Volume - 1
      SetVol Volume
      COLOR Col.Er, Col.BackEr
      LOCATE 4, 58 + Volume: PRINT CHR$(178);
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 74
    IF Volume < 15 THEN
      PCOPY 7, 0
      COLOR Col.Main, Col.BackMain
      LOCATE 4, 58 + Volume: PRINT CHR$(177);
      Volume = Volume + 1
      SetVol Volume
      COLOR Col.Er, Col.BackEr
      LOCATE 4, 58 + Volume: PRINT CHR$(178);
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 58 TO 73
    PCOPY 7, 0
    COLOR Col.Main, Col.BackMain
    LOCATE 4, 58 + Volume: PRINT CHR$(177);
    Volume = x - 58
    SetVol Volume
    COLOR Col.Er, Col.BackEr
    LOCATE 4, 58 + Volume: PRINT CHR$(178);
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END SELECT
END SELECT

END SUB

SUB CheckInstrument
'
' Allows to edit instrument values.
'
COLOR Col.Main, Col.BackMain
SELECT CASE y
CASE 9
  SELECT CASE x
  CASE 19
    IF FX.CMultiplier > 0 THEN
      PCOPY 7, 0
      LOCATE 9, 20 + FX.CMultiplier: PRINT CHR$(177)
      FX.CMultiplier = FX.CMultiplier - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 9, 20 + FX.CMultiplier: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 9, FX.CMultiplier
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 36
    IF FX.CMultiplier < 15 THEN
      PCOPY 7, 0
      LOCATE 9, 20 + FX.CMultiplier: PRINT CHR$(177)
      FX.CMultiplier = FX.CMultiplier + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 9, 20 + FX.CMultiplier: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 9, FX.CMultiplier
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 20 TO 35
    PCOPY 7, 0
    LOCATE 9, 20 + FX.CMultiplier: PRINT CHR$(177)
    FX.CMultiplier = x - 20
    COLOR Col.Er, Col.BackEr
    LOCATE 9, 20 + FX.CMultiplier: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 16, 9, FX.CMultiplier
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  CASE 58
    IF FX.MMultiplier > 0 THEN
      PCOPY 7, 0
      LOCATE 9, 59 + FX.MMultiplier: PRINT CHR$(177)
      FX.MMultiplier = FX.MMultiplier - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 9, 59 + FX.MMultiplier: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 9, FX.MMultiplier
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 75
    IF FX.MMultiplier < 15 THEN
      PCOPY 7, 0
      LOCATE 9, 59 + FX.MMultiplier: PRINT CHR$(177)
      FX.MMultiplier = FX.MMultiplier + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 9, 59 + FX.MMultiplier: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 9, FX.MMultiplier
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 59 TO 74
    PCOPY 7, 0
    LOCATE 9, 59 + FX.MMultiplier: PRINT CHR$(177)
    FX.MMultiplier = x - 59
    COLOR Col.Er, Col.BackEr
    LOCATE 9, 59 + FX.MMultiplier: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 55, 9, FX.MMultiplier
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END SELECT
CASE 11
  SELECT CASE x
  CASE 19
    IF FX.CAttenuation > 0 THEN
      PCOPY 7, 0
      LOCATE 11, 20 + (FX.CAttenuation \ 4): PRINT CHR$(177)
      FX.CAttenuation = FX.CAttenuation - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 11, 20 + (FX.CAttenuation \ 4): PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 11, FX.CAttenuation
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 36
    IF FX.CAttenuation < 63 THEN
      PCOPY 7, 0
      LOCATE 11, 20 + (FX.CAttenuation \ 4): PRINT CHR$(177)
      FX.CAttenuation = FX.CAttenuation + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 11, 20 + (FX.CAttenuation \ 4): PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 11, FX.CAttenuation
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 20 TO 35
    PCOPY 7, 0
    LOCATE 11, 20 + (FX.CAttenuation \ 4): PRINT CHR$(177)
    FX.CAttenuation = (x - 20) * 4
    COLOR Col.Er, Col.BackEr
    LOCATE 11, 20 + (FX.CAttenuation \ 4): PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 16, 11, FX.CAttenuation
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  CASE 58
    IF FX.MAttenuation > 0 THEN
      PCOPY 7, 0
      LOCATE 11, 59 + (FX.MAttenuation \ 4): PRINT CHR$(177)
      FX.MAttenuation = FX.MAttenuation - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 11, 59 + (FX.MAttenuation \ 4): PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 11, FX.MAttenuation
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 75
    IF FX.MAttenuation < 63 THEN
      PCOPY 7, 0
      LOCATE 11, 59 + (FX.MAttenuation \ 4): PRINT CHR$(177)
      FX.MAttenuation = FX.MAttenuation + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 11, 59 + (FX.MAttenuation \ 4): PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 11, FX.MAttenuation
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 59 TO 74
    PCOPY 7, 0
    LOCATE 11, 59 + (FX.MAttenuation \ 4): PRINT CHR$(177)
    FX.MAttenuation = (x - 59) * 4
    COLOR Col.Er, Col.BackEr
    LOCATE 11, 59 + (FX.MAttenuation \ 4): PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 55, 11, FX.MAttenuation
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END SELECT
CASE 13
  SELECT CASE x
  CASE 19
    IF FX.CAttack > 0 THEN
      PCOPY 7, 0
      LOCATE 13, 20 + FX.CAttack: PRINT CHR$(177)
      FX.CAttack = FX.CAttack - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 13, 20 + FX.CAttack: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 13, FX.CAttack
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 36
    IF FX.CAttack < 15 THEN
      PCOPY 7, 0
      LOCATE 13, 20 + FX.CAttack: PRINT CHR$(177)
      FX.CAttack = FX.CAttack + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 13, 20 + FX.CAttack: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 13, FX.CAttack
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 20 TO 35
    PCOPY 7, 0
    LOCATE 13, 20 + FX.CAttack: PRINT CHR$(177)
    FX.CAttack = x - 20
    COLOR Col.Er, Col.BackEr
    LOCATE 13, 20 + FX.CAttack: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 16, 13, FX.CAttack
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  CASE 58
    IF FX.MAttack > 0 THEN
      PCOPY 7, 0
      LOCATE 13, 59 + FX.MAttack: PRINT CHR$(177)
      FX.MAttack = FX.MAttack - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 13, 59 + FX.MAttack: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 13, FX.MAttack
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 75
    IF FX.MAttack < 15 THEN
      PCOPY 7, 0
      LOCATE 13, 59 + FX.MAttack: PRINT CHR$(177)
      FX.MAttack = FX.MAttack + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 13, 59 + FX.MAttack: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 13, FX.MAttack
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 59 TO 74
    PCOPY 7, 0
    LOCATE 13, 59 + FX.MAttack: PRINT CHR$(177)
    FX.MAttack = x - 59
    COLOR Col.Er, Col.BackEr
    LOCATE 13, 59 + FX.MAttack: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 55, 13, FX.MAttack
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END SELECT
CASE 15
  SELECT CASE x
  CASE 19
    IF FX.CDecay > 0 THEN
      PCOPY 7, 0
      LOCATE 15, 20 + FX.CDecay: PRINT CHR$(177)
      FX.CDecay = FX.CDecay - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 15, 20 + FX.CDecay: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 15, FX.CDecay
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 36
    IF FX.CDecay < 15 THEN
      PCOPY 7, 0
      LOCATE 15, 20 + FX.CDecay: PRINT CHR$(177)
      FX.CDecay = FX.CDecay + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 15, 20 + FX.CDecay: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 15, FX.CDecay
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 20 TO 35
    PCOPY 7, 0
    LOCATE 15, 20 + FX.CDecay: PRINT CHR$(177)
    FX.CDecay = x - 20
    COLOR Col.Er, Col.BackEr
    LOCATE 15, 20 + FX.CDecay: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 16, 15, FX.CDecay
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  CASE 58
    IF FX.MDecay > 0 THEN
      PCOPY 7, 0
      LOCATE 15, 59 + FX.MDecay: PRINT CHR$(177)
      FX.MDecay = FX.MDecay - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 15, 59 + FX.MDecay: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 15, FX.MDecay
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 75
    IF FX.MDecay < 15 THEN
      PCOPY 7, 0
      LOCATE 15, 59 + FX.MDecay: PRINT CHR$(177)
      FX.MDecay = FX.MDecay + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 15, 59 + FX.MDecay: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 15, FX.MDecay
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 59 TO 74
    PCOPY 7, 0
    LOCATE 15, 59 + FX.MDecay: PRINT CHR$(177)
    FX.MDecay = x - 59
    COLOR Col.Er, Col.BackEr
    LOCATE 15, 59 + FX.MDecay: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 55, 15, FX.MDecay
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END SELECT
CASE 17
  SELECT CASE x
  CASE 19
    IF FX.CSustain > 0 THEN
      PCOPY 7, 0
      LOCATE 17, 20 + FX.CSustain: PRINT CHR$(177)
      FX.CSustain = FX.CSustain - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 17, 20 + FX.CSustain: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 17, FX.CSustain
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 36
    IF FX.CSustain < 15 THEN
      PCOPY 7, 0
      LOCATE 17, 20 + FX.CSustain: PRINT CHR$(177)
      FX.CSustain = FX.CSustain + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 17, 20 + FX.CSustain: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 17, FX.CSustain
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 20 TO 35
    PCOPY 7, 0
    LOCATE 17, 20 + FX.CSustain: PRINT CHR$(177)
    FX.CSustain = x - 20
    COLOR Col.Er, Col.BackEr
    LOCATE 17, 20 + FX.CSustain: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 16, 17, FX.CSustain
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  CASE 58
    IF FX.MSustain > 0 THEN
      PCOPY 7, 0
      LOCATE 17, 59 + FX.MSustain: PRINT CHR$(177)
      FX.MSustain = FX.MSustain - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 17, 59 + FX.MSustain: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 17, FX.MSustain
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 75
    IF FX.MSustain < 15 THEN
      PCOPY 7, 0
      LOCATE 17, 59 + FX.MSustain: PRINT CHR$(177)
      FX.MSustain = FX.MSustain + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 17, 59 + FX.MSustain: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 17, FX.MSustain
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 59 TO 74
    PCOPY 7, 0
    LOCATE 17, 59 + FX.MSustain: PRINT CHR$(177)
    FX.MSustain = x - 59
    COLOR Col.Er, Col.BackEr
    LOCATE 17, 59 + FX.MSustain: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 55, 17, FX.MSustain
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END SELECT
CASE 19
  SELECT CASE x
  CASE 19
    IF FX.CRelease > 0 THEN
      PCOPY 7, 0
      LOCATE 19, 20 + FX.CRelease: PRINT CHR$(177)
      FX.CRelease = FX.CRelease - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 19, 20 + FX.CRelease: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 19, FX.CRelease
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 36
    IF FX.CRelease < 15 THEN
      PCOPY 7, 0
      LOCATE 19, 20 + FX.CRelease: PRINT CHR$(177)
      FX.CRelease = FX.CRelease + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 19, 20 + FX.CRelease: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 16, 19, FX.CRelease
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 20 TO 35
    PCOPY 7, 0
    LOCATE 19, 20 + FX.CRelease: PRINT CHR$(177)
    FX.CRelease = x - 20
    COLOR Col.Er, Col.BackEr
    LOCATE 19, 20 + FX.CRelease: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 16, 19, FX.CRelease
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  CASE 58
    IF FX.MRelease > 0 THEN
      PCOPY 7, 0
      LOCATE 19, 59 + FX.MRelease: PRINT CHR$(177)
      FX.MRelease = FX.MRelease - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 19, 59 + FX.MRelease: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 19, FX.MRelease
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 75
    IF FX.MRelease < 15 THEN
      PCOPY 7, 0
      LOCATE 19, 59 + FX.MRelease: PRINT CHR$(177)
      FX.MRelease = FX.MRelease + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 19, 59 + FX.MRelease: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 55, 19, FX.MRelease
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 59 TO 74
    PCOPY 7, 0
    LOCATE 19, 59 + FX.MRelease: PRINT CHR$(177)
    FX.MRelease = x - 59
    COLOR Col.Er, Col.BackEr
    LOCATE 19, 59 + FX.MRelease: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 55, 19, FX.MRelease
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END SELECT
CASE 21
  SELECT CASE x
  CASE 12
    PCOPY 7, 0
    IF FX.CVibrato THEN
      COLOR Col.Main, Col.BackMain
      LOCATE 21, 12: PRINT CHR$(32)
      FX.CVibrato = 0: PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .2
    ELSE
      COLOR Col.Main, Col.BackMain
      LOCATE 21, 12: PRINT CHR$(254)
      FX.CVibrato = 1: PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .2
    END IF
  CASE 23
    PCOPY 7, 0
    IF FX.CTremolo THEN
      COLOR Col.Main, Col.BackMain
      LOCATE 21, 23: PRINT CHR$(32)
      FX.CTremolo = 0: PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .2
    ELSE
      COLOR Col.Main, Col.BackMain
      LOCATE 21, 23: PRINT CHR$(254)
      FX.CTremolo = 1: PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .2
    END IF
  CASE 51
    PCOPY 7, 0
    IF FX.MVibrato THEN
      COLOR Col.Main, Col.BackMain
      LOCATE 21, 51: PRINT CHR$(32)
      FX.MVibrato = 0: PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .2
    ELSE
      COLOR Col.Main, Col.BackMain
      LOCATE 21, 51: PRINT CHR$(254)
      FX.MVibrato = 1: PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .2
    END IF
  CASE 62
    PCOPY 7, 0
    IF FX.MTremolo THEN
      COLOR Col.Main, Col.BackMain
      LOCATE 21, 62: PRINT CHR$(32)
      FX.MTremolo = 0: PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .2
    ELSE
      COLOR Col.Main, Col.BackMain
      LOCATE 21, 62: PRINT CHR$(254)
      FX.MTremolo = 1: PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .2
    END IF
  CASE 26 TO 36
    EditWave 1
  CASE 65 TO 75
    EditWave 2
  END SELECT
END SELECT

END SUB

SUB CheckSound
'
' Allows to edit sound values.
'
COLOR Col.Main, Col.BackMain
SELECT CASE y
CASE 13
  SELECT CASE x
  CASE 7
    IF FX.Frequency > 0 THEN
      PCOPY 7, 0
      LOCATE 13, 8 + (FX.Frequency \ 16): PRINT CHR$(177);
      FX.Frequency = FX.Frequency - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 13, 8 + (FX.Frequency \ 16): PRINT CHR$(178);
      COLOR Col.Text, Col.BackText
      s$ = LTRIM$(STR$(FX.Frequency))
      IF LEN(s$) < 4 THEN s$ = STRING$(4 - LEN(s$), CHR$(48)) + s$
      LOCATE 12, 28: PRINT s$
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 72
    IF FX.Frequency < 1023 THEN
      PCOPY 7, 0
      LOCATE 13, 8 + (FX.Frequency \ 16): PRINT CHR$(177);
      FX.Frequency = FX.Frequency + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 13, 8 + (FX.Frequency \ 16): PRINT CHR$(178);
      COLOR Col.Text, Col.BackText
      s$ = LTRIM$(STR$(FX.Frequency))
      IF LEN(s$) < 4 THEN s$ = STRING$(4 - LEN(s$), CHR$(48)) + s$
      LOCATE 12, 28: PRINT s$
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 8 TO 71
    PCOPY 7, 0
    LOCATE 13, 8 + (FX.Frequency \ 16): PRINT CHR$(177);
    FX.Frequency = (x - 8) * 16
    COLOR Col.Er, Col.BackEr
    LOCATE 13, 8 + (FX.Frequency \ 16): PRINT CHR$(178);
    COLOR Col.Text, Col.BackText
    s$ = LTRIM$(STR$(FX.Frequency))
    IF LEN(s$) < 4 THEN s$ = STRING$(4 - LEN(s$), CHR$(48)) + s$
    LOCATE 12, 28: PRINT s$
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END SELECT
CASE 15
  SELECT CASE x
  CASE 23
    IF FX.Octave > 0 THEN
      PCOPY 7, 0
      LOCATE 15, 24 + FX.Octave: PRINT CHR$(177)
      FX.Octave = FX.Octave - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 15, 24 + FX.Octave: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 20, 15, FX.Octave
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 32
    IF FX.Octave < 7 THEN
      PCOPY 7, 0
      LOCATE 15, 24 + FX.Octave: PRINT CHR$(177)
      FX.Octave = FX.Octave + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 15, 24 + FX.Octave: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 20, 15, FX.Octave
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 24 TO 31
    PCOPY 7, 0
    LOCATE 15, 24 + FX.Octave: PRINT CHR$(177)
    FX.Octave = x - 24
    COLOR Col.Er, Col.BackEr
    LOCATE 15, 24 + FX.Octave: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 20, 15, FX.Octave
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  CASE 62
    IF FX.Channel > 1 THEN
      PCOPY 7, 0
      LOCATE 15, 62 + FX.Channel: PRINT CHR$(177)
      FX.Channel = FX.Channel - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 15, 62 + FX.Channel: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 59, 15, FX.Channel
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 72
    IF FX.Channel < 9 THEN
      PCOPY 7, 0
      LOCATE 15, 62 + FX.Channel: PRINT CHR$(177)
      FX.Channel = FX.Channel + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 15, 62 + FX.Channel: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 59, 15, FX.Channel
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 63 TO 71
    PCOPY 7, 0
    LOCATE 15, 62 + FX.Channel: PRINT CHR$(177)
    FX.Channel = x - 62
    COLOR Col.Er, Col.BackEr
    LOCATE 15, 62 + FX.Channel: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 59, 15, FX.Channel
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END SELECT
CASE 17
  SELECT CASE x
  CASE 23
    IF FX.FeedBack > 0 THEN
      PCOPY 7, 0
      LOCATE 17, 24 + FX.FeedBack: PRINT CHR$(177)
      FX.FeedBack = FX.FeedBack - 1
      COLOR Col.Er, Col.BackEr
      LOCATE 17, 24 + FX.FeedBack: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 20, 17, FX.FeedBack
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 32
    IF FX.FeedBack < 7 THEN
      PCOPY 7, 0
      LOCATE 17, 24 + FX.FeedBack: PRINT CHR$(177)
      FX.FeedBack = FX.FeedBack + 1
      COLOR Col.Er, Col.BackEr
      LOCATE 17, 24 + FX.FeedBack: PRINT CHR$(178)
      COLOR Col.Text, Col.BackText: PrintStat 20, 17, FX.FeedBack
      PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .05
    END IF
  CASE 24 TO 31
    PCOPY 7, 0
    LOCATE 17, 24 + FX.FeedBack: PRINT CHR$(177)
    FX.FeedBack = x - 24
    COLOR Col.Er, Col.BackEr
    LOCATE 17, 24 + FX.FeedBack: PRINT CHR$(178)
    COLOR Col.Text, Col.BackText: PrintStat 20, 17, FX.FeedBack
    PCOPY 0, 7
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  CASE 49
    PCOPY 7, 0
    IF FX.Connection THEN
      COLOR Col.Main, Col.BackMain
      LOCATE 17, 49: PRINT CHR$(32)
      FX.Connection = 0: PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .2
    ELSE
      COLOR Col.Main, Col.BackMain
      LOCATE 17, 49: PRINT CHR$(254)
      FX.Connection = 1: PCOPY 0, 7
      COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
      Delay .2
    END IF
  END SELECT
END SELECT

END SUB

SUB CodeToFX
'
' Converts current sound bytes into FX values.
'
FX.Channel = ASC(MID$(Snd(CurSound), 1, 1)) - 175
FX.CTremolo = ReadBit(ASC(MID$(Snd(CurSound), 4, 1)), 7)
FX.MTremolo = ReadBit(ASC(MID$(Snd(CurSound), 6, 1)), 7)
FX.CVibrato = ReadBit(ASC(MID$(Snd(CurSound), 4, 1)), 6)
FX.MVibrato = ReadBit(ASC(MID$(Snd(CurSound), 6, 1)), 6)
FX.CMultiplier = ResetBit(ResetBit(ResetBit(ResetBit(ASC(MID$(Snd(CurSound), 4, 1)), 7), 6), 5), 4)
FX.MMultiplier = ResetBit(ResetBit(ResetBit(ResetBit(ASC(MID$(Snd(CurSound), 6, 1)), 7), 6), 5), 4)
FX.CAttenuation = ResetBit(ResetBit(ASC(MID$(Snd(CurSound), 8, 1)), 7), 6)
FX.MAttenuation = ResetBit(ResetBit(ASC(MID$(Snd(CurSound), 10, 1)), 7), 6)
FX.CAttack = ResetBit(ResetBit(ResetBit(ResetBit(RShift(ASC(MID$(Snd(CurSound), 12, 1)), 4), 7), 6), 5), 4)
FX.MAttack = ResetBit(ResetBit(ResetBit(ResetBit(RShift(ASC(MID$(Snd(CurSound), 14, 1)), 4), 7), 6), 5), 4)
FX.CDecay = ResetBit(ResetBit(ResetBit(ResetBit(ASC(MID$(Snd(CurSound), 12, 1)), 7), 6), 5), 4)
FX.MDecay = ResetBit(ResetBit(ResetBit(ResetBit(ASC(MID$(Snd(CurSound), 14, 1)), 7), 6), 5), 4)
FX.CSustain = ResetBit(ResetBit(ResetBit(ResetBit(RShift(ASC(MID$(Snd(CurSound), 16, 1)), 4), 7), 6), 5), 4)
FX.MSustain = ResetBit(ResetBit(ResetBit(ResetBit(RShift(ASC(MID$(Snd(CurSound), 18, 1)), 4), 7), 6), 5), 4)
FX.CRelease = ResetBit(ResetBit(ResetBit(ResetBit(ASC(MID$(Snd(CurSound), 16, 1)), 7), 6), 5), 4)
FX.MRelease = ResetBit(ResetBit(ResetBit(ResetBit(ASC(MID$(Snd(CurSound), 18, 1)), 7), 6), 5), 4)
FX.CWave = ASC(MID$(Snd(CurSound), 26, 1))
FX.MWave = ASC(MID$(Snd(CurSound), 28, 1))
FX.Connection = ReadBit(ASC(MID$(Snd(CurSound), 24, 1)), 0)
FX.FeedBack = ResetBit(ResetBit(ResetBit(ResetBit(ResetBit(RShift(ASC(MID$(Snd(CurSound), 24, 1)), 1), 7), 6), 5), 4), 3)
FX.Frequency = ASC(MID$(Snd(CurSound), 20, 1)) + (256 * ReadBit(ASC(MID$(Snd(CurSound), 30, 1)), 0)) + (512 * ReadBit(ASC(MID$(Snd(CurSound), 30, 1)), 1))
FX.Octave = ResetBit(ResetBit(ResetBit(ResetBit(ResetBit(RShift(ASC(MID$(Snd(CurSound), 30, 1)), 2), 7), 6), 5), 4), 3)

END SUB

SUB Delay (Tim!)
'
' Pauses execution for Tim! seconds.
'
t! = TIMER
IF (t! + Tim!) > 86400 THEN
  tf! = ((t! + Tim!) - 86400)
  DO WHILE TIMER >= t! OR TIMER <= tf!: LOOP
ELSE
  DO WHILE TIMER <= (t! + Tim!): LOOP
END IF

END SUB

FUNCTION Dir$ (FileSpec$) STATIC
'
' Returns a file from current directory
'
DIM DTA AS STRING * 44, Regs AS RegTypeX
Null$ = CHR$(0)

'-----  Set up our own DTA so we don't destroy COMMAND$
Regs.ax = SetDTA                   'Set DTA function
Regs.dx = VARPTR(DTA)              'DS:DX points to our DTA
Regs.ds = -1                       'Use current value for DS
INTERRUPTX DOS, Regs, Regs         'Do the interrupt

'-----  Check to see if this is First or Next
IF LEN(FileSpec$) THEN             'FileSpec$ isn't null, so
                'FindFirst
  FileSpecZ$ = FileSpec$ + Null$   'Make FileSpec$ into an ASCIIZ
                'string
  Regs.ax = FindFirst              'Perform a FindFirst
  Regs.cx = 0                      'Only look for normal files
  Regs.dx = SADD(FileSpecZ$)       'DS:DX points to ASCIIZ file
  Regs.ds = -1                     'Use current DS
ELSE                               'We have a null FileSpec$,
  Regs.ax = FindNext               'so FindNext
END IF

INTERRUPTX DOS, Regs, Regs         'Do the interrupt

'-----  Return file name or null
IF Regs.flags AND 1 THEN           'No files found
  Dir$ = ""                        'Return null string
ELSE
  Null = INSTR(31, DTA, Null$)     'Get the filename found
  Dir$ = MID$(DTA, 31, Null - 30)  'It's an ASCIIZ string starting
END IF                              'at offset 30 of the DTA

END FUNCTION

SUB DisplayError (ErrCode)
'
' Display occured error into a window.
'
PCOPY 7, 0
PCOPY 0, 6
DrawWindow 20, 10, 60, 15, Col.Er, Col.BackEr, "Error"
SELECT CASE ErrCode
CASE 38: Er$ = "Advanced feature not yet improved!"
CASE 39: Er$ = "No sounds to be deleted!"
CASE 40: Er$ = "No more free sounds available!"
CASE 50: Er$ = "Advanced SoundLab file encountered."
CASE 51: Er$ = "Invalid SoundLab file."
CASE 52: Er$ = "No files found in current directory."
CASE 53: Er$ = "File not found."
CASE 57: Er$ = "Device I/O error."
CASE 61: Er$ = "Disk full."
CASE 68: Er$ = "Device unavailable."
CASE 70: Er$ = "Permission denied."
CASE 71: Er$ = "Disk not ready."
CASE 76: Er$ = "Path not found."
END SELECT
LOCATE 12, (82 - LEN(Er$)) \ 2: PRINT Er$;
LOCATE 14, 38: PRINT "< OK >";
PCOPY 0, 7
COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    PCOPY 7, 0: Oldx = x: Oldy = y
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    IF y = 14 AND x > 37 AND x < 44 THEN EXIT DO
  END IF
LOOP
Hilight 38, 14, Col.Er, Col.BackEr, "< OK >"
Delay .2
PCOPY 6, 0: PCOPY 0, 7
COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);

END SUB

SUB DrawBar (Length)
'
' Draws a bar of specified length (To be used within menus).
'
IF Border = 1 THEN
  s$ = CHR$(204) + STRING$(Length - 2, CHR$(205)) + CHR$(185)
ELSE
  s$ = CHR$(195) + STRING$(Length - 2, CHR$(196)) + CHR$(180)
END IF
PRINT s$
END SUB

SUB DrawWindow (x1, y1, x2, y2, tCol, bCol, Title$)
'
' Draws a window.
' x1,y1 is the upper left corner, x2,y2 is the lower right one.
' tCol and bCol are text color and background color, title$ is the title.
'
COLOR tCol, bCol
FOR i = y1 TO y2
  s$ = ""
  LOCATE i, x1
  SELECT CASE i
  CASE y1
    IF Border = 1 THEN
      s$ = CHR$(201) + STRING$(x2 - x1 - 1, CHR$(205)) + CHR$(187)
    ELSE
      s$ = CHR$(218) + STRING$(x2 - x1 - 1, CHR$(196)) + CHR$(191)
    END IF
  CASE y2
    IF Border = 1 THEN
      s$ = CHR$(200) + STRING$(x2 - x1 - 1, CHR$(205)) + CHR$(188)
    ELSE
      s$ = CHR$(192) + STRING$(x2 - x1 - 1, CHR$(196)) + CHR$(217)
    END IF
  CASE ELSE
    IF Border = 1 THEN
      s$ = CHR$(186) + STRING$(x2 - x1 - 1, CHR$(32)) + CHR$(186)
    ELSE
      s$ = CHR$(179) + STRING$(x2 - x1 - 1, CHR$(32)) + CHR$(179)
    END IF
  END SELECT
  PRINT s$;
NEXT i
IF Title$ <> "" THEN
  LOCATE y1, x1 + (((x2 - x1 + 1) - LEN(" " + Title$ + " ")) \ 2)
  PRINT " " + Title$ + " ";
END IF
IF Shadows = TRUE THEN
  FOR i = y1 + 1 TO y2 + 1
    FOR ii = x2 + 1 TO x2 + 2
      COLOR 7, 0
      LOCATE i, ii: PRINT CHR$(SCREEN(i, ii));
    NEXT ii
  NEXT i
  FOR i = x1 + 2 TO x2
    LOCATE y2 + 1, i: PRINT CHR$(SCREEN(y2 + 1, i));
  NEXT i
END IF
COLOR tCol, bCol

END SUB

SUB EditInstrument
'
' Starts editing the values for the instrument of the current FX.
'
PCOPY 7, 0
COLOR Col.Main, Col.BackMain
FOR i = 7 TO 24: LOCATE i, 1: PRINT STRING$(80, CHR$(176)); : NEXT i

CodeToFX
FOR i = 0 TO 1
  IF i = 0 THEN
    DrawWindow 2, 7, 38, 23, Col.Text, Col.BackText, "Carrier"
  ELSE
    DrawWindow 41, 7, 77, 23, Col.Text, Col.BackText, "Modulator"
  END IF
  LOCATE 9, (i * 39) + 4: PRINT "Multiplier:"
  LOCATE 11, (i * 39) + 4: PRINT "Out level:"
  LOCATE 13, (i * 39) + 4: PRINT "Attack:"
  LOCATE 15, (i * 39) + 4: PRINT "Decay:"
  LOCATE 17, (i * 39) + 4: PRINT "Sustain:"
  LOCATE 19, (i * 39) + 4: PRINT "Release:"
  LOCATE 21, (i * 39) + 4: PRINT "Vibrato    Tremolo    <Wave Type>"
  COLOR Col.Main, Col.BackMain
  FOR ii = 9 TO 19 STEP 2
    LOCATE ii, (i * 39) + 19
    PRINT CHR$(27) + STRING$(16, CHR$(177)) + CHR$(26)
  NEXT ii
  LOCATE 21, (i * 39) + 12: PRINT CHR$(32);
  LOCATE 21, (i * 39) + 23: PRINT CHR$(32);
NEXT i
COLOR Col.Menu, Col.BackMenu
LOCATE 25, 45: PRINT CHR$(179) + " Instrument editor";
Edit = 1
COLOR Col.Main, Col.BackMain
IF FX.CVibrato THEN LOCATE 21, 12: PRINT CHR$(254)
IF FX.CTremolo THEN LOCATE 21, 23: PRINT CHR$(254)
IF FX.MVibrato THEN LOCATE 21, 51: PRINT CHR$(254)
IF FX.MTremolo THEN LOCATE 21, 62: PRINT CHR$(254)
COLOR Col.Er, Col.BackEr
LOCATE 9, 20 + FX.CMultiplier: PRINT CHR$(178)
LOCATE 9, 59 + FX.MMultiplier: PRINT CHR$(178)
LOCATE 11, 20 + (FX.CAttenuation \ 4): PRINT CHR$(178)
LOCATE 11, 59 + (FX.MAttenuation \ 4): PRINT CHR$(178)
LOCATE 13, 20 + FX.CAttack: PRINT CHR$(178)
LOCATE 13, 59 + FX.MAttack: PRINT CHR$(178)
LOCATE 15, 20 + FX.CDecay: PRINT CHR$(178)
LOCATE 15, 59 + FX.MDecay: PRINT CHR$(178)
LOCATE 17, 20 + FX.CSustain: PRINT CHR$(178)
LOCATE 17, 59 + FX.MSustain: PRINT CHR$(178)
LOCATE 19, 20 + FX.CRelease: PRINT CHR$(178)
LOCATE 19, 59 + FX.MRelease: PRINT CHR$(178)
                
COLOR Col.Text, Col.BackText
PrintStat 16, 9, FX.CMultiplier
PrintStat 55, 9, FX.MMultiplier
PrintStat 16, 11, FX.CAttenuation
PrintStat 55, 11, FX.MAttenuation
PrintStat 16, 13, FX.CAttack
PrintStat 55, 13, FX.MAttack
PrintStat 16, 15, FX.CDecay
PrintStat 55, 15, FX.MDecay
PrintStat 16, 17, FX.CSustain
PrintStat 55, 17, FX.MSustain
PrintStat 16, 19, FX.CRelease
PrintStat 55, 19, FX.MRelease
PCOPY 0, 7

END SUB

SUB EditSound
'
' Starts editing the values for the sound of the current FX.
'
COLOR Col.Main, Col.BackMain
FOR i = 7 TO 24: LOCATE i, 1: PRINT STRING$(80, CHR$(176)); : NEXT i

CodeToFX
DrawWindow 4, 8, 75, 19, Col.Text, Col.BackText, "Sound"
LOCATE 10, 7: PRINT "Sound Name:"
LOCATE 12, 7: PRINT "Current frequency:"
LOCATE 15, 7: PRINT "Octave:"
LOCATE 15, 38: PRINT "Played on Channel:"
LOCATE 17, 7: PRINT "FeedBack:"
LOCATE 17, 38: PRINT "Connected:"
COLOR Col.Main, Col.BackMain
LOCATE 10, 23: PRINT MID$(Snd(CurSound), 31, 20)
LOCATE 13, 7: PRINT CHR$(27) + STRING$(64, CHR$(177)) + CHR$(26)
LOCATE 15, 23: PRINT CHR$(27) + STRING$(8, CHR$(177)) + CHR$(26)
LOCATE 15, 62: PRINT CHR$(27) + STRING$(9, CHR$(177)) + CHR$(26)
LOCATE 17, 23: PRINT CHR$(27) + STRING$(8, CHR$(177)) + CHR$(26)
LOCATE 17, 49: PRINT CHR$(32)
IF FX.Connection = 1 THEN LOCATE 17, 49: PRINT CHR$(254)
COLOR Col.Er, Col.BackEr
LOCATE 13, 8 + (FX.Frequency \ 16): PRINT CHR$(178)
LOCATE 15, 24 + FX.Octave: PRINT CHR$(178)
LOCATE 15, 62 + FX.Channel: PRINT CHR$(178)
LOCATE 17, 24 + FX.FeedBack: PRINT CHR$(178)
COLOR Col.Text, Col.BackText
PrintStat 20, 15, FX.Octave
PrintStat 59, 15, FX.Channel
PrintStat 20, 17, FX.FeedBack
s$ = LTRIM$(STR$(FX.Frequency))
IF LEN(s$) < 4 THEN s$ = STRING$(4 - LEN(s$), CHR$(48)) + s$
LOCATE 12, 28: PRINT s$
COLOR Col.Menu, Col.BackMenu
LOCATE 25, 45: PRINT CHR$(179) + " Sound editor     ";
Edit = 2
PCOPY 0, 7

END SUB

SUB EditWave (Which)
'
' Edits wave type of carrier/modulator
'
TIMER OFF
Hilight 26 + ((Which - 1) * 39), 21, Col.Text, Col.BackText, "<Wave Type>"
PCOPY 7, 0
IF Which = 1 THEN W$ = "Carrier" ELSE W$ = "Modulator"
DrawWindow 29, 8, 50, 19, Col.Text, Col.BackText, W$ + " wave"
LOCATE 10, 34: PRINT "Normal sine"
LOCATE 12, 34: PRINT "Half sine"
LOCATE 14, 34: PRINT "Rectified sine"
LOCATE 16, 34: PRINT "Cliped sine"
LOCATE 18, 37: PRINT "< OK >"
COLOR Col.Main, Col.BackMain
FOR i = 0 TO 3: LOCATE 10 + (i * 2), 32: PRINT CHR$(32); : NEXT i
IF Which = 1 THEN Wave = FX.CWave ELSE Wave = FX.MWave
LOCATE 10 + (Wave * 2), 32: PRINT CHR$(254);
PCOPY 0, 6
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 6, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    IF x = 32 THEN
      IF y = 10 OR y = 12 OR y = 14 OR y = 16 THEN
        PCOPY 6, 0
        LOCATE 10 + (Wave * 2), 32
        COLOR Col.Main, Col.BackMain: PRINT CHR$(32);
        Wave = (y - 10) \ 2
        LOCATE 10 + (Wave * 2), 32: PRINT CHR$(254);
        PCOPY 0, 6: LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
      END IF
    END IF
    IF y = 18 THEN
      IF x > 36 AND x < 43 THEN EXIT DO
    END IF
  END IF
LOOP
Hilight 37, 18, Col.Text, Col.BackText, "< OK >"
IF Which = 1 THEN FX.CWave = Wave ELSE FX.MWave = Wave
PCOPY 7, 0
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
Delay .2
TIMER ON

END SUB

FUNCTION FileSelect$ (Mode)
'
' Selects a file from file list for different purposes.
'
Delay .3
DIM File$(1000): NumFiles = 0
File$(1) = Dir$("*." + Ext)
IF File$(1) <> "" THEN NumFiles = 1
FOR i = 2 TO 1000
  File$(i) = Dir$("")
  IF File$(i) <> "" THEN NumFiles = NumFiles + 1
NEXT i
IF NumFiles > 1 THEN Sort File$(), 1, NumFiles
SELECT CASE Mode
CASE 1            'Load file
  IF NumFiles = 0 THEN LastErr = TRUE: ERROR 52: FileSelect$ = "": EXIT FUNCTION
  DrawWindow 7, 5, 24, 16, Col.Text, Col.BackText, "Open"
  COLOR Col.Main, Col.BackMain
  LOCATE 6, 22: PRINT CHR$(24)
  LOCATE 15, 22: PRINT CHR$(25)
  FOR i = 7 TO 14
    COLOR Col.Main, Col.BackMain
    LOCATE i, 22: PRINT CHR$(177)
    IF NumFiles <= 10 THEN
      COLOR Col.Er, Col.BackEr
      LOCATE i, 22: PRINT CHR$(178)
    END IF
  NEXT i
  IF NumFiles > 10 THEN
    LOCATE 7, 22: COLOR Col.Er, Col.BackEr: PRINT CHR$(178)
  END IF
  COLOR Col.Text, Col.BackText
  FOR i = 1 TO 10
    LOCATE 5 + i, 9: PRINT File$(i)
  NEXT i
  FilePos = 0
  PCOPY 0, 2
  LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
  DO
    MouseStatus Lb, Rb, x, y
    IF x <> Oldx OR y <> Oldy THEN
      PCOPY 2, 0: Oldx = x: Oldy = y
      LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
    END IF
    IF Lb THEN
      IF x = 22 THEN
        IF y = 6 AND FilePos > 0 THEN
          PCOPY 2, 0
          LOCATE 7 + ((7 / (NumFiles - 10)) * FilePos), 22
          COLOR Col.Main, Col.BackMain: PRINT CHR$(177)
          FilePos = FilePos - 1
          COLOR Col.Text, Col.BackText
          FOR i = 1 TO 10
            LOCATE 5 + i, 9: PRINT SPACE$(12)
            LOCATE 5 + i, 9: PRINT File$(i + FilePos)
          NEXT i
          LOCATE 7 + ((7 / (NumFiles - 10)) * FilePos), 22
          COLOR Col.Er, Col.BackEr: PRINT CHR$(178)
          PCOPY 0, 2
          LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
          Delay .05
        END IF
        IF y = 15 AND FilePos < NumFiles - 10 THEN
          PCOPY 2, 0
          LOCATE 7 + ((7 / (NumFiles - 10)) * FilePos), 22
          COLOR Col.Main, Col.BackMain: PRINT CHR$(177)
          FilePos = FilePos + 1
          COLOR Col.Text, Col.BackText
          FOR i = 1 TO 10
            LOCATE 5 + i, 9: PRINT SPACE$(12)
            LOCATE 5 + i, 9: PRINT File$(i + FilePos)
          NEXT i
          LOCATE 7 + ((7 / (NumFiles - 10)) * FilePos), 22
          COLOR Col.Er, Col.BackEr: PRINT CHR$(178)
          PCOPY 0, 2
          LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
          Delay .05
        END IF
      END IF
      IF y > 5 AND y < 16 THEN
        IF x > 7 AND x < 22 THEN
          F$ = File$((y - 5) + FilePos)
          s$ = " " + F$ + SPACE$(13 - LEN(F$))
          Hilight 8, y, Col.Text, Col.BackText, s$
          FileSelect$ = LEFT$(F$, INSTR(F$, ".") - 1)
          EXIT DO
        END IF
      END IF
    END IF
    k$ = INKEY$
    IF k$ = CHR$(27) THEN FileSelect$ = "": EXIT DO
  LOOP
CASE 2            ' Save file
  DrawWindow 7, 5, 24, 8, Col.Text, Col.BackText, "Save as"
  LOCATE 6, 9: PRINT "File name:"
  LOCATE 7, 19: PRINT "." + Ext
  COLOR Col.Main, Col.BackMain
  LOCATE 7, 9: PRINT SPACE$(9)
  LOCATE 7, 9: PRINT "_"
  n$ = ""
  DO
    k$ = INKEY$: WHILE k$ = "": k$ = INKEY$: WEND
    IF k$ = CHR$(27) THEN FileSelect$ = "": EXIT DO
    k$ = UCASE$(k$)
    IF k$ >= "A" AND k$ <= "Z" AND LEN(n$) < 8 THEN
      n$ = n$ + k$: LOCATE 7, 9: PRINT n$ + "_"
    END IF
    IF k$ >= "0" AND k$ <= "9" AND LEN(n$) < 8 THEN
      IF n$ <> "" THEN n$ = n$ + k$: LOCATE 7, 9: PRINT n$ + "_"
    END IF
    IF k$ = CHR$(8) AND n$ <> "" THEN
      n$ = LEFT$(n$, LEN(n$) - 1)
      LOCATE 7, 9: PRINT n$ + "_ "
    END IF
    IF k$ = CHR$(13) THEN
      IF n$ = "" THEN
        Message "Please insert file name."
      ELSE
        EXIT DO
      END IF
    END IF
  LOOP
  FileSelect$ = n$
END SELECT

END FUNCTION

SUB FXToCode
'
' Converts current FX values into bytes
'
FOR i = 1 TO 15
  MID$(Snd(CurSound), (i * 2) - 1, 1) = CHR$(ChData(FX.Channel - 1, i))
NEXT i
' The following variables names referre to channel 0 regs.
' I used them to avoid using strange names.
MID$(Snd(CurSound), 2, 1) = CHR$(0)
Reg20 = FX.CMultiplier
IF FX.CTremolo THEN Reg20 = SetBit(Reg20, 7)
IF FX.CVibrato THEN Reg20 = SetBit(Reg20, 6)
MID$(Snd(CurSound), 4, 1) = CHR$(Reg20)
Reg23 = FX.MMultiplier
IF FX.MTremolo THEN Reg23 = SetBit(Reg23, 7)
IF FX.MVibrato THEN Reg23 = SetBit(Reg23, 6)
MID$(Snd(CurSound), 6, 1) = CHR$(Reg23)
Reg40 = FX.CAttenuation
MID$(Snd(CurSound), 8, 1) = CHR$(Reg40)
Reg43 = FX.MAttenuation
MID$(Snd(CurSound), 10, 1) = CHR$(Reg43)
Reg60 = FX.CDecay
temp = FX.CAttack
FOR i = 0 TO 3
  IF ReadBit(temp, i) THEN Reg60 = SetBit(Reg60, 4 + i)
NEXT i
MID$(Snd(CurSound), 12, 1) = CHR$(Reg60)
Reg63 = FX.MDecay
temp = FX.MAttack
FOR i = 0 TO 3
  IF ReadBit(temp, i) THEN Reg63 = SetBit(Reg63, 4 + i)
NEXT i
MID$(Snd(CurSound), 14, 1) = CHR$(Reg63)
Reg80 = FX.CRelease
temp = FX.CSustain
FOR i = 0 TO 3
  IF ReadBit(temp, i) THEN Reg80 = SetBit(Reg80, 4 + i)
NEXT i
MID$(Snd(CurSound), 16, 1) = CHR$(Reg80)
Reg83 = FX.MRelease
temp = FX.MSustain
FOR i = 0 TO 3
  IF ReadBit(temp, i) THEN Reg83 = SetBit(Reg83, 4 + i)
NEXT i
MID$(Snd(CurSound), 18, 1) = CHR$(Reg83)
MID$(Snd(CurSound), 22, 1) = CHR$(192)
RegC0 = FX.FeedBack
RegC0 = LShift(RegC0, 1)
IF FX.Connection THEN RegC0 = SetBit(RegC0, 0)
MID$(Snd(CurSound), 24, 1) = CHR$(RegC0)
MID$(Snd(CurSound), 26, 1) = CHR$(FX.CWave)
MID$(Snd(CurSound), 28, 1) = CHR$(FX.MWave)
MID$(Snd(CurSound), 20, 1) = CHR$(RShift(LShift(FX.Frequency, 2), 2))
RegB0 = LShift(FX.Octave, 2)
IF ReadBit(FX.Frequency, 8) THEN RegB0 = SetBit(RegB0, 0)
IF ReadBit(FX.Frequency, 9) THEN RegB0 = SetBit(RegB0, 1)
RegB0 = SetBit(RegB0, 5)
MID$(Snd(CurSound), 30, 1) = CHR$(RegB0)

END SUB

SUB Hilight (x1, y1, tCol, bCol, Text$)
'
' Hilights Text$ located at x1,y1.
'
COLOR bCol, tCol: LOCATE y1, x1: PRINT Text$
t! = TIMER: DO: LOOP UNTIL TIMER > t! + .1
COLOR tCol, bCol: LOCATE y1, x1: PRINT Text$

END SUB

SUB Init
'
' Initializes screen and global parameters.
'
SCREEN 0: WIDTH 80, 25: CLS

StartTime$ = TIME$
SBDetected = FALSE
FOR port = &H210 TO &H280 STEP &H10
  OUT port + &H6, 1
  FOR Count = 1 TO 100
    OUT port + &H6, 0
    Stat = INP(port + &HE)
    Stat = INP(port + &HA)
    IF Stat = &HAA THEN EXIT FOR
  NEXT Count
  IF Stat = &HAA THEN SBDetected = TRUE: BasePort = port: EXIT FOR
NEXT port
IF NOT SBDetected THEN
  PRINT "Sorry, this program requires a SoundBlaster compatible sound card to run."
  PRINT : END
END IF

RESTORE MouseData
FOR i = 1 TO 57:  READ A$:  H$ = CHR$(VAL("&H" + A$))
MID$(mouse$, i, 1) = H$: NEXT i
ms = MouseInit
IF NOT ms THEN
  PRINT "Sorry, this program requires a mouse in order to run."
  PRINT : END
END IF

RESTORE ChannelData
FOR i = 0 TO 8: FOR ii = 1 TO 15
  READ Dat$: ChData(i, ii) = VAL("&H" + Dat$)
NEXT ii, i

OPEN "SOUNDLAB.CFG" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  RESTORE DefaultConfig
  FOR i = 1 TO 11: READ Dat: PUT #1, , Dat: NEXT i
  READ Ext: PUT #1, , Ext
END IF
CLOSE #1
OPEN "SOUNDLAB.CFG" FOR BINARY AS #1
GET #1, , Col: GET #1, , Volume: GET #1, , Shadows: GET #1, , Border
GET #1, , Ext: CLOSE #1
SetVol Volume

NumSound = 1: CurSound = 1: FileName$ = "NONAME"
FOR i = 1 TO 15
  MID$(Snd(1), (i * 2) - 1, 1) = CHR$(ChData(0, i))
  MID$(Snd(1), (i * 2), 1) = CHR$(0)
NEXT i
MID$(Snd(1), 31, 20) = "Stop sound on ch.#1 "

COLOR Col.Main, Col.BackMain
FOR i = 1 TO 25: LOCATE i, 1: PRINT STRING$(80, CHR$(176)); : NEXT i
COLOR Col.Menu, Col.BackMenu
LOCATE 1, 1: PRINT SPACE$(80);
LOCATE 1, 1: PRINT "  File  Edit  Options  About"
LOCATE 25, 1: PRINT SPACE$(80);
LOCATE 25, 66: PRINT CHR$(179);
LOCATE 25, 70: PRINT TIME$;
DrawWindow 2, 3, 77, 5, Col.Text, Col.BackText, FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(1), 31, 20))
COLOR Col.Text, Col.BackText
LOCATE 4, 5: PRINT "<PLAY>  <STOP>  <NEXT>  <PREV>"
LOCATE 4, 40: PRINT USING "###/###"; CurSound; NumSound
LOCATE 4, 50: PRINT "Volume:"
COLOR Col.Main, Col.BackMain
LOCATE 4, 58: PRINT CHR$(27) + STRING$(15, CHR$(177)) + CHR$(26)
COLOR Col.Er, Col.BackEr
LOCATE 4, 58 + Volume: PRINT CHR$(178);
PCOPY 0, 7
TIMER ON
EditInstrument

END SUB

SUB Load (File$)
'
' Loads selected sound file.
'
OPEN File$ + "." + Ext FOR BINARY AS #1
id$ = SPACE$(4)
GET #1, , id$
IF MID$(id$, 1, 2) <> "SL" THEN CLOSE #1: LastErr = TRUE: ERROR 51
Version = VAL(MID$(id$, 3, 2))
IF Version <> 10 THEN CLOSE #1: LastErr = TRUE: ERROR 50
GET #1, , NumSound
FOR i = 1 TO NumSound
  GET #1, , Snd(i)
NEXT i
CLOSE #1
CurSound = 1

END SUB

FUNCTION LShift (Byte, Bits)
'
' Shifts left a number of n bits in specified byte.
'
LShift = (Byte * (2 ^ Bits)) MOD 256
END FUNCTION

SUB MainLoop
'
' Main program loop starts here.
'
MouseRange 0, 0, 639, 199
MouseStatus Lb, Rb, x, y
Oldx = x: Oldy = y
Welcome
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 7, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    TIMER OFF
    IF y > 8 THEN
      IF Edit = 1 THEN
        CheckInstrument
      ELSE
        CheckSound
      END IF
    ELSE
      CheckGlobal
    END IF
    TIMER ON
  END IF
LOOP

END SUB

SUB MenuEdit
'
' Edit menu handling.
'
PCOPY 7, 0
LOCATE 1, 8: COLOR Col.BackMenu, Col.Menu: PRINT " Edit "
DrawWindow 7, 2, 26, 14, Col.Menu, Col.BackMenu, ""
LOCATE 3, 9: PRINT "Add sound"
LOCATE 4, 9: PRINT "Delete sound"
LOCATE 5, 9: PRINT "Sound in buffer"
LOCATE 6, 9: PRINT "Buffer in sound"
LOCATE 7, 9: PRINT "Swap sounds"
LOCATE 8, 7: DrawBar 20
LOCATE 9, 9: PRINT "Name..."
LOCATE 10, 7: DrawBar 20
LOCATE 11, 9: PRINT "Pick from list"
LOCATE 12, 7: DrawBar 20
IF Edit = 1 THEN Change$ = " Sound...         " ELSE Change$ = " Instrument...    "
LOCATE 13, 8: PRINT Change$
PCOPY 0, 5
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
Menu = FALSE
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 5, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    IF y = 1 THEN
      IF x < 8 OR x > 13 THEN Menu = TRUE: EXIT DO
    END IF
    SELECT CASE x
    CASE 8 TO 25
      SELECT CASE y
      CASE 3
        Hilight 8, 3, Col.Menu, Col.BackMenu, " Add sound        "
        IF NumSound = MaxSound THEN ERROR 40: EXIT DO
        PCOPY 7, 0
        FXToCode
        NumSound = NumSound + 1
        CurSound = NumSound
        FOR i = 1 TO 15
          MID$(Snd(CurSound), (i * 2) - 1, 1) = CHR$(ChData(0, i))
          MID$(Snd(CurSound), (i * 2), 1) = CHR$(0)
        NEXT i
        MID$(Snd(CurSound), 31, 20) = "New sound on ch. #1 "
        COLOR Col.Text, Col.BackText
        IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
        LOCATE 3, 3: PRINT STRING$(73, s$)
        s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(CurSound), 31, 20))
        LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
        LOCATE 4, 40: PRINT USING "###/###"; CurSound; NumSound
        PCOPY 0, 7
        IF Edit = 1 THEN EditInstrument ELSE EditSound
        EXIT DO
      CASE 4
        Hilight 8, 4, Col.Menu, Col.BackMenu, " Delete sound     "
        IF NumSound = 1 THEN ERROR 39: EXIT DO
        IF Ask("Confirm deletion of current sound?") THEN
          IF CurSound = NumSound THEN
            NumSound = NumSound - 1: CurSound = CurSound - 1
          ELSE
            FOR i = CurSound TO NumSound - 1: Snd(i) = Snd(i + 1): NEXT i
            NumSound = NumSound - 1
          END IF
          PCOPY 7, 0
          COLOR Col.Text, Col.BackText
          IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
          LOCATE 3, 3: PRINT STRING$(73, s$)
          s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(CurSound), 31, 20))
          LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
          LOCATE 4, 40: PRINT USING "###/###"; CurSound; NumSound
          PCOPY 0, 7
          IF Edit = 1 THEN EditInstrument ELSE EditSound
        END IF
        EXIT DO
      CASE 5
        Hilight 8, 5, Col.Menu, Col.BackMenu, " Sound in buffer  "
        TempSnd = Snd(CurSound)
        EXIT DO
      CASE 6
        Hilight 8, 6, Col.Menu, Col.BackMenu, " Buffer in sound  "
        Snd(CurSound) = TempSnd
        PCOPY 7, 0
        COLOR Col.Text, Col.BackText
        IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
        LOCATE 3, 3: PRINT STRING$(73, s$)
        s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(CurSound), 31, 20))
        LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
        PCOPY 0, 7
        IF Edit = 1 THEN EditInstrument ELSE EditSound
        EXIT DO
      CASE 7
        Hilight 8, 7, Col.Menu, Col.BackMenu, " Swap sounds      "
        FXToCode
        A = PickSound("Select first sound")
        Delay .2
        IF A <> 0 THEN
          b = PickSound("Select second sound")
          Delay .2
          IF b <> 0 THEN
            s$ = "Confirm swap sound" + STR$(A) + " with sound" + STR$(b) + " ?"
            IF Ask(s$) THEN
              SWAP Snd(A), Snd(b)
              PCOPY 7, 0
              COLOR Col.Text, Col.BackText
              IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
              LOCATE 3, 3: PRINT STRING$(73, s$)
              s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(CurSound), 31, 20))
              LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
              PCOPY 0, 7
              IF Edit = 1 THEN EditInstrument ELSE EditSound
              EXIT DO
            END IF
          END IF
        END IF
        EXIT DO
      CASE 9
        Hilight 8, 9, Col.Menu, Col.BackMenu, " Name...          "
        PCOPY 5, 0
        DrawWindow 20, 10, 44, 12, Col.Text, Col.BackText, "Enter new name"
        COLOR Col.Main, Col.BackMain
        LOCATE 11, 22: PRINT SPACE$(21)
        LOCATE 11, 22: PRINT MID$(Snd(CurSound), 31, 20)
        n$ = MID$(Snd(CurSound), 31, 20)
        n$ = RTRIM$(n$)
        LOCATE 11, 22 + LEN(n$): PRINT "_"
        DO
          k$ = INKEY$: WHILE k$ = "": k$ = INKEY$: WEND
          IF ASC(k$) > 31 AND LEN(n$) < 20 THEN
            n$ = n$ + k$: LOCATE 11, 22: PRINT n$ + "_"
          END IF
          IF k$ = CHR$(8) AND n$ <> "" THEN
            n$ = LEFT$(n$, LEN(n$) - 1)
            LOCATE 11, 22: PRINT n$ + "_ "
          END IF
          IF k$ = CHR$(13) THEN
            IF n$ = "" THEN n$ = "Unknown"
            MID$(Snd(CurSound), 31, 20) = SPACE$(20)
            MID$(Snd(CurSound), 31, 20) = n$
            EXIT DO
          END IF
          IF k$ = CHR$(27) THEN EXIT DO
        LOOP
        PCOPY 7, 0
        COLOR Col.Text, Col.BackText
        IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
        LOCATE 3, 3: PRINT STRING$(73, s$)
        s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(CurSound), 31, 20))
        LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
        PCOPY 0, 7
        EXIT DO
      CASE 11
        Hilight 8, 11, Col.Menu, Col.BackMenu, " Pick from list   "
        FXToCode
        A = PickSound("Pick a sound")
        IF A <> 0 THEN
          CurSound = A
          PCOPY 7, 0
          COLOR Col.Text, Col.BackText
          IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
          LOCATE 3, 3: PRINT STRING$(73, s$)
          s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(CurSound), 31, 20))
          LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
          LOCATE 4, 40: PRINT USING "###/###"; CurSound; NumSound
          PCOPY 0, 7
          IF Edit = 1 THEN EditInstrument ELSE EditSound
        END IF
        EXIT DO
      CASE 13
        Hilight 8, 13, Col.Menu, Col.BackMenu, Change$
        PCOPY 7, 0
        FXToCode
        IF Edit = 1 THEN EditSound ELSE EditInstrument
        EXIT DO
      CASE IS > 14: EXIT DO
      END SELECT
    CASE ELSE: EXIT DO
    END SELECT
  END IF
LOOP
PCOPY 7, 0
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
IF NOT Menu THEN Delay .3

END SUB

SUB MenuFile
'
' File menu handling.
'
PCOPY 7, 0
LOCATE 1, 2: COLOR Col.BackMenu, Col.Menu: PRINT " File "
DrawWindow 1, 2, 15, 11, Col.Menu, Col.BackMenu, ""
LOCATE 3, 3: PRINT "New"
LOCATE 4, 3: PRINT "Open..."
LOCATE 5, 3: PRINT "Save"
LOCATE 6, 3: PRINT "Save as..."
LOCATE 7, 1: DrawBar 15
LOCATE 8, 3: PRINT "Info"
LOCATE 9, 1: DrawBar 15
LOCATE 10, 3: PRINT "Quit"
PCOPY 0, 5
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
Menu = FALSE
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 5, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    IF y = 1 THEN
      IF x < 2 OR x > 7 THEN Menu = TRUE: EXIT DO
    END IF
    SELECT CASE x
    CASE 2 TO 14
      SELECT CASE y
      CASE 3
        Hilight 2, 3, Col.Menu, Col.BackMenu, " New         "
        PCOPY 5, 0
        IF Ask("Current sound effects will be lost. Continue?") THEN
          PCOPY 7, 0
          FOR i = 2 TO MaxSound
            Snd(i) = STRING$(50, CHR$(0))
          NEXT i
          NumSound = 1: CurSound = 1: FileName$ = "NONAME"
          FOR i = 1 TO 15
            MID$(Snd(1), (i * 2) - 1, 1) = CHR$(ChData(0, i))
            MID$(Snd(1), (i * 2), 1) = CHR$(0)
          NEXT i
          COLOR Col.Text, Col.BackText
          MID$(Snd(1), 31, 20) = "Stop sound on ch.#1 "
          LOCATE 4, 40: PRINT USING "###/###"; CurSound; NumSound
          IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
          LOCATE 3, 3: PRINT STRING$(73, s$)
          s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(1), 31, 20))
          LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
          PCOPY 0, 7
          EXIT DO
        ELSE
          EXIT DO
        END IF
      CASE 4
        Hilight 2, 4, Col.Menu, Col.BackMenu, " Open        "
        PCOPY 5, 0
        F$ = FileSelect$(1)
        IF F$ = "" THEN
          EXIT DO
        ELSE
          Load F$
          IF LastErr = FALSE THEN
            PCOPY 7, 0
            IF Edit = 1 THEN EditInstrument ELSE EditSound
            CurSound = 1: FileName$ = F$
            LOCATE 4, 40: PRINT USING "###/###"; CurSound; NumSound
            IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
            LOCATE 3, 3: PRINT STRING$(73, s$)
            s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(1), 31, 20))
            LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
            PCOPY 0, 7
            CodeToFX
            IF Edit = 1 THEN EditInstrument ELSE EditSound
            EXIT DO
          ELSE
            LastErr = FALSE
          END IF
        END IF
      CASE 5
        Hilight 2, 5, Col.Menu, Col.BackMenu, " Save        "
        PCOPY 5, 0
        Save FileName$
        EXIT DO
      CASE 6
        Hilight 2, 6, Col.Menu, Col.BackMenu, " Save as     "
        PCOPY 5, 0
        F$ = FileSelect$(2)
        IF F$ = "" THEN
          EXIT DO
        ELSE
          OPEN F$ + "." + Ext FOR BINARY AS #1
          L = LOF(1): CLOSE #1
          IF L <> 0 THEN
            IF Ask("File already exists. Overwrite?") THEN
              Save F$
            ELSE
              EXIT DO
            END IF
          ELSE
            Save F$
          END IF
          PCOPY 7, 0
          FileName$ = F$
          COLOR Col.Text, Col.BackText
          IF Border = 1 THEN s$ = CHR$(205) ELSE s$ = CHR$(196)
          LOCATE 3, 3: PRINT STRING$(73, s$)
          s$ = FileName$ + "." + Ext + " - " + RTRIM$(MID$(Snd(CurSound), 31, 20))
          LOCATE 3, ((80 - LEN(" " + s$ + " ")) \ 2): PRINT " " + s$ + " "
          PCOPY 0, 7
        END IF
        EXIT DO
      CASE 8
        Hilight 2, 8, Col.Menu, Col.BackMenu, " Info        "
        PCOPY 5, 0
        ShowInfo
        EXIT DO
      CASE 10
        Hilight 2, 10, Col.Menu, Col.BackMenu, " Quit        "
        PCOPY 5, 0
        IF Ask("Are you sure to want to quit?") THEN
          COLOR 7, 0: CLS
          FOR i = &H0 TO &HF5
            OUT &H388, i
            OUT &H389, 0
          NEXT i
          PRINT "QuickBasic SOUNDLAB"
          PRINT "                       version 1.0"
          PRINT "                       by Angelo Mottola soft"
          PRINT
          PRINT "Thanks for using this program, I hope this will help you a lot in doing great"
          PRINT "SB effects for your games. If you have any suggestion, or you just want to do"
          PRINT "a comment to my work, don't esitate and send me a message at my new address:": PRINT
          PRINT "-----------------------"
          PRINT "angelillo@geocities.com"
          PRINT "-----------------------": PRINT
          PRINT "Also, visit my home page (QBasic Enhanced Programming Page) located at:": PRINT
          PRINT "-------------------------------------------------"
          PRINT "http://www.geocities.com/SiliconValley/Lakes/7303"
          PRINT "-------------------------------------------------"
          PRINT : END
        ELSE
          EXIT DO
        END IF
      CASE IS > 11: EXIT DO
      END SELECT
    CASE ELSE: EXIT DO
    END SELECT
  END IF
LOOP
PCOPY 7, 0
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
IF NOT Menu THEN Delay .3
END SUB

SUB MenuOptions
'
' Options menu handling.
'
PCOPY 7, 0
LOCATE 1, 14: COLOR Col.BackMenu, Col.Menu: PRINT " Options "
DrawWindow 13, 2, 35, 7, Col.Menu, Col.BackMenu, ""
LOCATE 3, 15: PRINT "Screen appearence"
LOCATE 4, 13: DrawBar 23
LOCATE 5, 15: PRINT "Show reg values"
LOCATE 6, 15: PRINT "Show channel stats"
PCOPY 0, 5
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
Menu = FALSE
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 5, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    IF y = 1 THEN
      IF x < 14 OR x > 22 THEN Menu = TRUE: EXIT DO
    END IF
    SELECT CASE x
    CASE 14 TO 34
      SELECT CASE y
      CASE 3
        Hilight 14, 3, Col.Menu, Col.BackMenu, " Screen appearence   "
        DrawWindow 30, 3, 49, 8, Col.Menu, Col.BackMenu, "Pick color set"
        LOCATE 4, 32: PRINT "Standard"
        LOCATE 5, 32: PRINT "Nature feeling"
        LOCATE 6, 32: PRINT "Psycho"
        LOCATE 7, 32: PRINT "Black and white"
        PCOPY 0, 4
        LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
        DO
          MouseStatus Lb, Rb, x, y
          IF x <> Oldx OR y <> Oldy THEN
            Oldx = x: Oldy = y: PCOPY 4, 0
            COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
          END IF
          IF Lb THEN
            IF x > 30 AND x < 49 THEN
              IF y > 3 AND y < 8 THEN
                DIM New AS ColorType
                SELECT CASE y
                CASE 4
                  Hilight 31, 4, Col.Menu, Col.BackMenu, " Standard         "
                  RESTORE DefaultConfig: EXIT DO
                CASE 5
                  Hilight 31, 5, Col.Menu, Col.BackMenu, " Nature Feeling   "
                  RESTORE NatureFeeling: EXIT DO
                CASE 6
                  Hilight 31, 6, Col.Menu, Col.BackMenu, " Psycho           "
                  RESTORE Psycho: EXIT DO
                CASE 7
                  Hilight 31, 7, Col.Menu, Col.BackMenu, " Black and white  "
                  RESTORE BlackAndWhite: EXIT DO
                END SELECT
              END IF
            END IF
          END IF
        LOOP
        n = Ask("Do you want to change the border of the windows?")
        Delay .3
        s = Ask("Do you want shadows to the windows?")
        Delay .3
        OPEN "SOUNDLAB.CFG" FOR BINARY AS #1
        FOR i = 0 TO 7: READ A: PUT #1, , A: NEXT i
        b = Border
        IF n THEN
          IF Border = 1 THEN b = 2 ELSE b = 1
        END IF
        PUT #1, , Volume: PUT #1, , s: PUT #1, , b: PUT #1, , Ext
        CLOSE #1
        A = Ask("Changes will not become operative until you restart. Restart now?")
        IF A THEN RUN
        EXIT DO
      CASE 5
        Hilight 14, 5, Col.Menu, Col.BackMenu, " Show reg values     "
        ShowRegs
        EXIT DO
      CASE 6
        Hilight 14, 6, Col.Menu, Col.BackMenu, " Show channel stats  "
        ShowChStats
        EXIT DO
      CASE IS > 7: EXIT DO
      END SELECT
    CASE ELSE: EXIT DO
    END SELECT
  END IF
LOOP
PCOPY 7, 0
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
IF NOT Menu THEN Delay .3

END SUB

SUB Message (Text$)
'
' Displays given message on the bottom of the screen.
'
COLOR Col.Menu, Col.BackMenu
LOCATE 25, 1: PRINT SPACE$(44);
LOCATE 25, 3: PRINT Text$;
END SUB

SUB MouseDriver (ax, bx, cx, dx)
'
' Makes the call to the asm routines of the mouse.
'
DEF SEG = VARSEG(mouse$)
mouse = SADD(mouse$)
CALL ABSOLUTE(ax, bx, cx, dx, mouse)
END SUB

SUB MouseHide
'
' Hides mouse cursor.
'
ax = 2
MouseDriver ax, 0, 0, 0
END SUB

FUNCTION MouseInit
'
' Detects if the mouse driver is loaded or if the mouse itself is present.
'
ax = 0
MouseDriver ax, 0, 0, 0
MouseInit = ax
END FUNCTION

SUB MousePut (x, y)
'
' Puts mouse cursor at x,y.
'
ax = 4
cx = x
dx = y
MouseDriver ax, 0, cx, dx
END SUB

SUB MouseRange (x1, y1, x2, y2)
'
' Sets mouse range between x1,y1 and x2,y2.
'
ax = 7
cx = x1
dx = x2
MouseDriver ax, 0, cx, dx
ax = 8
cx = y1
dx = y2
MouseDriver ax, 0, cx, dx
END SUB

SUB MouseShow
'
' Shows mouse cursor.
'
ax = 1
MouseDriver ax, 0, 0, 0
END SUB

SUB MouseStatus (Lb, Rb, x, y)
'
' Returns the status of the mouse
' xMouse,yMouse is where the mouse is,
' Lb,Rb are TRUE when left or right mouse button is pressed.
'
ax = 3
MouseDriver ax, bx, cx, dx
Lb = ((bx AND 1) <> 0)
Rb = ((bx AND 2) <> 0)
xMouse = cx
yMouse = dx
x = (xMouse \ 8) + 1
y = (yMouse \ 8) + 1
END SUB

FUNCTION PickSound (Text$)
'
' Allows to select between the available sounds and returns selected sound
' id number.
'
PCOPY 7, 0
PCOPY 0, 2
DrawWindow 23, 5, 57, 20, Col.Text, Col.BackText, Text$
LOCATE 6, 25: PRINT "Num  Name                 Ch"
IF NumSound < 13 THEN
  FOR i = 1 TO NumSound
    LOCATE 6 + i, 25
    IF i < 10 THEN s$ = "00" + LTRIM$(STR$(i)) ELSE s$ = "0" + LTRIM$(STR$(i))
    PRINT s$ + "  " + MID$(Snd(i), 31, 20) + " " + STR$(ASC(MID$(Snd(i), 1, 1)) - 175)
  NEXT i
ELSE
  FOR i = 1 TO 13
    LOCATE 6 + i, 25
    IF i < 10 THEN s$ = "00" + LTRIM$(STR$(i)) ELSE s$ = "0" + LTRIM$(STR$(i))
    PRINT s$ + "  " + MID$(Snd(i), 31, 20) + " " + STR$(ASC(MID$(Snd(i), 1, 1)) - 175)
  NEXT i
END IF
COLOR Col.Main, Col.BackMain
LOCATE 6, 55: PRINT CHR$(24)
LOCATE 19, 55: PRINT CHR$(25)
FOR i = 7 TO 18
  COLOR Col.Main, Col.BackMain
  LOCATE i, 55: PRINT CHR$(177)
  IF NumSound <= 13 THEN
    COLOR Col.Er, Col.BackEr
    LOCATE i, 55: PRINT CHR$(178)
  END IF
NEXT i
IF NumSound > 13 THEN LOCATE 7, 55: COLOR Col.Er, Col.BackEr: PRINT CHR$(178)
SoundPos = 0
PCOPY 0, 1
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 1, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    SELECT CASE x
    CASE 55
      SELECT CASE y
      CASE 6
        IF SoundPos > 0 THEN
          PCOPY 1, 0
          COLOR Col.Main, Col.BackMain
          LOCATE 7 + ((11 / (NumSound - 13)) * SoundPos), 55: PRINT CHR$(177)
          SoundPos = SoundPos - 1
          COLOR Col.Text, Col.BackText
          FOR i = 1 TO 13
            LOCATE 6 + i, 25
            IF i + SoundPos < 10 THEN s$ = "00" + LTRIM$(STR$(i + SoundPos)) ELSE IF i + SoundPos < 100 THEN s$ = "0" + LTRIM$(STR$(i + SoundPos)) ELSE s$ = LTRIM$(STR$(i + SoundPos))
            PRINT s$ + "  " + MID$(Snd(i + SoundPos), 31, 20) + " " + STR$(ASC(MID$(Snd(i + SoundPos), 1, 1)) - 175)
          NEXT i
          COLOR Col.Er, Col.BackEr
          LOCATE 7 + ((11 / (NumSound - 13)) * SoundPos), 55: PRINT CHR$(178)
          PCOPY 0, 1
          LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
          Delay .05
        END IF
      CASE 19
        IF SoundPos < NumSound - 13 THEN
          PCOPY 1, 0
          COLOR Col.Main, Col.BackMain
          LOCATE 7 + ((11 / (NumSound - 13)) * SoundPos), 55: PRINT CHR$(177)
          SoundPos = SoundPos + 1
          COLOR Col.Text, Col.BackText
          FOR i = 1 TO 13
            LOCATE 6 + i, 25
            IF i + SoundPos < 10 THEN s$ = "00" + LTRIM$(STR$(i + SoundPos)) ELSE IF i + SoundPos < 100 THEN s$ = "0" + LTRIM$(STR$(i + SoundPos)) ELSE s$ = LTRIM$(STR$(i + SoundPos))
            PRINT s$ + "  " + MID$(Snd(i + SoundPos), 31, 20) + " " + STR$(ASC(MID$(Snd(i + SoundPos), 1, 1)) - 175)
          NEXT i
          COLOR Col.Er, Col.BackEr
          LOCATE 7 + ((11 / (NumSound - 13)) * SoundPos), 55: PRINT CHR$(178)
          PCOPY 0, 1
          LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
          Delay .05
        END IF
      END SELECT
    CASE 24 TO 53
      IF y > 6 AND y < 20 THEN
        Pick = y - 6 + SoundPos
        IF Pick < 10 THEN s$ = "00" + LTRIM$(STR$(Pick)) ELSE IF Pick < 100 THEN s$ = "0" + LTRIM$(STR$(Pick)) ELSE s$ = LTRIM$(STR$(Pick))
        s$ = " " + s$ + "  " + MID$(Snd(Pick), 31, 20) + " " + STR$(ASC(MID$(Snd(Pick), 1, 1)) - 175)
        Hilight 24, y, Col.Text, Col.BackText, s$
        PickSound = Pick
        EXIT DO
      END IF
    END SELECT
  END IF
  k$ = INKEY$
  IF k$ = CHR$(27) THEN PickSound = 0: EXIT DO
LOOP

END FUNCTION

SUB PlayFX (Num)
'
' Plays specified FX num.
'
FOR i = 1 TO 15
  OUT &H388, ASC(MID$(Snd(Num), (i * 2) - 1, 1))
  FOR ii = 1 TO 6: temp = INP(&H388): NEXT ii
  OUT &H389, ASC(MID$(Snd(Num), (i * 2)))
  FOR ii = 1 TO 35: temp = INP(&H388): NEXT ii
NEXT i

END SUB

SUB PrintStat (x1, y1, Num)
'
' Prints a value placing a zero where aren't digits.
'
s$ = LTRIM$(STR$(Num))
IF LEN(s$) < 2 THEN s$ = "0" + s$
LOCATE y1, x1: PRINT s$

END SUB

FUNCTION ReadBit (Byte, Bit) STATIC
'
' Reads a bit from specified byte.
'
ReadBit = ABS(((2 ^ (Bit)) AND Byte) > 0)
END FUNCTION

FUNCTION ResetBit (Byte, Bit) STATIC
'
' Resets a bit of the specified byte.
'
ResetBit = Byte AND (255 - (2 ^ Bit))
END FUNCTION

FUNCTION RShift (Byte, Bits)
'
' Shifts right a number of n bits in specified byte.
'
RShift = Byte \ (2 ^ Bits)
END FUNCTION

SUB Save (File$)
'
' Saves File$ as a sound file.
'
OPEN File$ + "." + Ext FOR BINARY AS #1
IF LOF(1) <> 0 THEN
  CLOSE #1: KILL File$ + "." + Ext
  OPEN File$ + "." + Ext FOR BINARY AS #1
END IF
id$ = "SL10"
PUT #1, , id$
PUT #1, , NumSound
FOR i = 1 TO NumSound: PUT #1, , Snd(i): NEXT i
CLOSE #1

END SUB

FUNCTION SetBit (Byte, Bit) STATIC
'
' Sets a bit in the specified byte.
'
SetBit = Byte OR (2 ^ Bit)
END FUNCTION

SUB SetVol (Volume)
'
' Sets FM volume.
'
OUT BasePort + 4, &H22
OUT BasePort + 5, (Volume + Volume * 16) AND &HFF

END SUB

SUB ShowChStats
'
' Displays channel statistics
'
PCOPY 7, 0
DrawWindow 20, 8, 59, 20, Col.Text, Col.BackText, "Channels usage"
FOR i = 1 TO 9
  LOCATE 8 + i, 23: PRINT "Channel" + STR$(i) + " is being used";
  Times = 0
  FOR ii = 1 TO NumSound
    IF ASC(MID$(Snd(ii), 1, 1)) - 175 = i THEN Times = Times + 1
  NEXT ii
  PRINT STR$(Times) + " time(s)"
NEXT i
LOCATE 19, 37: PRINT "< OK >"
PCOPY 0, 4
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 4, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    IF y = 19 AND x > 36 AND x < 43 THEN EXIT DO
  END IF
LOOP
Hilight 37, 19, Col.Text, Col.BackText, "< OK >"

END SUB

SUB ShowInfo
'
' Shows informations about current sound file."
'
DrawWindow 19, 4, 61, 21, Col.Text, Col.BackText, "Info"
LOCATE 6, 22: PRINT "File name:          " + FileName$ + "." + Ext
LOCATE 7, 22: PRINT "Total file size:   " + STR$(6 + (50 * NumSound)) + " bytes"
LOCATE 9, 22: PRINT "Number of sounds:  " + STR$(NumSound)
LOCATE 10, 22: PRINT "Sounds available:  " + STR$(MaxSound - NumSound)
LOCATE 11, 22: PRINT "Channels used:      ";
First = TRUE
FOR i = 1 TO 9
  FOR ii = 1 TO NumSound
    IF ASC(MID$(Snd(ii), 1, 1)) - 175 = i THEN
      IF First THEN
        First = FALSE: PRINT LTRIM$(STR$(i));
      ELSE
        PRINT "," + LTRIM$(STR$(i));
      END IF
      EXIT FOR
    END IF
  NEXT ii
NEXT i
LOCATE 13, 22: PRINT "Memory available:  " + STR$(FRE(-1)) + " bytes"
LOCATE 15, 22: PRINT "A Sound Blaster compatible sound card"
LOCATE 16, 22: PRINT "was found at address " + HEX$(BasePort) + "H."
LOCATE 18, 22: PRINT "This program has started at: " + StartTime$
LOCATE 20, 37: PRINT "< OK >"
PCOPY 0, 3
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 3, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    IF y = 20 AND x > 36 AND x < 43 THEN EXIT DO
  END IF
LOOP
Hilight 37, 20, Col.Text, Col.BackText, "< OK >"

END SUB

SUB ShowRegs
'
' Displays registers values
'
PCOPY 7, 0
FXToCode
DrawWindow 35, 6, 44, 24, Col.Text, Col.BackText, "Regs"
FOR i = 1 TO 15
  LOCATE 6 + i, 37: PRINT HEX$(ChData(FX.Channel - 1, i)) + ": ";
  PRINT HEX$(ASC(MID$(Snd(CurSound), i * 2, 1)));
NEXT i
LOCATE 23, 37: PRINT "< OK >";
PCOPY 0, 4
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 4, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb THEN
    IF y = 23 AND x > 36 AND x < 43 THEN EXIT DO
  END IF
LOOP
Hilight 37, 23, Col.Text, Col.BackText, "< OK >"

END SUB

SUB Sort (A$(), Low, High)
'
' Quick sorts given array of strings.
'
IF Low < High THEN
  IF High - Low = 1 THEN
    IF A$(Low) > A$(High) THEN
      SWAP A$(Low), A$(High)
    END IF
  ELSE
    RANDOMIZE TIMER
    RandIndex = INT(RND(1) * (High - Low) + .5) + Low
    SWAP A$(High), A$(RandIndex)
    Partition$ = A$(High)
    DO
      i = Low: J = High
      DO WHILE (i < J) AND (A$(i) <= Partition$)
        i = i + 1
      LOOP
      DO WHILE (J > i) AND (A$(J) >= Partition$)
        J = J - 1
      LOOP
      IF i < J THEN
        SWAP A$(i), A$(J)
      END IF
    LOOP WHILE i < J
    SWAP A$(i), A$(High)
    IF (i - Low) < (High - i) THEN
      Sort A$(), Low, i - 1
      Sort A$(), i + 1, High
    ELSE
      Sort A$(), i + 1, High
      Sort A$(), Low, i - 1
    END IF
  END IF
END IF

END SUB

SUB Welcome
'
' Displays a welcome intro box.
'
TIMER OFF
PCOPY 0, 5
DrawWindow 15, 7, 64, 18, Col.Menu, Col.BackMenu, ""
LOCATE 8, 35: PRINT "QuickBasic"
LOCATE 9, 36: PRINT "SOUNDLAB"
LOCATE 11, 27: PRINT "Version 1.0 (C) April 1997"
LOCATE 12, 29: PRINT "by Angelo Mottola soft"
LOCATE 14, 18: PRINT "This program is freeware: this means you can"
LOCATE 15, 21: PRINT "use it every time you want. Enjoy it!!"
LOCATE 17, 37: PRINT "< OK >"
LOCATE 25, 1: PRINT SPACE$(80);
LOCATE 25, 3: PRINT "Welcome to SoundLab v1.0";
PCOPY 0, 7
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
DO
  MouseStatus Lb, Rb, x, y
  IF x <> Oldx OR y <> Oldy THEN
    Oldx = x: Oldy = y: PCOPY 7, 0
    COLOR 6, 0: LOCATE y, x: PRINT CHR$(219);
  END IF
  IF Lb AND y = 17 THEN
    IF x > 36 AND x < 43 THEN EXIT DO
  END IF
LOOP
Hilight 37, 17, Col.Menu, Col.BackMenu, "< OK >"
PCOPY 5, 0
PCOPY 0, 7
LOCATE y, x: COLOR 6, 0: PRINT CHR$(219);
Delay .2
TIMER ON

END SUB

