DECLARE SUB WriteReg (reg%, Value%)
DECLARE SUB MousePut ()
mouse.setup:
  DECLARE FUNCTION MouseInterr% (num%, ax%, bx%, cx%, dx%)
  DECLARE SUB MousePointer (OnOrOff$)
  DECLARE SUB MouseSpeed (Speed%)
  DECLARE SUB MouseSet (x%, y%)
  DECLARE SUB MouseArea (x1%, x2%, y1%, y2%)
  DECLARE SUB LoadConfiguration ()
  DECLARE SUB MouseDriver (ax%, bx%, cx%, dx%)
  DECLARE FUNCTION MouseInit% ()
  DECLARE SUB mouseshow ()
  DECLARE SUB mousestatus (lb%, RB%, Xmouse%, Ymouse%)
  DECLARE SUB MouseWait ()
  DIM SHARED mouse$
  RESTORE
  mouse$ = SPACE$(57)
  FOR i% = 1 TO 57
    READ a$
    H$ = CHR$(VAL("&H" + a$))
    MID$(mouse$, i%, 1) = H$
  NEXT i%
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00
  LoadConfiguration

  MS% = MouseInit%
  IF NOT MS% THEN
    PRINT "Mouse not found": LET AMOUSE$ = "NO":
  END IF
  PRINT "Mouse found and initialized": LET AMOUSE$ = "YES"
  mouseshow

vardef:
  'screen setup
    SCREEN 13
  'constant definitions
    CONST true = 1, false = 0
    CONST highlight = 4
    CONST BLUE = 65536, GREEN = 256, RED = 1
    CONST done.waiting = 3
  'dimension statements
    DIM SHARED start(0 TO 7, 0 TO 7)
    DIM SHARED square(0 TO 8, 0 TO 8)
    DIM SHARED inisquare(0 TO 7, 0 TO 7)
    DIM SHARED str(13) AS STRING
    DIM SHARED mover(200 * 20)
    DIM mouse%(0 TO 45)
    DIM SHARED xlength, ylength, header$, nowwait$, waitnow
    DIM SHARED points, t, m$, x, y, oldx, oldy, a, b, scl, xini, yini
  'minor initial variables
    scl = 20
    bwid = 90: bxmn = 3: bxmx = bxmn + bwid: bymn = 3: bymx = 196
    tox = (320 - bwid - (scl * 8)) / 2 + bwid + 5
    GOSUB pal.set

Setup:
  OPEN "chessdat.dat" FOR INPUT AS #2
    FOR g = 2 TO 13: INPUT #2, str(g): NEXT
    FOR b = 0 TO 7: FOR a = 0 TO 7
      INPUT #2, start(a, b)
    NEXT: NEXT
    FOR b = 0 TO 7: FOR a = 0 TO 7
      INPUT #2, square(a, b), inisquare(a, b)
    NEXT: NEXT
  CLOSE

restart: CLS : MousePointer "Off": header$ = "QB Chess: By Craig Parmer"
  FOR b = 0 TO 7: FOR a = 0 TO 7: square(a, b) = inisquare(a, b): NEXT: NEXT
  xini = (320 - (scl * 8)) / 2: yini = (200 - (scl * 8)) / 2
  GOSUB board.draw
  WHILE POINT(tox, 100) <> 0
    FOR m = 295 TO 16 STEP -20
      GET (m, 1)-(m + 19, 199), mover
      PUT (m + 1, 1), mover, PSET
    NEXT
  WEND: xini = tox + 1
  GOSUB boxes
  MousePointer "On": castle(1) = 0: castle(2) = 0

Main: MousePointer "On"
  WHILE m$ <> CHR$(27)
    RESTORE
    GOSUB prt.stats
    GOSUB get.key
    GOSUB mov.key
  WEND
END

prt.stats:
  COLOR 15: LOCATE 2, 2: PRINT "Status bar": PRINT
  LOCATE , 2: PRINT "Piece :": PRINT
  LOCATE , 4: IF piece <= 1 THEN PRINT "none   " ELSE PRINT pname$
  PRINT : LOCATE , 2: PRINT "Player "; player$
RETURN

get.key:
  WHILE INKEY$ <> "" OR m$ <> "" OR MouseB% <> 0: m$ = "": MouseB% = 0: MouseWait: WEND
  oldx = x: oldy = y: a = oldx: b = oldy: GOSUB load.pics
  WHILE m$ = "" AND MouseB% = 0
    DO: MouseWait
      GOSUB prt.headings
    LOOP WHILE MouseB% = 0 AND m$ = "": a = x: b = y: GOSUB load.pics
DATA.Mouse:
DATA 55,8b,ec,56,57,8b,76,0c,8b,04,8b,76,0a,8b,1c,8b,76,08,8b,0c,8b,76,06,8b
DATA 14,cd,21,8b,76,0c,89,04,8b,76,0a,89,1c,8b,76,08,89,0c,8b,76,06,89,14,5f
DATA 5e,5d,ca,08,00
    IF (MouseX% \ 2 - xini) \ 20 >= 0 AND (MouseX% \ 2 - xini) \ 20 <= 7 AND (MouseY% - yini) \ 20 >= 0 AND (MouseY% - yini) \ 20 <= 7 THEN
      x = (MouseX% \ 2 - xini) \ 20: y = (MouseY% - yini) \ 20
      IF square(oldx, oldy) \ 2 = square(oldx, oldy) / 2 THEN oldplayerno = 2 ELSE oldplayerno = 1
      IF square(x, y) \ 2 = square(x, y) / 2 THEN playerno = 2 ELSE playerno = 1
      IF square(oldx, oldy) <= 1 THEN oldplayerno = 0
      IF square(x, y) <= 1 THEN playerno = 0
      IF MouseB% = 2 AND playerno <> oldplayerno THEN
      sq = square(x, y): ReX = x: ReY = y
        SELECT CASE square(oldx, oldy)
          CASE 2: 'checks 2player pawn move legitimacy
                  IF sq > 1 AND sq \ 2 <> sq / 2 AND y = oldy + 1 AND ABS(x - oldx) = 1 THEN
                    IF y = 7 THEN piece = 12: square(x, y) = piece: a = x: b = y: GOSUB load.pics
                    RETURN
                  END IF
                  SELECT CASE oldy
                    CASE 1: IF NOT ((y = oldy + 2 OR y = oldy + 1) AND x = oldx) THEN x = oldx: y = oldy: buzz = true
                    CASE 0, 2, 3, 4, 5, 6, 7: IF NOT (y = oldy + 1 AND x = oldx) THEN x = oldx: y = oldy: buzz = true
                  END SELECT
                  IF y <> oldy THEN
                    FOR chk.y = oldy TO y STEP (ABS(y - oldy) / (y - oldy))
                      IF square(x, chk.y) > 1 AND square(x, chk.y) <> square(oldx, oldy) THEN y = oldy: x = oldx: buzz = true
                    NEXT
                  END IF
                  IF y = 7 THEN piece = 12: square(x, y) = piece: a = x: b = y: GOSUB load.pics
          ' 'AND ((square(x, 5) = 0 AND y = 5) OR ((square(x, 5) = 0) AND (square(x, 4) = 0) AND y = 4))
          ' 'AND ((square(x, 2) = 0 AND y = 2) OR ((square(x, 2) = 0) AND (square(x, 3) = 0) AND y = 3))
          CASE 3: 'checks 1player pawn move legitimacy
                  IF sq > 1 AND sq \ 2 = sq / 2 AND y = oldy - 1 AND ABS(x - oldx) = 1 THEN
                    IF y = 0 THEN piece = 13: square(x, y) = piece: a = x: b = y: GOSUB load.pics
                    RETURN
                  END IF
                  SELECT CASE oldy
                    CASE 6: IF NOT ((y = oldy - 2 OR y = oldy - 1) AND x = oldx) THEN x = oldx: y = oldy: buzz = true
                    CASE 0, 1, 2, 3, 4, 5, 7: IF NOT (y = oldy - 1 AND x = oldx) THEN x = oldx: y = oldy: buzz = true
                  END SELECT
                  IF y <> oldy THEN
                    FOR chk.y = oldy TO y STEP (ABS(y - oldy) / (y - oldy))
                      IF square(x, chk.y) > 1 AND square(x, chk.y) <> square(oldx, oldy) THEN y = oldy: x = oldx: buzz = true
                    NEXT
                  END IF
                  IF y = 0 THEN piece = 13: square(x, y) = piece: a = x: b = y: GOSUB load.pics
          CASE 4, 5: 'checks knight move legitimacy
                     IF NOT ((ABS(x - oldx) = 2 AND ABS(y - oldy) = 1) OR (ABS(x - oldx) = 1 AND ABS(y - oldy) = 2)) THEN x = oldx: y = oldy: buzz = true
          CASE 6, 7: 'checks bishop move legitimacy
                     IF NOT (ABS(x - oldx) = ABS(y - oldy)) THEN x = oldx: y = oldy: buzz = true
                       IF ReY <> oldy AND ReX <> oldx THEN
                         chk.x = oldx: FOR chk.y = oldy TO ReY STEP (ABS(ReY - oldy) / (ReY - oldy))
                           IF chk.y <> oldy THEN chk.x = chk.x + ((ABS(ReX - oldx) / (ReX - oldx)))
                           IF square(chk.x, chk.y) > 1 AND square(chk.x, chk.y) <> square(oldx, oldy) AND (chk.x <> ReX AND chk.y <> ReY) THEN y = oldy: x = oldx: buzz = true
                         NEXT
                       END IF
          CASE 8, 9: 'checks rook move legitimacy
                     IF NOT (x = oldx OR y = oldy) THEN x = oldx: y = oldy: buzz = true
                     IF y <> oldy THEN
                       FOR chk.y = oldy TO y STEP (ABS(y - oldy) / (y - oldy))
                         IF square(x, chk.y) > 1 AND square(x, chk.y) <> square(oldx, oldy) AND chk.y <> y THEN y = oldy: x = oldx: buzz = true
                       NEXT
                     END IF
                     IF x <> oldx THEN
                       FOR chk.x = oldx TO x STEP (ABS(x - oldx) / (x - oldx))
                         IF square(chk.x, y) > 1 AND square(chk.x, y) <> square(oldx, oldy) AND chk.x <> x THEN y = oldy: x = oldx: buzz = true
                       NEXT
                     END IF
          CASE 10, 11: 'checks king move legitimacy
                     IF NOT (ABS(x - oldx) <= 1 AND ABS(y - oldy) <= 1) THEN x = oldx: y = oldy: buzz = true
                     IF oldy = ReY AND (ReX = 1 OR ReX = 6) AND square(ReX, ReY) <= 1 THEN GOSUB castle
          CASE 12, 13: 'checks queen move legitimacy
                     IF NOT (ABS(x - oldx) = ABS(y - oldy)) AND NOT (x = oldx OR y = oldy) THEN x = oldx: y = oldy: buzz = true
                     IF x = oldx OR y = oldy THEN
                       IF y <> oldy THEN
                         FOR chk.y = oldy TO y STEP (ABS(y - oldy) / (y - oldy))
                           IF square(x, chk.y) > 1 AND square(x, chk.y) <> square(oldx, oldy) AND chk.y <> y THEN y = oldy: x = oldx: buzz = true
                         NEXT
                       END IF
                       IF x <> oldx THEN
                         FOR chk.x = oldx TO x STEP (ABS(x - oldx) / (x - oldx))
                           IF square(chk.x, y) > 1 AND square(chk.x, y) <> square(oldx, oldy) AND chk.x <> x THEN y = oldy: x = oldx: buzz = true
                         NEXT
                       END IF
                     ELSE
                       IF ReY <> oldy AND ReX <> oldx THEN
                         chk.x = oldx: FOR chk.y = oldy TO ReY STEP (ABS(ReY - oldy) / (ReY - oldy))
                           IF chk.y <> oldy THEN chk.x = chk.x + ((ABS(ReX - oldx) / (ReX - oldx)))
                           IF square(chk.x, chk.y) > 1 AND square(chk.x, chk.y) <> square(oldx, oldy) AND (chk.x <> ReX AND chk.y <> ReY) THEN y = oldy: x = oldx: buzz = true
                         NEXT
                       END IF
                     END IF
        END SELECT
        IF buzz = 1 THEN GOSUB buzz
      ELSE IF playerno = oldplayerno AND MouseB% = 2 THEN x = oldx: y = oldy: GOSUB buzz
      END IF
    END IF
    'SELECT CASE MouseX% \ 2
    '  CASE 20 TO 40
    '    SELECT CASE MouseY%
    '      CASE 80 TO 100: a = 8: b = 8:
    '      CASE 115 TO 135:
    '      CASE 150 TO 170:
    '    END SELECT
    '  CASE 55 TO 75
    '    SELECT CASE MouseY%
    '      CASE 80 TO 100:
    '      CASE 115 TO 135:
    '      CASE 150 TO 170:
    '    END SELECT
    'END SELECT
  WEND
RETURN

castle:
  IF castle(square(oldx, oldy) - 9) = 0 THEN
    WHILE m$ <> "y" AND m$ <> "n"
      header$ = "      Castle (Y/N)       "
      waitnow = 0: m$ = LCASE$(INKEY$)
      GOSUB prt.headings
    WEND
    IF m$ = "y" THEN x = ReX: y = ReY: buzz = false: castle(square(oldx, oldy) - 9) = 1
  END IF
RETURN

mov.key:
  a = oldx: b = oldy: GOSUB load.pics
  IF MouseB% = 1 THEN m$ = "5" ELSE IF MouseB% = 2 THEN m$ = CHR$(13)
  IF MouseB% <> 0 THEN MouseX% = 100: MouseY% = 100
  SELECT CASE m$
    CASE "5", "q": IF square(x, y) > 1 THEN piece = square(x, y): oldx = x: oldy = y: a = x: b = y: GOSUB get.name ELSE m$ = ""
    CASE CHR$(13), "e":
       IF x <> oldx OR y <> oldy AND piece > 1 THEN square(x, y) = piece: square(oldx, oldy) = start(oldx, oldy): GOSUB board.draw: 'piece = 0: pname$ = "         ": player$ = " "
    CASE "5", "q", "e", CHR$(13): GOSUB load.pics
    CASE "n": GOTO restart
  END SELECT
  IF x < 0 THEN x = 7 ELSE IF x > 7 THEN x = 0
  IF y < 0 THEN y = 7 ELSE IF y > 7 THEN y = 0
RETURN

load.pics:
  file$ = "": GOSUB get.name
  IF square(a, b) > 1 AND start(a, b) = 1 THEN file$ = file$ + "1" ELSE IF square(a, b) > 1 AND start(a, b) = 0 THEN file$ = file$ + "0"
  CLOSE : OPEN file$ + ".tpc" FOR INPUT AS #1: INPUT #1, scn, Xmin, Xmax, Ymin, Ymax: CLOSE
  REDIM colr(1 TO (Xmax - Xmin) * (Ymax - Ymin))
  DEF SEG = VARSEG(colr(1)): BLOAD file$ + ".PIC", VARPTR(colr(1)): DEF SEG : CLOSE
  PUT (a * scl + xini, b * scl + yini), colr, PSET
RETURN

get.name:
  SELECT CASE square(a, b)
    CASE 0: file$ = "bsq"
    CASE 1: file$ = "wsq"
    CASE 2: file$ = "pawn2"
    CASE 3: file$ = "pawn1"
    CASE 4: file$ = "knight2"
    CASE 5: file$ = "knight1"
    CASE 6: file$ = "bishop2"
    CASE 7: file$ = "bishop1"
    CASE 8: file$ = "rook2"
    CASE 9: file$ = "rook1"
    CASE 10: file$ = "king2"
    CASE 11: file$ = "king1"
    CASE 12: file$ = "queen2"
    CASE 13: file$ = "queen1"
  END SELECT
  IF m$ = "5" OR m$ = "q" THEN pname$ = LEFT$(file$, LEN(file$) - 1): player$ = RIGHT$(file$, 1)
  WHILE LEN(pname$) < 8: pname$ = pname$ + " ": WEND
RETURN

buzz: header$ = "   You can't do that!    "
  nowwait$ = TIME$: waitnow = 0: GOSUB prt.headings
  FOR reg% = 15 TO 215 STEP 10
    Value% = reg%: freq% = reg%
    GOSUB sound.out
  NEXT reg%
  buzz = false: reg% = 0: Value% = reg%: freq% = reg%
  GOSUB sound.out
RETURN

sound.out:
  CALL WriteReg(&H20, &H7)
  CALL WriteReg(&H40, &HF)
  CALL WriteReg(&H60, &HF0)
  CALL WriteReg(&H80, &HF0)
  CALL WriteReg(&HA0, freq%)
  CALL WriteReg(&H23, &HF)
  CALL WriteReg(&H43, &H0)
  CALL WriteReg(&H63, &HF0)
  CALL WriteReg(&H83, &HFF)
  CALL WriteReg(&HB0, &H20)
  CALL WriteReg(&HE0, &H0)
RETURN

boxes:
  FOR l = 2 TO -2 STEP -1
    LINE (bxmn - l, bymn - l)-(bxmx + l, bymx + l), 25 - ABS(l * 3), B
  NEXT
  file$ = "pawn": GOSUB smallload: PUT (20, 80), colr, PSET
  file$ = "knight": GOSUB smallload: PUT (55, 80), colr, PSET
  file$ = "bishop": GOSUB smallload: PUT (20, 115), colr, PSET
  file$ = "rook": GOSUB smallload: PUT (55, 115), colr, PSET
  file$ = "queen": GOSUB smallload: PUT (20, 150), colr, PSET
  file$ = "king": GOSUB smallload: PUT (55, 150), colr, PSET
RETURN

smallload:
  CLOSE : OPEN file$ + ".tpc" FOR INPUT AS #1: INPUT #1, scn, Xmin, Xmax, Ymin, Ymax: CLOSE
  REDIM colr(1 TO (Xmax - Xmin) * (Ymax - Ymin))
  DEF SEG = VARSEG(colr(1)): BLOAD file$ + ".PIC", VARPTR(colr(1)): DEF SEG : CLOSE
RETURN

prt.headings:
  IF nowwait$ <> TIME$ THEN waitnow = waitnow + 1
  IF waitnow >= done.waiting THEN header$ = "QB Chess: By Craig Parmer"
  COLOR 20: LOCATE 1, 14 + (27 - LEN(header$)) \ 2: PRINT header$;
  COLOR 20: LOCATE 24, 20: PRINT "Hit Esc to exit.";
RETURN

board.draw:
  FOR a = 0 TO 7: FOR b = 0 TO 7: file$ = ""
    GOSUB load.pics
  NEXT: NEXT
RETURN

pal.set: PALETTE
  'FOR g = 66 TO 81: PALETTE g, ((81 - g) * 4) * 65536 +  ((81 - g) * 4) * 256 + ((81 - g) * 4): NEXT
  FOR g = 66 TO 81: PALETTE g, (((g - 66) * 3) + 10) * RED: NEXT
  FOR g = 100 TO 150: PALETTE g, (g - 100) * 65536 + (g - 100) * 256 + (g - 100): NEXT
RETURN

border.line:
  LINE (x * scl + xini, y * scl + yini)-(x * scl + xini + 19, y * scl + yini + 19), highlight, B
RETURN

w:
COLOR 4: LOCATE 5, 1: PRINT chk.x; chk.y; oldx; oldy; x; y
END
RESUME

SUB LoadConfiguration
  SHARED mouse%()
  RESTORE DATA.Mouse
  DEF SEG = VARSEG(mouse%(0))
  FOR i% = 0 TO 52
    READ Byte$
    POKE VARPTR(mouse%(0)) + i%, VAL("&H" + Byte$)
  NEXT
  MouseArea 1, 319, 1, 199
  MouseSpeed 30
  MouseSet 200, 100
  MousePointer "On"
END SUB

SUB MouseArea (x1%, x2%, y1%, y2%)
  R% = MouseInterr%(&H33, 7, 0, x1%, x2%)
  R% = MouseInterr%(&H33, 8, bx%, y1%, y2%)
END SUB

SUB MouseDriver (ax%, bx%, cx%, dx%)
  DEF SEG = VARSEG(mouse$)
  mouse% = SADD(mouse$)
  CALL ABSOLUTE(ax%, bx%, cx%, dx%, mouse%)
END SUB

SUB MouseHide
  ax% = 2
  MouseDriver ax%, 0, 0, 0
END SUB

FUNCTION MouseInit%
  ax% = 0
  MouseDriver ax%, 0, 0, 0
  MouseInit% = ax%
END FUNCTION

FUNCTION MouseInterr% (num%, ax%, bx%, cx%, dx%)
  SHARED mouse%()
  IF mouse%(0) = 0 THEN
    PRINT "Mouse error, program stopped"
    SYSTEM
  END IF
  DEF SEG = VARSEG(mouse%(0))
  POKE VARPTR(mouse%(0)) + 26, num%
  CALL ABSOLUTE(ax%, bx%, cx%, dx%, VARPTR(mouse%(0)))
  MouseInterr% = ax%
END FUNCTION

SUB MousePointer (OnOrOff$)
  SELECT CASE OnOrOff$
    CASE "On": R% = MouseInterr%(&H33, 1, bx%, cx%, dx%)
    CASE "Off": R% = MouseInterr%(&H33, 2, bx%, cx%, dx%)
  END SELECT
END SUB

SUB MousePut
  ax% = 4
  cx% = x%
  dx% = y%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseSet (x%, y%)
  R% = MouseInterr%(&H33, 4, bx%, x%, y%)
END SUB

SUB mouseshow
  ax% = 1
  MouseDriver ax%, 0, 0, 0
END SUB

SUB MouseSpeed (Speed%)
  'Speed 0 = extremly fast, Speed 100 = extremly slow
  R% = MouseInterr%(&H33, 15, bx%, Speed%, Speed% * 2)
END SUB

SUB mousestatus (lb%, RB%, Xmouse%, Ymouse%)
  ax% = 3
  MouseDriver ax%, bx%, cx%, dx%
  lb% = ((bx% AND 1) <> 0)
  RB% = ((bx% AND 2) <> 0)
  Xmouse% = cx%
  Ymouse% = dx%
END SUB

SUB MouseWait
  SHARED MouseX%, MouseY%, MouseB%, m$
  OldMX% = MouseX%
  OldMY% = MouseY%
  OldMB% = MouseB%
  WHILE (OldMX% = MouseX% AND OldMY% = MouseY% AND OldMB% = MouseB%) AND m$ = ""
    m$ = LCASE$(INKEY$)
    R% = MouseInterr%(&H33, 3, MouseB%, MouseX%, MouseY%)
    a = oldx: b = oldy: GOSUB load.pics2
    a = x: b = y: GOSUB load.pics2
    GOSUB prt.headings.2
  WEND
GOTO end.sub.mw

load.pics2:
  file$ = "": GOSUB get.name2
  IF square(a, b) > 1 AND start(a, b) = 1 THEN file$ = file$ + "1" ELSE IF square(a, b) > 1 AND start(a, b) = 0 THEN file$ = file$ + "0"
  CLOSE : OPEN file$ + ".tpc" FOR INPUT AS #1: INPUT #1, scn, Xmin, Xmax, Ymin, Ymax: CLOSE
  REDIM colr(1 TO (Xmax - Xmin) * (Ymax - Ymin))
  DEF SEG = VARSEG(colr(1)): BLOAD file$ + ".PIC", VARPTR(colr(1)): DEF SEG : CLOSE
  PUT (a * scl + xini, b * scl + yini), colr, PSET
RETURN

get.name2:
  SELECT CASE square(a, b)
    CASE 0: file$ = "bsq"
    CASE 1: file$ = "wsq"
    CASE 2: file$ = "pawn2"
    CASE 3: file$ = "pawn1"
    CASE 4: file$ = "knight2"
    CASE 5: file$ = "knight1"
    CASE 6: file$ = "bishop2"
    CASE 7: file$ = "bishop1"
    CASE 8: file$ = "rook2"
    CASE 9: file$ = "rook1"
    CASE 10: file$ = "king2"
    CASE 11: file$ = "king1"
    CASE 12: file$ = "queen2"
    CASE 13: file$ = "queen1"
  END SELECT
  IF m$ = "5" OR m$ = "q" THEN pname$ = LEFT$(file$, LEN(file$) - 1): player$ = RIGHT$(file$, 1)
  WHILE LEN(pname$) < 8: pname$ = pname$ + " ": WEND
RETURN

prt.headings.2:
  IF nowwait$ <> TIME$ THEN waitnow = waitnow + 1
  IF waitnow >= done.waiting THEN header$ = "QB Chess: By Craig Parmer"
  COLOR 20: LOCATE 1, 14 + (27 - LEN(header$)) \ 2: PRINT header$;
  COLOR 20: LOCATE 24, 20: PRINT "Hit Esc to exit.";
RETURN

end.sub.mw:
END SUB

SUB WriteReg (reg%, Value%)
  OUT &H388, reg%
  FOR gox = 0 TO 5
    a = INP(&H388)
  NEXT gox
  OUT &H389, Value%
  FOR gox = 0 TO 34
    a = INP(&H388)
  NEXT gox
END SUB

