'===================[ GEMS v1.0 Programmed by William Yu ]====================
'
'      Release:  GEMS Version 1.0 by William Yu  (04-10-98)
'       Status:  100% Public Domain, sell it and get sued if you want
'      Credits:  Thanks to Phillip Jay Cohen for his OFONT routine.
'      Contact:  e-mail: voxel@freenet.edmonton.ab.ca
'
'  Description:  A Columns(TM) like game.
'                It's similar to Tetris (ie. one player, strategy, addictive)
'
'       Design:  I ripped the graphics from the original Sega(TM) classic.
'                If they sue, so be it.  Concept, play, etc. were mostly
'                reproduced, with a few exceptions.  Background graphics
'                were taken without permission and stripped of all its good
'                colours.  Why do I not feel guilty?  };-)
'
'Documentation:  Possible changes include Field Width/Height, Gem shapes,
'                Game keys, and number of matches.  Please check the CONST
'                fields on how.  I can't explain all the features, you'll
'                just have to play to find them out.
'                As for the code, it's ugly and inefficient in most parts,
'                but I've never experienced any lag on my 386/16, so it
'                should be good enough.  Since GemHeight = 15, this caused
'                the code to become ... quite lewd in some parts.
'                I'm not impressed with the Match routine, as it's no
'                doubt inefficient, but very basic, if that's any advantage.
'                Possible improvments should go there, as well as a spiffy
'                clearing of the gem routine.  My original idea was to fade
'                the gems out, but figured it was too much trouble.
'                To do this, it's better to have your own set of gems, so
'                you actually know the colours you're using!
'
' GamePlay:
'       Object:  To stack columns and align vertically, horizontally, or
'                diagonally to form a line of matching gems.
'
'     Controls:  Keyboard, or joystick.  Keyboard recommended on slow machines.
'                Configurable (Speed Down, Drop, Rotate, Move Left, Move Right)
'
'  How to Play:  You control the columns that slowly descend from above
'                Rotate, move, or drop them on to the playing field so that
'                you align the columns to form a line of matching gems.
'
'----------------------------------------------------------------------------

DEFINT A-Z
'$DYNAMIC
DECLARE SUB EliminateGem (Gems() AS INTEGER, Grid() AS INTEGER, Column AS ANY, ElimGem AS INTEGER)
DECLARE SUB RemoveGems (Gems() AS INTEGER, Grid() AS INTEGER, TempGrid() AS INTEGER)
DECLARE SUB Delay (Seconds AS SINGLE)
DECLARE SUB ConstructColumn (Column AS ANY)
DECLARE SUB UpdateDispColumn (Gems() AS INTEGER, Column AS ANY)
DECLARE SUB DisplayColumn (Gems() AS INTEGER, Column AS ANY)
DECLARE SUB LoadGemsFromFile (FileName$, Gems() AS INTEGER)
DECLARE SUB LoadBackGround (FileName$, BackGrnd() AS INTEGER)
DECLARE FUNCTION MatchDiagonal% (Grid() AS INTEGER, TempGrid() AS INTEGER, GridX AS INTEGER, GridY AS INTEGER)
DECLARE FUNCTION MatchHorizontal% (Grid() AS INTEGER, TempGrid() AS INTEGER, GridX AS INTEGER, GridY AS INTEGER)
DECLARE FUNCTION MatchVertical% (Grid() AS INTEGER, TempGrid() AS INTEGER, GridX AS INTEGER, GridY AS INTEGER)
DECLARE SUB CheckForMatch (Gems() AS INTEGER, Grid() AS INTEGER, GridX AS INTEGER, GridY AS INTEGER)
DECLARE SUB InitField (Grid() AS INTEGER)
DECLARE SUB DisplayBackGround (BackGrnd() AS INTEGER)
DECLARE SUB OFont (Text$, X%, Y%, Fore%, Back%)

CONST False = 0
CONST True = NOT False

'' Game Keys, modify as you wish
CONST UseJoyStick = False
CONST RotateTop = -72             '' Up arrow
CONST RotateBottom = 64           '' You know the drill
CONST MoveLeft = -75              '' Left arrow
CONST MoveRight = -77             '' Right arrow
CONST SpeedDown = -80             '' Down arrow
CONST DropDown = 32               '' Space bar
CONST Quit = 27                   '' ESC key

'' Here are the offsets for each gem, you can design your own and modify
'' these constants to suit you.
CONST BASEOfs = 70                '' Each half represents 70 (*2) bytes
CONST RedOffset = 0               '' Start of upper Red gem
CONST BlueOffset = 2 * BASEOfs    '' Start of upper Blue gem
CONST OrangeOffset = 4 * BASEOfs  '' :
CONST GreenOffset = 6 * BASEOfs   '' :
CONST YellowOffset = 8 * BASEOfs  '' :
CONST PurpleOffset = 10 * BASEOfs '' Lower half = _Color_Offset + BASEOfs
CONST MagicOffset = 12 * BASEOfs  '' My own creation!!!  Truly amazing!

CONST MagicProb = 4               '' Out of a hundred
                                  '' Try not to use single precision unless you want to upset QB
                                  '' However, under PDS, it works fine... weird.
                                  '' Just in case, use DEFSNG A-Z for ConstructColumn

'' These can also be modified to your liking, but it's not idiot proof
CONST StartX = 145, StartY = 1        '' Position of playing field
CONST NumFieldX = 6, NumFieldY = 13   '' Number of fields on grid
CONST BaseScore = 100

'' Better to leave these as is.
CONST GemWidth = 16, GemHeight = 15
CONST NumGems = 7
CONST Pit = NumFieldY * GemHeight

TYPE ColumnType          '' Each column can store 3 gems, unless you want more...
  Gem1 AS INTEGER        '' Will store offset of gem
  Gem2 AS INTEGER
  Gem3 AS INTEGER
  GridX AS INTEGER       '' Stores current position relative to array Grid
  GridY AS INTEGER
  PosX AS INTEGER        '' Stores current position relative to screen
  PosY AS SINGLE         '' Due to the fact that GemHeight = 15, an oddity
  Half AS INTEGER        '' Currently displayed gem
END TYPE

OPTION BASE 1
DIM Gems(0 TO BASEOfs * 2 * NumGems) AS INTEGER   '' 6 gems to allocate memory for
DIM BackGrnd(515) AS INTEGER                      '' Memory for background image
DIM Grid(-2 TO NumFieldY + 1, NumFieldX) AS INTEGER   '' Weird looking eh?
DIM Column AS ColumnType
DIM NextColumn AS ColumnType
DIM DropDelay AS SINGLE, Speed AS SINGLE, SpeedInc AS SINGLE
DIM GemInc AS SINGLE
DIM SHARED Score AS LONG
DIM SHARED Level AS INTEGER
DIM SHARED BaseGems AS INTEGER, GemsLeft AS INTEGER
DIM SHARED PrimColor AS INTEGER, SecColor AS INTEGER

Score = 0
Level = 0
BaseGems = 20         '' Need to eliminate so many gems
GemsLeft = BaseGems   '' Varies between levels
GemInc = 1.3          '' Gem multiplication factor (BaseGems * GemInc)
                      '' Determines number of gems needed to pass a level
Speed = .5            '' Initial drop delay (half a second)
SpeedInc = .05        '' Speed increment factor (level 10 is about the end)
                      '' if you choose .02 then level 25 is about the end

'' Check MAKEGEMS.BAS to supply your own custom gems
LoadGemsFromFile "GEMS.IMG", Gems()      '' Supply correct path if necessary
LoadBackGround "BITMAP.IMG", BackGrnd()  '' Cheesy background

SCREEN 13
DisplayBackGround BackGrnd()
InitField Grid()               '' Call after every game to re-initialize grid

LINE (StartX - 1, StartY)-(StartX + NumFieldX * GemWidth, StartY + GemHeight * NumFieldY - 1), 0, BF

DropDelay = TIMER + Speed
ConstructColumn Column
ConstructColumn NextColumn
UpdateDispColumn Gems(), Column

IF UseJoyStick THEN
  InitJoyX% = STICK(0)
  InitJoyY% = STICK(1)
  JoyDelay! = .1
  JD! = TIMER + JoyDelay!
END IF

'' Game Loop, no going back from here
DO
  Char = 0
  DO
    A$ = INKEY$
    IF UseJoyStick THEN              '' You can still use the keyboard
      JoyX% = STICK(0)
      JoyY% = STICK(1)
      IF STRIG(1) THEN
        Char = RotateTop: EXIT DO
      ELSEIF STRIG(5) THEN
        Char = RotateBottom: EXIT DO
      ELSEIF (TIMER - JD!) >= 0 THEN
        IF JoyX% - 30 > InitJoyX% THEN
          JD! = TIMER + JoyDelay!
          Char = MoveRight: EXIT DO
        ELSEIF JoyX% + 30 < InitJoyX% THEN
          JD! = TIMER + JoyDelay!
          Char = MoveLeft: EXIT DO
        ELSEIF JoyY% - 30 > InitJoyY% THEN
          JD! = TIMER + JoyDelay! - .05
          Char = SpeedDown: EXIT DO
        END IF
      END IF
    END IF
    IF TIMER >= DropDelay THEN GOSUB DropGem
  LOOP UNTIL LEN(A$)
  IF (Char = 0) THEN
    IF (LEN(A$) = 2) THEN Char = -ASC(RIGHT$(A$, 1)) ELSE Char = ASC(A$)
  END IF

  SELECT CASE Char
    CASE RotateTop                    ''      <--+
      SWAP Column.Gem1, Column.Gem2   ''  Gem1   |
      SWAP Column.Gem2, Column.Gem3   ''  Gem2   |
      DisplayColumn Gems(), Column    ''  Gem3 --+
      IF Column.GridY <= 2 THEN UpdateDispColumn Gems(), Column
    CASE RotateBottom
      SWAP Column.Gem3, Column.Gem2   '' Reverse of RotateTop
      SWAP Column.Gem2, Column.Gem1   '' In other words, top goes to bottom
      DisplayColumn Gems(), Column
      IF Column.GridY <= 2 THEN UpdateDispColumn Gems(), Column
    CASE MoveLeft AND Column.GridX > 1
      '' Messy routine that checks for blocks in the way of the column
      Proceed = False
      IF Grid(Column.GridY, Column.GridX - 1) = -1 THEN Proceed = True
      IF Column.Half = True AND Proceed THEN
        IF Grid(Column.GridY + 1, Column.GridX - 1) = -1 THEN Proceed = True ELSE Proceed = False
      END IF
      IF Proceed THEN
        LINE (Column.PosX, Column.PosY - 1)-(Column.PosX + GemWidth - 1, Column.PosY - (4 * GemHeight)), 0, BF
        Column.PosX = Column.PosX - GemWidth
        Column.GridX = Column.GridX - 1
        DisplayColumn Gems(), Column
      END IF
    CASE MoveRight AND Column.GridX < NumFieldX
      '' Messy routine that checks for blocks in the way of the column
      Proceed = False
      IF Grid(Column.GridY, Column.GridX + 1) = -1 THEN Proceed = True
      IF Column.Half = True AND Proceed THEN
        IF Grid(Column.GridY + 1, Column.GridX + 1) = -1 THEN Proceed = True ELSE Proceed = False
      END IF
      IF Proceed THEN
        LINE (Column.PosX, Column.PosY - 1)-(Column.PosX + GemWidth - 1, Column.PosY - (4 * GemHeight)), 0, BF
        Column.PosX = Column.PosX + GemWidth
        Column.GridX = Column.GridX + 1
        DisplayColumn Gems(), Column
      END IF
    CASE SpeedDown
      GOSUB DropGem
    CASE DropDown
      DO
        GOSUB DropGem
      LOOP UNTIL Column.PosY = StartY
    CASE Quit
      END
  END SELECT
  IF UseJoyStick THEN
    WHILE STRIG(1) OR STRIG(5)
      IF TIMER >= DropDelay THEN GOSUB DropGem
    WEND
  END IF
LOOP

DropGem:
  IF Column.PosY < Pit AND Grid(Column.GridY + 1, Column.GridX) = -1 THEN
    '' Column hasn't hit anything yet
    Column.PosY = Column.PosY + 7.5       '' Half of GemHeight (15)
    IF Column.Half = True THEN
      Column.GridY = Column.GridY + 1     '' Complete gem in grid
      Column.Half = False
    ELSE
      Column.Half = True
    END IF
  ELSE
    '' Column has hit a deadend.
    IF Column.Gem1 = 6 * 140 THEN   '' The magic gem!
      LINE (Column.PosX, Column.PosY - 1)-(Column.PosX + GemWidth - 1, Column.PosY - (4 * GemHeight)), 0, BF
      IF Column.GridY + 1 < NumFieldY + 1 THEN
        ElimGem = Grid(Column.GridY + 1, Column.GridX)
        EliminateGem Gems(), Grid(), Column, ElimGem
      END IF
    ELSE
      IF (Column.GridY - 2) < 1 THEN        '' Column extends beyond screen
        Grid(Column.GridY - 2, Column.GridX) = Column.Gem1
        Grid(Column.GridY - 1, Column.GridX) = Column.Gem2
        Grid(Column.GridY, Column.GridX) = Column.Gem3
        CheckForMatch Gems(), Grid(), Column.GridX, 1
        IF Grid(-2, Column.GridX) + Grid(-1, Column.GridX) + Grid(0, Column.GridX) <> -3 THEN
           LOCATE 1, 1: PRINT "YOU LOSE!": END
        ELSE
          '' Since the column extended beyond the visible screen, the gems hidden
          '' need to be displayed.
          PosX = StartX + ((Column.GridX - 1) * GemWidth)
          FOR I = 1 TO NumFieldY
            IF Grid(I, Column.GridX) >= 0 THEN
              PosY = StartY + ((I - 1) * GemHeight)
              PUT (PosX, PosY), Gems(Grid(I, Column.GridX)), PSET
              PUT (PosX, PosY + 7), Gems(Grid(I, Column.GridX) + BASEOfs), PSET
            END IF
          NEXT I
        END IF
      ELSE
        Grid(Column.GridY - 2, Column.GridX) = Column.Gem1
        Grid(Column.GridY - 1, Column.GridX) = Column.Gem2
        Grid(Column.GridY, Column.GridX) = Column.Gem3
        CheckForMatch Gems(), Grid(), Column.GridX, Column.GridY - 2
      END IF
    END IF
    IF GemsLeft < 1 THEN
      BaseGems = BaseGems * GemInc
      GemsLeft = GemsLeft + BaseGems
      Level = Level + 1
      Speed = Speed - SpeedInc
    END IF
    GemLeft$ = LTRIM$(RTRIM$(STR$(GemsLeft)))
    GemLeft$ = SPACE$(6 - LEN(GemLeft$)) + GemLeft$
    LINE (71, 119)-(125, 135), 0, BF
    OFont GemLeft$, 75, 123, 15, 8
    NLevel$ = LTRIM$(RTRIM$(STR$(Level)))
    NLevel$ = SPACE$(6 - LEN(NLevel$)) + NLevel$
    LINE (71, 147)-(125, 163), 0, BF
    OFont NLevel$, 75, 151, 15, 8
    Column = NextColumn              '' Makes a copy of the structure
    ConstructColumn NextColumn
    DisplayColumn Gems(), Column     '' Display current column on playing field
    UpdateDispColumn Gems(), Column  '' Display it on the next field
    DO: LOOP UNTIL INKEY$ = ""       '' Clear keyboard buffer
  END IF
  LINE (Column.PosX, Column.PosY - 1)-(Column.PosX + GemWidth - 1, Column.PosY - (4 * GemHeight)), 0, BF
  DisplayColumn Gems(), Column  '' Display current column on playing field
  IF Column.GridY >= 3 THEN     '' Position Next Column on screen
    NextColumn.PosX = 92
    NextColumn.PosY = 71
    DisplayColumn Gems(), NextColumn
    NextColumn.PosX = StartX + GemWidth * 2
    NextColumn.PosY = StartY
  END IF
  DropDelay = TIMER + Speed     '' Reset delay time
RETURN

SUB CheckForMatch (Gems() AS INTEGER, Grid() AS INTEGER, GridX AS INTEGER, GridY AS INTEGER)
''****************************************************************************
''  Function: Looks for any matches (vertically, horizontally, or diagonally)
''            on the playing field with respect to GridX and GridY.
''    Inputs: GridX = X location on Grid to start searching
''            GridY = Y location on Grid to start searching
''   Outputs: If any matches are found, the grid and playing field (screen)
''            will be updated accordingly, except for hidden gems (see main)
''****************************************************************************

  DIM TempGrid(-2 TO NumFieldY, 1 TO NumFieldX) AS INTEGER

  FOR Y = -2 TO NumFieldY           '' Create a temporary grid
    FOR X = 1 TO NumFieldX          '' to store eliminated gems
      TempGrid(Y, X) = Grid(Y, X)   '' so they can all be processed in one step
    NEXT X
  NEXT Y
 
  GotMatch = False

  IF GridX + GridY > 0 THEN         '' Check, if less than, search all
    FOR I = GridY TO GridY + 2      '' Only search relevant portions
      IF I > 0 THEN
         IF MatchHorizontal%(Grid(), TempGrid(), GridX, I) THEN
           GotMatch = True
         END IF
      END IF
    NEXT I
    IF MatchVertical%(Grid(), TempGrid(), GridX, GridY) THEN
      GotMatch = True
    END IF
    FOR I = GridY TO GridY + 2      '' Searches relevant portions
      IF I > 0 THEN
         IF MatchDiagonal%(Grid(), TempGrid(), GridX, I) THEN
           GotMatch = True
         END IF
      END IF
    NEXT I
  ELSE                        '' Do complete search
    GOSUB CompleteSearch
  END IF
  
  WHILE GotMatch              '' We have a match!
    RemoveGems Gems(), Grid(), TempGrid()
    GotMatch = False
    GOSUB CompleteSearch                     '' Efficient?
  WEND
GOTO CheckEnd     '' ooh shun, a goto!
  
CompleteSearch:   '' Completely searches entire grid
    FOR Y = -2 TO NumFieldY
      IF MatchHorizontal%(Grid(), TempGrid(), 1, Y) THEN
        GotMatch = True
      END IF
    NEXT Y
    FOR X = 1 TO NumFieldX
      IF MatchVertical%(Grid(), TempGrid(), X, 1) THEN
        GotMatch = True
      END IF
    NEXT X
    FOR X = 1 TO NumFieldX        '' Efficient?  Not a chance.
      FOR Y = 1 TO NumFieldY      '' Some repeat, but I'm going for simplicity
        IF MatchDiagonal%(Grid(), TempGrid(), X, Y) THEN
          GotMatch = True
        END IF
      NEXT Y
    NEXT X
RETURN


CheckEnd:
EXIT SUB

    ''debug, just to see how the grid is changing
    LOCATE 1, 1
    FOR Y = 1 TO NumFieldY
      FOR X = 1 TO NumFieldX
        IF Grid(Y, X) <> -1 THEN PRINT "1 ";  ELSE PRINT "0 ";
      NEXT X
      PRINT
    NEXT Y

END SUB

SUB ConstructColumn (Column AS ColumnType)
'' Constructs a column, initialized accordingly

  RANDOMIZE TIMER
  IF RND <= MagicProb / 100 THEN
    Column.Gem1 = 6 * 140
    Column.Gem2 = 6 * 140
    Column.Gem3 = 6 * 140
  ELSE
    Column.Gem1 = INT(RND * 6) * 140
    Column.Gem2 = INT(RND * 6) * 140
    Column.Gem3 = INT(RND * 6) * 140
  END IF
  Column.GridX = 3
  Column.GridY = 0
  Column.PosX = StartX + GemWidth * (Column.GridX - 1)
  Column.PosY = StartY
  Column.Half = False

END SUB

SUB Delay (Seconds AS SINGLE)

T! = TIMER
DO: LOOP UNTIL ABS(TIMER - T!) >= Seconds

END SUB

SUB DisplayBackGround (BackGrnd() AS INTEGER)
'' Tiles a 32x32 bitmap out on screen

  FOR Y = 8 TO 179 STEP 32
    FOR X = 0 TO 319 STEP 32
      PUT (X, Y), BackGrnd, PSET
    NEXT X
  NEXT Y

  LINE (100, 20)-(80, 30), 7
  LINE (100, 20)-(120, 30), 7
  LINE (80, 30)-(80, 65), 7
  LINE (120, 30)-(120, 65), 7
  LINE (100, 75)-(80, 65), 7
  LINE (100, 75)-(120, 65), 7
  PAINT (110, 50), 0, 7

  '' Score field
  LINE (70, 90)-(126, 90), 7
  LINE (70, 108)-(126, 108), 7
  CIRCLE (116, 99), 15, 7, 5.5, .8
  CIRCLE (79, 99), 15, 7, 2.3, 4
  PAINT (100, 99), 0, 7

  '' Gems left field
  LINE (70, 118)-(126, 118), 7
  LINE (70, 136)-(126, 136), 7
  CIRCLE (116, 127), 15, 7, 5.5, .8
  CIRCLE (79, 127), 15, 7, 2.3, 4
  PAINT (100, 127), 0, 7

  '' Level field
  LINE (70, 146)-(126, 146), 7
  LINE (70, 164)-(126, 164), 7
  CIRCLE (116, 155), 15, 7, 5.5, .8
  CIRCLE (79, 155), 15, 7, 2.3, 4
  PAINT (100, 155), 0, 7

  OUT &H3C8, 250
  OUT &H3C9, 63
  OUT &H3C9, 63
  OUT &H3C9, 63
  OUT &H3C8, 251
  OUT &H3C9, 0
  OUT &H3C9, 0
  OUT &H3C9, 0

  PrimColor = 250
  SecColor = 251

  GemLeft$ = LTRIM$(RTRIM$(STR$(GemsLeft)))
  GemLeft$ = SPACE$(6 - LEN(GemLeft$)) + GemLeft$

  OFont "     0", 75, 95, 250, 0
  OFont GemLeft$, 75, 123, 15, 8
  OFont "     0", 75, 151, 15, 8
  OFont "SCORE", 15, 95, 78, 9
  OFont "TO GO", 15, 123, 78, 9
  OFont "LEVEL", 15, 151, 78, 9

END SUB

SUB DisplayColumn (Gems(), Column AS ColumnType)

   '' Yes, this is ugly, not just because GemHeight = 15

   I = Column.PosY
   IF I - 8 >= 0 THEN PUT (Column.PosX, I - 8), Gems(Column.Gem3 + BASEOfs), PSET ELSE EXIT SUB
   IF I - 15 >= 0 THEN PUT (Column.PosX, I - 15), Gems(Column.Gem3), PSET ELSE EXIT SUB
   IF I - 23 >= 0 THEN PUT (Column.PosX, I - 23), Gems(Column.Gem2 + BASEOfs), PSET ELSE EXIT SUB
   IF I - 30 >= 0 THEN PUT (Column.PosX, I - 30), Gems(Column.Gem2), PSET ELSE EXIT SUB
   IF I - 38 >= 0 THEN PUT (Column.PosX, I - 38), Gems(Column.Gem1 + BASEOfs), PSET ELSE EXIT SUB
   IF I - 45 >= 0 THEN PUT (Column.PosX, I - 45), Gems(Column.Gem1), PSET ELSE EXIT SUB

END SUB

SUB EliminateGem (Gems() AS INTEGER, Grid() AS INTEGER, Column AS ColumnType, ElimGem AS INTEGER)
 
  DIM TempGrid(-2 TO NumFieldY, 1 TO NumFieldX) AS INTEGER
 
  FOR Y = -2 TO NumFieldY
    FOR X = 1 TO NumFieldX
      IF Grid(Y, X) = ElimGem THEN
        TempGrid(Y, X) = -5
      ELSE
        TempGrid(Y, X) = Grid(Y, X)
      END IF
    NEXT X
  NEXT Y

  RemoveGems Gems(), Grid(), TempGrid()
  CheckForMatch Gems(), Grid(), -1, -1

END SUB

SUB InitField (Grid() AS INTEGER)
'' The -2 is a buffer for the hidden gems (needed by the Match routines)
'' The +1 is also used as a buffer, although infrequently accessed

  FOR Y = -2 TO NumFieldY + 1
    FOR X = 1 TO NumFieldX
      Grid(Y, X) = -1         '' -1 signals an empty spot
    NEXT X
  NEXT Y

END SUB

SUB LoadBackGround (FileName$, BackGrnd() AS INTEGER)
 
  DEF SEG = VARSEG(BackGrnd(1))
  BLOAD FileName$, VARPTR(BackGrnd(1))

END SUB

SUB LoadGemsFromFile (FileName$, Gems() AS INTEGER)

  DEF SEG = VARSEG(Gems(0))
  BLOAD FileName$, VARPTR(Gems(0))

END SUB

FUNCTION MatchDiagonal% (Grid() AS INTEGER, TempGrid() AS INTEGER, GridX AS INTEGER, GridY AS INTEGER)
'' Checks for diagonal matches, relative to GridX and GridY

  MatchDiagonal% = False
  Correct = Grid(GridY, GridX)
  IF Correct = -1 THEN EXIT FUNCTION
  Match = 0
  StartMatch = 0

  '' Check for top-left bottom-right diagonal ( ie. \ )

  sX = GridX - 1         '' How many spaces to the left
  sY = GridY - sX        '' Go up diagonally, by that much
  IF sX = 0 THEN sX = 1  '' Bound checks
  IF sY < 1 THEN sX = ABS(sY) + 2: sY = 1 ELSE sX = 1

  X = sX
  FOR Y = sY TO sY + NumFieldX      '' Up --> down
    IF Y > NumFieldY THEN EXIT FOR  '' But not that far!
    IF Grid(Y, X) = Correct THEN
      IF Match = 0 THEN StartMatchX = X: StartMatchY = Y
      Match = Match + 1
    ELSE
      IF Match < 3 THEN Match = 0 ELSE EXIT FOR
    END IF
    X = X + 1
    IF X > NumFieldX THEN EXIT FOR
  NEXT Y
 
  IF Match >= 3 THEN
    X = StartMatchX
    FOR Y = StartMatchY TO StartMatchY + Match - 1
      TempGrid(Y, X) = -5
      X = X + 1
    NEXT Y
    MatchDiagonal% = True
  END IF

  '' Check for bottom-left top-right diagonal ( ie. / )

  Match = 0
  StartMatch = 0
 
  sX = GridX - 1         '' How many spaces to the left
  sY = GridY + sX        '' Go up diagonally
  IF sX = 0 THEN sX = 1
  IF sY > NumFieldY THEN sX = sY - NumFieldY + 1: sY = NumFieldY ELSE sX = 1

  X = sX
  FOR Y = sY TO 1 STEP -1
    IF Grid(Y, X) = Correct THEN
      IF Match = 0 THEN StartMatchX = X: StartMatchY = Y
      Match = Match + 1
    ELSE
      IF Match < 3 THEN Match = 0 ELSE EXIT FOR
    END IF
    X = X + 1
    IF X > NumFieldX THEN EXIT FOR
  NEXT Y

  IF Match >= 3 THEN
    X = StartMatchX
    FOR Y = StartMatchY TO StartMatchY - Match + 1 STEP -1
      TempGrid(Y, X) = -5
      X = X + 1
    NEXT Y
    MatchDiagonal% = True
  END IF

END FUNCTION

FUNCTION MatchHorizontal% (Grid() AS INTEGER, TempGrid() AS INTEGER, GridX AS INTEGER, GridY AS INTEGER)
'' Checks for Horizontal Matches relative to GridX and GridY

  MatchHorizontal% = False
  Correct = Grid(GridY, GridX)
  IF Correct = -1 THEN Correct = -10
  Match = 0
  StartMatch = 0

  FOR X = 1 TO NumFieldX
    IF Grid(GridY, X) = Correct THEN
      IF Match = 0 THEN StartMatch = X
      Match = Match + 1
    ELSE
      IF Match < 3 THEN
        Match = 1
        StartMatch = X
        Correct = Grid(GridY, X)
        IF Correct = -1 THEN Correct = -10
      ELSE
        GOSUB HorzMatched
        Match = 1
        StartMatch = X
        Correct = Grid(GridY, X)
        IF Correct = -1 THEN Correct = -10
      END IF
    END IF
  NEXT X
  IF Match >= 3 THEN GOSUB HorzMatched
EXIT FUNCTION

HorzMatched:
  FOR I = StartMatch TO StartMatch + Match - 1
    TempGrid(GridY, I) = -5
  NEXT I
  MatchHorizontal% = True
RETURN

END FUNCTION

FUNCTION MatchVertical% (Grid() AS INTEGER, TempGrid() AS INTEGER, GridX AS INTEGER, GridY AS INTEGER)
'' Checks for Vertical matches relative to GridX and GridY

  MatchVertical% = False
  Correct = Grid(-2, GridX)
  IF Correct = -1 THEN Correct = -10
  Match = 0
  StartMatch = 0

  FOR Y = -2 TO NumFieldY               '' Simple up down search
    IF Grid(Y, GridX) = Correct THEN
      IF Match = 0 THEN StartMatch = Y
      Match = Match + 1
    ELSE                                '' Not correctly matching
      IF Match < 3 THEN                 '' Try with other one
        Match = 1
        StartMatch = Y
        Correct = Grid(Y, GridX)
        IF Correct = -1 THEN Correct = -10
      ELSE
        GOSUB VertMatched
        Match = 1
        StartMatch = Y
        Correct = Grid(Y, GridX)
        IF Correct = -1 THEN Correct = -10
      END IF
    END IF
  NEXT Y
  IF Match >= 3 THEN GOSUB VertMatched
EXIT FUNCTION

VertMatched:
  FOR I = StartMatch TO StartMatch + Match - 1
    TempGrid(I, GridX) = -5
  NEXT I
  MatchVertical% = True
RETURN

END FUNCTION

DEFINT A-Z
SUB OFont (Text$, X, Y, Fore, Back)
DEF SEG = &HFFA6                              'Stores masks for letters
FOR Letter = 1 TO LEN(Text$)                  'Does each letter
Address = (8 * ASC(MID$(Text$, Letter))) + 14 'Address for start of letter
FOR Height = 0 TO 7                       'Each letter is an 8x8 pixel matrix
Mask = PEEK(Address + Height) * 128   'Address for mask of each line of letter
LINE (X + Curntx + 1, Y + Height + 1)-(X + 9 + Curntx, Y + Height + 1), Fore, , Mask
NEXT
Curntx = Curntx + 8                   'Advances X axis by 8 for next letter
NEXT                                  'Continue to next letter
DEF SEG = &HA000                      'Change to video memory
IF Back > 0 THEN                      'Background color can't be color 0
FOR V = Y TO Y + 7                    'Again, they're 8x8 pixels
FOR H = X TO (LEN(Text$) * 8) - 1 + X 'Calculates length of text in pixels
PK0& = PEEK(H + V * 320&)             'Is point at H,V = to foreground color?
PK1& = PEEK(H + 1 + (V + 1) * 320&)   'Is point at H+1, V+1 = to foreground?
PK2& = PEEK(H + 1 + V * 320&)         'Is point at H+1, V = to foreground?
PT& = H + V * 320&                    'Video memory pointer
IF PK0& <> Fore THEN                  'If this is foreground, don't overlap it
IF PK1& = Fore OR PK2& = Fore THEN POKE PT&, Back    'Put pixel into memory
END IF
NEXT H     'Next horizontal
NEXT V     'Next vertical
END IF
DEF SEG    'Put us back where
END SUB    'We started

SUB RemoveGems (Gems() AS INTEGER, Grid() AS INTEGER, TempGrid() AS INTEGER)
 
  REDIM Block(2000) AS INTEGER

    PrevScore$ = LTRIM$(RTRIM$(STR$(Score)))
    PrevScore$ = SPACE$(6 - LEN(PrevScore$)) + PrevScore$
    FOR Y = -2 TO NumFieldY
      FOR X = 1 TO NumFieldX
        IF TempGrid(Y, X) = -5 THEN
          GemsLeft = GemsLeft - 1
          Score = Score + BaseScore
        END IF
      NEXT X
    NEXT Y
    CurScore$ = LTRIM$(RTRIM$(STR$(Score)))
    CurScore$ = SPACE$(6 - LEN(CurScore$)) + CurScore$

    R = 63: R2 = 0
    G = 63: G2 = 0
    B = 63: G3 = 0
    LINE (71, 91)-(125, 107), 0, BF

    Alternate = False
    Flash = True
    FOR I = 1 TO 7            '' Spiffy routine
      Flash = NOT Flash       '' Alternates
      T! = TIMER + .2
      DO
      IF R > 0 THEN
        DO
          IF Alternate = False THEN
            OFont CurScore$, 75, 95, SecColor, 0
            OFont PrevScore$, 75, 95, PrimColor, 0
          ELSE
            OFont PrevScore$, 75, 95, PrimColor, 0
            OFont CurScore$, 75, 95, SecColor, 0
          END IF
          R = R - 3
          G = G - 3
          B = B - 3
          R2 = R2 + 3
          G2 = G2 + 3
          B2 = B2 + 3
          OUT &H3C8, PrimColor
          OUT &H3C9, R
          OUT &H3C9, G
          OUT &H3C9, B
          OUT &H3C8, SecColor
          OUT &H3C9, R2
          OUT &H3C9, G2
          OUT &H3C9, B2
          IF R <= R2 THEN Alternate = True
          Delay .05
        LOOP UNTIL TIMER - T! >= 0 OR R = 0
      END IF
      LOOP UNTIL TIMER - T! >= 0
      FOR Y = 1 TO NumFieldY     '' Search entire grid for eliminated gems
        FOR X = 1 TO NumFieldX
          IF TempGrid(Y, X) = -5 THEN    '' Eliminated
            PosX = StartX + ((X - 1) * GemWidth)
            PosY = StartY + ((Y - 1) * GemHeight)
            IF Flash THEN
              PUT (PosX, PosY), Gems(Grid(Y, X)), PSET
              PUT (PosX, PosY + 7), Gems(Grid(Y, X) + BASEOfs), PSET
            ELSE
              LINE (PosX, PosY)-(PosX + GemWidth - 1, PosY + GemHeight - 1), 0, BF
            END IF
          END IF
        NEXT X
      NEXT Y
    NEXT I
    FOR Y = -2 TO NumFieldY           '' Remove gems from original Grid()
      FOR X = 1 TO NumFieldX          '' Also, restore playing field
        IF TempGrid(Y, X) = -5 THEN
          PosX = StartX + ((X - 1) * GemWidth)
          PosY = StartY + ((Y - 1) * GemHeight)
          IF PosY > 0 THEN
            GET (PosX, StartY)-(PosX + GemWidth - 1, PosY - 1), Block
            LINE (PosX, StartY)-(PosX + GemWidth - 1, PosY - 1), 0, BF
            PUT (PosX, StartY + GemHeight), Block, PSET
          END IF
          Grid(Y, X) = -1                    '' Eliminated gem is now empty
          FOR I = Y TO -1 STEP -1            '' Restore grid
            SWAP Grid(I, X), Grid(I - 1, X)  '' Sift up
          NEXT I
        END IF
      NEXT X
    NEXT Y
    FOR Y = -2 TO NumFieldY                  '' Do it all again
      FOR X = 1 TO NumFieldX                 '' Since grid has changed
        TempGrid(Y, X) = Grid(Y, X)
      NEXT X
    NEXT Y

  SWAP PrimColor, SecColor
  ERASE Block

END SUB

SUB UpdateDispColumn (Gems() AS INTEGER, Column AS ColumnType)
'' Display column on the next field

    TempX = Column.PosX
    TempY! = Column.PosY
    Column.PosX = 92              '' Position of next field
    Column.PosY = 71
    DisplayColumn Gems(), Column
    Column.PosX = TempX
    Column.PosY = TempY!

END SUB

