'****************************************************************************
'NETRIS V3.0
' Stripped sorce code.
'
' This code is stripped because most QB Programmers don't have VBDOS and the
' extra functionality it provides.  Also QBasic doesn't like Underscores and
' my code is full of them so QB4.5 is out of it also.  I don't comment code
' very much so I'll give an explanation of whats going on
'
' The block data starts at the P1: label and ends at P7: label.  Now I've
' seen a lot of QB Tetris games out there and the DATA statement for the
' blocks is HUGE (7 Blocks * 4 Rotation views with a matrix of 4*4 at an
' Integer level is with a color = 910 Bytes)  My blocs are.. (7 Blocks at a
' matrix of 4*2 on Integer level with a color = 58 Bytes) Now you may think
' "So I saved a whole 852 bytes, So what.  Well if you consider having
' 15000 Bytes of SoundBlaster samples + 74,880 Bytes of Music data (FM) you
' want to save all of the memory you can.
'
' Now Back to blocks.
'  If you have noticed all Tetris blocks have 4 parts
' (e.g.)
'
' XX
'  XX
'
'  So all you need is 4 X,Y offsets making 0,0 the center of the blocks
'
' X0
'  XX
'
' "But how do you rotate it?" you ask
' Look at FlipC All its doing is rotating all the X,Y values which in turn
' rotates the Peice.
'
' Collision detection is as easy as falling out of bed.
'
' To check for a collision just cycle throu the Peice X,Y's and make sure
' that the peice offset+X,Y does not overlap on the player's feild.
'
' Now to make everything really nice. We use Clock ticks. NeTris uses 10
' Clock tickes per Cycle. Now this means that Level 10 Is the highest (REAL)
' Reachable level. But have you ever played Tetris where the peice falls as
' fast as once every 10 milliseconds?
'****************************************************************************




DECLARE SUB LoadFSP (File$)
DECLARE SUB BBlock (x%, y%)
DECLARE FUNCTION Bin2Dec% (Bin AS STRING)
DECLARE FUNCTION Bit$ (byte$)
DECLARE SUB Block (x%, y%, C%)
DECLARE SUB BOS ()
DECLARE SUB Center (y%, Text$)
DECLARE SUB CFG_Command ()
DECLARE SUB CheckLine ()
DECLARE FUNCTION Choice% (x%, y%, Num%, At%)
DECLARE FUNCTION Collision% (x%, y%)
DECLARE SUB Delay (RTime#)
DECLARE SUB EQuake (x%)
DECLARE SUB EraseNext ()
DECLARE SUB ErasePiece (x%, y%)
DECLARE SUB FadeIn ()
DECLARE SUB FadeOut ()
DECLARE SUB FlipC ()
DECLARE SUB FlipCC ()
DECLARE SUB Font (x%, y%, SC%, Text$)
DECLARE SUB GSPR (XS!, YS!, XL!, YL!, Sprite$, Trans!)
DECLARE SUB HLINE (y%)
DECLARE FUNCTION IKey$ ()
DECLARE SUB Init ()
DECLARE SUB LoadBMP (XOFF%, YOFF%, A$)
DECLARE SUB Menu ()
DECLARE SUB NewKey (NKey AS STRING)
DECLARE FUNCTION PlacePiece% (x%, y%, C%)
DECLARE SUB PlayGame ()
DECLARE SUB PSPR (XS AS INTEGER, YS AS INTEGER, Sprite$, CIndex%, SC%)
DECLARE SUB PutNext ()
DECLARE SUB PutPiece (x%, y%, C%)
DECLARE SUB RefreshField ()
DECLARE SUB Restorepal ()
DECLARE SUB RField ()
DECLARE SUB Stats ()
DEFINT A-Z
'Sound Blaster
TYPE SoundBlaster
	Port  AS INTEGER
	IRQ   AS INTEGER
	DMA1  AS INTEGER
	DMA2  AS INTEGER
	Found AS INTEGER

	LP    AS INTEGER
	AP    AS INTEGER
	PP    AS INTEGER
	MR    AS INTEGER
END TYPE
COMMON SHARED SB AS SoundBlaster

TYPE SBsnd
	SD(0) AS STRING * 5000
	Length AS LONG
	Freq AS LONG
	Active AS INTEGER
END TYPE

DIM SHARED SND(3) AS SBsnd

'Misc
	'Font
	DIM SHARED GFont(0, 100) AS STRING
	DIM SHARED CY AS INTEGER

DIM SHARED Blocks(8 * 8, 10) AS INTEGER
DIM SHARED Back(8 * 8, 3, 5) AS INTEGER
DIM SHARED PField(11, -1 TO 21) AS INTEGER
'Peices
DIM SHARED CPiece(4, 2) AS INTEGER
DIM SHARED NPiece(4, 2) AS INTEGER
DIM SHARED CClr AS INTEGER
DIM SHARED NClr AS INTEGER
DIM SHARED CBack AS INTEGER
'Pipes
DIM SHARED Pipes(8 * 8, 7) AS INTEGER
'Scoring
DIM SHARED Score AS INTEGER
DIM SHARED Level AS INTEGER
DIM SHARED Lines AS INTEGER
'Screen
DIM SHARED Pal(256, 2) AS STRING * 1
DIM SHARED Arrow(0, 7) AS STRING
'Config
TYPE Config
	CSound AS INTEGER
	CMusic AS INTEGER
	Flip1  AS STRING * 2
	Flip2  AS STRING * 2
	RT     AS STRING * 2
	LT     AS STRING * 2
	Drop   AS STRING * 2
	Fall   AS STRING * 2
END TYPE
DIM SHARED CFG AS Config


CONST False = 0
CONST True = NOT False

'Program Start

DIM Text(80, 25)


CRSRX = POS(0)
CRSRY = CSRLIN
FOR y = 1 TO 23
	FOR x = 1 TO 80
		Text(x, y) = SCREEN(y, x)
	NEXT
NEXT

FadeOut

Init

BOS

Menu

FadeOut

SCREEN 0: WIDTH 80, 25

FadeOut

COLOR 7
FOR y = 1 TO 23
	FOR x = 1 TO 80
		LOCATE y, x: PRINT CHR$(Text(x, y))
	NEXT
NEXT

LOCATE CRSRY, CRSRX
PRINT "Netris V3.0"
PRINT "A VHNet Production."

FadeIn

END



P1:
DATA -1, 0
DATA  0, 0
DATA  1, 0
DATA  2, 0
DATA 0

P2:
DATA  0, 0
DATA  1, 0
DATA  0, 1
DATA  1, 1
DATA 1

P3:
DATA -1, 0
DATA  0, 0
DATA  0, 1
DATA  1, 1
DATA 2

P4:
DATA -1, 1
DATA  0, 1
DATA  0, 0
DATA  1, 0
DATA 3

P5:
DATA  0, 0
DATA -1, 0
DATA  1, 0
DATA  0, 1
DATA 4

P6:
DATA  0,-1
DATA  0, 0
DATA  0, 1
DATA  1, 1
DATA 5

P7:
DATA  0,-1
DATA  0, 0
DATA  0, 1
DATA -1, 1
DATA 6

FieldD:
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 100000000001
DATA 111111111111
DATA 000000000000

PlayPipes:
DATA 15555555552600000000006155555555552
DATA 60000000006600000000006600000000006
DATA 60000000006600000000006600000000006
DATA 60000000006600000000006600000000006
DATA 35555555554600000000006600000000006
DATA 15555215552600000000006600000000006
DATA 67777660006600000000006600000000006
DATA 67777660006600000000006600000000006
DATA 67777660006600000000006600000000006
DATA 35555460006600000000006600000000006
DATA 15555540006600000000006600000000006
DATA 60000000006600000000006600000000006
DATA 60000000006600000000006600000000006
DATA 60000000006600000000006600000000006
DATA 60000000006600000000006600000000006
DATA 60000000006600000000006600000000006
DATA 60000000006600000000006600000000006
DATA 60000000006600000000006600000000006
DATA 35520000006600000000006600000000006
DATA 15260000006600000000006600000000006
DATA 60660000006355555555554600000000006
DATA 35435555554000000000000355555555554

Menu:
DATA 00000000000000000000000000000000000
DATA 00000000000000000000000000000000000
DATA 00000000000000000000000000000000000
DATA 00000000000000000000000000000000000
DATA 00000000000000000000000000000000000
DATA 00000000000000000000000000000000000
DATA 00000000000000000000000000000000000
DATA 00000000000000000000000000000000000
DATA 00015555555555555555555555555552000
DATA 00067777777777777777777777777776000
DATA 00067777777777777777777777777776000
DATA 00067777777777777777777777777776000
DATA 00067777777777777777777777777776000
DATA 00067777777777777777777777777776000
DATA 00067777777777777777777777777776000
DATA 00067777777777777777777777777776000
DATA 00067777777777777777777777777776000
DATA 00035555555555555555555555555554000
DATA 00000000000000000000000000000000000
DATA 00000000000000000000000000000015555
DATA 00000000000000000000000000000060000
DATA 00000000000000000000000000000060000

Scores:
DATA 15555555555555555555555555555555552
DATA 60000000000000000000000000000000006
DATA 35555555555555555555555555555555554

SUB BBlock (x, y)

IF y >= 0 THEN

	IF x AND 1 THEN A = 1
	IF y AND 1 THEN B = 1

	IF A = 0 AND B = 0 THEN C = 0
	IF A = 1 AND B = 0 THEN C = 1
	IF A = 0 AND B = 1 THEN C = 2
	IF A = 1 AND B = 1 THEN C = 3
	PUT ((x + 11) * 9, y * 9), Back(0, C, CBack), PSET


END IF
END SUB

FUNCTION Bin2Dec (Bin AS STRING)
Bin = STRING$(8 - LEN(Bin), " ") + Bin
Dec = 0
Root = 128
FOR A = 1 TO 8
IF MID$(Bin, A, 1) = "1" THEN Dec = Dec + Root
Root = Root / 2
NEXT
Bin2Dec = Dec
END FUNCTION

FUNCTION Bit$ (byte$)

Dec = ASC(byte$)
Bin$ = ""
Root = 128
FOR A = 1 TO 8
IF Root <= Dec THEN
Dec = Dec - Root
Bin$ = Bin$ + "1"
ELSE
Bin$ = Bin$ + "0"
END IF
Root = Root / 2
NEXT

Bit$ = Bin$
END FUNCTION

SUB Block (x, y, C)
IF y >= 0 THEN
	PUT ((x + 11) * 9, y * 9), Blocks(0, C), PSET
END IF
END SUB

SUB BOS ()
Restorepal
	CY = 3
	Center CY, "+7Netris V3.0^"
	Center CY, "+1Stripped for All QBasic users^"
	Center CY, "+1Because most people don't have VBDOS^"
	HLINE CY
	Center CY, "-2INIT_LOAD.^"
	Font 9, CY, 0, "-2Loading Blocks...^"
	FOR A = 1 TO 10
		Font 9, CY, 0, "+9[+1" + STRING$(A, "-") + SPACE$(10 - A) + "+9]"
	NEXT
	Font 9, CY, 0, "^"
	Font 9, CY, 0, "-2Loading Backgrounds...^"
	FOR A = 1 TO 10
		Font 9, CY, 0, "+9[+1" + STRING$(A, "-") + SPACE$(10 - A) + "+9]"
	NEXT
	Font 9, CY, 0, "^"
	HLINE CY
	CFG_Command
	Center CY, "+7NeTris V3.0^"

Rest# = TIMER + 2
WHILE IKey$ = "" AND Rest# > TIMER: WEND

FadeOut
END SUB

DEFSNG A-Z
SUB Box (A, B, x, y, C)
LINE (A, B)-(x, y), C, BF

LINE (A, B)-(x, B), 8
LINE (A, B)-(A, y), 8

LINE (A + 1, B + 1)-(x, B + 1), 0
LINE (A + 1, B + 1)-(A + 1, y), 0

LINE (x, y)-(x, B), 15
LINE (x, y)-(A, y), 15

LINE (x - 1, y - 1)-(x - 1, B + 1), 7
LINE (x - 1, y - 1)-(A + 1, y - 1), 7
END SUB

SUB Button (A, B, x, y, C)
LINE (A, B)-(x, y), C, BF

LINE (A, B)-(x - 1, B), 7
LINE (A, B)-(A, y - 1), 7

LINE (A + 1, B + 1)-(x - 2, B + 1), 15
LINE (A + 1, B + 1)-(A + 1, y - 2), 15

LINE (x, y)-(x, B), 0
LINE (x, y)-(A, y), 0

LINE (x - 1, y - 1)-(x - 1, B + 1), 8
LINE (x - 1, y - 1)-(A + 1, y - 1), 8

END SUB

DEFINT A-Z
SUB Center (y, Text$)
x = INT((80 - LEN(Text$)) / 2)
Font x * 4, y, 0, Text$
END SUB

DEFSNG A-Z
'DEFINT A-Z
SUB CFG_Command ()
	DIM Commands(10) AS STRING
	Center CY, "INIT_COMMAND^"

	Font 9, CY, 0, "Reading Command Line Parameters.^"
	
	IF COMMAND$ <> "" THEN
		FOR A = 1 TO LEN(COMMAND$)
			SELECT CASE MID$(COMMAND$, A, 1)
				CASE "/", "-", ":"
					B = B + 1
				CASE ELSE
					Commands(B) = Commands(B) + UCASE$(MID$(COMMAND$, A, 1))
					Commands(B) = UCASE$(RTRIM$(Commands(B)))
			END SELECT
		NEXT
	END IF

	FOR B = 1 TO 10
		SELECT CASE Commands(B)
			CASE ""
			CASE "S"
				IF LEN(Commands(B + 1)) = 4 THEN
					IPXSocket = VAL("&H" + Commands(B + 1))
					Font 9, CY, 0, "Setting IPXSocket=" + HEX$(IPXSocket) + "^"
					B = B + 1
				ELSE
					Font 9, CY, 0, "Invalid Socket Number" + Commands(B + 1) + "^"
				END IF
			CASE "VIRUS1"
				Plr.Virus = 1: Plr.VirusLen = 1000
			CASE "VIRUS2"
				Plr.Virus = 2: Plr.VirusLen = 1000
			CASE "VIRUS3"
				Plr.Virus = 3: Plr.VirusLen = 1000

			CASE ELSE
		END SELECT
	NEXT
	HLINE CY
END SUB

DEFINT A-Z
SUB CheckLine ()
	FOR y = 0 TO 19
		NBlock = 0
		FOR x = 1 TO 10
			IF PField(x, y) <> 0 THEN NBlock = NBlock + 1
		NEXT
		IF NBlock = 10 THEN
			L = L + 1
			FOR DY = y TO 1 STEP -1
	FOR x = 1 TO 10
		PField(x, DY) = PField(x, DY - 1)
	NEXT
			NEXT
			y = y - 1
		END IF
	NEXT
	SELECT CASE L
		CASE 1: LA = 4
		CASE 2: LA = 10
		CASE 3: LA = 30
		CASE 4: LA = 120
	END SELECT

	Score = Score + (LA * (11 - Level))
	Lines = Lines + L
	RLevel = Level
	IF 10 - INT(Lines / 10) < Level THEN Level = 10 - INT(Lines / 10)
	IF RLevel <> Level THEN CBack = (CBack + 1) MOD 4
	RField
END SUB

FUNCTION Choice (x, y, Num, At)
A = 0
IF At = 0 THEN At = 1
C = At
DO
	A = (A + 1) MOD 7
	BBlock x - 11, y + (C - 1)
	PSPR x * 9, (y + C - 1) * 9, Arrow(0, A), 0, 0
	Delay .1
	Key$ = IKey$
	SELECT CASE Key$
		CASE CHR$(0) + "H"
			IF C <> 1 THEN BBlock x - 11, y + (C - 1): C = C - 1
		CASE CHR$(0) + "P"
			IF C <> Num THEN BBlock x - 11, y + (C - 1): C = C + 1
		CASE CHR$(13)
			EXIT DO
	END SELECT
LOOP UNTIL Key$ = CHR$(27)
BBlock x - 11, y + (C - 1)
IF Key$ = CHR$(27) THEN Choice = 0 ELSE Choice = C
At = C
END FUNCTION

FUNCTION Collision (x, y)
	FOR A = 1 TO 4
		cx = CPiece(A, 1) + x
		CY = CPiece(A, 2) + y
		IF CY >= -1 AND cx < 12 AND cx > -1 THEN IF PField(cx, CY) <> 0 THEN Collision = 1
	NEXT
END FUNCTION

DEFSNG A-Z
SUB Delay (RTime#)
REND# = TIMER + RTime#
WHILE TIMER < REND#
WEND
END SUB

DEFINT A-Z
SUB EQuake (x)
FOR x = 1 TO x
	OUT &H3D4, 8
	OUT &H3D5, (RND * 255)
Delay .01
NEXT x
OUT &H3D4, 8: OUT &H3D5, 0
END SUB

SUB EraseNext ()
	FOR A = 1 TO 4
		BBlock NPiece(A, 1) - 9, NPiece(A, 2) + 7
	NEXT
END SUB

SUB ErasePiece (x, y)
FOR A = 1 TO 4

BBlock CPiece(A, 1) + x, CPiece(A, 2) + y

NEXT
END SUB

SUB FadeIn ()
	DIM TT(1 TO 3)
	FOR A = 1 TO 64
		FOR C = 0 TO 255
			OUT &H3C7, C
			TT(1) = INP(&H3C9)
			TT(2) = INP(&H3C9)
			TT(3) = INP(&H3C9)
			IF TT(1) < ASC(Pal(C, 0)) THEN TT(1) = TT(1) + 1
			IF TT(2) < ASC(Pal(C, 1)) THEN TT(2) = TT(2) + 1
			IF TT(3) < ASC(Pal(C, 2)) THEN TT(3) = TT(3) + 1
			R = TT(1)
			G = TT(2)
			B = TT(3)
			OUT &H3C8, C
			OUT &H3C9, R
			OUT &H3C9, G
			OUT &H3C9, B
		NEXT
	NEXT
	WHILE IKey$ <> "": WEND
END SUB

SUB FadeOut ()
DIM TT(1 TO 3)
FOR I = 1 TO 64
	FOR O = 0 TO 255
		OUT &H3C7, O
		TT(1) = INP(&H3C9)
		TT(2) = INP(&H3C9)
		TT(3) = INP(&H3C9)
		IF TT(1) > 0 THEN TT(1) = TT(1) - 1
		IF TT(2) > 0 THEN TT(2) = TT(2) - 1
		IF TT(3) > 0 THEN TT(3) = TT(3) - 1
		R = TT(1)
		G = TT(2)
		B = TT(3)
		OUT &H3C8, O
		OUT &H3C9, R
		OUT &H3C9, G
		OUT &H3C9, B
	NEXT O
NEXT I
CLS
WHILE IKey$ <> "": WEND
END SUB

SUB FlipC ()
	FOR A = 1 TO 4
		Temp = CPiece(A, 2)
		CPiece(A, 2) = CPiece(A, 1)
		CPiece(A, 1) = -Temp
	NEXT
END SUB

SUB FlipCC ()
	FOR A = 1 TO 4
		Temp = CPiece(A, 1)
		CPiece(A, 1) = CPiece(A, 2)
		CPiece(A, 2) = -Temp
	NEXT
END SUB

SUB Font (x, y, SC, Text$)
	IF SC = 0 THEN SC = 1
	bx = x
		FOR A = 1 TO LEN(Text$)
			Char$ = MID$(Text$, A, 1)
			Char% = ASC(Char$) - 32
			SELECT CASE Char$
				CASE CHR$(0)
					A = A + 1
					Char$ = MID$(Text$, A, 1)
					SELECT CASE Char$
						CASE "5"
							Font x, y, SC, "+2Alt"
						CASE "6"
							Font x, y, SC, "+2Ctrl"
						CASE "7"
							Font x, y, SC, "+2L Shift"
						CASE "8"
							Font x, y, SC, "+2R Shift"
						CASE " "
							Font x, y, SC, "+2Space"
						'Arrow Keys
						CASE "H"
							PSPR x, y, GFont(0, 95), CIndex, SC
						CASE "P"
							PSPR x, y, GFont(0, 93), CIndex, SC
						CASE "M"
							PSPR x, y, GFont(0, 92), CIndex, SC
						CASE "K"
							PSPR x, y, GFont(0, 94), CIndex, SC
					END SELECT
				'ASC Key Codes
				CASE CHR$(13)
					Font x, y, 0, "Enter"
				CASE CHR$(9)
					Font x, y, 0, "Tab"
				CASE CHR$(8)
					Font x, y, 0, "Back Space"
				'Colors
				CASE "-"
					A = A + 1
					IF MID$(Text$, A, 1) >= "0" AND MID$(Text$, A, 1) <= "9" THEN
						CIndex = -VAL(MID$(Text$, A, 1))
					ELSE
						PSPR x, y, GFont(0, Char%), CIndex, SC
						x = x + 4
						A = A - 1
					END IF
				CASE "+"
					A = A + 1
					IF MID$(Text$, A, 1) >= "0" AND MID$(Text$, A, 1) <= "9" THEN
						CIndex = VAL(MID$(Text$, A, 1))
					ELSE
						PSPR x, y, GFont(0, Char%), CIndex, SC
						x = x + 4
						A = A - 1
					END IF
				'Carriage Return
				CASE "^"
					x = bx
					y = y + (9 * SC)
					IF y >= 185 THEN LOCATE 25, 1: PRINT : y = 185
				'Space
				CASE " "
					x = x + (4 * SC)
				'Normal Chars
				CASE " " TO "z"
					PSPR x, y, GFont(0, Char%), CIndex, SC
					x = x + (4 * SC)
			END SELECT
		NEXT
END SUB

DEFSNG A-Z
SUB GETPal (C, R, G, B)
OUT &H3C6, &HFF
OUT &H3C8, C
R = INP(&H3C9)
G = INP(&H3C9)
B = INP(&H3C9)
END SUB

SUB GSPR (XS, YS, XL, YL, Sprite$, Trans)
	XE = XS + XL
	YE = YS + YL
	Sprite$ = Sprite$ + CHR$(XE - XS) + CHR$(YE - YS) + LTRIM$(STR$(Trans))
	FOR y = YS TO YE
		FOR x = XS TO XE
			Sprite$ = Sprite$ + CHR$(POINT(x, y))
		NEXT
	NEXT
END SUB

DEFINT A-Z
SUB HLINE (y)
IF y >= 185 THEN LOCATE 25, 1: PRINT : PRINT : y = 185 - 9
FOR x = 0 TO 34
	PUT (x * 9, y - 2), Pipes(0, 4), PSET
NEXT
y = y + 9
END SUB

FUNCTION IKey$ ()

IKey$ = CHR$(0) + CHR$(0)

	DEF SEG = 0
	KeySts = PEEK(1047)

	KeySts = KeySts + 1
		K = 0

		IF KeySts > 128 THEN KeySts = KeySts - 128: 'IKey$ = CHR$(0) + "1": K = 1  'InsKey
		IF KeySts > 64 THEN KeySts = KeySts - 64:   'IKey$ = CHR$(0) + "2": K = 1  'CapKey
		IF KeySts > 32 THEN KeySts = KeySts - 32:   'IKey$ = CHR$(0) + "3": K = 1  'NumKey
		IF KeySts > 16 THEN KeySts = KeySts - 16:   'IKey$ = CHR$(0) + "4": K = 1  'ScrKey
		IF KeySts > 8 THEN KeySts = KeySts - 8:     IKey$ = CHR$(0) + "5": K = 1  'AltKey
		IF KeySts > 4 THEN KeySts = KeySts - 4:     IKey$ = CHR$(0) + "6": K = 1  'CtrKey
		IF KeySts > 2 THEN KeySts = KeySts - 2:     IKey$ = CHR$(0) + "7": K = 1  'LSfKey
		IF KeySts > 1 THEN KeySts = KeySts - 1:     IKey$ = CHR$(0) + "8": K = 1  'RSfKey

IF K THEN EXIT FUNCTION

K$ = INKEY$

IF K$ = " " THEN IKey$ = CHR$(0) + " ":  ELSE IKey$ = K$

END FUNCTION

DEFSNG A-Z
SUB Init ()

	SCREEN 13
	RANDOMIZE TIMER
	LoadBMP 0, 0, "Font.BMP"
	FOR A = 0 TO 45
		GSPR A * 4, 0, 3, 5, GFont(0, A), 1
		GSPR A * 4, 6, 3, 5, GFont(0, A + 46), 1
	NEXT
	FOR A = 0 TO 3
		GSPR A * 6, 12, 5, 5, GFont(0, A + 92), 1
	NEXT

	CLS
	LoadBMP 0, 0, "Blocks.BMP"
	FOR A = 0 TO 10
		GET (A * 9, 0)-STEP(8, 8), Blocks(0, A)
	NEXT


	FOR A = 0 TO 7
		GET (A * 9, 27)-STEP(8, 8), Pipes(0, A)
	NEXT

	FOR A = 0 TO 7
		GSPR A * 9, 36, 8, 8, Arrow(0, A), 1
	NEXT

	FOR B = 0 TO 5
		FOR A = 0 TO 1
			GET ((A + B * 2) * 9, 9)-STEP(8, 8), Back(0, A, B)
			GET ((A + B * 2) * 9, 18)-STEP(8, 8), Back(0, A + 2, B)
		NEXT
	NEXT
	CLS
RefreshField
Level = 10

END SUB

DEFINT A-Z
SUB LoadBMP (XOFF, YOFF, A$)

DIM CRC              AS STRING * 2
DIM SizeOfFile       AS LONG
DIM Reserved         AS STRING * 4
DIM PDOffSet         AS LONG
DIM SizeIHead        AS LONG
DIM SizeX            AS LONG
DIM SizeY            AS LONG
DIM NOPlanes         AS INTEGER
DIM BPP              AS INTEGER
DIM Compression      AS LONG
DIM ImageSize        AS LONG
DIM PWPPM            AS LONG
DIM PHPPM            AS LONG
DIM NOCUsed          AS LONG
DIM NOIC             AS LONG


IF INSTR(A$, ".") = 0 THEN A$ = A$ + ".BMP"
FileNum = FREEFILE
OPEN A$ FOR INPUT AS #FileNum: CLOSE #FileNum
OPEN A$ FOR BINARY AS #FileNum


GET #FileNum, , CRC
GET #FileNum, , SizeOfFile
GET #FileNum, , Reserved
GET #FileNum, , PDOffSet
GET #FileNum, , SizeIHead
GET #FileNum, , SizeX
GET #FileNum, , SizeY
GET #FileNum, , NOPlanes
GET #FileNum, , BPP
GET #FileNum, , Compression
GET #FileNum, , ImageSize
GET #FileNum, , PWPPM
GET #FileNum, , PHPPM
GET #FileNum, , NOCUsed
GET #FileNum, , NOIC


'IF CRC <> "BM" THEN ERROR 5
'IF SizeIHead <> 40 THEN ERROR 5
'IF NOPlanes <> 1 THEN ERROR 5
'IF BPP <> 8 THEN ERROR 5
'IF Compression <> 0 THEN ERROR 5


'DIM Pal(256, 2) AS STRING * 1
Dum$ = " "
'Load Palette
IF BPP <> 24 THEN
FOR A = 0 TO 2 ^ BPP
GET #FileNum, , Pal(A, 2)
GET #FileNum, , Pal(A, 1)
GET #FileNum, , Pal(A, 0)
GET #FileNum, , Dum$

Pal(A, 2) = CHR$(ASC(Pal(A, 2)) / 4.11)
Pal(A, 1) = CHR$(ASC(Pal(A, 1)) / 4.11)
Pal(A, 0) = CHR$(ASC(Pal(A, 0)) / 4.11)


NEXT
END IF


DEF SEG = &HA000

SELECT CASE BPP
			CASE 1
			FOR A = 0 TO 1
			OUT &H3C9, INT(ASC(Pal(A, 0)) / 4)
			OUT &H3C9, INT(ASC(Pal(A, 1)) / 4)
			OUT &H3C9, INT(ASC(Pal(A, 2)) / 4)
			NEXT


			SEEK #FileNum, PDOffSet + 1
			FOR y = SizeY - 1 TO 0 STEP -1

			Pix$ = SPACE$((SizeX / 8))
			GET #FileNum, , Pix$
			FOR x = 0 TO SizeX - 1 STEP 8
			Bits$ = Bit$(MID$(Pix$, (x) / 8 + 1, 1))
						FOR CBit = 1 TO 8
						PSET (x + CBit - 1, y), VAL(MID$(Bits$, CBit, 1))
						NEXT
			NEXT
			NEXT
			CASE 4
			OUT &H3C6, &HFF
			OUT &H3C8, 0
			FOR A = 0 TO 2 ^ BPP - 1
			OUT &H3C9, INT(ASC(Pal(A, 0)) / 4)
			OUT &H3C9, INT(ASC(Pal(A, 1)) / 4)
			OUT &H3C9, INT(ASC(Pal(A, 2)) / 4)
			NEXT
			SEEK #FileNum, PDOffSet + 1
			FOR y = SizeY - 1 TO 0 STEP -1
			FOR x = 0 TO SizeX - 1 STEP 2
			Pix$ = " "
			GET #FileNum, , Pix$
			Bits$ = Bit$(Pix$)
			P1 = Bin2Dec(LEFT$(Bits$, 4))
			P2 = Bin2Dec(RIGHT$(Bits$, 4))




			'LINE (X / (SizeX / 640), Y / (SizeY / 480))-STEP(-5, -5), P1, BF
			'LINE ((X + 1) / (SizeX / 640), Y / (SizeY / 480))-STEP(-5, -5), P2, BF
			PSET (x, y), P1
			PSET (x + 1, y), P2
			'POKE X + Y * 320&, P1
			'POKE (X + 1) + Y * 320&, P2

			NEXT
			NEXT


			CASE 8
			
			OUT &H3C6, &HFF
			OUT &H3C8, 0
			FOR A = 0 TO 2 ^ BPP - 1
			OUT &H3C9, 0
			OUT &H3C9, 0
			OUT &H3C9, 0
			NEXT
			SEEK #FileNum, PDOffSet + 1
			'Pix$ = SPACE$(SizeX)
			'lin$ = SPACE$((INT((picwidth - 1) / 4) + 1) * 4)
			Pix$ = SPACE$((INT((SizeX - 1) / 4) + 1) * 4)

XScale! = SizeX / 320
YScale! = SizeY / 200

			FOR y = SizeY - 1 TO 0 STEP -1
			'Null$ = " ": GET #FileNum, , Null$
			GET #FileNum, , Pix$
						FOR x = SizeX - 1 TO 0 STEP -1
						'PSET (x + XOFF, y + YOFF), ASC(MID$(Pix$, x + 1, 1))
						IF 0 <= x AND x < 320 AND 0 <= y AND y < 200 THEN POKE x + y * 320&, ASC(MID$(Pix$, x + 1, 1))
						'LINE ((X + 1) / XScale!, (Y + 1) / YScale!)-((X - 1) / XScale!, 0), ASC(MID$(Pix$, X + 1, 1)), BF
						'LINE (X, 0)-(X, Y), ASC(MID$(Pix$, X + 1, 1))
						NEXT
			NEXT


			CASE 24

			OUT &H3C6, &HFF
			OUT &H3C8, 0
			FOR A = 0 TO 255
			OUT &H3C9, A / 4.11
			OUT &H3C9, A / 4.11
			OUT &H3C9, A / 4.11
			NEXT

			FOR y = SizeY - 1 TO 0 STEP -1
			FOR x = 0 TO SizeX - 1
			R$ = " "
			G$ = " "
			B$ = " "

			GET #FileNum, , R$
			GET #FileNum, , G$
			GET #FileNum, , B$

			Pixel = (ASC(R$) + ASC(G$) + ASC(B$)) / 3
			PSET (x, y), Pixel
			NEXT
			NEXT


			CASE ELSE
			SCREEN 0
			WIDTH 80, 25
			PRINT "Can't Handle" + STR$(BPP) + " Bit(s) Per Pixel"
END SELECT

DEF SEG
CLOSE #FileNum
END SUB

SUB LoadFSP (File$)
	DEF SEG = &HA000
		BLOAD File$, 0
	DEF SEG

	OPEN File$ FOR BINARY AS #1
		SEEK #1, 64004
		Pall$ = SPACE$(256 * 3)
		GET #1, , Pall$
	CLOSE #1
	FOR C = 0 TO 255
		Pal(C, 0) = MID$(Pall$, C * 3 + 1, 1)
		Pal(C, 1) = MID$(Pall$, C * 3 + 2, 1)
		Pal(C, 2) = MID$(Pall$, C * 3 + 3, 1)
	NEXT
END SUB

SUB Menu ()
SMenu:
LoadFSP "Logo.FSP"
	CBack = 3
GOSUB MenuPipes
Font 5 * 9 + 2, 9 * 9 + 2, 0, "-2New Game^-1Multi Player^-0Options^+1Veiw high scores^+2About^+3Quit"

FadeIn
RMenu:
GOSUB MenuPipes
Font 5 * 9 + 2, 9 * 9 + 2, 0, "-2New Game^-1Multi Player^-0Options^+1Veiw high scores^+2About^+3Quit"

	SELECT CASE Choice(4, 9, 6, RMAt)
		CASE 1
			GOSUB GameStart
		CASE 2
			GOTO RMenu
		CASE 3
			GOSUB Options
			GOTO RMenu
		CASE 4
			GOTO RMenu
		CASE 5
			GOSUB About
			GOSUB RMenu
		CASE 6, 0
			EXIT SUB
	END SELECT
GOTO RMenu

About:

	GOSUB MenuPipes
	Font 5 * 9 + 2, 9 * 9 + 2, 0, "-2NeTris V3.0^-1Created by +0Ximmer^+1Copyright +219+398 +0V-2H+4Net^^^^^+1Press -1" + CHR$(34) + "Enter" + CHR$(34) + "+1 key to continue"

	A = Choice(4, 16, 1, 1)

	RETURN

Options:
ROptions:
	CBack = 3
	GOSUB MenuPipes
	IF CFG.CSound THEN CSND$ = "+8On" ELSE CSND$ = "+8Off"
	IF CFG.CMusic THEN Mus$ = "+8On" ELSE Mus$ = "+8Off"
	
	Font 5 * 9 + 2, 9 * 9 + 2, 0, "-2Sound " + CSND$ + "^-1Music " + Mus$ + "^+0Keyboard Config^+1Volume Control"
		SELECT CASE Choice(4, 9, 3, OPAt)
			CASE 0
	RETURN
			CASE 1
	IF CFG.CSound THEN CFG.CSound = False ELSE CFG.CSound = True
			CASE 2
	IF CFG.CMusic THEN CFG.CMusic = False ELSE CFG.CMusic = True
			CASE 3
	GOSUB Keyboard
		END SELECT
	GOTO ROptions

Keyboard:
	CBack = 3
RKeyboard:
	GOSUB MenuPipes

	CF1$ = CFG.Flip1
	CF2$ = CFG.Flip2
	CRT$ = CFG.RT
	CLT$ = CFG.LT
	CDP$ = CFG.Drop
	CFL$ = CFG.Fall
	Font 5 * 9 + 2, 9 * 9 + 2, 0, "-2Flip Right:    ^-1Flip Left:     ^+0Move Right:    ^+1Move Left:     ^+2Drop:          ^+3Fall:         "
	Font 110, 9 * 9 + 2, 0, "+2" + CF1$ + "^" + CF2$ + "^" + CRT$ + "^" + CLT$ + "^" + CDP$ + "^" + CFL$
		SELECT CASE Choice(4, 9, 6, KBAt)
			CASE 0
	RETURN
			CASE 1
	NewKey CFG.Flip1
			CASE 2
	NewKey CFG.Flip2
			CASE 3
	NewKey CFG.RT
			CASE 4
	NewKey CFG.LT
			CASE 5
	NewKey CFG.Drop
			CASE 6
	NewKey CFG.Fall
		END SELECT
	GOTO RKeyboard


MenuPipes:
RESTORE Menu
	FOR y = 0 TO 21
		READ A$
		FOR x = 0 TO 34
			A = VAL(MID$(A$, x + 1, 1))
			SELECT CASE A
	CASE 1 TO 6
		PUT (x * 9, y * 9), Pipes(0, A - 1), PSET
	CASE 7
		BBlock x - 11, y
			END SELECT
		NEXT
	NEXT
RETURN
GameStart:
RGS:
	CBack = 3
	GOSUB MenuPipes
	Font 5 * 9 + 2, 9 * 9 + 2, 0, "-2Level   -1" + STR$(11 - Level) + "^-0Start"
		SELECT CASE Choice(4, 9, 2, GSAt)
			CASE 0
				GOTO RMenu
			CASE 1
				Level = Level - 1
				IF Level = 0 THEN Level = 10
			CASE 2
				MultiPlayer = 0
				FadeOut
				ERASE PField
				RefreshField
				PlayGame
				FadeOut
				Restorepal
				FOR A = 1 TO 8
					A$ = "GAME OVER"
					Font (80 - ((LEN(A$) * 4) * A)) / 2 + 130, 100, A, "+" + LTRIM$(STR$(A)) + A$
					Delay .1
				NEXT
				SLEEP 1
				FadeOut
				GOTO SMenu
		END SELECT
	GOTO RGS

RETURN
END SUB

SUB NewKey (NKey AS STRING)
DIM NKey2 AS STRING * 2
Done = 0

	Font 5 * 9 + 2, 15 * 9 + 2, 0, "+1Key"

DO
Key$ = IKey$
IF Key$ <> "" THEN IF Key$ <> CHR$(27) THEN NKey2 = Key$: Done = -1
LOOP UNTIL Key$ = CHR$(27) OR Done
IF Key$ <> CHR$(27) THEN NKey = UCASE$(NKey2)
END SUB

FUNCTION PlacePiece (x, y, C)
FOR A = 1 TO 4
	cx = CPiece(A, 1) + x
	CY = CPiece(A, 2) + y
	IF CY >= 0 THEN
		PField(cx, CY) = C + 1
	ELSE
		PlacePiece = 1
	END IF
NEXT
END FUNCTION

SUB PlayGame ()

	DIM K AS STRING * 2

	CBack = INT(RND * 5)

	RESTORE PlayPipes
		FOR y = 0 TO 21
			READ A$
			FOR x = 0 TO 34
				A = VAL(MID$(A$, x + 1, 1))
				SELECT CASE A
		CASE 1 TO 6
			PUT (x * 9, y * 9), Pipes(0, A - 1), PSET
		CASE 7
			BBlock x - 11, y
				END SELECT
			NEXT
		NEXT

		PieceOver = 0
		A = INT(RND * 7) + 1
		SELECT CASE A
			CASE 1: RESTORE P1
			CASE 2: RESTORE P2
			CASE 3: RESTORE P3
			CASE 4: RESTORE P4
			CASE 5: RESTORE P5
			CASE 6: RESTORE P6
			CASE 7: RESTORE P7
		END SELECT
		FOR A = 1 TO 4
			READ NPiece(A, 1)
			READ NPiece(A, 2)
		NEXT
		READ NClr

	Score = 0
	Lines = 0
	'Level = 10

	Stats

	RField

	FadeIn

	DO
		PieceOver = 0
		EraseNext
		A = INT(RND * 7) + 1
		SELECT CASE A
			CASE 1: RESTORE P1
			CASE 2: RESTORE P2
			CASE 3: RESTORE P3
			CASE 4: RESTORE P4
			CASE 5: RESTORE P5
			CASE 6: RESTORE P6
			CASE 7: RESTORE P7
		END SELECT
		FOR A = 1 TO 4
			CPiece(A, 1) = NPiece(A, 1)
			CPiece(A, 2) = NPiece(A, 2)
		NEXT
			CClr = NClr
		FOR A = 1 TO 4
			READ NPiece(A, 1)
			READ NPiece(A, 2)
		NEXT
		READ NClr
		PutNext
		y = -1
		x = 5
		Drop = 0

		DO
			MV$ = ""
			K = UCASE$(IKey$)
			SELECT CASE K
			CASE CHR$(27) + " ": EXIT SUB
			CASE CFG.RT: IF Plr.Virus <> 3 THEN MV$ = "R" ELSE MV$ = "L"
			CASE CFG.LT: IF Plr.Virus <> 3 THEN MV$ = "L" ELSE MV$ = "R"
			CASE CFG.Drop: Drop = 1
			CASE CFG.Fall: Fall = 1
			CASE CFG.Flip1
				FlipC
				IF Collision(x, y) = 0 THEN
		FlipCC
		ErasePiece x, y
		FlipC
		PutPiece x, y, CClr
				ELSE
		FlipCC
				END IF
			CASE CFG.Flip2
				FlipCC
				IF Collision(x, y) = 0 THEN
		FlipC
		ErasePiece x, y
		FlipCC
		PutPiece x, y, CClr
				ELSE
		FlipC
				END IF
			END SELECT



			SELECT CASE MV$
				CASE "R"
		IF Collision(x + 1, y) = 0 THEN
			ErasePiece x, y
			x = x + 1
			PutPiece x, y, CClr
		END IF
				CASE "L"
		IF Collision(x - 1, y) = 0 THEN
			ErasePiece x, y
			x = x - 1
			PutPiece x, y, CClr
		END IF
			END SELECT


			IF Click >= Level OR Drop = 1 OR Fall = 1 THEN

				IF Drop = 1 THEN
					ErasePiece x, y
					WHILE Collision(x, y + 1) = 0
						y = y + 1
					WEND
					PutPiece x, y, CClr
				END IF


				Fall = 0
				Click = 0
				IF Collision(x, y + 1) = 0 THEN
					ErasePiece x, y
					y = y + 1
					PutPiece x, y, CClr
				ELSE
					PieceOver = 1
				END IF
			END IF
			Click = Click + 1
			Delay .01
		LOOP UNTIL PieceOver = 1
		GameOver = PlacePiece(x, y, CClr)
		CheckLine
		Stats
	LOOP UNTIL GameOver = 1
	EQuake 10
END SUB

SUB PSPR (XS AS INTEGER, YS AS INTEGER, Sprite$, CIndex, SC)
	IF SC = 0 THEN SC = 1
	
	XSize = ASC(MID$(Sprite$, 1, 1))
	YSize = ASC(MID$(Sprite$, 2, 1))
	Trans = ASC(MID$(Sprite$, 3, 1))
	Z = 3
	DEF SEG = &HA000
	IF SC = 1 THEN
		FOR y = YS TO YS + YSize
			FOR x = XS TO XS + XSize
				Z = Z + 1
				CLR = ASC(MID$(Sprite$, Z, 1))
				IF Trans THEN
					IF CLR <> 0 AND CLR + (CIndex * 16) < 255 AND CLR + (CIndex * 16) > 0 AND x > -1 AND x < 320 AND y > -1 AND y < 200 THEN POKE x + y * 320&, CLR + (CIndex * 16)
				ELSE
					IF x > -1 AND x < 320 AND y > -1 AND y < 200 THEN POKE x + y * 320&, CLR + CIndex
				END IF
			NEXT
		NEXT
	ELSE
		FOR y = INT(YS / SC) - 1 TO INT(YS / SC) - 1 + YSize
			FOR x = INT(XS / SC) - 1 TO INT(XS / SC) - 1 + XSize
				Z = Z + 1
				CLR = ASC(MID$(Sprite$, Z, 1))
				IF Trans THEN
					IF CLR <> 0 THEN LINE (x * SC, y * SC)-STEP(SC - 1, SC - 1), CLR + (CIndex * 16), BF
				ELSE
					LINE (x * SC, y * SC)-STEP(SC - 1, SC - 1), CLR + (CIndex * 16), BF
				END IF

			NEXT
		NEXT
	END IF
		

	DEF SEG
END SUB

SUB PutNext ()
FOR A = 1 TO 4
	Block NPiece(A, 1) - 9, NPiece(A, 2) + 7, NClr
NEXT
END SUB

SUB PutPiece (x, y, C)
FOR A = 1 TO 4
Block CPiece(A, 1) + x, CPiece(A, 2) + y, C
NEXT
END SUB

SUB RefreshField ()
	RESTORE FieldD
	FOR y = -1 TO 21
		READ A$
		FOR x = 0 TO 11
			PField(x, y) = VAL(MID$(A$, x + 1, 1))
		NEXT
	NEXT
END SUB

SUB Restorepal ()
	FOR C = 0 TO 255
		R = ASC(Pal(C, 0))
		G = ASC(Pal(C, 1))
		B = ASC(Pal(C, 2))
		OUT &H3C8, C
		OUT &H3C9, R
		OUT &H3C9, G
		OUT &H3C9, B
	NEXT
END SUB

SUB RField ()
	FOR y = 0 TO 19
		FOR x = 1 TO 10
			IF PField(x, y) <> 0 THEN
	BBlock x, y
	Block x, y, PField(x, y) - 1
			ELSE
	BBlock x, y
			END IF
		NEXT
	NEXT
END SUB

SUB Stats ()
CY = 9
LINE (9, 9)-STEP(9 * 9, 3 * 9), 0, BF
Font 9, CY, 0, "Score:" + STR$(Score) + "^"
Font 9, CY, 0, "Lines:" + STR$(Lines) + "^"
Font 9, CY, 0, "Level:" + STR$(11 - Level) + "^"

END SUB

