'This game is freeware by Sami Kystil (hiteck in IRC, Kemple OY in MBNet)
'Soundsystem adapted from Mike Huff's DMAPlay
'Any questions, comments, etc. can be sent to:

'     hiteck@freenet.hut.fi
'     kemple.oy@mbnet.fi


'This source can be freely used as long
'as the original author is mentioned.


'Requirements:
'-------------

'   Minimum hardware: 486 with mouse

'   Recommended hardware: Pentium or better with mouse

'   Hardware programmed on: Cyrix 6x86 P150+

'This game is synchronized with your monitor's refresh signal.
'If the game is too fast and you've changed the refresh rate
'in the 320x200x256-mode, then change it back to normal and the
'game should run at normal speed.




'Revision history:
'-----------------

'v0.00000001 alpha
'-----------------
'Got the basic routines together.
'Not even playable.

'v0.5 beta
'---------
'Made the game engine
'Only 1 level (non-modifiable)

'v0.6
'----
'Made a menu system
'Made startup sequence display
'Made the startup logo with Paint Shop Pro v4.12
'Added a highscore-list

'v1.0
'----
'First "real" version :)
'Adapted DMA-sound support from Mike Huff's DMAPlay
'Brainstormed the 10 levels
'Added some fading-stuff
'Added a fire-effect to the highscore-list
'Added a Cheat Code ;)

'v1.1
'----
'The logo loads A LOT faster than before - Before: 4 sec. - Now: F A S T
'Fixed LOTSA bugs with the game engine and the sound system
'Now plays a startup test sound
'A more comprehencive startup display
'Rewrote the whole highscore-list
'Rewrote the Fire-effect (MUCH faster, and finally with a realistic palette ;)
'Made the Fade-effects a LOT faster
'Tweaked the Smooth SUB
'Lots of other bugfixes






'For all you coders (and why not everyone else) out there:
'-------------------------------------------------------

'Try to find the cheat code...     (Shouldn't be 2 hard ;)


'(Sorry for lack of comments)








DECLARE SUB WavPlay (File$, Freq&)
DECLARE SUB Help ()
DECLARE SUB TheEnd ()
DECLARE SUB Makefirepalette (MaxColors)
DECLARE SUB HiScores (Points!)
DECLARE SUB Scroller (Text$, Col!)
DECLARE SUB FadePRINT (y!, x!, Text$, StartCol!, ColStep!)
DECLARE SUB ShowLogo ()
DECLARE SUB GetSprites ()
DECLARE SUB Checkfiles ()
DECLARE SUB fade (r&, g&, B&)
DECLARE SUB Fadeback ()
DECLARE SUB Smooth (xpos&, ypos&, XLen!, YLen!, Times!, Rate!, Lowest)
DECLARE SUB Makepalette ()
DECLARE SUB PlayWav (Filename$, Freq&)
DECLARE SUB DMAPlay (Segment&, Offset&, Length&, Freq&)
DECLARE SUB SpeakerState (OnOff%)
DECLARE SUB WriteDSP (byte%)
DECLARE SUB GetBlaster (DMA%, Baseport%, IRQ%)
DECLARE FUNCTION ResetDSP% ()
DECLARE FUNCTION ReadDSP% ()
DECLARE FUNCTION ReadDAC% ()
DECLARE FUNCTION DMADone% ()




SCREEN 0: CLS
COLOR 15, 4
PRINT "                               SmashOut v1.1                                    "
COLOR 14, 0
PRINT
PRINT " System startup"
COLOR 7
PRINT "   Declaring variables...";
DIM SHARED Blocks
DIM SHARED Strength
DIM SHARED Code
DIM SHARED Level
DIM SHARED Score
Blocks = 10 * 18
Code = 0
Level = 1
Strength = 10
DIM SHARED Lauta AS INTEGER
Lauta = 50
DIM SHARED ScoredPoints AS INTEGER
DIM SHARED ScorePos AS INTEGER
DIM SHARED HiScoreName$(10)
DIM SHARED HiScore(10) AS INTEGER
DIM SHARED pic AS STRING * 199
DIM SHARED Board(Lauta * 5) AS INTEGER
DIM SHARED Pallo(6 * 6) AS INTEGER
DIM SHARED Pallo2(6 * 6) AS INTEGER
DIM SHARED Pikkulauta(8 * 4)
DIM SHARED Palikka1(8 * 16) AS INTEGER
DIM SHARED Palikka2(8 * 16) AS INTEGER
DIM SHARED Palikka3(8 * 16) AS INTEGER
DIM SHARED Palikka4(8 * 16) AS INTEGER
DIM SHARED Palikka1B(8 * 16) AS INTEGER
DIM SHARED Palikka2B(8 * 16) AS INTEGER
DIM SHARED Palikka3B(8 * 16) AS INTEGER
DIM SHARED Palikka4B(8 * 16) AS INTEGER
DIM SHARED Bx(Blocks) AS INTEGER
DIM SHARED by(Blocks) AS INTEGER
DIM SHARED BType(Blocks)  AS INTEGER
DIM SHARED BEnergy(Blocks) AS INTEGER
DIM SHARED BMaxEnergy(Blocks) AS INTEGER
DIM SHARED cols1(256) AS INTEGER
DIM SHARED cols2(256) AS INTEGER
DIM SHARED cols3(256) AS INTEGER
DIM SHARED cols4(256) AS INTEGER
DIM SHARED cols5(256) AS INTEGER
DIM SHARED cols6(256) AS INTEGER
DIM SHARED Kursori(10 * 10) AS INTEGER
DIM SHARED Kursorimaski(10 * 10)
DIM SHARED Kursoritausta(10 * 10)
DIM SHARED Baseport%, IRQ%, Channel%
DIM SHARED WavBuffer(1)  AS STRING * 32767
CONST DSPVersion! = 3

PRINT "Done"
PRINT "    - Available string space:"; FRE("")
PRINT "    - Unused stack space:"; FRE(-2)
PRINT "    - Available array space:"; FRE(-1)


PRINT "   Checking for necessary files...";
Checkfiles
PRINT "Done"
COLOR 14
PRINT " Control startup"
COLOR 7
PRINT "   Loading mouse driver...";







RANDOMIZE TIMER
DIM SHARED Hiiri$
Hiiri$ = SPACE$(57)
FOR i% = 1 TO 57
  READ a$
  h$ = CHR$(VAL("&H" + a$))
  MID$(Hiiri$, i%, 1) = h$
NEXT i%

DATA 55, 89, E5, 8B, 5E, 0C, 8B, 07, 50, 8B, 5E, 0A, 8B, 07, 50, 8B
DATA 5E, 08, 8B, 0F, 8B, 5E, 06, 8B, 17, 5B, 58, 1E, 07, CD, 33, 53
DATA 8B, 5E, 0C, 89, 07, 58, 8B, 5E, 0A, 89, 07, 8B, 5E, 08, 89, 0F
DATA 8B, 5E, 06, 89, 17, 5D, CA, 08, 00

GOSUB Hiiritarkista
napit% = Hiiritarkista%
IF (napit% = 0) THEN
  PRINT "Mouse not found!"
  END
END IF


PRINT "Done"
PRINT "   Setting mouse borders...";
hiirix1% = 0
hiirix2% = 640 - 8
hiiriy1% = 0
hiiriy2% = 200 - 8
GOSUB Hiirirajat
PRINT "Done"
PRINT "   Enabling mouse...";
GOSUB hiiriesiin
PRINT "Done"
PRINT "   Reading mouse position: "
COLOR 14
PRINT " Audio startup"
COLOR 7
PRINT "   Parsing BLASTER-enviroment variable...";
PRINT "Done"
GetBlaster Channel%, Baseport%, IRQ%
PRINT "   Sound Blaster(tm) or compatible found at:"
PRINT "    - Baseport:"; Baseport%
PRINT "    - Interrupt:"; IRQ%
PRINT "    - DMA-channel:"; Channel%
PRINT "   Playing test sound "; CHR$(34); "TESTSND.WAV"; CHR$(34); "...";
WavPlay "testsnd.wav", 11025
PRINT "Done"
COLOR 14
PRINT
PRINT " Press any key or click mouse button to continue"
DO
GOSUB Hiirilue
IF Hiiriv% = -1 THEN EXIT DO
IF Hiirio% = -1 THEN EXIT DO
IF Hiirik% = -1 THEN EXIT DO
COLOR 7
LOCATE 13, 30: PRINT "x:"; HiiriX% \ 8 + 1, "y:"; HiiriY% \ 8 + 1; "     "
LOOP UNTIL INKEY$ <> ""


GOSUB Hiiripiiloon

SCREEN 13
Restart:
hiirix1% = 0
hiirix2% = 640 - 8
hiiriy1% = 0
hiiriy2% = 200 - 8
GOSUB Hiirirajat

FOR i = 0 TO 255
  OUT (&H3C8), i - 1
  OUT (&H3C9), 0
  OUT (&H3C9), 0
  OUT (&H3C9), 0
NEXT
GetSprites
CLS

RESTORE Palettedata
OUT (&H3C8), 0
FOR i = 0 TO 255
  OUT (&H3C8), i - 1
  READ PRed, PGreen, PBlue
  OUT (&H3C9), PRed
  OUT (&H3C9), PGreen
  OUT (&H3C9), PBlue
NEXT

ShowLogo
DO
  GOSUB Hiirilue
  IF Hiiriv% = -1 THEN EXIT DO
  IF Hiirio% = -1 THEN EXIT DO
  IF Hiirik% = -1 THEN EXIT DO
LOOP UNTIL INKEY$ <> ""



Makepalette
GET (0, 0)-(10, 10), Kursoritausta
LINE (0, 0)-(5, 10), 40
LINE (0, 0)-(10, 5), 40
LINE (5, 10)-(10, 5), 40
PAINT (3, 3), 63, 40
Smooth 0, 0, 10, 10, 1, 1, 0
GET (0, 0)-(10, 10), Kursori

FOR y = 0 TO 10
  FOR x = 0 TO 10
    IF POINT(x, y) <> 0 THEN PSET (x, y), 0 ELSE PSET (x, y), 255
  NEXT
NEXT

GET (0, 0)-(10, 10), Kursorimaski
PUT (0, 0), Kursoritausta, PSET


LINE (80, 50)-(240, 170), 128, B
LINE (81, 51)-(239, 169), 108, B
LINE (82, 52)-(238, 168), 88, B
LINE (83, 53)-(237, 167), 0, BF

COLOR 30
LOCATE 10, 14
PRINT ""
LOCATE 13, 14
PRINT ""
LOCATE 16, 14
PRINT ""
LOCATE 19, 14
PRINT ""
FadePRINT 10, 17, "New game", 192, 6
FadePRINT 13, 17, "Hiscores", 192, 6
FadePRINT 16, 17, "Help", 192, 12
FadePRINT 19, 17, "Quit", 192, 12


GOSUB Hiirilue
x = HiiriX% \ 2
y = HiiriY%
IF x > 309 THEN x = 309
IF y > 189 THEN y = 189
GET (x, y)-(x + 10, y + 10), Kursoritausta


DO
  PUT (x, y), Kursoritausta, PSET
  GOSUB Hiirilue
  x = HiiriX% \ 2
  y = HiiriY%

  IF x > 309 THEN x = 309
  IF y > 189 THEN y = 189
  COLOR 30
  LOCATE 10, 14
  PRINT ""
  LOCATE 13, 14
  PRINT ""
  LOCATE 16, 14
  PRINT ""
  LOCATE 19, 14
  PRINT ""
  Selection = 0
  IF DMADone% THEN dummy = ResetDSP

  IF NOT Selection = 1 AND y \ 8 + 1 = 10 AND x \ 8 + 1 > 13 AND x \ 8 + 1 < 25 THEN LOCATE 10, 14: COLOR 63: PRINT "": Selection = 1: FadePRINT 10, 17, "New game", 63, 6
  IF NOT Selection = 2 AND y \ 8 + 1 = 13 AND x \ 8 + 1 > 13 AND x \ 8 + 1 < 25 THEN LOCATE 13, 14: COLOR 63: PRINT "": Selection = 2: FadePRINT 13, 17, "Hiscores", 63, 6
  IF NOT Selection = 3 AND y \ 8 + 1 = 16 AND x \ 8 + 1 > 13 AND x \ 8 + 1 < 25 THEN LOCATE 16, 14: COLOR 63: PRINT "": Selection = 3: FadePRINT 16, 17, "Help", 63, 12
  IF NOT Selection = 4 AND y \ 8 + 1 = 19 AND x \ 8 + 1 > 13 AND x \ 8 + 1 < 25 THEN LOCATE 19, 14: COLOR 63: PRINT "": Selection = 4: FadePRINT 19, 17, "Quit", 63, 12
  IF Selection <> OldSel AND Selection <> 0 THEN WavPlay "bounce.wav", 11025
 
  IF Selection <> OldSel THEN
    FadePRINT 10, 17, "New game", 192, 6
    FadePRINT 13, 17, "Hiscores", 192, 6
    FadePRINT 16, 17, "Help", 192, 12
    FadePRINT 19, 17, "Quit", 192, 12
  END IF
  OldSel = Selection
  
 
  IF Hiiriv% = -1 AND Selection <> 0 THEN EXIT DO
  GET (x, y)-(x + 10, y + 10), Kursoritausta

  PUT (x, y), Kursorimaski, AND
  PUT (x, y), Kursori, OR

  WAIT &H3DA, 8

LOOP


WavPlay "flump.wav", 11025
Level = 1

IF Selection = 3 THEN Help: CLS : Makepalette: GOTO Restart
fade 0, 0, 0
CLS
Makepalette
IF Selection = 4 THEN SYSTEM
IF Selection = 2 THEN HiScores (-1): GOTO Restart


OUT (&H3C8), 0
FOR x = 0 TO 255
  OUT (&H3C8), x + 1
  cols1(x) = INP(&H3C9)
  cols2(x) = INP(&H3C9)
  cols3(x) = INP(&H3C9)

  cols4(x) = cols1(x)
  cols5(x) = cols2(x)
  cols6(x) = cols3(x)
NEXT
Score = 0

NextLevel:
IF Level = 11 THEN TheEnd: GOTO Restart

i = 0
Blocks = 0

SELECT CASE Level
CASE IS = 1
  RESTORE Level1
CASE IS = 2
  RESTORE Level2
CASE IS = 3
  RESTORE Level3
CASE IS = 4
  RESTORE Level4
CASE IS = 5
  RESTORE Level5
CASE IS = 6
  RESTORE Level6
CASE IS = 7
  RESTORE Level7
CASE IS = 8
  RESTORE Level8
CASE IS = 9
  RESTORE Level9
CASE IS = 10
  RESTORE Level10
END SELECT

WavPlay "hiscore.wav", 11025
Scroller "Entering level" + STR$(Level), 192
CLS

FOR y = 1 TO 10
  FOR x = 1 TO 18
    READ BType(i)
    IF BType(i) <> 0 THEN
      i = Blocks
      Bx(i) = x * 17 - 17
      by(i) = y * 10 + 30
      Blocks = Blocks + 1
      SELECT CASE BType(i)
      CASE IS = 1
        PUT (Bx(i), by(i)), Palikka1, PSET
        BEnergy(i) = 25
        BMaxEnergy(i) = 25
      CASE IS = 2
        PUT (Bx(i), by(i)), Palikka2, PSET
        BEnergy(i) = 50
        BMaxEnergy(i) = 50
      CASE IS = 3
        PUT (Bx(i), by(i)), Palikka3, PSET
        BEnergy(i) = 75
        BMaxEnergy(i) = 75
      CASE IS = 4
        PUT (Bx(i), by(i)), Palikka4, PSET
        BEnergy(i) = 125
        BMaxEnergy(i) = 125
      END SELECT
      i = i + 1
    END IF
  NEXT
NEXT


COLOR 255
LOCATE 1, 1: PRINT " Score: "
LOCATE 1, 17: PRINT " Lives: "
FOR y& = 10 TO 0 STEP -1
  FOR x& = 0 TO 319
    IF POINT(x&, y&) = 0 THEN PSET (x&, y&), 200 + RND * 10 ELSE PSET (x&, y& + 2), POINT(x&, y&): PSET (x&, y&), 200 + RND * 10
  NEXT
NEXT
COLOR 193
LOCATE 1, 8: PRINT "       "
LOCATE 1, 24: PRINT "          "
Smooth 0, 0, 319, 12, 1, 1, 193

Lives = 4
BrokenBlocks = 0
DoitAgain:

hiirix1% = 140 - Lauta / 2
hiirix2% = 140 - Lauta / 2
hiiriy1% = 192
hiiriy2% = 192
GOSUB Hiirirajat
COLOR 128: LOCATE 1, 8: PRINT Score


x = 140 - Lauta / 2
y = 190
Px = 140
Py = 30
GET (Px, Py)-(Px + 4, Py + 4), Pallo2
PUT (Px, Py), Pallo, PSET
FOR i = 1 TO Lives
  PUT (i * 18 + (22 * 8), 3), Pikkulauta, PSET
NEXT




COLOR 63
LOCATE 19, 18: PRINT "-3-"
start! = TIMER
DO
  PUT (x, y - YOffset), Board, PSET
LOOP UNTIL TIMER > start! + .5
Smooth 16 * 8, 18 * 8, 32, 8, 14, 1, 0

COLOR 63
LOCATE 19, 18: PRINT "-2-"
start! = TIMER
DO
  PUT (x, y - YOffset), Board, PSET
LOOP UNTIL TIMER > start! + .5
Smooth 16 * 8, 18 * 8, 32, 8, 14, 1, 0

COLOR 63
LOCATE 19, 18: PRINT "-1-"
start! = TIMER
DO
  PUT (x, y - YOffset), Board, PSET
LOOP UNTIL TIMER > start! + .5
Smooth 16 * 8, 18 * 8, 32, 8, 14, 1, 0

COLOR 63
LOCATE 19, 18: PRINT "Go!"
start! = TIMER
DO
  PUT (x, y - YOffset), Board, PSET
LOOP UNTIL TIMER > start! + .5
Smooth 16 * 8, 18 * 8, 32, 8, 14, 1, 0
         
LINE (x, y - YOffset)-(x + Lauta + 1, y - YOffset + 6), 0, BF
GOSUB Hiirilue
x = HiiriX%
y = HiiriY%
Gravity! = .065
Velocity! = 0
XVel! = RND * 2 - 1
y = 190


hiirix1% = 0
hiirix2% = 319 - Lauta - 1
hiiriy1% = 192
hiiriy2% = 192
GOSUB Hiirirajat
Code$ = ""
secretcode$ = "LAMER"


DO
  k$ = UCASE$(INKEY$)
  IF k$ <> "" THEN
    IF k$ = CHR$(27) THEN fade 0, 0, 0: GOTO Restart
    Code$ = Code$ + k$
    CodePos = LEN(Code$)
    IF MID$(secretcode$, CodePos, 1) <> k$ THEN Code$ = ""
    IF Code$ = secretcode$ THEN
      IF Code = 0 THEN Code = 1 ELSE Code = 0
      IF Framecount = 0 THEN WavPlay "cackle.wav", 11025: Framecount = 80
      OUT (&H3C8), 0
      OUT (&H3C9), 63
      OUT (&H3C9), 0
      OUT (&H3C9), 0
      WAIT &H3DA, 8
      OUT (&H3C8), 0
      OUT (&H3C9), 0
      OUT (&H3C9), 0
      OUT (&H3C9), 0
    END IF
  END IF

  GOSUB Hiirilue
  WAIT &H3DA, 8
  LINE (x, y - YOffset)-(x + Lauta + 1, y - YOffset + 6), 0, BF
  IF YOffset > 0 THEN YOffset = YOffset - 1
  PUT (Px, Py), Pallo2, PSET
  x = HiiriX%
  IF Hiiriv% = -1 THEN YOffset = 8
  Py = Py + Velocity!
  Px = Px + XVel!
  IF Py >= 190 - YOffset THEN
    IF Px > x AND Px < x + Lauta THEN
      IF DMADone% THEN dummy = ResetDSP
      IF Framecount = 0 THEN WavPlay "bounce.wav", 11025
      Velocity! = -Velocity!
      IF YOffset > 4 THEN Velocity! = Velocity! - 1
      XVel! = (Px - x - Lauta / 2) / 10
      Py = 190 - YOffset
    ELSE
      IF Code = 0 THEN GOTO Die
      IF DMADone% THEN dummy = ResetDSP
      IF Framecount = 0 THEN WavPlay "bounce.wav", 11025
      Velocity! = -Velocity!
      Py = 190 - YOffset
    END IF
  END IF
  IF Py < 12 THEN
    IF DMADone% THEN dummy = ResetDSP
    IF Framecount = 0 THEN WavPlay "hit.wav", 11025
    Velocity! = -Velocity!
    Py = 12
  END IF
  IF Px >= 313 THEN
    IF DMADone% THEN dummy = ResetDSP
    IF Framecount = 0 THEN WavPlay "hit.wav", 11025
    XVel! = -XVel!
    Px = 313
  END IF
  IF Px < 1 THEN
    IF DMADone% THEN dummy = ResetDSP
    IF Framecount = 0 THEN WavPlay "hit.wav", 11025
    XVel! = -XVel!
    Px = 1
  END IF

 
  GET (Px, Py)-(Px + 4, Py + 4), Pallo2
  PUT (Px, Py), Pallo, PSET
  IF Velocity! < 0 THEN Velocity! = Velocity! + Gravity! * 1.2 ELSE Velocity! = Velocity! + Gravity!

  IF Velocity! > 5 THEN Velocity! = 5
  IF Velocity! < -5 THEN Velocity! = -5
  PUT (x, y - YOffset), Board, PSET

  FOR i = 0 TO Blocks
    IF Px > Bx(i) - 3 AND Px < Bx(i) + 19 AND Py > by(i) - 3 AND Py < by(i) + 11 THEN
      IF NOT BEnergy(i) = -666 THEN BEnergy(i) = BEnergy(i) - Strength: Score = Score + 1: COLOR 128: LOCATE 1, 8: PRINT Score
      IF NOT BEnergy(i) = -666 THEN PUT (Px, Py), Pallo2, PSET
      IF NOT BEnergy(i) = -666 THEN GET (Px, Py)-(Px + 4, Py + 4), Pallo2
      IF BEnergy(i) <= 0 AND NOT BEnergy(i) = -666 THEN BEnergy(i) = -666: LINE (Bx(i), by(i))-(Bx(i) + 16, by(i) + 8), 0, BF: GET (Px, Py)-(Px + 4, Py + 4), Pallo2: Score = Score + 1: COLOR 128: LOCATE 1, 8: PRINT Score: BrokenBlocks = BrokenBlocks + 1: IF Framecount = 0 THEN WavPlay "40mmexp.wav", 22050: Framecount = 100
      IF BEnergy(i) < BMaxEnergy(i) / 2 THEN
      IF BEnergy(i) = -666 GOTO DestroyedBlock
      SELECT CASE BType(i)
      CASE IS = 1
        PUT (Bx(i), by(i)), Palikka1B, PSET
      CASE IS = 2
        PUT (Bx(i), by(i)), Palikka2B, PSET
      CASE IS = 3
        PUT (Bx(i), by(i)), Palikka3B, PSET
      CASE IS = 4
        PUT (Bx(i), by(i)), Palikka4B, PSET
      END SELECT
      ELSE
      SELECT CASE BType(i)
      CASE IS = 1
        PUT (Bx(i), by(i)), Palikka1, PSET
      CASE IS = 2
        PUT (Bx(i), by(i)), Palikka2, PSET
      CASE IS = 3
        PUT (Bx(i), by(i)), Palikka3, PSET
      CASE IS = 4
        PUT (Bx(i), by(i)), Palikka4, PSET
      END SELECT
      END IF

      IF Px <= Bx(i) AND Py >= by(i) - 1 AND Py <= by(i) + 8 + 1 AND XVel! > 0 THEN XVel! = -XVel!
      IF Px >= Bx(i) AND Py >= by(i) - 1 AND Py <= by(i) + 8 + 1 AND XVel! < 0 THEN XVel! = -XVel!
     
      IF Py <= by(i) AND Px >= Bx(i) - 1 AND Px <= Bx(i) + 16 + 1 AND Velocity! > 0 THEN Velocity! = -Velocity!
      IF Py >= by(i) AND Px >= Bx(i) - 1 AND Px <= Bx(i) + 16 + 1 AND Velocity! < 0 THEN Velocity! = -Velocity!

      GET (Px, Py)-(Px + 4, Py + 4), Pallo2
DestroyedBlock:
      IF DMADone% THEN dummy = ResetDSP
      IF NOT BEnergy(i) = -666 AND Framecount = 0 THEN WavPlay "bounce.wav", 11025
    END IF


  NEXT

  IF Framecount > 0 THEN Framecount = Framecount - 1

  IF BrokenBlocks = Blocks THEN Level = Level + 1: Scroller "Level" + STR$(Level - 1) + " cleared! Score:" + STR$(Score), 128: GOTO NextLevel
  IF DMADone% THEN dummy = ResetDSP

LOOP



Die:
IF DMADone% THEN dummy = ResetDSP
WavPlay "40mmexp.wav", 11025
PUT (x, y - YOffset), Board, PSET
fade 63, 63, 63
LINE (x, y - YOffset)-(x + Lauta + 1, y - YOffset + 6), 0, BF
LINE (Lives * 18 + (22 * 8), 2)-(Lives * 18 + (22 * 8) + 8, 5), 193, BF
Fadeback

Lives = Lives - 1
IF Lives = 0 THEN
  fade 0, 0, 0
  CLS
  Makepalette
  WavPlay "Gameover.wav", 8025
  Scroller "Game Over", 63
  HiScores (Score)
  GOTO Restart
END IF


GOTO DoitAgain:

























'------------------ HiiRiSUBiT ------------------

Hiirilue:
  hiiriax% = 3
GOSUB Hiiriajuri
  Hiiriv% = ((hiiribx% AND 1) <> 0)
  Hiirio% = ((hiiribx% AND 2) <> 0)
  Hiirik% = ((hiiribx% AND 4) <> 0)
  HiiriX% = hiiricx%
  HiiriY% = hiiridx%
RETURN


Hiirirajat:
  hiiriax% = 7
  hiiribx% = 0
  hiiricx% = hiirix1%
  hiiridx% = hiirix2%
GOSUB Hiiriajuri
  hiiriax% = 8
  hiiricx% = hiiriy1%
  hiiridx% = hiiriy2%
GOSUB Hiiriajuri
RETURN
                             

Hiiripiiloon:
  hiiriax% = 2: hiiribx% = 0
  hiiricx% = 0: hiiridx% = 0
GOSUB Hiiriajuri
RETURN


hiiriesiin:
  hiiriax% = 1: hiiribx% = 0
  hiiricx% = 0: hiiridx% = 0
GOSUB Hiiriajuri
RETURN

Hiiritarkista:
  hiiriax% = 0
  hiiricx% = 0: hiiridx% = 0
GOSUB Hiiriajuri
  IF (hiiriax% = 0) THEN
    Hiiritarkista% = 0
  ELSEIF (hiiribx% = 3) THEN
    Hiiritarkista% = 3
  ELSEIF (hiiribx% = 0) THEN
    Hiiritarkista% = 1
  ELSE
    Hiiritarkista% = 2
  END IF
RETURN

Hiiriajuri:
  DEF SEG = VARSEG(Hiiri$)
  Hiiri% = SADD(Hiiri$)
  CALL absolute(hiiriax%, hiiribx%, hiiricx%, hiiridx%, Hiiri%) 'Kutsu
RETURN


Palettedata:
DATA 63 , 63 , 63 , 0 , 0 , 0 , 2 , 0 , 0 , 2 , 2 , 2 , 4 , 0 , 0 , 4 , 4 , 4 , 6 , 0 , 0 , 6 , 6 , 6 , 8 , 0 , 0 , 8 , 8 , 8 , 10 , 0 , 0 , 10 , 10 , 10 , 12 , 0 , 0 , 12 , 12 , 12 , 14 , 0 , 0 , 14 , 14 , 14 , 16 , 0 , 0 , 16 , 16 , 16 , 18 , 0 , 0 , 18 , 18 , 18 , 20 , 0 , 0 , 20 , 20 , 20 , 22 , 0 , 0 , 22 , 22 , 22 , 24 , 0 , 0 , 24 , 24 , 24 , 26 , 0 , 0 , 26 , 26 , 26 , 28 , 0 , 0 , 28 , 28 , 28 , 30 , 0 , 0 , 30 , 30 , 30 , 33 , 0 , 0 , 33 , 33 , 33 , 35 , 0 , 0 , 35 , 35 , 35 , 37 , 0 , 0 , 37 , 37 , 37 , 39 , 0 , 0 , 39 , 39 , 39 , 41 , 0 , 0 , 41 , 41 , 41 , 43 , 0 , 0 , 43 , 43 , 43 , 45 , 0 , 0 , 45 , 45 , 45 , 47 , 0 , 0 , 47 , 47 , 47 , 49 , 0 , 0 , 51 , 0 , 0 , 53 , 0 , 0 , 55 , 0 , 0 , 57 , 0 , 0 , 59 , 0 , 0 , 61 , 0 , 0 , 63 , 0 , 0 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63
DATA 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63
DATA 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63
DATA 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 , 63 ,








'Level data  (18x10):

'Level format:
'------------

'   0 = Empty block
'   1 = Red block
'   2 = Green block
'   3 = Blue block
'   4 = White block


Level1:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,2,1,2,1,0,0,0,2,1,2,1,0,0,0,0,0
DATA 0,0,1,2,1,2,0,0,0,1,2,1,2,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


Level2:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,0
DATA 0,0,1,1,1,0,0,0,2,2,2,0,0,0,3,3,3,0
DATA 0,0,1,1,1,0,0,0,2,2,2,0,0,0,3,3,3,0
DATA 0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


Level3:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,1,3,2,1,0,0,0,3,2,1,3,2,1,3,0,0
DATA 0,0,2,1,3,2,0,0,0,1,3,2,1,3,2,1,0,0
DATA 0,0,3,2,1,3,0,0,0,2,1,3,2,1,3,2,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


Level4:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,4,3,3,4,0,0,0,4,3,3,4,0,0,0,0,0
DATA 0,0,4,3,3,4,0,0,0,4,3,3,4,0,0,0,0,0
DATA 0,0,4,3,3,4,0,0,0,4,3,3,4,0,0,0,0,0
DATA 0,0,4,4,4,4,0,0,0,4,4,4,4,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


Level5:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


Level6:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,2,2,2,2,0,0,0,0,0,2,2,2,2,0,0,0,0
DATA 0,2,1,2,0,0,0,4,0,0,0,2,1,2,0,0,0,0
DATA 0,2,2,0,0,0,4,3,4,0,0,0,2,2,0,0,0,0
DATA 0,2,0,0,0,4,3,2,3,4,0,0,0,2,0,0,0,0
DATA 0,0,0,0,4,3,3,3,3,3,4,0,0,0,0,0,0,0
DATA 0,0,0,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


Level7:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0
DATA 0,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,0
DATA 0,4,3,2,2,2,2,2,2,2,2,2,2,2,2,3,4,0
DATA 0,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,0
DATA 0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


Level8:
DATA 0,0,4,4,4,4,4,4,3,3,4,4,4,0,0,0,0,0
DATA 0,0,4,4,4,4,4,4,3,3,4,4,4,0,0,0,0,0
DATA 0,0,4,4,4,4,4,4,3,3,4,4,4,0,0,0,0,0
DATA 0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0
DATA 0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0
DATA 0,0,4,4,4,4,4,4,3,3,4,4,4,0,0,0,0,0
DATA 0,0,4,4,4,4,4,4,3,3,4,4,4,0,0,0,0,0
DATA 0,0,4,4,4,4,4,4,3,3,4,4,4,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


Level9:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,4,2,1,4,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,4,2,1,2,1,4,0,0,0,0,0,0
DATA 0,0,0,0,0,4,2,1,2,1,2,1,4,0,0,0,0,0
DATA 0,0,0,0,4,2,1,2,1,2,1,2,1,4,0,0,0,0
DATA 0,0,0,4,2,1,2,1,2,1,2,1,2,1,4,0,0,0
DATA 0,0,4,2,1,2,1,2,1,2,1,2,1,2,1,4,0,0
DATA 0,4,2,1,2,1,2,1,2,1,2,1,2,1,2,1,4,0
DATA 4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4


Level10:
DATA 0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
DATA 0,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4
DATA 0,4,3,2,2,2,2,2,2,2,2,2,2,2,2,2,3,4
DATA 0,4,3,2,1,1,1,1,1,1,1,1,1,1,1,2,3,4
DATA 0,4,3,2,1,4,4,4,4,4,4,4,4,4,1,2,3,4
DATA 0,4,3,2,1,4,4,4,4,4,4,4,4,4,1,2,3,4
DATA 0,4,3,2,1,1,1,1,1,1,1,1,1,1,1,2,3,4
DATA 0,4,3,2,2,2,2,2,2,2,2,2,2,2,2,2,3,4
DATA 0,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4
DATA 0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4

SUB Checkfiles
OPEN "smash.dat" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "smash.dat"
  PRINT
  PRINT "    * SMASH.DAT not found!"
  END
END IF
CLOSE

OPEN "thebest.dat" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "thebest.dat"
  PRINT
  PRINT "    * THEBEST.DAT not found!"
  END
END IF
CLOSE

OPEN "testsnd.wav" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "testsnd.wav"
  PRINT
  PRINT "    * TESTSND.WAV not found!"
  END
END IF
CLOSE

OPEN "bounce.wav" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "bounce.wav"
  PRINT
  PRINT "    * BOUNCE.WAV not found!"
  END
END IF
CLOSE

OPEN "flump.wav" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "flump.wav"
  PRINT
  PRINT "    * FLUMP.WAV not found!"
  END
END IF
CLOSE

OPEN "hiscore.wav" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "hiscore.wav"
  PRINT
  PRINT "    * HISCORE.WAV not found!"
  END
END IF
CLOSE

OPEN "cackle.wav" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "cackle.wav"
  PRINT
  PRINT "    * CACKLE.WAV not found!"
  END
END IF
CLOSE

OPEN "hit.wav" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "hit.wav"
  PRINT
  PRINT "    * HIT.WAV not found!"
  END
END IF
CLOSE

OPEN "40mmexp.wav" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "40mmexp.wav"
  PRINT
  PRINT "    * 40MMEXP.WAV not found!"
  END
END IF
CLOSE

OPEN "gameover.wav" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "gameover.wav"
  PRINT
  PRINT "    * GAMEOVER.WAV not found!"
  END
END IF
CLOSE

OPEN "haha.wav" FOR BINARY AS #1
IF LOF(1) = 0 THEN
  CLOSE
  KILL "haha.wav"
  PRINT
  PRINT "    * HAHA.WAV not found!"
  END
END IF
CLOSE

END SUB

FUNCTION DMADone%
count% = INP(LenPort%)
Count2% = INP(LenPort%)
count& = CLNG(count% + 1) * CLNG(Count2% + 1)
IF (count& - 1) >= &HFFFF& THEN junk% = INP(DSPDataAvail%): DMADone% = -1
END FUNCTION

SUB DMAPlay (Segment&, Offset&, Length&, Freq&)
' Transfers and plays the contents of the buffer.
Length& = Length& - 1
Page% = 0
MemLoc& = Segment& * 16 + Offset&
SELECT CASE Channel%
    CASE 0
       PgPort% = &H87
       AddPort% = &H0
       LenPort% = &H1
       ModeReg% = &H48
    CASE 1
       PgPort% = &H83
       AddPort% = &H2
       LenPort% = &H3
       ModeReg% = &H49
    CASE 2
       PgPort% = &H81
       AddPort% = &H4
       LenPort% = &H5
       ModeReg% = &H4A
    CASE 3
       PgPort% = &H82
       AddPort% = &H6
       LenPort% = &H7
       ModeReg% = &H4B
    CASE ELSE
       PRINT "DMA channels 0-3 only are supported."
       EXIT SUB
END SELECT

OUT &HA, &H4 + Channel%
OUT &HC, &H0
OUT &HB, ModeReg%
OUT AddPort%, MemLoc& AND &HFF
OUT AddPort%, (MemLoc& AND &HFFFF&) \ &H100
IF (MemLoc& AND 65536) THEN Page% = Page% + 1
IF (MemLoc& AND 131072) THEN Page% = Page% + 2
IF (MemLoc& AND 262144) THEN Page% = Page% + 4
IF (MemLoc& AND 524288) THEN Page% = Page% + 8
OUT PgPort%, Page%
OUT LenPort%, Length& AND &HFF
OUT LenPort%, (Length& AND &HFFFF&) \ &H100
OUT &HA, Channel%

IF Freq& < 23000 THEN
   TimeConst% = 256 - 1000000 \ Freq&
   WriteDSP &H40
   WriteDSP TimeConst%
   WriteDSP &H14
   WriteDSP (Length& AND &HFF)
   WriteDSP ((Length& AND &HFFFF&) \ &H100)
ELSE
   IF DSPVersion! >= 3 THEN
      TimeConst% = ((65536 - 256000000 \ Freq&) AND &HFFFF&) \ &H100
      WriteDSP &H40
      WriteDSP TimeConst%
      WriteDSP (Length& AND &HFF)
      WriteDSP ((Length& AND &HFFFF&) \ &H100)
      WriteDSP &H91
   ELSE
      PRINT "You need a Sound Blaster with a DSP v3.x+ to play at high speed."
      EXIT SUB
   END IF
END IF

END SUB

SUB fade (r&, g&, B&)
Rate& = 1

OUT (&H3C8), 0
FOR x& = 0 TO 255
  OUT (&H3C8), x&
  cols1(x&) = INP(&H3C9)
  cols2(x&) = INP(&H3C9)
  cols3(x&) = INP(&H3C9)
          
  cols4(x&) = cols1(x&)
  cols5(x&) = cols2(x&)
  cols6(x&) = cols3(x&)
NEXT



FOR z& = 0 TO 63
OUT (&H3C8), 0
  FOR y& = 1 TO 256
    IF cols1(y&) > r& THEN cols1(y&) = cols1(y&) - Rate& ELSE IF cols1(y&) < r& THEN cols1(y&) = cols1(y&) + Rate&
    IF cols2(y&) > g& THEN cols2(y&) = cols2(y&) - Rate& ELSE IF cols2(y&) < g& THEN cols2(y&) = cols2(y&) + Rate&
    IF cols3(y&) > B& THEN cols3(y&) = cols3(y&) - Rate& ELSE IF cols3(y&) < B& THEN cols3(y&) = cols3(y&) + Rate&
    OUT (&H3C9), cols1(y&)
    OUT (&H3C9), cols2(y&)
    OUT (&H3C9), cols3(y&)
  NEXT
NEXT


END SUB

SUB Fadeback
Rate& = 1
FOR z& = 0 TO 63
  FOR y& = 1 TO 256
    IF cols1(y&) > cols4(y&) THEN cols1(y&) = cols1(y&) - Rate& ELSE IF cols1(y&) < cols4(y&) THEN cols1(y&) = cols1(y&) + Rate&
    IF cols2(y&) > cols5(y&) THEN cols2(y&) = cols2(y&) - Rate& ELSE IF cols2(y&) < cols5(y&) THEN cols2(y&) = cols2(y&) + Rate&
    IF cols3(y&) > cols6(y&) THEN cols3(y&) = cols3(y&) - Rate& ELSE IF cols3(y&) < cols6(y&) THEN cols3(y&) = cols3(y&) + Rate&
    OUT (&H3C8), y& - 1
    OUT (&H3C9), cols1(y&)
    OUT (&H3C9), cols2(y&)
    OUT (&H3C9), cols3(y&)
  NEXT
NEXT



END SUB

SUB FadePRINT (y, x, Text$, StartCol, ColStep)
Col = StartCol
LOCATE y, x
FOR i = 1 TO LEN(Text$)
  COLOR Col
  PRINT MID$(Text$, i, 1);
  Col = Col - ColStep
  IF Col < 0 THEN Col = 0
NEXT
END SUB

SUB GetBlaster (DMA%, Baseport%, IRQ%)
' This subroutine parses the BLASTER environment string and returns settings.
IF LEN(ENVIRON$("BLASTER")) = 0 THEN PRINT "BLASTER environment variable not set.": END
FOR Length% = 1 TO LEN(ENVIRON$("BLASTER"))
   SELECT CASE MID$(ENVIRON$("BLASTER"), Length%, 1)
      CASE "A"
        Baseport% = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length% + 1, 3))
      CASE "I"
        IRQ% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
      CASE "D"
        DMA% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
   END SELECT
NEXT


END SUB

SUB GetSprites
LINE (1, 1)-(Lauta - 1, y + 5), 63, BF
Smooth 0, 0, Lauta + 1, 6, 1, 1, 0
GET (0, 0)-(Lauta + 1, 6), Board
CLS

LINE (1, 1)-(16, 8), 63, BF
Smooth 0, 0, 16, 8, 1, 1, 0
GET (0, 0)-(16, 8), Palikka1
CLS

PAINT (0, 0), 64, 1
LINE (1, 1)-(16, 8), 128, BF
Smooth 0, 0, 16, 8, 1, 1, 65
GET (0, 0)-(16, 8), Palikka2
CLS

PAINT (0, 0), 129, 1
LINE (1, 1)-(16, 8), 192, BF
Smooth 0, 0, 16, 8, 1, 1, 129
GET (0, 0)-(16, 8), Palikka3
CLS

PAINT (0, 0), 193, 1
LINE (1, 1)-(16, 8), 255, BF
Smooth 0, 0, 16, 8, 1, 1, 193
GET (0, 0)-(16, 8), Palikka4
CLS


'Puoleksi rikkiniset palikat

LINE (1, 1)-(16, 8), 63, BF
FOR i = 0 TO 30
  PSET (RND * 15 + 1, RND * 7 + 1), 0
NEXT
Smooth 0, 0, 16, 8, 1, 1, 0
GET (0, 0)-(16, 8), Palikka1B
CLS


PAINT (0, 0), 64, 1
LINE (1, 1)-(16, 8), 128, BF
FOR i = 0 TO 30
  PSET (RND * 15 + 1, RND * 7 + 1), 63
NEXT
Smooth 0, 0, 16, 8, 1, 1, 64
GET (0, 0)-(16, 8), Palikka2B
CLS


PAINT (0, 0), 129, 1
LINE (1, 1)-(16, 8), 192, BF
FOR i = 0 TO 30
  PSET (RND * 15 + 1, RND * 7 + 1), 129
NEXT
Smooth 0, 0, 16, 8, 1, 1, 129
GET (0, 0)-(16, 8), Palikka3B
CLS


PAINT (0, 0), 193, 1
LINE (1, 1)-(16, 8), 255, BF
FOR i = 0 TO 30
  PSET (RND * 15 + 1, RND * 7 + 1), 193
NEXT
Smooth 0, 0, 16, 8, 1, 1, 193
GET (0, 0)-(16, 8), Palikka4B
CLS





PAINT (0, 0), 193, 129
CIRCLE (3, 3), 1, 255
Smooth 0, 0, 6, 6, 1, 1, 193
GET (1, 1)-(5, 5), Pallo
CLS


CLS
COLOR 63
LOCATE 1, 1: PRINT ""
Smooth 0, 0, 8, 8, 1, 1, 0
GET (0, 3)-(8, 4), Pikkulauta

END SUB

SUB Help
fade 0, 0, 0
CLS
COLOR 63
PRINT STRING$(14, " "); "H E L P"
Smooth 14 * 8, 0, 7 * 8, 8, 1, 1, 0
PRINT
COLOR 192
PRINT "Your mission is to clear 10 levels by"
COLOR 182
PRINT "smashing every block by bouncing a"
COLOR 172
PRINT "ball on the paddle. Move the paddle"
COLOR 162
PRINT "with your mouse and press the left"
COLOR 152
PRINT "mouse button to hit the ball to give"
COLOR 152
PRINT "it some more speed."
COLOR 192
PRINT "There are four different types of"
COLOR 182
PRINT "blocks:"
PRINT
COLOR 63
FadePRINT 12, 1, "        Red - the weakest", 63, 2
FadePRINT 14, 1, "        Green - medium weak", 128, 2
FadePRINT 16, 1, "        Blue - medium tough", 192, 2
FadePRINT 18, 1, "        White - the toughest", 254, 2
PRINT
PRINT
COLOR 192
PRINT "You score 1 point each time you hit"
COLOR 182
PRINT "a block and 10 points when you"
COLOR 172
PRINT "destroy one. You get 5 lives at"
COLOR 162
PRINT "the start of each level."

PUT (0, 11 * 8), Palikka1, PSET
PUT (0, 13 * 8), Palikka2, PSET
PUT (0, 15 * 8), Palikka3, PSET
PUT (0, 17 * 8), Palikka4, PSET
Fadeback

DO: LOOP UNTIL INKEY$ <> ""

fade 0, 0, 0
END SUB

SUB HiScores (Points)

'Fireroutines by Sami Kystil   1997
'May be used freely as long as original author is mentioned.

SHARED ScoredPoints AS INTEGER
DIM Fire(11 * 40) AS INTEGER
ScoredPoints = Points

CLOSE

OPEN "THEBEST.DAT" FOR INPUT AS #1

FOR i = 1 TO 10
  INPUT #1, HiScore(i)
  LINE INPUT #1, HiScoreName$(i)
NEXT
CLOSE #1

ScoredPos = 0
FOR ii = 10 TO 1 STEP -1
  IF ScoredPoints >= HiScore(ii) THEN HiScore(ii) = HiScore(ii - 1): HiScoreName$(ii) = HiScoreName$(ii - 1): ScorePos = ii
NEXT

HiScore(ScorePos) = ScoredPoints

Screenmode = 13   'Ruutumode (Mys 0 toimii!)
XLen = 20         'Tulen leveys X suunnassa
YLen = 30         'Tulen pituus Y suunnassa
XSize& = 1        'Pikselin koko X-suunnassa
YSize& = 1        'Pikselin koko Y-suunnassa
Rate = 1          'Kuinka usein uusia "hotspotteja" tehdn.
                  'Mit pienempi, sen useammin


xpos& = 0              'Tulen X-sijainti (jos -1 sitten tuli keskitetn)
ypos& = 199 - YLen     'Tulen Y-sijainti (jos -1 sitten tuli keskitetn)

Char$ = ""       'Tulen piirtomerkki (vain jos kytss Screenmode 0)






DIM Rand(512) AS LONG
DIM divide(1020) AS LONG



FOR i = 0 TO 512
  Rand(i) = RND * 9.5
NEXT

FOR i = 0 TO 1020
  divide(i) = i \ 4
NEXT










SCREEN Screenmode
IF Screenmode = 0 THEN XSize& = 1: YSize& = 1


  IF Screenmode = 13 THEN
    MaxColors = 255
    Screenwidth = 320
    Screenheight = 200
  END IF

  IF Screenmode = 0 THEN
    MaxColors = 8
    Screenwidth = 80
    Screenheight = 50
    WIDTH 80, 50
  END IF

  IF Screenmode = 2 THEN
    MaxColors = 2
    Screenwidth = 640
    Screenheight = 200
  END IF

  IF Screenmode = 7 THEN
    MaxColors = 8
    Screenwidth = 320
    Screenheight = 200
  END IF

  IF Screenmode = 9 THEN
    MaxColors = 15
    Screenwidth = 640
    Screenheight = 350
  END IF

  IF Screenmode = 10 THEN
    MaxColors = 4
    Screenwidth = 640
    Screenheight = 350
  END IF

  IF Screenmode = 11 THEN
    MaxColors = 2
    Screenwidth = 640
    Screenheight = 480
  END IF

  IF Screenmode = 12 THEN
    MaxColors = 15
    Screenwidth = 640
    Screenheight = 480
  END IF

Makefirepalette (MaxColors)     'Asetetaan paletti


Makefirepalette (MaxColors)



i = 254


FOR ii = 2 TO 20 STEP 2
  LOCATE ii - 1, 10
  COLOR i
  PRINT HiScoreName$(ii / 2); STRING$(16 - LEN(HiScoreName$(ii / 2)), " "); HiScore(ii / 2)
  i = i - 18
NEXT

COLOR 60
LOCATE 1, 2
PRINT "H"

LOCATE 3, 2
PRINT "I"

LOCATE 5, 2
PRINT "S"

LOCATE 7, 2
PRINT "C"

LOCATE 9, 2
PRINT "O"

LOCATE 11, 2
PRINT "R"

LOCATE 13, 2
PRINT "E"

LOCATE 15, 2
PRINT "S"

Smooth 8, 0, 16, 8 * 16, 1, 0, 0


IF ScorePos > 0 THEN
  LOCATE 2 * ScorePos - 1, 10
  COLOR 50
  PRINT "               "
  Name$ = ""
  DO
    k$ = INPUT$(1)
    IF k$ = CHR$(13) AND LEN(Name$) > 0 THEN EXIT DO
    IF k$ = CHR$(13) THEN k$ = ""
    IF k$ = CHR$(9) THEN k$ = ""
    IF k$ = CHR$(8) AND LEN(Name$) > 0 THEN Name$ = LEFT$(Name$, LEN(Name$) - 1)
    IF k$ = CHR$(8) THEN k$ = ""
    Name$ = Name$ + k$
    IF LEN(Name$) > 15 THEN Name$ = LEFT$(Name$, 15)
    LOCATE 2 * ScorePos - 1, 10
    COLOR 254
    PRINT Name$;
    COLOR 50
    PRINT " "
  LOOP
  HiScoreName$(ScorePos) = Name$
  i = 254
  FOR ii = 2 TO 20 STEP 2
    LOCATE ii - 1, 10
    COLOR i
    PRINT HiScoreName$(ii / 2); STRING$(16 - LEN(HiScoreName$(ii / 2)), " "); HiScore(ii / 2)
    i = i - 18
  NEXT
  LOCATE 2 * ScorePos - 1, 8
  COLOR 50
  PRINT ""
END IF

OPEN "THEBEST.DAT" FOR OUTPUT AS #1

FOR i = 1 TO 10
  PRINT #1, HiScore(i)
  PRINT #1, HiScoreName$(i)
NEXT
CLOSE #1
IF DMADone% THEN dummy = ResetDSP
WavPlay "hiscore.wav", 11025

IF XSize& <> 1 OR YSize& <> 1 THEN
  IF xpos& = -1 THEN xpos& = (Screenwidth / 2 - ((XLen * (XSize& + 1)) / 2)) / (XSize&)
  IF ypos& = -1 THEN ypos& = (Screenheight / 2 - ((YLen * (YSize& + 1)) / 2)) / (YSize&)
ELSE
  IF xpos& = -1 THEN xpos& = (Screenwidth / 2 - ((XLen / 2)))
  IF ypos& = -1 THEN ypos& = (Screenheight / 2 - ((YLen / 2)))
END IF








SCREEN Screenmode
IF Screenmode = 0 THEN XSize& = 1: YSize& = 1

Makefirepalette (MaxColors)     'Asetetaan paletti

IF XSize& <> 1 OR YSize& <> 1 THEN
  IF xpos& = -1 THEN xpos& = (Screenwidth / 2 - ((XLen * (XSize& + 1)) / 2)) / (XSize&)
  IF ypos& = -1 THEN ypos& = (Screenheight / 2 - ((YLen * (YSize& + 1)) / 2)) / (YSize&)
ELSE
  IF xpos& = -1 THEN xpos& = (Screenwidth / 2 - ((XLen / 2)))
  IF ypos& = -1 THEN ypos& = (Screenheight / 2 - ((YLen / 2)))
END IF


DIM Startbuf%(XLen, YLen)

RANDOMIZE TIMER

FOR i& = 0 TO XLen - 1
  IF RND * 5 > 4 THEN
    Startbuf%(i&, YLen) = 255
  ELSE
    Startbuf%(i&, YLen) = 0
  END IF
NEXT
IF Screenmode = 13 THEN DEF SEG = &HA000

DO
  q& = 0
  FOR y& = YLen TO 1 STEP -1
    FOR x& = 1 TO XLen - 1
      IF Startbuf%(x&, y&) > 0 OR Startbuf%(x& + 1, y&) > 0 OR Startbuf%(x& - 1, y&) > 0 THEN
        avg& = Startbuf%(x&, y&)
        avg& = avg& + Startbuf%(x&, y& - 1)     'Lasketaan 3 ymprivn
        avg& = avg& + Startbuf%(x& - 1, y&)     'pisteen vrikeskiarvo
        avg& = avg& + Startbuf%(x& + 1, y&)     'Esim:
      
                                                '
                                                '3
                                                '
                                                '234
                                                '
                                                '     ^
                                                '   x&,y&

        avg& = divide(INT(avg&))                'Haetaan tulos jakolaskutaulukosta
        IF avg& > 4 THEN avg& = avg& - Rand(q& MOD 512)
        IF avg& < 4 THEN avg& = 0
        Startbuf%(x&, y& - 1) = avg&
      END IF
    NEXT
  NEXT

  'Piirretn tuli

  IF Screenmode = 13 THEN
  FOR y& = YLen - 1 TO 1 STEP -1
    FOR i& = 0 TO XLen
      IF XSize& = 1 AND YSize& = 1 THEN
        POKE (((y& + ypos&) * YSize&) * 320 + ((i& + xpos&) * XSize&)), Startbuf%(i&, y&)
        GOTO Done13
      END IF
      IF XSize& = 2 AND YSize& = 2 THEN
        POKE (((y& + ypos&) * YSize&) * 320 + ((i& + xpos&) * XSize&)), Startbuf%(i&, y&)
        POKE (((y& + ypos&) * YSize&) * 320 + ((i& + xpos&) * XSize& + 1)), Startbuf%(i&, y&)
        POKE (((y& + ypos&) * YSize& + 1) * 320 + ((i& + xpos&) * XSize&)), Startbuf%(i&, y&)
        POKE (((y& + ypos&) * YSize& + 1) * 320 + ((i& + xpos&) * XSize& + 1)), Startbuf%(i&, y&)
        GOTO Done13
      END IF
      IF YSize& <> XSize& OR (XSize& > 2 AND YSize& > 2) THEN
        LINE ((i& + xpos&) * XSize&, (y& + ypos&) * YSize&)-((i& + xpos&) * XSize& + XSize& - 1, (y& + ypos&) * YSize& + YSize& - 1), Startbuf%(i&, y&), BF
      END IF
Done13:
    NEXT
  NEXT
  END IF

  IF Screenmode < 13 AND Screenmode > 0 THEN
  FOR y& = YLen - 1 TO 1 STEP -1
    FOR i& = 0 TO XLen
      IF Startbuf%(i&, y&) > 0 THEN
        IF XSize& = 1 AND YSize& = 1 THEN
          PSET ((i& + xpos&) * XSize&, (y& + ypos&) * YSize&), Startbuf%(i&, y&) \ 32
          GOTO Done7
        END IF
        IF YSize& <> XSize& OR (XSize& > 1 AND YSize& > 1) THEN
          LINE ((i& + xpos&) * XSize&, (y& + ypos&) * YSize&)-((i& + xpos&) * XSize& + XSize& - 1, (y& + ypos&) * YSize& + YSize& - 1), Startbuf%(i&, y&) \ 32, BF
        END IF
Done7:
      END IF
    NEXT
  NEXT
  END IF

  IF Screenmode = 0 THEN
  FOR y& = YLen - 1 TO 1 STEP -1
    FOR i& = 0 TO XLen
      IF Startbuf%(i&, y&) > 0 THEN
        LOCATE y& + ypos&, i& + xpos&
        COLOR Startbuf%(i&, y&) / 32
        PRINT Char$
      END IF
    NEXT
  NEXT
  END IF


  count = count + 1                           'Uusien "hotspottien" generointi
  IF count = Rate THEN
    count = 0
      FOR ii = 0 TO 20
        i = RND * XLen
        IF RND > .5 THEN
          Startbuf%(i, YLen) = 255
        ELSE
          Startbuf%(i, YLen) = 0
        END IF
    NEXT
  END IF

  GET (0, 199 - YLen)-(XLen, 199), Fire

  FOR ii = XLen * 2 TO 319 - XLen STEP XLen * 2
    PUT (ii, 199 - YLen), Fire, PSET
  NEXT

LOOP UNTIL INKEY$ <> ""
fade 0, 0, 0

END SUB

SUB Makefirepalette (MaxColors)

FOR x% = 1 TO MaxColors
  OUT &H3C8, x%
  OUT &H3C9, 63
  OUT &H3C9, 63
  OUT &H3C9, 63
NEXT


FOR x% = 0 TO (MaxColors \ 4) - 1
  OUT &H3C8, x%
  OUT &H3C9, x% * (63 / (MaxColors \ 4))
  OUT &H3C9, 0
  OUT &H3C9, 0

  OUT &H3C8, x% + (MaxColors \ 4)
  OUT &H3C9, 63
  OUT &H3C9, x% * (63 / (MaxColors \ 4))
  OUT &H3C9, 0

  OUT &H3C8, x% + ((MaxColors \ 4) * 2)
  OUT &H3C9, 63
  OUT &H3C9, 63
  OUT &H3C9, x% * (63 / (MaxColors \ 4))
NEXT x%

END SUB

SUB Makepalette
red! = 63
green! = 0
blue! = 0

FOR i = 63 TO 1 STEP -1
  OUT (&H3C8), i
  OUT (&H3C9), red!
  OUT (&H3C9), green!
  OUT (&H3C9), blue!
  IF red! > 0 THEN red! = red! - 1
  IF green! > 0 THEN green! = green! - 1
  IF blue! > 0 THEN blue! = blue! - 1
NEXT


red! = 0
green! = 63
blue! = 0

FOR i = 128 TO 64 STEP -1
  OUT (&H3C8), i
  OUT (&H3C9), red!
  OUT (&H3C9), green!
  OUT (&H3C9), blue!
  IF red! > 0 THEN red! = red! - 1
  IF green! > 0 THEN green! = green! - 1
  IF blue! > 0 THEN blue! = blue! - 1
NEXT


red! = 0
green! = 0
blue! = 63

FOR i = 192 TO 129 STEP -1
  OUT (&H3C8), i
  OUT (&H3C9), red!
  OUT (&H3C9), green!
  OUT (&H3C9), blue!
  IF red! > 0 THEN red! = red! - 1
  IF green! > 0 THEN green! = green! - 1
  IF blue! > 0 THEN blue! = blue! - 1
NEXT


red! = 63
green! = 63
blue! = 63

FOR i = 255 TO 193 STEP -1
  OUT (&H3C8), i
  OUT (&H3C9), red!
  OUT (&H3C9), green!
  OUT (&H3C9), blue!
  IF red! > 0 THEN red! = red! - 1
  IF green! > 0 THEN green! = green! - 1
  IF blue! > 0 THEN blue! = blue! - 1
NEXT
END SUB

FUNCTION ReadDAC%
' Reads a byte from the DAC.
WriteDSP &H20
ReadDAC% = ReadDSP%


END FUNCTION

FUNCTION ReadDSP%
' Reads a byte from the DSP
DO
LOOP UNTIL INP(Baseport% + 14) AND &H80
ReadDSP% = INP(Baseport% + 10)

END FUNCTION

FUNCTION ResetDSP%
' Resets the DSP
OUT Baseport% + 6, 1
FOR count% = 1 TO 4
   junk% = INP(Baseport% + 6)
NEXT
OUT Baseport% + 6, 0
IF INP(Baseport% + 14) AND &H80 = &H80 AND INP(Baseport% + 10) = &HAA THEN
   ResetDSP% = -1
ELSE
   ResetDSP% = 0
END IF

END FUNCTION

SUB Scroller (Text$, Col)
Text$ = LEFT$(Text$, 40)

DIM Scr(8 * LEN(Text$), 8) AS INTEGER
DIM Move(319 * 8) AS INTEGER

SCREEN 13: CLS
COLOR 1
LOCATE 1, 1: PRINT Text$
XLen = LEN(Text$) * 8

FOR y& = 0 TO 8
  FOR x& = 0 TO XLen
    Scr(x&, y&) = POINT(x&, y&)
  NEXT
NEXT
CLS

xpos = 0
ScrollCount = 0
YOffset = 0
ang! = .5


DO
  FOR i& = 96 TO 104
    IF Scr(xpos, i& - 96) = 1 THEN PSET (319, i& - YOffset), Col - ((i& - 96) * 7) ELSE PSET (319, i& - YOffset), 0
  NEXT
  GET (1, 96 - YOffset)-(319, 104 - YOffset), Move
  ang! = ang! + .015
  YOffset = SIN(ang!) * 60
  PUT (0, 96 - YOffset), Move, PSET
  LINE (0, 95 - YOffset)-(319, 95 - YOffset), 0
  LINE (0, 105 - YOffset)-(319, 105 - YOffset), 0
  xpos = xpos + 1
  IF xpos > XLen THEN ScrollCount = ScrollCount + 1: xpos = XLen
  IF ScrollCount > 319 THEN EXIT DO
  IF ScrollCount = 160 - XLen / 2 THEN SLEEP 2
LOOP UNTIL INKEY$ <> ""

END SUB

SUB ShowLogo
DEF SEG = &HA000
BLOAD "smash.dat", 0

END SUB

SUB Smooth (xpos&, ypos&, XLen, YLen, Times, Rate, Lowest)
DEF SEG = &HA000
done = 0
DO
  FOR y& = 0 TO YLen
    FOR x& = 0 TO XLen
      avg% = 0
      avg% = avg% + PEEK((y& + ypos& - 1) * 320 + (x& + xpos&))
      avg% = avg% + PEEK((y& + 1 + ypos&) * 320 + (x& + xpos&))
      avg% = avg% + PEEK((y& + ypos&) * 320 + (x& - 1 + xpos&))
      avg% = avg% + PEEK((y& + ypos&) * 320 + (x& + 1 + xpos&))
 
      avg% = avg% + PEEK((y& + ypos& - 1) * 320 + (x& + xpos& - 1))
      avg% = avg% + PEEK((y& + ypos& - 1) * 320 + (x& + xpos& + 1))
      avg% = avg% + PEEK((y& + ypos& + 1) * 320 + (x& + xpos& - 1))
      avg% = avg% + PEEK((y& + ypos& + 1) * 320 + (x& + xpos& + 1))
      avg% = avg% \ 8
      avg% = avg% - Rate
      IF avg% < Lowest THEN avg% = Lowest
      POKE ((y& + ypos&) * 320 + x& + xpos&), avg%
    NEXT
  NEXT
  done = done + 1
LOOP UNTIL done >= Times


END SUB

SUB SpeakerState (OnOff%)
' Turns speaker on or off.
IF OnOff% THEN WriteDSP &HD1 ELSE WriteDSP &HD3

END SUB

SUB TheEnd
IF DMADone% THEN dummy = ResetDSP
Makepalette
red! = 0
green! = 0
blue! = 45

FOR i = 63 TO 1 STEP -1
  OUT (&H3C8), i
  OUT (&H3C9), red!
  OUT (&H3C9), green!
  OUT (&H3C9), blue!
  IF red! > 0 THEN red! = red! - 1
  IF green! > 0 THEN green! = green! - 1
  IF blue! > 0 THEN blue! = blue! - 1
NEXT
ShowLogo

WavPlay "haha.wav", 11025
LINE (80, 50)-(240, 170), 128, B
LINE (81, 51)-(239, 169), 108, B
LINE (82, 52)-(238, 168), 88, B
LINE (83, 53)-(237, 167), 0, BF

COLOR 128
LOCATE 8, 12: PRINT " CONGRATULATIONS!"
COLOR 118
LOCATE 10, 12: PRINT "You have completed"
COLOR 108
LOCATE 11, 12: PRINT "the game. You got"
COLOR 98
LOCATE 12, 12: PRINT Score; "points."
IF Code = 0 THEN
  COLOR 88
  LOCATE 14, 12: PRINT "You didn't use"
  COLOR 78
  LOCATE 15, 12: PRINT "the cheat code."
ELSE
  COLOR 88
  LOCATE 14, 12: PRINT "You used"
  COLOR 78
  LOCATE 15, 12: PRINT "the cheat code."
END IF
COLOR 192
LOCATE 17, 12: PRINT "Have you tried"
LOCATE 18, 12: PRINT "making your own"
LOCATE 19, 12: PRINT "levels yet?"

DO: LOOP UNTIL INKEY$ <> ""

fade 0, 0, 0
HiScores (Score)
CLS
Makepalette

END SUB

DEFINT A-Z
SUB WavPlay (File$, Freq&)
IF DMADone% THEN EXIT SUB

WavFile = FREEFILE
OPEN File$ FOR BINARY AS #WavFile

GET #WavFile, 44, WavBuffer(0)
Length& = LOF(1) - 44
IF Length& > 32767 THEN Length& = 32767

DMAPlay VARSEG(WavBuffer(0)), VARPTR(WavBuffer(0)), Length&, Freq&

CLOSE #WavFile
END SUB

DEFSNG A-Z
SUB WriteDAC (byte%)
' Writes a byte to the DAC.
WriteDSP &H10
WriteDSP byte%

END SUB

SUB WriteDSP (byte%)
' Writes a byte to the DSP
DO
LOOP WHILE INP(Baseport% + 12) AND &H80
OUT Baseport% + 12, byte%

END SUB

