' Mini-Sokobanspiel

' (c) 2001 by Andreas Meile, CH-8242 Hofen SH

DECLARE FUNCTION FuehrNull$ (w%, l%)
DECLARE SUB AktualisiereZeit ()
DECLARE SUB AktualisiereZug ()
DECLARE SUB AktualisiereKisten ()
DECLARE SUB ZeigeCursor (x%, y%, el%, t$)
DECLARE SUB ZeichneRahmen (x1%, y1%, x2%, y2%, f%)
DECLARE SUB AktualisiereFeld (x%, y%)
DECLARE SUB RelSound (Freq%, dauer!)
DECLARE SUB SoundSlide (f1!, f2!, dauer!)
DECLARE SUB ZeichneLevel ()
DECLARE SUB FuehreWurmfutter (i%)
DECLARE SUB FuehreLaenge ()
DECLARE SUB FuehreSchluessel (n%, i%)
DECLARE SUB FuehreGeschwindigkeit ()
DECLARE SUB FuehreZeit (dt%)
DECLARE SUB ZeichneFeldchen (x%, y%)
DECLARE SUB GibSymbolAus (s%, x%, y%)
DECLARE SUB InitialisiereLevel ()
DECLARE SUB ZeichneStartWurm ()
DECLARE SUB LadeLevel ()
DECLARE SUB SpeichereLevel ()
DECLARE FUNCTION GenerierePasswort$ (n%)
DECLARE FUNCTION PruefePasswort% (pwd$)

' Auszug aus BMP_LIB
DECLARE SUB LadeBild (dn$, f%(), ind%)
DECLARE SUB LadePalette (dn$, p&(), ind%, mo%)
CONST PalCGA% = 0   ' fr SCREEN 1/2/7/8/9
CONST PalEGA% = 1   ' fr SCREEN 0/9
CONST PalVGA% = 2   ' fr SCREEN 11/12/13

DIM SHARED f%(15, 9), sh%(853), Lev%, soundEin%, pwd$, csr%(121)
DIM SHARED xPos%, yPos%, Zeit%, Zug%, kisten%
DIM pa&(15), plCheck%(6)

CONST MinSoundL! = 2.272728E-02
RANDOMIZE TIMER

' Grafik laden
LadePalette "shap000", pa&(), 0, PalCGA%
FOR i% = 0 TO 6
	LadeBild "shap" + FuehrNull$(i%, 3), sh%(), i% * 122
NEXT i%

SCREEN 7
LINE (0, 0)-(19, 19), 15, BF
LINE (4, 4)-(15, 15), 0, BF
GET (0, 0)-(19, 19), csr%

' PALETTE USING pa&

pwd$ = GenerierePasswort$(1)
soundEin% = -1
DO
	COLOR 7
	CLS
	LOCATE 3, 7
	COLOR 13
	PRINT "Sokoban - der Lagerarbeiter"
	LOCATE 4, 8
	COLOR 2
	PRINT "(c) 2001 by Andreas Meile"
	LOCATE 5, 9
	COLOR 4
	PRINT "e-Mail: ";
	COLOR 11
	PRINT "andreas@hofen.ch"
	LOCATE 6, 4
	COLOR 4
	PRINT "WWW: ";
	COLOR 11
	PRINT "http://www.hofen.ch/~andreas/"
	LOCATE 8, 11
	COLOR 14
	PRINT "Whle aus:"
	LOCATE 10, 11
	COLOR 9
	PRINT "F1";
	COLOR 6
	PRINT " Spiel"
	LOCATE 12, 11
	COLOR 9
	PRINT "F2";
	COLOR 6
	PRINT " Editor"
	LOCATE 14, 11
	COLOR 9
	PRINT "F3";
	COLOR 6
	PRINT " Anleitung"
	LOCATE 16, 11
	COLOR 9
	PRINT "F4";
	COLOR 6
	PRINT " Ende"

	DO
		DO
			tt$ = INKEY$
		LOOP WHILE tt$ = ""
		SELECT CASE tt$
		CASE CHR$(0) + ";"
			GOSUB Spielen
		CASE CHR$(0) + "<"
			GOSUB Editor
		CASE CHR$(0) + "="
			GOSUB Anleitung
		END SELECT
	LOOP UNTIL tt$ >= CHR$(0) + ";" AND tt$ <= CHR$(0) + ">"
LOOP UNTIL tt$ = CHR$(0) + ">"

SCREEN 0
WIDTH 80, 25
PRINT "Sokoban beendet."
END

' +-------------+
' | Leveleditor |
' +-------------+
Editor:
LOCATE 25, 1
COLOR 12
PRINT "F1";
COLOR 15
PRINT "=Hilfe"
LOCATE 23, 1
PRINT "E:";
el% = 0
PUT (16, 168), sh%, PSET
' Zu Beginn leerer Level
InitialisiereLevel
ZeichneLevel

cx% = 8
cy% = 5
hx% = cx%
hy% = cy%
ft% = 0
malenEin% = 0
Lev% = 1

DO
	ZeigeCursor 20 * cx%, 20 * cy%, f%(cx%, cy%), t$
	SELECT CASE t$
	CASE CHR$(0) + ";"
		' Hilfestellung
		ZeichneRahmen 6, 4, 31, 12, 12
		LOCATE 5, 7: COLOR 14: PRINT "Return";
		COLOR 7: PRINT "=Zeichnen";
		LOCATE 6, 7: COLOR 14: PRINT "Leertaste";
		COLOR 7: PRINT "=Element whlen";
		LOCATE 7, 7: COLOR 14: PRINT "M";
		COLOR 7: PRINT "=Malmodus ein/aus";
		LOCATE 8, 7: COLOR 14: PRINT "L";
		COLOR 7: PRINT "=Level laden";
		LOCATE 9, 7: COLOR 14: PRINT "S";
		COLOR 7: PRINT "=Level speichern";
		LOCATE 10, 7: COLOR 14: PRINT "Return";
		COLOR 7: PRINT "=Zeichnen";
		LOCATE 11, 7: COLOR 14: PRINT "Esc";
		COLOR 7: PRINT "=Ende";
		dummy$ = INPUT$(1)
		ZeichneLevel
	CASE CHR$(0) + "H"
		IF cy% > 1 THEN
			IF malenEin% THEN
				f%(cx%, cy%) = el%
				AktualisiereFeld cx%, cy%
			END IF
			cy% = cy% - 1
		END IF
	CASE CHR$(0) + "K"
		IF cx% > 1 THEN
			IF malenEin% THEN
				f%(cx%, cy%) = el%
				AktualisiereFeld cx%, cy%
			END IF
			cx% = cx% - 1
		END IF
	CASE CHR$(0) + "M"
		IF cx% < 14 THEN
			IF malenEin% THEN
				f%(cx%, cy%) = el%
				AktualisiereFeld cx%, cy%
			END IF
			cx% = cx% + 1
		END IF
	CASE CHR$(0) + "P"
		IF cy% < 8 THEN
			IF malenEin% THEN
				f%(cx%, cy%) = el%
				AktualisiereFeld cx%, cy%
			END IF
			cy% = cy% + 1
		END IF
	CASE CHR$(13)
		f%(cx%, cy%) = el%
		AktualisiereFeld cx%, cy%
	CASE "M", "m"
		malenEin% = NOT malenEin%
		LOCATE 22, 1
		COLOR 14
		IF malenEin% THEN
			PRINT "M";
		ELSE
			PRINT " ";
		END IF
	CASE " "
		ZeichneRahmen 4, 7, 23, 11, 3
		FOR i% = 0 TO 6
			PUT (34 + 20 * i%, 58), sh%(122 * i%), PSET
		NEXT i%
		DO
			ZeigeCursor 34 + 20 * el%, 58, el%, t2$
			SELECT CASE t2$
			CASE CHR$(0) + "K"
				el% = (el% + 6) MOD 7
			CASE CHR$(0) + "M"
				el% = (el% + 1) MOD 7
			END SELECT
		LOOP UNTIL t2$ = CHR$(13) OR t2$ = " "
		PUT (16, 168), sh%(122 * el%), PSET
		ZeichneLevel
	CASE "S", "s"
		' Plausibilittskontrolle
		FOR i% = 0 TO 6
			plCheck%(i%) = 0
		NEXT i%
		FOR y% = 1 TO 8
			FOR x% = 1 TO 14
				plCheck%(f%(x%, y%)) = plCheck%(f%(x%, y%)) + 1
			NEXT x%
		NEXT y%
		IF plCheck%(4) + plCheck%(6) = 1 AND plCheck%(1) = plCheck%(2) + plCheck%(6) THEN
			ZeichneRahmen 4, 5, 29, 8, 12
			LOCATE 6, 5: COLOR 14
			PRINT "Aktueller Level:";
			COLOR 15: PRINT Lev%;
			LOCATE 7, 5: COLOR 14
			INPUT "Speichern als:", Lev%
			SpeichereLevel
		ELSE
			ZeichneRahmen 5, 6, 27, 8, 14
			LOCATE 7, 6
			COLOR 12
			PRINT "Level nicht korrekt!";
			dummy$ = INPUT$(1)
		END IF
		ZeichneLevel
	CASE "L", "l"
		ZeichneRahmen 4, 5, 29, 8, 12
		LOCATE 6, 5: COLOR 14
		PRINT "Aktueller Level:";
		COLOR 15: PRINT Lev%;
		LOCATE 7, 5: COLOR 14
		INPUT "Lade Level:", Lev%
		LadeLevel
		ZeichneLevel
	END SELECT
LOOP UNTIL t$ = CHR$(27)
RETURN

' +-------+
' | Spiel |
' +-------+

' Start Spiel
Spielen:
DO
	COLOR 2, 0
	CLS
	LOCATE 10, 4
	PRINT "Geben Sie ein Passwort ein, um bei"
	LOCATE 11, 4
	PRINT "einem hheren Level zu starten"
	COLOR 11
	p% = 0
	DO
		LOCATE 13, 16
		PRINT pwd$;
		LINE (120 + 8 * p%, 102)-STEP(7, 1), 14, BF
		DO
			t$ = INKEY$
		LOOP WHILE t$ = ""
		LOCATE , , 0
		SELECT CASE t$
		CASE CHR$(0) + "K", CHR$(8)
			p% = (p% + 5) MOD 6
		CASE CHR$(0) + "M", " "
			p% = (p% + 1) MOD 6
		CASE "0" TO "9"
			MID$(pwd$, p% + 1) = t$
			p% = (p% + 1) MOD 6
		CASE "A" TO "Z", "a" TO "v"
			MID$(pwd$, p% + 1) = UCASE$(t$)
			p% = (p% + 1) MOD 6
		END SELECT
	LOOP UNTIL t$ = CHR$(13) OR t$ = CHR$(27)
	IF t$ = CHR$(27) THEN EXIT DO
	Lev% = PruefePasswort(pwd$)
	IF Lev% < 1 OR Lev% > 99 THEN
		Lev% = 1
		pwd$ = GenerierePasswort$(1)
	END IF
	InitialisiereLevel
	LadeLevel
	ZeichneLevel
	COLOR 14
	LOCATE 22, 1
	PRINT "L";
	COLOR 15
	PRINT FuehrNull$(Lev%, 3);
	COLOR 14
	LOCATE 23, 1
	PRINT "t--'--"; CHR$(34);
	LOCATE 24, 1
	PRINT "Z----";
	LOCATE 25, 1
	PRINT "K--";
	Zeit% = -1
	Zug% = -1
	AktualisiereZug
	AktualisiereKisten
	Drinbleib% = -1
	tn! = TIMER
	WHILE kisten% > 0 AND Drinbleib%
		IF TIMER >= tn! THEN
			tn! = tn! + 1!
			AktualisiereZeit
		END IF
		t$ = INKEY$
		IF t$ <> "" THEN
			Bewegen% = 0
			SELECT CASE t$
			CASE CHR$(0) + "H"
				sx% = 0: sy% = -1
				Bewegen% = -1
			CASE CHR$(0) + "K"
				sx% = -1: sy% = 0
				Bewegen% = -1
			CASE CHR$(0) + "M"
				sx% = 1: sy% = 0
				Bewegen% = -1
			CASE CHR$(0) + "P"
				sx% = 0: sy% = 1
				Bewegen% = -1
			CASE "S", "s"
				soundEin% = NOT soundEin%
			CASE CHR$(27)
				Drinbleib% = 0
			END SELECT
			IF Bewegen% THEN
				SELECT CASE f%(xPos% + sx%, yPos% + sy%) OR 2
				CASE 2      ' sei leer
					Gehen% = -1
					IF soundEin% THEN
						SOUND 250, .2
					END IF
				CASE 7      ' sei Wand
					Gehen% = 0
					IF soundEin% THEN
						SOUND 150, .4
					END IF
				CASE 3      ' sei Kiste
					IF (f%(xPos% + 2 * sx%, yPos% + 2 * sy%) OR 2) = 2 THEN
						IF soundEin% THEN
							FOR i% = 100 TO 150 STEP 5
								SOUND i%, .2
							NEXT i%
						END IF
						' Hinter der Kiste frei
						f%(xPos% + sx%, yPos% + sy%) = f%(xPos% + sx%, yPos% + sy%) AND -2
						IF f%(xPos% + sx%, yPos% + sy%) AND 2 THEN
							kisten% = kisten% + 1
						END IF
						f%(xPos% + 2 * sx%, yPos% + 2 * sy%) = f%(xPos% + 2 * sx%, yPos% + 2 * sy%) OR 1
						IF f%(xPos% + 2 * sx%, yPos% + 2 * sy%) AND 2 THEN
							kisten% = kisten% - 1
						END IF
						AktualisiereKisten
						AktualisiereFeld xPos% + 2 * sx%, yPos% + 2 * sy%
						Gehen% = -1
					ELSE
						IF soundEin% THEN
							FOR i% = 400 TO 100 STEP -20
								SOUND i%, .2
							NEXT i%
						END IF
						Gehen% = 0  ' Zu schwer!
					END IF
				END SELECT
				IF Gehen% THEN
					AktualisiereZug
					f%(xPos%, yPos%) = f%(xPos%, yPos%) AND -5
					AktualisiereFeld xPos%, yPos%
					xPos% = xPos% + sx%
					yPos% = yPos% + sy%
					f%(xPos%, yPos%) = f%(xPos%, yPos%) OR 4 ' sei Spielerfigur
					AktualisiereFeld xPos%, yPos%
				END IF
			END IF
		END IF
	WEND
	IF Drinbleib% THEN
		IF soundEin% THEN
			PLAY "mfo3t90l16ggafd8<b8>cc."
		END IF
		Lev% = Lev% + 1
		pwd$ = GenerierePasswort$(Lev%)
		ZeichneRahmen 5, 12, 36, 14, 12
		LOCATE 13, 6
		COLOR 11
		PRINT USING "Passwort fr Level ###: "; Lev%;
		COLOR 14
		PRINT pwd$;
		dummy$ = INPUT$(1)
	END IF
LOOP
RETURN

Anleitung:
Seite% = 1
DO
	COLOR 2, 0
	CLS
	PRINT "Sokoban - Seite"; Seite%; "von 3"
	COLOR 1
	PRINT STRING$(39, 205)
	COLOR 7
	SELECT CASE Seite%
	CASE 1
		COLOR 7
		PRINT
		PRINT "Sie sind Sokoban, der selbstndig tti-"
		PRINT "ge Lagerarbeiter. Ihre Aufgabe sind die"
		PRINT "verstreut herumliegenden Holzpaletten-"
		PRINT "kisten auf die mit einem grnen Kreuz"
		PRINT "markierten Lagerpltze zu verschieben."
		PRINT
		PRINT "Doch aufgepasst: Sie knnen die Kisten"
		PRINT "nur stossen, also nicht ziehen! Ein"
		PRINT "Verschieben in eine falsche Ecke kann"
		PRINT "also bedeuten, dass Sie den Auftrag"
		PRINT "nochmals von vorn beginnen mssen (Ab-"
		PRINT "bruch mit ";
		COLOR 4
		PRINT "Esc";
		COLOR 7
		PRINT "). Am Schluss erhalten Sie"
		PRINT "jeweils ein Passwort zum Weitermachen."
		PRINT "Ferner reichen Ihre krperlichen Krfte"
		PRINT "gerade aus, um jeweils eine der schwer"
		PRINT "beladenen Kisten auf einmal zu verschie-"
		PRINT "ben."
	CASE 2
		PRINT "Die Steuerung erfolgt mit den Pfeiltas-"
		PRINT "ten ";
		COLOR 4
		PRINT CHR$(26);
		COLOR 7
		PRINT ", ";
		COLOR 4
		PRINT CHR$(24);
		COLOR 7
		PRINT ", ";
		COLOR 4
		PRINT CHR$(27);
		COLOR 7
		PRINT " und ";
		COLOR 4
		PRINT CHR$(25);
		COLOR 7
		PRINT ". Mit ";
		COLOR 4
		PRINT "S";
		COLOR 7
		PRINT " kann der Ton"
		PRINT "jederzeit ein- und ausgeschaltet wer-"
		PRINT "den, ferner kann das Spiel jederzeit"
		PRINT "mit ";
		COLOR 4
		PRINT "Esc";
		COLOR 7
		PRINT " abgebrochen werden. Nach jedem"
		PRINT "gelsten Level erhalten Sie ein Pass-"
		PRINT "wort, um spter fortsetzen zu knnen."
		PRINT
		COLOR 11
		PRINT "Bedeutung der Anzeige"
		COLOR 14
		PRINT "L";
		COLOR 15
		PRINT "002";
		COLOR 7
		PRINT "    <= aktueller Level"
		COLOR 14
		PRINT "t";
		COLOR 15
		PRINT "01";
		COLOR 14
		PRINT "'";
		COLOR 15
		PRINT "43";
		COLOR 14
		PRINT CHR$(34);
		COLOR 7
		PRINT " <= verstrichene Zeit"
		COLOR 14
		PRINT "Z";
		COLOR 15
		PRINT "0027";
		COLOR 7
		PRINT "   <= bisher bentigte Spielzge"
		COLOR 14
		PRINT "K";
		COLOR 15
		PRINT "07";
		COLOR 7
		PRINT "     <= noch unplazierte Kisten"
		PRINT
		COLOR 11
		PRINT "         Symbole"
		COLOR 7
		LOCATE 19, 6
		PRINT "Sokoban                Kiste"
		PUT (18, 138), sh%(488), PSET
		PUT (202, 138), sh%(122), PSET
		LOCATE 22, 6
		PRINT "Zielplatz"
		PUT (18, 162), sh%(244), PSET
	CASE 3
		COLOR 11
		PRINT "Taktische Tips"
		COLOR 7
		PRINT
		PRINT "- Vermeiden Sie stets 4er-Block-Anhu-"
		PRINT "  fungen"
		FOR y% = 0 TO 1
			FOR x% = 0 TO 7
				IF x% MOD 3 <> 2 THEN
					PUT (40 + 20 * x%, 52 + 20 * y%), sh%(122 - 488 * (y% = 1 AND x% > 3)), PSET
				END IF
			NEXT x%
		NEXT y%
		LINE (37, 50)-(202, 93), 10
		LINE (37, 93)-(202, 50), 10
		LOCATE 13, 1
		PRINT "- Ebenso Anhufungen mit kleinen Ein-"
		PRINT "  schlssen"
		FOR y% = 0 TO 2
			FOR x% = 0 TO 2
				PUT (40 + 20 * x%, 118 + 20 * y%), sh%(122 + 122 * (x% = 1 AND y% = 1) - 488 * (y% = 2)), PSET
			NEXT x%
		NEXT y%
		LINE (37, 115)-(102, 180), 10
		LINE (37, 180)-(102, 115), 10
	END SELECT
	LOCATE 24, 1
	COLOR 1
	PRINT STRING$(39, 205);
	LOCATE 25, 1
	COLOR 4: PRINT "Bild"; CHR$(24);
	COLOR 2: PRINT "/";
	COLOR 4: PRINT "Bild"; CHR$(25);
	COLOR 2: PRINT " Blttern ";
	COLOR 4: PRINT "Esc";
	COLOR 2: PRINT " Verlassen";
	DO
		t$ = INKEY$
	LOOP WHILE t$ = ""
	SELECT CASE t$
	CASE CHR$(0) + "H", CHR$(0) + "I"
		Seite% = (Seite% + 1) MOD 3 + 1
	CASE CHR$(0) + "P", CHR$(0) + "Q"
		Seite% = Seite% MOD 3 + 1
	CASE CHR$(0) + "G"
		Seite% = 1
	CASE CHR$(0) + "O"
		Seite% = 3
	END SELECT
LOOP UNTIL t$ = CHR$(27)
RETURN

SUB AktualisiereFeld (x%, y%)
	PUT (20 * x%, 20 * y%), sh%(122 * f%(x%, y%)), PSET
END SUB

SUB AktualisiereKisten
	LOCATE 25, 2
	COLOR 15
	PRINT FuehrNull$(kisten%, 2);
END SUB

SUB AktualisiereZeit
	Zeit% = Zeit% + 1
	LOCATE 23, 2
	COLOR 15
	PRINT FuehrNull$(Zeit% \ 60, 2);
	LOCATE , 5
	PRINT FuehrNull$(Zeit% MOD 60, 2);
END SUB

SUB AktualisiereZug
	Zug% = Zug% + 1
	LOCATE 24, 2
	COLOR 15
	PRINT FuehrNull$(Zug%, 4);
END SUB

SUB FuehreZeit (dt%)
	Zeit% = Zeit% + dt%
	LOCATE 25, 6
	IF Zeit% <= 10 THEN
		COLOR 12, 0
		IF soundEin% AND dt% < 0 THEN
			SOUND 2637, 1.5
			SOUND 2093, 2!
		END IF
	ELSE
		COLOR 15, 0
	END IF
	PRINT FuehrNull$(Zeit% \ 60, 2); ":"; FuehrNull$(Zeit% MOD 60, 2);
END SUB

' String mit fhrenden Nullen bilden
FUNCTION FuehrNull$ (w%, a%)
	h$ = MID$(STR$(w%), 2)
	FuehrNull$ = STRING$(a% - LEN(h$), "0") + h$
END FUNCTION

FUNCTION GenerierePasswort$ (n%)
	LevCod& = CLNG(n%) + 256& * (CLNG(n%) * 3177605 + 2190087 AND 4194303)
	co2& = 0&
	FOR i% = 1 TO 5
		co2& = 64& * co2& + ((LevCod& AND 63&) * 17& + 23& AND 63&)
		LevCod& = LevCod& \ 64&
	NEXT i%
	pw$ = ""
	FOR i% = 1 TO 6
		c% = CINT(co2& AND 31&) * 19 + 13 AND 31
		IF c% < 10 THEN
			pw$ = CHR$(48 + c%) + pw$
		ELSE
			pw$ = CHR$(55 + c%) + pw$
		END IF
		co2& = co2& \ 32&
	NEXT i%
	GenerierePasswort$ = pw$
END FUNCTION

SUB InitialisiereLevel
	' Level initialisieren: Alles lschen
	FOR y% = 0 TO 9
		FOR x% = 0 TO 15
			f%(x%, y%) = 5
		NEXT x%
	NEXT y%
	f%(8, 5) = 4
END SUB

SUB LadeBild (dn$, f%(), ind%)
	OPEN dn$ + ".BMP" FOR INPUT AS 1
	CLOSE 1
	OPEN dn$ + ".BMP" FOR BINARY AS 1
	k$ = INPUT$(2, 1)
	IF k$ <> "BM" THEN
		PRINT "Kein gltiges Windows Bitmap Bild!"
		ERROR 5
	END IF
	SEEK 1, 11&
	basOf& = CVL(INPUT$(4, 1)) + 1&  ' ab hier beginnen die Nutzdaten
	SEEK 1, 19&
	xb& = CVL(INPUT$(4, 1))  ' Bildgrsse
	yb& = CVL(INPUT$(4, 1))
	anzBpl% = CVI(INPUT$(2, 1))
	IF anzBpl% <> 1 THEN
		PRINT "Bildformat einer knftigen Windowsversion"
		ERROR 5
	END IF
	bpp% = CVI(INPUT$(2, 1))
	komp& = CVL(INPUT$(4, 1))
	IF komp& <> 0& THEN
		PRINT "Komprimierung nicht untersttzt"
		ERROR 5
	END IF
	' Start der Verarbeitung
	br& = (xb& * CLNG(bpp%) + 31& AND -32&) \ 8&
	IF bpp% = 8 THEN
		f%(ind%) = 8 * CINT(xb&)
	ELSE
		f%(ind%) = CINT(xb&)
	END IF
	f%(ind% + 1) = CINT(yb&)
	ind% = ind% + 2
	SELECT CASE bpp%
	CASE 1, 8
		IF bpp% = 1 THEN
			b% = CINT((xb& + 7&) \ 8&)
		ELSE
			b% = CINT(xb&)
		END IF
		Pu$ = ""
		FOR y& = basOf& + br& * (yb& - 1&) TO basOf& STEP -br&
			SEEK 1, y&
			FOR x% = 1 TO b%
				Pu$ = Pu$ + INPUT$(1, 1)
				IF LEN(Pu$) = 2 THEN
					f%(ind%) = CVI(Pu$)
					ind% = ind% + 1
					Pu$ = ""
				END IF
			NEXT x%
		NEXT y&
		IF Pu$ <> "" THEN
			f%(ind%) = CVI(Pu$ + " ")
			ind% = ind% + 1
		END IF
	CASE 4
		DIM h%(3)
		FOR i% = 0 TO 3
			h%(i%) = 0
		NEXT i%
		b% = CINT(br&) \ 4
		pu1$ = SPACE$(4 * b%)
		FOR y& = basOf& + br& * (yb& - 1&) TO basOf& STEP -br&
			SEEK 1, y&
			FOR x1% = 1 TO b%
				FOR x2% = 1 TO 4
					z% = ASC(INPUT$(1, 1))
					FOR x3% = 0 TO 3
						h%(x3%) = 4 * h%(x3%) + (z% AND 1) + (z% AND 16) \ 8
						z% = z% \ 2
					NEXT x3%
				NEXT x2%
				FOR i% = 0 TO 3
					MID$(pu1$, x1% + b% * i%) = CHR$(h%(i%))
					h%(i%) = 0
				NEXT i%
			NEXT x1%
			FOR i% = 1 TO LEN(pu1$) STEP 2
				f%(ind%) = CVI(MID$(pu1$, i%, 2))
				ind% = ind% + 1
			NEXT i%
		NEXT y&
	CASE 24
		PRINT "Echtfarb (True Color) nicht mglich"
		ERROR 5
	CASE ELSE
		PRINT "Unbekannte Bildtiefe"
		ERROR 5
	END SELECT
	CLOSE 1
END SUB

SUB LadeLevel
	OPEN "level" + FuehrNull$(Lev%, 2) + ".dat" FOR INPUT AS 1
	CLOSE 1
	OPEN "level" + FuehrNull$(Lev%, 2) + ".dat" FOR BINARY AS 1
	k$ = INPUT$(4, 1)
	IF k$ <> "SoKo" THEN
		' Nicht Sokoban-Leveldatei
		STOP
	END IF
	FOR y% = 1 TO 7 STEP 2
		FOR x% = 1 TO 14
			IF y% < 7 OR x% > 3 THEN
				h% = ASC(INPUT$(1, 1))
				f%(x%, y%) = h% AND 15
				f%(x%, y% + 1) = h% \ 16
			END IF
		NEXT x%
	NEXT y%
	CLOSE 1
END SUB

SUB LadePalette (dn$, p&(), ind%, mo%)
	OPEN dn$ + ".BMP" FOR INPUT AS 1
	CLOSE 1
	OPEN dn$ + ".BMP" FOR BINARY AS 1
	k$ = INPUT$(2, 1)
	IF k$ <> "BM" THEN
		PRINT "Kein gltiges Windows Bitmap Bild!"
		ERROR 5
	END IF
	SEEK 1, 15&
	palOf& = CVL(INPUT$(4, 1)) + 15&   ' ab hier beginnen die Farbeintrge
	SEEK 1, 27&
	anzBpl% = CVI(INPUT$(2, 1))
	IF anzBpl% <> 1 THEN
		PRINT "Bildformat einer knftigen Windowsversion"
		ERROR 5
	END IF
	bpp% = CVI(INPUT$(2, 1))
	IF bpp% > 12 THEN
		PRINT "Echtfarb verwendet keine Farbpalette"
		ERROR 5
	END IF
	' Start der Verarbeitung
	aF% = 1
	FOR i% = 1 TO bpp%
		aF% = aF% * 2
	NEXT i%
	IF mo% = PalVlf% THEN
		' verlustfreier Spezialmodus, der keinem SCREEN gehrt
		' liest gesamter RGBQUAD ein
		SEEK 1, palOf&
		FOR i% = 1 TO aF&
			p&(ind%) = CVL(INPUT$(4, 1))
			ind% = ind% + 1
		NEXT i%
	ELSE
		FOR i% = 1 TO aF%
			SEEK 1, palOf&
			b% = ASC(INPUT$(1, 1))
			g% = ASC(INPUT$(1, 1))
			r% = ASC(INPUT$(1, 1))
			SELECT CASE mo%
			CASE PalCGA%  ' CGA-Palette von SCREEN 1/2/7/8
				Cga% = (r% AND 128) \ 32 + (g% AND 128) \ 64 + (b% AND 128) \ 128
				' Selektion, ob hellerer oder dnklerer Farbton darstellen
				h% = (r% AND 127) + (g% AND 127) + (b% AND 127) - 192
				p&(ind%) = CLNG(Cga% - 8 * (h% > 0))
				IF p&(ind%) = 4 AND g% > 80 THEN
					p&(ind%) = 6   ' Spezialfall Orange
				END IF
			CASE PalEGA%  ' EGA-Palette von SCREEN 0/9
				p&(ind%) = CLNG((r% AND 64) \ 2 + (r% AND 128) \ 32 + (g% AND 64) \ 4 + (g% AND 128) \ 64 + (b% AND 64) \ 8 + (b% AND 128) \ 128)
			CASE PalVGA%  ' VGA-Palette von SCREEN 11/12/13
				p&(ind%) = CLNG(r% AND 252) \ 4& + CLNG(g% AND 252) * 64& + CLNG(b% AND 252) * 16384&
			CASE ELSE
				ERROR 5
			END SELECT
			palOf& = palOf& + 4&
			ind% = ind% + 1
		NEXT i%
	END IF
	CLOSE 1
END SUB

FUNCTION PruefePasswort% (pwd$)
	co1& = 0&
	FOR i% = 1 TO 6
		c% = ASC(MID$(pwd$, i%, 1)) - 48
		IF c% > 10 THEN
			c% = c% - 7
		END IF
		co1& = 32& * co1& + CLNG(c% * 27 + 1 AND 31)
	NEXT i%
	cod& = 0&
	FOR i% = 1 TO 5
		cod& = 64& * cod& + ((co1& AND 63&) * 49& + 25& AND 63&)
		co1& = co1& \ 64&
	NEXT i%
	n% = CINT(cod& AND 255&)
	LevCod& = CLNG(n%) + 256& * (CLNG(n%) * 3177605 + 2190087 AND 4194303)
	IF cod& = LevCod& THEN
		PruefePasswort% = n%
	ELSE
		PruefePasswort% = -1    ' ungltiges Levelpasswort
	END IF
END FUNCTION

SUB SpeichereLevel
	OPEN "level" + FuehrNull$(Lev%, 2) + ".dat" FOR OUTPUT AS 1
	PRINT #1, "SoKo";
	FOR y% = 1 TO 7 STEP 2
		FOR x% = 1 TO 14
			IF y% < 7 OR x% > 3 THEN
				PRINT #1, CHR$(f%(x%, y%) + 16 * f%(x%, y% + 1));
			END IF
		NEXT x%
	NEXT y%
	CLOSE 1
END SUB

SUB ZeichneLevel
	kisten% = 0
	FOR y% = 0 TO 9
		FOR x% = 0 TO 15
			IF y% < 8 OR x% > 2 THEN
				AktualisiereFeld x%, y%
				IF (f%(x%, y%) OR 2) = 6 THEN
					xPos% = x%
					yPos% = y%
				ELSEIF f%(x%, y%) = 1 THEN
					kisten% = kisten% + 1
				END IF
			END IF
		NEXT x%
	NEXT y%
END SUB

SUB ZeichneRahmen (x1%, y1%, x2%, y2%, f%)
	LOCATE y1%, x1%
	COLOR f%
	PRINT ""; STRING$(x2% - x1% - 1, 205); "";
	FOR y% = y1% + 1 TO y2% - 1
		LOCATE y%, x1%
		PRINT ""; SPACE$(x2% - x1% - 1); "";
	NEXT y%
	LOCATE y2%, x1%
	PRINT ""; STRING$(x2% - x1% - 1, 205); "";
END SUB

SUB ZeigeCursor (x%, y%, el%, t$)
	PUT (x%, y%), csr%, OR
	csEin% = -1
	nB! = TIMER + .5
	DO
		t$ = INKEY$
		IF TIMER > nB! THEN
			IF csEin% THEN
				PUT (x%, y%), sh%(122 * el%), PSET
			ELSE
				PUT (x%, y%), csr%, OR
			END IF
			csEin% = NOT csEin%
			nB! = nB! + .5
		END IF
	LOOP WHILE t$ = ""
	IF csEin% THEN
		PUT (x%, y%), sh%(122 * el%), PSET
	END IF
END SUB

